package ONVIF::PTZ::Types::AudioSourceConfigurationOptions;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %InputTokensAvailable_of :ATTR(:get<InputTokensAvailable>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        InputTokensAvailable
        Extension

    ) ],
    {
        'InputTokensAvailable' => \%InputTokensAvailable_of,
        'Extension' => \%Extension_of,
    },
    {
        'InputTokensAvailable' => 'ONVIF::PTZ::Types::ReferenceToken',
        'Extension' => 'ONVIF::PTZ::Types::AudioSourceOptionsExtension',
    },
    {

        'InputTokensAvailable' => 'InputTokensAvailable',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::AudioSourceConfigurationOptions

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AudioSourceConfigurationOptions from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * InputTokensAvailable


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::AudioSourceConfigurationOptions
   InputTokensAvailable => $some_value, # ReferenceToken
   Extension =>  { # ONVIF::PTZ::Types::AudioSourceOptionsExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

