/* This file is part of Zanshin

   Copyright 2014 Kevin Ottens <ervin@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License or (at your option) version 3 or any later version
   accepted by the membership of KDE e.V. (or its successor approved
   by the membership of KDE e.V.), which shall act as a proxy
   defined in Section 14 of version 3 of the license.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
   USA.
*/

#ifndef TESTLIB_AKONADIFAKEMONITOR_H
#define TESTLIB_AKONADIFAKEMONITOR_H

#include "akonadi/akonadimonitorinterface.h"

namespace Testlib {

class AkonadiFakeMonitor : public Akonadi::MonitorInterface
{
    Q_OBJECT
public:
    typedef QSharedPointer<AkonadiFakeMonitor> Ptr;

    explicit AkonadiFakeMonitor(QObject *parent = Q_NULLPTR);

public slots:
    void addCollection(const Akonadi::Collection &collection);
    void removeCollection(const Akonadi::Collection &collection);
    void changeCollection(const Akonadi::Collection &collection);
    void changeCollectionSelection(const Akonadi::Collection &collection);

    void addItem(const Akonadi::Item &item);
    void removeItem(const Akonadi::Item &item);
    void changeItem(const Akonadi::Item &item);
    void moveItem(const Akonadi::Item &item);

    void addTag(const Akonadi::Tag &tag);
    void removeTag(const Akonadi::Tag &tag);
    void changeTag(const Akonadi::Tag &tag);
};

}

#endif // TESTLIB_AKONADIFAKEMONITOR_H
