/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name:     floate.h
 * Abstract:        include file for "floating-extension" word set
 */

#ifdef DECLARE_WORDS
#	ifdef PROTOTYPES
#		undef PROTOTYPES
#	endif
#	undef __FLOATE_H__
#else
#	ifndef PROTOTYPES
#		define PROTOTYPES
#	endif
#endif

#ifndef __FLOATE_H__
#define __FLOATE_H__

#include "yforth.h"
#include "macro.h"

/**************************************************************************/
/* PROTOTYPES *************************************************************/
/**************************************************************************/

code(d_f_store,                     "df!",                  0)
code(d_f_fetch,                     "df@",                  0)
code(align,                         "dfalign",              0)
code(aligned,                       "dfaligned",            0)
code(d_float_plus,                  "dfloat+",              0)
code(d_floats,                      "dfloats",              0)
code(f_star_star,                   "f**",                  0)
code(f_dot,                         "f.",                   0)
code(f_abs,                         "fabs",                 0)
code(f_a_cos,                       "facos",                0)
code(f_a_cosh,                      "facosh",               0)
code(f_a_log,                       "falog",                0)
code(f_a_sin,                       "fasin",                0)
code(f_a_sinh,                      "fasinh",               0)
code(f_a_tan,                       "fatan",                0)
code(f_a_tan2,                      "fatan2",               0)
code(f_a_tanh,                      "fatanh",               0)
code(f_cos,                         "fcos",                 0)
code(f_cosh,                        "fcosh",                0)
code(f_e_dot,                       "fe.",                  0)
code(f_exp,                         "fexp",                 0)
code(f_exp_m_one,                   "fexpm1",               0)
code(f_ln,                          "fln",                  0)
code(f_ln_p_one,                    "flnp1",                0)
code(f_log,                         "flog",                 0)
code(f_s_dot,                       "fs.",                  0)
code(f_sin,                         "fsin",                 0)
code(f_sin_cos,                     "fsincos",              0)
code(f_sinh,                        "fsinh",                0)
code(f_sqrt,                        "fsqrt",                0)
code(f_tan,                         "ftan",                 0)
code(f_tanh,                        "ftanh",                0)
code(f_proximate,                   "f~",                   0)
code(precision,                     "precision",            0)
code(set_precision,                 "set-precision",        0)
code(s_f_store,                     "sf!",                  0)
code(s_f_fetch,                     "sf@",                  0)
code(align,                         "sfalign",              0)
code(aligned,                       "sfaligned",            0)
code(s_float_plus,                	"sfloat+",              0)
code(s_floats,                      "sfloats",              0)

#ifdef PROTOTYPES

#endif

#endif

