/*
 *========================================================================
 * $Id: startup.c 208 2004-02-20 14:55:00Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 *  wulfstat_startup inherits the parsed command line and the does the
 * derived bookkeeping and initialization.  In particular it 
 *   a) allocates space for the important vectors and structures ;
 *   b) opens sockets to the list of hosts in hostfile (if possible);
 *   c) sends baseline init to all of those xmlsysd's.  This needs to
 * be done in startup because eventually the init process will be used to
 * mask the subset of all fields actually needed to generate the wulfstat
 * results (only);
 *   d) delay one second, and then pass control on to wulfstat_work for
 * an infinite loop of updates.  The one second will allow reasonably
 * accurate rates to be displayed from the beginning.
 *========================================================================
 */

#include "wulfstat.h"

void startup()
{

 /* loop index */
 int i;


 /* length of io buffer in use */
 int buflen,readcnt;

 /* pointer to return from xmltract */
 char *xpval;

 /*
  * This sets up ncurses, but unless I implement debugging output going
  * into a log file instead of stdout (a moderately massive rewrite)
  * we can only use ncurses if not verbose.  ncurses is pretty much
  * all or nothing and doesn't "like" freeform error messages.
  */
 if((verbose == D_ALL) || (verbose == D_STARTUP)){
   fprintf(OUTFP,"D_STARTUP: Setting up curses screen.  Use -v %d to focus.\n",D_STARTUP);
 }

 start_screen();

 if((verbose == D_ALL) || (verbose == D_STARTUP)){
   wprintw(debugpad,"D_STARTUP: Starting startup().  Use -v %d to focus.\n",D_STARTUP);
   wrefresh(debugpad);
 }

 /*
  * Allocate space for fields[][] (for parser). This is needed for
  * sending commands to daemon.  Note that for many purposes we prefer
  * to use our own general purpose parser rather than deal with fscanf()
  * and having to match types and whitespace and odd separators.
 command = (char *) malloc((size_t) (K*sizeof(char)));
 fields = (char **) malloc((size_t) (MAXFIELDNUMBER*sizeof(char*)));
 for(i = 0;i < MAXFIELDNUMBER;i++) {
   fields[i] = (char *) malloc((size_t)(K*sizeof(char)));
 }
  */

 /*
  * XML setup.
  * I like keeping blanks in the XML that is parsed and printed if I'm
  * going to read it.  One has to initialize the xpath parser as
  * well.
  */
 LIBXML_TEST_VERSION
 xmlKeepBlanksDefault(0);
 xmlXPathInit();

 allocate_hostlists();

 /*
  * Read in the xml wulfhost file.
  */
 if((verbose == D_ALL) || (verbose == D_STARTUP)){
   wprintw(debugpad,"D_STARTUP: Read the hostfile.");
   wrefresh(debugpad);
 }
 numhosts = read_wulfhosts(hostfile);

 /*
  * We have to set the DEFAULT state here so that init_host_values()
  * call below can Do The Right Thing.
  */
 set_display_dctl_state(hostlist);

 /*
  * This can't be done until numhosts is defined
  */
 start_displaypad();


 /*
  * Establish a connection to all hosts (if possible).  The threaded
  * connection loop resets the daemon and initializes all host values
  * according to the current dctl state.
  */
 if((verbose == D_ALL) || (verbose == D_STARTUP)){
   wprintw(debugpad,"D_STARTUP: Connect to the hosts in hostlist = %0x.\n",hostlist);
   wprintw(debugpad,"D_STARTUP: hostlist->head = %0x\n",hostlist->head);
   wrefresh(debugpad);
 }
 connectlist.hostlist = hostlist;
 connectlist.connect_delay = connect_delay;
 pthread_create(&connecttid,NULL,(void*)connect_to_all_hosts,&connectlist);

 if((verbose == D_ALL) || (verbose == D_STARTUP)){
   wprintw(debugpad,"D_STARTUP: All done with startup().\n");
   wrefresh(debugpad);
 }

}
