/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Date;

public class WDClock
extends Applet
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    int xsize;
    int ysize;
    int H_in = 0;
    int M_in = 0;
    int S_in = 0;
    Graphics2D backg;
    BufferedImage bg;
    Font font;
    int fontsize;
    String fontname;
    int edit = 0;
    int clock_type = 12;
    int uren;
    int minuten;
    int seconden;
    Color displaycolor;
    Color backgroundcolor;
    int alpha = -1;
    boolean user_modify = true;

    public void init() {
        String string = this.getParameter("user_modify");
        if (string != null && string.length() != 0 && (string.equals("0") || string.equalsIgnoreCase("no"))) {
            this.user_modify = false;
        }
        this.displaycolor = this.colorDecodeParam("displaycolor", Color.red);
        this.backgroundcolor = this.colorDecodeParam("backgroundcolor", Color.white);
        Dimension dimension = this.getSize();
        this.ysize = dimension.height;
        this.xsize = dimension.width;
        this.bg = new BufferedImage(this.xsize, this.ysize, 2);
        this.backg = (Graphics2D)this.bg.getGraphics();
        this.font = this.FitFont(this.backg, "Helvetica", 180);
        if (this.user_modify) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.addKeyListener(this);
        }
        this.getTime();
        this.uren = this.H_in;
        this.minuten = this.M_in;
        this.seconden = this.S_in;
        this.prepaint();
    }

    public void setApplet(String string, int n) {
        if (string.equals("H")) {
            this.setTime(0, n);
        } else if (string.equals("M")) {
            this.setTime(1, n);
        } else if (string.equals("S")) {
            this.setTime(2, n);
        }
    }

    public Font FitFont(Graphics graphics, String string, int n) {
        this.fontsize = n;
        this.fontname = string;
        String string2 = this.getParameter("clock_type");
        if (string2 != null && string2.equals("24")) {
            this.clock_type = 24;
        }
        if ((string2 = this.getParameter("fontsize")) != null) {
            try {
                this.fontsize = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                System.out.println("could not parse fontsize " + string2);
            }
        }
        if ((string2 = this.getParameter("font")) != null) {
            try {
                this.fontname = string2;
            }
            catch (Exception exception) {
                System.out.println("could nol load font" + string2);
            }
        }
        this.font = new Font(this.fontname, 1, this.fontsize);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        if (fontMetrics.stringWidth("00:00:00") > this.xsize) {
            boolean bl = true;
            while (this.fontsize > 4 && bl) {
                --this.fontsize;
                this.font = new Font(this.fontname, 1, this.fontsize);
                fontMetrics = graphics.getFontMetrics(this.font);
                if (fontMetrics.stringWidth("00:00:00") >= this.xsize) continue;
                bl = false;
            }
            System.out.println("xsize (" + this.xsize + ") of applet too small...adjusting fontsize to " + this.fontsize);
        }
        return this.font;
    }

    public Color MakeTransparent(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public Color colorDecodeParam(String string, Color color) {
        String string2 = this.getParameter(string);
        if (string2 != null && string2.length() != 0) {
            try {
                color = Color.decode(string2);
            }
            catch (Exception exception) {
                System.out.println("don't know color " + string2 + " ... setting to default");
            }
        }
        if ((string2 = this.getParameter("alpha")) != null && string2.length() != 0) {
            try {
                this.alpha = Integer.parseInt(string2);
                color = this.MakeTransparent(color, this.alpha);
            }
            catch (Exception exception) {
                System.out.println("could not parse alpha color " + string2);
            }
        }
        return color;
    }

    public String MakeTimeString(int n, int n2, int n3) {
        String string = "";
        String string2 = "";
        String string3 = "";
        string = n > 9 ? "" + n + "" : "0" + n;
        string2 = n2 > 9 ? "" + n2 + "" : "0" + n2;
        string3 = n3 > 9 ? "" + n3 + "" : "0" + n3;
        return string + ":" + string2 + ":" + string3;
    }

    public void getTime() {
        boolean bl = true;
        String string = this.getParameter("use_system_time");
        if (string != null && string.length() != 0 && (string.equals("1") || string.equalsIgnoreCase("yes"))) {
            Date date = new Date();
            this.S_in = date.getSeconds();
            this.M_in = date.getMinutes();
            this.H_in = date.getHours();
            bl = false;
        }
        if (bl) {
            string = this.getParameter("hours");
            this.H_in = string != null && string.length() != 0 ? Integer.parseInt(string) : (int)Math.round((double)this.clock_type * Math.random());
            string = this.getParameter("minutes");
            this.M_in = string != null && string.length() != 0 ? Integer.parseInt(string) : (int)Math.round(59.0 * Math.random());
            string = this.getParameter("seconds");
            this.S_in = string != null && string.length() != 0 ? Integer.parseInt(string) : (int)Math.round(59.0 * Math.random());
            if (this.H_in > this.clock_type) {
                this.H_in -= this.clock_type;
            }
            if (this.H_in > this.clock_type || this.H_in < 0) {
                System.out.println("hours param " + this.H_in + " is not correct");
            }
            if (this.M_in > 60 || this.M_in < 0) {
                System.out.println("minutes param " + this.M_in + " is not correct");
            }
            if (this.S_in > 60 || this.S_in < 0) {
                System.out.println("seconds param " + this.S_in + " is not correct");
            }
        }
    }

    public String readApplet() {
        return this.uren + ":" + this.minuten + ":" + this.seconden + "," + this.H_in + ":" + this.M_in + ":" + this.S_in;
    }

    public void prepaint() {
        this.backg.setColor(this.backgroundcolor);
        this.backg.fillRect(0, 0, this.xsize, this.ysize);
        this.backg.setFont(this.font);
        this.backg.setColor(this.displaycolor);
        this.backg.drawString(this.MakeTimeString(this.uren, this.minuten, this.seconden), 0, this.ysize);
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawImage((Image)this.bg, 0, 0, this);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        this.prepaint();
        this.paintComponent(graphics);
    }

    public void run() {
    }

    public void start() {
    }

    public void restart() {
        this.getTime();
        this.uren = this.H_in;
        this.minuten = this.M_in;
        this.seconden = this.S_in;
        this.repaint();
    }

    public void stop() {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getX() > 0 && mouseEvent.getX() < this.xsize / 3) {
            this.edit = 0;
        } else if (mouseEvent.getX() > this.xsize / 3 && mouseEvent.getX() < 2 * this.xsize / 3) {
            this.edit = 1;
        } else if (mouseEvent.getX() > 2 * this.xsize / 3 && mouseEvent.getX() < this.xsize) {
            this.edit = 2;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.edit = -1;
        if (mouseEvent.getX() > 0 && mouseEvent.getX() < this.xsize / 3) {
            this.edit = 0;
        } else if (mouseEvent.getX() > this.xsize / 3 && mouseEvent.getX() < 2 * this.xsize / 3) {
            this.edit = 1;
        } else if (mouseEvent.getX() > 2 * this.xsize / 3 && mouseEvent.getX() < this.xsize) {
            this.edit = 2;
        }
        if (this.edit > -1) {
            if (mouseEvent.getButton() == 1) {
                this.setTime(this.edit, 1);
            } else if (mouseEvent.getButton() == 3) {
                this.setTime(this.edit, -1);
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.setTime(this.edit, -1 * mouseWheelEvent.getWheelRotation());
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 32) {
            this.setTime(this.edit, 1);
        } else if (n == 8) {
            this.setTime(this.edit, 1);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void setTime(int n, int n2) {
        if (n == 0) {
            this.uren += n2;
        } else if (n == 1) {
            this.minuten += n2;
        } else if (n == 2) {
            this.seconden += n2;
        }
        if (this.seconden < 0) {
            this.seconden = 59;
            --this.minuten;
        }
        if (this.minuten < 0) {
            this.minuten = 59;
            --this.uren;
        }
        if (this.uren < 0) {
            this.uren = this.clock_type - 1;
        }
        if (this.seconden > 59) {
            this.seconden %= 60;
            ++this.minuten;
        }
        if (this.minuten > 59) {
            this.minuten %= 60;
            ++this.uren;
        }
        if (this.uren >= this.clock_type) {
            this.uren = 0;
        }
        this.repaint();
    }
}

