/**
 * FGraphImg.java
 *
 * Created on Jul 3, 2006
 */
package graphe;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

import maths.CoordSyst;
import maths.Fonction;

/**
 * Cette classe implemente <CODE>GraphImg</CODE>.
 *
 * @author Nicolae
 */
public class FGraphImg implements GraphImg {

	private Fonction fn;
	private CoordSyst cd;
	private GraphCol cl;
	private BufferedImage img;

	/**
	 * Constructeur standard.
	 */
	public FGraphImg() {
		fn = null;
		cd = null;
		cl = null;
		img = null;
	}
	
	public void setFonction(Fonction f) {
		fn = f;
		compute();
	}
	
	private void compute() {
		if(fn != null && cd != null && cl != null && cd.isValid()) {
			int w = cd.getWidth();
			int h = cd.getHeigth();
			
			img = new BufferedImage(w, h, BufferedImage.TYPE_4BYTE_ABGR);
			Graphics g = img.getGraphics();
			g.setColor(new Color(0,0,0,255));
			g.fillRect(0, 0, w, h);
			
			for (int i = 0; i < w; i++)
				for (int j = 0; j < h; j++) {
					int val = fn.getVal(cd.getRe(i), cd.getIm(j));
					
					img.setRGB(i, j, cl.getCol(val)); 
				}
		}
	}
	
	public void setCoords(CoordSyst coo) {
		cd = coo;
		compute();
	}
	
	public void setColors(GraphCol col) {
		cl = col;
		compute();
	}

	public BufferedImage getImage() {
		if(img == null)
			compute();
		
		return img;
	}
	
	public CoordSyst getCoords() {
		return cd;
	}
}
