target=basic parallel serial par3 ser3 h li parser bridge

#include "xiao.inc"
#include "data.inc"

\text{A=}

#if #TARGET (basic)
  \title{1 - resistor}
  \text{ctype=5/closeser}
  \text{comp=bat _V1_,wire,iArrow @@I,,res _R_}
  \text{f_a1=v1/r}
  \text{f_v2=v1}
  \text{f_a2=a1}
#endif
  
#if #TARGET (parallel)
  \title{2 - parallel}
  \text{ctype=5/closeparr}
  \text{comp=bat _V1_,iArrow @@I,res _R1_,,res _R_}
  \text{f_a1=v1/r1+v1/r}
  \text{f_v2=v1}
  \text{f_a2=v1/r}
#endif
  
#if #TARGET (serial)
  \title{2 - serial}
  \text{ctype=7/closeser}
  \text{comp=wire,bat _V1_,wire,iArrow @@I,chas,res _R1_,res _R_}
  \text{A=12,5.5}
  \text{f_a1=v1/(r1+r)}
  \text{f_v2=v1*r/(r1+r)}
  \text{f_a2=a1}
#endif
  
#if #TARGET (par3)
  \title{3 - parallel}
  \text{ctype=8/closepar3r}
  \text{comp=bat _V1_,iArrow @@I,res _R1_,chas,wire,res _R2_,wire,res _R_}
  \text{f_a1=v1/r1+v1/r2+v1/r}
  \text{f_v2=v1}
  \text{f_a2=v1/r}
#endif
  
#if #TARGET (ser3)
  \title{3 - serial}
  \text{ctype=7/closeser}
  \text{comp=wire,bat _V1_,iArrow @@I,res _R1_,chas,res _R2_,res _R_}
  \text{A=12,5.5}
  \text{f_a1=v1/(r1+r2+r)}
  \text{f_v2=v1*r/(r1+r2+r)}
  \text{f_a2=a1}
#endif
  
#if #TARGET (h)
  \title{3 - type h}
  \text{ctype=8/Hclose}
  \text{comp=bat _V1_,iArrow @@I,wire,,res _R_,chas,res _R1_,res _R2_}
  \text{A=14,5.5}
  \text{f_a1=v1/(r1+r2*r/(r2+r))}
  \text{f_v2=v1*(r2*r/(r2+r))/(r1+r2*r/(r2+r))}
  \text{f_a2=v1/(r1+r2*r/(r2+r))*r2/(r2+r)}
#endif
  
#if #TARGET (li)
  \title{3 - type il}
  \text{ctype=8/br3closeserr}
  \text{comp=bat _V1_,iArrow @@I,wire,res _R1_,res _R_,chas,wire,res _R2_}
  \text{A=9,5.5}
  \text{f_a1=v1/(r1+r)+v1/r2}
  \text{f_v2=v1*r/(r1+r)}
  \text{f_a2=v1/(r1+r)}
#endif

#if #TARGET (parser)
  \title{4 - parallel + serial}
  \text{ctype=8/br3closeserr}
  \text{comp=bat _V1_,iArrow @@I,wire,res _R1_,res _R2_,chas,res _R3_,res _R_}
  \text{A=14,5.5}
  \text{f_a1=v1/(r1+r2)+v1/(r3+r)}
  \text{f_v2=v1*r/(r3+r)}
  \text{f_a2=v1/(r3+r)}
#endif
  
#if #TARGET (bridge)
  \title{4 - type H}
  \text{ctype=8/Hclose}
  \text{comp=bat _V1_,iArrow @@I,wire,res _R3_,res _R_,chas,res _R1_,res _R2_}
  \text{A=14,5.5}
  \text{f_a1=v1/(r1*r3/(r1+r3)+r2*r/(r2+r))}
  \text{f_v2=v1*(r2*r/(r2+r))/(r1*r3/(r1+r3)+r2*r/(r2+r))}
  \text{f_a2=v1/(r1*r3/(r1+r3)+r2*r/(r2+r))*r2/(r2+r)}
#endif
  
#include "confparm.inc"
#include "process.inc"

\text{vide=}
\text{known=a1 isin \given?the current intensity I = \a1 \Aunit:}
\text{known=a2 isin \given?wims(append item \vide the current intensity
going through R is \a2 \Aunit to \known)}
\text{known=v2 isin \given?wims(append item \vide the voltage on point A
is \v2 V to \known)}

\statement{
    <img align=right hspace=10 src=\circ> <p>
In the circuit on the right,
\if{\known notsametext }{
 \known. <p>What is \quest&nbsp;? 
}{
 what is \quest&nbsp;?
}
\embed{r1,8}\qunit
<p>
ATTENTION. The error tolerance for your reply is \tolerance%.

<br clear=right>
}

\answer{\quest}{\good}{type=range}

\feedback{(\reply1 > \good2 and \reply1<=\good4) or
(\reply1 < \good1 and \reply1 >= \good3)}{Pay attention to the error tolerance!
Your seem to have made an error exceeding the tolerance in your computation.
}

