/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EndianConverter {
    public static int convert(byte[] byArray, short[] sArray, int n, int n2, int n3) {
        return EndianConverter.convert(byArray, sArray, n, n2, n3, (short)255);
    }

    public static int convert(byte[] byArray, short[] sArray, int n, int n2, int n3, short s) {
        n = Math.min(n3 * 2, n / 2 * 2);
        for (int i = 0; i < n; i += 2) {
            int n4 = (byArray[i] & 0xFF | byArray[i + 1] << 8) & s;
            sArray[i / 2 + n2] = (short)n4;
        }
        return n;
    }

    public static int convert(byte[] byArray, int[] nArray, int n, int n2, int n3) {
        return EndianConverter.convert(byArray, nArray, n, n2, n3, -1);
    }

    public static int convert(byte[] byArray, int[] nArray, int n, int n2, int n3, int n4) {
        n = Math.min(n3 * 4, n / 4 * 4);
        for (int i = 0; i < n; i += 4) {
            nArray[i / 4 + n2] = (byArray[i] & 0xFF | byArray[i + 1] << 8 & 0xFF00 | byArray[i + 2] << 16 & 0xFF0000 | byArray[i + 3] << 24) & n4;
        }
        return n;
    }

    public static int convert(byte[] byArray, long[] lArray, int n, int n2, int n3) {
        return EndianConverter.convert(byArray, lArray, n, n2, n3, -1L);
    }

    public static int convert(byte[] byArray, long[] lArray, int n, int n2, int n3, long l) {
        n = Math.min(n3 * 8, n / 8 * 8);
        for (int i = 0; i < n; i += 8) {
            lArray[i / 8 + n2] = ((long)(byArray[i] & 0xFF | byArray[i + 1] << 8 & 0xFF00 | byArray[i + 2] << 16 & 0xFF0000 | byArray[i + 3] << 24 & 0xFF000000) | (long)(byArray[i + 3] << 32) & 0xFF00000000L | (long)(byArray[i + 5] << 40) & 0xFF0000000000L | (long)(byArray[i + 6] << 48) & 0xFF000000000000L | (long)(byArray[i + 7] << 56)) & l;
        }
        return n;
    }

    public static short convert(short s) {
        return (short)(s >> 8 & 0xFF | s << 8);
    }

    public static int convert(int n) {
        return n >> 24 & 0xFF | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24;
    }

    public static long convert(long l) {
        return l >> 56 & 0xFFL | l >> 40 & 0xFF00L | l >> 24 & 0xFF0000L | l >> 8 & 0xFFFFFFFFFF000000L | l << 8 & 0xFF00000000L | l << 24 & 0xFF00000000L | l << 56 & 0xFF0000000000L;
    }

    public static int convertLittleEndianToFloat(byte[] byArray, float[] fArray, int n, int n2, int n3) {
        n = Math.min(n3 * 4, n / 4 * 4);
        for (int i = 0; i < n; i += 4) {
            fArray[i / 4 + n2] = Float.intBitsToFloat(byArray[i] & 0xFF | byArray[i + 1] << 8 & 0xFF00 | byArray[i + 2] << 16 & 0xFF0000 | byArray[i + 3] << 24);
        }
        return n;
    }

    public static int convertLittleEndianToDouble(byte[] byArray, double[] dArray, int n, int n2, int n3) {
        n = Math.min(n3 * 8, n / 8 * 8);
        for (int i = 0; i < n; i += 8) {
            dArray[i / 8 + n2] = Double.longBitsToDouble((long)(byArray[i] & 0xFF | byArray[i + 1] << 8 & 0xFF00 | byArray[i + 2] << 16 & 0xFF0000 | byArray[i + 3] << 24 & 0xFF000000) | (long)(byArray[i + 3] << 32) & 0xFF00000000L | (long)(byArray[i + 5] << 40) & 0xFF0000000000L | (long)(byArray[i + 6] << 48) & 0xFF000000000000L | (long)(byArray[i + 7] << 56));
        }
        return n;
    }

    public static int convert(int n, byte[] byArray, int[] nArray, int n2, int n3, int n4) {
        return EndianConverter.convert(n, byArray, nArray, n2, n3, n4, -1);
    }

    public static int convert(int n, byte[] byArray, int[] nArray, int n2, int n3, int n4, int n5) {
        int n6 = Math.min(n4 * n, n2 / n * n);
        if (n == 2) {
            for (int i = 0; i < n6; i += 2) {
                nArray[i / 2 + n3] = (byArray[i] & 0xFF | byArray[i + 1] << 8) & n5;
            }
            return n6;
        }
        if (n == 3) {
            for (int i = 0; i < n6; i += 3) {
                nArray[i / 3 + n3] = (byArray[i] & 0xFF | byArray[i + 1] << 8 & 0xFF00 | byArray[i + 2] << 24) & n5;
            }
            return n6;
        }
        if (n == 4) {
            return EndianConverter.convert(byArray, nArray, n2, n3, n4, n5);
        }
        return 0;
    }

    public static int convertToLittleEndian(short[] sArray, byte[] byArray, int n, int n2) {
        n2 = Math.min(n2, byArray.length / 2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            short s = sArray[n + i];
            byArray[n3++] = (byte)s;
            byArray[n3++] = (byte)(s >> 8);
        }
        return n2;
    }

    public static int convertToLittleEndian(int[] nArray, byte[] byArray, int n, int n2) {
        n2 = Math.min(n2, byArray.length / 4);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = nArray[n + i];
            byArray[n3++] = (byte)n4;
            byArray[n3++] = (byte)(n4 >> 8);
            byArray[n3++] = (byte)(n4 >> 16);
            byArray[n3++] = (byte)(n4 >> 24);
        }
        return n2;
    }

    public static int convertToLittleEndian(int n, int[] nArray, byte[] byArray, int n2, int n3) {
        n3 = Math.min(n3, byArray.length / n);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = nArray[n2 + i];
            byArray[n4++] = (byte)n5;
            if (n < 2) continue;
            byArray[n4++] = (byte)(n5 >> 8);
            if (n < 3) continue;
            byArray[n4++] = (byte)(n5 >> 16);
            if (n != 4) continue;
            byArray[n4++] = (byte)(n5 >> 24);
        }
        return n3;
    }

    public static int convertToLittleEndian(long[] lArray, byte[] byArray, int n, int n2) {
        n2 = Math.min(n2, byArray.length / 8);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            long l = lArray[n + i];
            for (int j = 0; j < 8; ++j) {
                byArray[n3++] = (byte)l;
                l >>= 8;
            }
        }
        return n2;
    }

    public static int convertToLittleEndian(float[] fArray, byte[] byArray, int n, int n2) {
        n2 = Math.min(n2, byArray.length / 4);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = Float.floatToIntBits(fArray[n + i]);
            byArray[n3++] = (byte)n4;
            byArray[n3++] = (byte)(n4 >> 8);
            byArray[n3++] = (byte)(n4 >> 16);
            byArray[n3++] = (byte)(n4 >> 24);
        }
        return n2;
    }

    public static int convertToLittleEndian(double[] dArray, byte[] byArray, int n, int n2) {
        n2 = Math.min(n2, byArray.length / 8);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            long l = Double.doubleToLongBits(dArray[n + i]);
            for (int j = 0; j < 8; ++j) {
                byArray[n3++] = (byte)l;
                l >>= 8;
            }
        }
        return n2;
    }

    public static int read(byte[] byArray, short[] sArray, int n, int n2, InputStream inputStream) throws IOException {
        return EndianConverter.read(byArray, sArray, n, n2, inputStream, (short)255);
    }

    public static int read(byte[] byArray, short[] sArray, int n, int n2, InputStream inputStream, short s) throws IOException {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = byArray.length / 2 * 2;
        for (n3 = 0; n5 >= 0 && n3 < n2; n3 += n4 / 2) {
            int n8 = Math.min((n2 - n3) * 2, n7);
            n5 = inputStream.read(byArray, n6, n8 - n6);
            if (n5 - (n4 = EndianConverter.convert(byArray, sArray, n5 + n6, n + n3, n2 - n3, s)) == 1) {
                n6 = 1;
                byArray[0] = byArray[n4];
                continue;
            }
            n6 = 0;
        }
        return n3;
    }

    public static int read(byte[] byArray, int[] nArray, int n, int n2, InputStream inputStream) throws IOException {
        return EndianConverter.read(byArray, nArray, n, n2, inputStream, -1);
    }

    public static int read(byte[] byArray, int[] nArray, int n, int n2, InputStream inputStream, int n3) throws IOException {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = byArray.length / 4 * 4;
        for (n4 = 0; n6 >= 0 && n4 < n2; n4 += n5 / 4) {
            int n9 = Math.min((n2 - n4) * 4, n8);
            n6 = inputStream.read(byArray, n7, n9 - n7);
            if ((n7 = n6 - (n5 = EndianConverter.convert(byArray, nArray, n6 + n7, n + n4, n2 - n4, n3))) < 1) continue;
            byArray[0] = byArray[n5];
            if (n7 < 2) continue;
            byArray[1] = byArray[n5 + 1];
            if (n7 < 3) continue;
            byArray[2] = byArray[n5 + 2];
        }
        return n4;
    }

    public static int read(int n, byte[] byArray, int[] nArray, int n2, int n3, InputStream inputStream) throws IOException {
        return EndianConverter.read(n, byArray, nArray, n2, n3, inputStream, -1);
    }

    public static int read(int n, byte[] byArray, int[] nArray, int n2, int n3, InputStream inputStream, int n4) throws IOException {
        if (n == 2) {
            return EndianConverter.read2ByteBlock(byArray, nArray, n2, n3, inputStream, n4);
        }
        if (n == 3) {
            return EndianConverter.read3ByteBlock(byArray, nArray, n2, n3, inputStream, n4);
        }
        if (n == 4) {
            return EndianConverter.read(byArray, nArray, n2, n3, inputStream, n4);
        }
        return 0;
    }

    public static int read4ByteBlock(InputStream inputStream) throws IOException {
        return EndianConverter.read(inputStream) & 0xFF | EndianConverter.read(inputStream) << 8 & 0xFF00 | EndianConverter.read(inputStream) << 16 & 0xFF0000 | EndianConverter.read(inputStream) << 24;
    }

    public static int read2ByteBlock(InputStream inputStream) throws IOException {
        return EndianConverter.read(inputStream) & 0xFF | EndianConverter.read(inputStream) << 8;
    }

    public static int read3ByteBlock(InputStream inputStream) throws IOException {
        return EndianConverter.read(inputStream) & 0xFF | EndianConverter.read(inputStream) << 8 & 0xFF00 | EndianConverter.read(inputStream) << 16;
    }

    public static long read8ByteBlock(InputStream inputStream) throws IOException {
        return (long)(EndianConverter.read(inputStream) & 0xFF | EndianConverter.read(inputStream) << 8 & 0xFF00 | EndianConverter.read(inputStream) << 16 & 0xFF0000 | EndianConverter.read(inputStream) << 24 & 0xFF000000) | (long)(EndianConverter.read(inputStream) << 32) & 0xFF00000000L | (long)(EndianConverter.read(inputStream) << 40) & 0xFF0000000000L | (long)(EndianConverter.read(inputStream) << 48) & 0xFF000000000000L | (long)(EndianConverter.read(inputStream) << 56);
    }

    public static void writeLittleEndian(short[] sArray, int n, int n2, OutputStream outputStream, byte[] byArray) throws IOException {
        while (n2 >= 0) {
            int n3 = EndianConverter.convertToLittleEndian(sArray, byArray, n, n2);
            outputStream.write(byArray, 0, n3 * 2);
            n += n3;
            n2 -= n3;
        }
    }

    public static void writeLittleEndian(int[] nArray, int n, int n2, OutputStream outputStream, byte[] byArray) throws IOException {
        while (n2 > 0) {
            int n3 = EndianConverter.convertToLittleEndian(nArray, byArray, n, n2);
            outputStream.write(byArray, 0, n3 * 4);
            n += n3;
            n2 -= n3;
        }
    }

    public static void writeLittleEndian(long[] lArray, int n, int n2, OutputStream outputStream, byte[] byArray) throws IOException {
        while (n2 > 0) {
            int n3 = EndianConverter.convertToLittleEndian(lArray, byArray, n, n2);
            outputStream.write(byArray, 0, n3 * 8);
            n += n3;
            n2 -= n3;
        }
    }

    public static void writeLittleEndian(int n, int[] nArray, int n2, int n3, OutputStream outputStream, byte[] byArray) throws IOException {
        while (n3 > 0) {
            int n4 = EndianConverter.convertToLittleEndian(n, nArray, byArray, n2, n3);
            outputStream.write(byArray, 0, n4 * n);
            n2 += n4;
            n3 -= n4;
        }
    }

    public static void writeLittleEndian(float[] fArray, int n, int n2, OutputStream outputStream, byte[] byArray) throws IOException {
        while (n2 > 0) {
            int n3 = EndianConverter.convertToLittleEndian(fArray, byArray, n, n2);
            outputStream.write(byArray, 0, n3 * 4);
            n += n3;
            n2 -= n3;
        }
    }

    public static void writeLittleEndian(double[] dArray, int n, int n2, OutputStream outputStream, byte[] byArray) throws IOException {
        while (n2 > 0) {
            int n3 = EndianConverter.convertToLittleEndian(dArray, byArray, n, n2);
            outputStream.write(byArray, 0, n3 * 8);
            n += n3;
            n2 -= n3;
        }
    }

    public static void writeLittleEndian(OutputStream outputStream, short s) throws IOException {
        outputStream.write(s);
        outputStream.write(s >> 8);
    }

    public static void writeLittleEndian(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n);
        outputStream.write(n >> 8);
        outputStream.write(n >> 16);
        outputStream.write(n >> 24);
    }

    public static void writeLittleEndian(OutputStream outputStream, long l) throws IOException {
        for (int i = 0; i < 8; ++i) {
            outputStream.write((int)l);
            l >>= 8;
        }
    }

    private static int read2ByteBlock(byte[] byArray, int[] nArray, int n, int n2, InputStream inputStream, int n3) throws IOException {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = byArray.length / 2 * 2;
        for (n4 = 0; n6 >= 0 && n4 < n2; n4 += n5 / 2) {
            int n9 = Math.max((n2 - n4) * 2, n8);
            n6 = inputStream.read(byArray, n7, n9 - n7);
            if (n6 - (n5 = EndianConverter.convert(2, byArray, nArray, n6 + n7, n + n4, n2 - n4, n3)) == 1) {
                n7 = 1;
                byArray[0] = byArray[n5];
                continue;
            }
            n7 = 0;
        }
        return n4;
    }

    private static int read3ByteBlock(byte[] byArray, int[] nArray, int n, int n2, InputStream inputStream, int n3) throws IOException {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = byArray.length / 3 * 3;
        for (n4 = 0; n6 >= 0 && n4 < n2; n4 += n5 / 3) {
            int n9 = Math.max((n2 - n4) * 3, n8);
            n6 = inputStream.read(byArray, n7, n9 - n7);
            if ((n7 = n6 - (n5 = EndianConverter.convert(3, byArray, nArray, n6 + n7, n + n4, n2 - n4, n3))) < 1) continue;
            byArray[0] = byArray[n5];
            if (n7 < 2) continue;
            byArray[1] = byArray[n5 + 1];
        }
        return n4;
    }

    private static int read(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new IOException("Filesize does not match blocksize");
        }
        return n;
    }
}

