// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) M(add)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anomymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_T32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  int32_t immediate;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] =
    {{{al, r7, pc, 19}, false, al, "al r7 pc 19", "al_r7_pc_19"},
     {{al, r6, pc, 78}, false, al, "al r6 pc 78", "al_r6_pc_78"},
     {{al, r7, pc, 92}, false, al, "al r7 pc 92", "al_r7_pc_92"},
     {{al, r7, pc, 195}, false, al, "al r7 pc 195", "al_r7_pc_195"},
     {{al, r4, pc, 17}, false, al, "al r4 pc 17", "al_r4_pc_17"},
     {{al, r6, pc, 150}, false, al, "al r6 pc 150", "al_r6_pc_150"},
     {{al, r4, pc, 166}, false, al, "al r4 pc 166", "al_r4_pc_166"},
     {{al, r1, pc, 63}, false, al, "al r1 pc 63", "al_r1_pc_63"},
     {{al, r3, pc, 15}, false, al, "al r3 pc 15", "al_r3_pc_15"},
     {{al, r6, pc, 49}, false, al, "al r6 pc 49", "al_r6_pc_49"},
     {{al, r2, pc, 205}, false, al, "al r2 pc 205", "al_r2_pc_205"},
     {{al, r6, pc, 107}, false, al, "al r6 pc 107", "al_r6_pc_107"},
     {{al, r4, pc, 226}, false, al, "al r4 pc 226", "al_r4_pc_226"},
     {{al, r5, pc, 128}, false, al, "al r5 pc 128", "al_r5_pc_128"},
     {{al, r6, pc, 54}, false, al, "al r6 pc 54", "al_r6_pc_54"},
     {{al, r3, pc, 63}, false, al, "al r3 pc 63", "al_r3_pc_63"},
     {{al, r1, pc, 9}, false, al, "al r1 pc 9", "al_r1_pc_9"},
     {{al, r1, pc, 214}, false, al, "al r1 pc 214", "al_r1_pc_214"},
     {{al, r0, pc, 148}, false, al, "al r0 pc 148", "al_r0_pc_148"},
     {{al, r1, pc, 70}, false, al, "al r1 pc 70", "al_r1_pc_70"},
     {{al, r2, pc, 167}, false, al, "al r2 pc 167", "al_r2_pc_167"},
     {{al, r0, pc, 1}, false, al, "al r0 pc 1", "al_r0_pc_1"},
     {{al, r0, pc, 97}, false, al, "al r0 pc 97", "al_r0_pc_97"},
     {{al, r7, pc, 66}, false, al, "al r7 pc 66", "al_r7_pc_66"},
     {{al, r7, pc, 179}, false, al, "al r7 pc 179", "al_r7_pc_179"},
     {{al, r4, pc, 183}, false, al, "al r4 pc 183", "al_r4_pc_183"},
     {{al, r7, pc, 150}, false, al, "al r7 pc 150", "al_r7_pc_150"},
     {{al, r5, pc, 241}, false, al, "al r5 pc 241", "al_r5_pc_241"},
     {{al, r6, pc, 31}, false, al, "al r6 pc 31", "al_r6_pc_31"},
     {{al, r7, pc, 224}, false, al, "al r7 pc 224", "al_r7_pc_224"},
     {{al, r6, pc, 235}, false, al, "al r6 pc 235", "al_r6_pc_235"},
     {{al, r3, pc, 220}, false, al, "al r3 pc 220", "al_r3_pc_220"},
     {{al, r7, pc, 201}, false, al, "al r7 pc 201", "al_r7_pc_201"},
     {{al, r2, pc, 70}, false, al, "al r2 pc 70", "al_r2_pc_70"},
     {{al, r4, pc, 174}, false, al, "al r4 pc 174", "al_r4_pc_174"},
     {{al, r4, pc, 142}, false, al, "al r4 pc 142", "al_r4_pc_142"},
     {{al, r1, pc, 249}, false, al, "al r1 pc 249", "al_r1_pc_249"},
     {{al, r5, pc, 244}, false, al, "al r5 pc 244", "al_r5_pc_244"},
     {{al, r2, pc, 26}, false, al, "al r2 pc 26", "al_r2_pc_26"},
     {{al, r4, pc, 177}, false, al, "al r4 pc 177", "al_r4_pc_177"},
     {{al, r3, pc, 150}, false, al, "al r3 pc 150", "al_r3_pc_150"},
     {{al, r2, pc, 85}, false, al, "al r2 pc 85", "al_r2_pc_85"},
     {{al, r6, pc, 48}, false, al, "al r6 pc 48", "al_r6_pc_48"},
     {{al, r5, pc, 25}, false, al, "al r5 pc 25", "al_r5_pc_25"},
     {{al, r6, pc, 95}, false, al, "al r6 pc 95", "al_r6_pc_95"},
     {{al, r7, pc, 228}, false, al, "al r7 pc 228", "al_r7_pc_228"},
     {{al, r5, pc, 20}, false, al, "al r5 pc 20", "al_r5_pc_20"},
     {{al, r1, pc, 8}, false, al, "al r1 pc 8", "al_r1_pc_8"},
     {{al, r6, pc, 222}, false, al, "al r6 pc 222", "al_r6_pc_222"},
     {{al, r5, pc, 221}, false, al, "al r5 pc 221", "al_r5_pc_221"},
     {{al, r3, pc, 109}, false, al, "al r3 pc 109", "al_r3_pc_109"},
     {{al, r6, pc, 165}, false, al, "al r6 pc 165", "al_r6_pc_165"},
     {{al, r5, pc, 114}, false, al, "al r5 pc 114", "al_r5_pc_114"},
     {{al, r6, pc, 207}, false, al, "al r6 pc 207", "al_r6_pc_207"},
     {{al, r7, pc, 197}, false, al, "al r7 pc 197", "al_r7_pc_197"},
     {{al, r4, pc, 121}, false, al, "al r4 pc 121", "al_r4_pc_121"},
     {{al, r4, pc, 233}, false, al, "al r4 pc 233", "al_r4_pc_233"},
     {{al, r6, pc, 141}, false, al, "al r6 pc 141", "al_r6_pc_141"},
     {{al, r3, pc, 175}, false, al, "al r3 pc 175", "al_r3_pc_175"},
     {{al, r3, pc, 182}, false, al, "al r3 pc 182", "al_r3_pc_182"},
     {{al, r0, pc, 206}, false, al, "al r0 pc 206", "al_r0_pc_206"},
     {{al, r2, pc, 123}, false, al, "al r2 pc 123", "al_r2_pc_123"},
     {{al, r5, pc, 118}, false, al, "al r5 pc 118", "al_r5_pc_118"},
     {{al, r1, pc, 127}, false, al, "al r1 pc 127", "al_r1_pc_127"},
     {{al, r0, pc, 234}, false, al, "al r0 pc 234", "al_r0_pc_234"},
     {{al, r0, pc, 132}, false, al, "al r0 pc 132", "al_r0_pc_132"},
     {{al, r7, pc, 13}, false, al, "al r7 pc 13", "al_r7_pc_13"},
     {{al, r0, pc, 157}, false, al, "al r0 pc 157", "al_r0_pc_157"},
     {{al, r5, pc, 37}, false, al, "al r5 pc 37", "al_r5_pc_37"},
     {{al, r7, pc, 227}, false, al, "al r7 pc 227", "al_r7_pc_227"},
     {{al, r0, pc, 127}, false, al, "al r0 pc 127", "al_r0_pc_127"},
     {{al, r4, pc, 154}, false, al, "al r4 pc 154", "al_r4_pc_154"},
     {{al, r6, pc, 237}, false, al, "al r6 pc 237", "al_r6_pc_237"},
     {{al, r1, pc, 104}, false, al, "al r1 pc 104", "al_r1_pc_104"},
     {{al, r6, pc, 79}, false, al, "al r6 pc 79", "al_r6_pc_79"},
     {{al, r6, pc, 174}, false, al, "al r6 pc 174", "al_r6_pc_174"},
     {{al, r1, pc, 206}, false, al, "al r1 pc 206", "al_r1_pc_206"},
     {{al, r1, pc, 244}, false, al, "al r1 pc 244", "al_r1_pc_244"},
     {{al, r7, pc, 138}, false, al, "al r7 pc 138", "al_r7_pc_138"},
     {{al, r6, pc, 17}, false, al, "al r6 pc 17", "al_r6_pc_17"},
     {{al, r1, pc, 135}, false, al, "al r1 pc 135", "al_r1_pc_135"},
     {{al, r0, pc, 147}, false, al, "al r0 pc 147", "al_r0_pc_147"},
     {{al, r5, pc, 200}, false, al, "al r5 pc 200", "al_r5_pc_200"},
     {{al, r2, pc, 62}, false, al, "al r2 pc 62", "al_r2_pc_62"},
     {{al, r5, pc, 188}, false, al, "al r5 pc 188", "al_r5_pc_188"},
     {{al, r6, pc, 180}, false, al, "al r6 pc 180", "al_r6_pc_180"},
     {{al, r3, pc, 155}, false, al, "al r3 pc 155", "al_r3_pc_155"},
     {{al, r3, pc, 185}, false, al, "al r3 pc 185", "al_r3_pc_185"},
     {{al, r6, pc, 87}, false, al, "al r6 pc 87", "al_r6_pc_87"},
     {{al, r0, pc, 243}, false, al, "al r0 pc 243", "al_r0_pc_243"},
     {{al, r2, pc, 68}, false, al, "al r2 pc 68", "al_r2_pc_68"},
     {{al, r3, pc, 99}, false, al, "al r3 pc 99", "al_r3_pc_99"},
     {{al, r0, pc, 15}, false, al, "al r0 pc 15", "al_r0_pc_15"},
     {{al, r7, pc, 91}, false, al, "al r7 pc 91", "al_r7_pc_91"},
     {{al, r7, pc, 75}, false, al, "al r7 pc 75", "al_r7_pc_75"},
     {{al, r0, pc, 14}, false, al, "al r0 pc 14", "al_r0_pc_14"},
     {{al, r4, pc, 246}, false, al, "al r4 pc 246", "al_r4_pc_246"},
     {{al, r5, pc, 92}, false, al, "al r5 pc 92", "al_r5_pc_92"},
     {{al, r2, pc, 23}, false, al, "al r2 pc 23", "al_r2_pc_23"},
     {{al, r0, pc, 150}, false, al, "al r0 pc 150", "al_r0_pc_150"},
     {{al, r0, pc, 196}, false, al, "al r0 pc 196", "al_r0_pc_196"},
     {{al, r1, pc, 126}, false, al, "al r1 pc 126", "al_r1_pc_126"},
     {{al, r1, pc, 141}, false, al, "al r1 pc 141", "al_r1_pc_141"},
     {{al, r3, pc, 191}, false, al, "al r3 pc 191", "al_r3_pc_191"},
     {{al, r7, pc, 187}, false, al, "al r7 pc 187", "al_r7_pc_187"},
     {{al, r4, pc, 238}, false, al, "al r4 pc 238", "al_r4_pc_238"},
     {{al, r0, pc, 114}, false, al, "al r0 pc 114", "al_r0_pc_114"},
     {{al, r3, pc, 34}, false, al, "al r3 pc 34", "al_r3_pc_34"},
     {{al, r5, pc, 189}, false, al, "al r5 pc 189", "al_r5_pc_189"},
     {{al, r7, pc, 252}, false, al, "al r7 pc 252", "al_r7_pc_252"},
     {{al, r3, pc, 116}, false, al, "al r3 pc 116", "al_r3_pc_116"},
     {{al, r0, pc, 154}, false, al, "al r0 pc 154", "al_r0_pc_154"},
     {{al, r1, pc, 84}, false, al, "al r1 pc 84", "al_r1_pc_84"},
     {{al, r0, pc, 214}, false, al, "al r0 pc 214", "al_r0_pc_214"},
     {{al, r5, pc, 139}, false, al, "al r5 pc 139", "al_r5_pc_139"},
     {{al, r6, pc, 138}, false, al, "al r6 pc 138", "al_r6_pc_138"},
     {{al, r6, pc, 212}, false, al, "al r6 pc 212", "al_r6_pc_212"},
     {{al, r3, pc, 112}, false, al, "al r3 pc 112", "al_r3_pc_112"},
     {{al, r7, pc, 140}, false, al, "al r7 pc 140", "al_r7_pc_140"},
     {{al, r6, pc, 33}, false, al, "al r6 pc 33", "al_r6_pc_33"},
     {{al, r2, pc, 207}, false, al, "al r2 pc 207", "al_r2_pc_207"},
     {{al, r4, pc, 208}, false, al, "al r4 pc 208", "al_r4_pc_208"},
     {{al, r2, pc, 61}, false, al, "al r2 pc 61", "al_r2_pc_61"},
     {{al, r3, pc, 43}, false, al, "al r3 pc 43", "al_r3_pc_43"},
     {{al, r5, pc, 192}, false, al, "al r5 pc 192", "al_r5_pc_192"},
     {{al, r5, pc, 67}, false, al, "al r5 pc 67", "al_r5_pc_67"},
     {{al, r3, pc, 193}, false, al, "al r3 pc 193", "al_r3_pc_193"},
     {{al, r2, pc, 255}, false, al, "al r2 pc 255", "al_r2_pc_255"},
     {{al, r7, pc, 58}, false, al, "al r7 pc 58", "al_r7_pc_58"},
     {{al, r0, pc, 198}, false, al, "al r0 pc 198", "al_r0_pc_198"},
     {{al, r4, pc, 34}, false, al, "al r4 pc 34", "al_r4_pc_34"},
     {{al, r7, pc, 73}, false, al, "al r7 pc 73", "al_r7_pc_73"},
     {{al, r2, pc, 118}, false, al, "al r2 pc 118", "al_r2_pc_118"},
     {{al, r0, pc, 123}, false, al, "al r0 pc 123", "al_r0_pc_123"},
     {{al, r6, pc, 226}, false, al, "al r6 pc 226", "al_r6_pc_226"},
     {{al, r7, pc, 109}, false, al, "al r7 pc 109", "al_r7_pc_109"},
     {{al, r1, pc, 29}, false, al, "al r1 pc 29", "al_r1_pc_29"},
     {{al, r0, pc, 140}, false, al, "al r0 pc 140", "al_r0_pc_140"},
     {{al, r0, pc, 121}, false, al, "al r0 pc 121", "al_r0_pc_121"},
     {{al, r6, pc, 178}, false, al, "al r6 pc 178", "al_r6_pc_178"},
     {{al, r3, pc, 236}, false, al, "al r3 pc 236", "al_r3_pc_236"},
     {{al, r6, pc, 195}, false, al, "al r6 pc 195", "al_r6_pc_195"},
     {{al, r2, pc, 138}, false, al, "al r2 pc 138", "al_r2_pc_138"},
     {{al, r5, pc, 199}, false, al, "al r5 pc 199", "al_r5_pc_199"},
     {{al, r7, pc, 134}, false, al, "al r7 pc 134", "al_r7_pc_134"},
     {{al, r5, pc, 206}, false, al, "al r5 pc 206", "al_r5_pc_206"},
     {{al, r6, pc, 43}, false, al, "al r6 pc 43", "al_r6_pc_43"},
     {{al, r2, pc, 120}, false, al, "al r2 pc 120", "al_r2_pc_120"},
     {{al, r7, pc, 27}, false, al, "al r7 pc 27", "al_r7_pc_27"},
     {{al, r5, pc, 108}, false, al, "al r5 pc 108", "al_r5_pc_108"},
     {{al, r0, pc, 142}, false, al, "al r0 pc 142", "al_r0_pc_142"},
     {{al, r0, pc, 95}, false, al, "al r0 pc 95", "al_r0_pc_95"},
     {{al, r4, pc, 115}, false, al, "al r4 pc 115", "al_r4_pc_115"},
     {{al, r2, pc, 212}, false, al, "al r2 pc 212", "al_r2_pc_212"},
     {{al, r4, pc, 253}, false, al, "al r4 pc 253", "al_r4_pc_253"},
     {{al, r2, pc, 77}, false, al, "al r2 pc 77", "al_r2_pc_77"},
     {{al, r4, pc, 218}, false, al, "al r4 pc 218", "al_r4_pc_218"},
     {{al, r4, pc, 72}, false, al, "al r4 pc 72", "al_r4_pc_72"},
     {{al, r4, pc, 85}, false, al, "al r4 pc 85", "al_r4_pc_85"},
     {{al, r7, pc, 137}, false, al, "al r7 pc 137", "al_r7_pc_137"},
     {{al, r3, pc, 91}, false, al, "al r3 pc 91", "al_r3_pc_91"},
     {{al, r3, pc, 90}, false, al, "al r3 pc 90", "al_r3_pc_90"},
     {{al, r0, pc, 125}, false, al, "al r0 pc 125", "al_r0_pc_125"},
     {{al, r1, pc, 0}, false, al, "al r1 pc 0", "al_r1_pc_0"},
     {{al, r1, pc, 90}, false, al, "al r1 pc 90", "al_r1_pc_90"},
     {{al, r1, pc, 245}, false, al, "al r1 pc 245", "al_r1_pc_245"},
     {{al, r6, pc, 152}, false, al, "al r6 pc 152", "al_r6_pc_152"},
     {{al, r4, pc, 130}, false, al, "al r4 pc 130", "al_r4_pc_130"},
     {{al, r2, pc, 218}, false, al, "al r2 pc 218", "al_r2_pc_218"},
     {{al, r4, pc, 156}, false, al, "al r4 pc 156", "al_r4_pc_156"},
     {{al, r5, pc, 239}, false, al, "al r5 pc 239", "al_r5_pc_239"},
     {{al, r2, pc, 140}, false, al, "al r2 pc 140", "al_r2_pc_140"},
     {{al, r5, pc, 147}, false, al, "al r5 pc 147", "al_r5_pc_147"},
     {{al, r5, pc, 226}, false, al, "al r5 pc 226", "al_r5_pc_226"},
     {{al, r1, pc, 95}, false, al, "al r1 pc 95", "al_r1_pc_95"},
     {{al, r2, pc, 58}, false, al, "al r2 pc 58", "al_r2_pc_58"},
     {{al, r4, pc, 41}, false, al, "al r4 pc 41", "al_r4_pc_41"},
     {{al, r3, pc, 76}, false, al, "al r3 pc 76", "al_r3_pc_76"},
     {{al, r4, pc, 38}, false, al, "al r4 pc 38", "al_r4_pc_38"},
     {{al, r5, pc, 155}, false, al, "al r5 pc 155", "al_r5_pc_155"},
     {{al, r6, pc, 255}, false, al, "al r6 pc 255", "al_r6_pc_255"},
     {{al, r4, pc, 144}, false, al, "al r4 pc 144", "al_r4_pc_144"},
     {{al, r2, pc, 86}, false, al, "al r2 pc 86", "al_r2_pc_86"},
     {{al, r1, pc, 60}, false, al, "al r1 pc 60", "al_r1_pc_60"},
     {{al, r4, pc, 33}, false, al, "al r4 pc 33", "al_r4_pc_33"},
     {{al, r4, pc, 170}, false, al, "al r4 pc 170", "al_r4_pc_170"},
     {{al, r5, pc, 121}, false, al, "al r5 pc 121", "al_r5_pc_121"},
     {{al, r7, pc, 170}, false, al, "al r7 pc 170", "al_r7_pc_170"},
     {{al, r2, pc, 133}, false, al, "al r2 pc 133", "al_r2_pc_133"},
     {{al, r7, pc, 14}, false, al, "al r7 pc 14", "al_r7_pc_14"},
     {{al, r5, pc, 180}, false, al, "al r5 pc 180", "al_r5_pc_180"},
     {{al, r2, pc, 116}, false, al, "al r2 pc 116", "al_r2_pc_116"},
     {{al, r3, pc, 173}, false, al, "al r3 pc 173", "al_r3_pc_173"},
     {{al, r2, pc, 48}, false, al, "al r2 pc 48", "al_r2_pc_48"},
     {{al, r0, pc, 63}, false, al, "al r0 pc 63", "al_r0_pc_63"},
     {{al, r1, pc, 43}, false, al, "al r1 pc 43", "al_r1_pc_43"},
     {{al, r6, pc, 253}, false, al, "al r6 pc 253", "al_r6_pc_253"},
     {{al, r7, pc, 247}, false, al, "al r7 pc 247", "al_r7_pc_247"},
     {{al, r5, pc, 186}, false, al, "al r5 pc 186", "al_r5_pc_186"},
     {{al, r0, pc, 90}, false, al, "al r0 pc 90", "al_r0_pc_90"},
     {{al, r0, pc, 111}, false, al, "al r0 pc 111", "al_r0_pc_111"},
     {{al, r5, pc, 124}, false, al, "al r5 pc 124", "al_r5_pc_124"},
     {{al, r2, pc, 254}, false, al, "al r2 pc 254", "al_r2_pc_254"},
     {{al, r2, pc, 150}, false, al, "al r2 pc 150", "al_r2_pc_150"},
     {{al, r1, pc, 198}, false, al, "al r1 pc 198", "al_r1_pc_198"},
     {{al, r5, pc, 156}, false, al, "al r5 pc 156", "al_r5_pc_156"},
     {{al, r5, pc, 80}, false, al, "al r5 pc 80", "al_r5_pc_80"},
     {{al, r2, pc, 73}, false, al, "al r2 pc 73", "al_r2_pc_73"},
     {{al, r5, pc, 17}, false, al, "al r5 pc 17", "al_r5_pc_17"},
     {{al, r3, pc, 136}, false, al, "al r3 pc 136", "al_r3_pc_136"},
     {{al, r1, pc, 105}, false, al, "al r1 pc 105", "al_r1_pc_105"},
     {{al, r0, pc, 122}, false, al, "al r0 pc 122", "al_r0_pc_122"},
     {{al, r2, pc, 240}, false, al, "al r2 pc 240", "al_r2_pc_240"},
     {{al, r6, pc, 242}, false, al, "al r6 pc 242", "al_r6_pc_242"},
     {{al, r0, pc, 251}, false, al, "al r0 pc 251", "al_r0_pc_251"},
     {{al, r7, pc, 98}, false, al, "al r7 pc 98", "al_r7_pc_98"},
     {{al, r4, pc, 254}, false, al, "al r4 pc 254", "al_r4_pc_254"},
     {{al, r1, pc, 251}, false, al, "al r1 pc 251", "al_r1_pc_251"},
     {{al, r4, pc, 212}, false, al, "al r4 pc 212", "al_r4_pc_212"},
     {{al, r6, pc, 173}, false, al, "al r6 pc 173", "al_r6_pc_173"},
     {{al, r6, pc, 69}, false, al, "al r6 pc 69", "al_r6_pc_69"},
     {{al, r3, pc, 145}, false, al, "al r3 pc 145", "al_r3_pc_145"},
     {{al, r4, pc, 152}, false, al, "al r4 pc 152", "al_r4_pc_152"},
     {{al, r7, pc, 164}, false, al, "al r7 pc 164", "al_r7_pc_164"},
     {{al, r4, pc, 96}, false, al, "al r4 pc 96", "al_r4_pc_96"},
     {{al, r7, pc, 37}, false, al, "al r7 pc 37", "al_r7_pc_37"},
     {{al, r4, pc, 69}, false, al, "al r4 pc 69", "al_r4_pc_69"},
     {{al, r2, pc, 7}, false, al, "al r2 pc 7", "al_r2_pc_7"},
     {{al, r2, pc, 59}, false, al, "al r2 pc 59", "al_r2_pc_59"},
     {{al, r7, pc, 44}, false, al, "al r7 pc 44", "al_r7_pc_44"},
     {{al, r5, pc, 23}, false, al, "al r5 pc 23", "al_r5_pc_23"},
     {{al, r3, pc, 231}, false, al, "al r3 pc 231", "al_r3_pc_231"},
     {{al, r7, pc, 169}, false, al, "al r7 pc 169", "al_r7_pc_169"},
     {{al, r5, pc, 127}, false, al, "al r5 pc 127", "al_r5_pc_127"},
     {{al, r2, pc, 229}, false, al, "al r2 pc 229", "al_r2_pc_229"},
     {{al, r7, pc, 163}, false, al, "al r7 pc 163", "al_r7_pc_163"},
     {{al, r0, pc, 104}, false, al, "al r0 pc 104", "al_r0_pc_104"},
     {{al, r1, pc, 227}, false, al, "al r1 pc 227", "al_r1_pc_227"},
     {{al, r2, pc, 235}, false, al, "al r2 pc 235", "al_r2_pc_235"},
     {{al, r7, pc, 182}, false, al, "al r7 pc 182", "al_r7_pc_182"},
     {{al, r1, pc, 149}, false, al, "al r1 pc 149", "al_r1_pc_149"},
     {{al, r4, pc, 35}, false, al, "al r4 pc 35", "al_r4_pc_35"},
     {{al, r2, pc, 250}, false, al, "al r2 pc 250", "al_r2_pc_250"},
     {{al, r2, pc, 109}, false, al, "al r2 pc 109", "al_r2_pc_109"},
     {{al, r5, pc, 178}, false, al, "al r5 pc 178", "al_r5_pc_178"},
     {{al, r1, pc, 78}, false, al, "al r1 pc 78", "al_r1_pc_78"},
     {{al, r4, pc, 78}, false, al, "al r4 pc 78", "al_r4_pc_78"},
     {{al, r6, pc, 121}, false, al, "al r6 pc 121", "al_r6_pc_121"},
     {{al, r2, pc, 202}, false, al, "al r2 pc 202", "al_r2_pc_202"},
     {{al, r0, pc, 228}, false, al, "al r0 pc 228", "al_r0_pc_228"},
     {{al, r6, pc, 56}, false, al, "al r6 pc 56", "al_r6_pc_56"},
     {{al, r7, pc, 191}, false, al, "al r7 pc 191", "al_r7_pc_191"},
     {{al, r7, pc, 213}, false, al, "al r7 pc 213", "al_r7_pc_213"},
     {{al, r4, pc, 20}, false, al, "al r4 pc 20", "al_r4_pc_20"},
     {{al, r7, pc, 111}, false, al, "al r7 pc 111", "al_r7_pc_111"},
     {{al, r6, pc, 130}, false, al, "al r6 pc 130", "al_r6_pc_130"},
     {{al, r5, pc, 28}, false, al, "al r5 pc 28", "al_r5_pc_28"},
     {{al, r7, pc, 96}, false, al, "al r7 pc 96", "al_r7_pc_96"},
     {{al, r5, pc, 10}, false, al, "al r5 pc 10", "al_r5_pc_10"},
     {{al, r7, pc, 88}, false, al, "al r7 pc 88", "al_r7_pc_88"},
     {{al, r2, pc, 142}, false, al, "al r2 pc 142", "al_r2_pc_142"},
     {{al, r2, pc, 49}, false, al, "al r2 pc 49", "al_r2_pc_49"},
     {{al, r4, pc, 214}, false, al, "al r4 pc 214", "al_r4_pc_214"},
     {{al, r7, pc, 1}, false, al, "al r7 pc 1", "al_r7_pc_1"},
     {{al, r1, pc, 88}, false, al, "al r1 pc 88", "al_r1_pc_88"},
     {{al, r5, pc, 160}, false, al, "al r5 pc 160", "al_r5_pc_160"},
     {{al, r7, pc, 82}, false, al, "al r7 pc 82", "al_r7_pc_82"},
     {{al, r1, pc, 220}, false, al, "al r1 pc 220", "al_r1_pc_220"},
     {{al, r0, pc, 254}, false, al, "al r0 pc 254", "al_r0_pc_254"},
     {{al, r6, pc, 119}, false, al, "al r6 pc 119", "al_r6_pc_119"},
     {{al, r2, pc, 55}, false, al, "al r2 pc 55", "al_r2_pc_55"},
     {{al, r7, pc, 71}, false, al, "al r7 pc 71", "al_r7_pc_71"},
     {{al, r1, pc, 142}, false, al, "al r1 pc 142", "al_r1_pc_142"},
     {{al, r1, pc, 109}, false, al, "al r1 pc 109", "al_r1_pc_109"},
     {{al, r7, pc, 35}, false, al, "al r7 pc 35", "al_r7_pc_35"},
     {{al, r4, pc, 249}, false, al, "al r4 pc 249", "al_r4_pc_249"},
     {{al, r3, pc, 134}, false, al, "al r3 pc 134", "al_r3_pc_134"},
     {{al, r6, pc, 81}, false, al, "al r6 pc 81", "al_r6_pc_81"},
     {{al, r7, pc, 249}, false, al, "al r7 pc 249", "al_r7_pc_249"},
     {{al, r0, pc, 81}, false, al, "al r0 pc 81", "al_r0_pc_81"},
     {{al, r7, pc, 233}, false, al, "al r7 pc 233", "al_r7_pc_233"},
     {{al, r6, pc, 162}, false, al, "al r6 pc 162", "al_r6_pc_162"},
     {{al, r4, pc, 123}, false, al, "al r4 pc 123", "al_r4_pc_123"},
     {{al, r1, pc, 229}, false, al, "al r1 pc 229", "al_r1_pc_229"},
     {{al, r0, pc, 51}, false, al, "al r0 pc 51", "al_r0_pc_51"},
     {{al, r6, pc, 44}, false, al, "al r6 pc 44", "al_r6_pc_44"},
     {{al, r3, pc, 132}, false, al, "al r3 pc 132", "al_r3_pc_132"},
     {{al, r5, pc, 246}, false, al, "al r5 pc 246", "al_r5_pc_246"},
     {{al, r2, pc, 156}, false, al, "al r2 pc 156", "al_r2_pc_156"},
     {{al, r3, pc, 74}, false, al, "al r3 pc 74", "al_r3_pc_74"},
     {{al, r4, pc, 199}, false, al, "al r4 pc 199", "al_r4_pc_199"},
     {{al, r5, pc, 181}, false, al, "al r5 pc 181", "al_r5_pc_181"},
     {{al, r4, pc, 180}, false, al, "al r4 pc 180", "al_r4_pc_180"},
     {{al, r4, pc, 93}, false, al, "al r4 pc 93", "al_r4_pc_93"},
     {{al, r3, pc, 23}, false, al, "al r3 pc 23", "al_r3_pc_23"},
     {{al, r2, pc, 204}, false, al, "al r2 pc 204", "al_r2_pc_204"},
     {{al, r0, pc, 83}, false, al, "al r0 pc 83", "al_r0_pc_83"},
     {{al, r0, pc, 39}, false, al, "al r0 pc 39", "al_r0_pc_39"},
     {{al, r3, pc, 158}, false, al, "al r3 pc 158", "al_r3_pc_158"},
     {{al, r5, pc, 137}, false, al, "al r5 pc 137", "al_r5_pc_137"},
     {{al, r4, pc, 209}, false, al, "al r4 pc 209", "al_r4_pc_209"},
     {{al, r0, pc, 43}, false, al, "al r0 pc 43", "al_r0_pc_43"},
     {{al, r6, pc, 65}, false, al, "al r6 pc 65", "al_r6_pc_65"},
     {{al, r7, pc, 128}, false, al, "al r7 pc 128", "al_r7_pc_128"},
     {{al, r5, pc, 176}, false, al, "al r5 pc 176", "al_r5_pc_176"},
     {{al, r5, pc, 143}, false, al, "al r5 pc 143", "al_r5_pc_143"},
     {{al, r1, pc, 123}, false, al, "al r1 pc 123", "al_r1_pc_123"},
     {{al, r2, pc, 181}, false, al, "al r2 pc 181", "al_r2_pc_181"},
     {{al, r3, pc, 10}, false, al, "al r3 pc 10", "al_r3_pc_10"},
     {{al, r7, pc, 40}, false, al, "al r7 pc 40", "al_r7_pc_40"},
     {{al, r5, pc, 94}, false, al, "al r5 pc 94", "al_r5_pc_94"},
     {{al, r3, pc, 117}, false, al, "al r3 pc 117", "al_r3_pc_117"},
     {{al, r3, pc, 65}, false, al, "al r3 pc 65", "al_r3_pc_65"},
     {{al, r7, pc, 209}, false, al, "al r7 pc 209", "al_r7_pc_209"},
     {{al, r0, pc, 181}, false, al, "al r0 pc 181", "al_r0_pc_181"},
     {{al, r7, pc, 151}, false, al, "al r7 pc 151", "al_r7_pc_151"},
     {{al, r1, pc, 207}, false, al, "al r1 pc 207", "al_r1_pc_207"},
     {{al, r3, pc, 58}, false, al, "al r3 pc 58", "al_r3_pc_58"},
     {{al, r6, pc, 118}, false, al, "al r6 pc 118", "al_r6_pc_118"},
     {{al, r5, pc, 58}, false, al, "al r5 pc 58", "al_r5_pc_58"},
     {{al, r5, pc, 138}, false, al, "al r5 pc 138", "al_r5_pc_138"},
     {{al, r0, pc, 204}, false, al, "al r0 pc 204", "al_r0_pc_204"},
     {{al, r1, pc, 138}, false, al, "al r1 pc 138", "al_r1_pc_138"},
     {{al, r6, pc, 221}, false, al, "al r6 pc 221", "al_r6_pc_221"},
     {{al, r3, pc, 125}, false, al, "al r3 pc 125", "al_r3_pc_125"},
     {{al, r4, pc, 2}, false, al, "al r4 pc 2", "al_r4_pc_2"},
     {{al, r3, pc, 8}, false, al, "al r3 pc 8", "al_r3_pc_8"},
     {{al, r7, pc, 188}, false, al, "al r7 pc 188", "al_r7_pc_188"},
     {{al, r2, pc, 237}, false, al, "al r2 pc 237", "al_r2_pc_237"},
     {{al, r2, pc, 22}, false, al, "al r2 pc 22", "al_r2_pc_22"},
     {{al, r4, pc, 179}, false, al, "al r4 pc 179", "al_r4_pc_179"},
     {{al, r2, pc, 65}, false, al, "al r2 pc 65", "al_r2_pc_65"},
     {{al, r4, pc, 30}, false, al, "al r4 pc 30", "al_r4_pc_30"},
     {{al, r1, pc, 239}, false, al, "al r1 pc 239", "al_r1_pc_239"},
     {{al, r6, pc, 169}, false, al, "al r6 pc 169", "al_r6_pc_169"},
     {{al, r7, pc, 30}, false, al, "al r7 pc 30", "al_r7_pc_30"},
     {{al, r3, pc, 184}, false, al, "al r3 pc 184", "al_r3_pc_184"},
     {{al, r0, pc, 112}, false, al, "al r0 pc 112", "al_r0_pc_112"},
     {{al, r0, pc, 25}, false, al, "al r0 pc 25", "al_r0_pc_25"},
     {{al, r4, pc, 77}, false, al, "al r4 pc 77", "al_r4_pc_77"},
     {{al, r7, pc, 142}, false, al, "al r7 pc 142", "al_r7_pc_142"},
     {{al, r1, pc, 33}, false, al, "al r1 pc 33", "al_r1_pc_33"},
     {{al, r2, pc, 64}, false, al, "al r2 pc 64", "al_r2_pc_64"},
     {{al, r4, pc, 230}, false, al, "al r4 pc 230", "al_r4_pc_230"},
     {{al, r5, pc, 40}, false, al, "al r5 pc 40", "al_r5_pc_40"},
     {{al, r3, pc, 209}, false, al, "al r3 pc 209", "al_r3_pc_209"},
     {{al, r4, pc, 227}, false, al, "al r4 pc 227", "al_r4_pc_227"},
     {{al, r7, pc, 219}, false, al, "al r7 pc 219", "al_r7_pc_219"},
     {{al, r4, pc, 46}, false, al, "al r4 pc 46", "al_r4_pc_46"},
     {{al, r2, pc, 245}, false, al, "al r2 pc 245", "al_r2_pc_245"},
     {{al, r2, pc, 146}, false, al, "al r2 pc 146", "al_r2_pc_146"},
     {{al, r6, pc, 191}, false, al, "al r6 pc 191", "al_r6_pc_191"},
     {{al, r4, pc, 106}, false, al, "al r4 pc 106", "al_r4_pc_106"},
     {{al, r3, pc, 92}, false, al, "al r3 pc 92", "al_r3_pc_92"},
     {{al, r2, pc, 153}, false, al, "al r2 pc 153", "al_r2_pc_153"},
     {{al, r4, pc, 155}, false, al, "al r4 pc 155", "al_r4_pc_155"},
     {{al, r4, pc, 164}, false, al, "al r4 pc 164", "al_r4_pc_164"},
     {{al, r4, pc, 252}, false, al, "al r4 pc 252", "al_r4_pc_252"},
     {{al, r0, pc, 107}, false, al, "al r0 pc 107", "al_r0_pc_107"},
     {{al, r2, pc, 198}, false, al, "al r2 pc 198", "al_r2_pc_198"},
     {{al, r2, pc, 191}, false, al, "al r2 pc 191", "al_r2_pc_191"},
     {{al, r3, pc, 59}, false, al, "al r3 pc 59", "al_r3_pc_59"},
     {{al, r7, pc, 156}, false, al, "al r7 pc 156", "al_r7_pc_156"},
     {{al, r2, pc, 244}, false, al, "al r2 pc 244", "al_r2_pc_244"},
     {{al, r1, pc, 11}, false, al, "al r1 pc 11", "al_r1_pc_11"},
     {{al, r6, pc, 82}, false, al, "al r6 pc 82", "al_r6_pc_82"},
     {{al, r4, pc, 28}, false, al, "al r4 pc 28", "al_r4_pc_28"},
     {{al, r3, pc, 211}, false, al, "al r3 pc 211", "al_r3_pc_211"},
     {{al, r2, pc, 1}, false, al, "al r2 pc 1", "al_r2_pc_1"},
     {{al, r2, pc, 195}, false, al, "al r2 pc 195", "al_r2_pc_195"},
     {{al, r0, pc, 60}, false, al, "al r0 pc 60", "al_r0_pc_60"},
     {{al, r4, pc, 193}, false, al, "al r4 pc 193", "al_r4_pc_193"},
     {{al, r7, pc, 171}, false, al, "al r7 pc 171", "al_r7_pc_171"},
     {{al, r6, pc, 45}, false, al, "al r6 pc 45", "al_r6_pc_45"},
     {{al, r4, pc, 167}, false, al, "al r4 pc 167", "al_r4_pc_167"},
     {{al, r6, pc, 185}, false, al, "al r6 pc 185", "al_r6_pc_185"},
     {{al, r4, pc, 148}, false, al, "al r4 pc 148", "al_r4_pc_148"},
     {{al, r0, pc, 88}, false, al, "al r0 pc 88", "al_r0_pc_88"},
     {{al, r1, pc, 167}, false, al, "al r1 pc 167", "al_r1_pc_167"},
     {{al, r3, pc, 80}, false, al, "al r3 pc 80", "al_r3_pc_80"},
     {{al, r1, pc, 180}, false, al, "al r1 pc 180", "al_r1_pc_180"},
     {{al, r4, pc, 150}, false, al, "al r4 pc 150", "al_r4_pc_150"},
     {{al, r6, pc, 201}, false, al, "al r6 pc 201", "al_r6_pc_201"},
     {{al, r0, pc, 24}, false, al, "al r0 pc 24", "al_r0_pc_24"},
     {{al, r3, pc, 41}, false, al, "al r3 pc 41", "al_r3_pc_41"},
     {{al, r0, pc, 41}, false, al, "al r0 pc 41", "al_r0_pc_41"},
     {{al, r3, pc, 84}, false, al, "al r3 pc 84", "al_r3_pc_84"},
     {{al, r1, pc, 164}, false, al, "al r1 pc 164", "al_r1_pc_164"},
     {{al, r0, pc, 32}, false, al, "al r0 pc 32", "al_r0_pc_32"},
     {{al, r7, pc, 240}, false, al, "al r7 pc 240", "al_r7_pc_240"},
     {{al, r4, pc, 53}, false, al, "al r4 pc 53", "al_r4_pc_53"},
     {{al, r4, pc, 117}, false, al, "al r4 pc 117", "al_r4_pc_117"},
     {{al, r2, pc, 243}, false, al, "al r2 pc 243", "al_r2_pc_243"},
     {{al, r7, pc, 43}, false, al, "al r7 pc 43", "al_r7_pc_43"},
     {{al, r4, pc, 153}, false, al, "al r4 pc 153", "al_r4_pc_153"},
     {{al, r3, pc, 159}, false, al, "al r3 pc 159", "al_r3_pc_159"},
     {{al, r6, pc, 137}, false, al, "al r6 pc 137", "al_r6_pc_137"},
     {{al, r1, pc, 205}, false, al, "al r1 pc 205", "al_r1_pc_205"},
     {{al, r7, pc, 16}, false, al, "al r7 pc 16", "al_r7_pc_16"},
     {{al, r1, pc, 174}, false, al, "al r1 pc 174", "al_r1_pc_174"},
     {{al, r1, pc, 102}, false, al, "al r1 pc 102", "al_r1_pc_102"},
     {{al, r3, pc, 148}, false, al, "al r3 pc 148", "al_r3_pc_148"},
     {{al, r6, pc, 28}, false, al, "al r6 pc 28", "al_r6_pc_28"},
     {{al, r4, pc, 127}, false, al, "al r4 pc 127", "al_r4_pc_127"},
     {{al, r5, pc, 237}, false, al, "al r5 pc 237", "al_r5_pc_237"},
     {{al, r4, pc, 215}, false, al, "al r4 pc 215", "al_r4_pc_215"},
     {{al, r2, pc, 80}, false, al, "al r2 pc 80", "al_r2_pc_80"},
     {{al, r4, pc, 160}, false, al, "al r4 pc 160", "al_r4_pc_160"},
     {{al, r5, pc, 132}, false, al, "al r5 pc 132", "al_r5_pc_132"},
     {{al, r6, pc, 158}, false, al, "al r6 pc 158", "al_r6_pc_158"},
     {{al, r4, pc, 139}, false, al, "al r4 pc 139", "al_r4_pc_139"},
     {{al, r7, pc, 218}, false, al, "al r7 pc 218", "al_r7_pc_218"},
     {{al, r5, pc, 1}, false, al, "al r5 pc 1", "al_r5_pc_1"},
     {{al, r1, pc, 106}, false, al, "al r1 pc 106", "al_r1_pc_106"},
     {{al, r0, pc, 36}, false, al, "al r0 pc 36", "al_r0_pc_36"},
     {{al, r2, pc, 186}, false, al, "al r2 pc 186", "al_r2_pc_186"},
     {{al, r1, pc, 217}, false, al, "al r1 pc 217", "al_r1_pc_217"},
     {{al, r2, pc, 110}, false, al, "al r2 pc 110", "al_r2_pc_110"},
     {{al, r4, pc, 22}, false, al, "al r4 pc 22", "al_r4_pc_22"},
     {{al, r1, pc, 44}, false, al, "al r1 pc 44", "al_r1_pc_44"},
     {{al, r5, pc, 70}, false, al, "al r5 pc 70", "al_r5_pc_70"},
     {{al, r3, pc, 222}, false, al, "al r3 pc 222", "al_r3_pc_222"},
     {{al, r1, pc, 45}, false, al, "al r1 pc 45", "al_r1_pc_45"},
     {{al, r2, pc, 152}, false, al, "al r2 pc 152", "al_r2_pc_152"},
     {{al, r1, pc, 37}, false, al, "al r1 pc 37", "al_r1_pc_37"},
     {{al, r7, pc, 174}, false, al, "al r7 pc 174", "al_r7_pc_174"},
     {{al, r0, pc, 23}, false, al, "al r0 pc 23", "al_r0_pc_23"},
     {{al, r7, pc, 83}, false, al, "al r7 pc 83", "al_r7_pc_83"},
     {{al, r5, pc, 203}, false, al, "al r5 pc 203", "al_r5_pc_203"},
     {{al, r0, pc, 241}, false, al, "al r0 pc 241", "al_r0_pc_241"},
     {{al, r1, pc, 89}, false, al, "al r1 pc 89", "al_r1_pc_89"},
     {{al, r6, pc, 145}, false, al, "al r6 pc 145", "al_r6_pc_145"},
     {{al, r5, pc, 91}, false, al, "al r5 pc 91", "al_r5_pc_91"},
     {{al, r2, pc, 15}, false, al, "al r2 pc 15", "al_r2_pc_15"},
     {{al, r4, pc, 8}, false, al, "al r4 pc 8", "al_r4_pc_8"},
     {{al, r5, pc, 53}, false, al, "al r5 pc 53", "al_r5_pc_53"},
     {{al, r5, pc, 173}, false, al, "al r5 pc 173", "al_r5_pc_173"},
     {{al, r2, pc, 10}, false, al, "al r2 pc 10", "al_r2_pc_10"},
     {{al, r2, pc, 175}, false, al, "al r2 pc 175", "al_r2_pc_175"},
     {{al, r7, pc, 186}, false, al, "al r7 pc 186", "al_r7_pc_186"},
     {{al, r4, pc, 66}, false, al, "al r4 pc 66", "al_r4_pc_66"},
     {{al, r3, pc, 27}, false, al, "al r3 pc 27", "al_r3_pc_27"},
     {{al, r7, pc, 99}, false, al, "al r7 pc 99", "al_r7_pc_99"},
     {{al, r0, pc, 126}, false, al, "al r0 pc 126", "al_r0_pc_126"},
     {{al, r0, pc, 130}, false, al, "al r0 pc 130", "al_r0_pc_130"},
     {{al, r7, pc, 60}, false, al, "al r7 pc 60", "al_r7_pc_60"},
     {{al, r5, pc, 2}, false, al, "al r5 pc 2", "al_r5_pc_2"},
     {{al, r3, pc, 107}, false, al, "al r3 pc 107", "al_r3_pc_107"},
     {{al, r6, pc, 113}, false, al, "al r6 pc 113", "al_r6_pc_113"},
     {{al, r2, pc, 18}, false, al, "al r2 pc 18", "al_r2_pc_18"},
     {{al, r5, pc, 219}, false, al, "al r5 pc 219", "al_r5_pc_219"},
     {{al, r6, pc, 115}, false, al, "al r6 pc 115", "al_r6_pc_115"},
     {{al, r7, pc, 159}, false, al, "al r7 pc 159", "al_r7_pc_159"},
     {{al, r7, pc, 206}, false, al, "al r7 pc 206", "al_r7_pc_206"},
     {{al, r6, pc, 193}, false, al, "al r6 pc 193", "al_r6_pc_193"},
     {{al, r4, pc, 119}, false, al, "al r4 pc 119", "al_r4_pc_119"},
     {{al, r0, pc, 98}, false, al, "al r0 pc 98", "al_r0_pc_98"},
     {{al, r5, pc, 201}, false, al, "al r5 pc 201", "al_r5_pc_201"},
     {{al, r0, pc, 182}, false, al, "al r0 pc 182", "al_r0_pc_182"},
     {{al, r4, pc, 118}, false, al, "al r4 pc 118", "al_r4_pc_118"},
     {{al, r6, pc, 18}, false, al, "al r6 pc 18", "al_r6_pc_18"},
     {{al, r0, pc, 185}, false, al, "al r0 pc 185", "al_r0_pc_185"},
     {{al, r0, pc, 106}, false, al, "al r0 pc 106", "al_r0_pc_106"},
     {{al, r0, pc, 92}, false, al, "al r0 pc 92", "al_r0_pc_92"},
     {{al, r5, pc, 215}, false, al, "al r5 pc 215", "al_r5_pc_215"},
     {{al, r0, pc, 153}, false, al, "al r0 pc 153", "al_r0_pc_153"},
     {{al, r5, pc, 75}, false, al, "al r5 pc 75", "al_r5_pc_75"},
     {{al, r6, pc, 211}, false, al, "al r6 pc 211", "al_r6_pc_211"},
     {{al, r0, pc, 244}, false, al, "al r0 pc 244", "al_r0_pc_244"},
     {{al, r0, pc, 255}, false, al, "al r0 pc 255", "al_r0_pc_255"},
     {{al, r7, pc, 100}, false, al, "al r7 pc 100", "al_r7_pc_100"},
     {{al, r7, pc, 105}, false, al, "al r7 pc 105", "al_r7_pc_105"},
     {{al, r3, pc, 243}, false, al, "al r3 pc 243", "al_r3_pc_243"},
     {{al, r3, pc, 120}, false, al, "al r3 pc 120", "al_r3_pc_120"},
     {{al, r0, pc, 143}, false, al, "al r0 pc 143", "al_r0_pc_143"},
     {{al, r5, pc, 45}, false, al, "al r5 pc 45", "al_r5_pc_45"},
     {{al, r6, pc, 205}, false, al, "al r6 pc 205", "al_r6_pc_205"},
     {{al, r3, pc, 200}, false, al, "al r3 pc 200", "al_r3_pc_200"},
     {{al, r6, pc, 167}, false, al, "al r6 pc 167", "al_r6_pc_167"},
     {{al, r6, pc, 220}, false, al, "al r6 pc 220", "al_r6_pc_220"},
     {{al, r3, pc, 216}, false, al, "al r3 pc 216", "al_r3_pc_216"},
     {{al, r2, pc, 217}, false, al, "al r2 pc 217", "al_r2_pc_217"},
     {{al, r2, pc, 67}, false, al, "al r2 pc 67", "al_r2_pc_67"},
     {{al, r0, pc, 119}, false, al, "al r0 pc 119", "al_r0_pc_119"},
     {{al, r2, pc, 130}, false, al, "al r2 pc 130", "al_r2_pc_130"},
     {{al, r6, pc, 97}, false, al, "al r6 pc 97", "al_r6_pc_97"},
     {{al, r1, pc, 35}, false, al, "al r1 pc 35", "al_r1_pc_35"},
     {{al, r5, pc, 243}, false, al, "al r5 pc 243", "al_r5_pc_243"},
     {{al, r7, pc, 222}, false, al, "al r7 pc 222", "al_r7_pc_222"},
     {{al, r7, pc, 56}, false, al, "al r7 pc 56", "al_r7_pc_56"},
     {{al, r4, pc, 52}, false, al, "al r4 pc 52", "al_r4_pc_52"},
     {{al, r3, pc, 4}, false, al, "al r3 pc 4", "al_r3_pc_4"},
     {{al, r2, pc, 119}, false, al, "al r2 pc 119", "al_r2_pc_119"},
     {{al, r7, pc, 212}, false, al, "al r7 pc 212", "al_r7_pc_212"},
     {{al, r0, pc, 195}, false, al, "al r0 pc 195", "al_r0_pc_195"},
     {{al, r3, pc, 232}, false, al, "al r3 pc 232", "al_r3_pc_232"},
     {{al, r3, pc, 98}, false, al, "al r3 pc 98", "al_r3_pc_98"},
     {{al, r4, pc, 149}, false, al, "al r4 pc 149", "al_r4_pc_149"},
     {{al, r0, pc, 233}, false, al, "al r0 pc 233", "al_r0_pc_233"},
     {{al, r6, pc, 247}, false, al, "al r6 pc 247", "al_r6_pc_247"},
     {{al, r2, pc, 113}, false, al, "al r2 pc 113", "al_r2_pc_113"},
     {{al, r4, pc, 104}, false, al, "al r4 pc 104", "al_r4_pc_104"},
     {{al, r5, pc, 195}, false, al, "al r5 pc 195", "al_r5_pc_195"},
     {{al, r0, pc, 9}, false, al, "al r0 pc 9", "al_r0_pc_9"},
     {{al, r1, pc, 16}, false, al, "al r1 pc 16", "al_r1_pc_16"},
     {{al, r2, pc, 126}, false, al, "al r2 pc 126", "al_r2_pc_126"},
     {{al, r5, pc, 223}, false, al, "al r5 pc 223", "al_r5_pc_223"},
     {{al, r2, pc, 94}, false, al, "al r2 pc 94", "al_r2_pc_94"},
     {{al, r4, pc, 57}, false, al, "al r4 pc 57", "al_r4_pc_57"},
     {{al, r0, pc, 68}, false, al, "al r0 pc 68", "al_r0_pc_68"},
     {{al, r6, pc, 216}, false, al, "al r6 pc 216", "al_r6_pc_216"},
     {{al, r6, pc, 88}, false, al, "al r6 pc 88", "al_r6_pc_88"},
     {{al, r2, pc, 196}, false, al, "al r2 pc 196", "al_r2_pc_196"},
     {{al, r4, pc, 132}, false, al, "al r4 pc 132", "al_r4_pc_132"},
     {{al, r4, pc, 90}, false, al, "al r4 pc 90", "al_r4_pc_90"},
     {{al, r0, pc, 66}, false, al, "al r0 pc 66", "al_r0_pc_66"},
     {{al, r7, pc, 180}, false, al, "al r7 pc 180", "al_r7_pc_180"},
     {{al, r3, pc, 53}, false, al, "al r3 pc 53", "al_r3_pc_53"},
     {{al, r7, pc, 189}, false, al, "al r7 pc 189", "al_r7_pc_189"},
     {{al, r1, pc, 145}, false, al, "al r1 pc 145", "al_r1_pc_145"},
     {{al, r3, pc, 83}, false, al, "al r3 pc 83", "al_r3_pc_83"},
     {{al, r4, pc, 206}, false, al, "al r4 pc 206", "al_r4_pc_206"},
     {{al, r4, pc, 184}, false, al, "al r4 pc 184", "al_r4_pc_184"},
     {{al, r4, pc, 173}, false, al, "al r4 pc 173", "al_r4_pc_173"},
     {{al, r1, pc, 162}, false, al, "al r1 pc 162", "al_r1_pc_162"},
     {{al, r3, pc, 35}, false, al, "al r3 pc 35", "al_r3_pc_35"},
     {{al, r7, pc, 129}, false, al, "al r7 pc 129", "al_r7_pc_129"},
     {{al, r7, pc, 4}, false, al, "al r7 pc 4", "al_r7_pc_4"},
     {{al, r2, pc, 163}, false, al, "al r2 pc 163", "al_r2_pc_163"},
     {{al, r6, pc, 29}, false, al, "al r6 pc 29", "al_r6_pc_29"},
     {{al, r3, pc, 28}, false, al, "al r3 pc 28", "al_r3_pc_28"},
     {{al, r7, pc, 176}, false, al, "al r7 pc 176", "al_r7_pc_176"},
     {{al, r7, pc, 0}, false, al, "al r7 pc 0", "al_r7_pc_0"},
     {{al, r2, pc, 84}, false, al, "al r2 pc 84", "al_r2_pc_84"},
     {{al, r6, pc, 232}, false, al, "al r6 pc 232", "al_r6_pc_232"},
     {{al, r0, pc, 77}, false, al, "al r0 pc 77", "al_r0_pc_77"},
     {{al, r5, pc, 230}, false, al, "al r5 pc 230", "al_r5_pc_230"},
     {{al, r5, pc, 102}, false, al, "al r5 pc 102", "al_r5_pc_102"},
     {{al, r6, pc, 177}, false, al, "al r6 pc 177", "al_r6_pc_177"},
     {{al, r3, pc, 111}, false, al, "al r3 pc 111", "al_r3_pc_111"},
     {{al, r0, pc, 57}, false, al, "al r0 pc 57", "al_r0_pc_57"},
     {{al, r3, pc, 85}, false, al, "al r3 pc 85", "al_r3_pc_85"},
     {{al, r0, pc, 240}, false, al, "al r0 pc 240", "al_r0_pc_240"},
     {{al, r6, pc, 125}, false, al, "al r6 pc 125", "al_r6_pc_125"},
     {{al, r3, pc, 14}, false, al, "al r3 pc 14", "al_r3_pc_14"},
     {{al, r5, pc, 14}, false, al, "al r5 pc 14", "al_r5_pc_14"},
     {{al, r2, pc, 199}, false, al, "al r2 pc 199", "al_r2_pc_199"},
     {{al, r1, pc, 155}, false, al, "al r1 pc 155", "al_r1_pc_155"},
     {{al, r6, pc, 248}, false, al, "al r6 pc 248", "al_r6_pc_248"},
     {{al, r7, pc, 54}, false, al, "al r7 pc 54", "al_r7_pc_54"},
     {{al, r3, pc, 228}, false, al, "al r3 pc 228", "al_r3_pc_228"},
     {{al, r2, pc, 221}, false, al, "al r2 pc 221", "al_r2_pc_221"},
     {{al, r4, pc, 176}, false, al, "al r4 pc 176", "al_r4_pc_176"},
     {{al, r7, pc, 194}, false, al, "al r7 pc 194", "al_r7_pc_194"},
     {{al, r2, pc, 52}, false, al, "al r2 pc 52", "al_r2_pc_52"},
     {{al, r3, pc, 46}, false, al, "al r3 pc 46", "al_r3_pc_46"},
     {{al, r1, pc, 163}, false, al, "al r1 pc 163", "al_r1_pc_163"},
     {{al, r0, pc, 247}, false, al, "al r0 pc 247", "al_r0_pc_247"},
     {{al, r5, pc, 87}, false, al, "al r5 pc 87", "al_r5_pc_87"},
     {{al, r6, pc, 6}, false, al, "al r6 pc 6", "al_r6_pc_6"},
     {{al, r6, pc, 181}, false, al, "al r6 pc 181", "al_r6_pc_181"},
     {{al, r6, pc, 37}, false, al, "al r6 pc 37", "al_r6_pc_37"},
     {{al, r1, pc, 158}, false, al, "al r1 pc 158", "al_r1_pc_158"},
     {{al, r6, pc, 187}, false, al, "al r6 pc 187", "al_r6_pc_187"},
     {{al, r3, pc, 215}, false, al, "al r3 pc 215", "al_r3_pc_215"},
     {{al, r4, pc, 45}, false, al, "al r4 pc 45", "al_r4_pc_45"},
     {{al, r4, pc, 124}, false, al, "al r4 pc 124", "al_r4_pc_124"},
     {{al, r7, pc, 127}, false, al, "al r7 pc 127", "al_r7_pc_127"},
     {{al, r3, pc, 194}, false, al, "al r3 pc 194", "al_r3_pc_194"},
     {{al, r0, pc, 159}, false, al, "al r0 pc 159", "al_r0_pc_159"},
     {{al, r2, pc, 241}, false, al, "al r2 pc 241", "al_r2_pc_241"},
     {{al, r5, pc, 84}, false, al, "al r5 pc 84", "al_r5_pc_84"},
     {{al, r2, pc, 149}, false, al, "al r2 pc 149", "al_r2_pc_149"},
     {{al, r3, pc, 171}, false, al, "al r3 pc 171", "al_r3_pc_171"},
     {{al, r3, pc, 143}, false, al, "al r3 pc 143", "al_r3_pc_143"},
     {{al, r0, pc, 85}, false, al, "al r0 pc 85", "al_r0_pc_85"},
     {{al, r1, pc, 134}, false, al, "al r1 pc 134", "al_r1_pc_134"},
     {{al, r1, pc, 39}, false, al, "al r1 pc 39", "al_r1_pc_39"},
     {{al, r6, pc, 200}, false, al, "al r6 pc 200", "al_r6_pc_200"},
     {{al, r5, pc, 110}, false, al, "al r5 pc 110", "al_r5_pc_110"},
     {{al, r6, pc, 35}, false, al, "al r6 pc 35", "al_r6_pc_35"},
     {{al, r7, pc, 237}, false, al, "al r7 pc 237", "al_r7_pc_237"},
     {{al, r0, pc, 42}, false, al, "al r0 pc 42", "al_r0_pc_42"},
     {{al, r2, pc, 36}, false, al, "al r2 pc 36", "al_r2_pc_36"},
     {{al, r4, pc, 55}, false, al, "al r4 pc 55", "al_r4_pc_55"},
     {{al, r2, pc, 5}, false, al, "al r2 pc 5", "al_r2_pc_5"},
     {{al, r2, pc, 103}, false, al, "al r2 pc 103", "al_r2_pc_103"},
     {{al, r7, pc, 104}, false, al, "al r7 pc 104", "al_r7_pc_104"},
     {{al, r1, pc, 116}, false, al, "al r1 pc 116", "al_r1_pc_116"},
     {{al, r1, pc, 156}, false, al, "al r1 pc 156", "al_r1_pc_156"},
     {{al, r6, pc, 100}, false, al, "al r6 pc 100", "al_r6_pc_100"},
     {{al, r6, pc, 108}, false, al, "al r6 pc 108", "al_r6_pc_108"},
     {{al, r0, pc, 237}, false, al, "al r0 pc 237", "al_r0_pc_237"},
     {{al, r5, pc, 182}, false, al, "al r5 pc 182", "al_r5_pc_182"},
     {{al, r1, pc, 189}, false, al, "al r1 pc 189", "al_r1_pc_189"},
     {{al, r6, pc, 16}, false, al, "al r6 pc 16", "al_r6_pc_16"},
     {{al, r5, pc, 184}, false, al, "al r5 pc 184", "al_r5_pc_184"},
     {{al, r3, pc, 67}, false, al, "al r3 pc 67", "al_r3_pc_67"},
     {{al, r2, pc, 107}, false, al, "al r2 pc 107", "al_r2_pc_107"},
     {{al, r1, pc, 182}, false, al, "al r1 pc 182", "al_r1_pc_182"},
     {{al, r7, pc, 69}, false, al, "al r7 pc 69", "al_r7_pc_69"},
     {{al, r3, pc, 164}, false, al, "al r3 pc 164", "al_r3_pc_164"},
     {{al, r7, pc, 119}, false, al, "al r7 pc 119", "al_r7_pc_119"},
     {{al, r4, pc, 239}, false, al, "al r4 pc 239", "al_r4_pc_239"},
     {{al, r7, pc, 11}, false, al, "al r7 pc 11", "al_r7_pc_11"},
     {{al, r0, pc, 138}, false, al, "al r0 pc 138", "al_r0_pc_138"},
     {{al, r1, pc, 59}, false, al, "al r1 pc 59", "al_r1_pc_59"},
     {{al, r4, pc, 157}, false, al, "al r4 pc 157", "al_r4_pc_157"},
     {{al, r0, pc, 177}, false, al, "al r0 pc 177", "al_r0_pc_177"},
     {{al, r7, pc, 214}, false, al, "al r7 pc 214", "al_r7_pc_214"},
     {{al, r1, pc, 157}, false, al, "al r1 pc 157", "al_r1_pc_157"},
     {{al, r6, pc, 227}, false, al, "al r6 pc 227", "al_r6_pc_227"},
     {{al, r1, pc, 85}, false, al, "al r1 pc 85", "al_r1_pc_85"},
     {{al, r5, pc, 85}, false, al, "al r5 pc 85", "al_r5_pc_85"},
     {{al, r4, pc, 234}, false, al, "al r4 pc 234", "al_r4_pc_234"},
     {{al, r0, pc, 7}, false, al, "al r0 pc 7", "al_r0_pc_7"},
     {{al, r1, pc, 61}, false, al, "al r1 pc 61", "al_r1_pc_61"},
     {{al, r6, pc, 154}, false, al, "al r6 pc 154", "al_r6_pc_154"},
     {{al, r0, pc, 19}, false, al, "al r0 pc 19", "al_r0_pc_19"},
     {{al, r7, pc, 200}, false, al, "al r7 pc 200", "al_r7_pc_200"},
     {{al, r0, pc, 223}, false, al, "al r0 pc 223", "al_r0_pc_223"},
     {{al, r0, pc, 187}, false, al, "al r0 pc 187", "al_r0_pc_187"},
     {{al, r2, pc, 213}, false, al, "al r2 pc 213", "al_r2_pc_213"},
     {{al, r4, pc, 42}, false, al, "al r4 pc 42", "al_r4_pc_42"},
     {{al, r6, pc, 217}, false, al, "al r6 pc 217", "al_r6_pc_217"},
     {{al, r7, pc, 45}, false, al, "al r7 pc 45", "al_r7_pc_45"},
     {{al, r3, pc, 124}, false, al, "al r3 pc 124", "al_r3_pc_124"},
     {{al, r0, pc, 102}, false, al, "al r0 pc 102", "al_r0_pc_102"},
     {{al, r3, pc, 96}, false, al, "al r3 pc 96", "al_r3_pc_96"},
     {{al, r7, pc, 114}, false, al, "al r7 pc 114", "al_r7_pc_114"},
     {{al, r3, pc, 139}, false, al, "al r3 pc 139", "al_r3_pc_139"},
     {{al, r6, pc, 241}, false, al, "al r6 pc 241", "al_r6_pc_241"},
     {{al, r7, pc, 199}, false, al, "al r7 pc 199", "al_r7_pc_199"},
     {{al, r0, pc, 13}, false, al, "al r0 pc 13", "al_r0_pc_13"},
     {{al, r5, pc, 109}, false, al, "al r5 pc 109", "al_r5_pc_109"},
     {{al, r1, pc, 50}, false, al, "al r1 pc 50", "al_r1_pc_50"},
     {{al, r5, pc, 62}, false, al, "al r5 pc 62", "al_r5_pc_62"},
     {{al, r5, pc, 136}, false, al, "al r5 pc 136", "al_r5_pc_136"},
     {{al, r7, pc, 133}, false, al, "al r7 pc 133", "al_r7_pc_133"},
     {{al, r1, pc, 150}, false, al, "al r1 pc 150", "al_r1_pc_150"},
     {{al, r3, pc, 100}, false, al, "al r3 pc 100", "al_r3_pc_100"},
     {{al, r3, pc, 129}, false, al, "al r3 pc 129", "al_r3_pc_129"},
     {{al, r4, pc, 105}, false, al, "al r4 pc 105", "al_r4_pc_105"},
     {{al, r3, pc, 133}, false, al, "al r3 pc 133", "al_r3_pc_133"},
     {{al, r1, pc, 225}, false, al, "al r1 pc 225", "al_r1_pc_225"},
     {{al, r3, pc, 130}, false, al, "al r3 pc 130", "al_r3_pc_130"},
     {{al, r0, pc, 209}, false, al, "al r0 pc 209", "al_r0_pc_209"},
     {{al, r2, pc, 14}, false, al, "al r2 pc 14", "al_r2_pc_14"},
     {{al, r0, pc, 72}, false, al, "al r0 pc 72", "al_r0_pc_72"},
     {{al, r7, pc, 221}, false, al, "al r7 pc 221", "al_r7_pc_221"},
     {{al, r4, pc, 4}, false, al, "al r4 pc 4", "al_r4_pc_4"},
     {{al, r7, pc, 112}, false, al, "al r7 pc 112", "al_r7_pc_112"},
     {{al, r6, pc, 59}, false, al, "al r6 pc 59", "al_r6_pc_59"},
     {{al, r3, pc, 140}, false, al, "al r3 pc 140", "al_r3_pc_140"},
     {{al, r1, pc, 186}, false, al, "al r1 pc 186", "al_r1_pc_186"},
     {{al, r3, pc, 61}, false, al, "al r3 pc 61", "al_r3_pc_61"},
     {{al, r1, pc, 32}, false, al, "al r1 pc 32", "al_r1_pc_32"},
     {{al, r3, pc, 42}, false, al, "al r3 pc 42", "al_r3_pc_42"},
     {{al, r3, pc, 72}, false, al, "al r3 pc 72", "al_r3_pc_72"},
     {{al, r0, pc, 152}, false, al, "al r0 pc 152", "al_r0_pc_152"},
     {{al, r5, pc, 104}, false, al, "al r5 pc 104", "al_r5_pc_104"},
     {{al, r1, pc, 136}, false, al, "al r1 pc 136", "al_r1_pc_136"},
     {{al, r7, pc, 161}, false, al, "al r7 pc 161", "al_r7_pc_161"},
     {{al, r1, pc, 188}, false, al, "al r1 pc 188", "al_r1_pc_188"},
     {{al, r1, pc, 42}, false, al, "al r1 pc 42", "al_r1_pc_42"},
     {{al, r4, pc, 145}, false, al, "al r4 pc 145", "al_r4_pc_145"},
     {{al, r3, pc, 75}, false, al, "al r3 pc 75", "al_r3_pc_75"},
     {{al, r1, pc, 219}, false, al, "al r1 pc 219", "al_r1_pc_219"},
     {{al, r4, pc, 133}, false, al, "al r4 pc 133", "al_r4_pc_133"},
     {{al, r1, pc, 176}, false, al, "al r1 pc 176", "al_r1_pc_176"},
     {{al, r5, pc, 73}, false, al, "al r5 pc 73", "al_r5_pc_73"},
     {{al, r6, pc, 127}, false, al, "al r6 pc 127", "al_r6_pc_127"},
     {{al, r4, pc, 40}, false, al, "al r4 pc 40", "al_r4_pc_40"},
     {{al, r0, pc, 89}, false, al, "al r0 pc 89", "al_r0_pc_89"},
     {{al, r4, pc, 125}, false, al, "al r4 pc 125", "al_r4_pc_125"},
     {{al, r0, pc, 124}, false, al, "al r0 pc 124", "al_r0_pc_124"},
     {{al, r5, pc, 212}, false, al, "al r5 pc 212", "al_r5_pc_212"},
     {{al, r1, pc, 121}, false, al, "al r1 pc 121", "al_r1_pc_121"},
     {{al, r4, pc, 181}, false, al, "al r4 pc 181", "al_r4_pc_181"},
     {{al, r6, pc, 2}, false, al, "al r6 pc 2", "al_r6_pc_2"},
     {{al, r7, pc, 51}, false, al, "al r7 pc 51", "al_r7_pc_51"},
     {{al, r7, pc, 39}, false, al, "al r7 pc 39", "al_r7_pc_39"},
     {{al, r4, pc, 178}, false, al, "al r4 pc 178", "al_r4_pc_178"},
     {{al, r7, pc, 121}, false, al, "al r7 pc 121", "al_r7_pc_121"},
     {{al, r5, pc, 29}, false, al, "al r5 pc 29", "al_r5_pc_29"},
     {{al, r6, pc, 105}, false, al, "al r6 pc 105", "al_r6_pc_105"},
     {{al, r5, pc, 234}, false, al, "al r5 pc 234", "al_r5_pc_234"},
     {{al, r6, pc, 50}, false, al, "al r6 pc 50", "al_r6_pc_50"},
     {{al, r3, pc, 183}, false, al, "al r3 pc 183", "al_r3_pc_183"},
     {{al, r2, pc, 121}, false, al, "al r2 pc 121", "al_r2_pc_121"},
     {{al, r1, pc, 213}, false, al, "al r1 pc 213", "al_r1_pc_213"},
     {{al, r1, pc, 168}, false, al, "al r1 pc 168", "al_r1_pc_168"},
     {{al, r1, pc, 153}, false, al, "al r1 pc 153", "al_r1_pc_153"},
     {{al, r6, pc, 254}, false, al, "al r6 pc 254", "al_r6_pc_254"},
     {{al, r4, pc, 112}, false, al, "al r4 pc 112", "al_r4_pc_112"},
     {{al, r4, pc, 162}, false, al, "al r4 pc 162", "al_r4_pc_162"},
     {{al, r5, pc, 253}, false, al, "al r5 pc 253", "al_r5_pc_253"},
     {{al, r6, pc, 22}, false, al, "al r6 pc 22", "al_r6_pc_22"},
     {{al, r6, pc, 128}, false, al, "al r6 pc 128", "al_r6_pc_128"},
     {{al, r5, pc, 248}, false, al, "al r5 pc 248", "al_r5_pc_248"},
     {{al, r2, pc, 239}, false, al, "al r2 pc 239", "al_r2_pc_239"},
     {{al, r1, pc, 223}, false, al, "al r1 pc 223", "al_r1_pc_223"},
     {{al, r7, pc, 93}, false, al, "al r7 pc 93", "al_r7_pc_93"},
     {{al, r4, pc, 91}, false, al, "al r4 pc 91", "al_r4_pc_91"},
     {{al, r3, pc, 26}, false, al, "al r3 pc 26", "al_r3_pc_26"},
     {{al, r4, pc, 21}, false, al, "al r4 pc 21", "al_r4_pc_21"},
     {{al, r3, pc, 0}, false, al, "al r3 pc 0", "al_r3_pc_0"},
     {{al, r0, pc, 216}, false, al, "al r0 pc 216", "al_r0_pc_216"},
     {{al, r7, pc, 86}, false, al, "al r7 pc 86", "al_r7_pc_86"},
     {{al, r2, pc, 114}, false, al, "al r2 pc 114", "al_r2_pc_114"},
     {{al, r1, pc, 55}, false, al, "al r1 pc 55", "al_r1_pc_55"},
     {{al, r1, pc, 154}, false, al, "al r1 pc 154", "al_r1_pc_154"},
     {{al, r1, pc, 159}, false, al, "al r1 pc 159", "al_r1_pc_159"},
     {{al, r6, pc, 93}, false, al, "al r6 pc 93", "al_r6_pc_93"},
     {{al, r1, pc, 184}, false, al, "al r1 pc 184", "al_r1_pc_184"},
     {{al, r2, pc, 83}, false, al, "al r2 pc 83", "al_r2_pc_83"},
     {{al, r7, pc, 208}, false, al, "al r7 pc 208", "al_r7_pc_208"},
     {{al, r2, pc, 124}, false, al, "al r2 pc 124", "al_r2_pc_124"},
     {{al, r5, pc, 254}, false, al, "al r5 pc 254", "al_r5_pc_254"},
     {{al, r2, pc, 139}, false, al, "al r2 pc 139", "al_r2_pc_139"},
     {{al, r4, pc, 48}, false, al, "al r4 pc 48", "al_r4_pc_48"},
     {{al, r1, pc, 15}, false, al, "al r1 pc 15", "al_r1_pc_15"},
     {{al, r7, pc, 87}, false, al, "al r7 pc 87", "al_r7_pc_87"},
     {{al, r0, pc, 27}, false, al, "al r0 pc 27", "al_r0_pc_27"},
     {{al, r1, pc, 80}, false, al, "al r1 pc 80", "al_r1_pc_80"},
     {{al, r6, pc, 91}, false, al, "al r6 pc 91", "al_r6_pc_91"},
     {{al, r2, pc, 166}, false, al, "al r2 pc 166", "al_r2_pc_166"},
     {{al, r5, pc, 242}, false, al, "al r5 pc 242", "al_r5_pc_242"},
     {{al, r5, pc, 229}, false, al, "al r5 pc 229", "al_r5_pc_229"},
     {{al, r1, pc, 7}, false, al, "al r1 pc 7", "al_r1_pc_7"},
     {{al, r1, pc, 96}, false, al, "al r1 pc 96", "al_r1_pc_96"},
     {{al, r3, pc, 56}, false, al, "al r3 pc 56", "al_r3_pc_56"},
     {{al, r2, pc, 179}, false, al, "al r2 pc 179", "al_r2_pc_179"},
     {{al, r4, pc, 27}, false, al, "al r4 pc 27", "al_r4_pc_27"},
     {{al, r4, pc, 12}, false, al, "al r4 pc 12", "al_r4_pc_12"},
     {{al, r2, pc, 79}, false, al, "al r2 pc 79", "al_r2_pc_79"},
     {{al, r5, pc, 247}, false, al, "al r5 pc 247", "al_r5_pc_247"},
     {{al, r0, pc, 18}, false, al, "al r0 pc 18", "al_r0_pc_18"},
     {{al, r5, pc, 205}, false, al, "al r5 pc 205", "al_r5_pc_205"},
     {{al, r2, pc, 66}, false, al, "al r2 pc 66", "al_r2_pc_66"},
     {{al, r0, pc, 133}, false, al, "al r0 pc 133", "al_r0_pc_133"},
     {{al, r6, pc, 58}, false, al, "al r6 pc 58", "al_r6_pc_58"},
     {{al, r5, pc, 32}, false, al, "al r5 pc 32", "al_r5_pc_32"},
     {{al, r0, pc, 99}, false, al, "al r0 pc 99", "al_r0_pc_99"},
     {{al, r2, pc, 32}, false, al, "al r2 pc 32", "al_r2_pc_32"},
     {{al, r3, pc, 89}, false, al, "al r3 pc 89", "al_r3_pc_89"},
     {{al, r6, pc, 114}, false, al, "al r6 pc 114", "al_r6_pc_114"},
     {{al, r2, pc, 100}, false, al, "al r2 pc 100", "al_r2_pc_100"},
     {{al, r1, pc, 82}, false, al, "al r1 pc 82", "al_r1_pc_82"},
     {{al, r2, pc, 210}, false, al, "al r2 pc 210", "al_r2_pc_210"},
     {{al, r2, pc, 29}, false, al, "al r2 pc 29", "al_r2_pc_29"},
     {{al, r6, pc, 20}, false, al, "al r6 pc 20", "al_r6_pc_20"},
     {{al, r0, pc, 120}, false, al, "al r0 pc 120", "al_r0_pc_120"},
     {{al, r6, pc, 75}, false, al, "al r6 pc 75", "al_r6_pc_75"},
     {{al, r5, pc, 164}, false, al, "al r5 pc 164", "al_r5_pc_164"},
     {{al, r6, pc, 32}, false, al, "al r6 pc 32", "al_r6_pc_32"},
     {{al, r7, pc, 59}, false, al, "al r7 pc 59", "al_r7_pc_59"},
     {{al, r0, pc, 71}, false, al, "al r0 pc 71", "al_r0_pc_71"},
     {{al, r6, pc, 98}, false, al, "al r6 pc 98", "al_r6_pc_98"},
     {{al, r0, pc, 236}, false, al, "al r0 pc 236", "al_r0_pc_236"},
     {{al, r4, pc, 25}, false, al, "al r4 pc 25", "al_r4_pc_25"},
     {{al, r1, pc, 131}, false, al, "al r1 pc 131", "al_r1_pc_131"},
     {{al, r2, pc, 215}, false, al, "al r2 pc 215", "al_r2_pc_215"},
     {{al, r5, pc, 44}, false, al, "al r5 pc 44", "al_r5_pc_44"},
     {{al, r3, pc, 226}, false, al, "al r3 pc 226", "al_r3_pc_226"},
     {{al, r1, pc, 34}, false, al, "al r1 pc 34", "al_r1_pc_34"},
     {{al, r0, pc, 96}, false, al, "al r0 pc 96", "al_r0_pc_96"},
     {{al, r4, pc, 245}, false, al, "al r4 pc 245", "al_r4_pc_245"},
     {{al, r1, pc, 140}, false, al, "al r1 pc 140", "al_r1_pc_140"},
     {{al, r6, pc, 83}, false, al, "al r6 pc 83", "al_r6_pc_83"},
     {{al, r5, pc, 168}, false, al, "al r5 pc 168", "al_r5_pc_168"},
     {{al, r6, pc, 183}, false, al, "al r6 pc 183", "al_r6_pc_183"},
     {{al, r6, pc, 9}, false, al, "al r6 pc 9", "al_r6_pc_9"},
     {{al, r7, pc, 110}, false, al, "al r7 pc 110", "al_r7_pc_110"},
     {{al, r6, pc, 30}, false, al, "al r6 pc 30", "al_r6_pc_30"},
     {{al, r3, pc, 253}, false, al, "al r3 pc 253", "al_r3_pc_253"},
     {{al, r2, pc, 3}, false, al, "al r2 pc 3", "al_r2_pc_3"},
     {{al, r3, pc, 177}, false, al, "al r3 pc 177", "al_r3_pc_177"},
     {{al, r5, pc, 159}, false, al, "al r5 pc 159", "al_r5_pc_159"},
     {{al, r0, pc, 110}, false, al, "al r0 pc 110", "al_r0_pc_110"},
     {{al, r7, pc, 255}, false, al, "al r7 pc 255", "al_r7_pc_255"},
     {{al, r5, pc, 9}, false, al, "al r5 pc 9", "al_r5_pc_9"},
     {{al, r3, pc, 138}, false, al, "al r3 pc 138", "al_r3_pc_138"},
     {{al, r0, pc, 10}, false, al, "al r0 pc 10", "al_r0_pc_10"},
     {{al, r2, pc, 225}, false, al, "al r2 pc 225", "al_r2_pc_225"},
     {{al, r3, pc, 70}, false, al, "al r3 pc 70", "al_r3_pc_70"},
     {{al, r4, pc, 76}, false, al, "al r4 pc 76", "al_r4_pc_76"},
     {{al, r2, pc, 105}, false, al, "al r2 pc 105", "al_r2_pc_105"},
     {{al, r4, pc, 137}, false, al, "al r4 pc 137", "al_r4_pc_137"},
     {{al, r4, pc, 5}, false, al, "al r4 pc 5", "al_r4_pc_5"},
     {{al, r4, pc, 18}, false, al, "al r4 pc 18", "al_r4_pc_18"},
     {{al, r5, pc, 174}, false, al, "al r5 pc 174", "al_r5_pc_174"},
     {{al, r3, pc, 146}, false, al, "al r3 pc 146", "al_r3_pc_146"},
     {{al, r1, pc, 201}, false, al, "al r1 pc 201", "al_r1_pc_201"},
     {{al, r7, pc, 46}, false, al, "al r7 pc 46", "al_r7_pc_46"},
     {{al, r4, pc, 37}, false, al, "al r4 pc 37", "al_r4_pc_37"},
     {{al, r0, pc, 69}, false, al, "al r0 pc 69", "al_r0_pc_69"},
     {{al, r2, pc, 188}, false, al, "al r2 pc 188", "al_r2_pc_188"},
     {{al, r1, pc, 68}, false, al, "al r1 pc 68", "al_r1_pc_68"},
     {{al, r3, pc, 3}, false, al, "al r3 pc 3", "al_r3_pc_3"},
     {{al, r2, pc, 211}, false, al, "al r2 pc 211", "al_r2_pc_211"},
     {{al, r3, pc, 137}, false, al, "al r3 pc 137", "al_r3_pc_137"},
     {{al, r5, pc, 129}, false, al, "al r5 pc 129", "al_r5_pc_129"},
     {{al, r3, pc, 241}, false, al, "al r3 pc 241", "al_r3_pc_241"},
     {{al, r7, pc, 184}, false, al, "al r7 pc 184", "al_r7_pc_184"},
     {{al, r6, pc, 89}, false, al, "al r6 pc 89", "al_r6_pc_89"},
     {{al, r2, pc, 132}, false, al, "al r2 pc 132", "al_r2_pc_132"},
     {{al, r2, pc, 246}, false, al, "al r2 pc 246", "al_r2_pc_246"},
     {{al, r0, pc, 20}, false, al, "al r0 pc 20", "al_r0_pc_20"},
     {{al, r4, pc, 224}, false, al, "al r4 pc 224", "al_r4_pc_224"},
     {{al, r4, pc, 68}, false, al, "al r4 pc 68", "al_r4_pc_68"},
     {{al, r1, pc, 19}, false, al, "al r1 pc 19", "al_r1_pc_19"},
     {{al, r6, pc, 36}, false, al, "al r6 pc 36", "al_r6_pc_36"},
     {{al, r1, pc, 52}, false, al, "al r1 pc 52", "al_r1_pc_52"},
     {{al, r5, pc, 185}, false, al, "al r5 pc 185", "al_r5_pc_185"},
     {{al, r3, pc, 118}, false, al, "al r3 pc 118", "al_r3_pc_118"},
     {{al, r0, pc, 183}, false, al, "al r0 pc 183", "al_r0_pc_183"},
     {{al, r7, pc, 50}, false, al, "al r7 pc 50", "al_r7_pc_50"},
     {{al, r1, pc, 204}, false, al, "al r1 pc 204", "al_r1_pc_204"},
     {{al, r2, pc, 25}, false, al, "al r2 pc 25", "al_r2_pc_25"},
     {{al, r0, pc, 202}, false, al, "al r0 pc 202", "al_r0_pc_202"},
     {{al, r6, pc, 186}, false, al, "al r6 pc 186", "al_r6_pc_186"},
     {{al, r1, pc, 139}, false, al, "al r1 pc 139", "al_r1_pc_139"},
     {{al, r5, pc, 148}, false, al, "al r5 pc 148", "al_r5_pc_148"},
     {{al, r0, pc, 70}, false, al, "al r0 pc 70", "al_r0_pc_70"},
     {{al, r0, pc, 101}, false, al, "al r0 pc 101", "al_r0_pc_101"},
     {{al, r6, pc, 175}, false, al, "al r6 pc 175", "al_r6_pc_175"},
     {{al, r7, pc, 253}, false, al, "al r7 pc 253", "al_r7_pc_253"},
     {{al, r3, pc, 221}, false, al, "al r3 pc 221", "al_r3_pc_221"},
     {{al, r4, pc, 19}, false, al, "al r4 pc 19", "al_r4_pc_19"},
     {{al, r2, pc, 16}, false, al, "al r2 pc 16", "al_r2_pc_16"},
     {{al, r2, pc, 74}, false, al, "al r2 pc 74", "al_r2_pc_74"},
     {{al, r5, pc, 228}, false, al, "al r5 pc 228", "al_r5_pc_228"},
     {{al, r5, pc, 251}, false, al, "al r5 pc 251", "al_r5_pc_251"},
     {{al, r4, pc, 94}, false, al, "al r4 pc 94", "al_r4_pc_94"},
     {{al, r5, pc, 48}, false, al, "al r5 pc 48", "al_r5_pc_48"},
     {{al, r3, pc, 225}, false, al, "al r3 pc 225", "al_r3_pc_225"},
     {{al, r2, pc, 247}, false, al, "al r2 pc 247", "al_r2_pc_247"},
     {{al, r4, pc, 29}, false, al, "al r4 pc 29", "al_r4_pc_29"},
     {{al, r7, pc, 89}, false, al, "al r7 pc 89", "al_r7_pc_89"},
     {{al, r5, pc, 162}, false, al, "al r5 pc 162", "al_r5_pc_162"},
     {{al, r6, pc, 104}, false, al, "al r6 pc 104", "al_r6_pc_104"},
     {{al, r1, pc, 3}, false, al, "al r1 pc 3", "al_r1_pc_3"},
     {{al, r6, pc, 229}, false, al, "al r6 pc 229", "al_r6_pc_229"},
     {{al, r5, pc, 232}, false, al, "al r5 pc 232", "al_r5_pc_232"},
     {{al, r1, pc, 94}, false, al, "al r1 pc 94", "al_r1_pc_94"},
     {{al, r7, pc, 28}, false, al, "al r7 pc 28", "al_r7_pc_28"},
     {{al, r6, pc, 206}, false, al, "al r6 pc 206", "al_r6_pc_206"},
     {{al, r7, pc, 126}, false, al, "al r7 pc 126", "al_r7_pc_126"},
     {{al, r4, pc, 109}, false, al, "al r4 pc 109", "al_r4_pc_109"},
     {{al, r3, pc, 21}, false, al, "al r3 pc 21", "al_r3_pc_21"},
     {{al, r5, pc, 227}, false, al, "al r5 pc 227", "al_r5_pc_227"},
     {{al, r2, pc, 242}, false, al, "al r2 pc 242", "al_r2_pc_242"},
     {{al, r3, pc, 51}, false, al, "al r3 pc 51", "al_r3_pc_51"},
     {{al, r0, pc, 116}, false, al, "al r0 pc 116", "al_r0_pc_116"},
     {{al, r7, pc, 84}, false, al, "al r7 pc 84", "al_r7_pc_84"},
     {{al, r1, pc, 23}, false, al, "al r1 pc 23", "al_r1_pc_23"},
     {{al, r3, pc, 192}, false, al, "al r3 pc 192", "al_r3_pc_192"},
     {{al, r4, pc, 49}, false, al, "al r4 pc 49", "al_r4_pc_49"},
     {{al, r2, pc, 222}, false, al, "al r2 pc 222", "al_r2_pc_222"},
     {{al, r4, pc, 255}, false, al, "al r4 pc 255", "al_r4_pc_255"},
     {{al, r3, pc, 55}, false, al, "al r3 pc 55", "al_r3_pc_55"},
     {{al, r1, pc, 47}, false, al, "al r1 pc 47", "al_r1_pc_47"},
     {{al, r7, pc, 141}, false, al, "al r7 pc 141", "al_r7_pc_141"},
     {{al, r5, pc, 252}, false, al, "al r5 pc 252", "al_r5_pc_252"},
     {{al, r0, pc, 62}, false, al, "al r0 pc 62", "al_r0_pc_62"},
     {{al, r7, pc, 185}, false, al, "al r7 pc 185", "al_r7_pc_185"},
     {{al, r0, pc, 194}, false, al, "al r0 pc 194", "al_r0_pc_194"},
     {{al, r4, pc, 107}, false, al, "al r4 pc 107", "al_r4_pc_107"},
     {{al, r5, pc, 100}, false, al, "al r5 pc 100", "al_r5_pc_100"},
     {{al, r3, pc, 48}, false, al, "al r3 pc 48", "al_r3_pc_48"},
     {{al, r7, pc, 118}, false, al, "al r7 pc 118", "al_r7_pc_118"},
     {{al, r5, pc, 210}, false, al, "al r5 pc 210", "al_r5_pc_210"},
     {{al, r7, pc, 178}, false, al, "al r7 pc 178", "al_r7_pc_178"},
     {{al, r0, pc, 78}, false, al, "al r0 pc 78", "al_r0_pc_78"},
     {{al, r7, pc, 15}, false, al, "al r7 pc 15", "al_r7_pc_15"},
     {{al, r1, pc, 177}, false, al, "al r1 pc 177", "al_r1_pc_177"},
     {{al, r6, pc, 208}, false, al, "al r6 pc 208", "al_r6_pc_208"},
     {{al, r2, pc, 88}, false, al, "al r2 pc 88", "al_r2_pc_88"},
     {{al, r4, pc, 241}, false, al, "al r4 pc 241", "al_r4_pc_241"},
     {{al, r1, pc, 119}, false, al, "al r1 pc 119", "al_r1_pc_119"},
     {{al, r6, pc, 143}, false, al, "al r6 pc 143", "al_r6_pc_143"},
     {{al, r6, pc, 112}, false, al, "al r6 pc 112", "al_r6_pc_112"},
     {{al, r5, pc, 96}, false, al, "al r5 pc 96", "al_r5_pc_96"},
     {{al, r5, pc, 74}, false, al, "al r5 pc 74", "al_r5_pc_74"},
     {{al, r6, pc, 84}, false, al, "al r6 pc 84", "al_r6_pc_84"},
     {{al, r7, pc, 234}, false, al, "al r7 pc 234", "al_r7_pc_234"},
     {{al, r7, pc, 211}, false, al, "al r7 pc 211", "al_r7_pc_211"},
     {{al, r6, pc, 74}, false, al, "al r6 pc 74", "al_r6_pc_74"},
     {{al, r4, pc, 36}, false, al, "al r4 pc 36", "al_r4_pc_36"},
     {{al, r6, pc, 26}, false, al, "al r6 pc 26", "al_r6_pc_26"},
     {{al, r5, pc, 133}, false, al, "al r5 pc 133", "al_r5_pc_133"},
     {{al, r7, pc, 216}, false, al, "al r7 pc 216", "al_r7_pc_216"},
     {{al, r4, pc, 159}, false, al, "al r4 pc 159", "al_r4_pc_159"},
     {{al, r2, pc, 0}, false, al, "al r2 pc 0", "al_r2_pc_0"},
     {{al, r6, pc, 172}, false, al, "al r6 pc 172", "al_r6_pc_172"},
     {{al, r6, pc, 80}, false, al, "al r6 pc 80", "al_r6_pc_80"},
     {{al, r4, pc, 250}, false, al, "al r4 pc 250", "al_r4_pc_250"},
     {{al, r0, pc, 163}, false, al, "al r0 pc 163", "al_r0_pc_163"},
     {{al, r6, pc, 190}, false, al, "al r6 pc 190", "al_r6_pc_190"},
     {{al, r1, pc, 17}, false, al, "al r1 pc 17", "al_r1_pc_17"},
     {{al, r5, pc, 238}, false, al, "al r5 pc 238", "al_r5_pc_238"},
     {{al, r4, pc, 231}, false, al, "al r4 pc 231", "al_r4_pc_231"},
     {{al, r3, pc, 197}, false, al, "al r3 pc 197", "al_r3_pc_197"},
     {{al, r5, pc, 167}, false, al, "al r5 pc 167", "al_r5_pc_167"},
     {{al, r3, pc, 36}, false, al, "al r3 pc 36", "al_r3_pc_36"},
     {{al, r3, pc, 110}, false, al, "al r3 pc 110", "al_r3_pc_110"},
     {{al, r7, pc, 157}, false, al, "al r7 pc 157", "al_r7_pc_157"},
     {{al, r0, pc, 160}, false, al, "al r0 pc 160", "al_r0_pc_160"},
     {{al, r1, pc, 187}, false, al, "al r1 pc 187", "al_r1_pc_187"},
     {{al, r6, pc, 213}, false, al, "al r6 pc 213", "al_r6_pc_213"},
     {{al, r1, pc, 175}, false, al, "al r1 pc 175", "al_r1_pc_175"},
     {{al, r1, pc, 58}, false, al, "al r1 pc 58", "al_r1_pc_58"},
     {{al, r1, pc, 30}, false, al, "al r1 pc 30", "al_r1_pc_30"},
     {{al, r3, pc, 234}, false, al, "al r3 pc 234", "al_r3_pc_234"},
     {{al, r4, pc, 129}, false, al, "al r4 pc 129", "al_r4_pc_129"},
     {{al, r0, pc, 49}, false, al, "al r0 pc 49", "al_r0_pc_49"},
     {{al, r6, pc, 140}, false, al, "al r6 pc 140", "al_r6_pc_140"},
     {{al, r4, pc, 64}, false, al, "al r4 pc 64", "al_r4_pc_64"},
     {{al, r1, pc, 250}, false, al, "al r1 pc 250", "al_r1_pc_250"},
     {{al, r3, pc, 233}, false, al, "al r3 pc 233", "al_r3_pc_233"},
     {{al, r6, pc, 194}, false, al, "al r6 pc 194", "al_r6_pc_194"},
     {{al, r7, pc, 245}, false, al, "al r7 pc 245", "al_r7_pc_245"},
     {{al, r1, pc, 200}, false, al, "al r1 pc 200", "al_r1_pc_200"},
     {{al, r4, pc, 175}, false, al, "al r4 pc 175", "al_r4_pc_175"},
     {{al, r3, pc, 68}, false, al, "al r3 pc 68", "al_r3_pc_68"},
     {{al, r0, pc, 221}, false, al, "al r0 pc 221", "al_r0_pc_221"},
     {{al, r7, pc, 130}, false, al, "al r7 pc 130", "al_r7_pc_130"},
     {{al, r2, pc, 187}, false, al, "al r2 pc 187", "al_r2_pc_187"},
     {{al, r2, pc, 159}, false, al, "al r2 pc 159", "al_r2_pc_159"},
     {{al, r1, pc, 210}, false, al, "al r1 pc 210", "al_r1_pc_210"},
     {{al, r3, pc, 141}, false, al, "al r3 pc 141", "al_r3_pc_141"},
     {{al, r2, pc, 148}, false, al, "al r2 pc 148", "al_r2_pc_148"},
     {{al, r7, pc, 26}, false, al, "al r7 pc 26", "al_r7_pc_26"},
     {{al, r6, pc, 153}, false, al, "al r6 pc 153", "al_r6_pc_153"},
     {{al, r2, pc, 252}, false, al, "al r2 pc 252", "al_r2_pc_252"},
     {{al, r6, pc, 101}, false, al, "al r6 pc 101", "al_r6_pc_101"},
     {{al, r3, pc, 128}, false, al, "al r3 pc 128", "al_r3_pc_128"},
     {{al, r2, pc, 69}, false, al, "al r2 pc 69", "al_r2_pc_69"},
     {{al, r2, pc, 208}, false, al, "al r2 pc 208", "al_r2_pc_208"},
     {{al, r1, pc, 199}, false, al, "al r1 pc 199", "al_r1_pc_199"},
     {{al, r7, pc, 202}, false, al, "al r7 pc 202", "al_r7_pc_202"},
     {{al, r5, pc, 16}, false, al, "al r5 pc 16", "al_r5_pc_16"},
     {{al, r7, pc, 172}, false, al, "al r7 pc 172", "al_r7_pc_172"},
     {{al, r3, pc, 205}, false, al, "al r3 pc 205", "al_r3_pc_205"},
     {{al, r1, pc, 111}, false, al, "al r1 pc 111", "al_r1_pc_111"},
     {{al, r3, pc, 163}, false, al, "al r3 pc 163", "al_r3_pc_163"},
     {{al, r7, pc, 217}, false, al, "al r7 pc 217", "al_r7_pc_217"},
     {{al, r1, pc, 254}, false, al, "al r1 pc 254", "al_r1_pc_254"},
     {{al, r2, pc, 117}, false, al, "al r2 pc 117", "al_r2_pc_117"},
     {{al, r0, pc, 188}, false, al, "al r0 pc 188", "al_r0_pc_188"},
     {{al, r5, pc, 209}, false, al, "al r5 pc 209", "al_r5_pc_209"},
     {{al, r4, pc, 13}, false, al, "al r4 pc 13", "al_r4_pc_13"},
     {{al, r7, pc, 165}, false, al, "al r7 pc 165", "al_r7_pc_165"},
     {{al, r4, pc, 172}, false, al, "al r4 pc 172", "al_r4_pc_172"},
     {{al, r3, pc, 106}, false, al, "al r3 pc 106", "al_r3_pc_106"},
     {{al, r0, pc, 201}, false, al, "al r0 pc 201", "al_r0_pc_201"},
     {{al, r4, pc, 7}, false, al, "al r4 pc 7", "al_r4_pc_7"},
     {{al, r1, pc, 197}, false, al, "al r1 pc 197", "al_r1_pc_197"},
     {{al, r4, pc, 204}, false, al, "al r4 pc 204", "al_r4_pc_204"},
     {{al, r7, pc, 64}, false, al, "al r7 pc 64", "al_r7_pc_64"},
     {{al, r3, pc, 20}, false, al, "al r3 pc 20", "al_r3_pc_20"},
     {{al, r6, pc, 12}, false, al, "al r6 pc 12", "al_r6_pc_12"},
     {{al, r1, pc, 193}, false, al, "al r1 pc 193", "al_r1_pc_193"},
     {{al, r6, pc, 156}, false, al, "al r6 pc 156", "al_r6_pc_156"},
     {{al, r7, pc, 166}, false, al, "al r7 pc 166", "al_r7_pc_166"},
     {{al, r5, pc, 154}, false, al, "al r5 pc 154", "al_r5_pc_154"},
     {{al, r3, pc, 144}, false, al, "al r3 pc 144", "al_r3_pc_144"},
     {{al, r0, pc, 21}, false, al, "al r0 pc 21", "al_r0_pc_21"},
     {{al, r0, pc, 128}, false, al, "al r0 pc 128", "al_r0_pc_128"},
     {{al, r6, pc, 163}, false, al, "al r6 pc 163", "al_r6_pc_163"},
     {{al, r2, pc, 216}, false, al, "al r2 pc 216", "al_r2_pc_216"},
     {{al, r3, pc, 122}, false, al, "al r3 pc 122", "al_r3_pc_122"},
     {{al, r5, pc, 81}, false, al, "al r5 pc 81", "al_r5_pc_81"},
     {{al, r4, pc, 31}, false, al, "al r4 pc 31", "al_r4_pc_31"},
     {{al, r1, pc, 2}, false, al, "al r1 pc 2", "al_r1_pc_2"},
     {{al, r6, pc, 111}, false, al, "al r6 pc 111", "al_r6_pc_111"},
     {{al, r3, pc, 247}, false, al, "al r3 pc 247", "al_r3_pc_247"},
     {{al, r1, pc, 62}, false, al, "al r1 pc 62", "al_r1_pc_62"},
     {{al, r2, pc, 82}, false, al, "al r2 pc 82", "al_r2_pc_82"},
     {{al, r4, pc, 43}, false, al, "al r4 pc 43", "al_r4_pc_43"},
     {{al, r1, pc, 25}, false, al, "al r1 pc 25", "al_r1_pc_25"},
     {{al, r0, pc, 35}, false, al, "al r0 pc 35", "al_r0_pc_35"},
     {{al, r3, pc, 204}, false, al, "al r3 pc 204", "al_r3_pc_204"},
     {{al, r5, pc, 0}, false, al, "al r5 pc 0", "al_r5_pc_0"},
     {{al, r0, pc, 100}, false, al, "al r0 pc 100", "al_r0_pc_100"},
     {{al, r5, pc, 140}, false, al, "al r5 pc 140", "al_r5_pc_140"},
     {{al, r0, pc, 252}, false, al, "al r0 pc 252", "al_r0_pc_252"},
     {{al, r5, pc, 117}, false, al, "al r5 pc 117", "al_r5_pc_117"},
     {{al, r2, pc, 131}, false, al, "al r2 pc 131", "al_r2_pc_131"},
     {{al, r1, pc, 99}, false, al, "al r1 pc 99", "al_r1_pc_99"},
     {{al, r0, pc, 189}, false, al, "al r0 pc 189", "al_r0_pc_189"},
     {{al, r1, pc, 18}, false, al, "al r1 pc 18", "al_r1_pc_18"},
     {{al, r7, pc, 205}, false, al, "al r7 pc 205", "al_r7_pc_205"},
     {{al, r0, pc, 213}, false, al, "al r0 pc 213", "al_r0_pc_213"},
     {{al, r5, pc, 249}, false, al, "al r5 pc 249", "al_r5_pc_249"},
     {{al, r3, pc, 57}, false, al, "al r3 pc 57", "al_r3_pc_57"},
     {{al, r2, pc, 38}, false, al, "al r2 pc 38", "al_r2_pc_38"},
     {{al, r6, pc, 106}, false, al, "al r6 pc 106", "al_r6_pc_106"},
     {{al, r5, pc, 224}, false, al, "al r5 pc 224", "al_r5_pc_224"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rd-pc-operand-imm8-add-t32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   Register rn,
                                   const Operand& op);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseT32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    int32_t immediate = kTests[i].operands.immediate;
    Operand op(immediate);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, rn, op);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                        \
  void Test_##mnemonic() {                                                    \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic);   \
  }                                                                           \
  Test test_##mnemonic("AARCH32_ASSEMBLER_COND_RD_PC_OPERAND_IMM8_" #mnemonic \
                       "_T32",                                                \
                       &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
