/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#ifndef _TUSERSETTINGS_H_
#define _TUSERSETTINGS_H_
#include <QtGui>
#include <QSettings>
#include <QFont>
#include "../const.h"

class TUserSettings
{
    //Q_OBJECT
public:
    TUserSettings();
    ~TUserSettings(void);

    void readSettings();
    void writeSettings();
    void sync();
	
	int getToolbarSize();
	QRect getGeometry();
	QString getPath();
	bool getShowPanel();

    QFont getFontMetaInfo();
    QFont getFontTimeInfo();
	
	int getCountFrames();
	int getCountHor();
	int getIndentBorder();
	int getIndentItems();
	qreal getScale();
	int getStyle();
	int getQuality();
	int getFormatImg();
	bool getLogo();
	
	QTime getIndentTimeStart();
	QTime getIndentTimeFinish();
	
	bool getInfoName();
	bool getInfoSize();
	bool getInfoDuration();
	bool getInfoResolution();
	bool getInfoVideo();
	bool getInfoAudio();
	
	QColor getColorInfoText();
	QColor getColorInfoInfo();
	QColor getColorBackground();

	
	void setToolbarSize(int);
	void setGeometry(QRect);
	void setPath(QString);
	void setShowPanel(bool);
	
    void setFontMetaInfo(QFont);
    void setFontTimeInfo(QFont);
	
	void setCountFrames(int);
	void setCountHor(int);
	void setIndentBorder(int);
	void setIndentItems(int);
	void setScale(qreal);
	void setStyle(int);
	void setQuality(int);
	void setFormatImg(int);
	void setLogo(bool);
	
	void setIndentTimeStart(QTime);
	void setIndentTimeFinish(QTime);
	
	void setInfoName(bool);
	void setInfoSize(bool);
	void setInfoDuration(bool);
	void setInfoResolution(bool);
	void setInfoVideo(bool);
	void setInfoAudio(bool);
	
	void setColorInfoText(QColor);
	void setColorInfoInfo(QColor);
	void setColorBackground(QColor);

protected:

private:
    QSettings *settings;

    // main window
	int toolbarSize;
	QRect geometry;
	QString path;
	bool showPanel;

	int countFrames;
	int countHor;
	int indentBorder;
	int indentItems;
	qreal scale;
	int style;
	int quality;
	int formatImg;
	bool logo;
	
	QTime indentTimeStart;
	QTime indentTimeFinish;
	
	bool infoName;
	bool infoSize;
	bool infoDuration;
	bool infoResolution;
	bool infoVideo;
	bool infoAudio;	
	
    // fonts
    QFont fontMetaInfo;
    QFont fontTimeInfo;
	
	// colors
	QColor colorInfoText;
	QColor colorInfoInfo;
	QColor colorBackground;
};

#endif
