/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2013 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef MULTIPOSE_SEEN
#define MULTIPOSE_SEEN

#include "Cds.h"

void
SuperPose2Anchor(CdsArray *scratchA, CdsArray *baseA, char *anchorf_name);

void
CalcTranslationsIp(CdsArray *scratchA, Algorithm *algo);

double
CalcRotations(CdsArray *cdsA);

double
CalcScaleFactorsML(CdsArray *cdsA);

double
CalcScaleFactorsMLConstr(CdsArray *cdsA);

double
CalcScaleFactorsMLLogNorm(CdsArray *cdsA);

double
CalcScaleFactorsML2(CdsArray *cdsA);

double
CalcScaleFactorsMLGoodall(CdsArray *cdsA);

double
CalcScaleFactors(CdsArray *cdsA);

void
ScaleCdsArray(CdsArray *cdsA);

int
CheckConvergenceInner(CdsArray *cdsA, const double precision);

int
CheckConvergenceOuter(CdsArray *cdsA, int round, const double precision);

double
SuperPoseArray2Orig(CdsArray *cdsA, CdsArray *targetA, double *sumdev);

void
HierarchVars(CdsArray *cdsA);

int
MultiPose_pth(CdsArray *baseA);

int
MultiPose(CdsArray *baseA);

void
RotPrincAxes(CdsArray *cdsA);

void
SuperJack(CdsArray *baseA);

void
CalcWts(CdsArray *cdsA);

void
CalcWtsFinal(CdsArray *cdsA);

double
SuperPose(Cds *cds1, Cds *cds2, double **rotmat, double *trans,
          double *, double *, double *);

#endif
