/* ====================================================================
 * Copyright (c) 2008       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _PATHSIMPLIFIER_TEST_H
#define _PATHSIMPLIFIER_TEST_H

// sc
class TestConfig;
class ConfigData;

// cppunit
#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>


class PathSimplifierTest : public CppUnit::TestCase 
{
  CPPUNIT_TEST_SUITE( PathSimplifierTest );
  CPPUNIT_TEST( simplifyEmptyPaths );
  CPPUNIT_TEST( simplifyEqualPaths );
  CPPUNIT_TEST( simplifyDifferentPaths );
  CPPUNIT_TEST_SUITE_END(); 
  
public:
  void setUp();
  void tearDown();
  
  // Tests
  void simplifyEmptyPaths();
  void simplifyEqualPaths();
  void simplifyDifferentPaths();
};

#endif // _PATHCOMPRESSOR_TEST_H
