/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CATPARAM_H
#define _SC_CATPARAM_H

// sc
#include "ScParam.h"
#include "svn/Revision.h"
#include "util/String.h"


/**
 * Parameter class for CatCmd.
 */
class CatParam : public ScParam
{
public:
  CatParam( const sc::String& pathOrUrl, const svn::RevisionPtr rev )
    : _pathOrUrl(pathOrUrl), _rev(rev)
  {
  }

  ~CatParam()
  {
  }

  const sc::String& getPathOrUrl() const
  {
    return _pathOrUrl;
  }

  const svn::RevisionPtr getRevision() const
  {
    return _rev;
  }

  sc::String& getValue()
  {
    return _cat;
  }

  ScParamAccept(CatParam);

private:
  // in
  sc::String       _pathOrUrl;
  svn::RevisionPtr _rev;

  // out
  sc::String       _cat;
};

#endif // _SC_CATPARAM_H
