5.6 Variablen

# Variablen

Es ist sehr nützlich beim Coden, Namen für Dinge zu vergeben. Sonic Pi 
macht es Dir hier sehr leicht: Schreib einfach den Namen, den Du gerne 
verwenden möchtest, dann ein Gleichheitszeichen (`=`) und dann das 
Ding, welches Du Dir merken möchtest.

```
sample_name = :loop_amen
```

Hier haben wir uns das Symbol `:loop_amen` mit der Variable 
`sample_name` *gemerkt*. Wir können nun `sample_name` überall da 
benutzen, wo wir auch `loop_amen` benutzen könnten. Zum Beispiel:


```
sample_name = :loop_amen
sample sample_name
```

Es gibt drei Hauptgründe, Variablen in Sonic Pi zu nutzen: Bedeutung 
vermitteln, Wiederholung steuern und Ergebnisse von Dingen speichern.

## Bedeutung vermitteln

Wenn Du Code schreibst, könntest Du denken, dass Du einfach nur dem 
Computer sagst, was er tun soll - solange der Computer das versteht, 
ist es okay. Es ist jedoch wichtig daran zu denken, dass nicht nur der 
Computer den Code liest. Andere Leute könnten den Code auch lesen und
wollen verstehen, was da vor sich geht. Wahrscheinlich wirst Du 
den Code auch später selbst wieder lesen und möchtest verstehen, was er 
bedeutet. Obwohl Dir jetzt vielleicht alles offensichtlich erscheint - 
wahrscheinlich ist es für andere nicht ganz so offensichtlich und 
vielleicht nicht einmal für Dich in der Zukunft!

Kommentare sind eine Möglichkeit, anderen dabei zu helfen, Deinen Code 
zu verstehen. Weiterhin kannst Du sinnvolle Namen für Deine Variablen
verwenden. Sie Dir diesen Code an:

```
sleep 1.7533
```

Warum steht hier die Zahl `1.7533`. Woher kommt diese Zahl? Was 
bedeutet sie? Sieh Dir zum Vergleich diesen Code an:

```
loop_amen_duration = 1.7533
sleep loop_amen_duration
```

Aha, jetzt ist viel klarer, was `1.7533` bedeutet: Es ist die Dauer des 
Sample `loop_amen`! Natürlich kannst Du jetzt sagen, warum nicht 
einfach schreiben:

```
sleep sample_duration(:loop_amen)
```

Das ist natürlich auch ein sehr guter Weg, die Absicht mitzuteilen, die 
hinter dem Code steht.

## Wiederholungen steuern

In Deinem Code wirst Du oft Dinge wiederholen, und wenn Du 
irgendwo etwas ändern willst, musst Du das an vielen Stellen tun. Schau 
Dir mal diesen Code an:

```
sample :loop_amen
sleep sample_duration(:loop_amen)
sample :loop_amen, rate: 0.5
sleep sample_duration(:loop_amen, rate: 0.5)
sample :loop_amen
sleep sample_duration(:loop_amen)
```

Hier machen wir eine ganze Menge mit dem `:loop_amen`! Was wäre, wenn 
Du das Ganze mit einem anderen Loop-Sample wie zum Beispiel 
`:loop_garzul` hören wollten? Wir müssten alle `:loop_amen` suchen und 
mit `:loop_garzul` ersetzen. Das mag in Ordnung sein, wenn Du viel Zeit 
hast - aber was, wenn Du gerade auf einer Bühne stehst? Manchmal hast 
Du nicht den Luxus, Zeit zu haben - vor allem dann nicht, wenn Du 
willst, dass die Leute weitertanzen.

Was wäre, wenn Du den Code so geschrieben hättest:

```
sample_name = :loop_amen
sample sample_name
sleep sample_duration(sample_name)
sample sample_name, rate: 0.5
sleep sample_duration(sample_name, rate: 0.5)
sample sample_name
sleep sample_duration(sample_name)
```

Das tut genau dasselbe wie der Code weiter oben (probier es aus). 
Außerdem bekommen wir die Möglichkeit, durch die Änderung der einen 
Zeile `sample_name = :loop_amen` in `sample_name = :loop_garzul` die 
vielen anderen Stellen durch die Magie der Variablen zu verändern.

## Ergebnisse von Dingen speichern

Wenn man schließlich die Ergebnisse von irgendwelchen Dingen speichern 
möchte, dann ist das ebenfalls ein guter Grund dafür, Variablen zu 
verwenden. Du möchtest vielleicht irgendetwas mit der Dauer eines 
Sample anstellen:

```
sd = sample_duration(:loop_amen)
```

Wir können nun `sd` überall da einsetzen, wo wir die Länge von 
`:loop_amen` brauchen.

Noch wichtiger vielleicht: Eine Variable erlaubt es uns, das Ergebnis 
eines Aufrufs von `play` oder `sample` zu speichern:

```
s = play 50, release: 8
```

Jetzt haben wir `s` als Variable eingefangen und gemerkt. Und das 
erlaubt es uns, einen Synth zu steuern während er läuft:

```
s = play 50, release: 8
sleep 2
control s, note: 62
```

Das nur als kleine Vorschau, wie man Synths steuert. Das schauen
wir uns später noch genauer an.
