# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.trusthub.v1.customer_profiles import CustomerProfilesList
from twilio.rest.trusthub.v1.end_user import EndUserList
from twilio.rest.trusthub.v1.end_user_type import EndUserTypeList
from twilio.rest.trusthub.v1.policies import PoliciesList
from twilio.rest.trusthub.v1.supporting_document import SupportingDocumentList
from twilio.rest.trusthub.v1.supporting_document_type import SupportingDocumentTypeList
from twilio.rest.trusthub.v1.trust_products import TrustProductsList


class V1(Version):

    def __init__(self, domain):
        """
        Initialize the V1 version of Trusthub

        :returns: V1 version of Trusthub
        :rtype: twilio.rest.trusthub.v1.V1.V1
        """
        super(V1, self).__init__(domain)
        self.version = 'v1'
        self._customer_profiles = None
        self._end_users = None
        self._end_user_types = None
        self._policies = None
        self._supporting_documents = None
        self._supporting_document_types = None
        self._trust_products = None

    @property
    def customer_profiles(self):
        """
        :rtype: twilio.rest.trusthub.v1.customer_profiles.CustomerProfilesList
        """
        if self._customer_profiles is None:
            self._customer_profiles = CustomerProfilesList(self)
        return self._customer_profiles

    @property
    def end_users(self):
        """
        :rtype: twilio.rest.trusthub.v1.end_user.EndUserList
        """
        if self._end_users is None:
            self._end_users = EndUserList(self)
        return self._end_users

    @property
    def end_user_types(self):
        """
        :rtype: twilio.rest.trusthub.v1.end_user_type.EndUserTypeList
        """
        if self._end_user_types is None:
            self._end_user_types = EndUserTypeList(self)
        return self._end_user_types

    @property
    def policies(self):
        """
        :rtype: twilio.rest.trusthub.v1.policies.PoliciesList
        """
        if self._policies is None:
            self._policies = PoliciesList(self)
        return self._policies

    @property
    def supporting_documents(self):
        """
        :rtype: twilio.rest.trusthub.v1.supporting_document.SupportingDocumentList
        """
        if self._supporting_documents is None:
            self._supporting_documents = SupportingDocumentList(self)
        return self._supporting_documents

    @property
    def supporting_document_types(self):
        """
        :rtype: twilio.rest.trusthub.v1.supporting_document_type.SupportingDocumentTypeList
        """
        if self._supporting_document_types is None:
            self._supporting_document_types = SupportingDocumentTypeList(self)
        return self._supporting_document_types

    @property
    def trust_products(self):
        """
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsList
        """
        if self._trust_products is None:
            self._trust_products = TrustProductsList(self)
        return self._trust_products

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Trusthub.V1>'
