# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.deviceregistry.aio import DeviceRegistryMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDeviceRegistryMgmtAssetEndpointProfilesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DeviceRegistryMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_asset_endpoint_profiles_get(self, resource_group):
        response = await self.client.asset_endpoint_profiles.get(
            resource_group_name=resource_group.name,
            asset_endpoint_profile_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_asset_endpoint_profiles_begin_create_or_replace(self, resource_group):
        response = await (
            await self.client.asset_endpoint_profiles.begin_create_or_replace(
                resource_group_name=resource_group.name,
                asset_endpoint_profile_name="str",
                resource={
                    "extendedLocation": {"name": "str", "type": "str"},
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "endpointProfileType": "str",
                        "targetAddress": "str",
                        "additionalConfiguration": "str",
                        "authentication": {
                            "method": "str",
                            "usernamePasswordCredentials": {"passwordSecretName": "str", "usernameSecretName": "str"},
                            "x509Credentials": {"certificateSecretName": "str"},
                        },
                        "discoveredAssetEndpointProfileRef": "str",
                        "provisioningState": "str",
                        "status": {"errors": [{"code": 0, "message": "str"}]},
                        "uuid": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_asset_endpoint_profiles_begin_update(self, resource_group):
        response = await (
            await self.client.asset_endpoint_profiles.begin_update(
                resource_group_name=resource_group.name,
                asset_endpoint_profile_name="str",
                properties={
                    "properties": {
                        "additionalConfiguration": "str",
                        "authentication": {
                            "method": "str",
                            "usernamePasswordCredentials": {"passwordSecretName": "str", "usernameSecretName": "str"},
                            "x509Credentials": {"certificateSecretName": "str"},
                        },
                        "endpointProfileType": "str",
                        "targetAddress": "str",
                    },
                    "tags": {"str": "str"},
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_asset_endpoint_profiles_begin_delete(self, resource_group):
        response = await (
            await self.client.asset_endpoint_profiles.begin_delete(
                resource_group_name=resource_group.name,
                asset_endpoint_profile_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_asset_endpoint_profiles_list_by_resource_group(self, resource_group):
        response = self.client.asset_endpoint_profiles.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_asset_endpoint_profiles_list_by_subscription(self, resource_group):
        response = self.client.asset_endpoint_profiles.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
