# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class AdditionalFeaturesServerConfigurations(msrest.serialization.Model):
    """Additional SQL Server feature settings.

    :param is_r_services_enabled: Enable or disable R services (SQL 2016 onwards).
    :type is_r_services_enabled: bool
    """

    _attribute_map = {
        'is_r_services_enabled': {'key': 'isRServicesEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AdditionalFeaturesServerConfigurations, self).__init__(**kwargs)
        self.is_r_services_enabled = kwargs.get('is_r_services_enabled', None)


class AutoBackupSettings(msrest.serialization.Model):
    """Configure backups for databases in your SQL virtual machine.

    :param enable: Enable or disable autobackup on SQL virtual machine.
    :type enable: bool
    :param enable_encryption: Enable or disable encryption for backup on SQL virtual machine.
    :type enable_encryption: bool
    :param retention_period: Retention period of backup: 1-30 days.
    :type retention_period: int
    :param storage_account_url: Storage account url where backup will be taken to.
    :type storage_account_url: str
    :param storage_access_key: Storage account key where backup will be taken to.
    :type storage_access_key: str
    :param password: Password for encryption on backup.
    :type password: str
    :param backup_system_dbs: Include or exclude system databases from auto backup.
    :type backup_system_dbs: bool
    :param backup_schedule_type: Backup schedule type. Possible values include: "Manual",
     "Automated".
    :type backup_schedule_type: str or ~azure.mgmt.sqlvirtualmachine.models.BackupScheduleType
    :param full_backup_frequency: Frequency of full backups. In both cases, full backups begin
     during the next scheduled time window. Possible values include: "Daily", "Weekly".
    :type full_backup_frequency: str or
     ~azure.mgmt.sqlvirtualmachine.models.FullBackupFrequencyType
    :param full_backup_start_time: Start time of a given day during which full backups can take
     place. 0-23 hours.
    :type full_backup_start_time: int
    :param full_backup_window_hours: Duration of the time window of a given day during which full
     backups can take place. 1-23 hours.
    :type full_backup_window_hours: int
    :param log_backup_frequency: Frequency of log backups. 5-60 minutes.
    :type log_backup_frequency: int
    """

    _attribute_map = {
        'enable': {'key': 'enable', 'type': 'bool'},
        'enable_encryption': {'key': 'enableEncryption', 'type': 'bool'},
        'retention_period': {'key': 'retentionPeriod', 'type': 'int'},
        'storage_account_url': {'key': 'storageAccountUrl', 'type': 'str'},
        'storage_access_key': {'key': 'storageAccessKey', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'backup_system_dbs': {'key': 'backupSystemDbs', 'type': 'bool'},
        'backup_schedule_type': {'key': 'backupScheduleType', 'type': 'str'},
        'full_backup_frequency': {'key': 'fullBackupFrequency', 'type': 'str'},
        'full_backup_start_time': {'key': 'fullBackupStartTime', 'type': 'int'},
        'full_backup_window_hours': {'key': 'fullBackupWindowHours', 'type': 'int'},
        'log_backup_frequency': {'key': 'logBackupFrequency', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoBackupSettings, self).__init__(**kwargs)
        self.enable = kwargs.get('enable', None)
        self.enable_encryption = kwargs.get('enable_encryption', None)
        self.retention_period = kwargs.get('retention_period', None)
        self.storage_account_url = kwargs.get('storage_account_url', None)
        self.storage_access_key = kwargs.get('storage_access_key', None)
        self.password = kwargs.get('password', None)
        self.backup_system_dbs = kwargs.get('backup_system_dbs', None)
        self.backup_schedule_type = kwargs.get('backup_schedule_type', None)
        self.full_backup_frequency = kwargs.get('full_backup_frequency', None)
        self.full_backup_start_time = kwargs.get('full_backup_start_time', None)
        self.full_backup_window_hours = kwargs.get('full_backup_window_hours', None)
        self.log_backup_frequency = kwargs.get('log_backup_frequency', None)


class AutoPatchingSettings(msrest.serialization.Model):
    """Set a patching window during which Windows and SQL patches will be applied.

    :param enable: Enable or disable autopatching on SQL virtual machine.
    :type enable: bool
    :param day_of_week: Day of week to apply the patch on. Possible values include: "Monday",
     "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday".
    :type day_of_week: str or ~azure.mgmt.sqlvirtualmachine.models.DayOfWeek
    :param maintenance_window_starting_hour: Hour of the day when patching is initiated. Local VM
     time.
    :type maintenance_window_starting_hour: int
    :param maintenance_window_duration: Duration of patching.
    :type maintenance_window_duration: int
    """

    _attribute_map = {
        'enable': {'key': 'enable', 'type': 'bool'},
        'day_of_week': {'key': 'dayOfWeek', 'type': 'str'},
        'maintenance_window_starting_hour': {'key': 'maintenanceWindowStartingHour', 'type': 'int'},
        'maintenance_window_duration': {'key': 'maintenanceWindowDuration', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoPatchingSettings, self).__init__(**kwargs)
        self.enable = kwargs.get('enable', None)
        self.day_of_week = kwargs.get('day_of_week', None)
        self.maintenance_window_starting_hour = kwargs.get('maintenance_window_starting_hour', None)
        self.maintenance_window_duration = kwargs.get('maintenance_window_duration', None)


class Resource(msrest.serialization.Model):
    """ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """ARM proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class AvailabilityGroupListener(ProxyResource):
    """A SQL Server availability group listener.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Provisioning state to track the async operation status.
    :vartype provisioning_state: str
    :param availability_group_name: Name of the availability group.
    :type availability_group_name: str
    :param load_balancer_configurations: List of load balancer configurations for an availability
     group listener.
    :type load_balancer_configurations:
     list[~azure.mgmt.sqlvirtualmachine.models.LoadBalancerConfiguration]
    :param create_default_availability_group_if_not_exist: Create a default availability group if
     it does not exist.
    :type create_default_availability_group_if_not_exist: bool
    :param port: Listener port.
    :type port: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'availability_group_name': {'key': 'properties.availabilityGroupName', 'type': 'str'},
        'load_balancer_configurations': {'key': 'properties.loadBalancerConfigurations', 'type': '[LoadBalancerConfiguration]'},
        'create_default_availability_group_if_not_exist': {'key': 'properties.createDefaultAvailabilityGroupIfNotExist', 'type': 'bool'},
        'port': {'key': 'properties.port', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailabilityGroupListener, self).__init__(**kwargs)
        self.provisioning_state = None
        self.availability_group_name = kwargs.get('availability_group_name', None)
        self.load_balancer_configurations = kwargs.get('load_balancer_configurations', None)
        self.create_default_availability_group_if_not_exist = kwargs.get('create_default_availability_group_if_not_exist', None)
        self.port = kwargs.get('port', None)


class AvailabilityGroupListenerListResult(msrest.serialization.Model):
    """A list of availability group listeners.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sqlvirtualmachine.models.AvailabilityGroupListener]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AvailabilityGroupListener]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailabilityGroupListenerListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class KeyVaultCredentialSettings(msrest.serialization.Model):
    """Configure your SQL virtual machine to be able to connect to the Azure Key Vault service.

    :param enable: Enable or disable key vault credential setting.
    :type enable: bool
    :param credential_name: Credential name.
    :type credential_name: str
    :param azure_key_vault_url: Azure Key Vault url.
    :type azure_key_vault_url: str
    :param service_principal_name: Service principal name to access key vault.
    :type service_principal_name: str
    :param service_principal_secret: Service principal name secret to access key vault.
    :type service_principal_secret: str
    """

    _attribute_map = {
        'enable': {'key': 'enable', 'type': 'bool'},
        'credential_name': {'key': 'credentialName', 'type': 'str'},
        'azure_key_vault_url': {'key': 'azureKeyVaultUrl', 'type': 'str'},
        'service_principal_name': {'key': 'servicePrincipalName', 'type': 'str'},
        'service_principal_secret': {'key': 'servicePrincipalSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultCredentialSettings, self).__init__(**kwargs)
        self.enable = kwargs.get('enable', None)
        self.credential_name = kwargs.get('credential_name', None)
        self.azure_key_vault_url = kwargs.get('azure_key_vault_url', None)
        self.service_principal_name = kwargs.get('service_principal_name', None)
        self.service_principal_secret = kwargs.get('service_principal_secret', None)


class LoadBalancerConfiguration(msrest.serialization.Model):
    """A load balancer configuration for an availability group listener.

    :param private_ip_address: Private IP address.
    :type private_ip_address: ~azure.mgmt.sqlvirtualmachine.models.PrivateIPAddress
    :param public_ip_address_resource_id: Resource id of the public IP.
    :type public_ip_address_resource_id: str
    :param load_balancer_resource_id: Resource id of the load balancer.
    :type load_balancer_resource_id: str
    :param probe_port: Probe port.
    :type probe_port: int
    :param sql_virtual_machine_instances: List of the SQL virtual machine instance resource id's
     that are enrolled into the availability group listener.
    :type sql_virtual_machine_instances: list[str]
    """

    _attribute_map = {
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'PrivateIPAddress'},
        'public_ip_address_resource_id': {'key': 'publicIpAddressResourceId', 'type': 'str'},
        'load_balancer_resource_id': {'key': 'loadBalancerResourceId', 'type': 'str'},
        'probe_port': {'key': 'probePort', 'type': 'int'},
        'sql_virtual_machine_instances': {'key': 'sqlVirtualMachineInstances', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancerConfiguration, self).__init__(**kwargs)
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.public_ip_address_resource_id = kwargs.get('public_ip_address_resource_id', None)
        self.load_balancer_resource_id = kwargs.get('load_balancer_resource_id', None)
        self.probe_port = kwargs.get('probe_port', None)
        self.sql_virtual_machine_instances = kwargs.get('sql_virtual_machine_instances', None)


class Operation(msrest.serialization.Model):
    """SQL REST API operation definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation being performed on this particular object.
    :vartype name: str
    :ivar display: The localized display information for this particular operation / action.
    :vartype display: ~azure.mgmt.sqlvirtualmachine.models.OperationDisplay
    :ivar origin: The intended executor of the operation. Possible values include: "user",
     "system".
    :vartype origin: str or ~azure.mgmt.sqlvirtualmachine.models.OperationOrigin
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, any]
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
        'origin': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.origin = None
        self.properties = None


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name.
    :vartype provider: str
    :ivar resource: The localized friendly form of the resource type related to this
     action/operation.
    :vartype resource: str
    :ivar operation: The localized friendly name for the operation.
    :vartype operation: str
    :ivar description: The localized friendly description for the operation.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list SQL operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sqlvirtualmachine.models.Operation]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateIPAddress(msrest.serialization.Model):
    """A private IP address bound to the availability group listener.

    :param ip_address: Private IP address bound to the availability group listener.
    :type ip_address: str
    :param subnet_resource_id: Subnet used to include private IP.
    :type subnet_resource_id: str
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'subnet_resource_id': {'key': 'subnetResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateIPAddress, self).__init__(**kwargs)
        self.ip_address = kwargs.get('ip_address', None)
        self.subnet_resource_id = kwargs.get('subnet_resource_id', None)


class ResourceIdentity(msrest.serialization.Model):
    """Azure Active Directory identity configuration for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The Azure Active Directory principal id.
    :vartype principal_id: str
    :param type: The identity type. Set this to 'SystemAssigned' in order to automatically create
     and assign an Azure Active Directory principal for the resource. Possible values include:
     "SystemAssigned".
    :type type: str or ~azure.mgmt.sqlvirtualmachine.models.IdentityType
    :ivar tenant_id: The Azure Active Directory tenant id.
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.type = kwargs.get('type', None)
        self.tenant_id = None


class ServerConfigurationsManagementSettings(msrest.serialization.Model):
    """Set the connectivity, storage and workload settings.

    :param sql_connectivity_update_settings: SQL connectivity type settings.
    :type sql_connectivity_update_settings:
     ~azure.mgmt.sqlvirtualmachine.models.SqlConnectivityUpdateSettings
    :param sql_workload_type_update_settings: SQL workload type settings.
    :type sql_workload_type_update_settings:
     ~azure.mgmt.sqlvirtualmachine.models.SqlWorkloadTypeUpdateSettings
    :param sql_storage_update_settings: SQL storage update settings.
    :type sql_storage_update_settings:
     ~azure.mgmt.sqlvirtualmachine.models.SqlStorageUpdateSettings
    :param additional_features_server_configurations: Additional SQL feature settings.
    :type additional_features_server_configurations:
     ~azure.mgmt.sqlvirtualmachine.models.AdditionalFeaturesServerConfigurations
    """

    _attribute_map = {
        'sql_connectivity_update_settings': {'key': 'sqlConnectivityUpdateSettings', 'type': 'SqlConnectivityUpdateSettings'},
        'sql_workload_type_update_settings': {'key': 'sqlWorkloadTypeUpdateSettings', 'type': 'SqlWorkloadTypeUpdateSettings'},
        'sql_storage_update_settings': {'key': 'sqlStorageUpdateSettings', 'type': 'SqlStorageUpdateSettings'},
        'additional_features_server_configurations': {'key': 'additionalFeaturesServerConfigurations', 'type': 'AdditionalFeaturesServerConfigurations'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerConfigurationsManagementSettings, self).__init__(**kwargs)
        self.sql_connectivity_update_settings = kwargs.get('sql_connectivity_update_settings', None)
        self.sql_workload_type_update_settings = kwargs.get('sql_workload_type_update_settings', None)
        self.sql_storage_update_settings = kwargs.get('sql_storage_update_settings', None)
        self.additional_features_server_configurations = kwargs.get('additional_features_server_configurations', None)


class SqlConnectivityUpdateSettings(msrest.serialization.Model):
    """Set the access level and network port settings for SQL Server.

    :param connectivity_type: SQL Server connectivity option. Possible values include: "LOCAL",
     "PRIVATE", "PUBLIC".
    :type connectivity_type: str or ~azure.mgmt.sqlvirtualmachine.models.ConnectivityType
    :param port: SQL Server port.
    :type port: int
    :param sql_auth_update_user_name: SQL Server sysadmin login to create.
    :type sql_auth_update_user_name: str
    :param sql_auth_update_password: SQL Server sysadmin login password.
    :type sql_auth_update_password: str
    """

    _attribute_map = {
        'connectivity_type': {'key': 'connectivityType', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'sql_auth_update_user_name': {'key': 'sqlAuthUpdateUserName', 'type': 'str'},
        'sql_auth_update_password': {'key': 'sqlAuthUpdatePassword', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlConnectivityUpdateSettings, self).__init__(**kwargs)
        self.connectivity_type = kwargs.get('connectivity_type', None)
        self.port = kwargs.get('port', None)
        self.sql_auth_update_user_name = kwargs.get('sql_auth_update_user_name', None)
        self.sql_auth_update_password = kwargs.get('sql_auth_update_password', None)


class SQLStorageSettings(msrest.serialization.Model):
    """Set disk storage settings for SQL Server.

    :param luns: Logical Unit Numbers for the disks.
    :type luns: list[int]
    :param default_file_path: SQL Server default file path.
    :type default_file_path: str
    """

    _attribute_map = {
        'luns': {'key': 'luns', 'type': '[int]'},
        'default_file_path': {'key': 'defaultFilePath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SQLStorageSettings, self).__init__(**kwargs)
        self.luns = kwargs.get('luns', None)
        self.default_file_path = kwargs.get('default_file_path', None)


class SqlStorageUpdateSettings(msrest.serialization.Model):
    """Set disk storage settings for SQL Server.

    :param disk_count: Virtual machine disk count.
    :type disk_count: int
    :param starting_device_id: Device id of the first disk to be updated.
    :type starting_device_id: int
    :param disk_configuration_type: Disk configuration to apply to SQL Server. Possible values
     include: "NEW", "EXTEND", "ADD".
    :type disk_configuration_type: str or
     ~azure.mgmt.sqlvirtualmachine.models.DiskConfigurationType
    """

    _attribute_map = {
        'disk_count': {'key': 'diskCount', 'type': 'int'},
        'starting_device_id': {'key': 'startingDeviceId', 'type': 'int'},
        'disk_configuration_type': {'key': 'diskConfigurationType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlStorageUpdateSettings, self).__init__(**kwargs)
        self.disk_count = kwargs.get('disk_count', None)
        self.starting_device_id = kwargs.get('starting_device_id', None)
        self.disk_configuration_type = kwargs.get('disk_configuration_type', None)


class TrackedResource(Resource):
    """ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class SqlVirtualMachine(TrackedResource):
    """A SQL virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: Azure Active Directory identity of the server.
    :type identity: ~azure.mgmt.sqlvirtualmachine.models.ResourceIdentity
    :param virtual_machine_resource_id: ARM Resource id of underlying virtual machine created from
     SQL marketplace image.
    :type virtual_machine_resource_id: str
    :ivar provisioning_state: Provisioning state to track the async operation status.
    :vartype provisioning_state: str
    :param sql_image_offer: SQL image offer. Examples include SQL2016-WS2016, SQL2017-WS2016.
    :type sql_image_offer: str
    :param sql_server_license_type: SQL Server license type. Possible values include: "PAYG",
     "AHUB", "DR".
    :type sql_server_license_type: str or ~azure.mgmt.sqlvirtualmachine.models.SqlServerLicenseType
    :param sql_management: SQL Server Management type. Possible values include: "Full",
     "LightWeight", "NoAgent".
    :type sql_management: str or ~azure.mgmt.sqlvirtualmachine.models.SqlManagementMode
    :param sql_image_sku: SQL Server edition type. Possible values include: "Developer", "Express",
     "Standard", "Enterprise", "Web".
    :type sql_image_sku: str or ~azure.mgmt.sqlvirtualmachine.models.SqlImageSku
    :param sql_virtual_machine_group_resource_id: ARM resource id of the SQL virtual machine group
     this SQL virtual machine is or will be part of.
    :type sql_virtual_machine_group_resource_id: str
    :param wsfc_domain_credentials: Domain credentials for setting up Windows Server Failover
     Cluster for SQL availability group.
    :type wsfc_domain_credentials: ~azure.mgmt.sqlvirtualmachine.models.WsfcDomainCredentials
    :param auto_patching_settings: Auto patching settings for applying critical security updates to
     SQL virtual machine.
    :type auto_patching_settings: ~azure.mgmt.sqlvirtualmachine.models.AutoPatchingSettings
    :param auto_backup_settings: Auto backup settings for SQL Server.
    :type auto_backup_settings: ~azure.mgmt.sqlvirtualmachine.models.AutoBackupSettings
    :param key_vault_credential_settings: Key vault credential settings.
    :type key_vault_credential_settings:
     ~azure.mgmt.sqlvirtualmachine.models.KeyVaultCredentialSettings
    :param server_configurations_management_settings: SQL Server configuration management settings.
    :type server_configurations_management_settings:
     ~azure.mgmt.sqlvirtualmachine.models.ServerConfigurationsManagementSettings
    :param storage_configuration_settings: Storage Configuration Settings.
    :type storage_configuration_settings:
     ~azure.mgmt.sqlvirtualmachine.models.StorageConfigurationSettings
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'virtual_machine_resource_id': {'key': 'properties.virtualMachineResourceId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sql_image_offer': {'key': 'properties.sqlImageOffer', 'type': 'str'},
        'sql_server_license_type': {'key': 'properties.sqlServerLicenseType', 'type': 'str'},
        'sql_management': {'key': 'properties.sqlManagement', 'type': 'str'},
        'sql_image_sku': {'key': 'properties.sqlImageSku', 'type': 'str'},
        'sql_virtual_machine_group_resource_id': {'key': 'properties.sqlVirtualMachineGroupResourceId', 'type': 'str'},
        'wsfc_domain_credentials': {'key': 'properties.wsfcDomainCredentials', 'type': 'WsfcDomainCredentials'},
        'auto_patching_settings': {'key': 'properties.autoPatchingSettings', 'type': 'AutoPatchingSettings'},
        'auto_backup_settings': {'key': 'properties.autoBackupSettings', 'type': 'AutoBackupSettings'},
        'key_vault_credential_settings': {'key': 'properties.keyVaultCredentialSettings', 'type': 'KeyVaultCredentialSettings'},
        'server_configurations_management_settings': {'key': 'properties.serverConfigurationsManagementSettings', 'type': 'ServerConfigurationsManagementSettings'},
        'storage_configuration_settings': {'key': 'properties.storageConfigurationSettings', 'type': 'StorageConfigurationSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlVirtualMachine, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.virtual_machine_resource_id = kwargs.get('virtual_machine_resource_id', None)
        self.provisioning_state = None
        self.sql_image_offer = kwargs.get('sql_image_offer', None)
        self.sql_server_license_type = kwargs.get('sql_server_license_type', None)
        self.sql_management = kwargs.get('sql_management', None)
        self.sql_image_sku = kwargs.get('sql_image_sku', None)
        self.sql_virtual_machine_group_resource_id = kwargs.get('sql_virtual_machine_group_resource_id', None)
        self.wsfc_domain_credentials = kwargs.get('wsfc_domain_credentials', None)
        self.auto_patching_settings = kwargs.get('auto_patching_settings', None)
        self.auto_backup_settings = kwargs.get('auto_backup_settings', None)
        self.key_vault_credential_settings = kwargs.get('key_vault_credential_settings', None)
        self.server_configurations_management_settings = kwargs.get('server_configurations_management_settings', None)
        self.storage_configuration_settings = kwargs.get('storage_configuration_settings', None)


class SqlVirtualMachineGroup(TrackedResource):
    """A SQL virtual machine group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar provisioning_state: Provisioning state to track the async operation status.
    :vartype provisioning_state: str
    :param sql_image_offer: SQL image offer. Examples may include SQL2016-WS2016, SQL2017-WS2016.
    :type sql_image_offer: str
    :param sql_image_sku: SQL image sku. Possible values include: "Developer", "Enterprise".
    :type sql_image_sku: str or ~azure.mgmt.sqlvirtualmachine.models.SqlVmGroupImageSku
    :ivar scale_type: Scale type. Possible values include: "HA".
    :vartype scale_type: str or ~azure.mgmt.sqlvirtualmachine.models.ScaleType
    :ivar cluster_manager_type: Type of cluster manager: Windows Server Failover Cluster (WSFC),
     implied by the scale type of the group and the OS type. Possible values include: "WSFC".
    :vartype cluster_manager_type: str or ~azure.mgmt.sqlvirtualmachine.models.ClusterManagerType
    :ivar cluster_configuration: Cluster type. Possible values include: "Domainful".
    :vartype cluster_configuration: str or
     ~azure.mgmt.sqlvirtualmachine.models.ClusterConfiguration
    :param wsfc_domain_profile: Cluster Active Directory domain profile.
    :type wsfc_domain_profile: ~azure.mgmt.sqlvirtualmachine.models.WsfcDomainProfile
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'scale_type': {'readonly': True},
        'cluster_manager_type': {'readonly': True},
        'cluster_configuration': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sql_image_offer': {'key': 'properties.sqlImageOffer', 'type': 'str'},
        'sql_image_sku': {'key': 'properties.sqlImageSku', 'type': 'str'},
        'scale_type': {'key': 'properties.scaleType', 'type': 'str'},
        'cluster_manager_type': {'key': 'properties.clusterManagerType', 'type': 'str'},
        'cluster_configuration': {'key': 'properties.clusterConfiguration', 'type': 'str'},
        'wsfc_domain_profile': {'key': 'properties.wsfcDomainProfile', 'type': 'WsfcDomainProfile'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlVirtualMachineGroup, self).__init__(**kwargs)
        self.provisioning_state = None
        self.sql_image_offer = kwargs.get('sql_image_offer', None)
        self.sql_image_sku = kwargs.get('sql_image_sku', None)
        self.scale_type = None
        self.cluster_manager_type = None
        self.cluster_configuration = None
        self.wsfc_domain_profile = kwargs.get('wsfc_domain_profile', None)


class SqlVirtualMachineGroupListResult(msrest.serialization.Model):
    """A list of SQL virtual machine groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sqlvirtualmachine.models.SqlVirtualMachineGroup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SqlVirtualMachineGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlVirtualMachineGroupListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SqlVirtualMachineGroupUpdate(msrest.serialization.Model):
    """An update to a SQL virtual machine group.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlVirtualMachineGroupUpdate, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class SqlVirtualMachineListResult(msrest.serialization.Model):
    """A list of SQL virtual machines.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sqlvirtualmachine.models.SqlVirtualMachine]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SqlVirtualMachine]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlVirtualMachineListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SqlVirtualMachineUpdate(msrest.serialization.Model):
    """An update to a SQL virtual machine.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlVirtualMachineUpdate, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class SqlWorkloadTypeUpdateSettings(msrest.serialization.Model):
    """Set workload type to optimize storage for SQL Server.

    :param sql_workload_type: SQL Server workload type. Possible values include: "GENERAL", "OLTP",
     "DW".
    :type sql_workload_type: str or ~azure.mgmt.sqlvirtualmachine.models.SqlWorkloadType
    """

    _attribute_map = {
        'sql_workload_type': {'key': 'sqlWorkloadType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlWorkloadTypeUpdateSettings, self).__init__(**kwargs)
        self.sql_workload_type = kwargs.get('sql_workload_type', None)


class StorageConfigurationSettings(msrest.serialization.Model):
    """Storage Configurations for SQL Data, Log and TempDb.

    :param sql_data_settings: SQL Server Data Storage Settings.
    :type sql_data_settings: ~azure.mgmt.sqlvirtualmachine.models.SQLStorageSettings
    :param sql_log_settings: SQL Server Log Storage Settings.
    :type sql_log_settings: ~azure.mgmt.sqlvirtualmachine.models.SQLStorageSettings
    :param sql_temp_db_settings: SQL Server TempDb Storage Settings.
    :type sql_temp_db_settings: ~azure.mgmt.sqlvirtualmachine.models.SQLStorageSettings
    :param disk_configuration_type: Disk configuration to apply to SQL Server. Possible values
     include: "NEW", "EXTEND", "ADD".
    :type disk_configuration_type: str or
     ~azure.mgmt.sqlvirtualmachine.models.DiskConfigurationType
    :param storage_workload_type: Storage workload type. Possible values include: "GENERAL",
     "OLTP", "DW".
    :type storage_workload_type: str or ~azure.mgmt.sqlvirtualmachine.models.StorageWorkloadType
    """

    _attribute_map = {
        'sql_data_settings': {'key': 'sqlDataSettings', 'type': 'SQLStorageSettings'},
        'sql_log_settings': {'key': 'sqlLogSettings', 'type': 'SQLStorageSettings'},
        'sql_temp_db_settings': {'key': 'sqlTempDbSettings', 'type': 'SQLStorageSettings'},
        'disk_configuration_type': {'key': 'diskConfigurationType', 'type': 'str'},
        'storage_workload_type': {'key': 'storageWorkloadType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageConfigurationSettings, self).__init__(**kwargs)
        self.sql_data_settings = kwargs.get('sql_data_settings', None)
        self.sql_log_settings = kwargs.get('sql_log_settings', None)
        self.sql_temp_db_settings = kwargs.get('sql_temp_db_settings', None)
        self.disk_configuration_type = kwargs.get('disk_configuration_type', None)
        self.storage_workload_type = kwargs.get('storage_workload_type', None)


class WsfcDomainCredentials(msrest.serialization.Model):
    """Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.

    :param cluster_bootstrap_account_password: Cluster bootstrap account password.
    :type cluster_bootstrap_account_password: str
    :param cluster_operator_account_password: Cluster operator account password.
    :type cluster_operator_account_password: str
    :param sql_service_account_password: SQL service account password.
    :type sql_service_account_password: str
    """

    _attribute_map = {
        'cluster_bootstrap_account_password': {'key': 'clusterBootstrapAccountPassword', 'type': 'str'},
        'cluster_operator_account_password': {'key': 'clusterOperatorAccountPassword', 'type': 'str'},
        'sql_service_account_password': {'key': 'sqlServiceAccountPassword', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WsfcDomainCredentials, self).__init__(**kwargs)
        self.cluster_bootstrap_account_password = kwargs.get('cluster_bootstrap_account_password', None)
        self.cluster_operator_account_password = kwargs.get('cluster_operator_account_password', None)
        self.sql_service_account_password = kwargs.get('sql_service_account_password', None)


class WsfcDomainProfile(msrest.serialization.Model):
    """Active Directory account details to operate Windows Server Failover Cluster.

    :param domain_fqdn: Fully qualified name of the domain.
    :type domain_fqdn: str
    :param ou_path: Organizational Unit path in which the nodes and cluster will be present.
    :type ou_path: str
    :param cluster_bootstrap_account: Account name used for creating cluster (at minimum needs
     permissions to 'Create Computer Objects' in domain).
    :type cluster_bootstrap_account: str
    :param cluster_operator_account: Account name used for operating cluster i.e. will be part of
     administrators group on all the participating virtual machines in the cluster.
    :type cluster_operator_account: str
    :param sql_service_account: Account name under which SQL service will run on all participating
     SQL virtual machines in the cluster.
    :type sql_service_account: str
    :param file_share_witness_path: Optional path for fileshare witness.
    :type file_share_witness_path: str
    :param storage_account_url: Fully qualified ARM resource id of the witness storage account.
    :type storage_account_url: str
    :param storage_account_primary_key: Primary key of the witness storage account.
    :type storage_account_primary_key: str
    """

    _attribute_map = {
        'domain_fqdn': {'key': 'domainFqdn', 'type': 'str'},
        'ou_path': {'key': 'ouPath', 'type': 'str'},
        'cluster_bootstrap_account': {'key': 'clusterBootstrapAccount', 'type': 'str'},
        'cluster_operator_account': {'key': 'clusterOperatorAccount', 'type': 'str'},
        'sql_service_account': {'key': 'sqlServiceAccount', 'type': 'str'},
        'file_share_witness_path': {'key': 'fileShareWitnessPath', 'type': 'str'},
        'storage_account_url': {'key': 'storageAccountUrl', 'type': 'str'},
        'storage_account_primary_key': {'key': 'storageAccountPrimaryKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WsfcDomainProfile, self).__init__(**kwargs)
        self.domain_fqdn = kwargs.get('domain_fqdn', None)
        self.ou_path = kwargs.get('ou_path', None)
        self.cluster_bootstrap_account = kwargs.get('cluster_bootstrap_account', None)
        self.cluster_operator_account = kwargs.get('cluster_operator_account', None)
        self.sql_service_account = kwargs.get('sql_service_account', None)
        self.file_share_witness_path = kwargs.get('file_share_witness_path', None)
        self.storage_account_url = kwargs.get('storage_account_url', None)
        self.storage_account_primary_key = kwargs.get('storage_account_primary_key', None)
