#
# Unit tests for gnocchi::storage::swift
#
require 'spec_helper'

describe 'gnocchi::storage::swift' do

  let :params do
    {}
  end

  shared_examples 'gnocchi storage swift' do

    context 'with default parameters' do
      it 'configures gnocchi-api with default parameters' do
        is_expected.to contain_gnocchi_config('storage/driver').with_value('swift')
        is_expected.to contain_gnocchi_config('storage/swift_user').with_value('admin:admin')
        is_expected.to contain_gnocchi_config('storage/swift_key').with_value('admin')
        is_expected.to contain_gnocchi_config('storage/swift_authurl').with_value('http://localhost:8080/auth/v1.0')
        is_expected.to contain_gnocchi_config('storage/swift_auth_version').with_value('1')
        is_expected.to contain_gnocchi_config('storage/swift_endpoint_type').with_value('<SERVICE DEFAULT>')
      end
    end

    context 'with swift_endpoint_type set' do
      before do
        params.merge!({
          :swift_endpoint_type => 'internalURL'
        })
      end
      it 'configures gnocchi-api with given endpoint type' do
        is_expected.to contain_gnocchi_config('storage/swift_endpoint_type').with_value('internalURL')
      end
    end
  end

  on_supported_os({
    :supported_os   => OSDefaults.get_supported_os
  }).each do |os,facts|
    context "on #{os}" do
      let (:facts) do
        facts.merge!(OSDefaults.get_facts())
      end

      it_behaves_like 'gnocchi storage swift'
    end
  end
end
