/*
 * Decompiled with CFR 0.152.
 */
package weka.associations.gsp;

import java.io.Serializable;
import java.util.Enumeration;
import weka.associations.gsp.Element;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class Sequence
implements Cloneable,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -5001018056339156390L;
    protected int m_SupportCount;
    protected FastVector m_Elements;

    public Sequence() {
        this.m_SupportCount = 0;
        this.m_Elements = new FastVector();
    }

    public Sequence(FastVector elements) {
        this.m_SupportCount = 0;
        this.m_Elements = elements;
    }

    public Sequence(int supportCount) {
        this.m_SupportCount = supportCount;
        this.m_Elements = new FastVector();
    }

    public static FastVector aprioriGen(FastVector kMinusOneSequences) throws CloneNotSupportedException {
        FastVector allCandidates = Sequence.generateKCandidates(kMinusOneSequences);
        FastVector prunedCandidates = Sequence.pruneCadidates(allCandidates, kMinusOneSequences);
        return prunedCandidates;
    }

    public static FastVector deleteInfrequentSequences(FastVector sequences, long minSupportCount) {
        FastVector deletedSequences = new FastVector();
        Enumeration seqEnum = sequences.elements();
        while (seqEnum.hasMoreElements()) {
            Sequence currentSeq = (Sequence)seqEnum.nextElement();
            long curSupportCount = currentSeq.getSupportCount();
            if (curSupportCount < minSupportCount) continue;
            deletedSequences.addElement(currentSeq);
        }
        return deletedSequences;
    }

    protected static FastVector generateKCandidates(FastVector kMinusOneSequences) throws CloneNotSupportedException {
        FastVector candidates = new FastVector();
        FastVector mergeResult = new FastVector();
        for (int i = 0; i < kMinusOneSequences.size(); ++i) {
            for (int j = 0; j < kMinusOneSequences.size(); ++j) {
                Sequence subseq2;
                Sequence originalSeq1 = (Sequence)kMinusOneSequences.elementAt(i);
                Sequence seq1 = originalSeq1.clone();
                Sequence originalSeq2 = (Sequence)kMinusOneSequences.elementAt(j);
                Sequence seq2 = originalSeq2.clone();
                Sequence subseq1 = seq1.deleteEvent("first");
                if (!subseq1.equals(subseq2 = seq2.deleteEvent("last"))) continue;
                mergeResult = subseq1.getElements().size() == 0 && subseq2.getElements().size() == 0 ? (i >= j ? Sequence.merge(seq1, seq2, true, true) : Sequence.merge(seq1, seq2, true, false)) : Sequence.merge(seq1, seq2, false, false);
                candidates.appendElements(mergeResult);
            }
        }
        return candidates;
    }

    protected static FastVector merge(Sequence seq1, Sequence seq2, boolean oneElements, boolean mergeElements) {
        FastVector mergeResult = new FastVector();
        if (oneElements) {
            Element element1 = (Element)seq1.getElements().firstElement();
            Element element2 = (Element)seq2.getElements().firstElement();
            Element element3 = null;
            if (mergeElements) {
                for (int i = 0; i < element1.getEvents().length; ++i) {
                    if (element1.getEvents()[i] <= -1) continue;
                    if (element2.getEvents()[i] > -1) break;
                    element3 = Element.merge(element1, element2);
                }
            }
            FastVector newElements1 = new FastVector();
            newElements1.addElement(element1);
            newElements1.addElement(element2);
            mergeResult.addElement(new Sequence(newElements1));
            if (element3 != null) {
                FastVector newElements2 = new FastVector();
                newElements2.addElement(element3);
                mergeResult.addElement(new Sequence(newElements2));
            }
            return mergeResult;
        }
        Element lastElementSeq1 = (Element)seq1.getElements().lastElement();
        Element lastElementSeq2 = (Element)seq2.getElements().lastElement();
        Sequence resultSeq = new Sequence();
        FastVector resultSeqElements = resultSeq.getElements();
        if (lastElementSeq2.containsOverOneEvent()) {
            for (int i = 0; i < seq1.getElements().size() - 1; ++i) {
                resultSeqElements.addElement(seq1.getElements().elementAt(i));
            }
            resultSeqElements.addElement(Element.merge(lastElementSeq1, lastElementSeq2));
            mergeResult.addElement(resultSeq);
            return mergeResult;
        }
        for (int i = 0; i < seq1.getElements().size(); ++i) {
            resultSeqElements.addElement(seq1.getElements().elementAt(i));
        }
        resultSeqElements.addElement(lastElementSeq2);
        mergeResult.addElement(resultSeq);
        return mergeResult;
    }

    public static FastVector oneElementsToSequences(FastVector elements) {
        FastVector sequences = new FastVector();
        Enumeration elementEnum = elements.elements();
        while (elementEnum.hasMoreElements()) {
            Sequence seq = new Sequence();
            FastVector seqElements = seq.getElements();
            seqElements.addElement(elementEnum.nextElement());
            sequences.addElement(seq);
        }
        return sequences;
    }

    public static void printSetOfSequences(FastVector setOfSequences) {
        Enumeration seqEnum = setOfSequences.elements();
        int i = 1;
        while (seqEnum.hasMoreElements()) {
            Sequence seq = (Sequence)seqEnum.nextElement();
            System.out.print("[" + i++ + "]" + " " + seq.toString());
        }
    }

    protected static FastVector pruneCadidates(FastVector allCandidates, FastVector kMinusOneSequences) {
        FastVector prunedCandidates = new FastVector();
        for (int i = 0; i < allCandidates.size(); ++i) {
            Sequence candidate = (Sequence)allCandidates.elementAt(i);
            boolean isFrequent = true;
            FastVector canElements = candidate.getElements();
            block1: for (int j = 0; j < canElements.size() && isFrequent; ++j) {
                Element origElement = (Element)canElements.elementAt(j);
                int[] origEvents = origElement.getEvents();
                for (int k = 0; k < origEvents.length; ++k) {
                    int containedAt;
                    if (origEvents[k] <= -1) continue;
                    int helpEvent = origEvents[k];
                    origEvents[k] = -1;
                    if (origElement.isEmpty()) {
                        canElements.removeElementAt(j);
                        containedAt = kMinusOneSequences.indexOf(candidate);
                        if (containedAt != -1) {
                            origEvents[k] = helpEvent;
                            canElements.insertElementAt(origElement, j);
                            continue block1;
                        }
                        isFrequent = false;
                        continue block1;
                    }
                    containedAt = kMinusOneSequences.indexOf(candidate);
                    if (containedAt != -1) {
                        origEvents[k] = helpEvent;
                        continue;
                    }
                    isFrequent = false;
                    continue block1;
                }
            }
            if (!isFrequent) continue;
            prunedCandidates.addElement(candidate);
        }
        return prunedCandidates;
    }

    public static String setOfSequencesToString(FastVector setOfSequences, Instances dataSet, FastVector filterAttributes) {
        StringBuffer resString = new StringBuffer();
        Enumeration SequencesEnum = setOfSequences.elements();
        int i = 1;
        while (SequencesEnum.hasMoreElements()) {
            Sequence seq = (Sequence)SequencesEnum.nextElement();
            Integer filterAttr = (Integer)filterAttributes.elementAt(0);
            boolean printSeq = true;
            if (filterAttr != -1) {
                block1: for (int j = 0; j < filterAttributes.size(); ++j) {
                    filterAttr = (Integer)filterAttributes.elementAt(j);
                    FastVector seqElements = seq.getElements();
                    if (!printSeq) continue;
                    for (int k = 0; k < seqElements.size(); ++k) {
                        Element currentElement = (Element)seqElements.elementAt(k);
                        int[] currentEvents = currentElement.getEvents();
                        if (currentEvents[filterAttr] != -1) continue;
                        printSeq = false;
                        continue block1;
                    }
                }
            }
            if (!printSeq) continue;
            resString.append("[" + i++ + "]" + " " + seq.toNominalString(dataSet));
        }
        return resString.toString();
    }

    public static void updateSupportCount(FastVector candidates, FastVector dataSequences) {
        Enumeration canEnumeration = candidates.elements();
        while (canEnumeration.hasMoreElements()) {
            Enumeration dataSeqEnumeration = dataSequences.elements();
            Sequence candidate = (Sequence)canEnumeration.nextElement();
            while (dataSeqEnumeration.hasMoreElements()) {
                Instances dataSequence = (Instances)dataSeqEnumeration.nextElement();
                if (!candidate.isSubsequenceOf(dataSequence)) continue;
                candidate.setSupportCount(candidate.getSupportCount() + 1);
            }
        }
    }

    public Sequence clone() {
        try {
            Sequence clone = (Sequence)super.clone();
            clone.setSupportCount(this.m_SupportCount);
            FastVector cloneElements = new FastVector(this.m_Elements.size());
            for (int i = 0; i < this.m_Elements.size(); ++i) {
                Element helpElement = (Element)this.m_Elements.elementAt(i);
                cloneElements.addElement(helpElement.clone());
            }
            clone.setElements(cloneElements);
            return clone;
        }
        catch (CloneNotSupportedException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    protected Sequence deleteEvent(String position) {
        Sequence cloneSeq = this.clone();
        if (position.equals("first")) {
            Element element = (Element)cloneSeq.getElements().firstElement();
            element.deleteEvent("first");
            if (element.isEmpty()) {
                cloneSeq.getElements().removeElementAt(0);
            }
            return cloneSeq;
        }
        if (position.equals("last")) {
            Element element = (Element)cloneSeq.getElements().lastElement();
            element.deleteEvent("last");
            if (element.isEmpty()) {
                cloneSeq.getElements().removeElementAt(this.m_Elements.size() - 1);
            }
            return cloneSeq;
        }
        return null;
    }

    public boolean equals(Object obj) {
        Sequence seq2 = (Sequence)obj;
        FastVector seq2Elements = seq2.getElements();
        for (int i = 0; i < this.m_Elements.size(); ++i) {
            Element seq2Element;
            Element thisElement = (Element)this.m_Elements.elementAt(i);
            if (thisElement.equals(seq2Element = (Element)seq2Elements.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    protected FastVector getElements() {
        return this.m_Elements;
    }

    protected int getSupportCount() {
        return this.m_SupportCount;
    }

    protected boolean isSubsequenceOf(Instances dataSequence) {
        FastVector elements = this.getElements();
        Enumeration elementEnum = elements.elements();
        Element curElement = (Element)elementEnum.nextElement();
        for (int i = 0; i < dataSequence.numInstances(); ++i) {
            if (!curElement.isContainedBy(dataSequence.instance(i))) continue;
            if (!elementEnum.hasMoreElements()) {
                return true;
            }
            curElement = (Element)elementEnum.nextElement();
        }
        return false;
    }

    protected void setElements(FastVector elements) {
        this.m_Elements = elements;
    }

    protected void setSupportCount(int supportCount) {
        this.m_SupportCount = supportCount;
    }

    public String toNominalString(Instances dataSet) {
        String result = "";
        result = result + "<";
        for (int i = 0; i < this.m_Elements.size(); ++i) {
            Element element = (Element)this.m_Elements.elementAt(i);
            result = result + element.toNominalString(dataSet);
        }
        result = result + "> (" + this.getSupportCount() + ")\n";
        return result;
    }

    public String toString() {
        String result = "";
        result = result + "Sequence Output\n";
        result = result + "------------------------------\n";
        result = result + "Support Count: " + this.getSupportCount() + "\n";
        result = result + "contained elements/itemsets:\n";
        for (int i = 0; i < this.m_Elements.size(); ++i) {
            Element element = (Element)this.m_Elements.elementAt(i);
            result = result + element.toString();
        }
        result = result + "\n\n";
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

