---
title: Clients
sort_rank: 6
nav_icon: sliders
---

# Sending alerts

__**Disclaimer**: Prometheus automatically takes care of sending alerts
generated by its configured [alerting
rules](https://prometheus.io/docs/prometheus/latest/configuration/alerting_rules/). It is highly
recommended to configure alerting rules in Prometheus based on time series data
rather than implementing a direct client.__

You send alerts to Alertmanager via API v2. The scheme for v2 is specified as
an OpenAPI specification that can be found [here
](https://github.com/prometheus/alertmanager/blob/master/api/v2/openapi.yaml).
API v1 was deprecated in Alertmanager version 0.16.0 and removed in Alertmanager
version 0.27.0.

Clients are expected to continuously re-send alerts as long as they are still
active (usually on the order of 30 seconds to 3 minutes). Clients can push a
list of alerts to Alertmanager via a POST request.

The labels of each alert are used to identify identical instances of an alert
and to perform deduplication. The annotations are always set to those received
most recently and are not identifying an alert.

Both `startsAt` and `endsAt` timestamp are optional. If `startsAt` is omitted,
the current time is assigned by the Alertmanager. `endsAt` is only set if the
end time of an alert is known. Otherwise it will be set to a configurable
timeout period from the time since the alert was last received.

The `generatorURL` field is a unique back-link which identifies the causing
entity of this alert in the client.

```json
[
  {
    "labels": {
      "alertname": "<requiredAlertName>",
      "<labelname>": "<labelvalue>",
      ...
    },
    "annotations": {
      "<labelname>": "<labelvalue>",
    },
    "startsAt": "<rfc3339>",
    "endsAt": "<rfc3339>",
    "generatorURL": "<generator_url>"
  },
  ...
]
```
