#ifndef _Eigen_and_TableOfReal_h_
#define _Eigen_and_TableOfReal_h_

/* Eigen_and_TableOfReal.h
 *
 * Copyright (C) 1993-2011, 2015 David Weenink
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 djmw 20020327 Initial version
 djmw 20020813 GPL header
 djmw 20110307 Latest modification
*/

#include "Eigen.h"
#include "TableOfReal.h"

autoTableOfReal Eigen_and_TableOfReal_project (Eigen me, TableOfReal thee, long from, long numberOfComponents);
/*
	Purpose: project the rows of the TableOfReal (thee) starting at index 'from'
	on the eigenspace (me).
*/

void Eigen_and_TableOfReal_project_into (Eigen me, TableOfReal thee, long thee_from, long thee_to, TableOfReal him, long his_from, long his_to);
/*
	Purpose: project the rows of the TableOfReal (thee) on the
	eigenspace (me). Result in existing TableOfReal (him).
*/

autoEigen TablesOfReal_to_Eigen_gsvd (TableOfReal me, TableOfReal thee);
/*
	Solve A'A x -lambda B'B x = 0
*/

#endif /* _Eigen_and_TableOfReal_h_ */
