/**********************************************************************
 *
 * PostGIS - Spatial Types for PostgreSQL
 * http://postgis.net
 *
 * PostGIS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * PostGIS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PostGIS.  If not, see <http://www.gnu.org/licenses/>.
 *
 **********************************************************************
 *
 * Copyright (C) 2010-2015 Paul Ramsey <pramsey@cleverelephant.ca>
 * Copyright (C) 2011-2014 Sandro Santilli <strk@kbt.io>
 *
 **********************************************************************/

#line 2 "lwin_wkt_lex.c"

#line 4 "lwin_wkt_lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer wkt_yy_create_buffer
#define yy_delete_buffer wkt_yy_delete_buffer
#define yy_flex_debug wkt_yy_flex_debug
#define yy_init_buffer wkt_yy_init_buffer
#define yy_flush_buffer wkt_yy_flush_buffer
#define yy_load_buffer_state wkt_yy_load_buffer_state
#define yy_switch_to_buffer wkt_yy_switch_to_buffer
#define yyin wkt_yyin
#define yyleng wkt_yyleng
#define yylex wkt_yylex
#define yylineno wkt_yylineno
#define yyout wkt_yyout
#define yyrestart wkt_yyrestart
#define yytext wkt_yytext
#define yywrap wkt_yywrap
#define yyalloc wkt_yyalloc
#define yyrealloc wkt_yyrealloc
#define yyfree wkt_yyfree

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 37
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types.
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE wkt_yyrestart(wkt_yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern yy_size_t wkt_yyleng;

extern FILE *wkt_yyin, *wkt_yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)

/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up wkt_yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up wkt_yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via wkt_yyrestart()), so that the user can continue scanning by
	 * just pointing wkt_yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when wkt_yytext is formed. */
static char yy_hold_char;
static yy_size_t yy_n_chars;		/* number of characters read into yy_ch_buf */
yy_size_t wkt_yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow wkt_yywrap()'s to do buffer switches
 * instead of setting up a fresh wkt_yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void wkt_yyrestart (FILE *input_file  );
void wkt_yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE wkt_yy_create_buffer (FILE *file,int size  );
void wkt_yy_delete_buffer (YY_BUFFER_STATE b  );
void wkt_yy_flush_buffer (YY_BUFFER_STATE b  );
void wkt_yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void wkt_yypop_buffer_state (void );

static void wkt_yyensure_buffer_stack (void );
static void wkt_yy_load_buffer_state (void );
static void wkt_yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER wkt_yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE wkt_yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE wkt_yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE wkt_yy_scan_bytes (yyconst char *bytes,yy_size_t len  );

void *wkt_yyalloc (yy_size_t  );
void *wkt_yyrealloc (void *,yy_size_t  );
void wkt_yyfree (void *  );

#define yy_new_buffer wkt_yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        wkt_yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            wkt_yy_create_buffer(wkt_yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        wkt_yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            wkt_yy_create_buffer(wkt_yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define wkt_yywrap() 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *wkt_yyin = (FILE *) 0, *wkt_yyout = (FILE *) 0;

typedef int yy_state_type;

extern int wkt_yylineno;

int wkt_yylineno = 1;

extern char *wkt_yytext;
#define yytext_ptr wkt_yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up wkt_yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	wkt_yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 26
#define YY_END_OF_BUFFER 27
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[172] =
    {   0,
        0,    0,   27,   25,   24,   24,   20,   21,   22,   25,
       25,    1,   23,   25,   25,   25,   25,   19,   25,   25,
       25,   19,   24,    0,    1,    1,    1,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   19,
        0,    1,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   16,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   18,    0,
        0,    0,   17,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    2,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

       10,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   15,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       13,    6,    0,    8,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    9,    0,    0,
        5,    4,    0,    0,   11,    0,    0,    0,   12,    0,
        0,    0,    0,    7,    0,    0,    0,    0,   14,    3,
        0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    1,    1,    1,    1,    1,    1,    4,
        5,    1,    6,    7,    8,    9,    1,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,    1,   11,    1,
       12,    1,    1,    1,   13,    1,   14,   15,   16,   17,
       18,   19,   20,    1,    1,   21,   22,   23,   24,   25,
        1,   26,   27,   28,   29,   30,    1,    1,   31,   32,
        1,    1,    1,    1,    1,    1,   33,    1,   34,   35,

       36,   37,   38,   39,   40,    1,    1,   41,   42,   43,
       44,   45,    1,   46,   47,   48,   49,   50,    1,    1,
       51,   52,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[53] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1
    } ;

static yyconst flex_int16_t yy_base[172] =
    {   0,
        0,    0,  353,  366,   51,   53,  366,  366,  366,   48,
      342,   50,  366,   41,   40,   47,   44,   38,   44,   43,
       51,   50,   71,  341,   84,   85,  340,   70,   53,   74,
       72,   77,   79,   81,   84,   86,   88,   86,   90,  366,
      339,  338,   97,   87,   83,   86,   93,  101,   91,  113,
      107,  125,  366,  128,  113,  119,  128,  114,  130,  120,
      128,  121,  132,  335,  129,  132,  125,  130,  366,  129,
      131,  166,  366,  152,  162,  173,  164,  171,  162,  162,
      162,  163,  161,  172,  170,  166,  174,  184,  336,   65,
      180,  177,  201,  197,  189,  202,  198,  202,  206,  202,

      366,  203,  214,  204,  218,  202,  220,  212,  207,  223,
      218,  212,  239,  245,  366,  232,  233,  246,  241,  248,
      251,  241,  241,  252,  258,  251,  247,  248,  251,  256,
      366,  366,  251,  366,  257,  269,  269,  278,  270,  279,
      283,  279,  283,  291,  279,  286,  294,  366,  295,  292,
      366,  366,  287,  296,  366,  301,  294,  302,  366,  293,
      305,  323,  318,  366,  326,  318,  328,  322,  366,  366,
      366
    } ;

static yyconst flex_int16_t yy_def[172] =
    {   0,
      171,    1,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,

      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
        0
    } ;

static yyconst flex_int16_t yy_nxt[419] =
    {   0,
        4,    5,    6,    7,    8,    4,    9,   10,   11,   12,
       13,    4,    4,   14,    4,   15,    4,   16,    4,    4,
       17,   18,    4,    4,   19,    4,   20,   21,    4,    4,
        4,   22,    4,   14,    4,   15,    4,   16,    4,    4,
       17,   18,    4,    4,   19,    4,   20,   21,    4,    4,
        4,   22,   23,   23,   23,   23,   24,   25,   27,   25,
       29,   32,   33,   34,   30,   28,   35,   36,   37,   31,
       38,   40,   23,   23,   90,   41,   39,   41,   43,   42,
       29,   32,   33,   34,   30,   28,   35,   36,   37,   31,
       38,   40,   27,   25,   26,   44,   39,   45,   43,   28,

       28,   46,   47,   48,   49,   50,   51,   52,   53,   54,
       55,   56,   57,   58,   59,   44,   60,   45,   61,   28,
       28,   46,   47,   48,   49,   50,   51,   52,   53,   54,
       55,   56,   57,   58,   59,   62,   60,   63,   61,   64,
       65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
       75,   77,   78,   79,   80,   62,   81,   63,   82,   64,
       65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
       75,   77,   78,   79,   80,   87,   81,   88,   82,   83,
       89,   91,   90,   92,   93,   94,   84,   95,   96,   97,
       85,   98,   86,   99,  100,   87,  101,   88,  102,   83,

      103,   91,  104,   92,   93,   94,   84,   95,   96,   97,
       85,   98,   86,   99,  100,  105,  101,  106,  102,  107,
      103,  108,  104,  109,  110,  111,  112,  113,  114,  115,
      116,  117,  118,  119,  120,  105,  121,  106,  122,  107,
      123,  108,  124,  109,  110,  111,  112,  113,  114,  115,
      116,  117,  118,  119,  120,  125,  121,  126,  122,  127,
      123,  128,  124,  129,  130,  131,  132,  133,  134,  135,
      136,  137,  138,  139,  140,  125,  141,  126,  142,  127,
      143,  128,  144,  129,  130,  131,  132,  133,  134,  135,
      136,  137,  138,  139,  140,  145,  141,  146,  142,  147,

      143,  148,  144,  149,  150,  151,  152,  153,  154,  155,
      156,  157,  158,  159,  160,  145,  161,  146,  162,  147,
      163,  148,  164,  149,  150,  151,  152,  153,  154,  155,
      156,  157,  158,  159,  160,  165,  161,  166,  162,  167,
      163,  168,  164,  169,  170,   90,   76,   42,   42,   26,
       26,   26,  171,  171,  171,  165,  171,  166,  171,  167,
      171,  168,  171,  169,  170,    3,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,

      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171
    } ;

static yyconst flex_int16_t yy_chk[419] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    5,    5,    6,    6,   10,   10,   12,   12,
       14,   15,   16,   17,   14,   12,   18,   19,   20,   14,
       21,   22,   23,   23,   90,   28,   21,   28,   29,   28,
       14,   15,   16,   17,   14,   12,   18,   19,   20,   14,
       21,   22,   25,   25,   26,   30,   21,   31,   29,   25,

       26,   32,   33,   34,   35,   36,   36,   37,   38,   39,
       43,   44,   45,   46,   47,   30,   48,   31,   49,   25,
       26,   32,   33,   34,   35,   36,   36,   37,   38,   39,
       43,   44,   45,   46,   47,   50,   48,   51,   49,   52,
       54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
       63,   65,   66,   67,   68,   50,   70,   51,   71,   52,
       54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
       63,   65,   66,   67,   68,   74,   70,   75,   71,   72,
       76,   77,   76,   78,   79,   80,   72,   81,   82,   83,
       72,   84,   72,   85,   86,   74,   87,   75,   88,   72,

       91,   77,   92,   78,   79,   80,   72,   81,   82,   83,
       72,   84,   72,   85,   86,   93,   87,   94,   88,   95,
       91,   96,   92,   97,   98,   99,   99,  100,  102,  103,
      104,  105,  106,  107,  108,   93,  109,   94,  110,   95,
      111,   96,  112,   97,   98,   99,   99,  100,  102,  103,
      104,  105,  106,  107,  108,  113,  109,  114,  110,  116,
      111,  117,  112,  118,  119,  120,  121,  122,  123,  124,
      125,  126,  127,  128,  129,  113,  130,  114,  133,  116,
      135,  117,  136,  118,  119,  120,  121,  122,  123,  124,
      125,  126,  127,  128,  129,  137,  130,  138,  133,  139,

      135,  140,  136,  141,  142,  143,  144,  145,  146,  147,
      149,  150,  153,  154,  156,  137,  157,  138,  158,  139,
      160,  140,  161,  141,  142,  143,  144,  145,  146,  147,
      149,  150,  153,  154,  156,  162,  157,  163,  158,  165,
      160,  166,  161,  167,  168,   89,   64,   42,   41,   27,
       24,   11,    3,    0,    0,  162,    0,  163,    0,  165,
        0,  166,    0,  167,  168,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,

      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int wkt_yy_flex_debug;
int wkt_yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *wkt_yytext;
#line 1 "lwin_wkt_lex.l"
#line 2 "lwin_wkt_lex.l"

/* The lexer */

#include <stdio.h>
#include <string.h>
#include "lwin_wkt.h"
#include "lwin_wkt_parse.h"
#include "lwgeom_log.h"

static YY_BUFFER_STATE wkt_yy_buf_state;


/*
* Set up the lexer!
*/
void wkt_lexer_init(char *src)
{
	wkt_yy_buf_state = wkt_yy_scan_string(src);
}

/*
* Clean up the lexer!
*/
void wkt_lexer_close()
{
	wkt_yy_delete_buffer(wkt_yy_buf_state);
}

/*
* Handle errors due to unexpected junk in WKT strings.
*/
static void wkt_lexer_unknown()
{
	/* Set the global error state */
	global_parser_result.errcode = PARSER_ERROR_OTHER;
	global_parser_result.message = parser_error_messages[PARSER_ERROR_OTHER];
	global_parser_result.errlocation = wkt_yylloc.last_column;
}


/*
* This macro is magically run after a rule is found but before the main
* action is run. We use it to update the parse location information
* so we can report on where things fail. Also optionally to dump
* debugging info.
*/
#define YY_USER_ACTION do { \
	wkt_yylloc.first_line = wkt_yylloc.last_line = wkt_yylineno; \
	wkt_yylloc.first_column = wkt_yylloc.last_column; \
	wkt_yylloc.last_column += wkt_yyleng; \
	LWDEBUGF(5,"lex: %s", wkt_yytext); \
	} while (0);


#define YY_NO_INPUT 1
/* Suppress the default implementations. */
#line 679 "lwin_wkt_lex.c"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int wkt_yylex_destroy (void );

int wkt_yyget_debug (void );

void wkt_yyset_debug (int debug_flag  );

YY_EXTRA_TYPE wkt_yyget_extra (void );

void wkt_yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *wkt_yyget_in (void );

void wkt_yyset_in  (FILE * in_str  );

FILE *wkt_yyget_out (void );

void wkt_yyset_out  (FILE * out_str  );

yy_size_t wkt_yyget_leng (void );

char *wkt_yyget_text (void );

int wkt_yyget_lineno (void );

void wkt_yyset_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int wkt_yywrap (void );
#else
extern int wkt_yywrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( wkt_yytext, wkt_yyleng, 1, wkt_yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( wkt_yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( wkt_yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, wkt_yyin))==0 && ferror(wkt_yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(wkt_yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int wkt_yylex (void);

#define YY_DECL int wkt_yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after wkt_yytext and wkt_yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

#line 67 "lwin_wkt_lex.l"


#line 862 "lwin_wkt_lex.c"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! wkt_yyin )
			wkt_yyin = stdin;

		if ( ! wkt_yyout )
			wkt_yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			wkt_yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				wkt_yy_create_buffer(wkt_yyin,YY_BUF_SIZE );
		}

		wkt_yy_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of wkt_yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 172 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 171 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 69 "lwin_wkt_lex.l"
{
	LWDEBUG(5,"DOUBLE");
	wkt_yylval.doublevalue = atof(wkt_yytext);
	return DOUBLE_TOK;
	}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 75 "lwin_wkt_lex.l"
{
	LWDEBUG(5,"SRID");
	wkt_yylval.integervalue = wkt_lexer_read_srid(wkt_yytext);
	return SRID_TOK;
	}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 81 "lwin_wkt_lex.l"
{ return COLLECTION_TOK; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 82 "lwin_wkt_lex.l"
{ return MSURFACE_TOK; }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 83 "lwin_wkt_lex.l"
{ return MPOLYGON_TOK; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 84 "lwin_wkt_lex.l"
{ return MCURVE_TOK; }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 85 "lwin_wkt_lex.l"
{ return MLINESTRING_TOK; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 86 "lwin_wkt_lex.l"
{ return MPOINT_TOK; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 87 "lwin_wkt_lex.l"
{ return CURVEPOLYGON_TOK; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 88 "lwin_wkt_lex.l"
{ return POLYGON_TOK; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 89 "lwin_wkt_lex.l"
{ return COMPOUNDCURVE_TOK; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 90 "lwin_wkt_lex.l"
{ return CIRCULARSTRING_TOK; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 91 "lwin_wkt_lex.l"
{ return LINESTRING_TOK; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 92 "lwin_wkt_lex.l"
{ return POLYHEDRALSURFACE_TOK; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 93 "lwin_wkt_lex.l"
{ return TRIANGLE_TOK; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 94 "lwin_wkt_lex.l"
{ return TIN_TOK; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 95 "lwin_wkt_lex.l"
{ return POINT_TOK; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 96 "lwin_wkt_lex.l"
{ return EMPTY_TOK; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 98 "lwin_wkt_lex.l"
{
	LWDEBUG(5,"DIMENSIONALITY");
	wkt_yylval.stringvalue = wkt_yytext;
	return DIMENSIONALITY_TOK;
	}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 104 "lwin_wkt_lex.l"
{ LWDEBUG(5,"LBRACKET"); return LBRACKET_TOK; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 105 "lwin_wkt_lex.l"
{ LWDEBUG(5,"RBRACKET"); return RBRACKET_TOK; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 106 "lwin_wkt_lex.l"
{ LWDEBUG(5,"COMMA"); return COMMA_TOK; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 107 "lwin_wkt_lex.l"
{ LWDEBUG(5,"SEMICOLON"); return SEMICOLON_TOK; }
	YY_BREAK
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 109 "lwin_wkt_lex.l"
{ /* ignore whitespace */ LWDEBUG(5,"WHITESPACE"); }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 111 "lwin_wkt_lex.l"
{ /* Error out and stop parsing on unknown/unexpected characters */
	LWDEBUG(5,"UNKNOWN");
	wkt_lexer_unknown();
	yyterminate();
	}
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 117 "lwin_wkt_lex.l"
ECHO;
	YY_BREAK
#line 1088 "lwin_wkt_lex.c"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed wkt_yyin at a new source and called
			 * wkt_yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = wkt_yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( wkt_yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * wkt_yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of wkt_yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					wkt_yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			wkt_yyrestart(wkt_yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) wkt_yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 172 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 172 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 171);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;

	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			yy_size_t offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					wkt_yyrestart(wkt_yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( wkt_yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve wkt_yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 *
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void wkt_yyrestart  (FILE * input_file )
{

	if ( ! YY_CURRENT_BUFFER ){
        wkt_yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            wkt_yy_create_buffer(wkt_yyin,YY_BUF_SIZE );
	}

	wkt_yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	wkt_yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 *
 */
    void wkt_yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		wkt_yypop_buffer_state();
	 *		wkt_yypush_buffer_state(new_buffer);
     */
	wkt_yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	wkt_yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (wkt_yywrap()) processing, but the only time this flag
	 * is looked at is after wkt_yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void wkt_yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	wkt_yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 *
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE wkt_yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) wkt_yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in wkt_yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) wkt_yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in wkt_yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	wkt_yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with wkt_yy_create_buffer()
 *
 */
    void wkt_yy_delete_buffer (YY_BUFFER_STATE  b )
{

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		wkt_yyfree((void *) b->yy_ch_buf  );

	wkt_yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a wkt_yyrestart() or at EOF.
 */
    static void wkt_yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;

	wkt_yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then wkt_yy_init_buffer was _probably_
     * called from wkt_yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;

	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 *
 */
    void wkt_yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		wkt_yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *
 */
void wkt_yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	wkt_yyensure_buffer_stack();

	/* This block is copied from wkt_yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from wkt_yy_switch_to_buffer. */
	wkt_yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *
 */
void wkt_yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	wkt_yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		wkt_yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void wkt_yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;

	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)wkt_yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in wkt_yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)wkt_yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in wkt_yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 *
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE wkt_yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) wkt_yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in wkt_yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	wkt_yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to wkt_yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 *
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       wkt_yy_scan_bytes() instead.
 */
YY_BUFFER_STATE wkt_yy_scan_string (yyconst char * yystr )
{

	return wkt_yy_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to wkt_yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 *
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE wkt_yy_scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) wkt_yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in wkt_yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = wkt_yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in wkt_yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up wkt_yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		wkt_yytext[wkt_yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = wkt_yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		wkt_yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 *
 */
int wkt_yyget_lineno  (void)
{

    return wkt_yylineno;
}

/** Get the input stream.
 *
 */
FILE *wkt_yyget_in  (void)
{
        return wkt_yyin;
}

/** Get the output stream.
 *
 */
FILE *wkt_yyget_out  (void)
{
        return wkt_yyout;
}

/** Get the length of the current token.
 *
 */
yy_size_t wkt_yyget_leng  (void)
{
        return wkt_yyleng;
}

/** Get the current token.
 *
 */

char *wkt_yyget_text  (void)
{
        return wkt_yytext;
}

/** Set the current line number.
 * @param line_number
 *
 */
void wkt_yyset_lineno (int  line_number )
{

    wkt_yylineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 *
 * @see wkt_yy_switch_to_buffer
 */
void wkt_yyset_in (FILE *  in_str )
{
        wkt_yyin = in_str ;
}

void wkt_yyset_out (FILE *  out_str )
{
        wkt_yyout = out_str ;
}

int wkt_yyget_debug  (void)
{
        return wkt_yy_flex_debug;
}

void wkt_yyset_debug (int  bdebug )
{
        wkt_yy_flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from wkt_yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    wkt_yyin = stdin;
    wkt_yyout = stdout;
#else
    wkt_yyin = (FILE *) 0;
    wkt_yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * wkt_yylex_init()
     */
    return 0;
}

/* wkt_yylex_destroy is for both reentrant and non-reentrant scanners. */
int wkt_yylex_destroy  (void)
{

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		wkt_yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		wkt_yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	wkt_yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * wkt_yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 117 "lwin_wkt_lex.l"



void *wkt_yyalloc (yy_size_t  size )
{
	return (void *) lwalloc( size );
}

void *wkt_yyrealloc  (void * ptr, yy_size_t  size )
{
	return (void *) lwrealloc( (char *) ptr, size );
}

void wkt_yyfree (void * ptr )
{
	lwfree( (char *) ptr );	/* see wkt_yyrealloc() for (char *) cast */
}
