# +-----------------------------------------------------------------------+
# | pLoader - a Perl photo uploader for Piwigo                            |
# +-----------------------------------------------------------------------+
# | Copyright(C) 2008-2010 Piwigo Team                  http://piwigo.org |
# +-----------------------------------------------------------------------+
# | This program is free software; you can redistribute it and/or modify  |
# | it under the terms of the GNU General Public License as published by  |
# | the Free Software Foundation                                          |
# |                                                                       |
# | This program is distributed in the hope that it will be useful, but   |
# | WITHOUT ANY WARRANTY; without even the implied warranty of            |
# | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      |
# | General Public License for more details.                              |
# |                                                                       |
# | You should have received a copy of the GNU General Public License     |
# | along with this program; if not, write to the Free Software           |
# | Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, |
# | USA.                                                                  |
# +-----------------------------------------------------------------------+

use strict;
use File::Spec;
use Wx;

use Class::Accessor::Fast;
use Uploader::GUI::wxApp;
use Uploader::GUI::Frame;
use Uploader::GUI::Layout::GlobalSettings;
use Uploader::GUI::Layout::Progress;
use Uploader::GUI::Layout::Login;
use Uploader::GUI::Layout::Reupload;
use Uploader::GUI::Layout::PhotoProperties;
use Uploader::GUI::Layout::PhotoPropertiesCategoriesTags;
use Uploader::GUI::Layout::PhotoPropertiesExif;
use Uploader::GUI::Layout::DestinationCategory;
use JSON;
use Wx::Locale qw/:default/;
use Data::Dumper;
use File::HomeDir;

$SIG{__DIE__} = \&OnDieHandler;

eval {
    my $app = Uploader::GUI::wxApp->new(
            {
                root_dir      => $ENV{PLOADER_ROOT}||'..',
                resource_dir => 'res',
                locale_dir   => 'locale',
                argv         => [ grep { -f $_ } @ARGV ],
            }
    );
    $app->SetFrame( 
        Uploader::GUI::Frame->new(
            {
                title     => sprintf("pLoader - Piwigo uploader %s - [%s]", $app->version, $app->site_url),
                pwg       => $app->pwg,
                imagelist => $app->imagelist,
                imageviewer_index => $app->imageviewerIndex,
                frameLayout => $app->frameLayout,
            }
        )
    );
    $app->MainLoop();
};

sub OnDieHandler {
    my ( $exception ) = @_;
    
    # if triggered in eval
    # return if $^S;
    print $exception;
}
1;


