/*	Profile_Checker

PIRL CVS ID: Profile_Checker.java,v 1.4 2012/04/16 06:04:12 castalia Exp

Copyright (C) 2008-2012	 Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import PIRL.Conductor.Maestro.Profile;

/** A <I>Profile_Checker</I> validates a Conductor matrix definition Profile.
<p>
	@see		Profile
	@author		Michael Wendell, UA/HiROC
	@version	1.4 
*/
public class Profile_Checker
{
/**	Success exit status (0).
*/
public static final int
	EXIT_SUCCESS				= 0;

/**	Command line syntax problem exit status (1).
*/
public static final int
	EXIT_COMMAND_LINE_SYNTAX	= 1;	

/**	Profile error (2).
*/
public static final int
	EXIT_ERROR					= 2;	

private static String
	NL							= System.getProperty ("line.separator");;

/*==============================================================================
	Application main
*/
/**	Validate a Profile source.
*/
public static void main
	(
	String args[]
	)
{
System.out.println (Profile.ID);

if (args.length == 0)
	Usage ();

String
	source = null;
boolean
	verbose = false;

for (int
		count = 0;
		count < args.length;
		count++)
	{
	if (args[count].length () > 1 &&
		args[count].charAt (0) == '-')
		{
		switch (args[count].toUpperCase ().charAt (1))
			{
			case 'I':	//	Input.
				if (++count == args.length ||
					args[count].charAt(0) == '-')
					{
					System.out.println
						("Missing profile source.");
					Usage ();
					}
				if (source != null &&
					! source.equals (args[count]))
					{
					System.out.println
						("Multiple profile sources specified -" + NL
						+ source + NL
						+ "and" + NL
						+ args[count]);
					Usage ();
					}
				source = args[count];
				break;

			case 'V':	//	Verbose.
				verbose = true;
				break;

			default:
				System.out.println
					("Unrecognized argument: " + args[count]);
			case 'H':	//	Help
				Usage ();
			}
		}
	else
		{
		//	Input source.
		if (source != null &&
			! source.equals (args[count]))
			{
			System.out.println
				("Multiple profile sources specified -" + NL
				+ source + NL
				+ "and" + NL
				+ args[count]);
			Usage ();
			}
		source = args[count];
		}
	}
if (source == null)
	{
	System.out.println
		("No profile source specified.");
	Usage ();
	}

int
	status = EXIT_SUCCESS;
try 
	{
	Profile
		profile = new Profile (source);
	System.out.println
		("Valid profile: " + source);
	if (verbose)
		System.out.println (profile);
	}
/*
	CATCH THE SPECIFIC types of exception that might be thrown
	and give addequate error report.

catch (Configuration_Exception exception)
	{
	status = EXIT_CONFIGURATION_PROBLEM;
	message = exception.getMessage ();
	}
*/
catch (Exception exception)
	{
	// set status and message
	System.out.println
		("Invalid profile: " + source + '\n'
		+ exception.getMessage ());
	status = EXIT_ERROR;
	}
System.exit (status);

}

/**	Print usage statement.
*/	  
private static void Usage ()
{
System.out.println 
	("Usage: Profile_Checker [-Input] <source>" + NL
	+"  The input source may be a local file pathname or a URL." + NL
	+"  Options -" + NL
	+"    -Verbose" + NL
	+"      Lists the resultant profile." + NL
	+"      Default: Only validity results and any errors are reported." + NL
	+"    -Help" + NL
	);
System.exit (EXIT_COMMAND_LINE_SYNTAX);
}

}
