/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.stl;

import java.io.IOException;
import java.io.InputStream;

public class LittleEndianConverter {
    public static int convertToBigEndian(byte[] byArray, short[] sArray, int n, int n2, int n3) {
        return LittleEndianConverter.convertToBigEndian(byArray, sArray, n, n2, n3, (short)255);
    }

    public static int convertToBigEndian(byte[] byArray, short[] sArray, int n, int n2, int n3, short s) {
        int n4 = Math.min(n3 * 2, n / 2 * 2);
        for (int i = 0; i < n4; i += 2) {
            int n5 = (byArray[i] & 0xFF | byArray[i + 1] << 8) & s;
            sArray[i / 2 + n2] = (short)n5;
        }
        return n4;
    }

    public static int convertToBigEndian(byte[] byArray, int[] nArray, int n, int n2, int n3) {
        return LittleEndianConverter.convertToBigEndian(byArray, nArray, n, n2, n3, -1);
    }

    public static int convertToBigEndian(byte[] byArray, int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = Math.min(n3 * 4, n / 4 * 4);
        for (int i = 0; i < n5; i += 4) {
            nArray[i / 4 + n2] = (byArray[i] & 0xFF | byArray[i + 1] << 8 & 0xFF00 | byArray[i + 2] << 16 & 0xFF0000 | byArray[i + 3] << 24) & n4;
        }
        return n5;
    }

    public static int convertToBigEndian(int n, byte[] byArray, int[] nArray, int n2, int n3, int n4) {
        return LittleEndianConverter.convertToBigEndian(n, byArray, nArray, n2, n3, n4, -1);
    }

    public static int convertToBigEndian(int n, byte[] byArray, int[] nArray, int n2, int n3, int n4, int n5) {
        int n6 = Math.min(n4 * n, n2 / n * n);
        if (n == 2) {
            for (int i = 0; i < n6; i += 2) {
                nArray[i / 2 + n3] = (byArray[i] & 0xFF | byArray[i + 1] << 8) & n5;
            }
            return n6;
        }
        if (n == 3) {
            for (int i = 0; i < n6; i += 3) {
                nArray[i / 3 + n3] = (byArray[i] & 0xFF | byArray[i + 1] << 8 & 0xFF00 | byArray[i + 2] << 24) & n5;
            }
            return n6;
        }
        if (n == 4) {
            return LittleEndianConverter.convertToBigEndian(byArray, nArray, n2, n3, n4, n5);
        }
        return 0;
    }

    public static int read(byte[] byArray, short[] sArray, int n, int n2, InputStream inputStream) throws IOException {
        return LittleEndianConverter.read(byArray, sArray, n, n2, inputStream, (short)255);
    }

    public static int read(byte[] byArray, short[] sArray, int n, int n2, InputStream inputStream, short s) throws IOException {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = byArray.length / 2 * 2;
        for (n3 = 0; n5 >= 0 && n3 < n2; n3 += n4 / 2) {
            int n8 = Math.min((n2 - n3) * 2, n7);
            n5 = inputStream.read(byArray, n6, n8 - n6);
            if (n5 - (n4 = LittleEndianConverter.convertToBigEndian(byArray, sArray, n5 + n6, n + n3, n2 - n3, s)) == 1) {
                n6 = 1;
                byArray[0] = byArray[n4];
                continue;
            }
            n6 = 0;
        }
        return n3;
    }

    public static int read(byte[] byArray, int[] nArray, int n, int n2, InputStream inputStream) throws IOException {
        return LittleEndianConverter.read(byArray, nArray, n, n2, inputStream, -1);
    }

    public static int read(byte[] byArray, int[] nArray, int n, int n2, InputStream inputStream, int n3) throws IOException {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = byArray.length / 4 * 4;
        for (n4 = 0; n6 >= 0 && n4 < n2; n4 += n5 / 4) {
            int n9 = Math.min((n2 - n4) * 4, n8);
            n6 = inputStream.read(byArray, n7, n9 - n7);
            n5 = LittleEndianConverter.convertToBigEndian(byArray, nArray, n6 + n7, n + n4, n2 - n4, n3);
            int n10 = n6 - n5;
            n7 = 0;
            if (n10 == 1) {
                n7 = 1;
                byArray[0] = byArray[n5];
            }
            if (n10 == 2) {
                n7 = 2;
                byArray[1] = byArray[n5 + 1];
            }
            if (n10 != 3) continue;
            n7 = 3;
            byArray[2] = byArray[n5 + 2];
        }
        return n4;
    }

    public static int read(int n, byte[] byArray, int[] nArray, int n2, int n3, InputStream inputStream) throws IOException {
        return LittleEndianConverter.read(n, byArray, nArray, n2, n3, inputStream, -1);
    }

    public static int read(int n, byte[] byArray, int[] nArray, int n2, int n3, InputStream inputStream, int n4) throws IOException {
        if (n == 2) {
            return LittleEndianConverter.read2ByteBlock(byArray, nArray, n2, n3, inputStream, n4);
        }
        if (n == 3) {
            return LittleEndianConverter.read3ByteBlock(byArray, nArray, n2, n3, inputStream, n4);
        }
        if (n == 4) {
            return LittleEndianConverter.read(byArray, nArray, n2, n3, inputStream, n4);
        }
        return 0;
    }

    public static int read4ByteBlock(InputStream inputStream) throws IOException {
        return LittleEndianConverter.read(inputStream) & 0xFF | LittleEndianConverter.read(inputStream) << 8 & 0xFF00 | LittleEndianConverter.read(inputStream) << 16 & 0xFF0000 | LittleEndianConverter.read(inputStream) << 24;
    }

    public static int read2ByteBlock(InputStream inputStream) throws IOException {
        return LittleEndianConverter.read(inputStream) & 0xFF | LittleEndianConverter.read(inputStream) << 8;
    }

    public static int read3ByteBlock(InputStream inputStream) throws IOException {
        return LittleEndianConverter.read(inputStream) & 0xFF | LittleEndianConverter.read(inputStream) << 8 & 0xFF00 | LittleEndianConverter.read(inputStream) << 16;
    }

    private static int read2ByteBlock(byte[] byArray, int[] nArray, int n, int n2, InputStream inputStream, int n3) throws IOException {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = byArray.length / 2 * 2;
        for (n4 = 0; n6 >= 0 && n4 < n2; n4 += n5 / 2) {
            int n9 = Math.max((n2 - n4) * 2, n8);
            n6 = inputStream.read(byArray, n7, n9 - n7);
            if (n6 - (n5 = LittleEndianConverter.convertToBigEndian(2, byArray, nArray, n6 + n7, n + n4, n2 - n4, n3)) == 1) {
                n7 = 1;
                byArray[0] = byArray[n5];
                continue;
            }
            n7 = 0;
        }
        return n4;
    }

    private static int read3ByteBlock(byte[] byArray, int[] nArray, int n, int n2, InputStream inputStream, int n3) throws IOException {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = byArray.length / 3 * 3;
        for (n4 = 0; n6 >= 0 && n4 < n2; n4 += n5 / 3) {
            int n9 = Math.max((n2 - n4) * 3, n8);
            n6 = inputStream.read(byArray, n7, n9 - n7);
            n5 = LittleEndianConverter.convertToBigEndian(3, byArray, nArray, n6 + n7, n + n4, n2 - n4, n3);
            int n10 = n6 - n5;
            n7 = 0;
            if (n10 == 1) {
                n7 = 1;
                byArray[0] = byArray[n5];
            }
            if (n10 != 2) continue;
            n7 = 2;
            byArray[1] = byArray[n5 + 1];
        }
        return n4;
    }

    private static int read(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new IOException("Filesize does not match blocksize");
        }
        return n;
    }
}

