// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    vpc "github.com/jdcloud-api/jdcloud-sdk-go/services/vpc/models"
)

type ModifyNetworkSecurityGroupRulesRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* NetworkSecurityGroup ID  */
    NetworkSecurityGroupId string `json:"networkSecurityGroupId"`

    /* 安全组规则信息  */
    ModifySecurityGroupRuleSpecs []vpc.ModifySecurityGroupRules `json:"modifySecurityGroupRuleSpecs"`
}

/*
 * param regionId: Region ID (Required)
 * param networkSecurityGroupId: NetworkSecurityGroup ID (Required)
 * param modifySecurityGroupRuleSpecs: 安全组规则信息 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewModifyNetworkSecurityGroupRulesRequest(
    regionId string,
    networkSecurityGroupId string,
    modifySecurityGroupRuleSpecs []vpc.ModifySecurityGroupRules,
) *ModifyNetworkSecurityGroupRulesRequest {

	return &ModifyNetworkSecurityGroupRulesRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/networkSecurityGroups/{networkSecurityGroupId}:modifyNetworkSecurityGroupRules",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        NetworkSecurityGroupId: networkSecurityGroupId,
        ModifySecurityGroupRuleSpecs: modifySecurityGroupRuleSpecs,
	}
}

/*
 * param regionId: Region ID (Required)
 * param networkSecurityGroupId: NetworkSecurityGroup ID (Required)
 * param modifySecurityGroupRuleSpecs: 安全组规则信息 (Required)
 */
func NewModifyNetworkSecurityGroupRulesRequestWithAllParams(
    regionId string,
    networkSecurityGroupId string,
    modifySecurityGroupRuleSpecs []vpc.ModifySecurityGroupRules,
) *ModifyNetworkSecurityGroupRulesRequest {

    return &ModifyNetworkSecurityGroupRulesRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/networkSecurityGroups/{networkSecurityGroupId}:modifyNetworkSecurityGroupRules",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        NetworkSecurityGroupId: networkSecurityGroupId,
        ModifySecurityGroupRuleSpecs: modifySecurityGroupRuleSpecs,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewModifyNetworkSecurityGroupRulesRequestWithoutParam() *ModifyNetworkSecurityGroupRulesRequest {

    return &ModifyNetworkSecurityGroupRulesRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/networkSecurityGroups/{networkSecurityGroupId}:modifyNetworkSecurityGroupRules",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *ModifyNetworkSecurityGroupRulesRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param networkSecurityGroupId: NetworkSecurityGroup ID(Required) */
func (r *ModifyNetworkSecurityGroupRulesRequest) SetNetworkSecurityGroupId(networkSecurityGroupId string) {
    r.NetworkSecurityGroupId = networkSecurityGroupId
}

/* param modifySecurityGroupRuleSpecs: 安全组规则信息(Required) */
func (r *ModifyNetworkSecurityGroupRulesRequest) SetModifySecurityGroupRuleSpecs(modifySecurityGroupRuleSpecs []vpc.ModifySecurityGroupRules) {
    r.ModifySecurityGroupRuleSpecs = modifySecurityGroupRuleSpecs
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r ModifyNetworkSecurityGroupRulesRequest) GetRegionId() string {
    return r.RegionId
}

type ModifyNetworkSecurityGroupRulesResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result ModifyNetworkSecurityGroupRulesResult `json:"result"`
}

type ModifyNetworkSecurityGroupRulesResult struct {
}