// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type AssociateElasticIpRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* networkInterface ID  */
    NetworkInterfaceId string `json:"networkInterfaceId"`

    /* 绑定的弹性Ip Id (Optional) */
    ElasticIpId *string `json:"elasticIpId"`

    /* 绑定弹性Ip到指定的privateIp (Optional) */
    PrivateIpAddress *string `json:"privateIpAddress"`

    /* 绑定的弹性Ip地址 (Optional) */
    ElasticIpAddress *string `json:"elasticIpAddress"`
}

/*
 * param regionId: Region ID (Required)
 * param networkInterfaceId: networkInterface ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewAssociateElasticIpRequest(
    regionId string,
    networkInterfaceId string,
) *AssociateElasticIpRequest {

	return &AssociateElasticIpRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/networkInterfaces/{networkInterfaceId}:associateElasticIp",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        NetworkInterfaceId: networkInterfaceId,
	}
}

/*
 * param regionId: Region ID (Required)
 * param networkInterfaceId: networkInterface ID (Required)
 * param elasticIpId: 绑定的弹性Ip Id (Optional)
 * param privateIpAddress: 绑定弹性Ip到指定的privateIp (Optional)
 * param elasticIpAddress: 绑定的弹性Ip地址 (Optional)
 */
func NewAssociateElasticIpRequestWithAllParams(
    regionId string,
    networkInterfaceId string,
    elasticIpId *string,
    privateIpAddress *string,
    elasticIpAddress *string,
) *AssociateElasticIpRequest {

    return &AssociateElasticIpRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/networkInterfaces/{networkInterfaceId}:associateElasticIp",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        NetworkInterfaceId: networkInterfaceId,
        ElasticIpId: elasticIpId,
        PrivateIpAddress: privateIpAddress,
        ElasticIpAddress: elasticIpAddress,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewAssociateElasticIpRequestWithoutParam() *AssociateElasticIpRequest {

    return &AssociateElasticIpRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/networkInterfaces/{networkInterfaceId}:associateElasticIp",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *AssociateElasticIpRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param networkInterfaceId: networkInterface ID(Required) */
func (r *AssociateElasticIpRequest) SetNetworkInterfaceId(networkInterfaceId string) {
    r.NetworkInterfaceId = networkInterfaceId
}

/* param elasticIpId: 绑定的弹性Ip Id(Optional) */
func (r *AssociateElasticIpRequest) SetElasticIpId(elasticIpId string) {
    r.ElasticIpId = &elasticIpId
}

/* param privateIpAddress: 绑定弹性Ip到指定的privateIp(Optional) */
func (r *AssociateElasticIpRequest) SetPrivateIpAddress(privateIpAddress string) {
    r.PrivateIpAddress = &privateIpAddress
}

/* param elasticIpAddress: 绑定的弹性Ip地址(Optional) */
func (r *AssociateElasticIpRequest) SetElasticIpAddress(elasticIpAddress string) {
    r.ElasticIpAddress = &elasticIpAddress
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r AssociateElasticIpRequest) GetRegionId() string {
    return r.RegionId
}

type AssociateElasticIpResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result AssociateElasticIpResult `json:"result"`
}

type AssociateElasticIpResult struct {
}