// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    vm "github.com/jdcloud-api/jdcloud-sdk-go/services/vm/models"
)

type CopyImagesRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 源镜像ID  */
    SourceImageIds []string `json:"sourceImageIds"`

    /* 目标区域  */
    DestinationRegion string `json:"destinationRegion"`
}

/*
 * param regionId: 地域ID (Required)
 * param sourceImageIds: 源镜像ID (Required)
 * param destinationRegion: 目标区域 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewCopyImagesRequest(
    regionId string,
    sourceImageIds []string,
    destinationRegion string,
) *CopyImagesRequest {

	return &CopyImagesRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/images:copyImages",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        SourceImageIds: sourceImageIds,
        DestinationRegion: destinationRegion,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param sourceImageIds: 源镜像ID (Required)
 * param destinationRegion: 目标区域 (Required)
 */
func NewCopyImagesRequestWithAllParams(
    regionId string,
    sourceImageIds []string,
    destinationRegion string,
) *CopyImagesRequest {

    return &CopyImagesRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/images:copyImages",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        SourceImageIds: sourceImageIds,
        DestinationRegion: destinationRegion,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewCopyImagesRequestWithoutParam() *CopyImagesRequest {

    return &CopyImagesRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/images:copyImages",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *CopyImagesRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param sourceImageIds: 源镜像ID(Required) */
func (r *CopyImagesRequest) SetSourceImageIds(sourceImageIds []string) {
    r.SourceImageIds = sourceImageIds
}

/* param destinationRegion: 目标区域(Required) */
func (r *CopyImagesRequest) SetDestinationRegion(destinationRegion string) {
    r.DestinationRegion = destinationRegion
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r CopyImagesRequest) GetRegionId() string {
    return r.RegionId
}

type CopyImagesResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result CopyImagesResult `json:"result"`
}

type CopyImagesResult struct {
    CopyImages []vm.CopyImage `json:"copyImages"`
}