#!/bin/sh
#
# autogen.sh glue
#
# Requires: automake 1.9, autoconf 2.57+, libtool 1.5.6+
# Conflicts: autoconf 2.13
set -e

# Refresh GNU autotools toolchain.
echo Cleaning autotools files...
find -type d -name autom4te.cache -print0 | xargs -0 rm -rf \;
find -type f \( -name aclocal.m4 -o -name INSTALL -o -name missing \
	-o -name install-sh -o -name depcomp -o -name ltmain.sh \
	-o -name configure -o -name Makefile.in -o -name Makefile \
	\) -print0 | xargs -0 rm -f

echo Running autoreconf...
autoreconf --force --install

# For the Debian package build
test -d debian && {
	# link these in Debian builds
	rm -f config.sub config.guess
	ln -s /usr/share/misc/config.sub .
	ln -s /usr/share/misc/config.guess .
}
exit 0
