#ifndef CO2TABLES_INC
#define CO2TABLES_INC

/* Tables for CO2 fluid properties calculated according to Span and
 * Wagner (1996).
 *
 * THIS AN AUTO-GENERATED FILE! DO NOT EDIT IT!
 *
 * Temperature range: 280.000 K to 400.000 K, using 200 sampling points
 * Pressure range: 0.100 MPa to 100.000 MPa, using 500 sampling points
 *
 * Generated using:
 *
 * ./extractproperties 280.0 400.0 200 1e5 100e6 500
 */
struct TabulatedDensityTraits {
    typedef double Scalar;
    static const char  *name;
    static const int    numX = 200;
    static const Scalar xMin;
    static const Scalar xMax;
    static const int    numY = 500;
    static const Scalar yMin;
    static const Scalar yMax;

    static const std::vector<std::vector<Scalar>> vals;
};

inline const double TabulatedDensityTraits::xMin = 2.800000000000000e+02;
inline const double TabulatedDensityTraits::xMax = 4.000000000000000e+02;
inline const double TabulatedDensityTraits::yMin = 1.000000000000000e+05;
inline const double TabulatedDensityTraits::yMax = 1.000000000000000e+08;
inline const char  *TabulatedDensityTraits::name = "density";

inline const std::vector<std::vector<double>> TabulatedDensityTraits::vals =
{
    {
            1.902062465274410e+00,     5.782408947482105e+00,     9.764909779046345e+00,     1.385694970929571e+01,     1.806682704790397e+01, 
            2.240391789044656e+01,     2.687888030157356e+01,     3.150391104248634e+01,     3.629307240336141e+01,     4.126271410164965e+01, 
            4.643202645965111e+01,     5.182377862839375e+01,     5.746532380925083e+01,     6.339000019560863e+01,     6.963913698776773e+01, 
            7.626502018649226e+01,     8.333544920754456e+01,     9.094107565501655e+01,     9.920794710517262e+01,     1.083206802964683e+02, 
            1.185701068818210e+02,     8.854494190604881e+02,     8.879785335109976e+02,     8.904262882902154e+02,     8.927992468133788e+02, 
            8.951031318186318e+02,     8.973429696398650e+02,     8.995232040155760e+02,     9.016477869623172e+02,     9.037202521331737e+02, 
            9.057437746274870e+02,     9.077212201969121e+02,     9.096551860638534e+02,     9.115480350401762e+02,     9.134019242461904e+02, 
            9.152188294415341e+02,     9.170005657625713e+02,     9.187488054960497e+02,     9.204650933921371e+02,     9.221508599218751e+02, 
            9.238074328074559e+02,     9.254360470933484e+02,     9.270378539784197e+02,     9.286139285909143e+02,     9.301652768573648e+02, 
            9.316928415915886e+02,     9.331975079096469e+02,     9.346801080600167e+02,     9.361414257445779e+02,     9.375821999946785e+02, 
            9.390031286571951e+02,     9.404048715376014e+02,     9.417880532405302e+02,     9.431532657427566e+02,     9.445010707288508e+02, 
            9.458320017157859e+02,     9.471465659893925e+02,     9.484452463727065e+02,     9.497285028437043e+02,     9.509967740178902e+02, 
            9.522504785092801e+02,     9.534900161817900e+02,     9.547157693016472e+02,     9.559281036002363e+02,     9.571273692557639e+02, 
            9.583139018012021e+02,     9.594880229651809e+02,     9.606500414517863e+02,     9.618002536646125e+02,     9.629389443798724e+02, 
            9.640663873728772e+02,     9.651828460017828e+02,     9.662885737521152e+02,     9.673838147452494e+02,     9.684688042137223e+02, 
            9.695437689459729e+02,     9.706089276180203e+02,     9.716644915978965e+02,     9.727106645158618e+02,     9.737476433521387e+02, 
            9.747756184413023e+02,     9.757947738088723e+02,     9.768052874684155e+02,     9.778073316915960e+02,     9.788010732628253e+02, 
            9.797866737196128e+02,     9.807642895795473e+02,     9.817340725548294e+02,     9.826961697551750e+02,     9.836507238798470e+02, 
            9.845978733995188e+02,     9.855377527286311e+02,     9.864704923888187e+02,     9.873962191639979e+02,     9.883150562475956e+02, 
            9.892271233824258e+02,     9.901325369936478e+02,     9.910314103152165e+02,     9.919238535102137e+02,     9.928099737854243e+02, 
            9.936898755004695e+02,     9.945636602718411e+02,     9.954314270338984e+02,     9.962932722901271e+02,     9.971492899623968e+02, 
            9.979995716423658e+02,     9.988442066314290e+02,     9.996832820195211e+02,     1.000516882761657e+03,     1.001345091750705e+03, 
            1.002167989884925e+03,     1.002985656133857e+03,     1.003798167601575e+03,     1.004605599587296e+03,     1.005408025643485e+03, 
            1.006205517631585e+03,     1.006998145287122e+03,     1.007785978031880e+03,     1.008569082626186e+03,     1.009347524675879e+03, 
            1.010121368342580e+03,     1.010890676387412e+03,     1.011655510213040e+03,     1.012415929904121e+03,     1.013171994266196e+03, 
            1.013923760863141e+03,     1.014671286053226e+03,     1.015414625023823e+03,     1.016153831824862e+03,     1.016888959401063e+03, 
            1.017620059623004e+03,     1.018347183317085e+03,     1.019070380294416e+03,     1.019789699378710e+03,     1.020505188433175e+03, 
            1.021216894386496e+03,     1.021924863257907e+03,     1.022629140181417e+03,     1.023329769429214e+03,     1.024026794434275e+03, 
            1.024720257812229e+03,     1.025410201382490e+03,     1.026096666188696e+03,     1.026779692518485e+03,     1.027459319922621e+03, 
            1.028135587233511e+03,     1.028808532583127e+03,     1.029478193420360e+03,     1.030144606527828e+03,     1.030807808038151e+03, 
            1.031467833449729e+03,     1.032124717642034e+03,     1.032778494890416e+03,     1.033429198880478e+03,     1.034076862722004e+03, 
            1.034721518962479e+03,     1.035363199600185e+03,     1.036001936096935e+03,     1.036637759390410e+03,     1.037270699906145e+03, 
            1.037900787569165e+03,     1.038528051815284e+03,     1.039152521602076e+03,     1.039774225419542e+03,     1.040393191300461e+03, 
            1.041009446796455e+03,     1.041623019125929e+03,     1.042233934973011e+03,     1.042842220639511e+03,     1.043447902017622e+03, 
            1.044051004598675e+03,     1.044651553481646e+03,     1.045249573381436e+03,     1.045845088636931e+03,     1.046438123218846e+03, 
            1.047028700737359e+03,     1.047616844449543e+03,     1.048202577266607e+03,     1.048785921760941e+03,     1.049366900172994e+03, 
            1.049945534417949e+03,     1.050521846092252e+03,     1.051095856479960e+03,     1.051667586558933e+03,     1.052237057006867e+03, 
            1.052804288207180e+03,     1.053369300254750e+03,     1.053932112961504e+03,     1.054492745861879e+03,     1.055051218218147e+03, 
            1.055607549025601e+03,     1.056161757017627e+03,     1.056713860670647e+03,     1.057263878208944e+03,     1.057811827609377e+03, 
            1.058357726605968e+03,     1.058901592694409e+03,     1.059443443136430e+03,     1.059983294964093e+03,     1.060521164983962e+03, 
            1.061057069781201e+03,     1.061591025723557e+03,     1.062123048965260e+03,     1.062653155450835e+03,     1.063181360918831e+03, 
            1.063707680905451e+03,     1.064232130748117e+03,     1.064754725588948e+03,     1.065275480378162e+03,     1.065794409877396e+03, 
            1.066311528662968e+03,     1.066826851129051e+03,     1.067340391490789e+03,     1.067852163787338e+03,     1.068362181884847e+03, 
            1.068870459479372e+03,     1.069377010099729e+03,     1.069881847110283e+03,     1.070384983713681e+03,     1.070886432953526e+03, 
            1.071386207716996e+03,     1.071884320737408e+03,     1.072380784596723e+03,     1.072875611728015e+03,     1.073368814417864e+03, 
            1.073860404808724e+03,     1.074350394901229e+03,     1.074838796556455e+03,     1.075325621498139e+03,     1.075810881314846e+03, 
            1.076294587462105e+03,     1.076776751264486e+03,     1.077257383917652e+03,     1.077736496490355e+03,     1.078214099926408e+03, 
            1.078690205046604e+03,     1.079164822550607e+03,     1.079637963018801e+03,     1.080109636914105e+03,     1.080579854037036e+03, 
            1.081048625700933e+03,     1.081515961493393e+03,     1.081981871424941e+03,     1.082446365397208e+03,     1.082909453204537e+03, 
            1.083371144535579e+03,     1.083831448974841e+03,     1.084290376004220e+03,     1.084747935004494e+03,     1.085204135256802e+03, 
            1.085658985944080e+03,     1.086112496152482e+03,     1.086564674872768e+03,     1.087015531001675e+03,     1.087465073343252e+03, 
            1.087913310610182e+03,     1.088360251425072e+03,     1.088805904321720e+03,     1.089250277746370e+03,     1.089693380058928e+03, 
            1.090135219534171e+03,     1.090575804362926e+03,     1.091015142653231e+03,     1.091453242431478e+03,     1.091890111643530e+03, 
            1.092325758155822e+03,     1.092760189756449e+03,     1.093193414156223e+03,     1.093625438989717e+03,     1.094056271816302e+03, 
            1.094485920121142e+03,     1.094914391316198e+03,     1.095341692741198e+03,     1.095767831664598e+03,     1.096192815284522e+03, 
            1.096616650729693e+03,     1.097039345060342e+03,     1.097460905269104e+03,     1.097881338281900e+03,     1.098300650958804e+03, 
            1.098718850094896e+03,     1.099135942421101e+03,     1.099551934605011e+03,     1.099966833251698e+03,     1.100380644904514e+03, 
            1.100793376045876e+03,     1.101205033098033e+03,     1.101615622423833e+03,     1.102025150327470e+03,     1.102433623087449e+03, 
            1.102841046827257e+03,     1.103247427712889e+03,     1.103652771821158e+03,     1.104057085173788e+03,     1.104460373738090e+03, 
            1.104862643427636e+03,     1.105263900102917e+03,     1.105664149571985e+03,     1.106063397591100e+03,     1.106461649865352e+03, 
            1.106858912049284e+03,     1.107255189747499e+03,     1.107650488515263e+03,     1.108044813859089e+03,     1.108438171237329e+03, 
            1.108830566060738e+03,     1.109222003693043e+03,     1.109612489451501e+03,     1.110002028607440e+03,     1.110390626386805e+03, 
            1.110778287970687e+03,     1.111165018495844e+03,     1.111550823055221e+03,     1.111935706698459e+03,     1.112319674432389e+03, 
            1.112702731221530e+03,     1.113084881988580e+03,     1.113466131614883e+03,     1.113846484940914e+03,     1.114225946766734e+03, 
            1.114604521852458e+03,     1.114982214918698e+03,     1.115359030647014e+03,     1.115734973680356e+03,     1.116110048623485e+03, 
            1.116484260043415e+03,     1.116857612469822e+03,     1.117230110395467e+03,     1.117601758276598e+03,     1.117972560533357e+03, 
            1.118342521550179e+03,     1.118711645676181e+03,     1.119079937225549e+03,     1.119447400477921e+03,     1.119814039678761e+03, 
            1.120179859039732e+03,     1.120544862739060e+03,     1.120909054921893e+03,     1.121272439700663e+03,     1.121635021155429e+03, 
            1.121996803334228e+03,     1.122357790253417e+03,     1.122717985898005e+03,     1.123077394221992e+03,     1.123436019148691e+03, 
            1.123793864571056e+03,     1.124150934351995e+03,     1.124507232324693e+03,     1.124862762292918e+03,     1.125217528031326e+03, 
            1.125571533285767e+03,     1.125924781773584e+03,     1.126277277183902e+03,     1.126629023177929e+03,     1.126980023389231e+03, 
            1.127330281424024e+03,     1.127679800861449e+03,     1.128028585253854e+03,     1.128376638127057e+03,     1.128723962980623e+03, 
            1.129070563288125e+03,     1.129416442497411e+03,     1.129761604030856e+03,     1.130106051285621e+03,     1.130449787633908e+03, 
            1.130792816423203e+03,     1.131135140976525e+03,     1.131476764592671e+03,     1.131817690546452e+03,     1.132157922088932e+03, 
            1.132497462447660e+03,     1.132836314826901e+03,     1.133174482407866e+03,     1.133511968348937e+03,     1.133848775785886e+03, 
            1.134184907832098e+03,     1.134520367578787e+03,     1.134855158095210e+03,     1.135189282428878e+03,     1.135522743605768e+03, 
            1.135855544630525e+03,     1.136187688486670e+03,     1.136519178136799e+03,     1.136850016522785e+03,     1.137180206565971e+03, 
            1.137509751167366e+03,     1.137838653207839e+03,     1.138166915548307e+03,     1.138494541029920e+03,     1.138821532474251e+03, 
            1.139147892683478e+03,     1.139473624440561e+03,     1.139798730509424e+03,     1.140123213635133e+03,     1.140447076544067e+03, 
            1.140770321944095e+03,     1.141092952524739e+03,     1.141414970957351e+03,     1.141736379895276e+03,     1.142057181974015e+03, 
            1.142377379811392e+03,     1.142696976007709e+03,     1.143015973145910e+03,     1.143334373791737e+03,     1.143652180493883e+03, 
            1.143969395784150e+03,     1.144286022177596e+03,     1.144602062172690e+03,     1.144917518251455e+03,     1.145232392879620e+03, 
            1.145546688506763e+03,     1.145860407566453e+03,     1.146173552476393e+03,     1.146486125638562e+03,     1.146798129439350e+03, 
            1.147109566249701e+03,     1.147420438425241e+03,     1.147730748306418e+03,     1.148040498218634e+03,     1.148349690472371e+03, 
            1.148658327363329e+03,     1.148966411172547e+03,     1.149273944166534e+03,     1.149580928597394e+03,     1.149887366702949e+03, 
            1.150193260706862e+03,     1.150498612818758e+03,     1.150803425234348e+03,     1.151107700135540e+03,     1.151411439690566e+03, 
            1.151714646054091e+03,     1.152017321367332e+03,     1.152319467758168e+03,     1.152621087341259e+03,     1.152922182218149e+03, 
            1.153222754477383e+03,     1.153522806194615e+03,     1.153822339432713e+03,     1.154121356241866e+03,     1.154419858659694e+03, 
            1.154717848711346e+03,     1.155015328409610e+03,     1.155312299755010e+03,     1.155608764735911e+03,     1.155904725328616e+03, 
            1.156200183497467e+03,     1.156495141194944e+03,     1.156789600361760e+03,     1.157083562926958e+03,     1.157377030808008e+03, 
            1.157670005910896e+03,     1.157962490130224e+03,     1.158254485349295e+03,     1.158545993440211e+03,     1.158837016263959e+03, 
            1.159127555670503e+03,     1.159417613498867e+03,     1.159707191577233e+03,     1.159996291723017e+03,     1.160284915742961e+03, 
            1.160573065433215e+03,     1.160860742579425e+03,     1.161147948956811e+03,     1.161434686330254e+03,     1.161720956454375e+03, 
            1.162006761073617e+03,     1.162292101922325e+03,     1.162576980724823e+03,     1.162861399195496e+03,     1.163145359038866e+03, 
            1.163428861949668e+03,     1.163711909612927e+03,     1.163994503704034e+03,     1.164276645888819e+03,     1.164558337823626e+03, 
            1.164839581155387e+03,     1.165120377521692e+03,     1.165400728550865e+03,     1.165680635862029e+03,     1.165960101065180e+03, 
            1.166239125761260e+03,     1.166517711542220e+03,     1.166795859991090e+03,     1.167073572682049e+03,     1.167350851180491e+03, 
            1.167627697043089e+03,     1.167904111817867e+03,     1.168180097044255e+03,     1.168455654253164e+03,     1.168730784967044e+03, 
            1.169005490699950e+03,     1.169279772957602e+03,     1.169553633237449e+03,     1.169827073028731e+03,     1.170100093812538e+03, 
            1.170372697061873e+03,     1.170644884241709e+03,     1.170916656809051e+03,     1.171188016212992e+03,     1.171458963894774e+03
    },
    {
            1.897892024419196e+00,     5.769198901625546e+00,     9.741637104801628e+00,     1.382244919643777e+01,     1.801976430574418e+01, 
            2.234275567750812e+01,     2.680183607917451e+01,     3.140890283280867e+01,     3.617764882219485e+01,     4.112396261068361e+01, 
            4.626645106490927e+01,     5.162713378264723e+01,     5.723238397308106e+01,     6.311423215571226e+01,     6.931222026906183e+01, 
            7.587612071220410e+01,     8.287007284547806e+01,     9.037916401355885e+01,     9.852050266878824e+01,     1.074632501590755e+02, 
            1.174685998450163e+02,     8.804918344232983e+02,     8.831340407915449e+02,     8.856863638572646e+02,     8.881564260809776e+02, 
            8.905508295484927e+02,     8.928753382524893e+02,     8.951350204155106e+02,     8.973343610868611e+02,     8.994773522811522e+02, 
            9.015675659120086e+02,     9.036082133790358e+02,     9.056021946822162e+02,     9.075521392329015e+02,     9.094604400182327e+02, 
            9.113292823981748e+02,     9.131606685329563e+02,     9.149564382263258e+02,     9.167182868083199e+02,     9.184477805566872e+02, 
            9.201463700595530e+02,     9.218154018461793e+02,     9.234561285530361e+02,     9.250697178449077e+02,     9.266572602727925e+02, 
            9.282197762197889e+02,     9.297582220612965e+02,     9.312734956457367e+02,     9.327664411853355e+02,     9.342378536329397e+02, 
            9.356884826094720e+02,     9.371190359372586e+02,     9.385301828266042e+02,     9.399225567563726e+02,     9.412967580838070e+02, 
            9.426533564141025e+02,     9.439928927562445e+02,     9.453158814882669e+02,     9.466228121521485e+02,     9.479141510960542e+02, 
            9.491903429795576e+02,     9.504518121555295e+02,     9.516989639408724e+02,     9.529321857868346e+02,     9.541518483584344e+02, 
            9.553583065314973e+02,     9.565519003148630e+02,     9.577329557045099e+02,     9.589017854756610e+02,     9.600586899182779e+02, 
            9.612039575208117e+02,     9.623378656066046e+02,     9.634606809268737e+02,     9.645726602138634e+02,     9.656740506973670e+02, 
            9.667650905875554e+02,     9.678460095267592e+02,     9.689170289634773e+02,     9.699783627928709e+02,     9.710302172467110e+02, 
            9.720727917162817e+02,     9.731062788532396e+02,     9.741308649189153e+02,     9.751467300771590e+02,     9.761540486685826e+02, 
            9.771529894691784e+02,     9.781437159343843e+02,     9.791263864295767e+02,     9.801011544479038e+02,     9.810681688163160e+02, 
            9.820275738905211e+02,     9.829795097396443e+02,     9.839241123211881e+02,     9.848615136469557e+02,     9.857918419404650e+02, 
            9.867152217864082e+02,     9.876317742726246e+02,     9.885416171250451e+02,     9.894448648360269e+02,     9.903416287864803e+02, 
            9.912320173621273e+02,     9.921161360642534e+02,     9.929940876152679e+02,     9.938659720155295e+02,     9.947318868190386e+02, 
            9.955919269485125e+02,     9.964461849723624e+02,     9.972947511395624e+02,     9.981377134599330e+02,     9.989751577823222e+02, 
            9.998071678665925e+02,     1.000633825452904e+03,     1.001455210328667e+03,     1.002271400392693e+03,     1.003082471716643e+03, 
            1.003888498603955e+03,     1.004689553212236e+03,     1.005485707170105e+03,     1.006277029519372e+03,     1.007063587993921e+03, 
            1.007845448872027e+03,     1.008622676952497e+03,     1.009395335616944e+03,     1.010163486872406e+03,     1.010927191392327e+03, 
            1.011686508555986e+03,     1.012441496486446e+03,     1.013192212087085e+03,     1.013938711076780e+03,     1.014681048023799e+03, 
            1.015419276378453e+03,     1.016153448504583e+03,     1.016883615709907e+03,     1.017609828275297e+03,     1.018332135483017e+03, 
            1.019050585643980e+03,     1.019765226124053e+03,     1.020476103369460e+03,     1.021183262931316e+03,     1.021886749489323e+03, 
            1.022586606874677e+03,     1.023282878092203e+03,     1.023975605341753e+03,     1.024664830038913e+03,     1.025350592835007e+03, 
            1.026032933636479e+03,     1.026711891623637e+03,     1.027387505268792e+03,     1.028059812353829e+03,     1.028728849987220e+03, 
            1.029394654620507e+03,     1.030057262064265e+03,     1.030716707503578e+03,     1.031373025513032e+03,     1.032026250071260e+03, 
            1.032676414575044e+03,     1.033323551852982e+03,     1.033967694178761e+03,     1.034608873284026e+03,     1.035247120370876e+03, 
            1.035882466123985e+03,     1.036514940722378e+03,     1.037144573850861e+03,     1.037771394711128e+03,     1.038395432032539e+03, 
            1.039016714082607e+03,     1.039635268644472e+03,     1.040251123159672e+03,     1.040864304535246e+03,     1.041474839290339e+03, 
            1.042082753530404e+03,     1.042688072956045e+03,     1.043290822871629e+03,     1.043891028193657e+03,     1.044488713458916e+03, 
            1.045083902832411e+03,     1.045676620115087e+03,     1.046266888751340e+03,     1.046854731836342e+03,     1.047440172123173e+03, 
            1.048023232029755e+03,     1.048603933645620e+03,     1.049182298738505e+03,     1.049758348760769e+03,     1.050332104855649e+03, 
            1.050903587863371e+03,     1.051472818327088e+03,     1.052039816498685e+03,     1.052604602344434e+03,     1.053167195550507e+03, 
            1.053727615528359e+03,     1.054285881419975e+03,     1.054842012102992e+03,     1.055396026195697e+03,     1.055947942061902e+03, 
            1.056497777815707e+03,     1.057045551326150e+03,     1.057591280221737e+03,     1.058134981894877e+03,     1.058676673506212e+03, 
            1.059216371988833e+03,     1.059754094052423e+03,     1.060289856187273e+03,     1.060823674668237e+03,     1.061355565558571e+03, 
            1.061885544713702e+03,     1.062413627784904e+03,     1.062939830222893e+03,     1.063464167281341e+03,     1.063986654020313e+03, 
            1.064507305309626e+03,     1.065026135832137e+03,     1.065543160086951e+03,     1.066058392392574e+03,     1.066571846889978e+03, 
            1.067083537545618e+03,     1.067593478154369e+03,     1.068101682342411e+03,     1.068608163570048e+03,     1.069112935134463e+03, 
            1.069616010172427e+03,     1.070117401662934e+03,     1.070617122429796e+03,     1.071115185144177e+03,     1.071611602327071e+03, 
            1.072106386351740e+03,     1.072599549446087e+03,     1.073091103694993e+03,     1.073581061042604e+03,     1.074069433294560e+03, 
            1.074556232120199e+03,     1.075041469054698e+03,     1.075525155501182e+03,     1.076007302732788e+03,     1.076487921894686e+03, 
            1.076967024006065e+03,     1.077444619962074e+03,     1.077920720535728e+03,     1.078395335838435e+03,     1.078868477473669e+03, 
            1.079340155331139e+03,     1.079810379713656e+03,     1.080279160810888e+03,     1.080746508701050e+03,     1.081212433352577e+03, 
            1.081676944625742e+03,     1.082140052274270e+03,     1.082601765946899e+03,     1.083062095188925e+03,     1.083521049443717e+03, 
            1.083978638054198e+03,     1.084434870264301e+03,     1.084889755220406e+03,     1.085343301972733e+03,     1.085795519476734e+03, 
            1.086246416594433e+03,     1.086696002095763e+03,     1.087144284659871e+03,     1.087591272876390e+03,     1.088036975246710e+03, 
            1.088481400185207e+03,     1.088924556020455e+03,     1.089366450996423e+03,     1.089807093273646e+03,     1.090246490930371e+03, 
            1.090684651963694e+03,     1.091121584290666e+03,     1.091557295749389e+03,     1.091991794100084e+03,     1.092425087026150e+03, 
            1.092857182135195e+03,     1.093288086960060e+03,     1.093717808959815e+03,     1.094146355520747e+03,     1.094573733957326e+03, 
            1.094999951513154e+03,     1.095425015361904e+03,     1.095848932608235e+03,     1.096271710288702e+03,     1.096693355372640e+03, 
            1.097113874763039e+03,     1.097533275297407e+03,     1.097951563748611e+03,     1.098368746825716e+03,     1.098784831174796e+03, 
            1.099199823379742e+03,     1.099613729963058e+03,     1.100026557418506e+03,     1.100438312083264e+03,     1.100849000333323e+03, 
            1.101258628453288e+03,     1.101667202670146e+03,     1.102074729153988e+03,     1.102481214018711e+03,     1.102886663322720e+03, 
            1.103291083069607e+03,     1.103694479208835e+03,     1.104096857636393e+03,     1.104498224195453e+03,     1.104898584677018e+03, 
            1.105297944820547e+03,     1.105696310314591e+03,     1.106093686797392e+03,     1.106490079857503e+03,     1.106885495034376e+03, 
            1.107279937818949e+03,     1.107673413654225e+03,     1.108065927935842e+03,     1.108457486012634e+03,     1.108848093187178e+03, 
            1.109237754716346e+03,     1.109626475811835e+03,     1.110014261640697e+03,     1.110401117325857e+03,     1.110787047946630e+03, 
            1.111172058539220e+03,     1.111556154097222e+03,     1.111939339572109e+03,     1.112321619873719e+03,     1.112702999870726e+03, 
            1.113083484391111e+03,     1.113463078222628e+03,     1.113841786113254e+03,     1.114219612771642e+03,     1.114596562867561e+03, 
            1.114972641032336e+03,     1.115347851859273e+03,     1.115722199904089e+03,     1.116095689685328e+03,     1.116468325684768e+03, 
            1.116840112347835e+03,     1.117211054084002e+03,     1.117581155267180e+03,     1.117950420236110e+03,     1.118318853294751e+03, 
            1.118686458712654e+03,     1.119053240725337e+03,     1.119419203534653e+03,     1.119784351309156e+03,     1.120148688184458e+03, 
            1.120512218263581e+03,     1.120874945617309e+03,     1.121236874284529e+03,     1.121598008272575e+03,     1.121958351557556e+03, 
            1.122317908084692e+03,     1.122676681768640e+03,     1.123034676493811e+03,     1.123391896114691e+03,     1.123748344456156e+03, 
            1.124104025313773e+03,     1.124458942454115e+03,     1.124813099615056e+03,     1.125166500506066e+03,     1.125519148808512e+03, 
            1.125871048175937e+03,     1.126222202234354e+03,     1.126572614582523e+03,     1.126922288792232e+03,     1.127271228408568e+03, 
            1.127619436950190e+03,     1.127966917909599e+03,     1.128313674753397e+03,     1.128659710922549e+03,     1.129005029832646e+03, 
            1.129349634874150e+03,     1.129693529412652e+03,     1.130036716789116e+03,     1.130379200320125e+03,     1.130720983298123e+03, 
            1.131062068991653e+03,     1.131402460645590e+03,     1.131742161481377e+03,     1.132081174697255e+03,     1.132419503468487e+03, 
            1.132757150947582e+03,     1.133094120264520e+03,     1.133430414526966e+03,     1.133766036820491e+03,     1.134100990208779e+03, 
            1.134435277733842e+03,     1.134768902416226e+03,     1.135101867255220e+03,     1.135434175229055e+03,     1.135765829295103e+03, 
            1.136096832390085e+03,     1.136427187430252e+03,     1.136756897311592e+03,     1.137085964910014e+03,     1.137414393081538e+03, 
            1.137742184662481e+03,     1.138069342469645e+03,     1.138395869300494e+03,     1.138721767933336e+03,     1.139047041127506e+03, 
            1.139371691623533e+03,     1.139695722143319e+03,     1.140019135390312e+03,     1.140341934049671e+03,     1.140664120788438e+03, 
            1.140985698255701e+03,     1.141306669082762e+03,     1.141627035883291e+03,     1.141946801253497e+03,     1.142265967772278e+03, 
            1.142584538001379e+03,     1.142902514485550e+03,     1.143219899752695e+03,     1.143536696314027e+03,     1.143852906664215e+03, 
            1.144168533281530e+03,     1.144483578627995e+03,     1.144798045149530e+03,     1.145111935276089e+03,     1.145425251421807e+03, 
            1.145737995985138e+03,     1.146050171348993e+03,     1.146361779880875e+03,     1.146672823933014e+03,     1.146983305842507e+03, 
            1.147293227931441e+03,     1.147602592507030e+03,     1.147911401861739e+03,     1.148219658273418e+03,     1.148527364005423e+03, 
            1.148834521306745e+03,     1.149141132412129e+03,     1.149447199542201e+03,     1.149752724903587e+03,     1.150057710689031e+03, 
            1.150362159077516e+03,     1.150666072234383e+03,     1.150969452311438e+03,     1.151272301447076e+03,     1.151574621766393e+03, 
            1.151876415381290e+03,     1.152177684390595e+03,     1.152478430880167e+03,     1.152778656923003e+03,     1.153078364579350e+03, 
            1.153377555896807e+03,     1.153676232910437e+03,     1.153974397642859e+03,     1.154272052104365e+03,     1.154569198293013e+03, 
            1.154865838194730e+03,     1.155161973783412e+03,     1.155457607021022e+03,     1.155752739857692e+03,     1.156047374231812e+03, 
            1.156341512070134e+03,     1.156635155287859e+03,     1.156928305788737e+03,     1.157220965465157e+03,     1.157513136198240e+03, 
            1.157804819857928e+03,     1.158096018303075e+03,     1.158386733381538e+03,     1.158676966930262e+03,     1.158966720775369e+03, 
            1.159255996732245e+03,     1.159544796605625e+03,     1.159833122189676e+03,     1.160120975268082e+03,     1.160408357614129e+03, 
            1.160695270990786e+03,     1.160981717150781e+03,     1.161267697836693e+03,     1.161553214781020e+03,     1.161838269706264e+03, 
            1.162122864325009e+03,     1.162407000339998e+03,     1.162690679444207e+03,     1.162973903320924e+03,     1.163256673643824e+03, 
            1.163538992077041e+03,     1.163820860275244e+03,     1.164102279883708e+03,     1.164383252538390e+03,     1.164663779865995e+03, 
            1.164943863484050e+03,     1.165223505000976e+03,     1.165502706016153e+03,     1.165781468119991e+03,     1.166059792894000e+03, 
            1.166337681910856e+03,     1.166615136734465e+03,     1.166892158920034e+03,     1.167168750014135e+03,     1.167444911554766e+03, 
            1.167720645071422e+03,     1.167995952085154e+03,     1.168270834108634e+03,     1.168545292646216e+03,     1.168819329194000e+03, 
            1.169092945239893e+03,     1.169366142263668e+03,     1.169638921737024e+03,     1.169911285123651e+03,     1.170183233879281e+03
    },
    {
            1.893740235269493e+00,     5.756053042950330e+00,     9.718487177240261e+00,     1.378814612244258e+01,     1.797299381016640e+01, 
            2.228200578215262e+01,     2.672535622855295e+01,     3.131465190435200e+01,     3.606322815184203e+01,     4.098652848111020e+01, 
            4.610259851942983e+01,     5.143273955752447e+01,     5.700238973967160e+01,     6.284233819341920e+01,     6.899044039242560e+01, 
            7.549411407693486e+01,     8.241410049896982e+01,     8.983037878342390e+01,     9.785197045827029e+01,     1.066343316297210e+02, 
            1.164131279867130e+02,     8.753985017757772e+02,     8.781643617293558e+02,     8.808304970337282e+02,     8.834058139221996e+02, 
            8.858979705484513e+02,     8.883136094528758e+02,     8.906585370390900e+02,     8.929378641436915e+02,     8.951561175537794e+02, 
            8.973173295013720e+02,     8.994251102353754e+02,     9.014827074299927e+02,     9.034930552387366e+02,     9.054588151203371e+02, 
            9.073824100648498e+02,     9.092660534802504e+02,     9.111117737247218e+02,     9.129214350617334e+02,     9.146967556561555e+02, 
            9.164393231071139e+02,     9.181506079179544e+02,     9.198319752289425e+02,     9.214846950792135e+02,     9.231099514174407e+02, 
            9.247088500429911e+02,     9.262824256288759e+02,     9.278316479531635e+02,     9.293574274453139e+02,     9.308606201373982e+02, 
            9.323420320964904e+02,     9.338024234032382e+02,     9.352425117321715e+02,     9.366629755814780e+02,     9.380644571932970e+02, 
            9.394475652000792e+02,     9.408128770277682e+02,     9.421609410826044e+02,     9.434922787448970e+02,     9.448073861901997e+02, 
            9.461067360558181e+02,     9.473907789684058e+02,     9.486599449465483e+02,     9.499146446906209e+02,     9.511552707707949e+02, 
            9.523821987228537e+02,     9.535957880604236e+02,     9.547963832112576e+02,     9.559843143844523e+02,     9.571598983746979e+02, 
            9.583234393090663e+02,     9.594752293412855e+02,     9.606155492979193e+02,     9.617446692804873e+02,     9.628628492271162e+02, 
            9.639703394370139e+02,     9.650673810607153e+02,     9.661542064355224e+02,     9.672310401076617e+02,     9.682980981215052e+02, 
            9.693555893917743e+02,     9.704037156805317e+02,     9.714426719348191e+02,     9.724726466243234e+02,     9.734938220368410e+02, 
            9.745063745566747e+02,     9.755104749271561e+02,     9.765062884983827e+02,     9.774939754611656e+02,     9.784736910681393e+02, 
            9.794455858428393e+02,     9.804098057775907e+02,     9.813664925208785e+02,     9.823157835549109e+02,     9.832578123639812e+02, 
            9.841927085941983e+02,     9.851205982051290e+02,     9.860416036138458e+02,     9.869558438318321e+02,     9.878634345951762e+02, 
            9.887644884884597e+02,     9.896591150626900e+02,     9.905474209476416e+02,     9.914295099589184e+02,     9.923054831504140e+02, 
            9.931754391151602e+02,     9.940394737650556e+02,     9.948976806341794e+02,     9.957501509084120e+02,     9.965969735077894e+02, 
            9.974382351645035e+02,     9.982740204955848e+02,     9.991044120737030e+02,     9.999294904950539e+02,     1.000749334444374e+03, 
            1.001564020757244e+03,     1.002373624479808e+03,     1.003178218398890e+03,     1.003977875007304e+03,     1.004772663942172e+03, 
            1.005562653652257e+03,     1.006347911012375e+03,     1.007128501468990e+03,     1.007904489017543e+03,     1.008675936262963e+03, 
            1.009442904461200e+03,     1.010205453559165e+03,     1.010963642233173e+03,     1.011717527925956e+03,     1.012467166882291e+03, 
            1.013212614183337e+03,     1.013953923779709e+03,     1.014691148523360e+03,     1.015424340198322e+03,     1.016153549550353e+03, 
            1.016878826315533e+03,     1.017600219247863e+03,     1.018317776145906e+03,     1.019031543878503e+03,     1.019741568409614e+03, 
            1.020447894822313e+03,     1.021150567341973e+03,     1.021849629358680e+03,     1.022545123448891e+03,     1.023237091396393e+03, 
            1.023925574212561e+03,     1.024610612155964e+03,     1.025292244751341e+03,     1.025970510807964e+03,     1.026645448437416e+03, 
            1.027317095070809e+03,     1.027985487475465e+03,     1.028650661771069e+03,     1.029312653445327e+03,     1.029971497369144e+03, 
            1.030627227811333e+03,     1.031279878452883e+03,     1.031929482400792e+03,     1.032576072201495e+03,     1.033219679853873e+03, 
            1.033860336821908e+03,     1.034498074046933e+03,     1.035132921959550e+03,     1.035764910491193e+03,     1.036394069085353e+03, 
            1.037020426708493e+03,     1.037644011860752e+03,     1.038264852554337e+03,     1.038882976452038e+03,     1.039498410681671e+03, 
            1.040111181977691e+03,     1.040721316656821e+03,     1.041328840627001e+03,     1.041933779396082e+03,     1.042536158080309e+03, 
            1.043136001412543e+03,     1.043733333750299e+03,     1.044328179083536e+03,     1.044920561042265e+03,     1.045510502903949e+03, 
            1.046098027600705e+03,     1.046683157726326e+03,     1.047265915543117e+03,     1.047846322988556e+03,     1.048424401681789e+03, 
            1.049000172929951e+03,     1.049573657734338e+03,     1.050144876796413e+03,     1.050713850523670e+03,     1.051280599035352e+03, 
            1.051845142168021e+03,     1.052407499480995e+03,     1.052967690261658e+03,     1.053525733530627e+03,     1.054081648046807e+03, 
            1.054635452312319e+03,     1.055187164577307e+03,     1.055736802844638e+03,     1.056284384874483e+03,     1.056829928188797e+03, 
            1.057373450075684e+03,     1.057914967593676e+03,     1.058454497575892e+03,     1.058992056634122e+03,     1.059527661162801e+03, 
            1.060061327342903e+03,     1.060593071145736e+03,     1.061122908336664e+03,     1.061650854478731e+03,     1.062176924936218e+03, 
            1.062701134878107e+03,     1.063223499281480e+03,     1.063744032934832e+03,     1.064262750441324e+03,     1.064779666221952e+03, 
            1.065294794518653e+03,     1.065808149397346e+03,     1.066319744750904e+03,     1.066829594302061e+03,     1.067337711606262e+03, 
            1.067844110054448e+03,     1.068348802875779e+03,     1.068851803140312e+03,     1.069353123761610e+03,     1.069852777499301e+03, 
            1.070350776961586e+03,     1.070847134607693e+03,     1.071341862750280e+03,     1.071834973557790e+03,     1.072326479056757e+03, 
            1.072816391134066e+03,     1.073304721539168e+03,     1.073791481886248e+03,     1.074276683656349e+03,     1.074760338199460e+03, 
            1.075242456736555e+03,     1.075723050361593e+03,     1.076202129508084e+03,     1.076679706078961e+03,     1.077155790276842e+03, 
            1.077630392706880e+03,     1.078103523856645e+03,     1.078575194097911e+03,     1.079045413688395e+03,     1.079514192773472e+03, 
            1.079981541387846e+03,     1.080447469457208e+03,     1.080911986799843e+03,     1.081375103128214e+03,     1.081836828050527e+03, 
            1.082297171072247e+03,     1.082756141597599e+03,     1.083213748931044e+03,     1.083670002278715e+03,     1.084124910749836e+03, 
            1.084578483358114e+03,     1.085030729023103e+03,     1.085481656571546e+03,     1.085931274738690e+03,     1.086379592169579e+03, 
            1.086826617420326e+03,     1.087272358959355e+03,     1.087716825168630e+03,     1.088160024344856e+03,     1.088601964700663e+03, 
            1.089042654365763e+03,     1.089482101388095e+03,     1.089920313734940e+03,     1.090357299294031e+03,     1.090793065874625e+03, 
            1.091227621208575e+03,     1.091660972951369e+03,     1.092093128683163e+03,     1.092524095909786e+03,     1.092953882063732e+03, 
            1.093382494505143e+03,     1.093809940522760e+03,     1.094236227334869e+03,     1.094661362090233e+03,     1.095085351868994e+03, 
            1.095508203683582e+03,     1.095929924479585e+03,     1.096350521136624e+03,     1.096770000469204e+03,     1.097188369227553e+03, 
            1.097605634129910e+03,     1.098021801736369e+03,     1.098436878641844e+03,     1.098850871347571e+03,     1.099263786294505e+03, 
            1.099675629864080e+03,     1.100086408378957e+03,     1.100496128103759e+03,     1.100904795245800e+03,     1.101312415955793e+03, 
            1.101718996328559e+03,     1.102124542403711e+03,     1.102529060166339e+03,     1.102932555547679e+03,     1.103335034425770e+03, 
            1.103736502626108e+03,     1.104136965922275e+03,     1.104536430036583e+03,     1.104934900640679e+03,     1.105332383356164e+03, 
            1.105728883755189e+03,     1.106124407361053e+03,     1.106518959648774e+03,     1.106912546045678e+03,     1.107305171931947e+03, 
            1.107696842641192e+03,     1.108087563460992e+03,     1.108477339633434e+03,     1.108866176355648e+03,     1.109254078780333e+03, 
            1.109641052016268e+03,     1.110027101128825e+03,     1.110412231140467e+03,     1.110796447031250e+03,     1.111179753739298e+03, 
            1.111562156161293e+03,     1.111943659152940e+03,     1.112324267529442e+03,     1.112703986065949e+03,     1.113082819498018e+03, 
            1.113460772522058e+03,     1.113837849795768e+03,     1.114214055938570e+03,     1.114589395532038e+03,     1.114963873120323e+03, 
            1.115337493210560e+03,     1.115710260273284e+03,     1.116082178742833e+03,     1.116453253017745e+03,     1.116823487461150e+03, 
            1.117192886401160e+03,     1.117561454131247e+03,     1.117929194910623e+03,     1.118296112964611e+03,     1.118662212485009e+03, 
            1.119027497630453e+03,     1.119391972526773e+03,     1.119755641267346e+03,     1.120118507913439e+03,     1.120480576494556e+03, 
            1.120841851008771e+03,     1.121202335423063e+03,     1.121562033673645e+03,     1.121920949666289e+03,     1.122279087276639e+03, 
            1.122636450350535e+03,     1.122993042704321e+03,     1.123348868125152e+03,     1.123703930371295e+03,     1.124058233172432e+03, 
            1.124411780229954e+03,     1.124764575217251e+03,     1.125116621780000e+03,     1.125467923536451e+03,     1.125818484077704e+03, 
            1.126168306967987e+03,     1.126517395744930e+03,     1.126865753919833e+03,     1.127213384977932e+03,     1.127560292378663e+03, 
            1.127906479555920e+03,     1.128251949918310e+03,     1.128596706849410e+03,     1.128940753708011e+03,     1.129284093828367e+03, 
            1.129626730520440e+03,     1.129968667070138e+03,     1.130309906739551e+03,     1.130650452767188e+03,     1.130990308368209e+03, 
            1.131329476734648e+03,     1.131667961035646e+03,     1.132005764417670e+03,     1.132342890004731e+03,     1.132679340898605e+03, 
            1.133015120179048e+03,     1.133350230904005e+03,     1.133684676109822e+03,     1.134018458811453e+03,     1.134351582002661e+03, 
            1.134684048656226e+03,     1.135015861724140e+03,     1.135347024137807e+03,     1.135677538808233e+03,     1.136007408626226e+03, 
            1.136336636462579e+03,     1.136665225168263e+03,     1.136993177574609e+03,     1.137320496493493e+03,     1.137647184717522e+03, 
            1.137973245020202e+03,     1.138298680156126e+03,     1.138623492861145e+03,     1.138947685852538e+03,     1.139271261829188e+03, 
            1.139594223471749e+03,     1.139916573442810e+03,     1.140238314387066e+03,     1.140559448931476e+03,     1.140879979685425e+03, 
            1.141199909240888e+03,     1.141519240172581e+03,     1.141837975038120e+03,     1.142156116378179e+03,     1.142473666716633e+03, 
            1.142790628560716e+03,     1.143107004401168e+03,     1.143422796712380e+03,     1.143738007952545e+03,     1.144052640563793e+03, 
            1.144366696972340e+03,     1.144680179588630e+03,     1.144993090807467e+03,     1.145305433008156e+03,     1.145617208554644e+03, 
            1.145928419795646e+03,     1.146239069064783e+03,     1.146549158680712e+03,     1.146858690947258e+03,     1.147167668153539e+03, 
            1.147476092574098e+03,     1.147783966469023e+03,     1.148091292084078e+03,     1.148398071650821e+03,     1.148704307386727e+03, 
            1.149010001495311e+03,     1.149315156166244e+03,     1.149619773575472e+03,     1.149923855885334e+03,     1.150227405244673e+03, 
            1.150530423788958e+03,     1.150832913640388e+03,     1.151134876908009e+03,     1.151436315687824e+03,     1.151737232062902e+03, 
            1.152037628103482e+03,     1.152337505867091e+03,     1.152636867398634e+03,     1.152935714730515e+03,     1.153234049882730e+03, 
            1.153531874862973e+03,     1.153829191666736e+03,     1.154126002277414e+03,     1.154422308666400e+03,     1.154718112793183e+03, 
            1.155013416605448e+03,     1.155308222039173e+03,     1.155602531018721e+03,     1.155896345456937e+03,     1.156189667255239e+03, 
            1.156482498303717e+03,     1.156774840481212e+03,     1.157066695655420e+03,     1.157358065682975e+03,     1.157648952409537e+03, 
            1.157939357669883e+03,     1.158229283287990e+03,     1.158518731077128e+03,     1.158807702839937e+03,     1.159096200368515e+03, 
            1.159384225444505e+03,     1.159671779839171e+03,     1.159958865313487e+03,     1.160245483618208e+03,     1.160531636493964e+03, 
            1.160817325671326e+03,     1.161102552870895e+03,     1.161387319803372e+03,     1.161671628169641e+03,     1.161955479660842e+03, 
            1.162238875958446e+03,     1.162521818734336e+03,     1.162804309650872e+03,     1.163086350360971e+03,     1.163367942508178e+03, 
            1.163649087726736e+03,     1.163929787641660e+03,     1.164210043868807e+03,     1.164489858014946e+03,     1.164769231677823e+03, 
            1.165048166446237e+03,     1.165326663900105e+03,     1.165604725610525e+03,     1.165882353139848e+03,     1.166159548041741e+03, 
            1.166436311861256e+03,     1.166712646134888e+03,     1.166988552390648e+03,     1.167264032148119e+03,     1.167539086918522e+03, 
            1.167813718204778e+03,     1.168087927501571e+03,     1.168361716295406e+03,     1.168635086064673e+03,     1.168908038279707e+03
    },
    {
            1.889606968910745e+00,     5.742970864030119e+00,     9.695458900801068e+00,     1.375403851512913e+01,     1.792651231354538e+01, 
            2.222166312696826e+01,     2.664943306686056e+01,     3.122114687451259e+01,     3.594979375026245e+01,     4.085038756088973e+01, 
            4.594043386505961e+01,     5.124054527469224e+01,     5.677526722685811e+01,     6.257420953192644e+01,     6.867363485410058e+01, 
            7.511875255794746e+01,     8.196714406042524e+01,     8.929408906392021e+01,     9.720127146504517e+01,     1.058319410428940e+02, 
            1.153996234274778e+02,     1.262492312252382e+02,     8.730589453930280e+02,     8.758494589318433e+02,     8.785392831097134e+02, 
            8.811373545909244e+02,     8.836513698111712e+02,     8.860880134332911e+02,     8.884531353159553e+02,     8.907518895277360e+02, 
            8.929888449186709e+02,     8.951680740619304e+02,     8.972932255273172e+02,     8.993675831553697e+02,     9.013941150821612e+02, 
            9.033755146021779e+02,     9.053142344717874e+02,     9.072125158965370e+02,     9.090724131761655e+02,     9.108958147770642e+02, 
            9.126844614456318e+02,     9.144399618551906e+02,     9.161638061850271e+02,     9.178573779561452e+02,     9.195219643897437e+02, 
            9.211587655077669e+02,     9.227689021573638e+02,     9.243534231108238e+02,     9.259133113679565e+02,     9.274494897677430e+02, 
            9.289628259996242e+02,     9.304541370910848e+02,     9.319241934369194e+02,     9.333737224261195e+02,     9.348034117144242e+02, 
            9.362139121839347e+02,     9.376058406256119e+02,     9.389797821756998e+02,     9.403362925331235e+02,     9.416758999814343e+02, 
            9.429991072359476e+02,     9.443063931341937e+02,     9.455982141856141e+02,     9.468750059945542e+02,     9.481371845689913e+02, 
            9.493851475259943e+02,     9.506192752037043e+02,     9.518399316885382e+02,     9.530474657653712e+02,     9.542422117976358e+02, 
            9.554244905435529e+02,     9.565946099140585e+02,     9.577528656774266e+02,     9.588995421151103e+02,     9.600349126328380e+02, 
            9.611592403306583e+02,     9.622727785352382e+02,     9.633757712974186e+02,     9.644684537812789e+02,     9.655510530744893e+02, 
            9.666237878725859e+02,     9.676868695466005e+02,     9.687405022015033e+02,     9.697848830508648e+02,     9.708202027433798e+02, 
            9.718466456626677e+02,     9.728643902097671e+02,     9.738736090694937e+02,     9.748744694617994e+02,     9.758671333791287e+02, 
            9.768517578107344e+02,     9.778284949547925e+02,     9.787974924191357e+02,     9.797588934113311e+02,     9.807128369187878e+02, 
            9.816594578795259e+02,     9.825988873441869e+02,     9.835312526298301e+02,     9.844566774660194e+02,     9.853752821336602e+02, 
            9.862871835970308e+02,     9.871924956294007e+02,     9.880913289326112e+02,     9.889837912509879e+02,     9.898699874798781e+02, 
            9.907500197691448e+02,     9.916239875719426e+02,     9.924919879437406e+02,     9.933541153170390e+02,     9.942104618036917e+02, 
            9.950611172232512e+02,     9.959061691802160e+02,     9.967457031385566e+02,     9.975798024935557e+02,     9.984085486406129e+02, 
            9.992320210411183e+02,     1.000050297285593e+03,     1.000863452700522e+03,     1.001671562040543e+03,     1.002474697319325e+03, 
            1.003272929219369e+03,     1.004066326847810e+03,     1.004854957717397e+03,     1.005638887898756e+03,     1.006418181994145e+03, 
            1.007192903199592e+03,     1.007963113346951e+03,     1.008728872944359e+03,     1.009490241215160e+03,     1.010247276135390e+03, 
            1.011000034469858e+03,     1.011748571806903e+03,     1.012492942591895e+03,     1.013233200159506e+03,     1.013969396764835e+03, 
            1.014701583613425e+03,     1.015429810890208e+03,     1.016154127787444e+03,     1.016874582531688e+03,     1.017591222409826e+03, 
            1.018304093794207e+03,     1.019013242166938e+03,     1.019718712143348e+03,     1.020420547494665e+03,     1.021118791169943e+03, 
            1.021813485317264e+03,     1.022504671304241e+03,     1.023192389737858e+03,     1.023876680483667e+03,     1.024557582684370e+03, 
            1.025235134777806e+03,     1.025909374514369e+03,     1.026580338973882e+03,     1.027248064581944e+03,     1.027912587125767e+03, 
            1.028573941769526e+03,     1.029232163069239e+03,     1.029887284987203e+03,     1.030539340905980e+03,     1.031188363641980e+03, 
            1.031834385458622e+03,     1.032477438079121e+03,     1.033117552698893e+03,     1.033754759997592e+03,     1.034389090150811e+03, 
            1.035020572841433e+03,     1.035649237270661e+03,     1.036275112136739e+03,     1.036898225775375e+03,     1.037518605971687e+03, 
            1.038136280104357e+03,     1.038751275121047e+03,     1.039363617547685e+03,     1.039973333497522e+03,     1.040580448679926e+03, 
            1.041184988408940e+03,     1.041786977611616e+03,     1.042386440836111e+03,     1.042983402259595e+03,     1.043577885695910e+03, 
            1.044169914603066e+03,     1.044759512090515e+03,     1.045346700926249e+03,     1.045931503543705e+03,     1.046513942048504e+03, 
            1.047094038225003e+03,     1.047671813542694e+03,     1.048247289162432e+03,     1.048820485942512e+03,     1.049391424444584e+03, 
            1.049960124939439e+03,     1.050526607412635e+03,     1.051090891569982e+03,     1.051652996842922e+03,     1.052212942393736e+03, 
            1.052770747120655e+03,     1.053326429662840e+03,     1.053880008405237e+03,     1.054431501483324e+03,     1.054980926787739e+03, 
            1.055528301968804e+03,     1.056073644440939e+03,     1.056616971386975e+03,     1.057158299762365e+03,     1.057697646299301e+03, 
            1.058235027510731e+03,     1.058770459694292e+03,     1.059303958936141e+03,     1.059835541114715e+03,     1.060365221904393e+03, 
            1.060893016779081e+03,     1.061418941015718e+03,     1.061943009697704e+03,     1.062465237718247e+03,     1.062985639783648e+03, 
            1.063504230416495e+03,     1.064021023958811e+03,     1.064536034575112e+03,     1.065049276255416e+03,     1.065560762818175e+03, 
            1.066070507913152e+03,     1.066578525024230e+03,     1.067084827472172e+03,     1.067589428417310e+03,     1.068092340862187e+03, 
            1.068593577654141e+03,     1.069093151487834e+03,     1.069591074907727e+03,     1.070087360310512e+03,     1.070582019947484e+03, 
            1.071075065926873e+03,     1.071566510216116e+03,     1.072056364644106e+03,     1.072544640903368e+03,     1.073031350552213e+03, 
            1.073516505016835e+03,     1.074000115593379e+03,     1.074482192907289e+03,     1.074962749072015e+03,     1.075441794476594e+03, 
            1.075919339916760e+03,     1.076395396067910e+03,     1.076869973486927e+03,     1.077343082613975e+03,     1.077814733774264e+03, 
            1.078284937179770e+03,     1.078753702930934e+03,     1.079221041018324e+03,     1.079686961324257e+03,     1.080151473624410e+03, 
            1.080614587589378e+03,     1.081076312786223e+03,     1.081536658679979e+03,     1.081995634635141e+03,     1.082453249917115e+03, 
            1.082909513693653e+03,     1.083364435036252e+03,     1.083818022921533e+03,     1.084270286232594e+03,     1.084721233760336e+03, 
            1.085170874204771e+03,     1.085619216176297e+03,     1.086066268196961e+03,     1.086512038701693e+03,     1.086956536039516e+03, 
            1.087399768474744e+03,     1.087841744188148e+03,     1.088282471278108e+03,     1.088721957761745e+03,     1.089160211576029e+03, 
            1.089597240578874e+03,     1.090033052550207e+03,     1.090467655193022e+03,     1.090901056134422e+03,     1.091333262926630e+03, 
            1.091764283047993e+03,     1.092194123903967e+03,     1.092622792828085e+03,     1.093050297082905e+03,     1.093476643860947e+03, 
            1.093901840285613e+03,     1.094325893412091e+03,     1.094748810260403e+03,     1.095170597686497e+03,     1.095591262579545e+03, 
            1.096010811730623e+03,     1.096429251866896e+03,     1.096846589652437e+03,     1.097262831689029e+03,     1.097677984516960e+03, 
            1.098092054615802e+03,     1.098505048405180e+03,     1.098916972245522e+03,     1.099327832438806e+03,     1.099737635229288e+03, 
            1.100146386804223e+03,     1.100554093294574e+03,     1.100960760775707e+03,     1.101366395268073e+03,     1.101771002737894e+03, 
            1.102174589097815e+03,     1.102577160207567e+03,     1.102978721874608e+03,     1.103379279854758e+03,     1.103778839852822e+03, 
            1.104177407523205e+03,     1.104574988470522e+03,     1.104971588250187e+03,     1.105367212369005e+03,     1.105761866285749e+03, 
            1.106155555411733e+03,     1.106548285111366e+03,     1.106940060702710e+03,     1.107330887458023e+03,     1.107720770604298e+03, 
            1.108109715323785e+03,     1.108497726754519e+03,     1.108884809990826e+03,     1.109270970083833e+03,     1.109656212041966e+03, 
            1.110040540831437e+03,     1.110423961376731e+03,     1.110806478561082e+03,     1.111188097226940e+03,     1.111568822176439e+03, 
            1.111948658171847e+03,     1.112327609936018e+03,     1.112705682152841e+03,     1.113082879467667e+03,     1.113459206487746e+03, 
            1.113834667782652e+03,     1.114209267884698e+03,     1.114583011289351e+03,     1.114955902455638e+03,     1.115327945806551e+03, 
            1.115699145729435e+03,     1.116069506576386e+03,     1.116439032664631e+03,     1.116807728276912e+03,     1.117175597661852e+03, 
            1.117542645034333e+03,     1.117908874575855e+03,     1.118274290434899e+03,     1.118638896727274e+03,     1.119002697536473e+03, 
            1.119365696914017e+03,     1.119727898879791e+03,     1.120089307422385e+03,     1.120449926499419e+03,     1.120809760037873e+03, 
            1.121168811934410e+03,     1.121527086055689e+03,     1.121884586238686e+03,     1.122241316290995e+03,     1.122597279991142e+03, 
            1.122952481088878e+03,     1.123306923305485e+03,     1.123660610334061e+03,     1.124013545839815e+03,     1.124365733460352e+03, 
            1.124717176805956e+03,     1.125067879459866e+03,     1.125417844978551e+03,     1.125767076891988e+03,     1.126115578703918e+03, 
            1.126463353892122e+03,     1.126810405908675e+03,     1.127156738180209e+03,     1.127502354108164e+03,     1.127847257069038e+03, 
            1.128191450414639e+03,     1.128534937472329e+03,     1.128877721545264e+03,     1.129219805912637e+03,     1.129561193829906e+03, 
            1.129901888529038e+03,     1.130241893218730e+03,     1.130581211084642e+03,     1.130919845289616e+03,     1.131257798973903e+03, 
            1.131595075255379e+03,     1.131931677229763e+03,     1.132267607970830e+03,     1.132602870530619e+03,     1.132937467939647e+03, 
            1.133271403207110e+03,     1.133604679321091e+03,     1.133937299248757e+03,     1.134269265936560e+03,     1.134600582310431e+03, 
            1.134931251275977e+03,     1.135261275718669e+03,     1.135590658504034e+03,     1.135919402477841e+03,     1.136247510466286e+03, 
            1.136574985276174e+03,     1.136901829695098e+03,     1.137228046491622e+03,     1.137553638415453e+03,     1.137878608197617e+03, 
            1.138202958550628e+03,     1.138526692168666e+03,     1.138849811727735e+03,     1.139172319885835e+03,     1.139494219283128e+03, 
            1.139815512542095e+03,     1.140136202267701e+03,     1.140456291047550e+03,     1.140775781452045e+03,     1.141094676034543e+03, 
            1.141412977331504e+03,     1.141730687862649e+03,     1.142047810131105e+03,     1.142364346623554e+03,     1.142680299810380e+03, 
            1.142995672145817e+03,     1.143310466068085e+03,     1.143624683999539e+03,     1.143938328346803e+03,     1.144251401500914e+03, 
            1.144563905837454e+03,     1.144875843716689e+03,     1.145187217483698e+03,     1.145498029468514e+03,     1.145808281986245e+03, 
            1.146117977337211e+03,     1.146427117807069e+03,     1.146735705666940e+03,     1.147043743173532e+03,     1.147351232569270e+03, 
            1.147658176082410e+03,     1.147964575927172e+03,     1.148270434303846e+03,     1.148575753398922e+03,     1.148880535385202e+03, 
            1.149184782421916e+03,     1.149488496654841e+03,     1.149791680216409e+03,     1.150094335225822e+03,     1.150396463789166e+03, 
            1.150698067999517e+03,     1.150999149937049e+03,     1.151299711669149e+03,     1.151599755250515e+03,     1.151899282723266e+03, 
            1.152198296117045e+03,     1.152496797449125e+03,     1.152794788724506e+03,     1.153092271936022e+03,     1.153389249064437e+03, 
            1.153685722078542e+03,     1.153981692935263e+03,     1.154277163579745e+03,     1.154572135945458e+03,     1.154866611954287e+03, 
            1.155160593516626e+03,     1.155454082531476e+03,     1.155747080886529e+03,     1.156039590458266e+03,     1.156331613112045e+03, 
            1.156623150702191e+03,     1.156914205072080e+03,     1.157204778054235e+03,     1.157494871470403e+03,     1.157784487131650e+03, 
            1.158073626838439e+03,     1.158362292380716e+03,     1.158650485537996e+03,     1.158938208079441e+03,     1.159225461763944e+03, 
            1.159512248340212e+03,     1.159798569546840e+03,     1.160084427112395e+03,     1.160369822755494e+03,     1.160654758184877e+03, 
            1.160939235099493e+03,     1.161223255188565e+03,     1.161506820131673e+03,     1.161789931598827e+03,     1.162072591250539e+03, 
            1.162354800737898e+03,     1.162636561702642e+03,     1.162917875777231e+03,     1.163198744584912e+03,     1.163479169739798e+03, 
            1.163759152846933e+03,     1.164038695502360e+03,     1.164317799293194e+03,     1.164596465797684e+03,     1.164874696585282e+03, 
            1.165152493216713e+03,     1.165429857244035e+03,     1.165706790210711e+03,     1.165983293651665e+03,     1.166259369093352e+03, 
            1.166535018053821e+03,     1.166810242042775e+03,     1.167085042561636e+03,     1.167359421103604e+03,     1.167633379153718e+03
    },
    {
            1.885492097666111e+00,     5.729951863295408e+00,     9.672551194570110e+00,     1.372012443225156e+01,     1.788031662356499e+01, 
            2.216172273086421e+01,     2.657405907287372e+01,     3.112837662555075e+01,     3.583732940328294e+01,     4.071551638417257e+01, 
            4.577992324264148e+01,     5.105050202305191e+01,     5.655094542078641e+01,     6.230974211946825e+01,     6.836164910005604e+01, 
            7.474980219603665e+01,     8.152884018856066e+01,     8.876971082002700e+01,     9.656742181379748e+01,     1.050543079248187e+02, 
            1.144245727319389e+02,     1.249847953762367e+02,     8.678057116056416e+02,     8.707327625611024e+02,     8.735476607110700e+02, 
            8.762609043894295e+02,     8.788814643486278e+02,     8.814170776369302e+02,     8.838744724856596e+02,     8.862595430591825e+02, 
            8.885774871055789e+02,     8.908329157120352e+02,     8.930299417823819e+02,     8.951722520732559e+02,     8.972631663763560e+02, 
            8.993056865436955e+02,     9.013025374081968e+02,     9.032562011790677e+02,     9.051689465399239e+02,     9.070428534135539e+02, 
            9.088798341565478e+02,     9.106816517930723e+02,     9.124499357779180e+02,     9.141861956858340e+02,     9.158918331509917e+02, 
            9.175681523222178e+02,     9.192163690533769e+02,     9.208376190108729e+02,     9.224329648501803e+02,     9.240034025886979e+02, 
            9.255498672822035e+02,     9.270732380956334e+02,     9.285743428452899e+02,     9.300539620782401e+02,     9.315128327452198e+02, 
            9.329516515154190e+02,     9.343710777749017e+02,     9.357717363447458e+02,     9.371542199502484e+02,     9.385190914684639e+02, 
            9.398668859779146e+02,     9.411981126312955e+02,     9.425132563695051e+02,     9.438127794930950e+02,     9.450971231053491e+02, 
            9.463667084395876e+02,     9.476219380817929e+02,     9.488631970984979e+02,     9.500908540787175e+02,     9.513052620977921e+02, 
            9.525067596101720e+02,     9.536956712774224e+02,     9.548723087370965e+02,     9.560369713175509e+02,     9.571899467032659e+02, 
            9.583315115547887e+02,     9.594619320870161e+02,     9.605814646091837e+02,     9.616903558622587e+02,     9.627888442860548e+02, 
            9.638771589968342e+02,     9.649555214600938e+02,     9.660241454543077e+02,     9.670832374017588e+02,     9.681329967499388e+02, 
            9.691736162953296e+02,     9.702052824874879e+02,     9.712281757155465e+02,     9.722424705783590e+02,     9.732483361394129e+02, 
            9.742459361675382e+02,     9.752354293643809e+02,     9.762169695794908e+02,     9.771907060138716e+02,     9.781567834127056e+02, 
            9.791153422479696e+02,     9.800665188915721e+02,     9.810104457796014e+02,     9.819472515682437e+02,     9.828770612818752e+02, 
            9.837999964538019e+02,     9.847161752600896e+02,     9.856257126468915e+02,     9.865287204516510e+02,     9.874253075185516e+02, 
            9.883155798085108e+02,     9.891996405040729e+02,     9.900775900540967e+02,     9.909495264961735e+02,     9.918155451985099e+02, 
            9.926757391877595e+02,     9.935301991709611e+02,     9.943790136137121e+02,     9.952222688161688e+02,     9.960600489858375e+02, 
            9.968924363072581e+02,     9.977195110087439e+02,     9.985413514263221e+02,     9.993580335143481e+02,     1.000169632901163e+03, 
            1.000976222211106e+03,     1.001777872793885e+03,     1.002574654389320e+03,     1.003366635193223e+03,     1.004153881839902e+03, 
            1.004936459548730e+03,     1.005714432099716e+03,     1.006487861893711e+03,     1.007256809993368e+03,     1.008021336162551e+03, 
            1.008781498904277e+03,     1.009537355497236e+03,     1.010288962030987e+03,     1.011036373439850e+03,     1.011779643535577e+03, 
            1.012518825038856e+03,     1.013253969609679e+03,     1.013985127876646e+03,     1.014712349465233e+03,     1.015435683025083e+03, 
            1.016155176256343e+03,     1.016870875935108e+03,     1.017582827937990e+03,     1.018291077265862e+03,     1.018995668066806e+03, 
            1.019696643658289e+03,     1.020394046548612e+03,     1.021087918457657e+03,     1.021778300336957e+03,     1.022465232389100e+03, 
            1.023148754086542e+03,     1.023828904189789e+03,     1.024505720765020e+03,     1.025179241201152e+03,     1.025849502226366e+03, 
            1.026516539924128e+03,     1.027180389748715e+03,     1.027841086540260e+03,     1.028498664539343e+03,     1.029153157401141e+03, 
            1.029804598209158e+03,     1.030453019488538e+03,     1.031098453218985e+03,     1.031740930847307e+03,     1.032380483299593e+03, 
            1.033017140993028e+03,     1.033650933847380e+03,     1.034281891263580e+03,     1.034910042266883e+03,     1.035535415315675e+03, 
            1.036158038448432e+03,     1.036777939258894e+03,     1.037395144905731e+03,     1.038009682121939e+03,     1.038621577223982e+03, 
            1.039230856120690e+03,     1.039837544321903e+03,     1.040441666946887e+03,     1.041043248732533e+03,     1.041642314041325e+03, 
            1.042238886869096e+03,     1.042832990852597e+03,     1.043424649276848e+03,     1.044013885082304e+03,     1.044600720871842e+03, 
            1.045185178917555e+03,     1.045767281167390e+03,     1.046347049251595e+03,     1.046924504489022e+03,     1.047499667893259e+03, 
            1.048072560178615e+03,     1.048643201765951e+03,     1.049211612788374e+03,     1.049777813096779e+03,     1.050341822265265e+03, 
            1.050903659596418e+03,     1.051463344126462e+03,     1.052020894630283e+03,     1.052576329626343e+03,     1.053129667381470e+03, 
            1.053680925915528e+03,     1.054230123005993e+03,     1.054777276192407e+03,     1.055322402780730e+03,     1.055865519847599e+03, 
            1.056406644244479e+03,     1.056945792601725e+03,     1.057482981332546e+03,     1.058018226636885e+03,     1.058551544505199e+03, 
            1.059082950722172e+03,     1.059612460870325e+03,     1.060140090333559e+03,     1.060665854300616e+03,     1.061189767768458e+03, 
            1.061711845545578e+03,     1.062232102255238e+03,     1.062750552338631e+03,     1.063267210057978e+03,     1.063782089499563e+03, 
            1.064295204576687e+03,     1.064806569032585e+03,     1.065316196443249e+03,     1.065824100220216e+03,     1.066330293613292e+03, 
            1.066834789713204e+03,     1.067337601454218e+03,     1.067838741616688e+03,     1.068338222829557e+03,     1.068836057572804e+03, 
            1.069332258179846e+03,     1.069826836839886e+03,     1.070319805600213e+03,     1.070811176368459e+03,     1.071300960914809e+03, 
            1.071789170874163e+03,     1.072275817212533e+03,     1.072760912358008e+03,     1.073244467030315e+03,     1.073726492344025e+03, 
            1.074206999288623e+03,     1.074685998730426e+03,     1.075163501414472e+03,     1.075639517966357e+03,     1.076114058894055e+03, 
            1.076587134589690e+03,     1.077058755331276e+03,     1.077528931284428e+03,     1.077997672504039e+03,     1.078464988935923e+03, 
            1.078930890418427e+03,     1.079395386684017e+03,     1.079858487360830e+03,     1.080320201974200e+03,     1.080780539948151e+03, 
            1.081239510606869e+03,     1.081697123176143e+03,     1.082153386784781e+03,     1.082608310465994e+03,     1.083061903158768e+03, 
            1.083514173709199e+03,     1.083965130871811e+03,     1.084414783310842e+03,     1.084863139601519e+03,     1.085310208231301e+03, 
            1.085755997601104e+03,     1.086200516026499e+03,     1.086643771738902e+03,     1.087085772886722e+03,     1.087526527536514e+03, 
            1.087966043674088e+03,     1.088404329205617e+03,     1.088841391958713e+03,     1.089277239683497e+03,     1.089711880053636e+03, 
            1.090145320667376e+03,     1.090577569048549e+03,     1.091008632647563e+03,     1.091438518842383e+03,     1.091867234939484e+03, 
            1.092294788206449e+03,     1.092721185745154e+03,     1.093146434686040e+03,     1.093570542058907e+03,     1.093993514826626e+03, 
            1.094415359886010e+03,     1.094836084068665e+03,     1.095255694141830e+03,     1.095674196809201e+03,     1.096091598711743e+03, 
            1.096507906428490e+03,     1.096923126477330e+03,     1.097337265315779e+03,     1.097750329341740e+03,     1.098162324894254e+03, 
            1.098573258254236e+03,     1.098983135645197e+03,     1.099391963233963e+03,     1.099799747131376e+03,     1.100206493392979e+03, 
            1.100612208019708e+03,     1.101016896958549e+03,     1.101420566103208e+03,     1.101823221294756e+03,     1.102224868322269e+03, 
            1.102625512923452e+03,     1.103025160785271e+03,     1.103423817544550e+03,     1.103821488788581e+03,     1.104218180055713e+03, 
            1.104613896835932e+03,     1.105008644571440e+03,     1.105402428657217e+03,     1.105795254441583e+03,     1.106187127226737e+03, 
            1.106578052269307e+03,     1.106968034780878e+03,     1.107357079928519e+03,     1.107745192835296e+03,     1.108132378580785e+03, 
            1.108518642201572e+03,     1.108903988691749e+03,     1.109288423003398e+03,     1.109671950047074e+03,     1.110054574692279e+03, 
            1.110436301767926e+03,     1.110817136062799e+03,     1.111197082326007e+03,     1.111576145267431e+03,     1.111954329558162e+03, 
            1.112331639830940e+03,     1.112708080680575e+03,     1.113083656664372e+03,     1.113458372302551e+03,     1.113832232078650e+03, 
            1.114205240439931e+03,     1.114577401797785e+03,     1.114948720528117e+03,     1.115319200971736e+03,     1.115688847434741e+03, 
            1.116057664188891e+03,     1.116425655471986e+03,     1.116792825488225e+03,     1.117159178408573e+03,     1.117524718371115e+03, 
            1.117889449481412e+03,     1.118253375812842e+03,     1.118616501406947e+03,     1.118978830273771e+03,     1.119340366392190e+03, 
            1.119701113710245e+03,     1.120061076145464e+03,     1.120420257585180e+03,     1.120778661886854e+03,     1.121136292878377e+03, 
            1.121493154358388e+03,     1.121849250096568e+03,     1.122204583833948e+03,     1.122559159283197e+03,     1.122912980128919e+03, 
            1.123266050027940e+03,     1.123618372609592e+03,     1.123969951475990e+03,     1.124320790202316e+03,     1.124670892337087e+03, 
            1.125020261402428e+03,     1.125368900894333e+03,     1.125716814282936e+03,     1.126064005012764e+03,     1.126410476502998e+03, 
            1.126756232147722e+03,     1.127101275316177e+03,     1.127445609353005e+03,     1.127789237578493e+03,     1.128132163288815e+03, 
            1.128474389756268e+03,     1.128815920229506e+03,     1.129156757933777e+03,     1.129496906071145e+03,     1.129836367820719e+03, 
            1.130175146338878e+03,     1.130513244759488e+03,     1.130850666194124e+03,     1.131187413732280e+03,     1.131523490441585e+03, 
            1.131858899368013e+03,     1.132193643536091e+03,     1.132527725949098e+03,     1.132861149589274e+03,     1.133193917418021e+03, 
            1.133526032376093e+03,     1.133857497383796e+03,     1.134188315341181e+03,     1.134518489128236e+03,     1.134848021605068e+03, 
            1.135176915612098e+03,     1.135505173970235e+03,     1.135832799481068e+03,     1.136159794927034e+03,     1.136486163071608e+03, 
            1.136811906659469e+03,     1.137137028416675e+03,     1.137461531050839e+03,     1.137785417251293e+03,     1.138108689689257e+03, 
            1.138431351018005e+03,     1.138753403873030e+03,     1.139074850872200e+03,     1.139395694615924e+03,     1.139715937687307e+03, 
            1.140035582652307e+03,     1.140354632059887e+03,     1.140673088442171e+03,     1.140990954314594e+03,     1.141308232176049e+03, 
            1.141624924509034e+03,     1.141941033779804e+03,     1.142256562438508e+03,     1.142571512919333e+03,     1.142885887640650e+03, 
            1.143199689005146e+03,     1.143512919399969e+03,     1.143825581196857e+03,     1.144137676752277e+03,     1.144449208407562e+03, 
            1.144760178489033e+03,     1.145070589308139e+03,     1.145380443161579e+03,     1.145689742331435e+03,     1.145998489085293e+03, 
            1.146306685676372e+03,     1.146614334343644e+03,     1.146921437311961e+03,     1.147227996792169e+03,     1.147534014981233e+03, 
            1.147839494062352e+03,     1.148144436205077e+03,     1.148448843565426e+03,     1.148752718286000e+03,     1.149056062496097e+03, 
            1.149358878311817e+03,     1.149661167836182e+03,     1.149962933159240e+03,     1.150264176358174e+03,     1.150564899497413e+03, 
            1.150865104628732e+03,     1.151164793791361e+03,     1.151463969012089e+03,     1.151762632305368e+03,     1.152060785673409e+03, 
            1.152358431106289e+03,     1.152655570582048e+03,     1.152952206066788e+03,     1.153248339514770e+03,     1.153543972868512e+03, 
            1.153839108058882e+03,     1.154133747005197e+03,     1.154427891615311e+03,     1.154721543785714e+03,     1.155014705401618e+03, 
            1.155307378337053e+03,     1.155599564454949e+03,     1.155891265607237e+03,     1.156182483634926e+03,     1.156473220368194e+03, 
            1.156763477626477e+03,     1.157053257218553e+03,     1.157342560942622e+03,     1.157631390586396e+03,     1.157919747927180e+03, 
            1.158207634731952e+03,     1.158495052757447e+03,     1.158782003750235e+03,     1.159068489446804e+03,     1.159354511573633e+03, 
            1.159640071847277e+03,     1.159925171974441e+03,     1.160209813652054e+03,     1.160493998567351e+03,     1.160777728397943e+03, 
            1.161061004811891e+03,     1.161343829467784e+03,     1.161626204014808e+03,     1.161908130092821e+03,     1.162189609332422e+03, 
            1.162470643355021e+03,     1.162751233772915e+03,     1.163031382189349e+03,     1.163311090198593e+03,     1.163590359386002e+03, 
            1.163869191328091e+03,     1.164147587592598e+03,     1.164425549738549e+03,     1.164703079316326e+03,     1.164980177867731e+03, 
            1.165256846926052e+03,     1.165533088016120e+03,     1.165808902654383e+03,     1.166084292348961e+03,     1.166359258599707e+03
    },
    {
            1.881395495080858e+00,     5.716995544941688e+00,     9.649762992012226e+00,     1.368640196087473e+01,     1.783440360192346e+01, 
            2.210217970656145e+01,     2.649922688233278e+01,     3.103633029616131e+01,     3.572581930958794e+01,     4.058189214475883e+01, 
            4.562103384507131e+01,     5.086256257513161e+01,     5.632935602498755e+01,     6.204883635129548e+01,     6.805433599933242e+01, 
            7.438704176012338e+01,     8.109884816108448e+01,     8.825670217332676e+01,     9.594952143406185e+01,     1.042998441419450e+02, 
            1.134849157932274e+02,     1.237787719355580e+02,     8.623907255341605e+02,     8.654684124768959e+02,     8.684205326333605e+02, 
            8.712595110283112e+02,     8.739958729033109e+02,     8.766386262831020e+02,     8.791955507763703e+02,     8.816734193123738e+02, 
            8.840781709455289e+02,     8.864150473242564e+02,     8.886887017522679e+02,     8.909032872849291e+02,     8.930625285848505e+02, 
            8.951697810513164e+02,     8.972280798728780e+02,     8.992401810241947e+02,     9.012085957659592e+02,     9.031356198624452e+02, 
            9.050233584717137e+02,     9.068737474660835e+02,     9.086885717885802e+02,     9.104694813333288e+02,     9.122180047457465e+02, 
            9.139355614657300e+02,     9.156234722793855e+02,     9.172829685987025e+02,     9.189152006514756e+02,     9.205212447336650e+02, 
            9.221021096519670e+02,     9.236587424642610e+02,     9.251920336090842e+02,     9.267028215016982e+02,     9.281918966628662e+02, 
            9.296600054370498e+02,     9.311078533487661e+02,     9.325361081391599e+02,     9.339454025191841e+02,     9.353363366710140e+02, 
            9.367094805252143e+02,     9.380653758376989e+02,     9.394045380875550e+02,     9.407274582142198e+02,     9.420346042102815e+02, 
            9.433264225842833e+02,     9.446033397062395e+02,     9.458657630471274e+02,     9.471140823223645e+02,     9.483486705482046e+02, 
            9.495698850189810e+02,     9.507780682123300e+02,     9.519735486287502e+02,     9.531566415712171e+02,     9.543276498699956e+02, 
            9.554868645572561e+02,     9.566345654956974e+02,     9.577710219649111e+02,     9.588964932089272e+02,     9.600112288393523e+02, 
            9.611154698390171e+02,     9.622094480162350e+02,     9.632933873271186e+02,     9.643675039113245e+02,     9.654320064788207e+02, 
            9.664870966764692e+02,     9.675329694154897e+02,     9.685698131797379e+02,     9.695978103161544e+02,     9.706171373086129e+02, 
            9.716279650363296e+02,     9.726304590178562e+02,     9.736247796416545e+02,     9.746110823841086e+02,     9.755895180158299e+02, 
            9.765602327969873e+02,     9.775233686623855e+02,     9.784790633969207e+02,     9.794274508020343e+02,     9.803686608537118e+02, 
            9.813028198525419e+02,     9.822300505663258e+02,     9.831504723656751e+02,     9.840642013530185e+02,     9.849713504853942e+02, 
            9.858720296914114e+02,     9.867663459826855e+02,     9.876544035600818e+02,     9.885363038542977e+02,     9.894121458755543e+02, 
            9.902820259037767e+02,     9.911460378795824e+02,     9.920042733811832e+02,     9.928568217236300e+02,     9.937037700320088e+02, 
            9.945452033151594e+02,     9.953812045362321e+02,     9.962118546802667e+02,     9.970372323442565e+02,     9.978574155103915e+02, 
            9.986724792743062e+02,     9.994824973242791e+02,     1.000287541668545e+03,     1.001087682687888e+03,     1.001882989202969e+03, 
            1.002673528453963e+03,     1.003459366252994e+03,     1.004240566956615e+03,     1.005017193527461e+03,     1.005789307575699e+03, 
            1.006556969398921e+03,     1.007320238020520e+03,     1.008079171226668e+03,     1.008833825601911e+03,     1.009584256563469e+03, 
            1.010330518394300e+03,     1.011072664274961e+03,     1.011810746314341e+03,     1.012544815579306e+03,     1.013274922123292e+03, 
            1.014001115013912e+03,     1.014723442359607e+03,     1.015441951335371e+03,     1.016156688207611e+03,     1.016867698358157e+03, 
            1.017575026307475e+03,     1.018278715737091e+03,     1.018978809511292e+03,     1.019675349698100e+03,     1.020368377589559e+03, 
            1.021057933721382e+03,     1.021744057891953e+03,     1.022426789180716e+03,     1.023106165965998e+03,     1.023782225942264e+03, 
            1.024455006136818e+03,     1.025124542926008e+03,     1.025790872050919e+03,     1.026454028632581e+03,     1.027114047186721e+03, 
            1.027770961638074e+03,     1.028424805334246e+03,     1.029075611059181e+03,     1.029723411046223e+03,     1.030368236990790e+03, 
            1.031010120062677e+03,     1.031649090918006e+03,     1.032285179710832e+03,     1.032918416073445e+03,     1.033548829253120e+03, 
            1.034176447930984e+03,     1.034801300362345e+03,     1.035423414353677e+03,     1.036042817272386e+03,     1.036659536056315e+03, 
            1.037273597222973e+03,     1.037885026878521e+03,     1.038493850726516e+03,     1.039100094076409e+03,     1.039703781851823e+03, 
            1.040304938598610e+03,     1.040903588492688e+03,     1.041499755347676e+03,     1.042093462622327e+03,     1.042684733427772e+03, 
            1.043273590534566e+03,     1.043860056379561e+03,     1.044444153072599e+03,     1.045025902403038e+03,     1.045605325846107e+03, 
            1.046182444569102e+03,     1.046757279437436e+03,     1.047329851020515e+03,     1.047900179597503e+03,     1.048468285162909e+03, 
            1.049034187432061e+03,     1.049597905846439e+03,     1.050159459578872e+03,     1.050718867538623e+03,     1.051276148376339e+03, 
            1.051831320488892e+03,     1.052384402024098e+03,     1.052935410885327e+03,     1.053484364736011e+03,     1.054031281004031e+03, 
            1.054576176886020e+03,     1.055119069351553e+03,     1.055659975147247e+03,     1.056198910800764e+03,     1.056735892624723e+03, 
            1.057270936720526e+03,     1.057804058982093e+03,     1.058335275099519e+03,     1.058864600562643e+03,     1.059392050664539e+03, 
            1.059917640504932e+03,     1.060441384993542e+03,     1.060963298853341e+03,     1.061483396623756e+03,     1.062001692663792e+03, 
            1.062518201155089e+03,     1.063032936104913e+03,     1.063545911349086e+03,     1.064057140554853e+03,     1.064566637223681e+03, 
            1.065074414694011e+03,     1.065580486143940e+03,     1.066084864593857e+03,     1.066587562909017e+03,     1.067088593802063e+03, 
            1.067587969835500e+03,     1.068085703424112e+03,     1.068581806837336e+03,     1.069076292201580e+03,     1.069569171502503e+03, 
            1.070060456587242e+03,     1.070550158624222e+03,     1.071038290260488e+03,     1.071524862412280e+03,     1.072009886394056e+03, 
            1.072493373392253e+03,     1.072975334467251e+03,     1.073455780555320e+03,     1.073934722470514e+03,     1.074412170906537e+03, 
            1.074888136438567e+03,     1.075362629525051e+03,     1.075835660509454e+03,     1.076307239621993e+03,     1.076777376981320e+03, 
            1.077246082596186e+03,     1.077713366367064e+03,     1.078179238087745e+03,     1.078643707446912e+03,     1.079106784029670e+03, 
            1.079568477319058e+03,     1.080028796697531e+03,     1.080487751448415e+03,     1.080945350757330e+03,     1.081401603713595e+03, 
            1.081856519311602e+03,     1.082310106452168e+03,     1.082762373943860e+03,     1.083213330504300e+03,     1.083662984761439e+03, 
            1.084111345254820e+03,     1.084558420436810e+03,     1.085004218673805e+03,     1.085448748247435e+03,     1.085892017355719e+03, 
            1.086334034114226e+03,     1.086774806557198e+03,     1.087214342638661e+03,     1.087652650233516e+03,     1.088089737138612e+03, 
            1.088525611073796e+03,     1.088960279682954e+03,     1.089393750535022e+03,     1.089826031156093e+03,     1.090257128904863e+03, 
            1.090687051163637e+03,     1.091115805211396e+03,     1.091543398257015e+03,     1.091969837440174e+03,     1.092395129832268e+03, 
            1.092819282437291e+03,     1.093242302192714e+03,     1.093664195970341e+03,     1.094084970577159e+03,     1.094504632756165e+03, 
            1.094923189187191e+03,     1.095340646487701e+03,     1.095757011213591e+03,     1.096172289859963e+03,     1.096586488861893e+03, 
            1.096999614595188e+03,     1.097411673377126e+03,     1.097822671467188e+03,     1.098232615067775e+03,     1.098641510324920e+03, 
            1.099049363328982e+03,     1.099456180115332e+03,     1.099861966665030e+03,     1.100266728905484e+03,     1.100670472711113e+03, 
            1.101073203903984e+03,     1.101474928254452e+03,     1.101875651481778e+03,     1.102275379254751e+03,     1.102674117192286e+03, 
            1.103071870864029e+03,     1.103468645790937e+03,     1.103864447445863e+03,     1.104259281254118e+03,     1.104653152594039e+03, 
            1.105046066797540e+03,     1.105438029150655e+03,     1.105829044894077e+03,     1.106219119223684e+03,     1.106608257291062e+03, 
            1.106996464204016e+03,     1.107383745027077e+03,     1.107770104782001e+03,     1.108155548448259e+03,     1.108540080963520e+03, 
            1.108923707224127e+03,     1.109306432085573e+03,     1.109688260362953e+03,     1.110069196831433e+03,     1.110449246226690e+03, 
            1.110828413245361e+03,     1.111206702545481e+03,     1.111584118746907e+03,     1.111960666431753e+03,     1.112336350144798e+03, 
            1.112711174393910e+03,     1.113085143650445e+03,     1.113458262349652e+03,     1.113830534891071e+03,     1.114201965638917e+03, 
            1.114572558922472e+03,     1.114942319036463e+03,     1.115311250241432e+03,     1.115679356764112e+03,     1.116046642797786e+03, 
            1.116413112502652e+03,     1.116778770006172e+03,     1.117143619403424e+03,     1.117507664757446e+03,     1.117870910099580e+03, 
            1.118233359429803e+03,     1.118595016717060e+03,     1.118955885899594e+03,     1.119315970885262e+03,     1.119675275551856e+03, 
            1.120033803747423e+03,     1.120391559290565e+03,     1.120748545970750e+03,     1.121104767548614e+03,     1.121460227756258e+03, 
            1.121814930297539e+03,     1.122168878848367e+03,     1.122522077056981e+03,     1.122874528544243e+03,     1.123226236903909e+03, 
            1.123577205702907e+03,     1.123927438481608e+03,     1.124276938754095e+03,     1.124625710008429e+03,     1.124973755706908e+03, 
            1.125321079286326e+03,     1.125667684158230e+03,     1.126013573709166e+03,     1.126358751300937e+03,     1.126703220270838e+03, 
            1.127046983931907e+03,     1.127390045573157e+03,     1.127732408459816e+03,     1.128074075833565e+03,     1.128415050912757e+03, 
            1.128755336892655e+03,     1.129094936945651e+03,     1.129433854221491e+03,     1.129772091847493e+03,     1.130109652928764e+03, 
            1.130446540548413e+03,     1.130782757767764e+03,     1.131118307626564e+03,     1.131453193143189e+03,     1.131787417314848e+03, 
            1.132120983117783e+03,     1.132453893507473e+03,     1.132786151418822e+03,     1.133117759766362e+03,     1.133448721444439e+03, 
            1.133779039327403e+03,     1.134108716269799e+03,     1.134437755106547e+03,     1.134766158653132e+03,     1.135093929705774e+03, 
            1.135421071041621e+03,     1.135747585418909e+03,     1.136073475577152e+03,     1.136398744237303e+03,     1.136723394101931e+03, 
            1.137047427855386e+03,     1.137370848163968e+03,     1.137693657676090e+03,     1.138015859022440e+03,     1.138337454816145e+03, 
            1.138658447652925e+03,     1.138978840111255e+03,     1.139298634752518e+03,     1.139617834121158e+03,     1.139936440744834e+03, 
            1.140254457134569e+03,     1.140571885784895e+03,     1.140888729174007e+03,     1.141204989763902e+03,     1.141520670000525e+03, 
            1.141835772313912e+03,     1.142150299118325e+03,     1.142464252812398e+03,     1.142777635779270e+03,     1.143090450386719e+03, 
            1.143402698987300e+03,     1.143714383918478e+03,     1.144025507502753e+03,     1.144336072047798e+03,     1.144646079846581e+03, 
            1.144955533177496e+03,     1.145264434304486e+03,     1.145572785477169e+03,     1.145880588930958e+03,     1.146187846887186e+03, 
            1.146494561553225e+03,     1.146800735122603e+03,     1.147106369775126e+03,     1.147411467676989e+03,     1.147716030980894e+03, 
            1.148020061826165e+03,     1.148323562338858e+03,     1.148626534631875e+03,     1.148928980805070e+03,     1.149230902945366e+03, 
            1.149532303126854e+03,     1.149833183410905e+03,     1.150133545846277e+03,     1.150433392469213e+03,     1.150732725303552e+03, 
            1.151031546360828e+03,     1.151329857640370e+03,     1.151627661129405e+03,     1.151924958803156e+03,     1.152221752624938e+03, 
            1.152518044546264e+03,     1.152813836506926e+03,     1.153109130435105e+03,     1.153403928247458e+03,     1.153698231849212e+03, 
            1.153992043134257e+03,     1.154285363985237e+03,     1.154578196273641e+03,     1.154870541859891e+03,     1.155162402593433e+03, 
            1.155453780312825e+03,     1.155744676845820e+03,     1.156035094009454e+03,     1.156325033610134e+03,     1.156614497443719e+03, 
            1.156903487295602e+03,     1.157192004940797e+03,     1.157480052144019e+03,     1.157767630659760e+03,     1.158054742232380e+03, 
            1.158341388596176e+03,     1.158627571475464e+03,     1.158913292584660e+03,     1.159198553628352e+03,     1.159483356301379e+03, 
            1.159767702288907e+03,     1.160051593266502e+03,     1.160335030900205e+03,     1.160618016846605e+03,     1.160900552752913e+03, 
            1.161182640257032e+03,     1.161464280987628e+03,     1.161745476564203e+03,     1.162026228597162e+03,     1.162306538687885e+03, 
            1.162586408428794e+03,     1.162865839403418e+03,     1.163144833186468e+03,     1.163423391343895e+03,     1.163701515432959e+03, 
            1.163979207002298e+03,     1.164256467591988e+03,     1.164533298733608e+03,     1.164809701950305e+03,     1.165085678756856e+03
    },
    {
            1.877317035907007e+00,     5.704101418839426e+00,     9.627093240708961e+00,     1.365286921676659e+01,     1.778877016307758e+01, 
            2.204302925816702e+01,     2.642492928345204e+01,     3.094499727338376e+01,     3.561524806637459e+01,     4.044949267085149e+01, 
            4.546373387287972e+01,     5.067668130845938e+01,     5.611043331946092e+01,     6.179139681228912e+01,     6.775155536142161e+01, 
            7.403026181016469e+01,     8.067684796983592e+01,     8.775455927997463e+01,     9.534674442336109e+01,     1.035671186147895e+02, 
            1.125779674799791e+02,     1.226254672084613e+02,     1.341175138068095e+02,     8.600425869675877e+02,     8.631459990871158e+02, 
            8.661228430588338e+02,     8.689855591852097e+02,     8.717447038931846e+02,     8.744093250475287e+02,     8.769872462739789e+02, 
            8.794852859298351e+02,     8.819094282141903e+02,     8.842649586209020e+02,     8.865565724167185e+02,     8.887884624310771e+02, 
            8.909643907815690e+02,     8.930877479846977e+02,     8.951616020588360e+02,     8.971887396127155e+02,     8.991717004600811e+02, 
            9.011128069631687e+02,     9.030141890523620e+02,     9.048778056747678e+02,     9.067054632743856e+02,     9.084988317901024e+02, 
            9.102594585664048e+02,     9.119887804996415e+02,     9.136881346853223e+02,     9.153587677860685e+02,     9.170018443028216e+02, 
            9.186184539019300e+02,     9.202096179263012e+02,     9.217762951987352e+02,     9.233193872090766e+02,     9.248397427631079e+02, 
            9.263381621597763e+02,     9.278154009537905e+02,     9.292721733527231e+02,     9.307091552909436e+02,     9.321269872171417e+02, 
            9.335262766272605e+02,     9.349076003706673e+02,     9.362715067538045e+02,     9.376185174625849e+02,     9.389491293222138e+02, 
            9.402638159108986e+02,     9.415630290419409e+02,     9.428472001270794e+02,     9.441167414324734e+02,     9.453720472374519e+02, 
            9.466134949050397e+02,     9.478414458723255e+02,     9.490562465678511e+02,     9.502582292624800e+02,     9.514477128595190e+02, 
            9.526250036293119e+02,     9.537903958929613e+02,     9.549441726594343e+02,     9.560866062198477e+02,     9.572179587023958e+02, 
            9.583384825269346e+02,     9.594484212059444e+02,     9.605480091823782e+02,     9.616374728479320e+02,     9.627170306710786e+02, 
            9.637868936121063e+02,     9.648472654807965e+02,     9.658983432682533e+02,     9.669403174592932e+02,     9.679733723267561e+02, 
            9.689976862089853e+02,     9.700134317716556e+02,     9.710207762549929e+02,     9.720198817073816e+02,     9.730109052062410e+02, 
            9.739939990670337e+02,     9.749693110411512e+02,     9.759369845033937e+02,     9.768971586297167e+02,     9.778499685658333e+02, 
            9.787955455872529e+02,     9.797340172512781e+02,     9.806655075414370e+02,     9.815901370048226e+02,     9.825080228827374e+02, 
            9.834192792350575e+02,     9.843240170586654e+02,     9.852223444002990e+02,     9.861143664641319e+02,     9.870001856482404e+02, 
            9.878799019138532e+02,     9.887536124628820e+02,     9.896214121132734e+02,     9.904833933094224e+02,     9.913396462036659e+02, 
            9.921902587342639e+02,     9.930353167000153e+02,     9.938749038316892e+02,     9.947091018604183e+02,     9.955379900072923e+02, 
            9.963616471361622e+02,     9.971801489501831e+02,     9.979935698050384e+02,     9.988019823584500e+02,     9.996054576234005e+02, 
            1.000404065019238e+03,     1.001197872436749e+03,     1.001986946219876e+03,     1.002771351311610e+03,     1.003551151228862e+03, 
            1.004326408122027e+03,     1.005097182815340e+03,     1.005863534845710e+03,     1.006625522500117e+03,     1.007383202851614e+03, 
            1.008136631794035e+03,     1.008885864075422e+03,     1.009630953330262e+03,     1.010371952110564e+03,     1.011108911915840e+03, 
            1.011841883222023e+03,     1.012570915509390e+03,     1.013296057289497e+03,     1.014017356131213e+03,     1.014734858685841e+03, 
            1.015448610711405e+03,     1.016158657096111e+03,     1.016865041881032e+03,     1.017567808282034e+03,     1.018266998710988e+03, 
            1.018962654796283e+03,     1.019654817402681e+03,     1.020343526650521e+03,     1.021028821934323e+03,     1.021710741940791e+03, 
            1.022389324666253e+03,     1.023064607433556e+03,     1.023736626908428e+03,     1.024405419115345e+03,     1.025071019452907e+03, 
            1.025733462708739e+03,     1.026392783073951e+03,     1.027049014157158e+03,     1.027702188998081e+03,     1.028352340080745e+03, 
            1.028999499346292e+03,     1.029643698205406e+03,     1.030284967550393e+03,     1.030923337735560e+03,     1.031558838715955e+03, 
            1.032191499864271e+03,     1.032821350113212e+03,     1.033448417932455e+03,     1.034072731338806e+03,     1.034694317906066e+03, 
            1.035313204774620e+03,     1.035929418660774e+03,     1.036542985865828e+03,     1.037153932284899e+03,     1.037762283415520e+03, 
            1.038368064365986e+03,     1.038971299863502e+03,     1.039572014262091e+03,     1.040170231550312e+03,     1.040765975358761e+03, 
            1.041359268967386e+03,     1.041950135312610e+03,     1.042538596994259e+03,     1.043124676282340e+03,     1.043708395123607e+03, 
            1.044289775147994e+03,     1.044868837674872e+03,     1.045445603719144e+03,     1.046020093997197e+03,     1.046592328932703e+03, 
            1.047162328662276e+03,     1.047730113040990e+03,     1.048295701647761e+03,     1.048859113790607e+03,     1.049420368511761e+03, 
            1.049979484592688e+03,     1.050536480558957e+03,     1.051091374685013e+03,     1.051644184998831e+03,     1.052194929286458e+03, 
            1.052743625096453e+03,     1.053290289744220e+03,     1.053834940316241e+03,     1.054377593674215e+03,     1.054918266459102e+03, 
            1.055456975095062e+03,     1.055993735793324e+03,     1.056528564555951e+03,     1.057061477179534e+03,     1.057592489258790e+03, 
            1.058121616190092e+03,     1.058648873174908e+03,     1.059174275223179e+03,     1.059697837156609e+03,     1.060219573611891e+03, 
            1.060739499043860e+03,     1.061257627728583e+03,     1.061773973766367e+03,     1.062288551084728e+03,     1.062801373441271e+03, 
            1.063312454426524e+03,     1.063821807466706e+03,     1.064329445826442e+03,     1.064835382611416e+03,     1.065339630770968e+03, 
            1.065842203100643e+03,     1.066343112244681e+03,     1.066842370698461e+03,     1.067339990810891e+03,     1.067835984786752e+03, 
            1.068330364154524e+03,     1.068823141892126e+03,     1.069314329265250e+03,     1.069803937924658e+03,     1.070291979388005e+03, 
            1.070778465041915e+03,     1.071263406144017e+03,     1.071746813824931e+03,     1.072228699090229e+03,     1.072709072822347e+03, 
            1.073187945782465e+03,     1.073665328612346e+03,     1.074141231836151e+03,     1.074615665862200e+03,     1.075088640984718e+03, 
            1.075560167385537e+03,     1.076030255135770e+03,     1.076498914197451e+03,     1.076966154425144e+03,     1.077431985567529e+03, 
            1.077896417268941e+03,     1.078359459070907e+03,     1.078821120413628e+03,     1.079281410637446e+03,     1.079740338984291e+03, 
            1.080197914599087e+03,     1.080654146531138e+03,     1.081109043735498e+03,     1.081562615074298e+03,     1.082014869318071e+03, 
            1.082465815147029e+03,     1.082915461152339e+03,     1.083363815837364e+03,     1.083810887618885e+03,     1.084256684828303e+03, 
            1.084701215712816e+03,     1.085144488436579e+03,     1.085586511081843e+03,     1.086027291650076e+03,     1.086466838063056e+03, 
            1.086905158163957e+03,     1.087342259748926e+03,     1.087778150444949e+03,     1.088212837897350e+03,     1.088646329645319e+03, 
            1.089078633154569e+03,     1.089509755818310e+03,     1.089939704958217e+03,     1.090368487825360e+03,     1.090796111601136e+03, 
            1.091222583398183e+03,     1.091647910261270e+03,     1.092072099168182e+03,     1.092495157030584e+03,     1.092917090694877e+03, 
            1.093337906943030e+03,     1.093757612493415e+03,     1.094176214001607e+03,     1.094593718061192e+03,     1.095010131204544e+03, 
            1.095425459903607e+03,     1.095839710570647e+03,     1.096252889559004e+03,     1.096665003163830e+03,     1.097076057622812e+03, 
            1.097486059116885e+03,     1.097895013770933e+03,     1.098302927654486e+03,     1.098709806782391e+03,     1.099115657115490e+03, 
            1.099520484561277e+03,     1.099924294974543e+03,     1.100327094158021e+03,     1.100728887863014e+03,     1.101129681790009e+03, 
            1.101529481589295e+03,     1.101928292861560e+03,     1.102326121158485e+03,     1.102722971983322e+03,     1.103118850791476e+03, 
            1.103513762991060e+03,     1.103907713943464e+03,     1.104300708963894e+03,     1.104692753321918e+03,     1.105083852241996e+03, 
            1.105474010904005e+03,     1.105863234443757e+03,     1.106251527953509e+03,     1.106638896482463e+03,     1.107025345037259e+03, 
            1.107410878582468e+03,     1.107795502041066e+03,     1.108179220294913e+03,     1.108562038185215e+03,     1.108943960512986e+03, 
            1.109324992039502e+03,     1.109705137486746e+03,     1.110084401537849e+03,     1.110462788837525e+03,     1.110840303992498e+03, 
            1.111216951571924e+03,     1.111592736107809e+03,     1.111967662095416e+03,     1.112341733993673e+03,     1.112714956225568e+03, 
            1.113087333178547e+03,     1.113458869204898e+03,     1.113829568622132e+03,     1.114199435713371e+03,     1.114568474727702e+03, 
            1.114936689880562e+03,     1.115304085354089e+03,     1.115670665297481e+03,     1.116036433827354e+03,     1.116401395028079e+03, 
            1.116765552952134e+03,     1.117128911620438e+03,     1.117491475022685e+03,     1.117853247117673e+03,     1.118214231833632e+03, 
            1.118574433068537e+03,     1.118933854690432e+03,     1.119292500537737e+03,     1.119650374419561e+03,     1.120007480115998e+03, 
            1.120363821378435e+03,     1.120719401929840e+03,     1.121074225465065e+03,     1.121428295651120e+03,     1.121781616127473e+03, 
            1.122134190506315e+03,     1.122486022372851e+03,     1.122837115285567e+03,     1.123187472776499e+03,     1.123537098351504e+03, 
            1.123885995490520e+03,     1.124234167647827e+03,     1.124581618252305e+03,     1.124928350707684e+03,     1.125274368392798e+03, 
            1.125619674661831e+03,     1.125964272844559e+03,     1.126308166246592e+03,     1.126651358149614e+03,     1.126993851811614e+03, 
            1.127335650467123e+03,     1.127676757327437e+03,     1.128017175580849e+03,     1.128356908392870e+03,     1.128695958906449e+03, 
            1.129034330242194e+03,     1.129372025498581e+03,     1.129709047752178e+03,     1.130045400057842e+03,     1.130381085448938e+03, 
            1.130716106937536e+03,     1.131050467514619e+03,     1.131384170150280e+03,     1.131717217793923e+03,     1.132049613374453e+03, 
            1.132381359800476e+03,     1.132712459960484e+03,     1.133042916723048e+03,     1.133372732937000e+03,     1.133701911431622e+03, 
            1.134030455016823e+03,     1.134358366483324e+03,     1.134685648602830e+03,     1.135012304128209e+03,     1.135338335793667e+03, 
            1.135663746314916e+03,     1.135988538389346e+03,     1.136312714696190e+03,     1.136636277896695e+03,     1.136959230634277e+03, 
            1.137281575534694e+03,     1.137603315206195e+03,     1.137924452239686e+03,     1.138244989208882e+03,     1.138564928670466e+03, 
            1.138884273164233e+03,     1.139203025213255e+03,     1.139521187324016e+03,     1.139838761986569e+03,     1.140155751674679e+03, 
            1.140472158845967e+03,     1.140787985942054e+03,     1.141103235388702e+03,     1.141417909595951e+03,     1.141732010958261e+03, 
            1.142045541854647e+03,     1.142358504648812e+03,     1.142670901689285e+03,     1.142982735309548e+03,     1.143294007828169e+03, 
            1.143604721548933e+03,     1.143914878760966e+03,     1.144224481738865e+03,     1.144533532742819e+03,     1.144842034018736e+03, 
            1.145149987798364e+03,     1.145457396299413e+03,     1.145764261725672e+03,     1.146070586267131e+03,     1.146376372100095e+03, 
            1.146681621387301e+03,     1.146986336278034e+03,     1.147290518908236e+03,     1.147594171400625e+03,     1.147897295864801e+03, 
            1.148199894397354e+03,     1.148501969081981e+03,     1.148803521989583e+03,     1.149104555178379e+03,     1.149405070694011e+03, 
            1.149705070569642e+03,     1.150004556826063e+03,     1.150303531471801e+03,     1.150601996503204e+03,     1.150899953904560e+03, 
            1.151197405648181e+03,     1.151494353694509e+03,     1.151790799992210e+03,     1.152086746478268e+03,     1.152382195078084e+03, 
            1.152677147705569e+03,     1.152971606263231e+03,     1.153265572642277e+03,     1.153559048722694e+03,     1.153852036373345e+03, 
            1.154144537452060e+03,     1.154436553805717e+03,     1.154728087270335e+03,     1.155019139671159e+03,     1.155309712822746e+03, 
            1.155599808529049e+03,     1.155889428583501e+03,     1.156178574769099e+03,     1.156467248858485e+03,     1.156755452614028e+03, 
            1.157043187787905e+03,     1.157330456122183e+03,     1.157617259348890e+03,     1.157903599190102e+03,     1.158189477358020e+03, 
            1.158474895555038e+03,     1.158759855473830e+03,     1.159044358797418e+03,     1.159328407199250e+03,     1.159612002343270e+03, 
            1.159895145883995e+03,     1.160177839466588e+03,     1.160460084726925e+03,     1.160741883291666e+03,     1.161023236778335e+03, 
            1.161304146795375e+03,     1.161584614942229e+03,     1.161864642809401e+03,     1.162144231978527e+03,     1.162423384022441e+03, 
            1.162702100505241e+03,     1.162980382982356e+03,     1.163258233000609e+03,     1.163535652098283e+03,     1.163812641805184e+03
    },
    {
            1.873256596088225e+00,     5.691269000445881e+00,     9.604540902102578e+00,     1.361952434380671e+01,     1.774341327302423e+01, 
            2.198426667882850e+01,     2.635115921259313e+01,     3.085436718483558e+01,     3.550560065563688e+01,     4.031829640102704e+01, 
            4.530799249217484e+01,     5.049281413155972e+01,     5.589411402896334e+01,     6.153733203835554e+01,     6.745317349323058e+01, 
            7.367926384710242e+01,     8.026253861815995e+01,     8.726281275766972e+01,     9.475833080054109e+01,     1.028548364083220e+02, 
            1.117013560432618e+02,     1.215200390164062e+02,     1.326694569275419e+02,     8.544392289586306e+02,     8.577103649662947e+02, 
            8.608391082683349e+02,     8.638402848219655e+02,     8.667263558790009e+02,     8.695079123760320e+02,     8.721940438483190e+02, 
            8.747926188124446e+02,     8.773105013147634e+02,     8.797537205704806e+02,     8.821276055471869e+02,     8.844368929564929e+02, 
            8.866858148014044e+02,     8.888781700141283e+02,     8.910173835761479e+02,     8.931065556897753e+02,     8.951485029698883e+02, 
            8.971457931804055e+02,     8.991007747077352e+02,     9.010156017118763e+02,     9.028922557036686e+02,     9.047325641483684e+02, 
            9.065382165803228e+02,     9.083107786229257e+02,     9.100517042364537e+02,     9.117623464593421e+02,     9.134439668627874e+02, 
            9.150977439016325e+02,     9.167247803146112e+02,     9.183261097025915e+02,     9.199027023933933e+02,     9.214554706852666e+02, 
            9.229852735473938e+02,     9.244929208443934e+02,     9.259791771422597e+02,     9.274447651451976e+02,     9.288903688060293e+02, 
            9.303166361471774e+02,     9.317241818243691e+02,     9.331135894610800e+02,     9.344854137782048e+02,     9.358401825404180e+02, 
            9.371783983380934e+02,     9.385005402213809e+02,     9.398070652011199e+02,     9.410984096295712e+02,     9.423749904724826e+02, 
            9.436372064827267e+02,     9.448854392846258e+02,     9.461200543771095e+02,     9.473414020629851e+02,     9.485498183108319e+02, 
            9.497456255553850e+02,     9.509291334416625e+02,     9.521006395175906e+02,     9.532604298793807e+02,     9.544087797735474e+02, 
            9.555459540143970e+02,     9.566722082003369e+02,     9.577877879207928e+02,     9.588929303396443e+02,     9.599878642267454e+02, 
            9.610728103461119e+02,     9.621479818682559e+02,     9.632135847275696e+02,     9.642698179584373e+02,     9.653168740116340e+02, 
            9.663549390524099e+02,     9.673841932415309e+02,     9.684048110004400e+02,     9.694169612616399e+02,     9.704208077052546e+02, 
            9.714165089827220e+02,     9.724042189284345e+02,     9.733840867601281e+02,     9.743562572687157e+02,     9.753208709982707e+02, 
            9.762780644167301e+02,     9.772279700779400e+02,     9.781707167755319e+02,     9.791064296891591e+02,     9.800352305235223e+02, 
            9.809572376406351e+02,     9.818725661857114e+02,     9.827813282070509e+02,     9.836836327702636e+02,     9.845795860671692e+02, 
            9.854692915196442e+02,     9.863528498151983e+02,     9.872303592665958e+02,     9.881019154952002e+02,     9.889676117946349e+02, 
            9.898275391418490e+02,     9.906817862760286e+02,     9.915304397740962e+02,     9.923735841229876e+02,     9.932113012914726e+02, 
            9.940436725910404e+02,     9.948707762927124e+02,     9.956926891815207e+02,     9.965094862708372e+02,     9.973212408584652e+02, 
            9.981280245804782e+02,     9.989299074629049e+02,     9.997269579880819e+02,     1.000519243074008e+03,     1.001306828225214e+03, 
            1.002089777505077e+03,     1.002868153596647e+03,     1.003642017843460e+03,     1.004411430288805e+03,     1.005176449713543e+03, 
            1.005937133672513e+03,     1.006693538529628e+03,     1.007445719491671e+03,     1.008193730640889e+03,     1.008937624966417e+03, 
            1.009677454394588e+03,     1.010413269818165e+03,     1.011145121124575e+03,     1.011873057223138e+03,     1.012597126071374e+03, 
            1.013317374700410e+03,     1.014033849239523e+03,     1.014746594939853e+03,     1.015455656197332e+03,     1.016161076574850e+03, 
            1.016862898823684e+03,     1.017561164904242e+03,     1.018255916006113e+03,     1.018947192567489e+03,     1.019635034293956e+03, 
            1.020319480176691e+03,     1.021000568510081e+03,     1.021678336908797e+03,     1.022352822324331e+03,     1.023024061061015e+03, 
            1.023692088791570e+03,     1.024356940572153e+03,     1.025018650856972e+03,     1.025677253512441e+03,     1.026332781830929e+03, 
            1.026985268544091e+03,     1.027634745835805e+03,     1.028281245354731e+03,     1.028924798194864e+03,     1.029565435035980e+03, 
            1.030203185959053e+03,     1.030838080590360e+03,     1.031470148078523e+03,     1.032099417105055e+03,     1.032725915894612e+03, 
            1.033349672224957e+03,     1.033970713436651e+03,     1.034589066442475e+03,     1.035204757736592e+03,     1.035817813403465e+03, 
            1.036428259126529e+03,     1.037036120196628e+03,     1.037641421520237e+03,     1.038244187627448e+03,     1.038844442679763e+03, 
            1.039442210477668e+03,     1.040037514468020e+03,     1.040630377751232e+03,     1.041220823088279e+03,     1.041808872907523e+03, 
            1.042394549311365e+03,     1.042977874082718e+03,     1.043558868691334e+03,     1.044137554299957e+03,     1.044713951770328e+03, 
            1.045288081669039e+03,     1.045859964273250e+03,     1.046429619576251e+03,     1.046997067292900e+03,     1.047562326864927e+03, 
            1.048125417466103e+03,     1.048686358007291e+03,     1.049245167141375e+03,     1.049801863268069e+03,     1.050356464538617e+03, 
            1.050908988860376e+03,     1.051459453901294e+03,     1.052007877094288e+03,     1.052554275641511e+03,     1.053098666518534e+03, 
            1.053641066478415e+03,     1.054181492055689e+03,     1.054719959570263e+03,     1.055256485131216e+03,     1.055791084640528e+03, 
            1.056323773796708e+03,     1.056854568098356e+03,     1.057383482847637e+03,     1.057910533153683e+03,     1.058435733935914e+03, 
            1.058959099927296e+03,     1.059480645677519e+03,     1.060000385556114e+03,     1.060518333755490e+03,     1.061034504293924e+03, 
            1.061548911018473e+03,     1.062061567607827e+03,     1.062572487575107e+03,     1.063081684270596e+03,     1.063589170884422e+03, 
            1.064094960449176e+03,     1.064599065842478e+03,     1.065101499789498e+03,     1.065602274865410e+03,     1.066101403497814e+03, 
            1.066598897428607e+03,     1.067094769863593e+03,     1.067589032275566e+03,     1.068081696524958e+03,     1.068572774335970e+03, 
            1.069062277298699e+03,     1.069550216871237e+03,     1.070036604381717e+03,     1.070521451030323e+03,     1.071004767891262e+03, 
            1.071486565914698e+03,     1.071966855928639e+03,     1.072445648640805e+03,     1.072922954640439e+03,     1.073398784400101e+03, 
            1.073873148277421e+03,     1.074346056516813e+03,     1.074817519251164e+03,     1.075287546503489e+03,     1.075756148188559e+03, 
            1.076223334114483e+03,     1.076689113984283e+03,     1.077153497397420e+03,     1.077616493851304e+03,     1.078078112742774e+03, 
            1.078538363369541e+03,     1.078997254931622e+03,     1.079454796532731e+03,     1.079910997181656e+03,     1.080365865793606e+03, 
            1.080819411191536e+03,     1.081271642107444e+03,     1.081722567183651e+03,     1.082172194974055e+03,     1.082620533945363e+03, 
            1.083067592478297e+03,     1.083513378868788e+03,     1.083957901329144e+03,     1.084401168020230e+03,     1.084843186927312e+03, 
            1.085283966050851e+03,     1.085723513279929e+03,     1.086161836425550e+03,     1.086598943221685e+03,     1.087034841326310e+03, 
            1.087469538322419e+03,     1.087903041719029e+03,     1.088335358952155e+03,     1.088766497385780e+03,     1.089196464312802e+03, 
            1.089625266955973e+03,     1.090052912468809e+03,     1.090479407936500e+03,     1.090904760376792e+03,     1.091328976740868e+03, 
            1.091752063914197e+03,     1.092174028717388e+03,     1.092594877907015e+03,     1.093014618176438e+03,     1.093433256156608e+03, 
            1.093850798416854e+03,     1.094267251465666e+03,     1.094682621751462e+03,     1.095096915663335e+03,     1.095510139531805e+03, 
            1.095922299629543e+03,     1.096333402172089e+03,     1.096743453318564e+03,     1.097152459172362e+03,     1.097560425781839e+03, 
            1.097967359140986e+03,     1.098373265190091e+03,     1.098778149816399e+03,     1.099182018854750e+03,     1.099584878088216e+03, 
            1.099986733248724e+03,     1.100387590017673e+03,     1.100787454026536e+03,     1.101186330857460e+03,     1.101584226043850e+03, 
            1.101981145070949e+03,     1.102377093376407e+03,     1.102772076350843e+03,     1.103166099338398e+03,     1.103559167637276e+03, 
            1.103951286500286e+03,     1.104342461135367e+03,     1.104732696706107e+03,     1.105121998332263e+03,     1.105510371090257e+03, 
            1.105897820013684e+03,     1.106284350093795e+03,     1.106669966279986e+03,     1.107054673480269e+03,     1.107438476561751e+03, 
            1.107821380351088e+03,     1.108203389634946e+03,     1.108584509160452e+03,     1.108964743635635e+03,     1.109344097729864e+03, 
            1.109722576074279e+03,     1.110100183262218e+03,     1.110476923849634e+03,     1.110852802355506e+03,     1.111227823262253e+03, 
            1.111601991016130e+03,     1.111975310027625e+03,     1.112347784671851e+03,     1.112719419288933e+03,     1.113090218184381e+03, 
            1.113460185629473e+03,     1.113829325861620e+03,     1.114197643084731e+03,     1.114565141469573e+03,     1.114931825154126e+03, 
            1.115297698243932e+03,     1.115662764812441e+03,     1.116027028901351e+03,     1.116390494520944e+03,     1.116753165650419e+03, 
            1.117115046238213e+03,     1.117476140202335e+03,     1.117836451430671e+03,     1.118195983781308e+03,     1.118554741082842e+03, 
            1.118912727134680e+03,     1.119269945707344e+03,     1.119626400542773e+03,     1.119982095354611e+03,     1.120337033828500e+03, 
            1.120691219622367e+03,     1.121044656366707e+03,     1.121397347664859e+03,     1.121749297093286e+03,     1.122100508201844e+03, 
            1.122450984514051e+03,     1.122800729527353e+03,     1.123149746713384e+03,     1.123498039518228e+03,     1.123845611362669e+03, 
            1.124192465642448e+03,     1.124538605728508e+03,     1.124884034967239e+03,     1.125228756680728e+03,     1.125572774166987e+03, 
            1.125916090700199e+03,     1.126258709530947e+03,     1.126600633886446e+03,     1.126941866970771e+03,     1.127282411965080e+03, 
            1.127622272027841e+03,     1.127961450295045e+03,     1.128299949880429e+03,     1.128637773875686e+03,     1.128974925350677e+03, 
            1.129311407353645e+03,     1.129647222911414e+03,     1.129982375029598e+03,     1.130316866692801e+03,     1.130650700864818e+03, 
            1.130983880488825e+03,     1.131316408487585e+03,     1.131648287763630e+03,     1.131979521199454e+03,     1.132310111657702e+03, 
            1.132640061981353e+03,     1.132969374993908e+03,     1.133298053499562e+03,     1.133626100283390e+03,     1.133953518111525e+03, 
            1.134280309731328e+03,     1.134606477871559e+03,     1.134932025242554e+03,     1.135256954536392e+03,     1.135581268427056e+03, 
            1.135904969570607e+03,     1.136228060605339e+03,     1.136550544151944e+03,     1.136872422813669e+03,     1.137193699176476e+03, 
            1.137514375809197e+03,     1.137834455263686e+03,     1.138153940074970e+03,     1.138472832761406e+03,     1.138791135824822e+03, 
            1.139108851750667e+03,     1.139425983008156e+03,     1.139742532050417e+03,     1.140058501314627e+03,     1.140373893222156e+03, 
            1.140688710178708e+03,     1.141002954574454e+03,     1.141316628784168e+03,     1.141629735167367e+03,     1.141942276068437e+03, 
            1.142254253816771e+03,     1.142565670726891e+03,     1.142876529098584e+03,     1.143186831217026e+03,     1.143496579352905e+03, 
            1.143805775762554e+03,     1.144114422688062e+03,     1.144422522357409e+03,     1.144730076984572e+03,     1.145037088769656e+03, 
            1.145343559899008e+03,     1.145649492545332e+03,     1.145954888867804e+03,     1.146259751012189e+03,     1.146564081110952e+03, 
            1.146867881283369e+03,     1.147171153635641e+03,     1.147473900260997e+03,     1.147776123239810e+03,     1.148077824639697e+03, 
            1.148379006515628e+03,     1.148679670910032e+03,     1.148979819852899e+03,     1.149279455361883e+03,     1.149578579442401e+03, 
            1.149877194087741e+03,     1.150175301279151e+03,     1.150472902985947e+03,     1.150770001165604e+03,     1.151066597763855e+03, 
            1.151362694714787e+03,     1.151658293940933e+03,     1.151953397353367e+03,     1.152248006851798e+03,     1.152542124324657e+03, 
            1.152835751649195e+03,     1.153128890691564e+03,     1.153421543306914e+03,     1.153713711339472e+03,     1.154005396622638e+03, 
            1.154296600979067e+03,     1.154587326220753e+03,     1.154877574149115e+03,     1.155167346555082e+03,     1.155456645219171e+03, 
            1.155745471911576e+03,     1.156033828392243e+03,     1.156321716410952e+03,     1.156609137707398e+03,     1.156896094011269e+03, 
            1.157182587042323e+03,     1.157468618510468e+03,     1.157754190115832e+03,     1.158039303548846e+03,     1.158323960490316e+03, 
            1.158608162611496e+03,     1.158891911574163e+03,     1.159175209030691e+03,     1.159458056624118e+03,     1.159740455988223e+03, 
            1.160022408747594e+03,     1.160303916517699e+03,     1.160584980904955e+03,     1.160865603506795e+03,     1.161145785911738e+03, 
            1.161425529699456e+03,     1.161704836440842e+03,     1.161983707698072e+03,     1.162262145024675e+03,     1.162540149965594e+03
    },
    {
            1.869214052744953e+00,     5.678497810718655e+00,     9.582104951246050e+00,     1.358636551341043e+01,     1.769832994811787e+01, 
            2.192588734846487e+01,     2.627790975009411e+01,     3.076442989125288e+01,     3.539686243104560e+01,     4.018828236135247e+01, 
            4.515377979479418e+01,     5.031091841424393e+01,     5.568033719977570e+01,     6.128655429494331e+01,     6.715906279169839e+01, 
            7.333385954008095e+01,     7.985563659463720e+01,     8.678102445195405e+01,     9.418357940969736e+01,     1.021618213000666e+02, 
            1.108529740708030e+02,     1.204583271799522e+02,     1.312952158124600e+02,     8.486395109605539e+02,     8.520977424571203e+02, 
            8.553947528946628e+02,     8.585483779491113e+02,     8.615734479506642e+02,     8.644824493349261e+02,     8.672860097900615e+02, 
            8.699932615174799e+02,     8.726121181416103e+02,     8.751494891335306e+02,     8.776114481699299e+02,     8.800033669707281e+02, 
            8.823300228843170e+02,     8.845956862442539e+02,     8.868041919525671e+02,     8.889589986299666e+02,     8.910632378686216e+02, 
            8.931197555343268e+02,     8.951311466284060e+02,     8.970997848923408e+02,     8.990278480899917e+02,     9.009173397122411e+02, 
            9.027701077021115e+02,     9.045878606839118e+02,     9.063721820900907e+02,     9.081245425082578e+02,     9.098463105140950e+02, 
            9.115387622103301e+02,     9.132030896551623e+02,     9.148404083336333e+02,     9.164517638010764e+02,     9.180381376076610e+02, 
            9.196004525965824e+02,     9.211395776546711e+02,     9.226563319828026e+02,     9.241514889439145e+02,     9.256257795384221e+02, 
            9.270798955500201e+02,     9.285144923991741e+02,     9.299301917366834e+02,     9.313275838055866e+02,     9.327072295961020e+02, 
            9.340696628152737e+02,     9.354153916903366e+02,     9.367449006226020e+02,     9.380586517066519e+02,     9.393570861279682e+02, 
            9.406406254506320e+02,     9.419096728054398e+02,     9.431646139876386e+02,     9.444058184725335e+02,     9.456336403562985e+02, 
            9.468484192286088e+02,     9.480504809830073e+02,     9.492401385703148e+02,     9.504176926999066e+02,     9.515834324931591e+02, 
            9.527376360929823e+02,     9.538805711434509e+02,     9.550124957574319e+02,     9.561336581792717e+02,     9.572442980256468e+02, 
            9.583446463954967e+02,     9.594349263091520e+02,     9.605153531053444e+02,     9.615861348029762e+02,     9.626474724413978e+02, 
            9.636995604007252e+02,     9.647425867036067e+02,     9.657767332997262e+02,     9.668021763342308e+02,     9.678190864011825e+02, 
            9.688276287830246e+02,     9.698279636770022e+02,     9.708202464093918e+02,     9.718046276383168e+02,     9.727812535458962e+02, 
            9.737502660203947e+02,     9.747118028290000e+02,     9.756659977818032e+02,     9.766129808875388e+02,     9.775528785015576e+02, 
            9.784858134665217e+02,     9.794119052462423e+02,     9.803312700530556e+02,     9.812440209691365e+02,     9.821502680620678e+02, 
            9.830501184950128e+02,     9.839436766319313e+02,     9.848310440707133e+02,     9.857123200210193e+02,     9.865876009597467e+02, 
            9.874569810161152e+02,     9.883205519785175e+02,     9.891784033743397e+02,     9.900306225463332e+02,     9.908772942994452e+02, 
            9.917185024989664e+02,     9.925543280655512e+02,     9.933848502984561e+02,     9.942101466482453e+02,     9.950302927759077e+02, 
            9.958453626095738e+02,     9.966554283989487e+02,     9.974605607675907e+02,     9.982608287631004e+02,     9.990562999211199e+02, 
            9.998470402472274e+02,     1.000633114360547e+03,     1.001414585468936e+03,     1.002191515427616e+03,     1.002963964778867e+03, 
            1.003731992790254e+03,     1.004495657491441e+03,     1.005255015709649e+03,     1.006010123103832e+03,     1.006761034197612e+03, 
            1.007507802411046e+03,     1.008250480091249e+03,     1.008989118541958e+03,     1.009723768052041e+03,     1.010454477923035e+03, 
            1.011181296495718e+03,     1.011904271175789e+03,     1.012623448458664e+03,     1.013338873953447e+03,     1.014050592406087e+03, 
            1.014758647721778e+03,     1.015463082986616e+03,     1.016163940488548e+03,     1.016861261737636e+03,     1.017555087485673e+03, 
            1.018245457745175e+03,     1.018932411807755e+03,     1.019615988261926e+03,     1.020296225010346e+03,     1.020973159286524e+03, 
            1.021646827671007e+03,     1.022317266107072e+03,     1.022984509915934e+03,     1.023648593811507e+03,     1.024309551914698e+03, 
            1.024967417767290e+03,     1.025622224345414e+03,     1.026274004072604e+03,     1.026922788832491e+03,     1.027568609951276e+03, 
            1.028211498330939e+03,     1.028851484275986e+03,     1.029488597630063e+03,     1.030122867755033e+03,     1.030754323541624e+03, 
            1.031382993419780e+03,     1.032008905368729e+03,     1.032632086926756e+03,     1.033252565200723e+03,     1.033870366875320e+03, 
            1.034485518222060e+03,     1.035098045108044e+03,     1.035707973004471e+03,     1.036315326994938e+03,     1.036920131783509e+03, 
            1.037522411702574e+03,     1.038122190720497e+03,     1.038719492449070e+03,     1.039314340150769e+03,     1.039906756745828e+03, 
            1.040496764819118e+03,     1.041084386626867e+03,     1.041669644103198e+03,     1.042252558866502e+03,     1.042833152225658e+03, 
            1.043411445186091e+03,     1.043987458455679e+03,     1.044561212450519e+03,     1.045132727300546e+03,     1.045702022855018e+03, 
            1.046269118687865e+03,     1.046834034102912e+03,     1.047396788138966e+03,     1.047957399574802e+03,     1.048515886934003e+03, 
            1.049072268489710e+03,     1.049626562269240e+03,     1.050178786058615e+03,     1.050728957406964e+03,     1.051277093630844e+03, 
            1.051823211818443e+03,     1.052367328833698e+03,     1.052909461320313e+03,     1.053449625705694e+03,     1.053987838204776e+03, 
            1.054524114823788e+03,     1.055058471363915e+03,     1.055590923424886e+03,     1.056121486408485e+03,     1.056650175521974e+03, 
            1.057177005781453e+03,     1.057701992015138e+03,     1.058225148866568e+03,     1.058746490797752e+03,     1.059266032092231e+03, 
            1.059783786858093e+03,     1.060299769030908e+03,     1.060813992376611e+03,     1.061326470494316e+03,     1.061837216819080e+03, 
            1.062346244624599e+03,     1.062853567025852e+03,     1.063359196981697e+03,     1.063863147297394e+03,     1.064365430095479e+03, 
            1.064866058929998e+03,     1.065365045642987e+03,     1.065862402449678e+03,     1.066358141423635e+03,     1.066852274498989e+03, 
            1.067344813472634e+03,     1.067835770006385e+03,     1.068325155629084e+03,     1.068812981738661e+03,     1.069299259604173e+03, 
            1.069784000367780e+03,     1.070267215046697e+03,     1.070748914535105e+03,     1.071229109606021e+03,     1.071707810913138e+03, 
            1.072185028992620e+03,     1.072660774264881e+03,     1.073135057036304e+03,     1.073607887500951e+03,     1.074079275742225e+03, 
            1.074549231734514e+03,     1.075017765344787e+03,     1.075484886334179e+03,     1.075950604359533e+03,     1.076414928974921e+03, 
            1.076877869633126e+03,     1.077339435687116e+03,     1.077799636391473e+03,     1.078258480903799e+03,     1.078715978286111e+03, 
            1.079172137506189e+03,     1.079626967438916e+03,     1.080080476867588e+03,     1.080532674485200e+03,     1.080983568895707e+03, 
            1.081433168615275e+03,     1.081881482103856e+03,     1.082328517643800e+03,     1.082774283526652e+03,     1.083218787929375e+03, 
            1.083662038947027e+03,     1.084104044593873e+03,     1.084544812804487e+03,     1.084984351434827e+03,     1.085422668263297e+03, 
            1.085859770991789e+03,     1.086295667246704e+03,     1.086730364579966e+03,     1.087163870470002e+03,     1.087596192322724e+03, 
            1.088027337472480e+03,     1.088457313182995e+03,     1.088886126648300e+03,     1.089313784993641e+03,     1.089740295276369e+03, 
            1.090165664486823e+03,     1.090589899549198e+03,     1.091013007322392e+03,     1.091434994600846e+03,     1.091855868115365e+03, 
            1.092275634533934e+03,     1.092694300462510e+03,     1.093111872445809e+03,     1.093528356968076e+03,     1.093943760453848e+03, 
            1.094358089268700e+03,     1.094771349719978e+03,     1.095183548057530e+03,     1.095594690474408e+03,     1.096004783107582e+03, 
            1.096413832038621e+03,     1.096821843294376e+03,     1.097228822847652e+03,     1.097634776617859e+03,     1.098039710471671e+03, 
            1.098443630223656e+03,     1.098846541636910e+03,     1.099248450423673e+03,     1.099649362245943e+03,     1.100049282716071e+03, 
            1.100448217397357e+03,     1.100846171804630e+03,     1.101243151404825e+03,     1.101639161617542e+03,     1.102034207815610e+03, 
            1.102428295325631e+03,     1.102821429428522e+03,     1.103213615360045e+03,     1.103604858311337e+03,     1.103995163429418e+03, 
            1.104384535817709e+03,     1.104772980536529e+03,     1.105160502603588e+03,     1.105547106994480e+03,     1.105932798643159e+03, 
            1.106317582442411e+03,     1.106701463244323e+03,     1.107084445860745e+03,     1.107466535063737e+03,     1.107847735586021e+03, 
            1.108228052121420e+03,     1.108607489325289e+03,     1.108986051814950e+03,     1.109363744170105e+03,     1.109740570933260e+03, 
            1.110116536610132e+03,     1.110491645670050e+03,     1.110865902546361e+03,     1.111239311636820e+03,     1.111611877303974e+03, 
            1.111983603875552e+03,     1.112354495644836e+03,     1.112724556871036e+03,     1.113093791779659e+03,     1.113462204562865e+03, 
            1.113829799379830e+03,     1.114196580357095e+03,     1.114562551588917e+03,     1.114927717137606e+03,     1.115292081033869e+03, 
            1.115655647277142e+03,     1.116018419835915e+03,     1.116380402648064e+03,     1.116741599621166e+03,     1.117102014632819e+03, 
            1.117461651530951e+03,     1.117820514134130e+03,     1.118178606231867e+03,     1.118535931584917e+03,     1.118892493925574e+03, 
            1.119248296957963e+03,     1.119603344358332e+03,     1.119957639775330e+03,     1.120311186830294e+03,     1.120663989117523e+03, 
            1.121016050204554e+03,     1.121367373632431e+03,     1.121717962915972e+03,     1.122067821544033e+03,     1.122416952979768e+03, 
            1.122765360660884e+03,     1.123113047999897e+03,     1.123460018384385e+03,     1.123806275177224e+03,     1.124151821716848e+03, 
            1.124496661317478e+03,     1.124840797269365e+03,     1.125184232839022e+03,     1.125526971269464e+03,     1.125869015780425e+03, 
            1.126210369568596e+03,     1.126551035807843e+03,     1.126891017649427e+03,     1.127230318222228e+03,     1.127568940632952e+03, 
            1.127906887966353e+03,     1.128244163285437e+03,     1.128580769631674e+03,     1.128916710025198e+03,     1.129251987465018e+03, 
            1.129586604929209e+03,     1.129920565375118e+03,     1.130253871739554e+03,     1.130586526938986e+03,     1.130918533869730e+03, 
            1.131249895408141e+03,     1.131580614410795e+03,     1.131910693714679e+03,     1.132240136137370e+03,     1.132568944477215e+03, 
            1.132897121513509e+03,     1.133224670006671e+03,     1.133551592698419e+03,     1.133877892311940e+03,     1.134203571552061e+03, 
            1.134528633105412e+03,     1.134853079640603e+03,     1.135176913808377e+03,     1.135500138241776e+03,     1.135822755556301e+03, 
            1.136144768350071e+03,     1.136466179203980e+03,     1.136786990681850e+03,     1.137107205330585e+03,     1.137426825680322e+03, 
            1.137745854244580e+03,     1.138064293520412e+03,     1.138382145988543e+03,     1.138699414113524e+03,     1.139016100343867e+03, 
            1.139332207112192e+03,     1.139647736835364e+03,     1.139962691914630e+03,     1.140277074735761e+03,     1.140590887669182e+03, 
            1.140904133070106e+03,     1.141216813278670e+03,     1.141528930620063e+03,     1.141840487404656e+03,     1.142151485928127e+03, 
            1.142461928471595e+03,     1.142771817301738e+03,     1.143081154670919e+03,     1.143389942817308e+03,     1.143698183965007e+03, 
            1.144005880324164e+03,     1.144313034091097e+03,     1.144619647448404e+03,     1.144925722565088e+03,     1.145231261596666e+03, 
            1.145536266685283e+03,     1.145840739959827e+03,     1.146144683536037e+03,     1.146448099516615e+03,     1.146750989991334e+03, 
            1.147053357037146e+03,     1.147355202718290e+03,     1.147656529086392e+03,     1.147957338180577e+03,     1.148257632027569e+03, 
            1.148557412641788e+03,     1.148856682025459e+03,     1.149155442168709e+03,     1.149453695049664e+03,     1.149751442634551e+03, 
            1.150048686877789e+03,     1.150345429722093e+03,     1.150641673098561e+03,     1.150937418926774e+03,     1.151232669114886e+03, 
            1.151527425559717e+03,     1.151821690146842e+03,     1.152115464750687e+03,     1.152408751234612e+03,     1.152701551451002e+03, 
            1.152993867241354e+03,     1.153285700436368e+03,     1.153577052856025e+03,     1.153867926309675e+03,     1.154158322596127e+03, 
            1.154448243503722e+03,     1.154737690810424e+03,     1.155026666283896e+03,     1.155315171681585e+03,     1.155603208750797e+03, 
            1.155890779228783e+03,     1.156177884842808e+03,     1.156464527310241e+03,     1.156750708338620e+03,     1.157036429625734e+03, 
            1.157321692859700e+03,     1.157606499719030e+03,     1.157890851872716e+03,     1.158174750980294e+03,     1.158458198691919e+03, 
            1.158741196648439e+03,     1.159023746481465e+03,     1.159305849813441e+03,     1.159587508257710e+03,     1.159868723418592e+03, 
            1.160149496891445e+03,     1.160429830262734e+03,     1.160709725110099e+03,     1.160989183002424e+03,     1.161268205499898e+03
    },
    {
            1.865189284159769e+00,     5.665787376030943e+00,     9.559784376558788e+00,     1.355339092396800e+01,     1.765351725392258e+01, 
            2.186788673157116e+01,     2.620517411624748e+01,     3.067517547932333e+01,     3.528901910539231e+01,     4.005943014358244e+01, 
            4.500106676052531e+01,     5.013095292189313e+01,     5.546904408428708e+01,     6.103897937119450e+01,     6.686910136859498e+01, 
            7.299387002244532e+01,     7.945587450114350e+01,     8.630878466674912e+01,     9.362184178267221e+01,     1.014870011383432e+02, 
            1.100309389766727e+02,     1.194367254747954e+02,     1.299868766204913e+02,     1.421614846542864e+02,     8.462895329859729e+02, 
            8.497740767766529e+02,     8.530964419245089e+02,     8.562744420543406e+02,     8.593229171795664e+02,     8.622543815892600e+02, 
            8.650795007854769e+02,     8.678074497227531e+02,     8.704461866376354e+02,     8.730026655938792e+02,     8.754830037167828e+02, 
            8.778926143830780e+02,     8.802363144613482e+02,     8.825184115160334e+02,     8.847427753589888e+02,     8.869128972426691e+02, 
            8.890319392005745e+02,     8.911027754621892e+02,     8.931280274400183e+02,     8.951100934635352e+02,     8.970511741896958e+02, 
            8.989532944316741e+02,     9.008183220019582e+02,     9.026479840524180e+02,     9.044438813045546e+02,     9.062075004923738e+02, 
            9.079402252837810e+02,     9.096433459009900e+02,     9.113180676237698e+02,     9.129655183294409e+02,     9.145867551992202e+02, 
            9.161827707003919e+02,     9.177544979372874e+02,     9.193028154502376e+02,     9.208285515302973e+02,     9.223324881078778e+02, 
            9.238153642654078e+02,     9.252778794173324e+02,     9.267206961949952e+02,     9.281444430690628e+02,     9.295497167379671e+02, 
            9.309370843072866e+02,     9.323070852818969e+02,     9.336602333901013e+02,     9.349970182566661e+02,     9.363179069397181e+02, 
            9.376233453447334e+02,     9.389137595273793e+02,     9.401895568956496e+02,     9.414511273206015e+02,     9.426988441640200e+02, 
            9.439330652304338e+02,     9.451541336501491e+02,     9.463623786992968e+02,     9.475581165622593e+02,     9.487416510413384e+02, 
            9.499132742180323e+02,     9.510732670698759e+02,     9.522218999973305e+02,     9.533594336057967e+02,     9.544861187276218e+02, 
            9.556021973662288e+02,     9.567079029113769e+02,     9.578034605938010e+02,     9.588890878766136e+02,     9.599649948213834e+02, 
            9.610313844324758e+02,     9.620884529811706e+02,     9.631363903110189e+02,     9.641753801257196e+02,     9.652056002607208e+02, 
            9.662272229396679e+02,     9.672404150166915e+02,     9.682453382054945e+02,     9.692421492960912e+02,     9.702310003600011e+02, 
            9.712120389446450e+02,     9.721854082576160e+02,     9.731512473414620e+02,     9.741096912395776e+02,     9.750608711537391e+02, 
            9.760049145937850e+02,     9.769419455199351e+02,     9.778720844781571e+02,     9.787954487290135e+02,     9.797121523703430e+02, 
            9.806223064541580e+02,     9.815260190980704e+02,     9.824233955924487e+02,     9.833145384298676e+02,     9.841995477010382e+02, 
            9.850785207239381e+02,     9.859515524492518e+02,     9.868187354631652e+02,     9.876801600680834e+02,     9.885359143598439e+02, 
            9.893860837796356e+02,     9.902307530699551e+02,     9.910700037699741e+02,     9.919039158519281e+02,     9.927325674211424e+02, 
            9.935560347757879e+02,     9.943743924642216e+02,     9.951877133400041e+02,     9.959960686147413e+02,     9.967995279088207e+02, 
            9.975981593164867e+02,     9.983920293859176e+02,     9.991812032668730e+02,     9.999657446839067e+02,     1.000745715996047e+03, 
            1.001521178236925e+03,     1.002292191153396e+03,     1.003058813242742e+03,     1.003821101788506e+03,     1.004579112895016e+03, 
            1.005332901520672e+03,     1.006082521510039e+03,     1.006828025624788e+03,     1.007569465573564e+03,     1.008306892040790e+03, 
            1.009040354714487e+03,     1.009769902313120e+03,     1.010495582611536e+03,     1.011217442466020e+03,     1.011935527838498e+03, 
            1.012649883819937e+03,     1.013360554652972e+03,     1.014067583753773e+03,     1.014771013733211e+03,     1.015470886417322e+03, 
            1.016167242867123e+03,     1.016860123397780e+03,     1.017549567597184e+03,     1.018235614343913e+03,     1.018918301824658e+03, 
            1.019597667551088e+03,     1.020273748376193e+03,     1.020946580510141e+03,     1.021616199535622e+03,     1.022282640422758e+03, 
            1.022945937543537e+03,     1.023606124685831e+03,     1.024263235066990e+03,     1.024917301347032e+03,     1.025568355611484e+03, 
            1.026216429505621e+03,     1.026861554060801e+03,     1.027503759832122e+03,     1.028143076877773e+03,     1.028779534770097e+03, 
            1.029413162606341e+03,     1.030043989019104e+03,     1.030672042186495e+03,     1.031297349842009e+03,     1.031919939284124e+03, 
            1.032539837385642e+03,     1.033157070602774e+03,     1.033771664983976e+03,     1.034383646178546e+03,     1.034993039445000e+03, 
            1.035599869659207e+03,     1.036204161322330e+03,     1.036805938568543e+03,     1.037405225172544e+03,     1.038002044556891e+03, 
            1.038596419799130e+03,     1.039188373638736e+03,     1.039777928483906e+03,     1.040365106418139e+03,     1.040949929206680e+03, 
            1.041532418302793e+03,     1.042112594853864e+03,     1.042690479707375e+03,     1.043266093416713e+03,     1.043839456246839e+03, 
            1.044410588179824e+03,     1.044979508920248e+03,     1.045546237900460e+03,     1.046110794285724e+03,     1.046673196979234e+03, 
            1.047233464627007e+03,     1.047791615622670e+03,     1.048347668112122e+03,     1.048901639998094e+03,     1.049453548944605e+03, 
            1.050003412381299e+03,     1.050551247507705e+03,     1.051097071297380e+03,     1.051640900501963e+03,     1.052182751655141e+03, 
            1.052722641076520e+03,     1.053260584875408e+03,     1.053796598954516e+03,     1.054330699013580e+03,     1.054862900552893e+03, 
            1.055393218876761e+03,     1.055921669096895e+03,     1.056448266135710e+03,     1.056973024729571e+03,     1.057495959431946e+03, 
            1.058017084616517e+03,     1.058536414480204e+03,     1.059053963046132e+03,     1.059569744166532e+03,     1.060083771525589e+03, 
            1.060596058642217e+03,     1.061106618872785e+03,     1.061615465413783e+03,     1.062122611304432e+03,     1.062628068892232e+03, 
            1.063131851968563e+03,     1.063633972593676e+03,     1.064134443202763e+03,     1.064633276086015e+03,     1.065130483390923e+03, 
            1.065626077124546e+03,     1.066120069155720e+03,     1.066612471217226e+03,     1.067103294907921e+03,     1.067592551694815e+03, 
            1.068080252915121e+03,     1.068566409778253e+03,     1.069051033367792e+03,     1.069534134643410e+03,     1.070015724442757e+03, 
            1.070495813483315e+03,     1.070974412364213e+03,     1.071451531568006e+03,     1.071927181462420e+03,     1.072401372302076e+03, 
            1.072874114230157e+03,     1.073345417280070e+03,     1.073815291377056e+03,     1.074283746339783e+03,     1.074750791881902e+03, 
            1.075216437613581e+03,     1.075680693043000e+03,     1.076143567577834e+03,     1.076605070526688e+03,     1.077065211100530e+03, 
            1.077523998414076e+03,     1.077981441487166e+03,     1.078437549246104e+03,     1.078892330524983e+03,     1.079345794096651e+03, 
            1.079797948554185e+03,     1.080248802493549e+03,     1.080698364392720e+03,     1.081146642643719e+03,     1.081593645553797e+03, 
            1.082039381346603e+03,     1.082483858163327e+03,     1.082927084063824e+03,     1.083369067027725e+03,     1.083809814955515e+03, 
            1.084249335669612e+03,     1.084687636915407e+03,     1.085124726362300e+03,     1.085560611604716e+03,     1.085995300163098e+03, 
            1.086428799484891e+03,     1.086861116945504e+03,     1.087292259849260e+03,     1.087722235430324e+03,     1.088151050853623e+03, 
            1.088578713215747e+03,     1.089005229545834e+03,     1.089430606806441e+03,     1.089854851894406e+03,     1.090277971641686e+03, 
            1.090699972816192e+03,     1.091120862122603e+03,     1.091540646203166e+03,     1.091959331638495e+03,     1.092376924948338e+03, 
            1.092793432592353e+03,     1.093208860970851e+03,     1.093623216425544e+03,     1.094036505240272e+03,     1.094448733641721e+03, 
            1.094859907800128e+03,     1.095270033829980e+03,     1.095679117790698e+03,     1.096087165687305e+03,     1.096494183471099e+03, 
            1.096900177040300e+03,     1.097305152240693e+03,     1.097709114866268e+03,     1.098112070659835e+03,     1.098514025313643e+03, 
            1.098914984469985e+03,     1.099314953721793e+03,     1.099713938613222e+03,     1.100111944640234e+03,     1.100508977251161e+03, 
            1.100905041847269e+03,     1.101300143783309e+03,     1.101694288368063e+03,     1.102087480864877e+03,     1.102479726492193e+03, 
            1.102871030424065e+03,     1.103261397790677e+03,     1.103650833678842e+03,     1.104039343132506e+03,     1.104426931153235e+03, 
            1.104813602700697e+03,     1.105199362693145e+03,     1.105584216007880e+03,     1.105968167481717e+03,     1.106351221911443e+03, 
            1.106733384054261e+03,     1.107114658628241e+03,     1.107495050312751e+03,     1.107874563748891e+03,     1.108253203539917e+03, 
            1.108630974251662e+03,     1.109007880412943e+03,     1.109383926515978e+03,     1.109759117016776e+03,     1.110133456335544e+03, 
            1.110506948857071e+03,     1.110879598931115e+03,     1.111251410872780e+03,     1.111622388962899e+03,     1.111992537448393e+03, 
            1.112361860542642e+03,     1.112730362425845e+03,     1.113098047245368e+03,     1.113464919116102e+03,     1.113830982120803e+03, 
            1.114196240310436e+03,     1.114560697704506e+03,     1.114924358291396e+03,     1.115287226028687e+03,     1.115649304843487e+03, 
            1.116010598632746e+03,     1.116371111263568e+03,     1.116730846573528e+03,     1.117089808370972e+03,     1.117448000435320e+03, 
            1.117805426517368e+03,     1.118162090339573e+03,     1.118517995596358e+03,     1.118873145954381e+03,     1.119227545052834e+03, 
            1.119581196503710e+03,     1.119934103892087e+03,     1.120286270776394e+03,     1.120637700688685e+03,     1.120988397134899e+03, 
            1.121338363595127e+03,     1.121687603523866e+03,     1.122036120350278e+03,     1.122383917478436e+03,     1.122730998287582e+03, 
            1.123077366132365e+03,     1.123423024343088e+03,     1.123767976225943e+03,     1.124112225063254e+03,     1.124455774113705e+03, 
            1.124798626612576e+03,     1.125140785771964e+03,     1.125482254781016e+03,     1.125823036806146e+03,     1.126163134991257e+03, 
            1.126502552457956e+03,     1.126841292305772e+03,     1.127179357612362e+03,     1.127516751433729e+03,     1.127853476804419e+03, 
            1.128189536737728e+03,     1.128524934225911e+03,     1.128859672240371e+03,     1.129193753731860e+03,     1.129527181630677e+03, 
            1.129859958846855e+03,     1.130192088270352e+03,     1.130523572771241e+03,     1.130854415199896e+03,     1.131184618387171e+03, 
            1.131514185144582e+03,     1.131843118264493e+03,     1.132171420520283e+03,     1.132499094666526e+03,     1.132826143439165e+03, 
            1.133152569555681e+03,     1.133478375715259e+03,     1.133803564598961e+03,     1.134128138869885e+03,     1.134452101173333e+03, 
            1.134775454136970e+03,     1.135098200370981e+03,     1.135420342468233e+03,     1.135741883004427e+03,     1.136062824538255e+03, 
            1.136383169611550e+03,     1.136702920749437e+03,     1.137022080460483e+03,     1.137340651236841e+03,     1.137658635554400e+03, 
            1.137976035872927e+03,     1.138292854636207e+03,     1.138609094272184e+03,     1.138924757193106e+03,     1.139239845795654e+03, 
            1.139554362461083e+03,     1.139868309555358e+03,     1.140181689429281e+03,     1.140494504418629e+03,     1.140806756844280e+03, 
            1.141118449012343e+03,     1.141429583214287e+03,     1.141740161727064e+03,     1.142050186813234e+03,     1.142359660721091e+03, 
            1.142668585684782e+03,     1.142976963924429e+03,     1.143284797646247e+03,     1.143592089042663e+03,     1.143898840292434e+03, 
            1.144205053560758e+03,     1.144510730999393e+03,     1.144815874746770e+03,     1.145120486928100e+03,     1.145424569655489e+03, 
            1.145728125028044e+03,     1.146031155131988e+03,     1.146333662040760e+03,     1.146635647815123e+03,     1.146937114503271e+03, 
            1.147238064140931e+03,     1.147538498751466e+03,     1.147838420345977e+03,     1.148137830923403e+03,     1.148436732470623e+03, 
            1.148735126962551e+03,     1.149033016362237e+03,     1.149330402620958e+03,     1.149627287678323e+03,     1.149923673462357e+03, 
            1.150219561889602e+03,     1.150514954865206e+03,     1.150809854283018e+03,     1.151104262025673e+03,     1.151398179964689e+03, 
            1.151691609960550e+03,     1.151984553862798e+03,     1.152277013510119e+03,     1.152568990730426e+03,     1.152860487340951e+03, 
            1.153151505148323e+03,     1.153442045948657e+03,     1.153732111527633e+03,     1.154021703660580e+03,     1.154310824112556e+03, 
            1.154599474638430e+03,     1.154887656982961e+03,     1.155175372880876e+03,     1.155462624056951e+03,     1.155749412226082e+03, 
            1.156035739093369e+03,     1.156321606354187e+03,     1.156607015694265e+03,     1.156891968789753e+03,     1.157176467307306e+03, 
            1.157460512904147e+03,     1.157744107228145e+03,     1.158027251917887e+03,     1.158309948602744e+03,     1.158592198902945e+03, 
            1.158874004429647e+03,     1.159155366785001e+03,     1.159436287562220e+03,     1.159716768345649e+03,     1.159996810710832e+03
    },
    {
            1.861182169762975e+00,     5.653137228088464e+00,     9.537578179587952e+00,     1.352059880029833e+01,     1.760897230409750e+01, 
            2.181026037509362e+01,     2.613294566742072e+01,     3.058659425479782e+01,     3.518205673856845e+01,     3.993171988437515e+01, 
            4.484982522126599e+01,     4.995287775345833e+01,     5.526017803279712e+01,     6.079452638839640e+01,     6.658317270442758e+01, 
            7.265912524912449e+01,     7.906299981642340e+01,     8.584570966235530e+01,     9.307251680509377e+01,     1.008293954589675e+02, 
            1.092335608366486e+02,     1.184520832169951e+02,     1.287378193632776e+02,     1.405078932616931e+02,     8.402637396058457e+02, 
            8.439587333867094e+02,     8.474689838739471e+02,     8.508161152538974e+02,     8.540179256544421e+02,     8.570892678448105e+02, 
            8.600426849870934e+02,     8.628888802140062e+02,     8.656370703613898e+02,     8.682952570315456e+02,     8.708704374525921e+02, 
            8.733687707059306e+02,     8.757957103394664e+02,     8.781561113049288e+02,     8.804543170324578e+02,     8.826942309619850e+02, 
            8.848793757837104e+02,     8.870129428660440e+02,     8.890978337804415e+02,     8.911366954092078e+02,     8.931319498036058e+02, 
            8.950858197172089e+02,     8.970003505532546e+02,     8.988774293204580e+02,     9.007188010789632e+02,     9.025260832693315e+02, 
            9.043007782469241e+02,     9.060442842878153e+02,     9.077579052870183e+02,     9.094428593332254e+02,     9.111002863144445e+02, 
            9.127312546845101e+02,     9.143367675004301e+02,     9.159177678238989e+02,     9.174751435665961e+02,     9.190097318473870e+02, 
            9.205223229199094e+02,     9.220136637209918e+02,     9.234844610834790e+02,     9.249353846512754e+02,     9.263670695295109e+02, 
            9.277801186985041e+02,     9.291751052166537e+02,     9.305525742342514e+02,     9.319130448376109e+02,     9.332570117405572e+02, 
            9.345849468383744e+02,     9.358973006375855e+02,     9.371945035733842e+02,     9.384769672253129e+02,     9.397450854405447e+02, 
            9.409992353731950e+02,     9.422397784471559e+02,     9.434670612491940e+02,     9.446814163583468e+02,     9.458831631170779e+02, 
            9.470726083490574e+02,     9.482500470280203e+02,     9.494157627844307e+02,     9.505700290525748e+02,     9.517131085513403e+02, 
            9.528452547487703e+02,     9.539667119703666e+02,     9.550777158548730e+02,     9.561784937956045e+02,     9.572692653344466e+02, 
            9.583502425321277e+02,     9.594216303164851e+02,     9.604836268102911e+02,     9.615364236400840e+02,     9.625802062273228e+02, 
            9.636151540630763e+02,     9.646414409673749e+02,     9.656592353342520e+02,     9.666687003634082e+02,     9.676699942794040e+02, 
            9.686632705391626e+02,     9.696486780285487e+02,     9.706263612487022e+02,     9.715964604927830e+02,     9.725591120137076e+02, 
            9.735144481834401e+02,     9.744625976443377e+02,     9.754036854530468e+02,     9.763378332173601e+02,     9.772651592264895e+02, 
            9.781857785750977e+02,     9.790998032814741e+02,     9.800073424003875e+02,     9.809085021323799e+02,     9.818033858480186e+02, 
            9.826920945028994e+02,     9.835747262411830e+02,     9.844513768204002e+02,     9.853221396104220e+02,     9.861871056750412e+02, 
            9.870463634015761e+02,     9.879000001850635e+02,     9.887481003152458e+02,     9.895907463735612e+02,     9.904280189937185e+02, 
            9.912599969246695e+02,     9.920867570909987e+02,     9.929083746508541e+02,     9.937249230515512e+02,     9.945364740829598e+02, 
            9.953430979287721e+02,     9.961448632157663e+02,     9.969418370764242e+02,     9.977340851319394e+02,     9.985216716320206e+02, 
            9.993046594313831e+02,     1.000083110047119e+03,     1.000857083697727e+03,     1.001626639340677e+03,     1.002391834708618e+03, 
            1.003152726344249e+03,     1.003909369633942e+03,     1.004661818840157e+03,     1.005410127132694e+03,     1.006154346618859e+03, 
            1.006894528372557e+03,     1.007630722462388e+03,     1.008362977978758e+03,     1.009091343060075e+03,     1.009815864918051e+03, 
            1.010536589862145e+03,     1.011253563323192e+03,     1.011966829876248e+03,     1.012676433262676e+03,     1.013382416411515e+03, 
            1.014084821460140e+03,     1.014783689774276e+03,     1.015479061967347e+03,     1.016170977919226e+03,     1.016859476794383e+03, 
            1.017544597059464e+03,     1.018226376500323e+03,     1.018904852238525e+03,     1.019580060747341e+03,     1.020252037867254e+03, 
            1.020920818820993e+03,     1.021586438228118e+03,     1.022248930119160e+03,     1.022908327949343e+03,     1.023564664581867e+03, 
            1.024217972422922e+03,     1.024868283248059e+03,     1.025515628340615e+03,     1.026160038471425e+03,     1.026801543910318e+03, 
            1.027440174437278e+03,     1.028075959353296e+03,     1.028708927490918e+03,     1.029339107224486e+03,     1.029966526480106e+03, 
            1.030591212745342e+03,     1.031213193078633e+03,     1.031832494118459e+03,     1.032449142092264e+03,     1.033063162825126e+03, 
            1.033674581748204e+03,     1.034283423906958e+03,     1.034889713969150e+03,     1.035493476232629e+03,     1.036094734632926e+03, 
            1.036693512750637e+03,     1.037289833818618e+03,     1.037883720729004e+03,     1.038475196040036e+03,     1.039064281982720e+03, 
            1.039651000467316e+03,     1.040235373089668e+03,     1.040817421137365e+03,     1.041397165595763e+03,     1.041974627153842e+03, 
            1.042549826209930e+03,     1.043122782877287e+03,     1.043693516989542e+03,     1.044262048106009e+03,     1.044828395516872e+03, 
            1.045392578248239e+03,     1.045954615067089e+03,     1.046514524486085e+03,     1.047072324768289e+03,     1.047628033931753e+03, 
            1.048181669754010e+03,     1.048733249776462e+03,     1.049282791308657e+03,     1.049830311432482e+03,     1.050375827006243e+03, 
            1.050919354668669e+03,     1.051460910842811e+03,     1.052000511739858e+03,     1.052538173362875e+03,     1.053073911510442e+03, 
            1.053607741780230e+03,     1.054139679572475e+03,     1.054669740093405e+03,     1.055197938358560e+03,     1.055724289196066e+03, 
            1.056248807249826e+03,     1.056771506982633e+03,     1.057292402679241e+03,     1.057811508449343e+03,     1.058328838230504e+03, 
            1.058844405791025e+03,     1.059358224732744e+03,     1.059870308493785e+03,     1.060380669824006e+03,     1.060889322881620e+03, 
            1.061396280117006e+03,     1.061901554339746e+03,     1.062405158208605e+03,     1.062907104233939e+03,     1.063407404780082e+03, 
            1.063906072067654e+03,     1.064403118175853e+03,     1.064898555044673e+03,     1.065392394477103e+03,     1.065884648141260e+03, 
            1.066375327572496e+03,     1.066864444175449e+03,     1.067352009226075e+03,     1.067838033873612e+03,     1.068322529142531e+03, 
            1.068805505934434e+03,     1.069286975029918e+03,     1.069766947090412e+03,     1.070245432659963e+03,     1.070722442167004e+03, 
            1.071197985926075e+03,     1.071672074139525e+03,     1.072144716899161e+03,     1.072615924187896e+03,     1.073085705881336e+03, 
            1.073554071749359e+03,     1.074021031457651e+03,     1.074486594569222e+03,     1.074950770545891e+03,     1.075413568749742e+03, 
            1.075874998444562e+03,     1.076335068827326e+03,     1.076793788908092e+03,     1.077251167695334e+03,     1.077707214073428e+03, 
            1.078161936835223e+03,     1.078615344683327e+03,     1.079067446231368e+03,     1.079518250005231e+03,     1.079967764444275e+03, 
            1.080415997902529e+03,     1.080862958649862e+03,     1.081308654873144e+03,     1.081753094677370e+03,     1.082196286086784e+03, 
            1.082638237045967e+03,     1.083078955420913e+03,     1.083518449000091e+03,     1.083956725495482e+03,     1.084393792543598e+03, 
            1.084829657706493e+03,     1.085264328472743e+03,     1.085697812258423e+03,     1.086130116408060e+03,     1.086561248195569e+03, 
            1.086991214825180e+03,     1.087420023432346e+03,     1.087847681084632e+03,     1.088274194782595e+03,     1.088699571460651e+03, 
            1.089123817987920e+03,     1.089546941169065e+03,     1.089968947745113e+03,     1.090389844394264e+03,     1.090809637732688e+03, 
            1.091228334315307e+03,     1.091645940636568e+03,     1.092062463131197e+03,     1.092477908174951e+03,     1.092892282085348e+03, 
            1.093305591122391e+03,     1.093717841489283e+03,     1.094129039333123e+03,     1.094539190745598e+03,     1.094948301763660e+03, 
            1.095356378370195e+03,     1.095763426494686e+03,     1.096169452013849e+03,     1.096574460752283e+03,     1.096978458483092e+03, 
            1.097381450928504e+03,     1.097783443760479e+03,     1.098184442601314e+03,     1.098584453024228e+03,     1.098983480553945e+03, 
            1.099381530667273e+03,     1.099778608793659e+03,     1.100174720315752e+03,     1.100569870569949e+03,     1.100964064846936e+03, 
            1.101357308392215e+03,     1.101749606406636e+03,     1.102140964046907e+03,     1.102531386426102e+03,     1.102920878614170e+03, 
            1.103309445638419e+03,     1.103697092484010e+03,     1.104083824094436e+03,     1.104469645371991e+03,     1.104854561178240e+03, 
            1.105238576334475e+03,     1.105621695622173e+03,     1.106003923783436e+03,     1.106385265521439e+03,     1.106765725500855e+03, 
            1.107145308348288e+03,     1.107524018652696e+03,     1.107901860965802e+03,     1.108278839802510e+03,     1.108654959641302e+03, 
            1.109030224924642e+03,     1.109404640059371e+03,     1.109778209417087e+03,     1.110150937334536e+03,     1.110522828113982e+03, 
            1.110893886023584e+03,     1.111264115297762e+03,     1.111633520137555e+03,     1.112002104710983e+03,     1.112369873153396e+03, 
            1.112736829567826e+03,     1.113102978025323e+03,     1.113468322565297e+03,     1.113832867195851e+03,     1.114196615894113e+03, 
            1.114559572606555e+03,     1.114921741249318e+03,     1.115283125708527e+03,     1.115643729840603e+03,     1.116003557472572e+03, 
            1.116362612402365e+03,     1.116720898399125e+03,     1.117078419203495e+03,     1.117435178527917e+03,     1.117791180056918e+03, 
            1.118146427447392e+03,     1.118500924328885e+03,     1.118854674303871e+03,     1.119207680948026e+03,     1.119559947810493e+03, 
            1.119911478414163e+03,     1.120262276255922e+03,     1.120612344806922e+03,     1.120961687512834e+03,     1.121310307794100e+03, 
            1.121658209046189e+03,     1.122005394639838e+03,     1.122351867921301e+03,     1.122697632212587e+03,     1.123042690811699e+03, 
            1.123387046992872e+03,     1.123730704006800e+03,     1.124073665080869e+03,     1.124415933419384e+03,     1.124757512203791e+03, 
            1.125098404592897e+03,     1.125438613723094e+03,     1.125778142708567e+03,     1.126116994641511e+03,     1.126455172592345e+03, 
            1.126792679609912e+03,     1.127129518721692e+03,     1.127465692933998e+03,     1.127801205232184e+03,     1.128136058580838e+03, 
            1.128470255923977e+03,     1.128803800185245e+03,     1.129136694268101e+03,     1.129468941056008e+03,     1.129800543412621e+03, 
            1.130131504181969e+03,     1.130461826188641e+03,     1.130791512237961e+03,     1.131120565116173e+03,     1.131448987590607e+03, 
            1.131776782409866e+03,     1.132103952303984e+03,     1.132430499984606e+03,     1.132756428145153e+03,     1.133081739460984e+03, 
            1.133406436589567e+03,     1.133730522170634e+03,     1.134053998826350e+03,     1.134376869161461e+03,     1.134699135763459e+03, 
            1.135020801202735e+03,     1.135341868032727e+03,     1.135662338790080e+03,     1.135982215994789e+03,     1.136301502150350e+03, 
            1.136620199743905e+03,     1.136938311246388e+03,     1.137255839112666e+03,     1.137572785781685e+03,     1.137889153676603e+03, 
            1.138204945204937e+03,     1.138520162758691e+03,     1.138834808714496e+03,     1.139148885433746e+03,     1.139462395262725e+03, 
            1.139775340532741e+03,     1.140087723560256e+03,     1.140399546647014e+03,     1.140710812080164e+03,     1.141021522132390e+03, 
            1.141331679062033e+03,     1.141641285113213e+03,     1.141950342515952e+03,     1.142258853486291e+03,     1.142566820226414e+03, 
            1.142874244924757e+03,     1.143181129756135e+03,     1.143487476881846e+03,     1.143793288449793e+03,     1.144098566594591e+03, 
            1.144403313437683e+03,     1.144707531087446e+03,     1.145011221639301e+03,     1.145314387175823e+03,     1.145617029766845e+03, 
            1.145919151469566e+03,     1.146220754328653e+03,     1.146521840376344e+03,     1.146822411632554e+03,     1.147122470104975e+03, 
            1.147422017789170e+03,     1.147721056668684e+03,     1.148019588715130e+03,     1.148317615888293e+03,     1.148615140136226e+03, 
            1.148912163395343e+03,     1.149208687590512e+03,     1.149504714635153e+03,     1.149800246431324e+03,     1.150095284869818e+03, 
            1.150389831830251e+03,     1.150683889181150e+03,     1.150977458780042e+03,     1.151270542473546e+03,     1.151563142097453e+03, 
            1.151855259476817e+03,     1.152146896426038e+03,     1.152438054748945e+03,     1.152728736238883e+03,     1.153018942678793e+03, 
            1.153308675841293e+03,     1.153597937488760e+03,     1.153886729373412e+03,     1.154175053237382e+03,     1.154462910812803e+03, 
            1.154750303821881e+03,     1.155037233976974e+03,     1.155323702980668e+03,     1.155609712525851e+03,     1.155895264295792e+03, 
            1.156180359964211e+03,     1.156465001195349e+03,     1.156749189644054e+03,     1.157032926955835e+03,     1.157316214766948e+03, 
            1.157599054704457e+03,     1.157881448386311e+03,     1.158163397421405e+03,     1.158444903409658e+03,     1.158725967942074e+03
    },
    {
            1.857192590118415e+00,     5.640546903848001e+00,     9.515485374775194e+00,     1.348798739311679e+01,     1.756469225931427e+01, 
            2.175300390637260e+01,     2.606121789231278e+01,     3.049867673586707e+01,     3.507596172605103e+01,     3.980513224546877e+01, 
            4.470002782700242e+01,     4.977665428292191e+01,     5.505368439198939e+01,     6.055311762152981e+01,     6.630116532872145e+01, 
            7.232946340892914e+01,     7.867677377902965e+01,     8.539143943823109e+01,     9.253504605112911e+01,     1.001881049451169e+02, 
            1.084593159527059e+02,     1.175016284468393e+02,     1.275424379520507e+02,     1.389470664875485e+02,     8.339940349959962e+02, 
            8.379270687939553e+02,     8.416479338921841e+02,     8.451832025093590e+02,     8.485544426889577e+02,     8.517794404416327e+02, 
            8.548730620746592e+02,     8.578478789482256e+02,     8.607146303618571e+02,     8.634825731751398e+02,     8.661597503389153e+02, 
            8.687532002061965e+02,     8.712691218314892e+02,     8.737130070503382e+02,     8.760897471346923e+02,     8.784037197459542e+02, 
            8.806588604461942e+02,     8.828587219813492e+02,     8.850065237895985e+02,     8.871051936278757e+02,     8.891574027917977e+02, 
            8.911655960894030e+02,     8.931320174891582e+02,     8.950587321782884e+02,     8.969476456242012e+02,     8.988005201198735e+02, 
            9.006189892056569e+02,     9.024045702898670e+02,     9.041586757343854e+02,     9.058826226263756e+02,     9.075776414206304e+02, 
            9.092448836073357e+02,     9.108854285356196e+02,     9.125002895032263e+02,     9.140904192060486e+02,     9.156567146274729e+02, 
            9.172000214359994e+02,     9.187211379499405e+02,     9.202208187199172e+02,     9.216997777730066e+02,     9.231586915565875e+02, 
            9.245982016150042e+02,     9.260189170279511e+02,     9.274214166358430e+02,     9.288062510743907e+02,     9.301739446378771e+02, 
            9.315249969883427e+02,     9.328598847259104e+02,     9.341790628336912e+02,     9.354829660092623e+02,     9.367720098933337e+02, 
            9.380465922051106e+02,     9.393070937928022e+02,     9.405538796068710e+02,     9.417872996028157e+02,     9.430076895795888e+02, 
            9.442153719591474e+02,     9.454106565120661e+02,     9.465938410337068e+02,     9.477652119071403e+02,     9.489250450252759e+02, 
            9.500736056928129e+02,     9.512111497602951e+02,     9.523379238265618e+02,     9.534541657291209e+02,     9.545601049742520e+02, 
            9.556559631353222e+02,     9.567419542271051e+02,     9.578182850578617e+02,     9.588851555607494e+02,     9.599427591060154e+02, 
            9.609912827953342e+02,     9.620309077394845e+02,     9.630618093205236e+02,     9.640841574394848e+02,     9.650981167505570e+02, 
            9.661038468826493e+02,     9.671015026491352e+02,     9.680912342465460e+02,     9.690731874429231e+02,     9.700475037564456e+02, 
            9.710143206249807e+02,     9.719737715670632e+02,     9.729259863348724e+02,     9.738710910596458e+02,     9.748092083900061e+02, 
            9.757404576236013e+02,     9.766649548324568e+02,     9.775828129824109e+02,     9.784941420480467e+02,     9.793990491223753e+02, 
            9.802976384371607e+02,     9.811900117961610e+02,     9.820762681543781e+02,     9.829565040611139e+02,     9.838308136553702e+02, 
            9.846992887482670e+02,     9.855620183531273e+02,     9.864190907449403e+02,     9.872705908228456e+02,     9.881166018359949e+02, 
            9.889572050677128e+02,     9.897924798991052e+02,     9.906225038700597e+02,     9.914473527377675e+02,     9.922671005328895e+02, 
            9.930818196134782e+02,     9.938915807167626e+02,     9.946964530089027e+02,     9.954965041485154e+02,     9.962918002683757e+02, 
            9.970824061183559e+02,     9.978683850404868e+02,     9.986497990272094e+02,     9.994267087607740e+02,     1.000199173651198e+03, 
            1.000967251872806e+03,     1.001731000399458e+03,     1.002490475038492e+03,     1.003245730463452e+03,     1.003996820245657e+03, 
            1.004743796884644e+03,     1.005486711837551e+03,     1.006225615547475e+03,     1.006960557470854e+03,     1.007691586103908e+03, 
            1.008418749008181e+03,     1.009142092835220e+03,     1.009861663350427e+03,     1.010577505456125e+03,     1.011289663213842e+03, 
            1.011998179865893e+03,     1.012703097856232e+03,     1.013404458850644e+03,     1.014102303756289e+03,     1.014796672740619e+03, 
            1.015487605249693e+03,     1.016175140025926e+03,     1.016859315125272e+03,     1.017540167933886e+03,     1.018217735184261e+03, 
            1.018892052970878e+03,     1.019563156765382e+03,     1.020231081431290e+03,     1.020895861238272e+03,     1.021557529845957e+03, 
            1.022216120439458e+03,     1.022871665556240e+03,     1.023524197225022e+03,     1.024173746945957e+03,     1.024820345702566e+03, 
            1.025464023973331e+03,     1.026104811742966e+03,     1.026742738513360e+03,     1.027377833314213e+03,     1.028010124713383e+03, 
            1.028639640826931e+03,     1.029266409328900e+03,     1.029890457460823e+03,     1.030511812040963e+03,     1.031130499473316e+03, 
            1.031746545756357e+03,     1.032359976491565e+03,     1.032970816891706e+03,     1.033579091788910e+03,     1.034184825642524e+03, 
            1.034788042546767e+03,     1.035388766238182e+03,     1.035987020102894e+03,     1.036582827183683e+03,     1.037176210186873e+03, 
            1.037767191489051e+03,     1.038355793143609e+03,     1.038942036887124e+03,     1.039525944145581e+03,     1.040107536040432e+03, 
            1.040686833394516e+03,     1.041263856737830e+03,     1.041838626313145e+03,     1.042411162081509e+03,     1.042981483727597e+03, 
            1.043549610664935e+03,     1.044115562041012e+03,     1.044679356742249e+03,     1.045241013398867e+03,     1.045800550389632e+03, 
            1.046357985846490e+03,     1.046913337659094e+03,     1.047466623479222e+03,     1.048017860725099e+03,     1.048567066585616e+03, 
            1.049114258024451e+03,     1.049659451784098e+03,     1.050202664389800e+03,     1.050743912153406e+03,     1.051283211177124e+03, 
            1.051820577357198e+03,     1.052356026387510e+03,     1.052889573763089e+03,     1.053421234783554e+03,     1.053951024556474e+03, 
            1.054478958000656e+03,     1.055005049849365e+03,     1.055529314653473e+03,     1.056051766784536e+03,     1.056572420437809e+03, 
            1.057091289635202e+03,     1.057608388228154e+03,     1.058123729900474e+03,     1.058637327639111e+03,     1.059149195849620e+03, 
            1.059659347212249e+03,     1.060167794767356e+03,     1.060674551400932e+03,     1.061179629847093e+03,     1.061683042690518e+03, 
            1.062184802368844e+03,     1.062684921175002e+03,     1.063183411259515e+03,     1.063680284632748e+03,     1.064175553167111e+03, 
            1.064669228599214e+03,     1.065161322531989e+03,     1.065651846436764e+03,     1.066140811655296e+03,     1.066628229401765e+03, 
            1.067114110764727e+03,     1.067598466709037e+03,     1.068081308077724e+03,     1.068562645593837e+03,     1.069042489862252e+03, 
            1.069520851371449e+03,     1.069997740495247e+03,     1.070473167494516e+03,     1.070947142518850e+03,     1.071419675608209e+03, 
            1.071890776694534e+03,     1.072360455603329e+03,     1.072828722055211e+03,     1.073295585667439e+03,     1.073761055984738e+03, 
            1.074225142362339e+03,     1.074687854146773e+03,     1.075149200556548e+03,     1.075609190714026e+03,     1.076067833646786e+03, 
            1.076525138288964e+03,     1.076981113482575e+03,     1.077435767978796e+03,     1.077889110439245e+03,     1.078341149437225e+03, 
            1.078791893458944e+03,     1.079241350904731e+03,     1.079689530090206e+03,     1.080136439247450e+03,     1.080582086526142e+03, 
            1.081026479994687e+03,     1.081469627641314e+03,     1.081911537375159e+03,     1.082352217027330e+03,     1.082791674351964e+03, 
            1.083229917027241e+03,     1.083666952656406e+03,     1.084102788768757e+03,     1.084537432820634e+03,     1.084970892196366e+03, 
            1.085403174209227e+03,     1.085834286102362e+03,     1.086264235049702e+03,     1.086693028156863e+03,     1.087120672462029e+03, 
            1.087547174936828e+03,     1.087972542487178e+03,     1.088396781954138e+03,     1.088819900114729e+03,     1.089241903682755e+03, 
            1.089662799309601e+03,     1.090082593585021e+03,     1.090501293037917e+03,     1.090918904137099e+03,     1.091335433292042e+03, 
            1.091750886853621e+03,     1.092165271114841e+03,     1.092578592311551e+03,     1.092990856623155e+03,     1.093402070173301e+03, 
            1.093812239030566e+03,     1.094221369209130e+03,     1.094629466669439e+03,     1.095036537318852e+03,     1.095442587012290e+03, 
            1.095847621552868e+03,     1.096251646692509e+03,     1.096654668132570e+03,     1.097056691524436e+03,     1.097457722470118e+03, 
            1.097857766522842e+03,     1.098256829187623e+03,     1.098654915921832e+03,     1.099052032135757e+03,     1.099448183193161e+03, 
            1.099843374411812e+03,     1.100237611064032e+03,     1.100630898377218e+03,     1.101023241534360e+03,     1.101414645674556e+03, 
            1.101805115893521e+03,     1.102194657244075e+03,     1.102583274736637e+03,     1.102970973339714e+03,     1.103357757980368e+03, 
            1.103743633544690e+03,     1.104128604878262e+03,     1.104512676786612e+03,     1.104895854035667e+03,     1.105278141352188e+03, 
            1.105659543424214e+03,     1.106040064901494e+03,     1.106419710395901e+03,     1.106798484481864e+03,     1.107176391696770e+03, 
            1.107553436541378e+03,     1.107929623480215e+03,     1.108304956941977e+03,     1.108679441319914e+03,     1.109053080972219e+03, 
            1.109425880222406e+03,     1.109797843359685e+03,     1.110168974639329e+03,     1.110539278283043e+03,     1.110908758479317e+03, 
            1.111277419383788e+03,     1.111645265119582e+03,     1.112012299777664e+03,     1.112378527417179e+03,     1.112743952065783e+03, 
            1.113108577719976e+03,     1.113472408345435e+03,     1.113835447877326e+03,     1.114197700220633e+03,     1.114559169250462e+03, 
            1.114919858812359e+03,     1.115279772722612e+03,     1.115638914768555e+03,     1.115997288708862e+03,     1.116354898273845e+03, 
            1.116711747165745e+03,     1.117067839059013e+03,     1.117423177600599e+03,     1.117777766410228e+03,     1.118131609080674e+03, 
            1.118484709178038e+03,     1.118837070242010e+03,     1.119188695786138e+03,     1.119539589298088e+03,     1.119889754239904e+03, 
            1.120239194048261e+03,     1.120587912134721e+03,     1.120935911885978e+03,     1.121283196664104e+03,     1.121629769806795e+03, 
            1.121975634627606e+03,     1.122320794416193e+03,     1.122665252438539e+03,     1.123009011937196e+03,     1.123352076131501e+03, 
            1.123694448217810e+03,     1.124036131369717e+03,     1.124377128738272e+03,     1.124717443452202e+03,     1.125057078618123e+03, 
            1.125396037320751e+03,     1.125734322623115e+03,     1.126071937566757e+03,     1.126408885171944e+03,     1.126745168437865e+03, 
            1.127080790342831e+03,     1.127415753844472e+03,     1.127750061879933e+03,     1.128083717366065e+03,     1.128416723199615e+03, 
            1.128749082257414e+03,     1.129080797396563e+03,     1.129411871454616e+03,     1.129742307249761e+03,     1.130072107580998e+03, 
            1.130401275228320e+03,     1.130729812952884e+03,     1.131057723497184e+03,     1.131385009585225e+03,     1.131711673922687e+03, 
            1.132037719197099e+03,     1.132363148077997e+03,     1.132687963217091e+03,     1.133012167248426e+03,     1.133335762788539e+03, 
            1.133658752436621e+03,     1.133981138774668e+03,     1.134302924367638e+03,     1.134624111763604e+03,     1.134944703493903e+03, 
            1.135264702073284e+03,     1.135584110000057e+03,     1.135902929756238e+03,     1.136221163807692e+03,     1.136538814604279e+03, 
            1.136855884579989e+03,     1.137172376153087e+03,     1.137488291726246e+03,     1.137803633686685e+03,     1.138118404406304e+03, 
            1.138432606241819e+03,     1.138746241534887e+03,     1.139059312612246e+03,     1.139371821785834e+03,     1.139683771352924e+03, 
            1.139995163596246e+03,     1.140306000784113e+03,     1.140616285170543e+03,     1.140926018995384e+03,     1.141235204484430e+03, 
            1.141543843849546e+03,     1.141851939288780e+03,     1.142159492986488e+03,     1.142466507113438e+03,     1.142772983826936e+03, 
            1.143078925270931e+03,     1.143384333576134e+03,     1.143689210860119e+03,     1.143993559227442e+03,     1.144297380769746e+03, 
            1.144600677565867e+03,     1.144903451681941e+03,     1.145205705171510e+03,     1.145507440075624e+03,     1.145808658422947e+03, 
            1.146109362229854e+03,     1.146409553500537e+03,     1.146709234227103e+03,     1.147008406389670e+03,     1.147307071956467e+03, 
            1.147605232883930e+03,     1.147902891116799e+03,     1.148200048588212e+03,     1.148496707219796e+03,     1.148792868921764e+03, 
            1.149088535593005e+03,     1.149383709121174e+03,     1.149678391382785e+03,     1.149972584243293e+03,     1.150266289557191e+03, 
            1.150559509168092e+03,     1.150852244908817e+03,     1.151144498601480e+03,     1.151436272057572e+03,     1.151727567078046e+03, 
            1.152018385453401e+03,     1.152308728963761e+03,     1.152598599378959e+03,     1.152887998458616e+03,     1.153176927952221e+03, 
            1.153465389599213e+03,     1.153753385129055e+03,     1.154040916261311e+03,     1.154327984705728e+03,     1.154614592162307e+03, 
            1.154900740321378e+03,     1.155186430863680e+03,     1.155471665460427e+03,     1.155756445773388e+03,     1.156040773454954e+03, 
            1.156324650148212e+03,     1.156608077487018e+03,     1.156891057096062e+03,     1.157173590590941e+03,     1.157455679578230e+03
    },
    {
            1.853220426909507e+00,     5.628015945437514e+00,     9.493504989228645e+00,     1.345555497851666e+01,     1.752067432620546e+01, 
            2.169611303115040e+01,     2.598998440834091e+01,     3.041141364679100e+01,     3.497072078786977e+01,     3.967964839476493e+01, 
            4.455164801349470e+01,     4.960224510398769e+01,     5.484951040957917e+01,     6.031467833283162e+01,     6.602297252424620e+01, 
            7.200473038609721e+01,     7.829697037573251e+01,     8.494563575371726e+01,     9.200890973806148e+01,     9.956230240296810e+01, 
            1.077068249365511e+02,     1.165829071426696e+02,     1.263959343233730e+02,     1.374681084110119e+02,     1.503605151877131e+02, 
            8.316532296436335e+02,     8.356120119366725e+02,     8.393579360841229e+02,     8.429174522009208e+02,     8.463120756669638e+02, 
            8.495595805967270e+02,     8.526748453275893e+02,     8.556704670435956e+02,     8.585572184610674e+02,     8.613443936155093e+02, 
            8.640400740151160e+02,     8.666513364853387e+02,     8.691844175796192e+02,     8.716448451398660e+02,     8.740375446701870e+02, 
            8.763669261607682e+02,     8.786369555671612e+02,     8.808512141226487e+02,     8.830129479130475e+02,     8.851251095912201e+02, 
            8.871903936962188e+02,     8.892112667306808e+02,     8.911899929126129e+02,     8.931286563347855e+02,     8.950291801229251e+02, 
            8.968933430725579e+02,     8.987227941565537e+02,     9.005190652255745e+02,     9.022835821677269e+02,     9.040176747487309e+02, 
            9.057225853174075e+02,     9.073994765315701e+02,     9.090494382350437e+02,     9.106734935964953e+02,     9.122726046041322e+02, 
            9.138476769965564e+02,     9.153995646985198e+02,     9.169290738206917e+02,     9.184369662744003e+02,     9.199239630454387e+02, 
            9.213907471652368e+02,     9.228379664126819e+02,     9.242662357756908e+02,     9.256761396979931e+02,     9.270682341334556e+02, 
            9.284430484276105e+02,     9.298010870437279e+02,     9.311428311487549e+02,     9.324687400726926e+02,     9.337792526534847e+02, 
            9.350747884781281e+02,     9.363557490295833e+02,     9.376225187480200e+02,     9.388754660140470e+02,     9.401149440607877e+02, 
            9.413412918209477e+02,     9.425548347144359e+02,     9.437558853815008e+02,     9.449447443659243e+02,     9.461217007191135e+02, 
            9.472870327611720e+02,     9.484410083055287e+02,     9.495838855105179e+02,     9.507159132017140e+02,     9.518373313615064e+02, 
            9.529483715578249e+02,     9.540492573466088e+02,     9.551402046500499e+02,     9.562214221123389e+02,     9.572931114345364e+02, 
            9.583554676900319e+02,     9.594086796219376e+02,     9.604529299236643e+02,     9.614883955038207e+02,     9.625152477364838e+02, 
            9.635336526978122e+02,     9.645437713899064e+02,     9.655457599527169e+02,     9.665397698648028e+02,     9.675259481336149e+02, 
            9.685044374759749e+02,     9.694753764893551e+02,     9.704388998145281e+02,     9.713951382900913e+02,     9.723442190993833e+02, 
            9.732862659102123e+02,     9.742213990078398e+02,     9.751497354216123e+02,     9.760713890458949e+02,     9.769864707570086e+02, 
            9.778950885218749e+02,     9.787973474164547e+02,     9.796933500753764e+02,     9.805831962487317e+02,     9.814669832620746e+02, 
            9.823448060085500e+02,     9.832167565594577e+02,     9.840829259425476e+02,     9.849434019101279e+02,     9.857982704169741e+02, 
            9.866476153673391e+02,     9.874915186819599e+02,     9.883300603622897e+02,     9.891633185520991e+02,     9.899913695965649e+02, 
            9.908142880989866e+02,     9.916321469752299e+02,     9.924450175060144e+02,     9.932529693871541e+02,     9.940560707939162e+02, 
            9.948543883616109e+02,     9.956479873313535e+02,     9.964369315238878e+02,     9.972212833986528e+02,     9.980011040935620e+02, 
            9.987764534633078e+02,     9.995473901162650e+02,     1.000313971450039e+03,     1.001076253685733e+03,     1.001834291900990e+03, 
            1.002588140061845e+03,     1.003337851053461e+03,     1.004083476709785e+03,     1.004825067842175e+03,     1.005562674267024e+03, 
            1.006296344832459e+03,     1.007026127444109e+03,     1.007752069090018e+03,     1.008474215864716e+03,     1.009192612992489e+03, 
            1.009907304849879e+03,     1.010618334987451e+03,     1.011325746150841e+03,     1.012029580301137e+03,     1.012729878634585e+03, 
            1.013426681601691e+03,     1.014120028925695e+03,     1.014809959620479e+03,     1.015496512007908e+03,     1.016179723734637e+03, 
            1.016859631788393e+03,     1.017536272513768e+03,     1.018209681627525e+03,     1.018879894233440e+03,     1.019546944806745e+03, 
            1.020210867329884e+03,     1.020871695120334e+03,     1.021529460969717e+03,     1.022184197124527e+03,     1.022835935298523e+03, 
            1.023484706684778e+03,     1.024130541967372e+03,     1.024773471332757e+03,     1.025413524480796e+03,     1.026050730635495e+03, 
            1.026685118555433e+03,     1.027316716543897e+03,     1.027945552458744e+03,     1.028571653721991e+03,     1.029195047329133e+03, 
            1.029815759858225e+03,     1.030433817478699e+03,     1.031049245959962e+03,     1.031662070679753e+03,     1.032272316632283e+03, 
            1.032880008436158e+03,     1.033485170342096e+03,     1.034087826240443e+03,     1.034687999668492e+03,     1.035285713817613e+03, 
            1.035880991540203e+03,     1.036473855356456e+03,     1.037064327460964e+03,     1.037652429729150e+03,     1.038238183723533e+03, 
            1.038821610699854e+03,     1.039402731613031e+03,     1.039981567122977e+03,     1.040558137600276e+03,     1.041132463131715e+03, 
            1.041704563525682e+03,     1.042274458317446e+03,     1.042842166774288e+03,     1.043407707900528e+03,     1.043971100442424e+03, 
            1.044532362892960e+03,     1.045091513496513e+03,     1.045648570253420e+03,     1.046203550924432e+03,     1.046756473035070e+03, 
            1.047307353879878e+03,     1.047856210526573e+03,     1.048403059820110e+03,     1.048947918386652e+03,     1.049490802637441e+03, 
            1.050031728772596e+03,     1.050570712784820e+03,     1.051107770463014e+03,     1.051642917395831e+03,     1.052176168975135e+03, 
            1.052707540399396e+03,     1.053237046676996e+03,     1.053764702629479e+03,     1.054290522894722e+03,     1.054814521930039e+03, 
            1.055336714015215e+03,     1.055857113255488e+03,     1.056375733063099e+03,     1.056892588230345e+03,     1.057407691849626e+03, 
            1.057921057356456e+03,     1.058432698025746e+03,     1.058942626974418e+03,     1.059450857163973e+03,     1.059957401402996e+03, 
            1.060462272349620e+03,     1.060965482513930e+03,     1.061467044260329e+03,     1.061966969809842e+03,     1.062465271242389e+03, 
            1.062961960499002e+03,     1.063457049383999e+03,     1.063950549567122e+03,     1.064442472585624e+03,     1.064932829846315e+03, 
            1.065421632627578e+03,     1.065908892081334e+03,     1.066394619234976e+03,     1.066878824993260e+03,     1.067361520140167e+03, 
            1.067842715340720e+03,     1.068322421142776e+03,     1.068800647978774e+03,     1.069277406167459e+03,     1.069752705915567e+03, 
            1.070226557319480e+03,     1.070698970396538e+03,     1.071169954966752e+03,     1.071639520835941e+03,     1.072107677675017e+03, 
            1.072574435052364e+03,     1.073039802435324e+03,     1.073503789191639e+03,     1.073966404590883e+03,     1.074427657805861e+03, 
            1.074887557913986e+03,     1.075346113898623e+03,     1.075803334650424e+03,     1.076259228968620e+03,     1.076713805562307e+03, 
            1.077167073051701e+03,     1.077619039969372e+03,     1.078069714761451e+03,     1.078519105788833e+03,     1.078967221328335e+03, 
            1.079414069573851e+03,     1.079859658637487e+03,     1.080303996550662e+03,     1.080747091265206e+03,     1.081188950654432e+03, 
            1.081629582514187e+03,     1.082068994563894e+03,     1.082507194447563e+03,     1.082944189734801e+03,     1.083379987921793e+03, 
            1.083814596432269e+03,     1.084248022618459e+03,     1.084680273762027e+03,     1.085111357074993e+03,     1.085541279700637e+03, 
            1.085970048714394e+03,     1.086397671124724e+03,     1.086824153873976e+03,     1.087249503839240e+03,     1.087673727833172e+03, 
            1.088096832604825e+03,     1.088518824840444e+03,     1.088939711164273e+03,     1.089359498139326e+03,     1.089778192268162e+03, 
            1.090195799993640e+03,     1.090612327699663e+03,     1.091027781711912e+03,     1.091442168298568e+03,     1.091855493671020e+03, 
            1.092267763984566e+03,     1.092678985339102e+03,     1.093089163779794e+03,     1.093498305297753e+03,     1.093906415830686e+03, 
            1.094313501263543e+03,     1.094719567429158e+03,     1.095124620108870e+03,     1.095528665033144e+03,     1.095931707882179e+03, 
            1.096333754286504e+03,     1.096734809827574e+03,     1.097134880038340e+03,     1.097533970403836e+03,     1.097932086361729e+03, 
            1.098329233302882e+03,     1.098725416571899e+03,     1.099120641467664e+03,     1.099514913243872e+03,     1.099908237109551e+03, 
            1.100300618229582e+03,     1.100692061725199e+03,     1.101082572674500e+03,     1.101472156112930e+03,     1.101860817033774e+03, 
            1.102248560388634e+03,     1.102635391087903e+03,     1.103021314001227e+03,     1.103406333957964e+03,     1.103790455747644e+03, 
            1.104173684120404e+03,     1.104556023787436e+03,     1.104937479421414e+03,     1.105318055656928e+03,     1.105697757090898e+03, 
            1.106076588282997e+03,     1.106454553756055e+03,     1.106831657996464e+03,     1.107207905454577e+03,     1.107583300545102e+03, 
            1.107957847647488e+03,     1.108331551106306e+03,     1.108704415231629e+03,     1.109076444299399e+03,     1.109447642551801e+03, 
            1.109818014197614e+03,     1.110187563412577e+03,     1.110556294339739e+03,     1.110924211089803e+03,     1.111291317741469e+03, 
            1.111657618341777e+03,     1.112023116906433e+03,     1.112387817420142e+03,     1.112751723836935e+03,     1.113114840080485e+03, 
            1.113477170044424e+03,     1.113838717592656e+03,     1.114199486559664e+03,     1.114559480750817e+03,     1.114918703942662e+03, 
            1.115277159883228e+03,     1.115634852292316e+03,     1.115991784861785e+03,     1.116347961255836e+03,     1.116703385111297e+03, 
            1.117058060037900e+03,     1.117411989618548e+03,     1.117765177409594e+03,     1.118117626941103e+03,     1.118469341717115e+03, 
            1.118820325215908e+03,     1.119170580890253e+03,     1.119520112167668e+03,     1.119868922450668e+03,     1.120217015117012e+03, 
            1.120564393519948e+03,     1.120911060988454e+03,     1.121257020827476e+03,     1.121602276318163e+03,     1.121946830718098e+03, 
            1.122290687261531e+03,     1.122633849159601e+03,     1.122976319600565e+03,     1.123318101750011e+03,     1.123659198751087e+03, 
            1.123999613724708e+03,     1.124339349769773e+03,     1.124678409963375e+03,     1.125016797361008e+03,     1.125354514996775e+03, 
            1.125691565883584e+03,     1.126027953013361e+03,     1.126363679357235e+03,     1.126698747865743e+03,     1.127033161469016e+03, 
            1.127366923076980e+03,     1.127700035579534e+03,     1.128032501846743e+03,     1.128364324729023e+03,     1.128695507057320e+03, 
            1.129026051643291e+03,     1.129355961279485e+03,     1.129685238739513e+03,     1.130013886778231e+03,     1.130341908131901e+03, 
            1.130669305518370e+03,     1.130996081637233e+03,     1.131322239170001e+03,     1.131647780780264e+03,     1.131972709113855e+03, 
            1.132297026799008e+03,     1.132620736446516e+03,     1.132943840649895e+03,     1.133266341985528e+03,     1.133588243012826e+03, 
            1.133909546274377e+03,     1.134230254296096e+03,     1.134550369587372e+03,     1.134869894641218e+03,     1.135188831934410e+03, 
            1.135507183927635e+03,     1.135824953065632e+03,     1.136142141777329e+03,     1.136458752475985e+03,     1.136774787559325e+03, 
            1.137090249409674e+03,     1.137405140394097e+03,     1.137719462864523e+03,     1.138033219157882e+03,     1.138346411596233e+03, 
            1.138659042486890e+03,     1.138971114122554e+03,     1.139282628781433e+03,     1.139593588727366e+03,     1.139903996209952e+03, 
            1.140213853464665e+03,     1.140523162712976e+03,     1.140831926162472e+03,     1.141140146006974e+03,     1.141447824426652e+03, 
            1.141754963588142e+03,     1.142061565644658e+03,     1.142367632736103e+03,     1.142673166989186e+03,     1.142978170517525e+03, 
            1.143282645421763e+03,     1.143586593789670e+03,     1.143890017696254e+03,     1.144192919203864e+03,     1.144495300362296e+03, 
            1.144797163208896e+03,     1.145098509768663e+03,     1.145399342054348e+03,     1.145699662066556e+03,     1.145999471793849e+03, 
            1.146298773212834e+03,     1.146597568288272e+03,     1.146895858973166e+03,     1.147193647208860e+03,     1.147490934925131e+03, 
            1.147787724040285e+03,     1.148084016461247e+03,     1.148379814083654e+03,     1.148675118791943e+03,     1.148969932459443e+03, 
            1.149264256948464e+03,     1.149558094110381e+03,     1.149851445785728e+03,     1.150144313804273e+03,     1.150436699985115e+03, 
            1.150728606136762e+03,     1.151020034057211e+03,     1.151310985534041e+03,     1.151601462344486e+03,     1.151891466255517e+03, 
            1.152180999023927e+03,     1.152470062396405e+03,     1.152758658109620e+03,     1.153046787890291e+03,     1.153334453455273e+03, 
            1.153621656511627e+03,     1.153908398756699e+03,     1.154194681878193e+03,     1.154480507554245e+03,     1.154765877453499e+03, 
            1.155050793235176e+03,     1.155335256549148e+03,     1.155619269036011e+03,     1.155902832327152e+03,     1.156185948044819e+03
    },
    {
            1.849265562925494e+00,     5.615543900077792e+00,     9.471636062500014e+00,     1.342329985746355e+01,     1.747691575634263e+01, 
            2.163958353164161e+01,     2.591923895815195e+01,     3.032479591176893e+01,     3.486632095803034e+01,     3.955524998826869e+01, 
            4.440465997156527e+01,     4.942961397778386e+01,     5.464760514468097e+01,     6.007913661639419e+01,     6.574849205301891e+01, 
            7.168477926610200e+01,     7.792337542339028e+01,     8.450798035598166e+01,     9.149362307552943e+01,     9.895122499274268e+01, 
            1.069748343947464e+02,     1.156937345247456e+02,     1.252941638525101e+02,     1.360620613445103e+02,     1.484790142270883e+02, 
            8.251059303489292e+02,     8.293358774218300e+02,     8.333194416231601e+02,     8.370895146593401e+02,     8.406724277571946e+02, 
            8.440896427812054e+02,     8.473589190945029e+02,     8.504951433162149e+02,     8.535109344129315e+02,     8.564170945040606e+02, 
            8.592229509795286e+02,     8.619366203527017e+02,     8.645652146666222e+02,     8.671150050171768e+02,     8.695915525812308e+02, 
            8.719998146884730e+02,     8.743442314931381e+02,     8.766287973980037e+02,     8.788571203734700e+02,     8.810324715779150e+02, 
            8.831578271411461e+02,     8.852359035656054e+02,     8.872691878921196e+02,     8.892599635418189e+02,     8.912103325645830e+02, 
            8.931222348833305e+02,     8.949974650129373e+02,     8.968376866452240e+02,     8.986444454219443e+02,     9.004191801620296e+02, 
            9.021632327645096e+02,     9.038778569720769e+02,     9.055642261506272e+02,     9.072234402157929e+02,     9.088565318173937e+02, 
            9.104644718761622e+02,     9.120481745533070e+02,     9.136085017219208e+02,     9.151462669995715e+02,     9.166622393932898e+02, 
            9.181571466012614e+02,     9.196316780096889e+02,     9.210864874183351e+02,     9.225221955239836e+02,     9.239393921874454e+02, 
            9.253386385065708e+02,     9.267204687150768e+02,     9.280853919246216e+02,     9.294338937255679e+02,     9.307664376601200e+02, 
            9.320834665799566e+02,     9.333854038991932e+02,     9.346726547522959e+02,     9.359456070655634e+02,     9.372046325498823e+02, 
            9.384500876216789e+02,     9.396823142582571e+02,     9.409016407931250e+02,     9.421083826563510e+02,     9.433028430644721e+02, 
            9.444853136640896e+02,     9.456560751328657e+02,     9.468153977412885e+02,     9.479635418782848e+02,     9.491007585434554e+02, 
            9.502272898084822e+02,     9.513433692500106e+02,     9.524492223561238e+02,     9.535450669083515e+02,     9.546311133409532e+02, 
            9.557075650791248e+02,     9.567746188575882e+02,     9.578324650209510e+02,     9.588812878070675e+02,     9.599212656145680e+02, 
            9.609525712556135e+02,     9.619753721948571e+02,     9.629898307755150e+02,     9.639961044333813e+02,     9.649943458995659e+02, 
            9.659847033926521e+02,     9.669673208009609e+02,     9.679423378555144e+02,     9.689098902942816e+02,     9.698701100182248e+02, 
            9.708231252396486e+02,     9.717690606232986e+02,     9.727080374206494e+02,     9.736401735977834e+02,     9.745655839585547e+02, 
            9.754843802614420e+02,     9.763966713286574e+02,     9.773025630629280e+02,     9.782021589119371e+02,     9.790955594047064e+02, 
            9.799828626270988e+02,     9.808641642110122e+02,     9.817395568404304e+02,     9.826091324238964e+02,     9.834729793111583e+02, 
            9.843311841170334e+02,     9.851838313879209e+02,     9.860310036694401e+02,     9.868727815712751e+02,     9.877092438293466e+02, 
            9.885404673654704e+02,     9.893665273445912e+02,     9.901874972297459e+02,     9.910034488348394e+02,     9.918144523753444e+02, 
            9.926205765170351e+02,     9.934218884377183e+02,     9.942184538113527e+02,     9.950103369449841e+02,     9.957976007564869e+02, 
            9.965803068311217e+02,     9.973585154601985e+02,     9.981322856783067e+02,     9.989016752991940e+02,     9.996667409503501e+02, 
            1.000427538106334e+03,     1.001184121120929e+03,     1.001936543258152e+03,     1.002684856722176e+03,     1.003429112686210e+03, 
            1.004169361320382e+03,     1.004905651818663e+03,     1.005638032424880e+03,     1.006366550457840e+03,     1.007091252335617e+03, 
            1.007812183599034e+03,     1.008529388934355e+03,     1.009242912195247e+03,     1.009952796424018e+03,     1.010659083872163e+03, 
            1.011361816020264e+03,     1.012061033597237e+03,     1.012756776598985e+03,     1.013449084306450e+03,     1.014137995303110e+03, 
            1.014823547491932e+03,     1.015505778111793e+03,     1.016184723753408e+03,     1.016860420374769e+03,     1.017532903286306e+03, 
            1.018202207286605e+03,     1.018868366491649e+03,     1.019531414473854e+03,     1.020191384243437e+03,     1.020848308261298e+03, 
            1.021502218451522e+03,     1.022153146213527e+03,     1.022801122433855e+03,     1.023446177497635e+03,     1.024088341299714e+03, 
            1.024727643255479e+03,     1.025364112311370e+03,     1.025997776955111e+03,     1.026628665225640e+03,     1.027256804722786e+03, 
            1.027882222616667e+03,     1.028504945656838e+03,     1.029125000181193e+03,     1.029742412124622e+03,     1.030357207027445e+03, 
            1.030969410043613e+03,     1.031579045948701e+03,     1.032186139147686e+03,     1.032790713682520e+03,     1.033392793239517e+03, 
            1.033992401156532e+03,     1.034589560429975e+03,     1.035184293721632e+03,     1.035776623365318e+03,     1.036366571373362e+03, 
            1.036954159442930e+03,     1.037539408962188e+03,     1.038122341016311e+03,     1.038702976393350e+03,     1.039281335589948e+03, 
            1.039857438816918e+03,     1.040431306004688e+03,     1.041002956808613e+03,     1.041572410614156e+03,     1.042139686541952e+03, 
            1.042704803452744e+03,     1.043267779952208e+03,     1.043828634395659e+03,     1.044387384892654e+03,     1.044944049311480e+03, 
            1.045498645283542e+03,     1.046051190207649e+03,     1.046601701254203e+03,     1.047150195369288e+03,     1.047696689278671e+03, 
            1.048241199491711e+03,     1.048783742305177e+03,     1.049324333806983e+03,     1.049862989879844e+03,     1.050399726204837e+03, 
            1.050934558264905e+03,     1.051467501348262e+03,     1.051998570551738e+03,     1.052527780784044e+03,     1.053055146768971e+03, 
            1.053580683048518e+03,     1.054104403985949e+03,     1.054626323243320e+03,     1.055146455870875e+03,     1.055664815203110e+03, 
            1.056181414917685e+03,     1.056696268527885e+03,     1.057209389385311e+03,     1.057720790682520e+03,     1.058230485455601e+03, 
            1.058738486586710e+03,     1.059244806806544e+03,     1.059749458696769e+03,     1.060252454692396e+03,     1.060753807084114e+03, 
            1.061253528020566e+03,     1.061751629510590e+03,     1.062248123425413e+03,     1.062743021500794e+03,     1.063236335339131e+03, 
            1.063728076411530e+03,     1.064218256059821e+03,     1.064706885498550e+03,     1.065193975816918e+03,     1.065679537980696e+03, 
            1.066163582834087e+03,     1.066646121101569e+03,     1.067127163389691e+03,     1.067606720188840e+03,     1.068084801903845e+03, 
            1.068561418739075e+03,     1.069036580876722e+03,     1.069510298359518e+03,     1.069982581122376e+03,     1.070453438993958e+03, 
            1.070922881698234e+03,     1.071390918855985e+03,     1.071857559986306e+03,     1.072322814508060e+03,     1.072786691741319e+03, 
            1.073249200908773e+03,     1.073710351137113e+03,     1.074170151458393e+03,     1.074628610811363e+03,     1.075085738042781e+03, 
            1.075541541908704e+03,     1.075996031075748e+03,     1.076449214122330e+03,     1.076901099539899e+03,     1.077351695734123e+03, 
            1.077801011026076e+03,     1.078249053653391e+03,     1.078695831771402e+03,     1.079141353454257e+03,     1.079585626696022e+03, 
            1.080028659411761e+03,     1.080470459438592e+03,     1.080911034536737e+03,     1.081350392390545e+03,     1.081788540609503e+03, 
            1.082225486729221e+03,     1.082661238212415e+03,     1.083095802449863e+03,     1.083529186761343e+03,     1.083961398396568e+03, 
            1.084392444536091e+03,     1.084822332292205e+03,     1.085251068709827e+03,     1.085678660767359e+03,     1.086105115377546e+03, 
            1.086530439388316e+03,     1.086954639583604e+03,     1.087377722684166e+03,     1.087799695348377e+03,     1.088220564173019e+03, 
            1.088640335694053e+03,     1.089059016387387e+03,     1.089476612669615e+03,     1.089893130898766e+03,     1.090308577375024e+03, 
            1.090722958341443e+03,     1.091136279984654e+03,     1.091548548435556e+03,     1.091959769769995e+03,     1.092369950009440e+03, 
            1.092779095121643e+03,     1.093187211021288e+03,     1.093594303570632e+03,     1.094000378580137e+03,     1.094405441809094e+03, 
            1.094809498966229e+03,     1.095212555710311e+03,     1.095614617650744e+03,     1.096015690348151e+03,     1.096415779314951e+03, 
            1.096814890015924e+03,     1.097213027868774e+03,     1.097610198244679e+03,     1.098006406468828e+03,     1.098401657820961e+03, 
            1.098795957535895e+03,     1.099189310804040e+03,     1.099581722771915e+03,     1.099973198542645e+03,     1.100363743176466e+03, 
            1.100753361691205e+03,     1.101142059062773e+03,     1.101529840225629e+03,     1.101916710073258e+03,     1.102302673458625e+03, 
            1.102687735194639e+03,     1.103071900054593e+03,     1.103455172772612e+03,     1.103837558044086e+03,     1.104219060526104e+03, 
            1.104599684837873e+03,     1.104979435561139e+03,     1.105358317240599e+03,     1.105736334384309e+03,     1.106113491464079e+03, 
            1.106489792915876e+03,     1.106865243140208e+03,     1.107239846502510e+03,     1.107613607333526e+03,     1.107986529929680e+03, 
            1.108358618553445e+03,     1.108729877433707e+03,     1.109100310766126e+03,     1.109469922713488e+03,     1.109838717406056e+03, 
            1.110206698941911e+03,     1.110573871387298e+03,     1.110940238776956e+03,     1.111305805114452e+03,     1.111670574372506e+03, 
            1.112034550493316e+03,     1.112397737388871e+03,     1.112760138941271e+03,     1.113121759003033e+03,     1.113482601397396e+03, 
            1.113842669918625e+03,     1.114201968332310e+03,     1.114560500375652e+03,     1.114918269757763e+03,     1.115275280159950e+03, 
            1.115631535235990e+03,     1.115987038612419e+03,     1.116341793888801e+03,     1.116695804638004e+03,     1.117049074406465e+03, 
            1.117401606714456e+03,     1.117753405056348e+03,     1.118104472900867e+03,     1.118454813691347e+03,     1.118804430845989e+03, 
            1.119153327758103e+03,     1.119501507796354e+03,     1.119848974305012e+03,     1.120195730604179e+03,     1.120541779990039e+03, 
            1.120887125735081e+03,     1.121231771088337e+03,     1.121575719275604e+03,     1.121918973499676e+03,     1.122261536940557e+03, 
            1.122603412755692e+03,     1.122944604080174e+03,     1.123285114026966e+03,     1.123624945687104e+03,     1.123964102129918e+03, 
            1.124302586403227e+03,     1.124640401533549e+03,     1.124977550526304e+03,     1.125314036366011e+03,     1.125649862016483e+03, 
            1.125985030421027e+03,     1.126319544502629e+03,     1.126653407164153e+03,     1.126986621288519e+03,     1.127319189738899e+03, 
            1.127651115358889e+03,     1.127982400972701e+03,     1.128313049385333e+03,     1.128643063382752e+03,     1.128972445732069e+03, 
            1.129301199181706e+03,     1.129629326461576e+03,     1.129956830283240e+03,     1.130283713340088e+03,     1.130609978307491e+03, 
            1.130935627842976e+03,     1.131260664586376e+03,     1.131585091159997e+03,     1.131908910168775e+03,     1.132232124200428e+03, 
            1.132554735825614e+03,     1.132876747598082e+03,     1.133198162054821e+03,     1.133518981716211e+03,     1.133839209086173e+03, 
            1.134158846652306e+03,     1.134477896886038e+03,     1.134796362242770e+03,     1.135114245162011e+03,     1.135431548067519e+03, 
            1.135748273367440e+03,     1.136064423454445e+03,     1.136380000705862e+03,     1.136695007483813e+03,     1.137009446135338e+03, 
            1.137323318992537e+03,     1.137636628372688e+03,     1.137949376578381e+03,     1.138261565897643e+03,     1.138573198604059e+03, 
            1.138884276956900e+03,     1.139194803201242e+03,     1.139504779568091e+03,     1.139814208274496e+03,     1.140123091523672e+03, 
            1.140431431505117e+03,     1.140739230394722e+03,     1.141046490354894e+03,     1.141353213534662e+03,     1.141659402069793e+03, 
            1.141965058082901e+03,     1.142270183683559e+03,     1.142574780968401e+03,     1.142878852021239e+03,     1.143182398913163e+03, 
            1.143485423702646e+03,     1.143787928435652e+03,     1.144089915145732e+03,     1.144391385854136e+03,     1.144692342569904e+03, 
            1.144992787289971e+03,     1.145292721999266e+03,     1.145592148670805e+03,     1.145891069265795e+03,     1.146189485733724e+03, 
            1.146487400012456e+03,     1.146784814028330e+03,     1.147081729696245e+03,     1.147378148919760e+03,     1.147674073591178e+03, 
            1.147969505591642e+03,     1.148264446791217e+03,     1.148558899048987e+03,     1.148852864213136e+03,     1.149146344121035e+03, 
            1.149439340599331e+03,     1.149731855464026e+03,     1.150023890520570e+03,     1.150315447563934e+03,     1.150606528378699e+03, 
            1.150897134739133e+03,     1.151187268409278e+03,     1.151476931143022e+03,     1.151766124684182e+03,     1.152054850766584e+03, 
            1.152343111114136e+03,     1.152630907440910e+03,     1.152918241451213e+03,     1.153205114839665e+03,     1.153491529291275e+03, 
            1.153777486481509e+03,     1.154062988076369e+03,     1.154348035732464e+03,     1.154632631097078e+03,     1.154916775808248e+03
    },
    {
            1.845327882047904e+00,     5.603130320005606e+00,     9.449877646366621e+00,     1.339122035504249e+01,     1.743341384524329e+01, 
            2.158341126466350e+01,     2.584897540625305e+01,     3.023881464903934e+01,     3.476274957437132e+01,     3.943191915283804e+01, 
            4.425903861789450e+01,     4.925872578338027e+01,     5.444791938348150e+01,     5.984642325291551e+01,     6.547762590214721e+01, 
            7.136946988133005e+01,     7.755578573386923e+01,     8.407817338908241e+01,     9.098873313254612e+01,     9.835416750642014e+01, 
            1.062622015116460e+02,     1.148321556107549e+02,     1.242335171427939e+02,     1.347214524388365e+02,     1.467132245818825e+02, 
            1.609848582939076e+02,     8.227889601517712e+02,     8.270429308063132e+02,     8.310501934440908e+02,     8.348434114404077e+02, 
            8.384487944452037e+02,     8.418877458506468e+02,     8.451780044803595e+02,     8.483344593419538e+02,     8.513697455427714e+02, 
            8.542946893761336e+02,     8.571186468274316e+02,     8.598497651299184e+02,     8.624951877090004e+02,     8.650612167819204e+02, 
            8.675534438134167e+02,     8.699768552456452e+02,     8.723359189799244e+02,     8.746346557108645e+02,     8.768766982211256e+02, 
            8.790653410197874e+02,     8.812035821705003e+02,     8.832941587535062e+02,     8.853395771011568e+02,     8.873421387137715e+02, 
            8.893039625829690e+02,     8.912270045097035e+02,     8.931130738944767e+02,     8.949638483903267e+02,     8.967808867400920e+02, 
            8.985656400640150e+02,     9.003194618190344e+02,     9.020436166148219e+02,     9.037392880420590e+02,     9.054075856440950e+02, 
            9.070495511431687e+02,     9.086661640157411e+02,     9.102583464977363e+02,     9.118269680888783e+02,     9.133728496157141e+02, 
            9.148967669046904e+02,     9.163994541097942e+02,     9.178816067333995e+02,     9.193438843739686e+02,     9.207869132300161e+02, 
            9.222112883860780e+02,     9.236175759032893e+02,     9.250063147344734e+02,     9.263780184813025e+02,     9.277331770090537e+02, 
            9.290722579327244e+02,     9.303957079867353e+02,     9.317039542891079e+02,     9.329974055098058e+02,     9.342764529519327e+02, 
            9.355414715535350e+02,     9.367928208169864e+02,     9.380308456721943e+02,     9.392558772792798e+02,     9.404682337757877e+02, 
            9.416682209730172e+02,     9.428561330056253e+02,     9.440322529382348e+02,     9.451968533324721e+02,     9.463501967775154e+02, 
            9.474925363869595e+02,     9.486241162645698e+02,     9.497451719412504e+02,     9.508559307853584e+02,     9.519566123883163e+02, 
            9.530474289272995e+02,     9.541285855066376e+02,     9.552002804794222e+02,     9.562627057507086e+02,     9.573160470635539e+02, 
            9.583604842690828e+02,     9.593961915816278e+02,     9.604233378199560e+02,     9.614420866354671e+02,     9.624525967282389e+02, 
            9.634550220516668e+02,     9.644495120064421e+02,     9.654362116245260e+02,     9.664152617437448e+02,     9.673867991735738e+02, 
            9.683509568526503e+02,     9.693078639985154e+02,     9.702576462500275e+02,     9.712004258029089e+02,     9.721363215392523e+02, 
            9.730654491523976e+02,     9.739879212627934e+02,     9.749038475290482e+02,     9.758133346628010e+02,     9.767164869064692e+02, 
            9.776134055514696e+02,     9.785041894276229e+02,     9.793889343905339e+02,     9.802677352030919e+02,     9.811406831723684e+02, 
            9.820078677165843e+02,     9.828693760968631e+02,     9.837252934884729e+02,     9.845757030490773e+02,     9.854206859841679e+02, 
            9.862603216098036e+02,     9.870946874128003e+02,     9.879238591084933e+02,     9.887479106961861e+02,     9.895669145124015e+02, 
            9.903809412820401e+02,     9.911900601675495e+02,     9.919943388313129e+02,     9.927938434191705e+02,     9.935886386992845e+02, 
            9.943787880391957e+02,     9.951643534630019e+02,     9.959453956903665e+02,     9.967219741740763e+02,     9.974941471362376e+02, 
            9.982619716031562e+02,     9.990255034389679e+02,     9.997847973780658e+02,     1.000539907056380e+03,     1.001290885041567e+03, 
            1.002037782862134e+03,     1.002780651035563e+03,     1.003519539095477e+03,     1.004254495617861e+03,     1.004985568246420e+03, 
            1.005712803717060e+03,     1.006436247881578e+03,     1.007155945730550e+03,     1.007871941415474e+03,     1.008584278270192e+03, 
            1.009292998831614e+03,     1.009998144859779e+03,     1.010699757357271e+03,     1.011397876588026e+03,     1.012092542095539e+03, 
            1.012783792720505e+03,     1.013471666617914e+03,     1.014156201273611e+03,     1.014837433520360e+03,     1.015515399523803e+03, 
            1.016190134917911e+03,     1.016861674636052e+03,     1.017530053049716e+03,     1.018195303950600e+03,     1.018857460563992e+03, 
            1.019516555561758e+03,     1.020172621074951e+03,     1.020825688706050e+03,     1.021475789540857e+03,     1.022122954160046e+03, 
            1.022767212650388e+03,     1.023408594615657e+03,     1.024047129187239e+03,     1.024682845034430e+03,     1.025315770374460e+03, 
            1.025945932982241e+03,     1.026573360199840e+03,     1.027198078945702e+03,     1.027820115723628e+03,     1.028439496631491e+03, 
            1.029056247369748e+03,     1.029670393249696e+03,     1.030281959201539e+03,     1.030890969782218e+03,     1.031497449183051e+03, 
            1.032101421237175e+03,     1.032702909426782e+03,     1.033301936890188e+03,     1.033898526428708e+03,     1.034492700513362e+03, 
            1.035084481291410e+03,     1.035673890592720e+03,     1.036260949935988e+03,     1.036845680534789e+03,     1.037428103303485e+03, 
            1.038008238862992e+03,     1.038586107546400e+03,     1.039161729404458e+03,     1.039735124210925e+03,     1.040306311467798e+03, 
            1.040875310410407e+03,     1.041442140012392e+03,     1.042006818990568e+03,     1.042569365809662e+03,     1.043129798686954e+03, 
            1.043688135596795e+03,     1.044244394275035e+03,     1.044798592223337e+03,     1.045350746713397e+03,     1.045900874791068e+03, 
            1.046448993280387e+03,     1.046995118787515e+03,     1.047539267704582e+03,     1.048081456213455e+03,     1.048621700289415e+03, 
            1.049160015704750e+03,     1.049696418032280e+03,     1.050230922648794e+03,     1.050763544738410e+03,     1.051294299295873e+03, 
            1.051823201129779e+03,     1.052350264865713e+03,     1.052875504419944e+03,     1.053398935104392e+03,     1.053920570499867e+03, 
            1.054440424530130e+03,     1.054958510950710e+03,     1.055474843351678e+03,     1.055989435160359e+03,     1.056502299643987e+03, 
            1.057013449912310e+03,     1.057522898920129e+03,     1.058030659469804e+03,     1.058536744213690e+03,     1.059041165656536e+03, 
            1.059543936157826e+03,     1.060045067934086e+03,     1.060544573061130e+03,     1.061042463476268e+03,     1.061538750980473e+03, 
            1.062033447240501e+03,     1.062526563790967e+03,     1.063018112036385e+03,     1.063508103253170e+03,     1.063996548591591e+03, 
            1.064483459077698e+03,     1.064968845644379e+03,     1.065452719015364e+03,     1.065935089885561e+03,     1.066415968802612e+03, 
            1.066895366199013e+03,     1.067373292393808e+03,     1.067849757594284e+03,     1.068324771897612e+03,     1.068798345292461e+03, 
            1.069270487660587e+03,     1.069741208778396e+03,     1.070210518318461e+03,     1.070678425851033e+03,     1.071144940845511e+03, 
            1.071610072671881e+03,     1.072073830602148e+03,     1.072536223811721e+03,     1.072997261380786e+03,     1.073456952295646e+03, 
            1.073915305450050e+03,     1.074372329646481e+03,     1.074828033597432e+03,     1.075282425926662e+03,     1.075735515170419e+03, 
            1.076187309778651e+03,     1.076637818116194e+03,     1.077087048463931e+03,     1.077535009019949e+03,     1.077981707900650e+03, 
            1.078427153141873e+03,     1.078871352699970e+03,     1.079314314452882e+03,     1.079756046201183e+03,     1.080196555669119e+03, 
            1.080635850505619e+03,     1.081073938285297e+03,     1.081510826509430e+03,     1.081946522606927e+03,     1.082381033935270e+03, 
            1.082814367781461e+03,     1.083246531362925e+03,     1.083677531828421e+03,     1.084107376258929e+03,     1.084536071668523e+03, 
            1.084963625005227e+03,     1.085390043151865e+03,     1.085815332926888e+03,     1.086239501085196e+03,     1.086662554318937e+03, 
            1.087084499258308e+03,     1.087505342472323e+03,     1.087925090469590e+03,     1.088343749699058e+03,     1.088761326550767e+03, 
            1.089177827356569e+03,     1.089593258390862e+03,     1.090007625871282e+03,     1.090420935959412e+03,     1.090833194761465e+03, 
            1.091244408328956e+03,     1.091654582659375e+03,     1.092063723696835e+03,     1.092471837332719e+03,     1.092878929406317e+03, 
            1.093285005705450e+03,     1.093690071967088e+03,     1.094094133877951e+03,     1.094497197075115e+03,     1.094899267146592e+03, 
            1.095300349631914e+03,     1.095700450022706e+03,     1.096099573763245e+03,     1.096497726251011e+03,     1.096894912837245e+03, 
            1.097291138827472e+03,     1.097686409482041e+03,     1.098080730016643e+03,     1.098474105602827e+03,     1.098866541368507e+03, 
            1.099258042398460e+03,     1.099648613734821e+03,     1.100038260377567e+03,     1.100426987284993e+03,     1.100814799374190e+03, 
            1.101201701521501e+03,     1.101587698562988e+03,     1.101972795294876e+03,     1.102356996474002e+03,     1.102740306818255e+03, 
            1.103122731007005e+03,     1.103504273681532e+03,     1.103884939445448e+03,     1.104264732865108e+03,     1.104643658470020e+03, 
            1.105021720753254e+03,     1.105398924171829e+03,     1.105775273147116e+03,     1.106150772065218e+03,     1.106525425277353e+03, 
            1.106899237100234e+03,     1.107272211816433e+03,     1.107644353674756e+03,     1.108015666890595e+03,     1.108386155646291e+03, 
            1.108755824091483e+03,     1.109124676343455e+03,     1.109492716487479e+03,     1.109859948577149e+03,     1.110226376634719e+03, 
            1.110592004651428e+03,     1.110956836587828e+03,     1.111320876374097e+03,     1.111684127910363e+03,     1.112046595067011e+03, 
            1.112408281684991e+03,     1.112769191576121e+03,     1.113129328523389e+03,     1.113488696281245e+03,     1.113847298575898e+03, 
            1.114205139105598e+03,     1.114562221540924e+03,     1.114918549525066e+03,     1.115274126674096e+03,     1.115628956577248e+03, 
            1.115983042797186e+03,     1.116336388870269e+03,     1.116688998306816e+03,     1.117040874591364e+03,     1.117392021182930e+03, 
            1.117742441515254e+03,     1.118092138997061e+03,     1.118441117012300e+03,     1.118789378920392e+03,     1.119136928056468e+03, 
            1.119483767731610e+03,     1.119829901233084e+03,     1.120175331824572e+03,     1.120520062746405e+03,     1.120864097215783e+03, 
            1.121207438427003e+03,     1.121550089551680e+03,     1.121892053738965e+03,     1.122233334115758e+03,     1.122573933786924e+03, 
            1.122913855835503e+03,     1.123253103322915e+03,     1.123591679289170e+03,     1.123929586753067e+03,     1.124266828712398e+03, 
            1.124603408144140e+03,     1.124939328004660e+03,     1.125274591229899e+03,     1.125609200735569e+03,     1.125943159417340e+03, 
            1.126276470151026e+03,     1.126609135792773e+03,     1.126941159179234e+03,     1.127272543127758e+03,     1.127603290436560e+03, 
            1.127933403884902e+03,     1.128262886233266e+03,     1.128591740223525e+03,     1.128919968579113e+03,     1.129247574005193e+03, 
            1.129574559188825e+03,     1.129900926799125e+03,     1.130226679487433e+03,     1.130551819887471e+03,     1.130876350615501e+03, 
            1.131200274270481e+03,     1.131523593434224e+03,     1.131846310671546e+03,     1.132168428530421e+03,     1.132489949542129e+03, 
            1.132810876221406e+03,     1.133131211066589e+03,     1.133450956559760e+03,     1.133770115166891e+03,     1.134088689337985e+03, 
            1.134406681507216e+03,     1.134724094093068e+03,     1.135040929498469e+03,     1.135357190110931e+03,     1.135672878302681e+03, 
            1.135987996430795e+03,     1.136302546837326e+03,     1.136616531849439e+03,     1.136929953779533e+03,     1.137242814925373e+03, 
            1.137555117570213e+03,     1.137866863982919e+03,     1.138178056418094e+03,     1.138488697116198e+03,     1.138798788303670e+03, 
            1.139108332193045e+03,     1.139417330983069e+03,     1.139725786858821e+03,     1.140033701991826e+03,     1.140341078540166e+03, 
            1.140647918648595e+03,     1.140954224448650e+03,     1.141259998058764e+03,     1.141565241584369e+03,     1.141869957118010e+03, 
            1.142174146739446e+03,     1.142477812515763e+03,     1.142780956501472e+03,     1.143083580738616e+03,     1.143385687256870e+03, 
            1.143687278073646e+03,     1.143988355194189e+03,     1.144288920611681e+03,     1.144588976307333e+03,     1.144888524250491e+03, 
            1.145187566398723e+03,     1.145486104697919e+03,     1.145784141082387e+03,     1.146081677474943e+03,     1.146378715787002e+03, 
            1.146675257918677e+03,     1.146971305758860e+03,     1.147266861185318e+03,     1.147561926064780e+03,     1.147856502253023e+03, 
            1.148150591594962e+03,     1.148444195924736e+03,     1.148737317065787e+03,     1.149029956830955e+03,     1.149322117022551e+03, 
            1.149613799432447e+03,     1.149905005842154e+03,     1.150195738022904e+03,     1.150485997735732e+03,     1.150775786731552e+03, 
            1.151065106751240e+03,     1.151353959525707e+03,     1.151642346775980e+03,     1.151930270213277e+03,     1.152217731539084e+03, 
            1.152504732445225e+03,     1.152791274613945e+03,     1.153077359717973e+03,     1.153362989420603e+03,     1.153648165375764e+03
    },
    {
            1.841407269237216e+00,     5.590774762398324e+00,     9.428228804618250e+00,     1.335931482103734e+01,     1.739016593140539e+01, 
            2.152759215982391e+01,     2.577918773575647e+01,     3.015346116519893e+01,     3.465999426883302e+01,     3.930963846969900e+01, 
            4.411475956723354e+01,     4.908954647093731e+01,     5.425040555983826e+01,     5.961647157380055e+01,     6.521028004777719e+01, 
            7.105866839274722e+01,     7.719400835295971e+01,     8.365593196187908e+01,     9.049381601314668e+01,     9.777047652349759e+01, 
            1.055678809843987e+02,     1.139964129444456e+02,     1.232108281689034e+02,     1.334399693046932e+02,     1.450483320173898e+02, 
            1.586852788273551e+02,     8.159338088897143e+02,     8.204985975089319e+02,     8.247752917346968e+02,     8.288050594691121e+02, 
            8.326203301844873e+02,     8.362471838294973e+02,     8.397069565597511e+02,     8.430173581359577e+02,     8.461932720525750e+02, 
            8.492473424128704e+02,     8.521904133110444e+02,     8.550318636853905e+02,     8.577798665120559e+02,     8.604415922155592e+02, 
            8.630233702744905e+02,     8.655308190393796e+02,     8.679689510619949e+02,     8.703422593353605e+02,     8.726547884928520e+02, 
            8.749101940394714e+02,     8.771117919744192e+02,     8.792626006347999e+02,     8.813653761933316e+02,     8.834226429419849e+02, 
            8.854367192630962e+02,     8.874097400114420e+02,     8.893436758920709e+02,     8.912403503096854e+02,     8.931014540791200e+02, 
            8.949285583177270e+02,     8.967231257853454e+02,     8.984865208929733e+02,     9.002200185651784e+02,     9.019248121117048e+02, 
            9.036020202395456e+02,     9.052526933167510e+02,     9.068778189826945e+02,     9.084783271856992e+02,     9.100550947174265e+02, 
            9.116089493037407e+02,     9.131406733035776e+02,     9.146510070604894e+02,     9.161406519456277e+02,     9.176102731259680e+02, 
            9.190605020872991e+02,     9.204919389378234e+02,     9.219051545151068e+02,     9.233006923163564e+02,     9.246790702696826e+02, 
            9.260407823619654e+02,     9.273863001371569e+02,     9.287160740773226e+02,     9.300305348773691e+02,     9.313300946232197e+02, 
            9.326151478821744e+02,     9.338860727132601e+02,     9.351432316045892e+02,     9.363869723440240e+02,     9.376176288288090e+02, 
            9.388355218192976e+02,     9.400409596413791e+02,     9.412342388417786e+02,     9.424156448000214e+02,     9.435854523004767e+02, 
            9.447439260676113e+02,     9.458913212672705e+02,     9.470278839765792e+02,     9.481538516248090e+02,     9.492694534073588e+02, 
            9.503749106748190e+02,     9.514704372989088e+02,     9.525562400169399e+02,     9.536325187563164e+02,     9.546994669404471e+02, 
            9.557572717773685e+02,     9.568061145322297e+02,     9.578461707847323e+02,     9.588776106725165e+02,     9.599005991214283e+02, 
            9.609152960634838e+02,     9.619218566433677e+02,     9.629204314141406e+02,     9.639111665228731e+02,     9.648942038868001e+02, 
            9.658696813605928e+02,     9.668377328952870e+02,     9.677984886893533e+02,     9.687520753323989e+02,     9.696986159419783e+02, 
            9.706382302953931e+02,     9.715710349540338e+02,     9.724971433801190e+02,     9.734166660493108e+02,     9.743297104639109e+02, 
            9.752363816422846e+02,     9.761367816213353e+02,     9.770310095299100e+02,     9.779191631043482e+02,     9.788013367026155e+02, 
            9.796776226424951e+02,     9.805481109920568e+02,     9.814128896446828e+02,     9.822720443909228e+02,     9.831256589873502e+02, 
            9.839738152225586e+02,     9.848165929804517e+02,     9.856540703009512e+02,     9.864863234382624e+02,     9.873134269168008e+02, 
            9.881354535849065e+02,     9.889524746664412e+02,     9.897645598103763e+02,     9.905717771537973e+02,     9.913741933049913e+02, 
            9.921718734839393e+02,     9.929648814988740e+02,     9.937532798040310e+02,     9.945371295389782e+02,     9.953164905665024e+02, 
            9.960914215091034e+02,     9.968619797841750e+02,     9.976282216379162e+02,     9.983902021780316e+02,     9.991479754052758e+02, 
            9.999015942438919e+02,     1.000651110570983e+03,     1.001396575244875e+03,     1.002138038132493e+03,     1.002875548135825e+03, 
            1.003609153217465e+03,     1.004338900425319e+03,     1.005064835916474e+03,     1.005787004980282e+03,     1.006505452060689e+03, 
            1.007220220777822e+03,     1.007931353948897e+03,     1.008638893608431e+03,     1.009342881027824e+03,     1.010043356734319e+03, 
            1.010740360529354e+03,     1.011433931506349e+03,     1.012124108067936e+03,     1.012810927942659e+03,     1.013494428171835e+03, 
            1.014174645244479e+03,     1.014851614930641e+03,     1.015525372419544e+03,     1.016195952302498e+03,     1.016863388586796e+03, 
            1.017527714709199e+03,     1.018188963549027e+03,     1.018847167440864e+03,     1.019502358186902e+03,     1.020154567068927e+03, 
            1.020803824859958e+03,     1.021450161835566e+03,     1.022093607784864e+03,     1.022734192021189e+03,     1.023371943392497e+03, 
            1.024006890291455e+03,     1.024639060665268e+03,     1.025268482025228e+03,     1.025895181456004e+03,     1.026519185624689e+03, 
            1.027140520789592e+03,     1.027759212808805e+03,     1.028375287148535e+03,     1.028988768891218e+03,     1.029599682743422e+03, 
            1.030208053043541e+03,     1.030813903769289e+03,     1.031417258545004e+03,     1.032018140648757e+03,     1.032616573019287e+03, 
            1.033212578262756e+03,     1.033806178659338e+03,     1.034397396169626e+03,     1.034986252440905e+03,     1.035572768813250e+03, 
            1.036156966325478e+03,     1.036738865720953e+03,     1.037318487453253e+03,     1.037895851691695e+03,     1.038470978326730e+03, 
            1.039043886975200e+03,     1.039614596985481e+03,     1.040183127442495e+03,     1.040749497172602e+03,     1.041313724748386e+03, 
            1.041875828493321e+03,     1.042435826486327e+03,     1.042993736566228e+03,     1.043549576336097e+03,     1.044103363167511e+03, 
            1.044655114204700e+03,     1.045204846368609e+03,     1.045752576360861e+03,     1.046298320667639e+03,     1.046842095563469e+03, 
            1.047383917114934e+03,     1.047923801184289e+03,     1.048461763433013e+03,     1.048997819325265e+03,     1.049531984131279e+03, 
            1.050064272930681e+03,     1.050594700098210e+03,     1.051123281361353e+03,     1.051650030744919e+03,     1.052174962597837e+03, 
            1.052698091093957e+03,     1.053219430234970e+03,     1.053738993853251e+03,     1.054256795614653e+03,     1.054772849021237e+03, 
            1.055287167413946e+03,     1.055799763975227e+03,     1.056310651731594e+03,     1.056819843556146e+03,     1.057327352171019e+03, 
            1.057833190149807e+03,     1.058337369919918e+03,     1.058839903764893e+03,     1.059340803826672e+03,     1.059840082107819e+03, 
            1.060337750473699e+03,     1.060833820654615e+03,     1.061328304247899e+03,     1.061821212719969e+03,     1.062312557436653e+03, 
            1.062802349550790e+03,     1.063290600177435e+03,     1.063777320279069e+03,     1.064262520696938e+03,     1.064746212152871e+03, 
            1.065228405251076e+03,     1.065709110479891e+03,     1.066188338213514e+03,     1.066666098713687e+03,     1.067142402131361e+03, 
            1.067617258508316e+03,     1.068090677778767e+03,     1.068562669770926e+03,     1.069033244208543e+03,     1.069502410712417e+03, 
            1.069970178801877e+03,     1.070436557896242e+03,     1.070901557316245e+03,     1.071365186285440e+03,     1.071827453931583e+03, 
            1.072288369287973e+03,     1.072747941294800e+03,     1.073206178800435e+03,     1.073663090562719e+03,     1.074118685250223e+03, 
            1.074572971443481e+03,     1.075025957636211e+03,     1.075477652236506e+03,     1.075928063568011e+03,     1.076377199871069e+03, 
            1.076825069303866e+03,     1.077271679943532e+03,     1.077717039787244e+03,     1.078161156753300e+03,     1.078604038682176e+03, 
            1.079045693337564e+03,     1.079486128407400e+03,     1.079925351504859e+03,     1.080363370169353e+03,     1.080800191867495e+03, 
            1.081235823994058e+03,     1.081670273872916e+03,     1.082103548757960e+03,     1.082535655834016e+03,     1.082966602217733e+03, 
            1.083396394958463e+03,     1.083825041039125e+03,     1.084252547377057e+03,     1.084678920824855e+03,     1.085104168171189e+03, 
            1.085528296141619e+03,     1.085951311399393e+03,     1.086373220546223e+03,     1.086794030123069e+03,     1.087213746610886e+03, 
            1.087632376431382e+03,     1.088049925947746e+03,     1.088466401465377e+03,     1.088881809232595e+03,     1.089296155441342e+03, 
            1.089709446227873e+03,     1.090121687673437e+03,     1.090532885804947e+03,     1.090943046595637e+03,     1.091352175965713e+03, 
            1.091760279782991e+03,     1.092167363863528e+03,     1.092573433972239e+03,     1.092978495823512e+03,     1.093382555081803e+03, 
            1.093785617362234e+03,     1.094187688231173e+03,     1.094588773206811e+03,     1.094988877759724e+03,     1.095388007313435e+03, 
            1.095786167244960e+03,     1.096183362885352e+03,     1.096579599520233e+03,     1.096974882390318e+03,     1.097369216691935e+03, 
            1.097762607577533e+03,     1.098155060156188e+03,     1.098546579494094e+03,     1.098937170615057e+03,     1.099326838500969e+03, 
            1.099715588092290e+03,     1.100103424288509e+03,     1.100490351948612e+03,     1.100876375891527e+03,     1.101261500896582e+03, 
            1.101645731703938e+03,     1.102029073015030e+03,     1.102411529492995e+03,     1.102793105763093e+03,     1.103173806413125e+03, 
            1.103553635993849e+03,     1.103932599019377e+03,     1.104310699967584e+03,     1.104687943280498e+03,     1.105064333364689e+03, 
            1.105439874591655e+03,     1.105814571298197e+03,     1.106188427786798e+03,     1.106561448325987e+03,     1.106933637150702e+03, 
            1.107304998462653e+03,     1.107675536430670e+03,     1.108045255191054e+03,     1.108414158847924e+03,     1.108782251473553e+03, 
            1.109149537108701e+03,     1.109516019762956e+03,     1.109881703415044e+03,     1.110246592013167e+03,     1.110610689475309e+03, 
            1.110973999689556e+03,     1.111336526514402e+03,     1.111698273779054e+03,     1.112059245283740e+03,     1.112419444799994e+03, 
            1.112778876070963e+03,     1.113137542811687e+03,     1.113495448709388e+03,     1.113852597423755e+03,     1.114208992587218e+03, 
            1.114564637805229e+03,     1.114919536656527e+03,     1.115273692693410e+03,     1.115627109442000e+03,     1.115979790402505e+03, 
            1.116331739049471e+03,     1.116682958832048e+03,     1.117033453174229e+03,     1.117383225475110e+03,     1.117732279109126e+03, 
            1.118080617426300e+03,     1.118428243752480e+03,     1.118775161389575e+03,     1.119121373615787e+03,     1.119466883685847e+03, 
            1.119811694831235e+03,     1.120155810260413e+03,     1.120499233159041e+03,     1.120841966690199e+03,     1.121184013994604e+03, 
            1.121525378190825e+03,     1.121866062375491e+03,     1.122206069623505e+03,     1.122545402988247e+03,     1.122884065501780e+03, 
            1.123222060175049e+03,     1.123559389998083e+03,     1.123896057940193e+03,     1.124232066950160e+03,     1.124567419956436e+03, 
            1.124902119867325e+03,     1.125236169571179e+03,     1.125569571936578e+03,     1.125902329812516e+03,     1.126234446028577e+03, 
            1.126565923395124e+03,     1.126896764703467e+03,     1.127226972726040e+03,     1.127556550216576e+03,     1.127885499910277e+03, 
            1.128213824523982e+03,     1.128541526756333e+03,     1.128868609287946e+03,     1.129195074781565e+03,     1.129520925882229e+03, 
            1.129846165217432e+03,     1.130170795397279e+03,     1.130494819014638e+03,     1.130818238645302e+03,     1.131141056848138e+03, 
            1.131463276165232e+03,     1.131784899122046e+03,     1.132105928227564e+03,     1.132426365974430e+03,     1.132746214839103e+03, 
            1.133065477281992e+03,     1.133384155747598e+03,     1.133702252664654e+03,     1.134019770446266e+03,     1.134336711490043e+03, 
            1.134653078178233e+03,     1.134968872877862e+03,     1.135284097940860e+03,     1.135598755704191e+03,     1.135912848489987e+03, 
            1.136226378605670e+03,     1.136539348344081e+03,     1.136851759983606e+03,     1.137163615788294e+03,     1.137474918007985e+03, 
            1.137785668878428e+03,     1.138095870621401e+03,     1.138405525444829e+03,     1.138714635542900e+03,     1.139023203096182e+03, 
            1.139331230271739e+03,     1.139638719223238e+03,     1.139945672091071e+03,     1.140252091002455e+03,     1.140557978071551e+03, 
            1.140863335399563e+03,     1.141168165074858e+03,     1.141472469173057e+03,     1.141776249757156e+03,     1.142079508877617e+03, 
            1.142382248572479e+03,     1.142684470867454e+03,     1.142986177776034e+03,     1.143287371299587e+03,     1.143588053427456e+03, 
            1.143888226137059e+03,     1.144187891393981e+03,     1.144487051152076e+03,     1.144785707353558e+03,     1.145083861929093e+03, 
            1.145381516797899e+03,     1.145678673867830e+03,     1.145975335035470e+03,     1.146271502186227e+03,     1.146567177194414e+03, 
            1.146862361923346e+03,     1.147157058225421e+03,     1.147451267942208e+03,     1.147744992904537e+03,     1.148038234932576e+03, 
            1.148330995835923e+03,     1.148623277413683e+03,     1.148915081454551e+03,     1.149206409736901e+03,     1.149497264028854e+03, 
            1.149787646088369e+03,     1.150077557663316e+03,     1.150367000491555e+03,     1.150655976301019e+03,     1.150944486809781e+03, 
            1.151232533726138e+03,     1.151520118748685e+03,     1.151807243566385e+03,     1.152093909858649e+03,     1.152380119295404e+03
    },
    {
            1.837503610519728e+00,     5.578476789299936e+00,     9.406688612848692e+00,     1.332758162784285e+01,     1.734716939536862e+01, 
            2.147212221776471e+01,     2.570987004523399e+01,     3.006872694973072e+01,     3.455804295811765e+01,     3.918839095868494e+01, 
            4.397179910595158e+01,     4.892204301731680e+01,     5.405501768045630e+01,     5.938921733388575e+01,     6.494636423558896e+01, 
            7.075224690411370e+01,     7.683785986538703e+01,     8.324098885571452e+01,     9.000847435416993e+01,     9.719954529881481e+01, 
            1.048909138825541e+02,     1.131849199524982e+02,     1.222233018762381e+02,     1.322122221461836e+02,     1.434723728636761e+02, 
            1.565542238792714e+02,     8.087236822513173e+02,     8.136500684656406e+02,     8.182358149408088e+02,     8.225338045918024e+02, 
            8.265847827265983e+02,     8.304209322173696e+02,     8.340681902986722e+02,     8.375478136773272e+02,     8.408774720374414e+02, 
            8.440720336226237e+02,     8.471441430087182e+02,     8.501046546659436e+02,     8.529629640287499e+02,     8.557272642007114e+02, 
            8.584047477156417e+02,     8.610017670472689e+02,     8.635239637009308e+02,     8.659763730664878e+02,     8.683635103520146e+02, 
            8.706894415929703e+02,     8.729578427733720e+02,     8.751720493929520e+02,     8.773350982927304e+02,     8.794497631597199e+02, 
            8.815185848341847e+02,     8.835438973150464e+02,     8.855278501827249e+02,     8.874724280213047e+02,     8.893794673137514e+02, 
            8.912506711983589e+02,     8.930876224062700e+02,     8.948917946451259e+02,     8.966645626495651e+02,     8.984072110833954e+02, 
            9.001209424487514e+02,     9.018068841335037e+02,     9.034660947081990e+02,     9.050995695672968e+02,     9.067082459957280e+02, 
            9.082930077302392e+02,     9.098546890753607e+02,     9.113940786256383e+02,     9.129119226389093e+02,     9.144089280994847e+02, 
            9.158857655051709e+02,     9.173430714077119e+02,     9.187814507326497e+02,     9.202014789013680e+02,     9.216037037754370e+02, 
            9.229886474409562e+02,     9.243568078486076e+02,     9.257086603233031e+02,     9.270446589558112e+02,     9.283652378873395e+02, 
            9.296708124969241e+02,     9.309617805003767e+02,     9.322385229686610e+02,     9.335014052727515e+02,     9.347507779613130e+02, 
            9.359869775768982e+02,     9.372103274158184e+02,     9.384211382363242e+02,     9.396197089193121e+02,     9.408063270853370e+02, 
            9.419812696714214e+02,     9.431448034707571e+02,     9.442971856381896e+02,     9.454386641640543e+02,     9.465694783187519e+02, 
            9.476898590702210e+02,     9.488000294762913e+02,     9.499002050537139e+02,     9.509905941255504e+02,     9.520713981484239e+02, 
            9.531428120210404e+02,     9.542050243752569e+02,     9.552582178509001e+02,     9.563025693553901e+02,     9.573382503092124e+02, 
            9.583654268781395e+02,     9.593842601930687e+02,     9.603949065582744e+02,     9.613975176487874e+02,     9.623922406976158e+02, 
            9.633792186734026e+02,     9.643585904491246e+02,     9.653304909623741e+02,     9.662950513677232e+02,     9.672523992180712e+02, 
            9.682026584210796e+02,     9.691459497365810e+02,     9.700823905357903e+02,     9.710120951021898e+02,     9.719351747087402e+02, 
            9.728517376297706e+02,     9.737618896403725e+02,     9.746657335056813e+02,     9.755633689643920e+02,     9.764548946162536e+02, 
            9.773404054138055e+02,     9.782199943275546e+02,     9.790937520605715e+02,     9.799617671241449e+02,     9.808241259102357e+02, 
            9.816809127609140e+02,     9.825322100348986e+02,     9.833780981713828e+02,     9.842186557512468e+02,     9.850539595558023e+02, 
            9.858840846231913e+02,     9.867091043025383e+02,     9.875290903059779e+02,     9.883441127586536e+02,     9.891542402622517e+02, 
            9.899595398778901e+02,     9.907600772678676e+02,     9.915559166719516e+02,     9.923471209656279e+02,     9.931337516997506e+02, 
            9.939158691387294e+02,     9.946935322973337e+02,     9.954667989761529e+02,     9.962357257957794e+02,     9.970003682297809e+02, 
            9.977607806364956e+02,     9.985170162897185e+02,     9.992691274083072e+02,     1.000017165184775e+03,     1.000761179812888e+03, 
            1.001501220514335e+03,     1.002237335564481e+03,     1.002969572317270e+03,     1.003697977229278e+03,     1.004422595882992e+03, 
            1.005143473009300e+03,     1.005860652509267e+03,     1.006574177475193e+03,     1.007284090210996e+03,     1.007990432251943e+03, 
            1.008693244383755e+03,     1.009392566661113e+03,     1.010088438425576e+03,     1.010780898322950e+03,     1.011469984291131e+03, 
            1.012155733694277e+03,     1.012838183158826e+03,     1.013517368710800e+03,     1.014193325759635e+03,     1.014866089112611e+03, 
            1.015535692988855e+03,     1.016202171032929e+03,     1.016865556328019e+03,     1.017525881408742e+03,     1.018183178273584e+03, 
            1.018837478396971e+03,     1.019488812741010e+03,     1.020137211766878e+03,     1.020782705445908e+03,     1.021425323270353e+03, 
            1.022065094263847e+03,     1.022702046991586e+03,     1.023336209570223e+03,     1.023967609677489e+03,     1.024596274561560e+03, 
            1.025222231050159e+03,     1.025845505559430e+03,     1.026466124102554e+03,     1.027084112298150e+03,     1.027699495378454e+03, 
            1.028312298197271e+03,     1.028922545237736e+03,     1.029530260619857e+03,     1.030135468107875e+03,     1.030738191117424e+03, 
            1.031338452722524e+03,     1.031936275662377e+03,     1.032531682348005e+03,     1.033124694868716e+03,     1.033715334998406e+03, 
            1.034303624201717e+03,     1.034889583640018e+03,     1.035473234177265e+03,     1.036054596385703e+03,     1.036633690551433e+03, 
            1.037210536679840e+03,     1.037785154500901e+03,     1.038357563474353e+03,     1.038927782794746e+03,     1.039495831396372e+03, 
            1.040061727958084e+03,     1.040625490907992e+03,     1.041187138428058e+03,     1.041746688458580e+03,     1.042304158702573e+03, 
            1.042859566630050e+03,     1.043412929482205e+03,     1.043964264275500e+03,     1.044513587805660e+03,     1.045060916651576e+03, 
            1.045606267179125e+03,     1.046149655544899e+03,     1.046691097699855e+03,     1.047230609392882e+03,     1.047768206174297e+03, 
            1.048303903399245e+03,     1.048837715710226e+03,     1.049369659107837e+03,     1.049899747876208e+03,     1.050427996622503e+03, 
            1.050954419774715e+03,     1.051479031584651e+03,     1.052001846130874e+03,     1.052522877321563e+03,     1.053042138897328e+03, 
            1.053559644433962e+03,     1.054075407345129e+03,     1.054589440885004e+03,     1.055101758150857e+03,     1.055612372085584e+03, 
            1.056121295480183e+03,     1.056628540976182e+03,     1.057134121068020e+03,     1.057638048105376e+03,     1.058140334295453e+03, 
            1.058640991705216e+03,     1.059140032292170e+03,     1.059637467791046e+03,     1.060133309890850e+03,     1.060627570119099e+03, 
            1.061120259873619e+03,     1.061611390424531e+03,     1.062100972916191e+03,     1.062589018369111e+03,     1.063075537681822e+03, 
            1.063560541632719e+03,     1.064044040881857e+03,     1.064526045972726e+03,     1.065006567333978e+03,     1.065485615281139e+03, 
            1.065963200018265e+03,     1.066439331639595e+03,     1.066914020131148e+03,     1.067387275372309e+03,     1.067859107137372e+03, 
            1.068329525097067e+03,     1.068798538820045e+03,     1.069266157774354e+03,     1.069732391328864e+03,     1.070197248754694e+03, 
            1.070660739226588e+03,     1.071122871824286e+03,     1.071583655533854e+03,     1.072043099249004e+03,     1.072501211772385e+03, 
            1.072958001816842e+03,     1.073413478006674e+03,     1.073867648878848e+03,     1.074320522884207e+03,     1.074772108388648e+03, 
            1.075222413674284e+03,     1.075671446940584e+03,     1.076119216305494e+03,     1.076565729806539e+03,     1.077010995401908e+03, 
            1.077455020971512e+03,     1.077897814318040e+03,     1.078339383167976e+03,     1.078779735172621e+03,     1.079218877909081e+03, 
            1.079656818881246e+03,     1.080093565520750e+03,     1.080529125187923e+03,     1.080963505172709e+03,     1.081396712695591e+03, 
            1.081828754908483e+03,     1.082259638895621e+03,     1.082689371674428e+03,     1.083117960196369e+03,     1.083545411347801e+03, 
            1.083971731950791e+03,     1.084396928763937e+03,     1.084821008483173e+03,     1.085243977742550e+03,     1.085665843115020e+03, 
            1.086086611113193e+03,     1.086506288190099e+03,     1.086924880739916e+03,     1.087342395098713e+03,     1.087758837545154e+03, 
            1.088174214301210e+03,     1.088588531532855e+03,     1.089001795350749e+03,     1.089414011810912e+03,     1.089825186915385e+03, 
            1.090235326612888e+03,     1.090644436799455e+03,     1.091052523319079e+03,     1.091459591964325e+03,     1.091865648476948e+03, 
            1.092270698548499e+03,     1.092674747820922e+03,     1.093077801887137e+03,     1.093479866291618e+03,     1.093880946530969e+03, 
            1.094281048054477e+03,     1.094680176264670e+03,     1.095078336517859e+03,     1.095475534124675e+03,     1.095871774350597e+03, 
            1.096267062416475e+03,     1.096661403499041e+03,     1.097054802731417e+03,     1.097447265203611e+03,     1.097838795963009e+03, 
            1.098229400014861e+03,     1.098619082322756e+03,     1.099007847809095e+03,     1.099395701355548e+03,     1.099782647803522e+03, 
            1.100168691954604e+03,     1.100553838571004e+03,     1.100938092375999e+03,     1.101321458054358e+03,     1.101703940252777e+03, 
            1.102085543580287e+03,     1.102466272608679e+03,     1.102846131872903e+03,     1.103225125871478e+03,     1.103603259066883e+03, 
            1.103980535885953e+03,     1.104356960720264e+03,     1.104732537926510e+03,     1.105107271826885e+03,     1.105481166709448e+03, 
            1.105854226828491e+03,     1.106226456404902e+03,     1.106597859626513e+03,     1.106968440648462e+03,     1.107338203593526e+03, 
            1.107707152552475e+03,     1.108075291584402e+03,     1.108442624717056e+03,     1.108809155947172e+03,     1.109174889240794e+03, 
            1.109539828533593e+03,     1.109903977731186e+03,     1.110267340709442e+03,     1.110629921314795e+03,     1.110991723364539e+03, 
            1.111352750647138e+03,     1.111713006922511e+03,     1.112072495922329e+03,     1.112431221350302e+03,     1.112789186882460e+03, 
            1.113146396167439e+03,     1.113502852826751e+03,     1.113858560455061e+03,     1.114213522620459e+03,     1.114567742864722e+03, 
            1.114921224703575e+03,     1.115273971626960e+03,     1.115625987099281e+03,     1.115977274559667e+03,     1.116327837422214e+03, 
            1.116677679076236e+03,     1.117026802886509e+03,     1.117375212193511e+03,     1.117722910313657e+03,     1.118069900539538e+03, 
            1.118416186140152e+03,     1.118761770361129e+03,     1.119106656424965e+03,     1.119450847531236e+03,     1.119794346856828e+03, 
            1.120137157556146e+03,     1.120479282761338e+03,     1.120820725582503e+03,     1.121161489107902e+03,     1.121501576404164e+03, 
            1.121840990516497e+03,     1.122179734468882e+03,     1.122517811264282e+03,     1.122855223884834e+03,     1.123191975292048e+03, 
            1.123528068426997e+03,     1.123863506210513e+03,     1.124198291543370e+03,     1.124532427306473e+03,     1.124865916361043e+03, 
            1.125198761548801e+03,     1.125530965692142e+03,     1.125862531594317e+03,     1.126193462039613e+03,     1.126523759793514e+03, 
            1.126853427602889e+03,     1.127182468196149e+03,     1.127510884283422e+03,     1.127838678556715e+03,     1.128165853690081e+03, 
            1.128492412339780e+03,     1.128818357144437e+03,     1.129143690725205e+03,     1.129468415685918e+03,     1.129792534613248e+03, 
            1.130116050076858e+03,     1.130438964629550e+03,     1.130761280807422e+03,     1.131083001130007e+03,     1.131404128100428e+03, 
            1.131724664205536e+03,     1.132044611916058e+03,     1.132363973686735e+03,     1.132682751956465e+03,     1.133000949148438e+03, 
            1.133318567670278e+03,     1.133635609914171e+03,     1.133952078257008e+03,     1.134267975060509e+03,     1.134583302671360e+03, 
            1.134898063421340e+03,     1.135212259627448e+03,     1.135525893592034e+03,     1.135838967602918e+03,     1.136151483933522e+03, 
            1.136463444842985e+03,     1.136774852576289e+03,     1.137085709364379e+03,     1.137396017424280e+03,     1.137705778959216e+03, 
            1.138014996158724e+03,     1.138323671198772e+03,     1.138631806241871e+03,     1.138939403437188e+03,     1.139246464920659e+03, 
            1.139552992815096e+03,     1.139858989230299e+03,     1.140164456263164e+03,     1.140469395997785e+03,     1.140773810505566e+03, 
            1.141077701845325e+03,     1.141381072063392e+03,     1.141683923193717e+03,     1.141986257257969e+03,     1.142288076265636e+03, 
            1.142589382214126e+03,     1.142890177088864e+03,     1.143190462863391e+03,     1.143490241499457e+03,     1.143789514947118e+03, 
            1.144088285144832e+03,     1.144386554019550e+03,     1.144684323486810e+03,     1.144981595450827e+03,     1.145278371804586e+03, 
            1.145574654429926e+03,     1.145870445197637e+03,     1.146165745967542e+03,     1.146460558588585e+03,     1.146754884898918e+03, 
            1.147048726725986e+03,     1.147342085886611e+03,     1.147634964187075e+03,     1.147927363423207e+03,     1.148219285380456e+03, 
            1.148510731833980e+03,     1.148801704548726e+03,     1.149092205279505e+03,     1.149382235771071e+03,     1.149671797758206e+03, 
            1.149960892965787e+03,     1.150249523108872e+03,     1.150537689892767e+03,     1.150825395013108e+03,     1.151112640155932e+03
    },
    {
            1.833616792974633e+00,     5.566235967548499e+00,     9.385256158251801e+00,     1.329601917110818e+01,     1.730442165880149e+01, 
            2.141699750845854e+01,     2.564101654567616e+01,     2.998460366973191e+01,     3.445688383472200e+01,     3.906816006316168e+01, 
            4.383013416683976e+01,     4.875618338399910e+01,     5.386171125432478e+01,     5.916459859212682e+01,     6.468579177644074e+01, 
            7.045008310569393e+01,     7.648716575900328e+01,     8.283309135546304e+01,     8.953233509297533e+01,     9.664080932443393e+01, 
            1.042304180943416e+02,     1.123962387657327e+02,     1.212684563872975e+02,     1.310335655831338e+02,     1.419755176562446e+02, 
            1.545660945245144e+02,     1.697048420695517e+02,     8.064521605616575e+02,     8.113965237893850e+02,     8.160015087765081e+02, 
            8.203192504582389e+02,     8.243900527012361e+02,     8.282458328978387e+02,     8.319123682774306e+02,     8.354108208478549e+02, 
            8.387588069968901e+02,     8.419711683458248e+02,     8.450605401885072e+02,     8.480377790038862e+02,     8.509122895342230e+02, 
            8.536922788199540e+02,     8.563849561570199e+02,     8.589966923805773e+02,     8.615331481216501e+02,     8.639993780926710e+02, 
            8.663999166388234e+02,     8.687388484936747e+02,     8.710198677369151e+02,     8.732463272613062e+02,     8.754212805423490e+02, 
            8.775475171180573e+02,     8.796275928927877e+02,     8.816638561539003e+02,     8.836584700157307e+02,     8.856134318692618e+02, 
            8.875305903087542e+02,     8.894116599217099e+02,     8.912582342607963e+02,     8.930717972618512e+02,     8.948537333281485e+02, 
            8.966053362652568e+02,     8.983278172216146e+02,     9.000223117658751e+02,     9.016898862122448e+02,     9.033315432885320e+02, 
            9.049482272279536e+02,     9.065408283541871e+02,     9.081101872195616e+02,     9.096570983480954e+02,     9.111823136282167e+02, 
            9.126865453941275e+02,     9.141704692297861e+02,     9.156347265251994e+02,     9.170799268110624e+02,     9.185066498946030e+02, 
            9.199154478167986e+02,     9.213068466487512e+02,     9.226813481429435e+02,     9.240394312533833e+02,     9.253815535370086e+02, 
            9.267081524474258e+02,     9.280196465308470e+02,     9.293164365330389e+02,     9.305989064251846e+02,     9.318674243557515e+02, 
            9.331223435347282e+02,     9.343640030559812e+02,     9.355927286628870e+02,     9.368088334619266e+02,     9.380126185884639e+02, 
            9.392043738285358e+02,     9.403843782001330e+02,     9.415529004971215e+02,     9.427101997986838e+02,     9.438565259468854e+02, 
            9.449921199947657e+02,     9.461172146271149e+02,     9.472320345559405e+02,     9.483367968924533e+02,     9.494317114972185e+02, 
            9.505169813100316e+02,     9.515928026609166e+02,     9.526593655635352e+02,     9.537168539922106e+02,     9.547654461436539e+02, 
            9.558053146844096e+02,     9.568366269849565e+02,     9.578595453413249e+02,     9.588742271850257e+02,     9.598808252820444e+02, 
            9.608794879215592e+02,     9.618703590950494e+02,     9.628535786663624e+02,     9.638292825332878e+02,     9.647976027811580e+02, 
            9.657586678290795e+02,     9.667126025707893e+02,     9.676595285068054e+02,     9.685995638692438e+02,     9.695328237419336e+02, 
            9.704594201749817e+02,     9.713794621957487e+02,     9.722930563164363e+02,     9.732003055579698e+02,     9.741013115997522e+02, 
            9.749961725536074e+02,     9.758849843913791e+02,     9.767678407206276e+02,     9.776448328642825e+02,     9.785160499369028e+02, 
            9.793815789177196e+02,     9.802415047206165e+02,     9.810959102612147e+02,     9.819448765211982e+02,     9.827884826100158e+02, 
            9.836268058240984e+02,     9.844599217037007e+02,     9.852879040874873e+02,     9.861108251649698e+02,     9.869287555269043e+02, 
            9.877417642292920e+02,     9.885499187762699e+02,     9.893532852627701e+02,     9.901519283507638e+02,     9.909459113279282e+02, 
            9.917352961476076e+02,     9.925201434673098e+02,     9.933005126857862e+02,     9.940764619787725e+02,     9.948480483334421e+02, 
            9.956153275816313e+02,     9.963783544318854e+02,     9.971371825003758e+02,     9.978918643407434e+02,     9.986424514729080e+02, 
            9.993889944108822e+02,     1.000131542689642e+03,     1.000870144891081e+03,     1.001604848669107e+03,     1.002335700773877e+03, 
            1.003062747075252e+03,     1.003786032585464e+03,     1.004505601481057e+03,     1.005221497124101e+03,     1.005933762082735e+03, 
            1.006642438151046e+03,     1.007347566368320e+03,     1.008049187037686e+03,     1.008747339744172e+03,     1.009442063343612e+03, 
            1.010133396095860e+03,     1.010821375503860e+03,     1.011506038449911e+03,     1.012187421180480e+03,     1.012865559321194e+03, 
            1.013540487891379e+03,     1.014212241318161e+03,     1.014880853450158e+03,     1.015546357570774e+03,     1.016208786411088e+03, 
            1.016868172162395e+03,     1.017524546488362e+03,     1.018177940536853e+03,     1.018828384951409e+03,     1.019475909882408e+03, 
            1.020120544997910e+03,     1.020762319494199e+03,     1.021401262106036e+03,     1.022037401116621e+03,     1.022670764367295e+03, 
            1.023301379266963e+03,     1.023929272801274e+03,     1.024554471541548e+03,     1.025177001653463e+03,     1.025796888905516e+03, 
            1.026414158677254e+03,     1.027028835967292e+03,     1.027640945401123e+03,     1.028250511238722e+03,     1.028857557381949e+03, 
            1.029462107381775e+03,     1.030064184445309e+03,     1.030663811442654e+03,     1.031261010913585e+03,     1.031855805074067e+03, 
            1.032448215822601e+03,     1.033038264746413e+03,     1.033625973127502e+03,     1.034211361948519e+03,     1.034794451898521e+03, 
            1.035375263378571e+03,     1.035953816507211e+03,     1.036530131125800e+03,     1.037104226803724e+03,     1.037676122843482e+03, 
            1.038245838285650e+03,     1.038813391913730e+03,     1.039378802258886e+03,     1.039942087604565e+03,     1.040503265991015e+03, 
            1.041062355219693e+03,     1.041619372857585e+03,     1.042174336241403e+03,     1.042727262481715e+03,     1.043278168466956e+03, 
            1.043827070867365e+03,     1.044373986138830e+03,     1.044918930526641e+03,     1.045461920069166e+03,     1.046002970601443e+03, 
            1.046542097758695e+03,     1.047079316455829e+03,     1.047614642970515e+03,     1.048148091850665e+03,     1.048679677965861e+03, 
            1.049209416002325e+03,     1.049737320465993e+03,     1.050263405685534e+03,     1.050787685815302e+03,     1.051310174838222e+03, 
            1.051830886568622e+03,     1.052349834655000e+03,     1.052867032582733e+03,     1.053382493676738e+03,     1.053896231104071e+03, 
            1.054408257876467e+03,     1.054918586852845e+03,     1.055427230741746e+03,     1.055934202103729e+03,     1.056439513381401e+03, 
            1.056943176789877e+03,     1.057445204488496e+03,     1.057945608468882e+03,     1.058444400585951e+03,     1.058941592560028e+03, 
            1.059437195978930e+03,     1.059931222300002e+03,     1.060423682852120e+03,     1.060914588837649e+03,     1.061403951334363e+03, 
            1.061891781297339e+03,     1.062378089560798e+03,     1.062862886839924e+03,     1.063346183732639e+03,     1.063827990721355e+03, 
            1.064308318174682e+03,     1.064787176349111e+03,     1.065264575390662e+03,     1.065740525336505e+03,     1.066215036116545e+03, 
            1.066688117554984e+03,     1.067159779371849e+03,     1.067630031184497e+03,     1.068098882509089e+03,     1.068566342762037e+03, 
            1.069032421261426e+03,     1.069497127228412e+03,     1.069960469788590e+03,     1.070422457973343e+03,     1.070883100721164e+03, 
            1.071342406878955e+03,     1.071800385203300e+03,     1.072257044361723e+03,     1.072712392933917e+03,     1.073166439412953e+03, 
            1.073619192206471e+03,     1.074070659637845e+03,     1.074520849947335e+03,     1.074969771293209e+03,     1.075417431752861e+03, 
            1.075863839323890e+03,     1.076309001925177e+03,     1.076752927397937e+03,     1.077195623506755e+03,     1.077637097940601e+03, 
            1.078077358313834e+03,     1.078516412167181e+03,     1.078954266968708e+03,     1.079390930114771e+03,     1.079826408930950e+03, 
            1.080260710672968e+03,     1.080693842527598e+03,     1.081125811613555e+03,     1.081556624982365e+03,     1.081986289619233e+03, 
            1.082414812443885e+03,     1.082842200311406e+03,     1.083268460013055e+03,     1.083693598277078e+03,     1.084117621769497e+03, 
            1.084540537094893e+03,     1.084962350797177e+03,     1.085383069360343e+03,     1.085802699209217e+03,     1.086221246710185e+03, 
            1.086638718171920e+03,     1.087055119846089e+03,     1.087470457928052e+03,     1.087884738557554e+03,     1.088297967819398e+03, 
            1.088710151744116e+03,     1.089121296308623e+03,     1.089531407436868e+03,     1.089940491000467e+03,     1.090348552819333e+03, 
            1.090755598662293e+03,     1.091161634247698e+03,     1.091566665244018e+03,     1.091970697270438e+03,     1.092373735897437e+03, 
            1.092775786647359e+03,     1.093176854994982e+03,     1.093576946368069e+03,     1.093976066147919e+03,     1.094374219669905e+03, 
            1.094771412224007e+03,     1.095167649055336e+03,     1.095562935364648e+03,     1.095957276308857e+03,     1.096350677001532e+03, 
            1.096743142513393e+03,     1.097134677872801e+03,     1.097525288066231e+03,     1.097914978038752e+03,     1.098303752694491e+03, 
            1.098691616897092e+03,     1.099078575470170e+03,     1.099464633197756e+03,     1.099849794824743e+03,     1.100234065057312e+03, 
            1.100617448563367e+03,     1.100999949972956e+03,     1.101381573878684e+03,     1.101762324836127e+03,     1.102142207364236e+03, 
            1.102521225945735e+03,     1.102899385027515e+03,     1.103276689021026e+03,     1.103653142302654e+03,     1.104028749214104e+03, 
            1.104403514062770e+03,     1.104777441122103e+03,     1.105150534631973e+03,     1.105522798799028e+03,     1.105894237797048e+03, 
            1.106264855767289e+03,     1.106634656818831e+03,     1.107003645028913e+03,     1.107371824443272e+03,     1.107739199076470e+03, 
            1.108105772912215e+03,     1.108471549903694e+03,     1.108836533973880e+03,     1.109200729015849e+03,     1.109564138893088e+03, 
            1.109926767439797e+03,     1.110288618461199e+03,     1.110649695733824e+03,     1.111010003005813e+03,     1.111369543997199e+03, 
            1.111728322400202e+03,     1.112086341879501e+03,     1.112443606072516e+03,     1.112800118589688e+03,     1.113155883014741e+03, 
            1.113510902904957e+03,     1.113865181791436e+03,     1.114218723179360e+03,     1.114571530548252e+03,     1.114923607352223e+03, 
            1.115274957020232e+03,     1.115625582956329e+03,     1.115975488539905e+03,     1.116324677125926e+03,     1.116673152045181e+03, 
            1.117020916604513e+03,     1.117367974087051e+03,     1.117714327752445e+03,     1.118059980837091e+03,     1.118404936554354e+03, 
            1.118749198094793e+03,     1.119092768626379e+03,     1.119435651294711e+03,     1.119777849223231e+03,     1.120119365513436e+03, 
            1.120460203245082e+03,     1.120800365476399e+03,     1.121139855244287e+03,     1.121478675564521e+03,     1.121816829431950e+03, 
            1.122154319820692e+03,     1.122491149684331e+03,     1.122827321956106e+03,     1.123162839549104e+03,     1.123497705356444e+03, 
            1.123831922251465e+03,     1.124165493087906e+03,     1.124498420700094e+03,     1.124830707903113e+03,     1.125162357492989e+03, 
            1.125493372246859e+03,     1.125823754923150e+03,     1.126153508261744e+03,     1.126482634984148e+03,     1.126811137793664e+03, 
            1.127139019375549e+03,     1.127466282397185e+03,     1.127792929508230e+03,     1.128118963340788e+03,     1.128444386509560e+03, 
            1.128769201612001e+03,     1.129093411228476e+03,     1.129417017922410e+03,     1.129740024240437e+03,     1.130062432712555e+03, 
            1.130384245852267e+03,     1.130705466156730e+03,     1.131026096106897e+03,     1.131346138167659e+03,     1.131665594787990e+03, 
            1.131984468401081e+03,     1.132302761424479e+03,     1.132620476260224e+03,     1.132937615294986e+03,     1.133254180900193e+03, 
            1.133570175432167e+03,     1.133885601232250e+03,     1.134200460626938e+03,     1.134514755928006e+03,     1.134828489432631e+03, 
            1.135141663423525e+03,     1.135454280169046e+03,     1.135766341923335e+03,     1.136077850926421e+03,     1.136388809404354e+03, 
            1.136699219569316e+03,     1.137009083619737e+03,     1.137318403740417e+03,     1.137627182102632e+03,     1.137935420864255e+03, 
            1.138243122169864e+03,     1.138550288150852e+03,     1.138856920925539e+03,     1.139163022599280e+03,     1.139468595264573e+03, 
            1.139773641001161e+03,     1.140078161876144e+03,     1.140382159944078e+03,     1.140685637247080e+03,     1.140988595814928e+03, 
            1.141291037665166e+03,     1.141592964803198e+03,     1.141894379222392e+03,     1.142195282904174e+03,     1.142495677818130e+03, 
            1.142795565922094e+03,     1.143094949162249e+03,     1.143393829473218e+03,     1.143692208778159e+03,     1.143990088988855e+03, 
            1.144287472005807e+03,     1.144584359718320e+03,     1.144880754004598e+03,     1.145176656731826e+03,     1.145472069756266e+03, 
            1.145766994923332e+03,     1.146061434067686e+03,     1.146355389013318e+03,     1.146648861573630e+03,     1.146941853551521e+03, 
            1.147234366739466e+03,     1.147526402919601e+03,     1.147817963863804e+03,     1.148109051333771e+03,     1.148399667081098e+03, 
            1.148689812847357e+03,     1.148979490364179e+03,     1.149268701353325e+03,     1.149557447526763e+03,     1.149845730586747e+03
    },
    {
            1.829746704721273e+00,     5.554051868704915e+00,     9.363930539422025e+00,     1.326462586901047e+01,     1.726192018361333e+01, 
            2.136221416955705e+01,     2.557262155755230e+01,     2.990108316483288e+01,     3.435650535832471e+01,     3.894892963560282e+01, 
            4.368974230510038e+01,     4.859193647716217e+01,     5.367044322612109e+01,     5.894255559964951e+01,     6.442847935590143e+01, 
            7.015205994474631e+01,     7.614175984209589e+01,     8.243200018978914e+01,     8.906504747016045e+01,     9.609374233265279e+01, 
            1.035855800901507e+02,     1.116290616168126e+02,     1.203440763409410e+02,     1.298999626895399e+02,     1.405495725413149e+02, 
            1.527010735564088e+02,     1.670963993289834e+02,     7.988475134668163e+02,     8.042138561172453e+02,     8.091741182472847e+02, 
            8.137964933999189e+02,     8.181323426225276e+02,     8.222215018405644e+02,     8.260955988976527e+02,     8.297802301060819e+02, 
            8.332964449355518e+02,     8.366617913666958e+02,     8.398910716193618e+02,     8.429969008852124e+02,     8.459901284655647e+02, 
            8.488801605839568e+02,     8.516752115235727e+02,     8.543825015935713e+02,     8.570084150329624e+02,     8.595586273057735e+02, 
            8.620382087151709e+02,     8.644517094865325e+02,     8.668032301983951e+02,     8.690964805176362e+02,     8.713348285168720e+02, 
            8.735213423469030e+02,     8.756588256568297e+02,     8.777498478651232e+02,     8.797967701627174e+02,     8.818017679570044e+02, 
            8.837668503309960e+02,     8.856938769859437e+02,     8.875845730515892e+02,     8.894405420810574e+02,     8.912632774933719e+02, 
            8.930541726829056e+02,     8.948145299795166e+02,     8.965455686140311e+02,     8.982484318198625e+02,     8.999241931817652e+02, 
            9.015738623263364e+02,     9.031983900352050e+02,     9.047986728503969e+02,     9.063755572317375e+02,     9.079298433180124e+02, 
            9.094622883367717e+02,     9.109736097017427e+02,     9.124644878318934e+02,     9.139355687218789e+02,     9.153874662899386e+02, 
            9.168207645261891e+02,     9.182360194614893e+02,     9.196337609747195e+02,     9.210144944542827e+02,     9.223787023278138e+02, 
            9.237268454725561e+02,     9.250593645175179e+02,     9.263766810472819e+02,     9.276791987163438e+02,     9.289673042819007e+02, 
            9.302413685622195e+02,     9.315017473269719e+02,     9.327487821253155e+02,     9.339828010569018e+02,     9.352041194905272e+02, 
            9.364130407346571e+02,     9.376098566636857e+02,     9.387948483034141e+02,     9.399682863789368e+02,     9.411304318278002e+02, 
            9.422815362810837e+02,     9.434218425147996e+02,     9.445515848737897e+02,     9.456709896701446e+02,     9.467802755579557e+02, 
            9.478796538861055e+02,     9.489693290306259e+02,     9.500494987080297e+02,     9.511203542709533e+02,     9.521820809872760e+02, 
            9.532348583038304e+02,     9.542788600957417e+02,     9.553142549023055e+02,     9.563412061502975e+02,     9.573598723655188e+02, 
            9.583704073732971e+02,     9.593729604886657e+02,     9.603676766968401e+02,     9.613546968245882e+02,     9.623341577030498e+02, 
            9.633061923225197e+02,     9.642709299806268e+02,     9.652284964239009e+02,     9.661790139794732e+02,     9.671226016818127e+02, 
            9.680593753937997e+02,     9.689894479229014e+02,     9.699129290279762e+02,     9.708299259405426e+02,     9.717405422676743e+02, 
            9.726448805468560e+02,     9.735430394650673e+02,     9.744351156325076e+02,     9.753212032778292e+02,     9.762013943284087e+02, 
            9.770757784871810e+02,     9.779444433062438e+02,     9.788074742573746e+02,     9.796649547996285e+02,     9.805169664441497e+02, 
            9.813635888163481e+02,     9.822048997155689e+02,     9.830409751723595e+02,     9.838718895034737e+02,     9.846977153647138e+02, 
            9.855185238016978e+02,     9.863343843142729e+02,     9.871453648396036e+02,     9.879515318954039e+02,     9.887529505563438e+02, 
            9.895496845130718e+02,     9.903417961124819e+02,     9.911293463964868e+02,     9.919123951393892e+02,     9.926910008838819e+02, 
            9.934652209757651e+02,     9.942351115974144e+02,     9.950007278000689e+02,     9.957621235349776e+02,     9.965193516834703e+02, 
            9.972724640859691e+02,     9.980215115700200e+02,     9.987665439773579e+02,     9.995076101900574e+02,     1.000244758155802e+03, 
            1.000978034912314e+03,     1.001707486610972e+03,     1.002433158539652e+03,     1.003155095144817e+03,     1.003873340052900e+03, 
            1.004587936090990e+03,     1.005298925306861e+03,     1.006006348988360e+03,     1.006710247682183e+03,     1.007410661183939e+03, 
            1.008107628670175e+03,     1.008801188540903e+03,     1.009491378554584e+03,     1.010178235814026e+03,     1.010861796781947e+03, 
            1.011542097296070e+03,     1.012219172583768e+03,     1.012893057276265e+03,     1.013563785422434e+03,     1.014231390502169e+03, 
            1.014895905439389e+03,     1.015557362614647e+03,     1.016215793877388e+03,     1.016871230557852e+03,     1.017523703478636e+03, 
            1.018173242965931e+03,     1.018819878860451e+03,     1.019463640528043e+03,     1.020104556870013e+03,     1.020742656333164e+03, 
            1.021377966919557e+03,     1.022010516196011e+03,     1.022640331303337e+03,     1.023267438965338e+03,     1.023891865497548e+03, 
            1.024513636815755e+03,     1.025132778444295e+03,     1.025749315524115e+03,     1.026363272820649e+03,     1.026974674731465e+03, 
            1.027583545293729e+03,     1.028189908191470e+03,     1.028793786762663e+03,     1.029395204006135e+03,     1.029994182588281e+03, 
            1.030590744849632e+03,     1.031184912811242e+03,     1.031776708180927e+03,     1.032366152359339e+03,     1.032953266445903e+03, 
            1.033538071244598e+03,     1.034120587269600e+03,     1.034700834750795e+03,     1.035278833639145e+03,     1.035854603611942e+03, 
            1.036428164077923e+03,     1.036999534182270e+03,     1.037568732811495e+03,     1.038135778598201e+03,     1.038700689925736e+03, 
            1.039263484932749e+03,     1.039824181517619e+03,     1.040382797342804e+03,     1.040939349839074e+03,     1.041493856209659e+03, 
            1.042046333434297e+03,     1.042596798273188e+03,     1.043145267270871e+03,     1.043691756759996e+03,     1.044236282865031e+03, 
            1.044778861505876e+03,     1.045319507874558e+03,     1.045858238529824e+03,     1.046395068287888e+03,     1.046930012284977e+03, 
            1.047463085469679e+03,     1.047994302606111e+03,     1.048523678277021e+03,     1.049051226886822e+03,     1.049576962664564e+03, 
            1.050100899666841e+03,     1.050623051780639e+03,     1.051143432726119e+03,     1.051662056059354e+03,     1.052178935174994e+03, 
            1.052694083308887e+03,     1.053207513568554e+03,     1.053719238822931e+03,     1.054229271875713e+03,     1.054737625352655e+03, 
            1.055244311733014e+03,     1.055749343351865e+03,     1.056252732402369e+03,     1.056754490937993e+03,     1.057254630874691e+03, 
            1.057753163993037e+03,     1.058250101940322e+03,     1.058745456232600e+03,     1.059239238256706e+03,     1.059731459272227e+03, 
            1.060222130413434e+03,     1.060711262691185e+03,     1.061198866994781e+03,     1.061684954093797e+03,     1.062169534639868e+03, 
            1.062652619168447e+03,     1.063134218100532e+03,     1.063614341744353e+03,     1.064093000297035e+03,     1.064570203846224e+03, 
            1.065045962371690e+03,     1.065520285746888e+03,     1.065993183740509e+03,     1.066464666017981e+03,     1.066934742142960e+03, 
            1.067403421578784e+03,     1.067870713689907e+03,     1.068336627743300e+03,     1.068801172909831e+03,     1.069264358265623e+03, 
            1.069726192793383e+03,     1.070186685383706e+03,     1.070645844836365e+03,     1.071103679861566e+03,     1.071560199081190e+03, 
            1.072015411030013e+03,     1.072469324156895e+03,     1.072921946825961e+03,     1.073373287317756e+03,     1.073823353830374e+03, 
            1.074272154480581e+03,     1.074719697304907e+03,     1.075165990260724e+03,     1.075611041227307e+03,     1.076054858006873e+03, 
            1.076497448325606e+03,     1.076938819834667e+03,     1.077378980111174e+03,     1.077817936659186e+03,     1.078255696910654e+03, 
            1.078692268226365e+03,     1.079127657896863e+03,     1.079561873143366e+03,     1.079994921118654e+03,     1.080426808907956e+03, 
            1.080857543529814e+03,     1.081287131936936e+03,     1.081715581017030e+03,     1.082142897593636e+03,     1.082569088426935e+03, 
            1.082994160214546e+03,     1.083418119592314e+03,     1.083840973135082e+03,     1.084262727357456e+03,     1.084683388714549e+03, 
            1.085102963602722e+03,     1.085521458360309e+03,     1.085938879268331e+03,     1.086355232551201e+03,     1.086770524377416e+03, 
            1.087184760860235e+03,     1.087597948058357e+03,     1.088010091976576e+03,     1.088421198566437e+03,     1.088831273726871e+03, 
            1.089240323304832e+03,     1.089648353095914e+03,     1.090055368844967e+03,     1.090461376246694e+03,     1.090866380946254e+03, 
            1.091270388539837e+03,     1.091673404575248e+03,     1.092075434552469e+03,     1.092476483924224e+03,     1.092876558096525e+03, 
            1.093275662429215e+03,     1.093673802236507e+03,     1.094070982787508e+03,     1.094467209306737e+03,     1.094862486974640e+03, 
            1.095256820928094e+03,     1.095650216260900e+03,     1.096042678024278e+03,     1.096434211227345e+03,     1.096824820837597e+03, 
            1.097214511781373e+03,     1.097603288944318e+03,     1.097991157171840e+03,     1.098378121269561e+03,     1.098764186003756e+03, 
            1.099149356101794e+03,     1.099533636252565e+03,     1.099917031106907e+03,     1.100299545278024e+03,     1.100681183341899e+03, 
            1.101061949837702e+03,     1.101441849268190e+03,     1.101820886100103e+03,     1.102199064764556e+03,     1.102576389657423e+03, 
            1.102952865139718e+03,     1.103328495537969e+03,     1.103703285144588e+03,     1.104077238218234e+03,     1.104450358984176e+03, 
            1.104822651634645e+03,     1.105194120329187e+03,     1.105564769195004e+03,     1.105934602327300e+03,     1.106303623789612e+03, 
            1.106671837614148e+03,     1.107039247802108e+03,     1.107405858324013e+03,     1.107771673120017e+03,     1.108136696100229e+03, 
            1.108500931145019e+03,     1.108864382105327e+03,     1.109227052802961e+03,     1.109588947030901e+03,     1.109950068553592e+03, 
            1.110310421107231e+03,     1.110670008400061e+03,     1.111028834112650e+03,     1.111386901898169e+03,     1.111744215382675e+03, 
            1.112100778165376e+03,     1.112456593818907e+03,     1.112811665889591e+03,     1.113165997897705e+03,     1.113519593337733e+03, 
            1.113872455678631e+03,     1.114224588364076e+03,     1.114575994812709e+03,     1.114926678418392e+03,     1.115276642550444e+03, 
            1.115625890553886e+03,     1.115974425749675e+03,     1.116322251434939e+03,     1.116669370883210e+03,     1.117015787344652e+03, 
            1.117361504046288e+03,     1.117706524192221e+03,     1.118050850963854e+03,     1.118394487520113e+03,     1.118737436997655e+03, 
            1.119079702511087e+03,     1.119421287153171e+03,     1.119762193995033e+03,     1.120102426086372e+03,     1.120441986455654e+03, 
            1.120780878110321e+03,     1.121119104036983e+03,     1.121456667201614e+03,     1.121793570549748e+03,     1.122129817006668e+03, 
            1.122465409477594e+03,     1.122800350847869e+03,     1.123134643983145e+03,     1.123468291729562e+03,     1.123801296913933e+03, 
            1.124133662343915e+03,     1.124465390808190e+03,     1.124796485076636e+03,     1.125126947900501e+03,     1.125456782012570e+03, 
            1.125785990127332e+03,     1.126114574941152e+03,     1.126442539132426e+03,     1.126769885361750e+03,     1.127096616272078e+03, 
            1.127422734488878e+03,     1.127748242620294e+03,     1.128073143257294e+03,     1.128397438973828e+03,     1.128721132326978e+03, 
            1.129044225857109e+03,     1.129366722088012e+03,     1.129688623527057e+03,     1.130009932665331e+03,     1.130330651977788e+03, 
            1.130650783923386e+03,     1.130970330945227e+03,     1.131289295470696e+03,     1.131607679911599e+03,     1.131925486664297e+03, 
            1.132242718109841e+03,     1.132559376614103e+03,     1.132875464527908e+03,     1.133190984187163e+03,     1.133505937912985e+03, 
            1.133820328011828e+03,     1.134134156775610e+03,     1.134447426481831e+03,     1.134760139393707e+03,     1.135072297760277e+03, 
            1.135383903816535e+03,     1.135694959783544e+03,     1.136005467868551e+03,     1.136315430265109e+03,     1.136624849153188e+03, 
            1.136933726699287e+03,     1.137242065056555e+03,     1.137549866364891e+03,     1.137857132751064e+03,     1.138163866328815e+03, 
            1.138470069198972e+03,     1.138775743449549e+03,     1.139080891155856e+03,     1.139385514380605e+03,     1.139689615174011e+03, 
            1.139993195573894e+03,     1.140296257605783e+03,     1.140598803283011e+03,     1.140900834606824e+03,     1.141202353566468e+03, 
            1.141503362139294e+03,     1.141803862290852e+03,     1.142103855974986e+03,     1.142403345133925e+03,     1.142702331698385e+03, 
            1.143000817587653e+03,     1.143298804709684e+03,     1.143596294961186e+03,     1.143893290227715e+03,     1.144189792383761e+03, 
            1.144485803292838e+03,     1.144781324807566e+03,     1.145076358769763e+03,     1.145370907010529e+03,     1.145664971350325e+03, 
            1.145958553599064e+03,     1.146251655556189e+03,     1.146544279010758e+03,     1.146836425741521e+03,     1.147128097517003e+03, 
            1.147419296095588e+03,     1.147710023225584e+03,     1.148000280645318e+03,     1.148290070083201e+03,     1.148579393257810e+03
    },
    {
            1.825893234906605e+00,     5.541924068983052e+00,     9.342710866159178e+00,     1.323340016181995e+01,     1.721966247109038e+01, 
            2.130776840478838e+01,     2.550467950796707e+01,     2.981815744229835e+01,     3.425689624751065e+01,     3.883068392378026e+01, 
            4.355060167545312e+01,     4.842927210978783e+01,     5.348117191331289e+01,     5.872303069461448e+01,     6.417434685653288e+01, 
            6.985806532036440e+01,     7.580148370846811e+01,     8.203748856835142e+01,     8.860628123759909e+01,     9.555785285684786e+01, 
            1.029556477865809e+02,     1.108821951294064e+02,     1.194481748325604e+02,     1.288078795462842e+02,     1.391876221417240e+02, 
            1.509434398969870e+02,     1.646965582304607e+02,     7.907613057581810e+02,     7.966328364880037e+02,     8.020097466746663e+02, 
            8.069836888786516e+02,     8.116214970748764e+02,     8.159737233286775e+02,     8.200797030391960e+02,     8.239707462647273e+02, 
            8.276722445552430e+02,     8.312051148898289e+02,     8.345868201770095e+02,     8.378321092919994e+02,     8.409535656176478e+02, 
            8.439620214062123e+02,     8.468668759992912e+02,     8.496763438031703e+02,     8.523976500500811e+02,     8.550371871488974e+02, 
            8.576006408780187e+02,     8.600930932131893e+02,     8.625191068482549e+02,     8.648827952240214e+02,     8.671878809769179e+02, 
            8.694377450537150e+02,     8.716354682424638e+02,     8.737838664958410e+02,     8.758855211382445e+02,     8.779428048289575e+02, 
            8.799579039838019e+02,     8.819328382247646e+02,     8.838694773223448e+02,     8.857695560121490e+02,     8.876346870007624e+02, 
            8.894663724224279e+02,     8.912660139647214e+02,     8.930349218461675e+02,     8.947743227998718e+02,     8.964853671934804e+02, 
            8.981691353961717e+02,     8.998266434870488e+02,     9.014588483857161e+02,     9.030666524744092e+02,     9.046509077714815e+02, 
            9.062124197079269e+02,     9.077519505517841e+02,     9.092702225194174e+02,     9.107679206076971e+02,     9.122456951768492e+02, 
            9.137041643100497e+02,     9.151439159727477e+02,     9.165655099919105e+02,     9.179694798730928e+02,     9.193563344711184e+02, 
            9.207265595284451e+02,     9.220806190936770e+02,     9.234189568313585e+02,     9.247419972329756e+02,     9.260501467380508e+02, 
            9.273437947732829e+02,     9.286233147168953e+02,     9.298890647945852e+02,     9.311413889128972e+02,     9.323806174352097e+02, 
            9.336070679050658e+02,     9.348210457211121e+02,     9.360228447675164e+02,     9.372127480033662e+02,     9.383910280142406e+02, 
            9.395579475288579e+02,     9.407137599034450e+02,     9.418587095762338e+02,     9.429930324942959e+02,     9.441169565147196e+02, 
            9.452307017819899e+02,     9.463344810832451e+02,     9.474285001829729e+02,     9.485129581385659e+02,     9.495880475980540e+02, 
            9.506539550812109e+02,     9.517108612451476e+02,     9.527589411354375e+02,     9.537983644236836e+02,     9.548292956324374e+02, 
            9.558518943482641e+02,     9.568663154236954e+02,     9.578727091687830e+02,     9.588712215328799e+02,     9.598619942772560e+02, 
            9.608451651391015e+02,     9.618208679876794e+02,     9.627892329746090e+02,     9.637503866742165e+02,     9.647044522168577e+02, 
            9.656515494168717e+02,     9.665917948945345e+02,     9.675253020803416e+02,     9.684521817853970e+02,     9.693725411154702e+02, 
            9.702864857950174e+02,     9.711941177800871e+02,     9.720955367851512e+02,     9.729908400419683e+02,     9.738801223840662e+02, 
            9.747634763275909e+02,     9.756409921487140e+02,     9.765127579577616e+02,     9.773788597702545e+02,     9.782393815749892e+02, 
            9.790944053993277e+02,     9.799440113718251e+02,     9.807882777823297e+02,     9.816272811396695e+02,     9.824610962270541e+02, 
            9.832897961552990e+02,     9.841134524139618e+02,     9.849321349360890e+02,     9.857459120817252e+02,     9.865548507813428e+02, 
            9.873590165126553e+02,     9.881584733599118e+02,     9.889532840544570e+02,     9.897435100137848e+02,     9.905292113791746e+02, 
            9.913104470519540e+02,     9.920872747284624e+02,     9.928597509337592e+02,     9.936279310541403e+02,     9.943918693685175e+02, 
            9.951516190786873e+02,     9.959072323385658e+02,     9.966587602824085e+02,     9.974062530520721e+02,     9.981497598233509e+02, 
            9.988893288314268e+02,     9.996250073954698e+02,     1.000356841942422e+03,     1.001084878030001e+03,     1.001809160368950e+03, 
            1.002529732844564e+03,     1.003246638537526e+03,     1.003959919744075e+03,     1.004669617995528e+03,     1.005375774049576e+03, 
            1.006078428020931e+03,     1.006777619227670e+03,     1.007473386324731e+03,     1.008165767290977e+03,     1.008854799445356e+03, 
            1.009540519462570e+03,     1.010222963388276e+03,     1.010902166653831e+03,     1.011578164090596e+03,     1.012250989943819e+03, 
            1.012920677886115e+03,     1.013587261030547e+03,     1.014250771943323e+03,     1.014911242656146e+03,     1.015568704678192e+03, 
            1.016223189007752e+03,     1.016874726143552e+03,     1.017523346095746e+03,     1.018169078396608e+03,     1.018811952110925e+03, 
            1.019451995846100e+03,     1.020089237761990e+03,     1.020723705580455e+03,     1.021355426594670e+03,     1.021984427678172e+03, 
            1.022610735293671e+03,     1.023234375501623e+03,     1.023855373968578e+03,     1.024473755975310e+03,     1.025089546424724e+03, 
            1.025702769849578e+03,     1.026313450419983e+03,     1.026921611950719e+03,     1.027527277908369e+03,     1.028130471418265e+03, 
            1.028731215271254e+03,     1.029329531930311e+03,     1.029925443536964e+03,     1.030518971917573e+03,     1.031110138589453e+03, 
            1.031698964766841e+03,     1.032285471366722e+03,     1.032869679014504e+03,     1.033451608049571e+03,     1.034031278530684e+03, 
            1.034608710241268e+03,     1.035183922694562e+03,     1.035756935138652e+03,     1.036327766561384e+03,     1.036896435695164e+03, 
            1.037462961021637e+03,     1.038027360776270e+03,     1.038589652952818e+03,     1.039149855307697e+03,     1.039707985364242e+03, 
            1.040264060416886e+03,     1.040818097535233e+03,     1.041370113568036e+03,     1.041920125147100e+03,     1.042468148691084e+03, 
            1.043014199895816e+03,     1.043558295775421e+03,     1.044100451633572e+03,     1.044640683072755e+03,     1.045179005500116e+03, 
            1.045715434130801e+03,     1.046249983991204e+03,     1.046782669922167e+03,     1.047313506582094e+03,     1.047842508450010e+03, 
            1.048369689828546e+03,     1.048895064846870e+03,     1.049418647463548e+03,     1.049940451469355e+03,     1.050460490516999e+03, 
            1.050978778014776e+03,     1.051495327294453e+03,     1.052010151502522e+03,     1.052523263630857e+03,     1.053034676519188e+03, 
            1.053544402857525e+03,     1.054052455188541e+03,     1.054558845909894e+03,     1.055063587276510e+03,     1.055566691402821e+03, 
            1.056068170264954e+03,     1.056568035702887e+03,     1.057066299422541e+03,     1.057562972997864e+03,     1.058058067872838e+03, 
            1.058551595363474e+03,     1.059043566659758e+03,     1.059533992827556e+03,     1.060022884810494e+03,     1.060510253431788e+03, 
            1.060996109396048e+03,     1.061480463291048e+03,     1.061963325589459e+03,     1.062444706650549e+03,     1.062924616721857e+03, 
            1.063403065940826e+03,     1.063880064336418e+03,     1.064355621830687e+03,     1.064829748240330e+03,     1.065302453278213e+03, 
            1.065773746554854e+03,     1.066243637579899e+03,     1.066712135763555e+03,     1.067179250418007e+03,     1.067644990758805e+03, 
            1.068109365906226e+03,     1.068572384886612e+03,     1.069034056633689e+03,     1.069494389989854e+03,     1.069953393707447e+03, 
            1.070411076449996e+03,     1.070867446793440e+03,     1.071322513227337e+03,     1.071776284156041e+03,     1.072228767899867e+03, 
            1.072679972696232e+03,     1.073129906700778e+03,     1.073578577988472e+03,     1.074025994554694e+03,     1.074472164316298e+03, 
            1.074917095112668e+03,     1.075360794706733e+03,     1.075803270785999e+03,     1.076244530963525e+03,     1.076684582778918e+03, 
            1.077123433699284e+03,     1.077561091120183e+03,     1.077997562366555e+03,     1.078432854693637e+03,     1.078866975287865e+03, 
            1.079299931267757e+03,     1.079731729684789e+03,     1.080162377524246e+03,     1.080591881706073e+03,     1.081020249085700e+03, 
            1.081447486454858e+03,     1.081873600542384e+03,     1.082298598015015e+03,     1.082722485478159e+03,     1.083145269476667e+03, 
            1.083566956495583e+03,     1.083987552960886e+03,     1.084407065240224e+03,     1.084825499643627e+03,     1.085242862424218e+03, 
            1.085659159778909e+03,     1.086074397849085e+03,     1.086488582721285e+03,     1.086901720427857e+03,     1.087313816947621e+03, 
            1.087724878206509e+03,     1.088134910078204e+03,     1.088543918384760e+03,     1.088951908897221e+03,     1.089358887336225e+03, 
            1.089764859372605e+03,     1.090169830627973e+03,     1.090573806675304e+03,     1.090976793039502e+03,     1.091378795197965e+03, 
            1.091779818581141e+03,     1.092179868573069e+03,     1.092578950511923e+03,     1.092977069690535e+03,     1.093374231356925e+03, 
            1.093770440714809e+03,     1.094165702924109e+03,     1.094560023101454e+03,     1.094953406320671e+03,     1.095345857613270e+03, 
            1.095737381968923e+03,     1.096127984335939e+03,     1.096517669621723e+03,     1.096906442693240e+03,     1.097294308377464e+03, 
            1.097681271461822e+03,     1.098067336694638e+03,     1.098452508785562e+03,     1.098836792405999e+03,     1.099220192189529e+03, 
            1.099602712732323e+03,     1.099984358593551e+03,     1.100365134295790e+03,     1.100745044325415e+03,     1.101124093132998e+03, 
            1.101502285133694e+03,     1.101879624707620e+03,     1.102256116200235e+03,     1.102631763922712e+03,     1.103006572152302e+03, 
            1.103380545132696e+03,     1.103753687074387e+03,     1.104126002155014e+03,     1.104497494519716e+03,     1.104868168281471e+03, 
            1.105238027521433e+03,     1.105607076289273e+03,     1.105975318603499e+03,     1.106342758451787e+03,     1.106709399791298e+03, 
            1.107075246548998e+03,     1.107440302621964e+03,     1.107804571877703e+03,     1.108168058154442e+03,     1.108530765261441e+03, 
            1.108892696979281e+03,     1.109253857060163e+03,     1.109614249228187e+03,     1.109973877179650e+03,     1.110332744583314e+03, 
            1.110690855080696e+03,     1.111048212286333e+03,     1.111404819788054e+03,     1.111760681147256e+03,     1.112115799899155e+03, 
            1.112470179553057e+03,     1.112823823592607e+03,     1.113176735476052e+03,     1.113528918636483e+03,     1.113880376482090e+03, 
            1.114231112396403e+03,     1.114581129738532e+03,     1.114930431843410e+03,     1.115279022022026e+03,     1.115626903561659e+03, 
            1.115974079726107e+03,     1.116320553755913e+03,     1.116666328868595e+03,     1.117011408258859e+03,     1.117355795098825e+03, 
            1.117699492538241e+03,     1.118042503704693e+03,     1.118384831703823e+03,     1.118726479619533e+03,     1.119067450514193e+03, 
            1.119407747428842e+03,     1.119747373383390e+03,     1.120086331376821e+03,     1.120424624387384e+03,     1.120762255372787e+03, 
            1.121099227270395e+03,     1.121435542997412e+03,     1.121771205451073e+03,     1.122106217508827e+03,     1.122440582028521e+03, 
            1.122774301848581e+03,     1.123107379788189e+03,     1.123439818647461e+03,     1.123771621207622e+03,     1.124102790231176e+03, 
            1.124433328462080e+03,     1.124763238625912e+03,     1.125092523430032e+03,     1.125421185563756e+03,     1.125749227698512e+03, 
            1.126076652488004e+03,     1.126403462568370e+03,     1.126729660558340e+03,     1.127055249059392e+03,     1.127380230655902e+03, 
            1.127704607915306e+03,     1.128028383388235e+03,     1.128351559608680e+03,     1.128674139094127e+03,     1.128996124345710e+03, 
            1.129317517848348e+03,     1.129638322070895e+03,     1.129958539466274e+03,     1.130278172471620e+03,     1.130597223508415e+03, 
            1.130915694982625e+03,     1.131233589284836e+03,     1.131550908790387e+03,     1.131867655859497e+03,     1.132183832837400e+03, 
            1.132499442054474e+03,     1.132814485826366e+03,     1.133128966454117e+03,     1.133442886224290e+03,     1.133756247409092e+03, 
            1.134069052266496e+03,     1.134381303040358e+03,     1.134693001960543e+03,     1.135004151243040e+03,     1.135314753090075e+03, 
            1.135624809690236e+03,     1.135934323218575e+03,     1.136243295836733e+03,     1.136551729693044e+03,     1.136859626922648e+03, 
            1.137166989647604e+03,     1.137473819976993e+03,     1.137780120007029e+03,     1.138085891821163e+03,     1.138391137490191e+03, 
            1.138695859072355e+03,     1.139000058613449e+03,     1.139303738146916e+03,     1.139606899693953e+03,     1.139909545263613e+03, 
            1.140211676852895e+03,     1.140513296446852e+03,     1.140814406018680e+03,     1.141115007529819e+03,     1.141415102930042e+03, 
            1.141714694157556e+03,     1.142013783139090e+03,     1.142312371789987e+03,     1.142610462014298e+03,     1.142908055704867e+03, 
            1.143205154743429e+03,     1.143501761000686e+03,     1.143797876336406e+03,     1.144093502599502e+03,     1.144388641628123e+03, 
            1.144683295249731e+03,     1.144977465281196e+03,     1.145271153528869e+03,     1.145564361788669e+03,     1.145857091846165e+03, 
            1.146149345476656e+03,     1.146441124445250e+03,     1.146732430506942e+03,     1.147023265406697e+03,     1.147313630879521e+03
    },
    {
            1.822056273692837e+00,     5.529852149181162e+00,     9.321596259277472e+00,     1.320234051147560e+01,     1.717764606105522e+01, 
            2.125365648240262e+01,     2.543718492790997e+01,     2.973581867230372e+01,     3.415804547181734e+01,     3.871340755754012e+01, 
            4.341269101029715e+01,     4.826816096567276e+01,     5.329385694671222e+01,     5.850596820339873e+01,     6.392331719189642e+01, 
            6.956799180050827e+01,     7.546618624558636e+01,     8.164934130530311e+01,     8.815572504649472e+01,     9.503268113575416e+01, 
            1.023399243250901e+02,     1.101545469646953e+02,     1.185789620811261e+02,     1.277542022772898e+02,     1.378837674153845e+02, 
            1.492804707277539e+02,     1.624710555707170e+02,     1.784810134256831e+02,     7.885822865940163e+02,     7.944558519602856e+02, 
            7.998406718143583e+02,     8.048259630668452e+02,     8.094771592947134e+02,     8.138439617067285e+02,     8.179651680511837e+02, 
            8.218717392231547e+02,     8.255888359326156e+02,     8.291372210923957e+02,     8.325342546697855e+02,     8.357946173426127e+02, 
            8.389308482800502e+02,     8.419537522698769e+02,     8.448727129791109e+02,     8.476959374743390e+02,     8.504306495435296e+02, 
            8.530832443052790e+02,     8.556594131475189e+02,     8.581642456458441e+02,     8.606023134215466e+02,     8.629777396861075e+02, 
            8.652942573355606e+02,     8.675552578064322e+02,     8.697638324185057e+02,     8.719228075623924e+02,     8.740347748099100e+02, 
            8.761021168097176e+02,     8.781270296632464e+02,     8.801115423449342e+02,     8.820575336273481e+02,     8.839667468896063e+02, 
            8.858408031217596e+02,     8.876812123848788e+02,     8.894893839436476e+02,     8.912666352533940e+02,     8.930141999548404e+02, 
            8.947332350062775e+02,     8.964248270634237e+02,     8.980899982010061e+02,     8.997297110565756e+02,     9.013448734657539e+02, 
            9.029363426485721e+02,     9.045049289984886e+02,     9.060513995188608e+02,     9.075764809458267e+02,     9.090808625915882e+02, 
            9.105651989378528e+02,     9.120301120055224e+02,     9.134761935235888e+02,     9.149040069174691e+02,     9.163140891346726e+02, 
            9.177069523236297e+02,     9.190830853797444e+02,     9.204429553711758e+02,     9.217870088554967e+02,     9.231156730971668e+02, 
            9.244293571947380e+02,     9.257284531257689e+02,     9.270133367165951e+02,     9.282843685434264e+02,     9.295418947705457e+02, 
            9.307862479308725e+02,     9.320177476535996e+02,     9.332367013431967e+02,     9.344434048136734e+02,     9.356381428815979e+02, 
            9.368211899210968e+02,     9.379928103837390e+02,     9.391532592859614e+02,     9.403027826664568e+02,     9.414416180157452e+02, 
            9.425699946799344e+02,     9.436881342405501e+02,     9.447962508721117e+02,     9.458945516790203e+02,     9.469832370131998e+02, 
            9.480625007737964e+02,     9.491325306901545e+02,     9.501935085891905e+02,     9.512456106481889e+02,     9.522890076339792e+02, 
            9.533238651293665e+02,     9.543503437476343e+02,     9.553685993358764e+02,     9.563787831678476e+02,     9.573810421269839e+02, 
            9.583755188801999e+02,     9.593623520430335e+02,     9.603416763379061e+02,     9.613136227444264e+02,     9.622783186397899e+02, 
            9.632358879338631e+02,     9.641864511980281e+02,     9.651301257879695e+02,     9.660670258482380e+02,     9.669972624700375e+02, 
            9.679209445684947e+02,     9.688381774720478e+02,     9.697490641046911e+02,     9.706537048020888e+02,     9.715521974005084e+02, 
            9.724446373218850e+02,     9.733311176552294e+02,     9.742117292345762e+02,     9.750865607136224e+02,     9.759556986372630e+02, 
            9.768192275101413e+02,     9.776772298623940e+02,     9.785297863127091e+02,     9.793769756288458e+02,     9.802188747857138e+02, 
            9.810555590211706e+02,     9.818871018895986e+02,     9.827135753134060e+02,     9.835350496480359e+02,     9.843515936661009e+02, 
            9.851632747006690e+02,     9.859701586226900e+02,     9.867723099005017e+02,     9.875697916406665e+02,     9.883626656272979e+02, 
            9.891509923599518e+02,     9.899348310901389e+02,     9.907142398565279e+02,     9.914892755188881e+02,     9.922599937908257e+02, 
            9.930264492713748e+02,     9.937886954754822e+02,     9.945467848634314e+02,     9.953007688692637e+02,     9.960506979282217e+02, 
            9.967966215032627e+02,     9.975385881106884e+02,     9.982766453449060e+02,     9.990108399023778e+02,     9.997412176047798e+02, 
            1.000467823421400e+03,     1.001190701490814e+03,     1.001909895141862e+03,     1.002625446913946e+03,     1.003337398549629e+03, 
            1.004045791123750e+03,     1.004750664893891e+03,     1.005452059432220e+03,     1.006150013613790e+03,     1.006844565633318e+03, 
            1.007535753021448e+03,     1.008223612660538e+03,     1.008908180799952e+03,     1.009589493070907e+03,     1.010267584500873e+03, 
            1.010942489527550e+03,     1.011614242012431e+03,     1.012282875253975e+03,     1.012948422000392e+03,     1.013610914462064e+03, 
            1.014270384323611e+03,     1.014926862755610e+03,     1.015580380425984e+03,     1.016230967511070e+03,     1.016878653706387e+03, 
            1.017523468237086e+03,     1.018165439868133e+03,     1.018804596914194e+03,     1.019440967249269e+03,     1.020074578316044e+03, 
            1.020705457135010e+03,     1.021333630313327e+03,     1.021959124053453e+03,     1.022581964161545e+03,     1.023202176055647e+03, 
            1.023819784773646e+03,     1.024434814981039e+03,     1.025047290978485e+03,     1.025657236709175e+03,     1.026264675766003e+03, 
            1.026869631398558e+03,     1.027472126519941e+03,     1.028072183713411e+03,     1.028669825238855e+03,     1.029265073039113e+03, 
            1.029857948746130e+03,     1.030448473686972e+03,     1.031036668889678e+03,     1.031622555088981e+03,     1.032206152731892e+03, 
            1.032787481983136e+03,     1.033366562730472e+03,     1.033943414589875e+03,     1.034518056910609e+03,     1.035090508780158e+03, 
            1.035660789029065e+03,     1.036228916235639e+03,     1.036794908730569e+03,     1.037358784601414e+03,     1.037920561697003e+03, 
            1.038480257631727e+03,     1.039037889789737e+03,     1.039593475329046e+03,     1.040147031185532e+03,     1.040698574076864e+03, 
            1.041248119990612e+03,     1.041795686234534e+03,     1.042341288394621e+03,     1.042884942353154e+03,     1.043426663792530e+03, 
            1.043966468198680e+03,     1.044504370864428e+03,     1.045040386892766e+03,     1.045574531200065e+03,     1.046106818519218e+03, 
            1.046637263402706e+03,     1.047165880252798e+03,     1.047692683214643e+03,     1.048217686345644e+03,     1.048740903506108e+03, 
            1.049262348390351e+03,     1.049782034529415e+03,     1.050299975293708e+03,     1.050816183895603e+03,     1.051330673391981e+03, 
            1.051843456686724e+03,     1.052354546533149e+03,     1.052863955536404e+03,     1.053371696155810e+03,     1.053877780707151e+03, 
            1.054382221364935e+03,     1.054885030164586e+03,     1.055386219004618e+03,     1.055885799648743e+03,     1.056383783727958e+03, 
            1.056880182742577e+03,     1.057375008064226e+03,     1.057868270937808e+03,     1.058359982483420e+03,     1.058850153698236e+03, 
            1.059338795458357e+03,     1.059825918520625e+03,     1.060311533524397e+03,     1.060795650993294e+03,     1.061278281336912e+03, 
            1.061759434852500e+03,     1.062239121726611e+03,     1.062717352036717e+03,     1.063194135752800e+03,     1.063669482738911e+03, 
            1.064143402754695e+03,     1.064615905456899e+03,     1.065087000400845e+03,     1.065556697041874e+03,     1.066025004736775e+03, 
            1.066491932745173e+03,     1.066957490230908e+03,     1.067421686263377e+03,     1.067884529818855e+03,     1.068346029781799e+03, 
            1.068806194946123e+03,     1.069265034016448e+03,     1.069722555609339e+03,     1.070178768254511e+03,     1.070633680396024e+03, 
            1.071087300393440e+03,     1.071539636522987e+03,     1.071990696978677e+03,     1.072440489873417e+03,     1.072889023240102e+03, 
            1.073336305032685e+03,     1.073782343127232e+03,     1.074227145322955e+03,     1.074670719343233e+03,     1.075113072836613e+03, 
            1.075554213377795e+03,     1.075994148468597e+03,     1.076432885538914e+03,     1.076870431947644e+03,     1.077306794983621e+03, 
            1.077741981866510e+03,     1.078175999747705e+03,     1.078608855711205e+03,     1.079040556774471e+03,     1.079471109889282e+03, 
            1.079900521942560e+03,     1.080328799757203e+03,     1.080755950092884e+03,     1.081181979646847e+03,     1.081606895054695e+03, 
            1.082030702891154e+03,     1.082453409670836e+03,     1.082875021848979e+03,     1.083295545822189e+03,     1.083714987929154e+03, 
            1.084133354451364e+03,     1.084550651613806e+03,     1.084966885585653e+03,     1.085382062480948e+03,     1.085796188359270e+03, 
            1.086209269226387e+03,     1.086621311034916e+03,     1.087032319684948e+03,     1.087442301024686e+03,     1.087851260851063e+03, 
            1.088259204910345e+03,     1.088666138898741e+03,     1.089072068462987e+03,     1.089476999200934e+03,     1.089880936662117e+03, 
            1.090283886348328e+03,     1.090685853714163e+03,     1.091086844167583e+03,     1.091486863070442e+03,     1.091885915739030e+03, 
            1.092284007444595e+03,     1.092681143413859e+03,     1.093077328829527e+03,     1.093472568830797e+03,     1.093866868513845e+03, 
            1.094260232932320e+03,     1.094652667097823e+03,     1.095044175980385e+03,     1.095434764508926e+03,     1.095824437571725e+03, 
            1.096213200016871e+03,     1.096601056652708e+03,     1.096988012248280e+03,     1.097374071533769e+03,     1.097759239200917e+03, 
            1.098143519903455e+03,     1.098526918257520e+03,     1.098909438842064e+03,     1.099291086199263e+03,     1.099671864834914e+03, 
            1.100051779218835e+03,     1.100430833785248e+03,     1.100809032933168e+03,     1.101186381026780e+03,     1.101562882395814e+03, 
            1.101938541335911e+03,     1.102313362108989e+03,     1.102687348943602e+03,     1.103060506035291e+03,     1.103432837546938e+03, 
            1.103804347609106e+03,     1.104175040320381e+03,     1.104544919747708e+03,     1.104913989926720e+03,     1.105282254862066e+03, 
            1.105649718527735e+03,     1.106016384867369e+03,     1.106382257794583e+03,     1.106747341193269e+03,     1.107111638917907e+03, 
            1.107475154793865e+03,     1.107837892617694e+03,     1.108199856157423e+03,     1.108561049152857e+03,     1.108921475315851e+03, 
            1.109281138330599e+03,     1.109640041853918e+03,     1.109998189515512e+03,     1.110355584918258e+03,     1.110712231638462e+03, 
            1.111068133226133e+03,     1.111423293205241e+03,     1.111777715073975e+03,     1.112131402305003e+03,     1.112484358345720e+03, 
            1.112836586618496e+03,     1.113188090520927e+03,     1.113538873426074e+03,     1.113888938682704e+03,     1.114238289615528e+03, 
            1.114586929525432e+03,     1.114934861689711e+03,     1.115282089362299e+03,     1.115628615773986e+03,     1.115974444132655e+03, 
            1.116319577623486e+03,     1.116664019409186e+03,     1.117007772630198e+03,     1.117350840404913e+03,     1.117693225829883e+03, 
            1.118034931980024e+03,     1.118375961908824e+03,     1.118716318648543e+03,     1.119056005210413e+03,     1.119395024584838e+03, 
            1.119733379741585e+03,     1.120071073629980e+03,     1.120408109179096e+03,     1.120744489297946e+03,     1.121080216875660e+03, 
            1.121415294781680e+03,     1.121749725865933e+03,     1.122083512959013e+03,     1.122416658872362e+03,     1.122749166398443e+03, 
            1.123081038310909e+03,     1.123412277364783e+03,     1.123742886296620e+03,     1.124072867824680e+03,     1.124402224649089e+03, 
            1.124730959452007e+03,     1.125059074897784e+03,     1.125386573633129e+03,     1.125713458287258e+03,     1.126039731472057e+03, 
            1.126365395782236e+03,     1.126690453795479e+03,     1.127014908072598e+03,     1.127338761157681e+03,     1.127662015578238e+03, 
            1.127984673845354e+03,     1.128306738453825e+03,     1.128628211882306e+03,     1.128949096593451e+03,     1.129269395034053e+03, 
            1.129589109635182e+03,     1.129908242812322e+03,     1.130226796965505e+03,     1.130544774479448e+03,     1.130862177723681e+03, 
            1.131179009052679e+03,     1.131495270805996e+03,     1.131810965308387e+03,     1.132126094869935e+03,     1.132440661786181e+03, 
            1.132754668338246e+03,     1.133068116792949e+03,     1.133381009402933e+03,     1.133693348406787e+03,     1.134005136029158e+03, 
            1.134316374480873e+03,     1.134627065959054e+03,     1.134937212647234e+03,     1.135246816715469e+03,     1.135555880320450e+03, 
            1.135864405605618e+03,     1.136172394701272e+03,     1.136479849724675e+03,     1.136786772780166e+03,     1.137093165959267e+03, 
            1.137399031340785e+03,     1.137704370990920e+03,     1.138009186963365e+03,     1.138313481299413e+03,     1.138617256028053e+03, 
            1.138920513166076e+03,     1.139223254718169e+03,     1.139525482677016e+03,     1.139827199023395e+03,     1.140128405726275e+03, 
            1.140429104742906e+03,     1.140729298018922e+03,     1.141028987488428e+03,     1.141328175074093e+03,     1.141626862687246e+03, 
            1.141925052227960e+03,     1.142222745585145e+03,     1.142519944636636e+03,     1.142816651249285e+03,     1.143112867279038e+03, 
            1.143408594571033e+03,     1.143703834959676e+03,     1.143998590268729e+03,     1.144292862311396e+03,     1.144586652890400e+03, 
            1.144879963798069e+03,     1.145172796816417e+03,     1.145465153717221e+03,     1.145757036262106e+03,     1.146048446202617e+03
    },
    {
            1.818235712245263e+00,     5.517835694614562e+00,     9.300585850418617e+00,     1.317144540117103e+01,     1.713586853104875e+01, 
            2.119987473366300e+01,     2.537013244959383e+01,     2.965405918337814e+01,     3.405994224408775e+01,     3.859708553613259e+01, 
            4.327598959886954e+01,     4.810857456522815e+01,     5.310845921425297e+01,     5.829131434763605e+01,     6.367531615135163e+01, 
            6.928173635928130e+01,     7.513572318162190e+01,     8.126735401979720e+01,     8.771308499376346e+01,     9.451779636999854e+01, 
            1.017377626872959e+02,     1.094451144046837e+02,     1.177348194163403e+02,     1.267361709367087e+02,     1.366329291451791e+02, 
            1.477016975263736e+02,     1.603939162467288e+02,     1.755436656418592e+02,     7.799670194417342e+02,     7.864449136083664e+02, 
            7.923173673009472e+02,     7.977073314683838e+02,     8.027015571152729e+02,     8.073640295719804e+02,     8.117435528125123e+02, 
            8.158783467652817e+02,     8.197989896519698e+02,     8.235303837299252e+02,     8.270931151393897e+02,     8.305044221874288e+02, 
            8.337789018513836e+02,     8.369290361760968e+02,     8.399655916703719e+02,     8.428979272149294e+02,     8.457342348157530e+02, 
            8.484817302381726e+02,     8.511468056761697e+02,     8.537351532773049e+02,     8.562518660225753e+02,     8.587015208168203e+02, 
            8.610882474630763e+02,     8.634157863321429e+02,     8.656875369014774e+02,     8.679065988613675e+02,     8.700758071263342e+02, 
            8.721977618149043e+02,     8.742748540491756e+02,     8.763092882608906e+02,     8.783031015617639e+02,     8.802581806339023e+02, 
            8.821762765150838e+02,     8.840590175888144e+02,     8.859079210367232e+02,     8.877244029685183e+02,     8.895097874101273e+02, 
            8.912653143023264e+02,     8.929921466388399e+02,     8.946913768535502e+02,     8.963640325504235e+02,     8.980110816563123e+02, 
            8.996334370655728e+02,     9.012319608359364e+02,     9.028074679870839e+02,     9.043607299465848e+02,     9.058924776820483e+02, 
            9.074034045534535e+02,     9.088941689153327e+02,     9.103653964948885e+02,     9.118176825689943e+02,     9.132515939602763e+02, 
            9.146676708701827e+02,     9.160664285648763e+02,     9.174483589279970e+02,     9.188139318928304e+02,     9.201635967650227e+02, 
            9.214977834458093e+02,     9.228169035646652e+02,     9.241213515293817e+02,     9.254115055007320e+02,     9.266877282981943e+02, 
            9.279503682425354e+02,     9.291997599405181e+02,     9.304362250164676e+02,     9.316600727949907e+02,     9.328716009387512e+02, 
            9.340710960448179e+02,     9.352588342028174e+02,     9.364350815177991e+02,     9.376000946004847e+02,     9.387541210273370e+02, 
            9.398973997726553e+02,     9.410301616147528e+02,     9.421526295180523e+02,     9.432650189928269e+02,     9.443675384341365e+02, 
            9.454603894414065e+02,     9.465437671199782e+02,     9.476178603658310e+02,     9.486828521346237e+02,     9.497389196960631e+02, 
            9.507862348745912e+02,     9.518249642772327e+02,     9.528552695094664e+02,     9.538773073798400e+02,     9.548912300940524e+02, 
            9.558971854391438e+02,     9.568953169584086e+02,     9.578857641180153e+02,     9.588686624670158e+02,     9.598441437863411e+02, 
            9.608123362310637e+02,     9.617733644665168e+02,     9.627273497979736e+02,     9.636744102942438e+02,     9.646146607929448e+02, 
            9.655482129577293e+02,     9.664751765335402e+02,     9.673956574089527e+02,     9.683097591278963e+02,     9.692175826293276e+02, 
            9.701192263367300e+02,     9.710147862437530e+02,     9.719043559961488e+02,     9.727880269702267e+02,     9.736658883479954e+02, 
            9.745380271891557e+02,     9.754045285001127e+02,     9.762654753001481e+02,     9.771209486848936e+02,     9.779710278872471e+02, 
            9.788157903358425e+02,     9.796553117112045e+02,     9.804896659996847e+02,     9.813189255452985e+02,     9.821431611149358e+02, 
            9.829624418833187e+02,     9.837768355758095e+02,     9.845864084466498e+02,     9.853912253386258e+02,     9.861913497241565e+02, 
            9.869868437448882e+02,     9.877777682498311e+02,     9.885641828321116e+02,     9.893461458644069e+02,     9.901237145331087e+02, 
            9.908969448712751e+02,     9.916658917904281e+02,     9.924306091112356e+02,     9.931911495931322e+02,     9.939475649629192e+02, 
            9.946999059423938e+02,     9.954482222750324e+02,     9.961925627517863e+02,     9.969329752360053e+02,     9.976695066875435e+02, 
            9.984022031860650e+02,     9.991311099535949e+02,     9.998562713763274e+02,     1.000577731025740e+03,     1.001295531652569e+03, 
            1.002009715314223e+03,     1.002720323229693e+03,     1.003427395909578e+03,     1.004130973145678e+03,     1.004831094028429e+03, 
            1.005527796963783e+03,     1.006221119689585e+03,     1.006911099291452e+03,     1.007597772218173e+03,     1.008281174296642e+03, 
            1.008961340746355e+03,     1.009638306193477e+03,     1.010312104684489e+03,     1.010982769699447e+03,     1.011650334164849e+03, 
            1.012314830466135e+03,     1.012976290459828e+03,     1.013634745485327e+03,     1.014290226376371e+03,     1.014942763472183e+03, 
            1.015592386628287e+03,     1.016239125227049e+03,     1.016883008187903e+03,     1.017524063977316e+03,     1.018162320618466e+03, 
            1.018797805700670e+03,     1.019430546388545e+03,     1.020060569430939e+03,     1.020687901169607e+03,     1.021312567547674e+03, 
            1.021934594117859e+03,     1.022554006050497e+03,     1.023170828141345e+03,     1.023785084819186e+03,     1.024396800153240e+03, 
            1.025005997860383e+03,     1.025612701312186e+03,     1.026216933541766e+03,     1.026818717250480e+03,     1.027418074814434e+03, 
            1.028015028290846e+03,     1.028609599424237e+03,     1.029201809652481e+03,     1.029791680112699e+03,     1.030379231647014e+03, 
            1.030964484808162e+03,     1.031547459864974e+03,     1.032128176807718e+03,     1.032706655353319e+03,     1.033282914950460e+03, 
            1.033856974784545e+03,     1.034428853782566e+03,     1.034998570617845e+03,     1.035566143714662e+03,     1.036131591252791e+03, 
            1.036694931171911e+03,     1.037256181175936e+03,     1.037815358737229e+03,     1.038372481100734e+03,     1.038927565288006e+03, 
            1.039480627583327e+03,     1.040031685592362e+03,     1.040580755188183e+03,     1.041127852537342e+03,     1.041672993601856e+03, 
            1.042216194142729e+03,     1.042757469723406e+03,     1.043296835713134e+03,     1.043834307317648e+03,     1.044369899471755e+03, 
            1.044903627010204e+03,     1.045435504557771e+03,     1.045965546560841e+03,     1.046493767290380e+03,     1.047020180844825e+03, 
            1.047544801152929e+03,     1.048067641976542e+03,     1.048588716913326e+03,     1.049108039399430e+03,     1.049625622712093e+03, 
            1.050141479972205e+03,     1.050655624146816e+03,     1.051168068051584e+03,     1.051678824353183e+03,     1.052187905571662e+03, 
            1.052695324082747e+03,     1.053201092120113e+03,     1.053705221777597e+03,     1.054207725011372e+03,     1.054708613642081e+03, 
            1.055207899356925e+03,     1.055705593711715e+03,     1.056201708132875e+03,     1.056696253919418e+03,     1.057189242244875e+03, 
            1.057680684159191e+03,     1.058170590590583e+03,     1.058658972347365e+03,     1.059145840119736e+03,     1.059631204481532e+03, 
            1.060115075891955e+03,     1.060597464697253e+03,     1.061078381132387e+03,     1.061557835322655e+03,     1.062035837285285e+03, 
            1.062512396931012e+03,     1.062987524065607e+03,     1.063461228391395e+03,     1.063933519508733e+03,     1.064404406917471e+03, 
            1.064873900018378e+03,     1.065342008114549e+03,     1.065808740412784e+03,     1.066274106024936e+03,     1.066738113969255e+03, 
            1.067200773171677e+03,     1.067662092467124e+03,     1.068122080600754e+03,     1.068580746229202e+03,     1.069038097921804e+03, 
            1.069494144161782e+03,     1.069948893347429e+03,     1.070402353793258e+03,     1.070854533731139e+03,     1.071305441311415e+03, 
            1.071755084603998e+03,     1.072203471599448e+03,     1.072650610210030e+03,     1.073096508270759e+03,     1.073541173540422e+03, 
            1.073984613702586e+03,     1.074426836366587e+03,     1.074867849068505e+03,     1.075307659272120e+03,     1.075746274369855e+03, 
            1.076183701683703e+03,     1.076619948466134e+03,     1.077055021900996e+03,     1.077488929104393e+03,     1.077921677125553e+03, 
            1.078353272947681e+03,     1.078783723488801e+03,     1.079213035602575e+03,     1.079641216079123e+03,     1.080068271645819e+03, 
            1.080494208968076e+03,     1.080919034650126e+03,     1.081342755235777e+03,     1.081765377209164e+03,     1.082186906995489e+03, 
            1.082607350961748e+03,     1.083026715417443e+03,     1.083445006615291e+03,     1.083862230751913e+03,     1.084278393968523e+03, 
            1.084693502351590e+03,     1.085107561933511e+03,     1.085520578693254e+03,     1.085932558557006e+03,     1.086343507398803e+03, 
            1.086753431041148e+03,     1.087162335255633e+03,     1.087570225763536e+03,     1.087977108236416e+03,     1.088382988296704e+03, 
            1.088787871518277e+03,     1.089191763427022e+03,     1.089594669501407e+03,     1.089996595173023e+03,     1.090397545827131e+03, 
            1.090797526803203e+03,     1.091196543395440e+03,     1.091594600853302e+03,     1.091991704382013e+03,     1.092387859143073e+03, 
            1.092783070254750e+03,     1.093177342792578e+03,     1.093570681789830e+03,     1.093963092238008e+03,     1.094354579087301e+03, 
            1.094745147247059e+03,     1.095134801586242e+03,     1.095523546933872e+03,     1.095911388079480e+03,     1.096298329773542e+03, 
            1.096684376727909e+03,     1.097069533616236e+03,     1.097453805074399e+03,     1.097837195700908e+03,     1.098219710057321e+03, 
            1.098601352668638e+03,     1.098982128023705e+03,     1.099362040575602e+03,     1.099741094742031e+03,     1.100119294905693e+03, 
            1.100496645414672e+03,     1.100873150582793e+03,     1.101248814690001e+03,     1.101623641982712e+03,     1.101997636674174e+03, 
            1.102370802944816e+03,     1.102743144942594e+03,     1.103114666783334e+03,     1.103485372551069e+03,     1.103855266298370e+03, 
            1.104224352046678e+03,     1.104592633786623e+03,     1.104960115478348e+03,     1.105326801051822e+03,     1.105692694407154e+03, 
            1.106057799414898e+03,     1.106422119916355e+03,     1.106785659723878e+03,     1.107148422621161e+03,     1.107510412363536e+03, 
            1.107871632678258e+03,     1.108232087264789e+03,     1.108591779795082e+03,     1.108950713913855e+03,     1.109308893238864e+03, 
            1.109666321361176e+03,     1.110023001845433e+03,     1.110378938230120e+03,     1.110734134027815e+03,     1.111088592725458e+03, 
            1.111442317784597e+03,     1.111795312641640e+03,     1.112147580708101e+03,     1.112499125370847e+03,     1.112849949992337e+03, 
            1.113200057910861e+03,     1.113549452440777e+03,     1.113898136872736e+03,     1.114246114473921e+03,     1.114593388488271e+03, 
            1.114939962136699e+03,     1.115285838617321e+03,     1.115631021105669e+03,     1.115975512754910e+03,     1.116319316696059e+03, 
            1.116662436038188e+03,     1.117004873868634e+03,     1.117346633253209e+03,     1.117687717236398e+03,     1.118028128841560e+03, 
            1.118367871071132e+03,     1.118706946906820e+03,     1.119045359309792e+03,     1.119383111220873e+03,     1.119720205560734e+03, 
            1.120056645230076e+03,     1.120392433109815e+03,     1.120727572061271e+03,     1.121062064926336e+03,     1.121395914527669e+03, 
            1.121729123668854e+03,     1.122061695134592e+03,     1.122393631690859e+03,     1.122724936085084e+03,     1.123055611046317e+03, 
            1.123385659285392e+03,     1.123715083495094e+03,     1.124043886350321e+03,     1.124372070508245e+03,     1.124699638608471e+03, 
            1.125026593273194e+03,     1.125352937107353e+03,     1.125678672698789e+03,     1.126003802618391e+03,     1.126328329420251e+03, 
            1.126652255641811e+03,     1.126975583804007e+03,     1.127298316411418e+03,     1.127620455952409e+03,     1.127942004899274e+03, 
            1.128262965708373e+03,     1.128583340820271e+03,     1.128903132659880e+03,     1.129222343636593e+03,     1.129540976144415e+03, 
            1.129859032562098e+03,     1.130176515253276e+03,     1.130493426566589e+03,     1.130809768835817e+03,     1.131125544380003e+03, 
            1.131440755503581e+03,     1.131755404496500e+03,     1.132069493634350e+03,     1.132383025178477e+03,     1.132696001376109e+03, 
            1.133008424460477e+03,     1.133320296650927e+03,     1.133631620153041e+03,     1.133942397158749e+03,     1.134252629846450e+03, 
            1.134562320381115e+03,     1.134871470914410e+03,     1.135180083584796e+03,     1.135488160517649e+03,     1.135795703825357e+03, 
            1.136102715607439e+03,     1.136409197950642e+03,     1.136715152929050e+03,     1.137020582604189e+03,     1.137325489025126e+03, 
            1.137629874228575e+03,     1.137933740238995e+03,     1.138237089068692e+03,     1.138539922717913e+03,     1.138842243174950e+03, 
            1.139144052416234e+03,     1.139445352406428e+03,     1.139746145098524e+03,     1.140046432433940e+03,     1.140346216342607e+03, 
            1.140645498743065e+03,     1.140944281542549e+03,     1.141242566637089e+03,     1.141540355911587e+03,     1.141837651239914e+03, 
            1.142134454484992e+03,     1.142430767498885e+03,     1.142726592122879e+03,     1.143021930187576e+03,     1.143316783512965e+03, 
            1.143611153908518e+03,     1.143905043173263e+03,     1.144198453095870e+03,     1.144491385454730e+03,     1.144783842018036e+03
    },
    {
            1.814431442720272e+00,     5.505874295049583e+00,     9.279678781868874e+00,     1.314071333495033e+01,     1.709432749553396e+01, 
            2.114641955138160e+01,     2.530351680387917e+01,     2.957287145800794e+01,     3.396257601311564e+01,     3.848170321606909e+01, 
            4.314047726734618e+01,     4.795048523296201e+01,     5.292494080778262e+01,     5.807901715669939e+01,     6.343027225480483e+01, 
            6.899920013271380e+01,     7.480995666769446e+01,     8.089133240537872e+01,     8.727808330811162e+01,     9.401279427484546e+01, 
            1.011485608612967e+02,     1.087529745382329e+02,     1.169142775163052e+02,     1.257513262196405e+02,     1.354306979080738e+02, 
            1.461983850911395e+02,     1.584448858387953e+02,     1.728603538677675e+02,     1.909056648300271e+02,     7.778874993399492e+02, 
            7.843499062543823e+02,     7.902180126553425e+02,     7.956102867621181e+02,     8.006109765770836e+02,     8.052825675606130e+02, 
            8.096729176865880e+02,     8.138196272666750e+02,     8.177528571768943e+02,     8.214972227527608e+02,     8.250731100082214e+02, 
            8.284976163715673e+02,     8.317852392239823e+02,     8.349483902619453e+02,     8.379977866470814e+02,     8.409427531541787e+02, 
            8.437914588354521e+02,     8.465511047111501e+02,     8.492280742947643e+02,     8.518280555403161e+02,     8.543561405514080e+02, 
            8.568169077964920e+02,     8.592144904252810e+02,     8.615526334413363e+02,     8.638347418643079e+02,     8.660639215500235e+02, 
            8.682430139844020e+02,     8.703746260980131e+02,     8.724611559403933e+02,     8.745048148915947e+02,     8.765076469616678e+02, 
            8.784715456285111e+02,     8.803982685847361e+02,     8.822894507002522e+02,     8.841466154556884e+02,     8.859711850599091e+02, 
            8.877644894307921e+02,     8.895277741903634e+02,     8.912622078023799e+02,     8.929688879612612e+02,     8.946488473254210e+02, 
            8.963030586747182e+02,     8.979324395606037e+02,     8.995378565081501e+02,     9.011201288211847e+02,     9.026800320350253e+02, 
            9.042183010555508e+02,     9.057356330184449e+02,     9.072326898982446e+02,     9.087101008932117e+02,     9.101684646088972e+02, 
            9.116083510606343e+02,     9.130303035127725e+02,     9.144348401705296e+02,     9.158224557384714e+02,     9.171936228581694e+02, 
            9.185487934361450e+02,     9.198883998721186e+02,     9.212128561964302e+02,     9.225225591246649e+02,     9.238178890366540e+02, 
            9.250992108863117e+02,     9.263668750481411e+02,     9.276212181056590e+02,     9.288625635864952e+02,     9.300912226484737e+02, 
            9.313074947205673e+02,     9.325116681022782e+02,     9.337040205246574e+02,     9.348848196758946e+02,     9.360543236941595e+02, 
            9.372127816301219e+02,     9.383604338813848e+02,     9.394975126008710e+02,     9.406242420810261e+02,     9.417408391155536e+02, 
            9.428475133402516e+02,     9.439444675543987e+02,     9.450318980240080e+02,     9.461099947681944e+02,     9.471789418297516e+02, 
            9.482389175310094e+02,     9.492900947159098e+02,     9.503326409792053e+02,     9.513667188835894e+02,     9.523924861655302e+02, 
            9.534100959305022e+02,     9.544196968382824e+02,     9.554214332789696e+02,     9.564154455418138e+02,     9.574018699745016e+02, 
            9.583808391328153e+02,     9.593524819243934e+02,     9.603169237456847e+02,     9.612742866124190e+02,     9.622246892849505e+02, 
            9.631682468241455e+02,     9.641050727667503e+02,     9.650352763616692e+02,     9.659589644691482e+02,     9.668762412342683e+02, 
            9.677872081811386e+02,     9.686919643029637e+02,     9.695906061481986e+02,     9.704832279030074e+02,     9.713699214701982e+02, 
            9.722507765448360e+02,     9.731258806866833e+02,     9.739953193896409e+02,     9.748591761483332e+02,     9.757175325219823e+02, 
            9.765704681956979e+02,     9.774180610393181e+02,     9.782603871639084e+02,     9.790975209760425e+02,     9.799295352299608e+02, 
            9.807565010929147e+02,     9.815784881311415e+02,     9.823955644518628e+02,     9.832077966825558e+02,     9.840152500306790e+02, 
            9.848179883250367e+02,     9.856160740556043e+02,     9.864095684119114e+02,     9.871985313200289e+02,     9.879830214782113e+02, 
            9.887630963912857e+02,     9.895388124038047e+02,     9.903102247320420e+02,     9.910773874948690e+02,     9.918403537435562e+02, 
            9.925991754905569e+02,     9.933539037373031e+02,     9.941045885010592e+02,     9.948512788408748e+02,     9.955940228826664e+02, 
            9.963328678434723e+02,     9.970678600549030e+02,     9.977990449858314e+02,     9.985264672643352e+02,     9.992501706731337e+02, 
            9.999701982751556e+02,     1.000686592273179e+03,     1.001399394137882e+03,     1.002108644598819e+03,     1.002814383662508e+03, 
            1.003516650629974e+03,     1.004215484113731e+03,     1.004910922054263e+03,     1.005603001736002e+03,     1.006291759802815e+03, 
            1.006977232273039e+03,     1.007659454554061e+03,     1.008338461456474e+03,     1.009014287207803e+03,     1.009686965465855e+03, 
            1.010356529331654e+03,     1.011023011362027e+03,     1.011686443581810e+03,     1.012346857495721e+03,     1.013004284099895e+03, 
            1.013658753893081e+03,     1.014310296887547e+03,     1.014958942619669e+03,     1.015604720160225e+03,     1.016247658124422e+03, 
            1.016887784681628e+03,     1.017525127564863e+03,     1.018159714080012e+03,     1.018791571114809e+03,     1.019420725147571e+03, 
            1.020047202255704e+03,     1.020671028123985e+03,     1.021292228052628e+03,     1.021910826965137e+03,     1.022526849415958e+03, 
            1.023140319597931e+03,     1.023751261349559e+03,     1.024359698162078e+03,     1.024965653186365e+03,     1.025569149239655e+03, 
            1.026170208812104e+03,     1.026768854073178e+03,     1.027365106877892e+03,     1.027958988772886e+03,     1.028550521002361e+03, 
            1.029139724513865e+03,     1.029726619963941e+03,     1.030311227723636e+03,     1.030893567883881e+03,     1.031473660260738e+03, 
            1.032051524400530e+03,     1.032627179584838e+03,     1.033200644835396e+03,     1.033771938918858e+03,     1.034341080351455e+03, 
            1.034908087403556e+03,     1.035472978104111e+03,     1.036035770245000e+03,     1.036596481385273e+03,     1.037155128855311e+03, 
            1.037711729241136e+03,     1.038266300450651e+03,     1.038818858648822e+03,     1.039369420290995e+03,     1.039918001623237e+03, 
            1.040464618685957e+03,     1.041009287343868e+03,     1.041552023182701e+03,     1.042092841674426e+03,     1.042631758071518e+03, 
            1.043168787437765e+03,     1.043703944651450e+03,     1.044237244408456e+03,     1.044768701225318e+03,     1.045298329442191e+03, 
            1.045826143225776e+03,     1.046352156572173e+03,     1.046876383309672e+03,     1.047398837101499e+03,     1.047919531448491e+03, 
            1.048438479691726e+03,     1.048955695015092e+03,     1.049471190447811e+03,     1.049984978866900e+03,     1.050497072999601e+03, 
            1.051007485425740e+03,     1.051516228580058e+03,     1.052023314754481e+03,     1.052528756100354e+03,     1.053032564630629e+03, 
            1.053534752222004e+03,     1.054035330617030e+03,     1.054534311426168e+03,     1.055031706129810e+03,     1.055527526080264e+03, 
            1.056021782503689e+03,     1.056514486502010e+03,     1.057005649054782e+03,     1.057495281021025e+03,     1.057983393141020e+03, 
            1.058469996038083e+03,     1.058955100220282e+03,     1.059438716082152e+03,     1.059920853906349e+03,     1.060401523865297e+03, 
            1.060880736022788e+03,     1.061358500335559e+03,     1.061834826654840e+03,     1.062309724727879e+03,     1.062783204199423e+03, 
            1.063255274613190e+03,     1.063725945413305e+03,     1.064195225945711e+03,     1.064663125459558e+03,     1.065129653108563e+03, 
            1.065594817952349e+03,     1.066058628957756e+03,     1.066521095000135e+03,     1.066982224864614e+03,     1.067442027247349e+03, 
            1.067900510756737e+03,     1.068357683914628e+03,     1.068813555157506e+03,     1.069268132837644e+03,     1.069721425224253e+03, 
            1.070173440504600e+03,     1.070624186785109e+03,     1.071073672092449e+03,     1.071521904374596e+03,     1.071968891501885e+03, 
            1.072414641268030e+03,     1.072859161391151e+03,     1.073302459514755e+03,     1.073744543208726e+03,     1.074185419970281e+03, 
            1.074625097224922e+03,     1.075063582327361e+03,     1.075500882562442e+03,     1.075937005146037e+03,     1.076371957225937e+03, 
            1.076805745882721e+03,     1.077238378130611e+03,     1.077669860918323e+03,     1.078100201129890e+03,     1.078529405585484e+03, 
            1.078957481042217e+03,     1.079384434194933e+03,     1.079810271676987e+03,     1.080235000061013e+03,     1.080658625859671e+03, 
            1.081081155526400e+03,     1.081502595456138e+03,     1.081922951986052e+03,     1.082342231396235e+03,     1.082760439910413e+03, 
            1.083177583696623e+03,     1.083593668867896e+03,     1.084008701482918e+03,     1.084422687546688e+03,     1.084835633011159e+03, 
            1.085247543775877e+03,     1.085658425688609e+03,     1.086068284545953e+03,     1.086477126093948e+03,     1.086884956028677e+03, 
            1.087291779996846e+03,     1.087697603596374e+03,     1.088102432376960e+03,     1.088506271840643e+03,     1.088909127442364e+03, 
            1.089311004590511e+03,     1.089711908647451e+03,     1.090111844930068e+03,     1.090510818710285e+03,     1.090908835215576e+03, 
            1.091305899629479e+03,     1.091702017092091e+03,     1.092097192700566e+03,     1.092491431509599e+03,     1.092884738531907e+03, 
            1.093277118738698e+03,     1.093668577060143e+03,     1.094059118385830e+03,     1.094448747565218e+03,     1.094837469408085e+03, 
            1.095225288684964e+03,     1.095612210127584e+03,     1.095998238429290e+03,     1.096383378245469e+03,     1.096767634193969e+03, 
            1.097151010855500e+03,     1.097533512774047e+03,     1.097915144457270e+03,     1.098295910376887e+03,     1.098675814969073e+03, 
            1.099054862634840e+03,     1.099433057740410e+03,     1.099810404617595e+03,     1.100186907564157e+03,     1.100562570844176e+03, 
            1.100937398688407e+03,     1.101311395294628e+03,     1.101684564827995e+03,     1.102056911421381e+03,     1.102428439175717e+03, 
            1.102799152160323e+03,     1.103169054413244e+03,     1.103538149941572e+03,     1.103906442721764e+03,     1.104273936699965e+03, 
            1.104640635792322e+03,     1.105006543885285e+03,     1.105371664835919e+03,     1.105736002472200e+03,     1.106099560593320e+03, 
            1.106462342969969e+03,     1.106824353344635e+03,     1.107185595431880e+03,     1.107546072918634e+03,     1.107905789464460e+03, 
            1.108264748701840e+03,     1.108622954236441e+03,     1.108980409647382e+03,     1.109337118487504e+03,     1.109693084283625e+03, 
            1.110048310536805e+03,     1.110402800722594e+03,     1.110756558291284e+03,     1.111109586668166e+03,     1.111461889253766e+03, 
            1.111813469424090e+03,     1.112164330530866e+03,     1.112514475901776e+03,     1.112863908840694e+03,     1.113212632627916e+03, 
            1.113560650520383e+03,     1.113907965751911e+03,     1.114254581533412e+03,     1.114600501053115e+03,     1.114945727476776e+03, 
            1.115290263947903e+03,     1.115634113587962e+03,     1.115977279496582e+03,     1.116319764751772e+03,     1.116661572410115e+03, 
            1.117002705506978e+03,     1.117343167056706e+03,     1.117682960052819e+03,     1.118022087468210e+03,     1.118360552255337e+03, 
            1.118698357346411e+03,     1.119035505653584e+03,     1.119372000069136e+03,     1.119707843465657e+03,     1.120043038696234e+03, 
            1.120377588594618e+03,     1.120711495975418e+03,     1.121044763634259e+03,     1.121377394347967e+03,     1.121709390874737e+03, 
            1.122040755954300e+03,     1.122371492308092e+03,     1.122701602639419e+03,     1.123031089633622e+03,     1.123359955958234e+03, 
            1.123688204263146e+03,     1.124015837180759e+03,     1.124342857326145e+03,     1.124669267297199e+03,     1.124995069674791e+03, 
            1.125320267022918e+03,     1.125644861888853e+03,     1.125968856803294e+03,     1.126292254280508e+03,     1.126615056818474e+03, 
            1.126937266899032e+03,     1.127258886988016e+03,     1.127579919535398e+03,     1.127900366975427e+03,     1.128220231726764e+03, 
            1.128539516192614e+03,     1.128858222760867e+03,     1.129176353804224e+03,     1.129493911680327e+03,     1.129810898731893e+03, 
            1.130127317286841e+03,     1.130443169658413e+03,     1.130758458145307e+03,     1.131073185031793e+03,     1.131387352587843e+03, 
            1.131700963069247e+03,     1.132014018717732e+03,     1.132326521761086e+03,     1.132638474413271e+03,     1.132949878874539e+03, 
            1.133260737331549e+03,     1.133571051957480e+03,     1.133880824912141e+03,     1.134190058342086e+03,     1.134498754380722e+03, 
            1.134806915148417e+03,     1.135114542752609e+03,     1.135421639287915e+03,     1.135728206836230e+03,     1.136034247466838e+03, 
            1.136339763236514e+03,     1.136644756189622e+03,     1.136949228358222e+03,     1.137253181762165e+03,     1.137556618409197e+03, 
            1.137859540295055e+03,     1.138161949403562e+03,     1.138463847706726e+03,     1.138765237164834e+03,     1.139066119726549e+03, 
            1.139366497328997e+03,     1.139666371897865e+03,     1.139965745347492e+03,     1.140264619580955e+03,     1.140562996490163e+03, 
            1.140860877955944e+03,     1.141158265848133e+03,     1.141455162025658e+03,     1.141751568336627e+03,     1.142047486618414e+03, 
            1.142342918697742e+03,     1.142637866390764e+03,     1.142932331503153e+03,     1.143226315830176e+03,     1.143519821156779e+03
    },
    {
            1.810643358253539e+00,     5.493967544638702e+00,     9.258874206380080e+00,     1.311014283731356e+01,     1.705302060512096e+01, 
            2.109328738849792e+01,     2.523733281778100e+01,     2.949224812839362e+01,     3.386593645657027e+01,     3.836724629948034e+01, 
            4.300613435983445e+01,     4.779386606654525e+01,     5.274326497267444e+01,     5.786902638524364e+01,     6.318811661664156e+01, 
            6.872028819148738e+01,     7.448875489203310e+01,     8.052109156114390e+01,     8.685045715972386e+01,     9.351729489090940e+01, 
            1.005717576937509e+02,     1.080772757821875e+02,     1.161159980728480e+02,     1.247974660658916e+02,     1.342732176785885e+02, 
            1.447631564919152e+02,     1.566078085444115e+02,     1.703864089115321e+02,     1.872440130321721e+02,     7.686604885367753e+02, 
            7.758544907184669e+02,     7.822977607779352e+02,     7.881582456615409e+02,     7.935499629649448e+02,     7.985546181787926e+02, 
            8.032331443839378e+02,     8.076324043300149e+02,     8.117893366007727e+02,     8.157336498041576e+02,     8.194896436727990e+02, 
            8.230774805568601e+02,     8.265140976262404e+02,     8.298138766285115e+02,     8.329891455625245e+02,     8.360505610637013e+02, 
            8.390074043830116e+02,     8.418678136384975e+02,     8.446389683053009e+02,     8.473272373914790e+02,     8.499382996427655e+02, 
            8.524772419475938e+02,     8.549486405689782e+02,     8.573566287144652e+02,     8.597049531389924e+02,     8.619970218703426e+02, 
            8.642359446931946e+02,     8.664245676838419e+02,     8.685655028245477e+02,     8.706611535231376e+02,     8.727137367050962e+02, 
            8.747253020209915e+02,     8.766977486136963e+02,     8.786328398113548e+02,     8.805322160492129e+02,     8.823974062725915e+02, 
            8.842298380320685e+02,     8.860308464482798e+02,     8.878016821960891e+02,     8.895435186351141e+02,     8.912574581946756e+02, 
            8.929445381055168e+02,     8.946057355574901e+02,     8.962419723513530e+02,     8.978541191035100e+02,     8.994429990546657e+02, 
            9.010093915266496e+02,     9.025540350659961e+02,     9.040776303079651e+02,     9.055808425905424e+02,     9.070643043443266e+02, 
            9.085286172811525e+02,     9.099743544015747e+02,     9.114020618390560e+02,     9.128122605566350e+02,     9.142054479101214e+02, 
            9.155820990903097e+02,     9.169426684553490e+02,     9.182875907632301e+02,     9.196172823133046e+02,     9.209321420048409e+02, 
            9.222325523197782e+02,     9.235188802361744e+02,     9.247914780781426e+02,     9.260506843075736e+02,     9.272968242623683e+02, 
            9.285302108455058e+02,     9.297511451688586e+02,     9.309599171552818e+02,     9.321568061022242e+02,     9.333420812097842e+02, 
            9.345160020758932e+02,     9.356788191610696e+02,     9.368307742249837e+02,     9.379721007368590e+02,     9.391030242616096e+02, 
            9.402237628234035e+02,     9.413345272482492e+02,     9.424355214870401e+02,     9.435269429203989e+02,     9.446089826465416e+02, 
            9.456818257532992e+02,     9.467456515753399e+02,     9.478006339375511e+02,     9.488469413854784e+02,     9.498847374036418e+02, 
            9.509141806224995e+02,     9.519354250147609e+02,     9.529486201474483e+02,     9.539539110308370e+02,     9.549514389458575e+02, 
            9.559413409448382e+02,     9.569237503317977e+02,     9.578987967413435e+02,     9.588666062764071e+02,     9.598273016394598e+02, 
            9.607810021335885e+02,     9.617278237370592e+02,     9.626678804275542e+02,     9.636012821121398e+02,     9.645281362490865e+02, 
            9.654485475656235e+02,     9.663626181526754e+02,     9.672704475554583e+02,     9.681721328601448e+02,     9.690677687767903e+02, 
            9.699574477187455e+02,     9.708412598787041e+02,     9.717192933015762e+02,     9.725916339543294e+02,     9.734583657929769e+02, 
            9.743195708268205e+02,     9.751753291801082e+02,     9.760257191512187e+02,     9.768708172694985e+02,     9.777106983498604e+02, 
            9.785454355452540e+02,     9.793751004120833e+02,     9.801997628973837e+02,     9.810194914796876e+02,     9.818343531495233e+02, 
            9.826444134691498e+02,     9.834497366141621e+02,     9.842503854135641e+02,     9.850464213883706e+02,     9.858379047888146e+02, 
            9.866248946302080e+02,     9.874074487275283e+02,     9.881856237287749e+02,     9.889594751471487e+02,     9.897290573921182e+02, 
            9.904944237993933e+02,     9.912556266598838e+02,     9.920127172476581e+02,     9.927657458469594e+02,     9.935147617783082e+02, 
            9.942598134237387e+02,     9.950009482511914e+02,     9.957382128381105e+02,     9.964716528672815e+02,     9.972013132586690e+02, 
            9.979272380232567e+02,     9.986494703974458e+02,     9.993680528341151e+02,     1.000083027022016e+03,     1.000794433904556e+03, 
            1.001502313698003e+03,     1.002206705909119e+03,     1.002907649352250e+03,     1.003605182165909e+03,     1.004299341828836e+03, 
            1.004990165175587e+03,     1.005677688411654e+03,     1.006361947128130e+03,     1.007042976315947e+03,     1.007720810379693e+03, 
            1.008395483151024e+03,     1.009067027901690e+03,     1.009735477356184e+03,     1.010400863704028e+03,     1.011063218611712e+03, 
            1.011722573234294e+03,     1.012378958226671e+03,     1.013032403754538e+03,     1.013682939505042e+03,     1.014330594697144e+03, 
            1.014975398091693e+03,     1.015617378001222e+03,     1.016256562299492e+03,     1.016892978430760e+03,     1.017526653418813e+03, 
            1.018157613875757e+03,     1.018785886010568e+03,     1.019411495637426e+03,     1.020034468183825e+03,     1.020654828698472e+03, 
            1.021272601858984e+03,     1.021887811979386e+03,     1.022500483017416e+03,     1.023110638581643e+03,     1.023718301938406e+03, 
            1.024323496018582e+03,     1.024926243424174e+03,     1.025526566434747e+03,     1.026124487013695e+03,     1.026720026814359e+03, 
            1.027313207185995e+03,     1.027904049179589e+03,     1.028492573553545e+03,     1.029078800779215e+03,     1.029662751046321e+03, 
            1.030244444268228e+03,     1.030823900087101e+03,     1.031401137878936e+03,     1.031976176758473e+03,     1.032549035584000e+03, 
            1.033119732962035e+03,     1.033688287251910e+03,     1.034254716570240e+03,     1.034819038795297e+03,     1.035381271066368e+03, 
            1.035941431791033e+03,     1.036499537669085e+03,     1.037055605667171e+03,     1.037609652560588e+03,     1.038161694829636e+03, 
            1.038711748826268e+03,     1.039259830667929e+03,     1.039805956268880e+03,     1.040350141343683e+03,     1.040892401410618e+03, 
            1.041432751795012e+03,     1.041971207632512e+03,     1.042507783872278e+03,     1.043042495280108e+03,     1.043575356441501e+03, 
            1.044106381764653e+03,     1.044635585483391e+03,     1.045162981660041e+03,     1.045688584188244e+03,     1.046212406795704e+03, 
            1.046734463046892e+03,     1.047254766345678e+03,     1.047773329937923e+03,     1.048290166914013e+03,     1.048805290211338e+03, 
            1.049318712616728e+03,     1.049830446768833e+03,     1.050340505160461e+03,     1.050848900140866e+03,     1.051355643917989e+03, 
            1.051860748560660e+03,     1.052364226000753e+03,     1.052866088035299e+03,     1.053366346328557e+03,     1.053865012414044e+03, 
            1.054362097696535e+03,     1.054857613454007e+03,     1.055351570839561e+03,     1.055843980883301e+03,     1.056334854494176e+03, 
            1.056824202461791e+03,     1.057312035458178e+03,     1.057798364039545e+03,     1.058283198647973e+03,     1.058766549613102e+03, 
            1.059248427153773e+03,     1.059728841379643e+03,     1.060207802292769e+03,     1.060685319789167e+03,     1.061161403660338e+03, 
            1.061636063594765e+03,     1.062109309179392e+03,     1.062581149901062e+03,     1.063051595147941e+03,     1.063520654210914e+03, 
            1.063988336284949e+03,     1.064454650470447e+03,     1.064919605774560e+03,     1.065383211112491e+03,     1.065845475308764e+03, 
            1.066306407098484e+03,     1.066766015128561e+03,     1.067224307958922e+03,     1.067681294063699e+03,     1.068136981832396e+03, 
            1.068591379571038e+03,     1.069044495503296e+03,     1.069496337771598e+03,     1.069946914438220e+03,     1.070396233486349e+03, 
            1.070844302821150e+03,     1.071291130270787e+03,     1.071736723587449e+03,     1.072181090448353e+03,     1.072624238456721e+03, 
            1.073066175142750e+03,     1.073506907964568e+03,     1.073946444309167e+03,     1.074384791493322e+03,     1.074821956764502e+03, 
            1.075257947301756e+03,     1.075692770216591e+03,     1.076126432553834e+03,     1.076558941292484e+03,     1.076990303346539e+03, 
            1.077420525565825e+03,     1.077849614736800e+03,     1.078277577583348e+03,     1.078704420767568e+03,     1.079130150890537e+03, 
            1.079554774493072e+03,     1.079978298056475e+03,     1.080400728003270e+03,     1.080822070697922e+03,     1.081242332447551e+03, 
            1.081661519502633e+03,     1.082079638057692e+03,     1.082496694251973e+03,     1.082912694170118e+03,     1.083327643842819e+03, 
            1.083741549247473e+03,     1.084154416308813e+03,     1.084566250899543e+03,     1.084977058840956e+03,     1.085386845903543e+03, 
            1.085795617807594e+03,     1.086203380223795e+03,     1.086610138773803e+03,     1.087015899030828e+03,     1.087420666520195e+03, 
            1.087824446719902e+03,     1.088227245061173e+03,     1.088629066928994e+03,     1.089029917662651e+03,     1.089429802556254e+03, 
            1.089828726859255e+03,     1.090226695776958e+03,     1.090623714471026e+03,     1.091019788059970e+03,     1.091414921619646e+03, 
            1.091809120183730e+03,     1.092202388744197e+03,     1.092594732251786e+03,     1.092986155616468e+03,     1.093376663707892e+03, 
            1.093766261355840e+03,     1.094154953350669e+03,     1.094542744443742e+03,     1.094929639347865e+03,     1.095315642737707e+03, 
            1.095700759250217e+03,     1.096084993485041e+03,     1.096468350004925e+03,     1.096850833336114e+03,     1.097232447968755e+03, 
            1.097613198357280e+03,     1.097993088920792e+03,     1.098372124043450e+03,     1.098750308074836e+03,     1.099127645330328e+03, 
            1.099504140091466e+03,     1.099879796606307e+03,     1.100254619089784e+03,     1.100628611724053e+03,     1.101001778658840e+03, 
            1.101374124011781e+03,     1.101745651868756e+03,     1.102116366284225e+03,     1.102486271281553e+03,     1.102855370853330e+03, 
            1.103223668961695e+03,     1.103591169538649e+03,     1.103957876486363e+03,     1.104323793677487e+03,     1.104688924955450e+03, 
            1.105053274134762e+03,     1.105416845001308e+03,     1.105779641312633e+03,     1.106141666798239e+03,     1.106502925159860e+03, 
            1.106863420071747e+03,     1.107223155180942e+03,     1.107582134107551e+03,     1.107940360445014e+03,     1.108297837760372e+03, 
            1.108654569594526e+03,     1.109010559462499e+03,     1.109365810853694e+03,     1.109720327232140e+03,     1.110074112036752e+03, 
            1.110427168681565e+03,     1.110779500555991e+03,     1.111131111025049e+03,     1.111482003429606e+03,     1.111832181086615e+03, 
            1.112181647289340e+03,     1.112530405307592e+03,     1.112878458387950e+03,     1.113225809753988e+03,     1.113572462606493e+03, 
            1.113918420123683e+03,     1.114263685461424e+03,     1.114608261753444e+03,     1.114952152111539e+03,     1.115295359625783e+03, 
            1.115637887364735e+03,     1.115979738375639e+03,     1.116320915684624e+03,     1.116661422296907e+03,     1.117001261196982e+03, 
            1.117340435348816e+03,     1.117678947696044e+03,     1.118016801162149e+03,     1.118353998650658e+03,     1.118690543045320e+03, 
            1.119026437210292e+03,     1.119361683990316e+03,     1.119696286210900e+03,     1.120030246678492e+03,     1.120363568180654e+03, 
            1.120696253486236e+03,     1.121028305345544e+03,     1.121359726490508e+03,     1.121690519634848e+03,     1.122020687474242e+03, 
            1.122350232686482e+03,     1.122679157931640e+03,     1.123007465852222e+03,     1.123335159073329e+03,     1.123662240202812e+03, 
            1.123988711831421e+03,     1.124314576532960e+03,     1.124639836864439e+03,     1.124964495366216e+03,     1.125288554562150e+03, 
            1.125612016959742e+03,     1.125934885050282e+03,     1.126257161308986e+03,     1.126578848195140e+03,     1.126899948152238e+03, 
            1.127220463608117e+03,     1.127540396975098e+03,     1.127859750650113e+03,     1.128178527014843e+03,     1.128496728435847e+03, 
            1.128814357264692e+03,     1.129131415838085e+03,     1.129447906477994e+03,     1.129763831491777e+03,     1.130079193172307e+03, 
            1.130393993798092e+03,     1.130708235633404e+03,     1.131021920928388e+03,     1.131335051919190e+03,     1.131647630828073e+03, 
            1.131959659863530e+03,     1.132271141220405e+03,     1.132582077080002e+03,     1.132892469610201e+03,     1.133202320965569e+03, 
            1.133511633287470e+03,     1.133820408704175e+03,     1.134128649330969e+03,     1.134436357270262e+03,     1.134743534611689e+03, 
            1.135050183432219e+03,     1.135356305796261e+03,     1.135661903755760e+03,     1.135966979350302e+03,     1.136271534607220e+03, 
            1.136575571541684e+03,     1.136879092156806e+03,     1.137182098443736e+03,     1.137484592381759e+03,     1.137786575938389e+03, 
            1.138088051069465e+03,     1.138389019719244e+03,     1.138689483820498e+03,     1.138989445294595e+03,     1.139288906051604e+03, 
            1.139587867990373e+03,     1.139886332998624e+03,     1.140184302953042e+03,     1.140481779719357e+03,     1.140778765152436e+03, 
            1.141075261096365e+03,     1.141371269384538e+03,     1.141666791839734e+03,     1.141961830274205e+03,     1.142256386489757e+03
    },
    {
            1.806871352948390e+00,     5.482115041856900e+00,     9.238171286994397e+00,     1.307973245283176e+01,     1.701194554581244e+01, 
            2.104047475669877e+01,     2.517157541205508e+01,     2.941218197235384e+01,     3.377001347418775e+01,     3.825370082295069e+01, 
            4.287294172020963e+01,     4.763869090736917e+01,     5.256339606008144e+01,     5.766129343545795e+01,     6.294878281814646e+01, 
            6.844490932918974e+01,     7.417199172312780e+01,     8.015645537840412e+01,     8.642995757963425e+01,     9.303094062032115e+01, 
            1.000068291669974e+02,     1.074172305215239e+02,     1.153387582446056e+02,     1.238726099907668e+02,     1.331570942389449e+02, 
            1.433897166373611e+02,     1.548695551427065e+02,     1.680886185800580e+02,     1.839663087103205e+02,     2.046628695170949e+02, 
            7.667171870852101e+02,     7.738682663587681e+02,     7.802887614153976e+02,     7.861383586691986e+02,     7.915266543114496e+02, 
            7.965327731565172e+02,     8.012160450284407e+02,     8.056222894865177e+02,     8.097877421500830e+02,     8.137416250232542e+02, 
            8.175078939412081e+02,     8.211064643033947e+02,     8.245540938005073e+02,     8.278650326058511e+02,     8.310515117263682e+02, 
            8.341241161190230e+02,     8.370920741009702e+02,     8.399634848710690e+02,     8.427454995466491e+02,     8.454444667876777e+02, 
            8.480660510962249e+02,     8.506153297856929e+02,     8.530968731220310e+02,     8.555148110593988e+02,     8.578728892009701e+02, 
            8.601745160277625e+02,     8.624228029968364e+02,     8.646205987752206e+02,     8.667705186190942e+02,     8.688749697091856e+02, 
            8.709361730984239e+02,     8.729561828060947e+02,     8.749369024962745e+02,     8.768801001013801e+02,     8.787874206898817e+02, 
            8.806603978273019e+02,     8.825004636390935e+02,     8.843089577507970e+02,     8.860871352537158e+02,     8.878361738217976e+02, 
            8.895571800868368e+02,     8.912511953635208e+02,     8.929192008029033e+02,     8.945621220419193e+02,     8.961808334073637e+02, 
            8.977761617249838e+02,     8.993488897776655e+02,     9.008997594510811e+02,     9.024294746003224e+02,     9.039387036669012e+02, 
            9.054280820719307e+02,     9.068982144082278e+02,     9.083496764514158e+02,     9.097830170077723e+02,     9.111987596146013e+02, 
            9.125974041071042e+02,     9.139794280642255e+02,     9.153452881445953e+02,     9.166954213225056e+02,     9.180302460328273e+02, 
            9.193501632328527e+02,     9.206555573882462e+02,     9.219467973895544e+02,     9.232242374051178e+02,     9.244882176756298e+02, 
            9.257390652551042e+02,     9.269770947025717e+02,     9.282026087283975e+02,     9.294158987987822e+02,     9.306172457016685e+02, 
            9.318069200769994e+02,     9.329851829140001e+02,     9.341522860179427e+02,     9.353084724486206e+02,     9.364539769325960e+02, 
            9.375890262510633e+02,     9.387138396050971e+02,     9.398286289598227e+02,     9.409335993689817e+02,     9.420289492812213e+02, 
            9.431148708293488e+02,     9.441915501036705e+02,     9.452591674104732e+02,     9.463178975166110e+02,     9.473679098810912e+02, 
            9.484093688744921e+02,     9.494424339869685e+02,     9.504672600255682e+02,     9.514839973016731e+02,     9.524927918107882e+02, 
            9.534937854011583e+02,     9.544871159332004e+02,     9.554729174322672e+02,     9.564513202340676e+02,     9.574224511231268e+02, 
            9.583864334647006e+02,     9.593433867289665e+02,     9.602934288295306e+02,     9.612366731382001e+02,     9.621732305372473e+02, 
            9.631032090630659e+02,     9.640267140058310e+02,     9.649438480047573e+02,     9.658547111391886e+02,     9.667594010157359e+02, 
            9.676580128516653e+02,     9.685506395547433e+02,     9.694373717997104e+02,     9.703182981015501e+02,     9.711935048857277e+02, 
            9.720630765555402e+02,     9.729270955567242e+02,     9.737856424394532e+02,     9.746387959178560e+02,     9.754866329271682e+02, 
            9.763292286786404e+02,     9.771666567122979e+02,     9.779989889623751e+02,     9.788262957458670e+02,     9.796486459019632e+02, 
            9.804661067739578e+02,     9.812787442689280e+02,     9.820866228995779e+02,     9.828898058245330e+02,     9.836883548871626e+02, 
            9.844823306529960e+02,     9.852717924457876e+02,     9.860567983822986e+02,     9.868374054058387e+02,     9.876136693186318e+02, 
            9.883856448130555e+02,     9.891533855017864e+02,     9.899169439469208e+02,     9.906763716880906e+02,     9.914317192696350e+02, 
            9.921830362668506e+02,     9.929303713113684e+02,     9.936737721156882e+02,     9.944132854706850e+02,     9.951489573752334e+02, 
            9.958808328955773e+02,     9.966089562973543e+02,     9.973333710382424e+02,     9.980541197880964e+02,     9.987712444484533e+02, 
            9.994847861714238e+02,     1.000194785377995e+03,     1.000901281775764e+03,     1.001604314376134e+03,     1.002303921510977e+03, 
            1.003000140848793e+03,     1.003693009410388e+03,     1.004382563584073e+03,     1.005068839140418e+03,     1.005751871246565e+03, 
            1.006431694480130e+03,     1.007108342842682e+03,     1.007781849772848e+03,     1.008452248159033e+03,     1.009119570351774e+03, 
            1.009783848175747e+03,     1.010445112941428e+03,     1.011103395456434e+03,     1.011758726036541e+03,     1.012411134516397e+03, 
            1.013060650259941e+03,     1.013707302170534e+03,     1.014351118700819e+03,     1.014992127862298e+03,     1.015630357234675e+03, 
            1.016265833974926e+03,     1.016898584826141e+03,     1.017528636126124e+03,     1.018156013815773e+03,     1.018780743447232e+03, 
            1.019402850191841e+03,     1.020022358847871e+03,     1.020639293848064e+03,     1.021253679266979e+03,     1.021865538828152e+03, 
            1.022474895911072e+03,     1.023081773557984e+03,     1.023686194480518e+03,     1.024288181066159e+03,     1.024887755384548e+03, 
            1.025484939193637e+03,     1.026079753945683e+03,     1.026672220793106e+03,     1.027262360594194e+03,     1.027850193918682e+03, 
            1.028435741053190e+03,     1.029019022006528e+03,     1.029600056514881e+03,     1.030178864046874e+03,     1.030755463808507e+03, 
            1.031329874747982e+03,     1.031902115560421e+03,     1.032472204692462e+03,     1.033040160346768e+03,     1.033605999980149e+03, 
            1.034169742316209e+03,     1.034731404387365e+03,     1.035291003410990e+03,     1.035848556460546e+03,     1.036404080363673e+03, 
            1.036957591732782e+03,     1.037509106968804e+03,     1.038058642264844e+03,     1.038606213609780e+03,     1.039151836791759e+03, 
            1.039695527401630e+03,     1.040237300836303e+03,     1.040777172302026e+03,     1.041315156817603e+03,     1.041851269217534e+03, 
            1.042385524155096e+03,     1.042917936105355e+03,     1.043448519368113e+03,     1.043977288070797e+03,     1.044504256171283e+03, 
            1.045029437460669e+03,     1.045552845565979e+03,     1.046074493952826e+03,     1.046594395928006e+03,     1.047112564642051e+03, 
            1.047629013091719e+03,     1.048143754122444e+03,     1.048656800430728e+03,     1.049168164566496e+03,     1.049677858935388e+03, 
            1.050185895801022e+03,     1.050692287287198e+03,     1.051197045380072e+03,     1.051700181930277e+03,     1.052201708655004e+03, 
            1.052701637140049e+03,     1.053199978841814e+03,     1.053696745089269e+03,     1.054191947085884e+03,     1.054685595911510e+03, 
            1.055177702524244e+03,     1.055668277762237e+03,     1.056157332345485e+03,     1.056644876877575e+03,     1.057130921847405e+03, 
            1.057615477630869e+03,     1.058098554492511e+03,     1.058580162587148e+03,     1.059060311961466e+03,     1.059539012555579e+03, 
            1.060016274204573e+03,     1.060492106640005e+03,     1.060966519491387e+03,     1.061439522287640e+03,     1.061911124458522e+03, 
            1.062381335336023e+03,     1.062850164155755e+03,     1.063317620058287e+03,     1.063783712090487e+03,     1.064248449206818e+03, 
            1.064711840270625e+03,     1.065173894055390e+03,     1.065634619245972e+03,     1.066094024439820e+03,     1.066552118148170e+03, 
            1.067008908797215e+03,     1.067464404729261e+03,     1.067918614203864e+03,     1.068371545398936e+03,     1.068823206411847e+03, 
            1.069273605260503e+03,     1.069722749884395e+03,     1.070170648145653e+03,     1.070617307830056e+03,     1.071062736648049e+03, 
            1.071506942235726e+03,     1.071949932155805e+03,     1.072391713898584e+03,     1.072832294882883e+03,     1.073271682456970e+03, 
            1.073709883899468e+03,     1.074146906420255e+03,     1.074582757161341e+03,     1.075017443197740e+03,     1.075450971538315e+03, 
            1.075883349126625e+03,     1.076314582841743e+03,     1.076744679499078e+03,     1.077173645851161e+03,     1.077601488588445e+03, 
            1.078028214340070e+03,     1.078453829674631e+03,     1.078878341100923e+03,     1.079301755068684e+03,     1.079724077969317e+03, 
            1.080145316136611e+03,     1.080565475847439e+03,     1.080984563322458e+03,     1.081402584726786e+03,     1.081819546170680e+03, 
            1.082235453710192e+03,     1.082650313347825e+03,     1.083064131033175e+03,     1.083476912663561e+03,     1.083888664084648e+03, 
            1.084299391091064e+03,     1.084709099427001e+03,     1.085117794786806e+03,     1.085525482815579e+03,     1.085932169109738e+03, 
            1.086337859217595e+03,     1.086742558639915e+03,     1.087146272830469e+03,     1.087549007196575e+03,     1.087950767099639e+03, 
            1.088351557855678e+03,     1.088751384735847e+03,     1.089150252966946e+03,     1.089548167731933e+03,     1.089945134170411e+03, 
            1.090341157379133e+03,     1.090736242412476e+03,     1.091130394282923e+03,     1.091523617961532e+03,     1.091915918378402e+03, 
            1.092307300423128e+03,     1.092697768945250e+03,     1.093087328754705e+03,     1.093475984622255e+03,     1.093863741279930e+03, 
            1.094250603421444e+03,     1.094636575702623e+03,     1.095021662741815e+03,     1.095405869120300e+03,     1.095789199382694e+03, 
            1.096171658037344e+03,     1.096553249556722e+03,     1.096933978377813e+03,     1.097313848902492e+03,     1.097692865497905e+03, 
            1.098071032496837e+03,     1.098448354198080e+03,     1.098824834866794e+03,     1.099200478734861e+03,     1.099575290001241e+03, 
            1.099949272832314e+03,     1.100322431362227e+03,     1.100694769693228e+03,     1.101066291896001e+03,     1.101437002009993e+03, 
            1.101806904043746e+03,     1.102176001975205e+03,     1.102544299752043e+03,     1.102911801291973e+03,     1.103278510483050e+03, 
            1.103644431183980e+03,     1.104009567224419e+03,     1.104373922405267e+03,     1.104737500498965e+03,     1.105100305249777e+03, 
            1.105462340374080e+03,     1.105823609560644e+03,     1.106184116470908e+03,     1.106543864739257e+03,     1.106902857973289e+03, 
            1.107261099754086e+03,     1.107618593636476e+03,     1.107975343149292e+03,     1.108331351795633e+03,     1.108686623053115e+03, 
            1.109041160374123e+03,     1.109394967186058e+03,     1.109748046891584e+03,     1.110100402868868e+03,     1.110452038471817e+03, 
            1.110802957030318e+03,     1.111153161850468e+03,     1.111502656214801e+03,     1.111851443382524e+03,     1.112199526589733e+03, 
            1.112546909049639e+03,     1.112893593952787e+03,     1.113239584467268e+03,     1.113584883738940e+03,     1.113929494891633e+03, 
            1.114273421027360e+03,     1.114616665226526e+03,     1.114959230548126e+03,     1.115301120029952e+03,     1.115642336688785e+03, 
            1.115982883520601e+03,     1.116322763500757e+03,     1.116661979584186e+03,     1.117000534705586e+03,     1.117338431779613e+03, 
            1.117675673701056e+03,     1.118012263345027e+03,     1.118348203567143e+03,     1.118683497203700e+03,     1.119018147071853e+03, 
            1.119352155969790e+03,     1.119685526676905e+03,     1.120018261953968e+03,     1.120350364543297e+03,     1.120681837168920e+03, 
            1.121012682536741e+03,     1.121342903334708e+03,     1.121672502232969e+03,     1.122001481884032e+03,     1.122329844922926e+03, 
            1.122657593967354e+03,     1.122984731617846e+03,     1.123311260457915e+03,     1.123637183054204e+03,     1.123962501956640e+03, 
            1.124287219698574e+03,     1.124611338796933e+03,     1.124934861752362e+03,     1.125257791049365e+03,     1.125580129156448e+03, 
            1.125901878526258e+03,     1.126223041595719e+03,     1.126543620786170e+03,     1.126863618503501e+03,     1.127183037138282e+03, 
            1.127501879065900e+03,     1.127820146646687e+03,     1.128137842226048e+03,     1.128454968134590e+03,     1.128771526688250e+03, 
            1.129087520188416e+03,     1.129402950922053e+03,     1.129717821161825e+03,     1.130032133166216e+03,     1.130345889179650e+03, 
            1.130659091432608e+03,     1.130971742141745e+03,     1.131283843510010e+03,     1.131595397726755e+03,     1.131906406967850e+03, 
            1.132216873395798e+03,     1.132526799159845e+03,     1.132836186396089e+03,     1.133145037227585e+03,     1.133453353764462e+03, 
            1.133761138104021e+03,     1.134068392330845e+03,     1.134375118516899e+03,     1.134681318721640e+03,     1.134986994992111e+03, 
            1.135292149363051e+03,     1.135596783856985e+03,     1.135900900484333e+03,     1.136204501243501e+03,     1.136507588120981e+03, 
            1.136810163091447e+03,     1.137112228117848e+03,     1.137413785151506e+03,     1.137714836132205e+03,     1.138015382988286e+03, 
            1.138315427636736e+03,     1.138614971983283e+03,     1.138914017922477e+03,     1.139212567337788e+03,     1.139510622101688e+03, 
            1.139808184075739e+03,     1.140105255110679e+03,     1.140401837046507e+03,     1.140697931712568e+03,     1.140993540927635e+03
    },
    {
            1.803115321864341e+00,     5.470316389439176e+00,     9.217569196872809e+00,     1.304948074577097e+01,     1.697110003826910e+01, 
            2.098797822507822e+01,     2.510623959886048e+01,     2.933266590937075e+01,     3.367479718121717e+01,     3.814105314680564e+01, 
            4.274088067475088e+01,     4.748493431250876e+01,     5.238529948166637e+01,     5.745577128370513e+01,     6.271220678777628e+01, 
            6.817297586482763e+01,     7.385954637926021e+01,     7.979725597733487e+01,     8.601634847668140e+01,     9.255339446059706e+01, 
            9.945328510863254e+01,     1.067721086827275e+02,     1.145814373952978e+02,     1.229749695190099e+02,     1.320793221963467e+02, 
            1.420726443504949e+02,     1.532192878779564e+02,     1.659414932603634e+02,     1.809917858188388e+02,     1.999831206763195e+02, 
            7.567757957495066e+02,     7.648243362956227e+02,     7.719288431920090e+02,     7.783229942591084e+02,     7.841584880592750e+02, 
            7.895405304301136e+02,     7.945456318085456e+02,     7.992314716547000e+02,     8.036427811162972e+02,     8.078150535336664e+02, 
            8.117769913056625e+02,     8.155521790031179e+02,     8.191602624355136e+02,     8.226178010474418e+02,     8.259388978161699e+02, 
            8.291356736863452e+02,     8.322186309408436e+02,     8.351969356616509e+02,     8.380786402177270e+02,     8.408708606054485e+02, 
            8.435799193258285e+02,     8.462114616208845e+02,     8.487705508789538e+02,     8.512617475805974e+02,     8.536891751140578e+02, 
            8.560565750231342e+02,     8.583673536805377e+02,     8.606246219512356e+02,     8.628312290844924e+02,     8.649897918233432e+02, 
            8.671027195265964e+02,     8.691722359472808e+02,     8.712003981924289e+02,     8.731891132946994e+02,     8.751401527510324e+02, 
            8.770551653229226e+02,     8.789356883439492e+02,     8.807831577403667e+02,     8.825989169379802e+02,     8.843842248017514e+02, 
            8.861402627324563e+02,     8.878681410263468e+02,     8.895689045884585e+02,     8.912435380773863e+02,     8.928929705485693e+02, 
            8.945180796540218e+02,     8.961196954487577e+02,     8.976986038475862e+02,     8.992555497703770e+02,     9.007912400091145e+02, 
            9.023063458459426e+02,     9.038015054478883e+02,     9.052773260608731e+02,     9.067343860230071e+02,     9.081732366148428e+02, 
            9.095944037622866e+02,     9.109983896061128e+02,     9.123856739505029e+02,     9.137567156017085e+02,     9.151119536067418e+02, 
            9.164518084009878e+02,     9.177766828726993e+02,     9.190869633515496e+02,     9.203830205276879e+02,     9.216652103071226e+02, 
            9.229338746086814e+02,     9.241893421073087e+02,     9.254319289280040e+02,     9.266619392943102e+02,     9.278796661349016e+02, 
            9.290853916515007e+02,     9.302793878510608e+02,     9.314619170449128e+02,     9.326332323172952e+02,     9.337935779655484e+02, 
            9.349431899139779e+02,     9.360822961033055e+02,     9.372111168573987e+02,     9.383298652288836e+02,     9.394387473250813e+02, 
            9.405379626156201e+02,     9.416277042229349e+02,     9.427081591968182e+02,     9.437795087740516e+02,     9.448419286240886e+02, 
            9.458955890817039e+02,     9.469406553674075e+02,     9.479772877964249e+02,     9.490056419769394e+02,     9.500258689993736e+02, 
            9.510381156164075e+02,     9.520425244110485e+02,     9.530392339578054e+02,     9.540283789762154e+02,     9.550100904769680e+02, 
            9.559844959010588e+02,     9.569517188402322e+02,     9.579118805094987e+02,     9.588650983854986e+02,     9.598114867547503e+02, 
            9.607511570725301e+02,     9.616842179332646e+02,     9.626107751706978e+02,     9.635309319536302e+02,     9.644447888774799e+02, 
            9.653524440518636e+02,     9.662539931844151e+02,     9.671495296610444e+02,     9.680391446228077e+02,     9.689229270395523e+02, 
            9.698009637805295e+02,     9.706733396820877e+02,     9.715401376126239e+02,     9.724014385349049e+02,     9.732573215658959e+02, 
            9.741078640342193e+02,     9.749531415353446e+02,     9.757932279846329e+02,     9.766281956827260e+02,     9.774581153056300e+02, 
            9.782830560424436e+02,     9.791030855788440e+02,     9.799182701566532e+02,     9.807286746159056e+02,     9.815343624353582e+02, 
            9.823353957715178e+02,     9.831318354962610e+02,     9.839237412330904e+02,     9.847111713921000e+02,     9.854941832037002e+02, 
            9.862728327511594e+02,     9.870471750020025e+02,     9.878172638383286e+02,     9.885831520860794e+02,     9.893448915433124e+02, 
            9.901025330075167e+02,     9.908561263020016e+02,     9.916057203014155e+02,     9.923513629309789e+02,     9.930931012938075e+02, 
            9.938309815360336e+02,     9.945650489763603e+02,     9.952953481003494e+02,     9.960219225813358e+02,     9.967448153006752e+02, 
            9.974640683673510e+02,     9.981797231369723e+02,     9.988918202301695e+02,     9.996003995504299e+02,     1.000305500301382e+03, 
            1.001007161003547e+03,     1.001705419510594e+03,     1.002400313025090e+03,     1.003091878113791e+03,     1.003780150722470e+03, 
            1.004465166190312e+03,     1.005146959263883e+03,     1.005825564110693e+03,     1.006501014332358e+03,     1.007173342977404e+03, 
            1.007842582553673e+03,     1.008508765040402e+03,     1.009171921899951e+03,     1.009832084089196e+03,     1.010489282070608e+03, 
            1.011143545823033e+03,     1.011794904852154e+03,     1.012443388200686e+03,     1.013089024458282e+03,     1.013731841771171e+03, 
            1.014371867851540e+03,     1.015009129986662e+03,     1.015643655047777e+03,     1.016275469498749e+03,     1.016904599404477e+03, 
            1.017531070439106e+03,     1.018154907894007e+03,     1.018776136685560e+03,     1.019394781362734e+03,     1.020010866114469e+03, 
            1.020624414776878e+03,     1.021235450840261e+03,     1.021843997455937e+03,     1.022450077442920e+03,     1.023053713294413e+03, 
            1.023654927184149e+03,     1.024253740972574e+03,     1.024850176212879e+03,     1.025444254156884e+03,     1.026035995760780e+03, 
            1.026625421690727e+03,     1.027212552328329e+03,     1.027797407775967e+03,     1.028380007862012e+03,     1.028960372145908e+03, 
            1.029538519923146e+03,     1.030114470230112e+03,     1.030688241848822e+03,     1.031259853337328e+03,     1.031829322422627e+03, 
            1.032396668175896e+03,     1.032961907916027e+03,     1.033525059220540e+03,     1.034086139438817e+03,     1.034645165696131e+03, 
            1.035202154897593e+03,     1.035757123731995e+03,     1.036310088675586e+03,     1.036861065995754e+03,     1.037410071754626e+03, 
            1.037957121812594e+03,     1.038502231831770e+03,     1.039045417279346e+03,     1.039586693430909e+03,     1.040126075373657e+03, 
            1.040663578009572e+03,     1.041199216058504e+03,     1.041733004061208e+03,     1.042264956382299e+03,     1.042795087213161e+03, 
            1.043323410574786e+03,     1.043849940320558e+03,     1.044374690138979e+03,     1.044897673556331e+03,     1.045418903939301e+03, 
            1.045938394497532e+03,     1.046456158286141e+03,     1.046972208208166e+03,     1.047486557016987e+03,     1.047999217318674e+03, 
            1.048510201574311e+03,     1.049019522102255e+03,     1.049527191080364e+03,     1.050033220548172e+03,     1.050537622409023e+03, 
            1.051040408432171e+03,     1.051541590254826e+03,     1.052041179384174e+03,     1.052539187199346e+03,     1.053035624953357e+03, 
            1.053530503775007e+03,     1.054023834670739e+03,     1.054515628526473e+03,     1.055005896109396e+03,     1.055494648069719e+03, 
            1.055981894942410e+03,     1.056467647148884e+03,     1.056951914998665e+03,     1.057434708691018e+03,     1.057916038316555e+03, 
            1.058395913858802e+03,     1.058874345195745e+03,     1.059351342101346e+03,     1.059826914247027e+03,     1.060301071203138e+03, 
            1.060773822440383e+03,     1.061245177331235e+03,     1.061715145151318e+03,     1.062183735080764e+03,     1.062650956205551e+03, 
            1.063116817518811e+03,     1.063581327922118e+03,     1.064044496226759e+03,     1.064506331154969e+03,     1.064966841341160e+03, 
            1.065426035333116e+03,     1.065883921593176e+03,     1.066340508499393e+03,     1.066795804346673e+03,     1.067249817347891e+03, 
            1.067702555635002e+03,     1.068154027260112e+03,     1.068604240196550e+03,     1.069053202339907e+03,     1.069500921509071e+03, 
            1.069947405447237e+03,     1.070392661822896e+03,     1.070836698230818e+03,     1.071279522193012e+03,     1.071721141159672e+03, 
            1.072161562510108e+03,     1.072600793553659e+03,     1.073038841530594e+03,     1.073475713612998e+03,     1.073911416905643e+03, 
            1.074345958446842e+03,     1.074779345209298e+03,     1.075211584100928e+03,     1.075642681965684e+03,     1.076072645584352e+03, 
            1.076501481675343e+03,     1.076929196895478e+03,     1.077355797840744e+03,     1.077781291047055e+03,     1.078205682990990e+03, 
            1.078628980090525e+03,     1.079051188705751e+03,     1.079472315139586e+03,     1.079892365638464e+03,     1.080311346393030e+03, 
            1.080729263538807e+03,     1.081146123156871e+03,     1.081561931274496e+03,     1.081976693865807e+03,     1.082390416852412e+03, 
            1.082803106104029e+03,     1.083214767439100e+03,     1.083625406625399e+03,     1.084035029380635e+03,     1.084443641373033e+03, 
            1.084851248221921e+03,     1.085257855498299e+03,     1.085663468725400e+03,     1.086068093379250e+03,     1.086471734889211e+03, 
            1.086874398638522e+03,     1.087276089964829e+03,     1.087676814160707e+03,     1.088076576474180e+03,     1.088475382109225e+03, 
            1.088873236226273e+03,     1.089270143942706e+03,     1.089666110333340e+03,     1.090061140430907e+03,     1.090455239226529e+03, 
            1.090848411670178e+03,     1.091240662671144e+03,     1.091631997098481e+03,     1.092022419781458e+03,     1.092411935509999e+03, 
            1.092800549035114e+03,     1.093188265069330e+03,     1.093575088287115e+03,     1.093961023325288e+03,     1.094346074783437e+03, 
            1.094730247224320e+03,     1.095113545174266e+03,     1.095495973123565e+03,     1.095877535526864e+03,     1.096258236803541e+03, 
            1.096638081338092e+03,     1.097017073480500e+03,     1.097395217546600e+03,     1.097772517818448e+03,     1.098148978544674e+03, 
            1.098524603940837e+03,     1.098899398189776e+03,     1.099273365441949e+03,     1.099646509815778e+03,     1.100018835397980e+03, 
            1.100390346243897e+03,     1.100761046377825e+03,     1.101130939793336e+03,     1.101500030453590e+03,     1.101868322291656e+03, 
            1.102235819210818e+03,     1.102602525084877e+03,     1.102968443758461e+03,     1.103333579047312e+03,     1.103697934738589e+03, 
            1.104061514591152e+03,     1.104424322335849e+03,     1.104786361675803e+03,     1.105147636286685e+03,     1.105508149816993e+03, 
            1.105867905888324e+03,     1.106226908095639e+03,     1.106585160007533e+03,     1.106942665166494e+03,     1.107299427089162e+03, 
            1.107655449266583e+03,     1.108010735164464e+03,     1.108365288223418e+03,     1.108719111859215e+03,     1.109072209463020e+03, 
            1.109424584401635e+03,     1.109776240017736e+03,     1.110127179630108e+03,     1.110477406533871e+03,     1.110826924000717e+03, 
            1.111175735279125e+03,     1.111523843594595e+03,     1.111871252149858e+03,     1.112217964125100e+03,     1.112563982678173e+03, 
            1.112909310944812e+03,     1.113253952038837e+03,     1.113597909052368e+03,     1.113941185056026e+03,     1.114283783099133e+03, 
            1.114625706209917e+03,     1.114966957395706e+03,     1.115307539643122e+03,     1.115647455918281e+03,     1.115986709166974e+03, 
            1.116325302314861e+03,     1.116663238267656e+03,     1.117000519911310e+03,     1.117337150112196e+03,     1.117673131717284e+03, 
            1.118008467554323e+03,     1.118343160432013e+03,     1.118677213140182e+03,     1.119010628449954e+03,     1.119343409113921e+03, 
            1.119675557866313e+03,     1.120007077423155e+03,     1.120337970482441e+03,     1.120668239724291e+03,     1.120997887811110e+03, 
            1.121326917387751e+03,     1.121655331081666e+03,     1.121983131503066e+03,     1.122310321245069e+03,     1.122636902883856e+03, 
            1.122962878978818e+03,     1.123288252072704e+03,     1.123613024691770e+03,     1.123937199345919e+03,     1.124260778528848e+03, 
            1.124583764718188e+03,     1.124906160375646e+03,     1.125227967947139e+03,     1.125549189862936e+03,     1.125869828537790e+03, 
            1.126189886371073e+03,     1.126509365746909e+03,     1.126828269034305e+03,     1.127146598587279e+03,     1.127464356744991e+03, 
            1.127781545831866e+03,     1.128098168157726e+03,     1.128414226017904e+03,     1.128729721693378e+03,     1.129044657450885e+03, 
            1.129359035543042e+03,     1.129672858208470e+03,     1.129986127671905e+03,     1.130298846144318e+03,     1.130611015823029e+03, 
            1.130922638891824e+03,     1.131233717521062e+03,     1.131544253867792e+03,     1.131854250075860e+03,     1.132163708276021e+03, 
            1.132472630586043e+03,     1.132781019110819e+03,     1.133088875942470e+03,     1.133396203160450e+03,     1.133703002831647e+03, 
            1.134009277010494e+03,     1.134315027739062e+03,     1.134620257047162e+03,     1.134924966952450e+03,     1.135229159460518e+03, 
            1.135532836564996e+03,     1.135836000247649e+03,     1.136138652478470e+03,     1.136440795215774e+03,     1.136742430406296e+03, 
            1.137043559985278e+03,     1.137344185876565e+03,     1.137644309992692e+03,     1.137943934234980e+03,     1.138243060493617e+03, 
            1.138541690647751e+03,     1.138839826565577e+03,     1.139137470104423e+03,     1.139434623110832e+03,     1.139731287420652e+03
    },
    {
            1.799375161005808e+00,     5.458571194319209e+00,     9.197067119127261e+00,     1.301938629972534e+01,     1.693048183709439e+01, 
            2.093579441883622e+01,     2.504132047949602e+01,     2.925369299677087e+01,     3.358027790211069e+01,     3.802928994483126e+01, 
            4.260993301553531e+01,     4.733257152801244e+01,     5.220894166665562e+01,     5.725241441125394e+01,     6.247832668870801e+01, 
            6.790440345844895e+01,     7.355130312207864e+01,     7.944333318873247e+01,     8.560940574150375e+01,     9.208433841243011e+01, 
            9.891066626400159e+01,     1.061412321588900e+02,     1.138430057188338e+02,     1.221029234885894e+02,     1.310372261688352e+02, 
            1.408072331881895e+02,     1.516479406727134e+02,     1.639249700269751e+02,     1.782640331955204e+02,     1.959123667352239e+02, 
            7.457847441533440e+02,     7.550186429357286e+02,     7.629815827810264e+02,     7.700360059865058e+02,     7.764003632860674e+02, 
            7.822186252851308e+02,     7.875916441009146e+02,     7.925932890594406e+02,     7.972795476729549e+02,     8.016940214458022e+02, 
            8.058714249395981e+02,     8.098399099286543e+02,     8.136226637558866e+02,     8.172390410025464e+02,     8.207053848197210e+02, 
            8.240356358874853e+02,     8.272417923965664e+02,     8.303342632367511e+02,     8.333221431559788e+02,     8.362134299307764e+02, 
            8.390151977817044e+02,     8.417337373186630e+02,     8.443746695639884e+02,     8.469430396712912e+02,     8.494433945755924e+02, 
            8.518798478057465e+02,     8.542561339508001e+02,     8.565756547208111e+02,     8.588415181276066e+02,     8.610565719948816e+02, 
            8.632234327641506e+02,     8.653445103747448e+02,     8.674220298487146e+02,     8.694580500954618e+02,     8.714544803587825e+02, 
            8.734130946553300e+02,     8.753355444942626e+02,     8.772233701199118e+02,     8.790780104801818e+02,     8.809008120915413e+02, 
            8.826930369450453e+02,     8.844558695761962e+02,     8.861904234032975e+02,     8.878977464239522e+02,     8.895788263466711e+02, 
            8.912345952239774e+02,     8.928659336443901e+02,     8.944736745330752e+02,     8.960586066044929e+02,     8.976214775048164e+02, 
            8.991629966772097e+02,     9.006838379789523e+02,     9.021846420759396e+02,     9.036660186370239e+02,     9.051285483480773e+02, 
            9.065727847633669e+02,     9.079992560098458e+02,     9.094084663582712e+02,     9.108008976734836e+02,     9.121770107549348e+02, 
            9.135372465773110e+02,     9.148820274401315e+02,     9.162117580342502e+02,     9.175268264324239e+02,     9.188276050103694e+02, 
            9.201144513041340e+02,     9.213877088090035e+02,     9.226477077247135e+02,     9.238947656512591e+02,     9.251291882391992e+02, 
            9.263512697980116e+02,     9.275612938657289e+02,     9.287595337427825e+02,     9.299462529927378e+02,     9.311217059123898e+02, 
            9.322861379734366e+02,     9.334397862377823e+02,     9.345828797483691e+02,     9.357156398972392e+02,     9.368382807724192e+02, 
            9.379510094850910e+02,     9.390540264783713e+02,     9.401475258189515e+02,     9.412316954727296e+02,     9.423067175654769e+02, 
            9.433727686295313e+02,     9.444300198373908e+02,     9.454786372230554e+02,     9.465187818918806e+02,     9.475506102200142e+02, 
            9.485742740454334e+02,     9.495899208463405e+02,     9.505976939108361e+02,     9.515977324990245e+02,     9.525901719972319e+02, 
            9.535751440647949e+02,     9.545527767738223e+02,     9.555231940941148e+02,     9.564865184156206e+02,     9.574428673174674e+02, 
            9.583923557873392e+02,     9.593350958325103e+02,     9.602711965851801e+02,     9.612007644031150e+02,     9.621239029658451e+02, 
            9.630407133666532e+02,     9.639512942005795e+02,     9.648557416486447e+02,     9.657541495584902e+02,     9.666466095216239e+02, 
            9.675332109474219e+02,     9.684140411340821e+02,     9.692891853366560e+02,     9.701587268323109e+02,     9.710227469829605e+02, 
            9.718813252953895e+02,     9.727345394789928e+02,     9.735824655012433e+02,     9.744251776409969e+02,     9.752627485537856e+02, 
            9.760952492635845e+02,     9.769227492985618e+02,     9.777453166763092e+02,     9.785630179632344e+02,     9.793759183168440e+02, 
            9.801840815264527e+02,     9.809875700524133e+02,     9.817864450639220e+02,     9.825807664754585e+02,     9.833705929819340e+02, 
            9.841559820925786e+02,     9.849369901636543e+02,     9.857136724300101e+02,     9.864860830355559e+02,     9.872542750626765e+02, 
            9.880183005606582e+02,     9.887782105731275e+02,     9.895340551645912e+02,     9.902858834214612e+02,     9.910337435770059e+02, 
            9.917776828824125e+02,     9.925177477337979e+02,     9.932539836681991e+02,     9.939864353852831e+02,     9.947151467683742e+02, 
            9.954401609048058e+02,     9.961615201056233e+02,     9.968792659246797e+02,     9.975934391771333e+02,     9.983040799573660e+02, 
            9.990112276563623e+02,     9.997149209785438e+02,     1.000415197958108e+03,     1.001112095974862e+03,     1.001805651769590e+03, 
            1.002495901458959e+03,     1.003182880549986e+03,     1.003866623954081e+03,     1.004547166000676e+03,     1.005224540450466e+03, 
            1.005898780508260e+03,     1.006569918835469e+03,     1.007237987562236e+03,     1.007903018299231e+03,     1.008565042149095e+03, 
            1.009224089717588e+03,     1.009880191124410e+03,     1.010533376013729e+03,     1.011183673564425e+03,     1.011831112500040e+03, 
            1.012475721098476e+03,     1.013117527201419e+03,     1.013756558223516e+03,     1.014392841161302e+03,     1.015026402601899e+03, 
            1.015657268731475e+03,     1.016285465343493e+03,     1.016911017846730e+03,     1.017533951273111e+03,     1.018154290285315e+03, 
            1.018772059184201e+03,     1.019387281916048e+03,     1.019999982079601e+03,     1.020610182932943e+03,     1.021217907400200e+03, 
            1.021823178078075e+03,     1.022426017242214e+03,     1.023026446853427e+03,     1.023624488563746e+03,     1.024220163722343e+03, 
            1.024813493381298e+03,     1.025404498301232e+03,     1.025993198956801e+03,     1.026579615542063e+03,     1.027163767975714e+03, 
            1.027745675932133e+03,     1.028325358741523e+03,     1.028902835553808e+03,     1.029478125236182e+03,     1.030051245896494e+03, 
            1.030622216904319e+03,     1.031191055895777e+03,     1.031757780761057e+03,     1.032322409156955e+03,     1.032884958511009e+03, 
            1.033445446025555e+03,     1.034003888681689e+03,     1.034560303243135e+03,     1.035114706260035e+03,     1.035667114072654e+03, 
            1.036217542814993e+03,     1.036766008418343e+03,     1.037312526614744e+03,     1.037857112940373e+03,     1.038399782738868e+03, 
            1.038940551164571e+03,     1.039479433185702e+03,     1.040016443587475e+03,     1.040551596975133e+03,     1.041084907776936e+03, 
            1.041616390247072e+03,     1.042146058468516e+03,     1.042673926355822e+03,     1.043200007657871e+03,     1.043724315960543e+03, 
            1.044246864689354e+03,     1.044767667112021e+03,     1.045286736340991e+03,     1.045804085335904e+03,     1.046319726906022e+03, 
            1.046833673712594e+03,     1.047345938271184e+03,     1.047856532953953e+03,     1.048365469991882e+03,     1.048872761476974e+03, 
            1.049378419364390e+03,     1.049882455474559e+03,     1.050384881495241e+03,     1.050885708983550e+03,     1.051384949367935e+03, 
            1.051882613950132e+03,     1.052378713907068e+03,     1.052873260292738e+03,     1.053366264040038e+03,     1.053857735962566e+03, 
            1.054347686756399e+03,     1.054836127001817e+03,     1.055323067165012e+03,     1.055808517599760e+03,     1.056292488549056e+03, 
            1.056774990146727e+03,     1.057256032419014e+03,     1.057735625286118e+03,     1.058213778563726e+03,     1.058690501964508e+03, 
            1.059165805099579e+03,     1.059639697479950e+03,     1.060112188517934e+03,     1.060583287528543e+03,     1.061053003730851e+03, 
            1.061521346249335e+03,     1.061988324115195e+03,     1.062453946267647e+03,     1.062918221555193e+03,     1.063381158736875e+03, 
            1.063842766483495e+03,     1.064303053378833e+03,     1.064762027920819e+03,     1.065219698522710e+03,     1.065676073514227e+03, 
            1.066131161142684e+03,     1.066584969574095e+03,     1.067037506894258e+03,     1.067488781109828e+03,     1.067938800149367e+03, 
            1.068387571864376e+03,     1.068835104030311e+03,     1.069281404347586e+03,     1.069726480442551e+03,     1.070170339868461e+03, 
            1.070612990106424e+03,     1.071054438566340e+03,     1.071494692587815e+03,     1.071933759441072e+03,     1.072371646327834e+03, 
            1.072808360382201e+03,     1.073243908671518e+03,     1.073678298197210e+03,     1.074111535895627e+03,     1.074543628638859e+03, 
            1.074974583235541e+03,     1.075404406431654e+03,     1.075833104911303e+03,     1.076260685297485e+03,     1.076687154152849e+03, 
            1.077112517980442e+03,     1.077536783224442e+03,     1.077959956270877e+03,     1.078382043448344e+03,     1.078803051028703e+03, 
            1.079222985227768e+03,     1.079641852205988e+03,     1.080059658069113e+03,     1.080476408868852e+03,     1.080892110603525e+03, 
            1.081306769218697e+03,     1.081720390607810e+03,     1.082132980612801e+03,     1.082544545024712e+03,     1.082955089584292e+03, 
            1.083364619982586e+03,     1.083773141861523e+03,     1.084180660814485e+03,     1.084587182386879e+03,     1.084992712076689e+03, 
            1.085397255335028e+03,     1.085800817566681e+03,     1.086203404130636e+03,     1.086605020340611e+03,     1.087005671465571e+03, 
            1.087405362730240e+03,     1.087804099315604e+03,     1.088201886359407e+03,     1.088598728956639e+03,     1.088994632160019e+03, 
            1.089389600980471e+03,     1.089783640387589e+03,     1.090176755310104e+03,     1.090568950636333e+03,     1.090960231214633e+03, 
            1.091350601853839e+03,     1.091740067323706e+03,     1.092128632355335e+03,     1.092516301641597e+03,     1.092903079837554e+03, 
            1.093288971560868e+03,     1.093673981392213e+03,     1.094058113875672e+03,     1.094441373519134e+03,     1.094823764794685e+03, 
            1.095205292138992e+03,     1.095585959953686e+03,     1.095965772605730e+03,     1.096344734427797e+03,     1.096722849718629e+03, 
            1.097100122743398e+03,     1.097476557734060e+03,     1.097852158889711e+03,     1.098226930376923e+03,     1.098600876330093e+03, 
            1.098974000851776e+03,     1.099346308013016e+03,     1.099717801853678e+03,     1.100088486382766e+03,     1.100458365578746e+03, 
            1.100827443389858e+03,     1.101195723734429e+03,     1.101563210501182e+03,     1.101929907549531e+03,     1.102295818709887e+03, 
            1.102660947783953e+03,     1.103025298545010e+03,     1.103388874738211e+03,     1.103751680080858e+03,     1.104113718262690e+03, 
            1.104474992946151e+03,     1.104835507766672e+03,     1.105195266332935e+03,     1.105554272227140e+03,     1.105912529005270e+03, 
            1.106270040197348e+03,     1.106626809307699e+03,     1.106982839815194e+03,     1.107338135173507e+03,     1.107692698811365e+03, 
            1.108046534132781e+03,     1.108399644517304e+03,     1.108752033320255e+03,     1.109103703872959e+03,     1.109454659482982e+03, 
            1.109804903434356e+03,     1.110154438987807e+03,     1.110503269380982e+03,     1.110851397828664e+03,     1.111198827522993e+03, 
            1.111545561633686e+03,     1.111891603308245e+03,     1.112236955672168e+03,     1.112581621829158e+03,     1.112925604861331e+03, 
            1.113268907829417e+03,     1.113611533772956e+03,     1.113953485710507e+03,     1.114294766639837e+03,     1.114635379538114e+03, 
            1.114975327362100e+03,     1.115314613048344e+03,     1.115653239513362e+03,     1.115991209653826e+03,     1.116328526346748e+03, 
            1.116665192449657e+03,     1.117001210800779e+03,     1.117336584219213e+03,     1.117671315505108e+03,     1.118005407439830e+03, 
            1.118338862786137e+03,     1.118671684288346e+03,     1.119003874672498e+03,     1.119335436646526e+03,     1.119666372900412e+03, 
            1.119996686106357e+03,     1.120326378918929e+03,     1.120655453975229e+03,     1.120983913895044e+03,     1.121311761280997e+03, 
            1.121638998718705e+03,     1.121965628776924e+03,     1.122291654007703e+03,     1.122617076946524e+03,     1.122941900112457e+03, 
            1.123266126008293e+03,     1.123589757120695e+03,     1.123912795920332e+03,     1.124235244862023e+03,     1.124557106384874e+03, 
            1.124878382912408e+03,     1.125199076852709e+03,     1.125519190598548e+03,     1.125838726527517e+03,     1.126157687002158e+03, 
            1.126476074370096e+03,     1.126793890964160e+03,     1.127111139102515e+03,     1.127427821088782e+03,     1.127743939212163e+03, 
            1.128059495747566e+03,     1.128374492955721e+03,     1.128688933083302e+03,     1.129002818363044e+03,     1.129316151013863e+03, 
            1.129628933240967e+03,     1.129941167235972e+03,     1.130252855177019e+03,     1.130563999228882e+03,     1.130874601543077e+03, 
            1.131184664257978e+03,     1.131494189498923e+03,     1.131803179378317e+03,     1.132111635995744e+03,     1.132419561438073e+03, 
            1.132726957779553e+03,     1.133033827081928e+03,     1.133340171394532e+03,     1.133645992754391e+03,     1.133951293186322e+03, 
            1.134256074703037e+03,     1.134560339305234e+03,     1.134864088981697e+03,     1.135167325709393e+03,     1.135470051453567e+03, 
            1.135772268167832e+03,     1.136073977794268e+03,     1.136375182263508e+03,     1.136675883494834e+03,     1.136976083396265e+03, 
            1.137275783864645e+03,     1.137574986785737e+03,     1.137873694034302e+03,     1.138171907474194e+03,     1.138469628958441e+03
    },
    {
            1.795650767310983e+00,     5.446879067569144e+00,     9.176664246656330e+00,     1.298944771725881e+01,     1.689008873013794e+01, 
            2.088392001801470e+01,     2.497681324220756e+01,     2.917525642603617e+01,     3.348644616444672e+01,     3.791839819440488e+01, 
            4.248008098455092e+01,     4.718157846344390e+01,     5.203429002107454e+01,     5.705117873883120e+01,     6.224708281313412e+01, 
            6.763911093883246e+01,     7.324715097212277e+01,     7.909453407655432e+01,     8.520891642835751e+01,     9.162347204094276e+01, 
            9.837854168387115e+01,     1.055239698073954e+02,     1.131225144328228e+02,     1.212549972765365e+02,     1.300284129065541e+02, 
            1.395893676745570e+02,     1.501478419500794e+02,     1.620229286486598e+02,     1.757418100996120e+02,     1.922948349404708e+02, 
            2.140239788607310e+02,     7.442332910430633e+02,     7.533133457722519e+02,     7.611883084459188e+02,     7.681893329053013e+02, 
            7.745206080189075e+02,     7.803186292415797e+02,     7.856799400561204e+02,     7.906757508279056e+02,     7.953603224306546e+02, 
            7.997760904795394e+02,     8.039569578037244e+02,     8.079304970568272e+02,     8.117194741976080e+02,     8.153429322466070e+02, 
            8.188169809656669e+02,     8.221553843356675e+02,     8.253700056191099e+02,     8.284711499787411e+02,     8.314678320175432e+02, 
            8.343679873732467e+02,     8.371786419983506e+02,     8.399060490019464e+02,     8.425558003192269e+02,     8.451329186286655e+02, 
            8.476419336113424e+02,     8.500869456817074e+02,     8.524716796069449e+02,     8.547995299005795e+02,     8.570735994747578e+02, 
            8.592967327297213e+02,     8.614715440235358e+02,     8.636004422822774e+02,     8.656856523677053e+02,     8.677292337064886e+02, 
            8.697330965952443e+02,     8.716990165238335e+02,     8.736286468014451e+02,     8.755235297231552e+02,     8.773851064764112e+02, 
            8.792147259556070e+02,     8.810136526271125e+02,     8.827830735658147e+02,     8.845241047664526e+02,     8.862377968182587e+02, 
            8.879251400189618e+02,     8.895870689937774e+02,     8.912244668761563e+02,     8.928381690995676e+02,     8.944289668432347e+02, 
            8.959976101692528e+02,     8.975448108838857e+02,     8.990712451518152e+02,     9.005775558886388e+02,     9.020643549539619e+02, 
            9.035322251648015e+02,     9.049817221467870e+02,     9.064133760386860e+02,     9.078276930640545e+02,     9.092251569823206e+02, 
            9.106062304303032e+02,     9.119713561639895e+02,     9.133209582094019e+02,     9.146554429304590e+02,     9.159752000209618e+02, 
            9.172806034271200e+02,     9.185720122064005e+02,     9.198497713279438e+02,     9.211142124192613e+02,     9.223656544635411e+02, 
            9.236044044514153e+02,     9.248307579907661e+02,     9.260449998777724e+02,     9.272474046321406e+02,     9.284382369991941e+02, 
            9.296177524212777e+02,     9.307861974807051e+02,     9.319438103163058e+02,     9.330908210154413e+02,     9.342274519832355e+02, 
            9.353539182905706e+02,     9.364704280023374e+02,     9.375771824872537e+02,     9.386743767105096e+02,     9.397621995103568e+02, 
            9.408408338597173e+02,     9.419104571137572e+02,     9.429712412443469e+02,     9.440233530622303e+02,     9.450669544277200e+02, 
            9.461022024521128e+02,     9.471292496879461e+02,     9.481482443075963e+02,     9.491593302743590e+02,     9.501626475052125e+02, 
            9.511583320256694e+02,     9.521465161171518e+02,     9.531273280107239e+02,     9.541008934863169e+02,     9.550673343743739e+02, 
            9.560267691687770e+02,     9.569793134019588e+02,     9.579250796120178e+02,     9.588641774485108e+02,     9.597967137735349e+02, 
            9.607227927583398e+02,     9.616425159757310e+02,     9.625559824884560e+02,     9.634632889338088e+02,     9.643645296046282e+02, 
            9.652597965268872e+02,     9.661491795340384e+02,     9.670327663382825e+02,     9.679106425989112e+02,     9.687828919878655e+02, 
            9.696495962526614e+02,     9.705108352767837e+02,     9.713666871376952e+02,     9.722172281625627e+02,     9.730625329968816e+02, 
            9.739026745942548e+02,     9.747377243607028e+02,     9.755677521374873e+02,     9.763928262635576e+02,     9.772130136196761e+02, 
            9.780283796708833e+02,     9.788389885074116e+02,     9.796449028840924e+02,     9.804461842583485e+02,     9.812428928268034e+02, 
            9.820350875605957e+02,     9.828228262394364e+02,     9.836061654844683e+02,     9.843851607899812e+02,     9.851598665540265e+02, 
            9.859303361079774e+02,     9.866966217450841e+02,     9.874587747225008e+02,     9.882168453919501e+02,     9.889708830666805e+02, 
            9.897209361542172e+02,     9.904670521529742e+02,     9.912092776755580e+02,     9.919476584713210e+02,     9.926822394481771e+02, 
            9.934130646937272e+02,     9.941401774957100e+02,     9.948636203618071e+02,     9.955834350388280e+02,     9.962996625312934e+02, 
            9.970123431194502e+02,     9.977215163767260e+02,     9.984272211866578e+02,     9.991294957592966e+02,     9.998283776471307e+02, 
            1.000523903760519e+03,     1.001216110382680e+03,     1.001905033184218e+03,     1.002590707237246e+03,     1.003273167029074e+03, 
            1.003952446475519e+03,     1.004628578933817e+03,     1.005301597215175e+03,     1.005971533596959e+03,     1.006638419834543e+03, 
            1.007302287172819e+03,     1.007963166357388e+03,     1.008621087645445e+03,     1.009276080816353e+03,     1.009928175181933e+03, 
            1.010577399596477e+03,     1.011223782466480e+03,     1.011867351760118e+03,     1.012508135016463e+03,     1.013146159354465e+03, 
            1.013781451481682e+03,     1.014414037702790e+03,     1.015043943927866e+03,     1.015671195680454e+03,     1.016295818105426e+03, 
            1.016917835976636e+03,     1.017537273704381e+03,     1.018154155342669e+03,     1.018768504596311e+03,     1.019380344827819e+03, 
            1.019989699064145e+03,     1.020596590003248e+03,     1.021201040020493e+03,     1.021803071174901e+03,     1.022402705215238e+03, 
            1.022999963585959e+03,     1.023594867433009e+03,     1.024187437609317e+03,     1.024777694706076e+03,     1.025365658955637e+03, 
            1.025951350391403e+03,     1.026534788748983e+03,     1.027115993497468e+03,     1.027694983844330e+03,     1.028271778231052e+03, 
            1.028846396357285e+03,     1.029418856181567e+03,     1.029989175911662e+03,     1.030557373516561e+03,     1.031123466730755e+03, 
            1.031687473058389e+03,     1.032249409777342e+03,     1.032809293943199e+03,     1.033367142393152e+03,     1.033922971749796e+03, 
            1.034476798424855e+03,     1.035028638622823e+03,     1.035578508344518e+03,     1.036126423390573e+03,     1.036672399364833e+03, 
            1.037216451677697e+03,     1.037758595549376e+03,     1.038298846013084e+03,     1.038837217918168e+03,     1.039373725933162e+03, 
            1.039908384548780e+03,     1.040441208080853e+03,     1.040972210673190e+03,     1.041501406300398e+03,     1.042028808770628e+03, 
            1.042554431728272e+03,     1.043078288656604e+03,     1.043600392880366e+03,     1.044120757568300e+03,     1.044639395735635e+03, 
            1.045156320246513e+03,     1.045671543816380e+03,     1.046185079014316e+03,     1.046696938265327e+03,     1.047207133852589e+03, 
            1.047715677919650e+03,     1.048222582472583e+03,     1.048727859382103e+03,     1.049231520385641e+03,     1.049733577089375e+03, 
            1.050234040970225e+03,     1.050732923377812e+03,     1.051230235536368e+03,     1.051725988546627e+03,     1.052220193387664e+03, 
            1.052712860918710e+03,     1.053204001880926e+03,     1.053693626899149e+03,     1.054181746483600e+03,     1.054668371031567e+03, 
            1.055153510829047e+03,     1.055637176052373e+03,     1.056119376769790e+03,     1.056600122943022e+03,     1.057079424428801e+03, 
            1.057557290980366e+03,     1.058033732248942e+03,     1.058508757785186e+03,     1.058982377040611e+03,     1.059454599368983e+03, 
            1.059925434027691e+03,     1.060394890179100e+03,     1.060862976891868e+03,     1.061329703142253e+03,     1.061795077815388e+03, 
            1.062259109706535e+03,     1.062721807522322e+03,     1.063183179881953e+03,     1.063643235318398e+03,     1.064101982279566e+03, 
            1.064559429129456e+03,     1.065015584149285e+03,     1.065470455538602e+03,     1.065924051416381e+03,     1.066376379822093e+03, 
            1.066827448716762e+03,     1.067277265984007e+03,     1.067725839431060e+03,     1.068173176789771e+03,     1.068619285717593e+03, 
            1.069064173798558e+03,     1.069507848544225e+03,     1.069950317394627e+03,     1.070391587719188e+03,     1.070831666817635e+03, 
            1.071270561920893e+03,     1.071708280191960e+03,     1.072144828726778e+03,     1.072580214555079e+03,     1.073014444641228e+03, 
            1.073447525885041e+03,     1.073879465122602e+03,     1.074310269127056e+03,     1.074739944609400e+03,     1.075168498219251e+03, 
            1.075595936545612e+03,     1.076022266117614e+03,     1.076447493405264e+03,     1.076871624820159e+03,     1.077294666716209e+03, 
            1.077716625390340e+03,     1.078137507083180e+03,     1.078557317979751e+03,     1.078976064210131e+03,     1.079393751850124e+03, 
            1.079810386921903e+03,     1.080225975394660e+03,     1.080640523185230e+03,     1.081054036158721e+03,     1.081466520129117e+03, 
            1.081877980859893e+03,     1.082288424064600e+03,     1.082697855407458e+03,     1.083106280503929e+03,     1.083513704921286e+03, 
            1.083920134179176e+03,     1.084325573750168e+03,     1.084730029060301e+03,     1.085133505489619e+03,     1.085536008372693e+03, 
            1.085937542999155e+03,     1.086338114614196e+03,     1.086737728419083e+03,     1.087136389571650e+03,     1.087534103186795e+03, 
            1.087930874336959e+03,     1.088326708052608e+03,     1.088721609322697e+03,     1.089115583095143e+03,     1.089508634277274e+03, 
            1.089900767736287e+03,     1.090291988299683e+03,     1.090682300755716e+03,     1.091071709853819e+03,     1.091460220305031e+03, 
            1.091847836782418e+03,     1.092234563921487e+03,     1.092620406320597e+03,     1.093005368541358e+03,     1.093389455109032e+03, 
            1.093772670512923e+03,     1.094155019206768e+03,     1.094536505609112e+03,     1.094917134103688e+03,     1.095296909039792e+03, 
            1.095675834732643e+03,     1.096053915463746e+03,     1.096431155481253e+03,     1.096807559000307e+03,     1.097183130203398e+03, 
            1.097557873240698e+03,     1.097931792230405e+03,     1.098304891259071e+03,     1.098677174381934e+03,     1.099048645623244e+03, 
            1.099419308976581e+03,     1.099789168405174e+03,     1.100158227842209e+03,     1.100526491191143e+03,     1.100893962326003e+03, 
            1.101260645091689e+03,     1.101626543304270e+03,     1.101991660751277e+03,     1.102356001191990e+03,     1.102719568357727e+03, 
            1.103082365952117e+03,     1.103444397651391e+03,     1.103805667104646e+03,     1.104166177934118e+03,     1.104525933735455e+03, 
            1.104884938077972e+03,     1.105243194504920e+03,     1.105600706533739e+03,     1.105957477656317e+03,     1.106313511339233e+03, 
            1.106668811024014e+03,     1.107023380127376e+03,     1.107377222041464e+03,     1.107730340134095e+03,     1.108082737748993e+03, 
            1.108434418206019e+03,     1.108785384801407e+03,     1.109135640807988e+03,     1.109485189475412e+03,     1.109834034030379e+03, 
            1.110182177676847e+03,     1.110529623596258e+03,     1.110876374947749e+03,     1.111222434868359e+03,     1.111567806473248e+03, 
            1.111912492855893e+03,     1.112256497088300e+03,     1.112599822221200e+03,     1.112942471284253e+03,     1.113284447286240e+03, 
            1.113625753215262e+03,     1.113966392038931e+03,     1.114306366704558e+03,     1.114645680139343e+03,     1.114984335250561e+03, 
            1.115322334925741e+03,     1.115659682032855e+03,     1.115996379420492e+03,     1.116332429918033e+03,     1.116667836335832e+03, 
            1.117002601465388e+03,     1.117336728079510e+03,     1.117670218932495e+03,     1.118003076760288e+03,     1.118335304280650e+03, 
            1.118666904193324e+03,     1.118997879180193e+03,     1.119328231905441e+03,     1.119657965015709e+03,     1.119987081140258e+03, 
            1.120315582891112e+03,     1.120643472863223e+03,     1.120970753634614e+03,     1.121297427766529e+03,     1.121623497803584e+03, 
            1.121948966273911e+03,     1.122273835689302e+03,     1.122598108545352e+03,     1.122921787321603e+03,     1.123244874481677e+03, 
            1.123567372473422e+03,     1.123889283729044e+03,     1.124210610665241e+03,     1.124531355683343e+03,     1.124851521169436e+03, 
            1.125171109494499e+03,     1.125490123014530e+03,     1.125808564070676e+03,     1.126126434989357e+03,     1.126443738082394e+03, 
            1.126760475647133e+03,     1.127076649966565e+03,     1.127392263309447e+03,     1.127707317930425e+03,     1.128021816070152e+03, 
            1.128335759955404e+03,     1.128649151799196e+03,     1.128961993800898e+03,     1.129274288146349e+03,     1.129586037007968e+03, 
            1.129897242544867e+03,     1.130207906902961e+03,     1.130518032215077e+03,     1.130827620601059e+03,     1.131136674167879e+03, 
            1.131445195009742e+03,     1.131753185208188e+03,     1.132060646832197e+03,     1.132367581938293e+03,     1.132673992570642e+03, 
            1.132979880761157e+03,     1.133285248529591e+03,     1.133590097883641e+03,     1.133894430819044e+03,     1.134198249319671e+03, 
            1.134501555357623e+03,     1.134804350893329e+03,     1.135106637875635e+03,     1.135408418241898e+03,     1.135709693918076e+03, 
            1.136010466818825e+03,     1.136310738847580e+03,     1.136610511896648e+03,     1.136909787847298e+03,     1.137208568569843e+03
    },
    {
            1.791942038640876e+00,     5.435239624340501e+00,     9.156359781984335e+00,     1.295966361955530e+01,     1.684991853781731e+01, 
            2.083235175626976e+01,     2.491271316006385e+01,     2.909734951924010e+01,     3.339329269307606e+01,     3.780836516701753e+01, 
            4.235130725849159e+01,     4.703193166760591e+01,     5.186131288903249e+01,     5.685202156474216e+01,     6.201841748282068e+01, 
            6.737702014230018e+01,     7.294698344441504e+01,     7.875071249740255e+01,     8.481467800667352e+01,     9.117051117273554e+01, 
            9.785650638682614e+01,     1.049197331430645e+02,     1.124190872839265e+02,     1.204298452105309e+02,     1.290507319563879e+02, 
            1.384154257415998e+02,     1.487124348063762e+02,     1.602221927543414e+02,     1.733938979538658e+02,     1.890305730916544e+02, 
            2.088579693933173e+02,     7.321210610119447e+02,     7.427307147728014e+02,     7.516588560420881e+02,     7.594436688930884e+02, 
            7.663882222351136e+02,     7.726833222789880e+02,     7.784582395665549e+02,     7.838052645394826e+02,     7.887929409932415e+02, 
            7.934737763628316e+02,     7.978890098640109e+02,     8.020717037524436e+02,     8.060488260185188e+02,     8.098426992169012e+02, 
            8.134720360338333e+02,     8.169526968939770e+02,     8.202982555294085e+02,     8.235204287379536e+02,     8.266294081019236e+02, 
            8.296341196325997e+02,     8.325424295598540e+02,     8.353613092878584e+02,     8.380969689777482e+02,     8.407549667350057e+02, 
            8.433402986185731e+02,     8.458574734210721e+02,     8.483105752442382e+02,     8.507033162097262e+02,     8.530390811337662e+02, 
            8.553209656073585e+02,     8.575518086282259e+02,     8.597342207029703e+02,     8.618706081607370e+02,     8.639631942808111e+02, 
            8.660140377268178e+02,     8.680250486928948e+02,     8.699980030972239e+02,     8.719345551019347e+02,     8.738362481925864e+02, 
            8.757045250131761e+02,     8.775407361219611e+02,     8.793461478081913e+02,     8.811219490889040e+02,     8.828692579876104e+02, 
            8.845891271821014e+02,     8.862825490964403e+02,     8.879504605019513e+02,     8.895937466832593e+02,     8.912132452181460e+02, 
            8.928097494136193e+02,     8.943840114352857e+02,     8.959367451624821e+02,     8.974686287976706e+02,     8.989803072551877e+02, 
            9.004723943514925e+02,     9.019454748164862e+02,     9.034001061432555e+02,     9.048368202916611e+02,     9.062561252594716e+02, 
            9.076585065332973e+02,     9.090444284302292e+02,     9.104143353399878e+02,     9.117686528763358e+02,     9.131077889456535e+02, 
            9.144321347397398e+02,     9.157420656592623e+02,     9.170379421735930e+02,     9.183201106222630e+02,     9.195889039627472e+02, 
            9.208446424688610e+02,     9.220876343836508e+02,     9.233181765303186e+02,     9.245365548843844e+02,     9.257430451100258e+02, 
            9.269379130632648e+02,     9.281214152644486e+02,     9.292937993422519e+02,     9.304553044512609e+02,     9.316061616650007e+02, 
            9.327465943461433e+02,     9.338768184954645e+02,     9.349970430810192e+02,     9.361074703488654e+02,     9.372082961165752e+02, 
            9.382997100506759e+02,     9.393818959290659e+02,     9.404550318893849e+02,     9.415192906642329e+02,     9.425748398284446e+02, 
            9.436218418892747e+02,     9.446604547325217e+02,     9.456908315676113e+02,     9.467131212297342e+02,     9.477274683272730e+02, 
            9.487340134051522e+02,     9.497328931002545e+02,     9.507242399054137e+02,     9.517081835318875e+02,     9.526848497880485e+02, 
            9.536543609267303e+02,     9.546168361216586e+02,     9.555723914278924e+02,     9.565211398930363e+02,     9.574631916634453e+02, 
            9.583986540857150e+02,     9.593276318036811e+02,     9.602502268511955e+02,     9.611665387408792e+02,     9.620766645490664e+02, 
            9.629806989971454e+02,     9.638787345294634e+02,     9.647708613879896e+02,     9.656571676838770e+02,     9.665377394660972e+02, 
            9.674126607872802e+02,     9.682820137669030e+02,     9.691458786519429e+02,     9.700043338751408e+02,     9.708574561109632e+02, 
            9.717053203440024e+02,     9.725479998608596e+02,     9.733855663917824e+02,     9.742180900956663e+02,     9.750456396222097e+02, 
            9.758682821562188e+02,     9.766860834602702e+02,     9.774991079158016e+02,     9.783074185626988e+02,     9.791110771374518e+02, 
            9.799101441099333e+02,     9.807046787188684e+02,     9.814947390060471e+02,     9.822803818493303e+02,     9.830616629945063e+02, 
            9.838386370860492e+02,     9.846113576968096e+02,     9.853798773320540e+02,     9.861442475574775e+02,     9.869045188728210e+02, 
            9.876607408417644e+02,     9.884129620904498e+02,     9.891612303316800e+02,     9.899055923883354e+02,     9.906460942160238e+02, 
            9.913827809250021e+02,     9.921156968013950e+02,     9.928448853277420e+02,     9.935703892028932e+02,     9.942922503612845e+02, 
            9.950105099916051e+02,     9.957252085548963e+02,     9.964363858020889e+02,     9.971440807910062e+02,     9.978483319028503e+02, 
            9.985491768581945e+02,     9.992466527324943e+02,     9.999407959711349e+02,     1.000631642404043e+03,     1.001319227259857e+03, 
            1.002003585179693e+03,     1.002684750230509e+03,     1.003362755918079e+03,     1.004037635199607e+03,     1.004709420495967e+03, 
            1.005378143703612e+03,     1.006043836206136e+03,     1.006706528885518e+03,     1.007366252133055e+03,     1.008023035859989e+03, 
            1.008676909507848e+03,     1.009327902058498e+03,     1.009976042043928e+03,     1.010621357555768e+03,     1.011263876254550e+03, 
            1.011903625378732e+03,     1.012540631753469e+03,     1.013174921799159e+03,     1.013806521539773e+03,     1.014435456610953e+03, 
            1.015061752267909e+03,     1.015685433393113e+03,     1.016306524503798e+03,     1.016925049759251e+03,     1.017541032967943e+03, 
            1.018154497594464e+03,     1.018765466766287e+03,     1.019373963280368e+03,     1.019980009609581e+03,     1.020583627908986e+03, 
            1.021184840047059e+03,     1.021783667510136e+03,     1.022380131562252e+03,     1.022974253146962e+03,     1.023566052919167e+03, 
            1.024155551250530e+03,     1.024742768234760e+03,     1.025327723692778e+03,     1.025910437177759e+03,     1.026490927470313e+03, 
            1.027069214604976e+03,     1.027645316867957e+03,     1.028219252789544e+03,     1.028791040655776e+03,     1.029360698512827e+03, 
            1.029928244171287e+03,     1.030493695210350e+03,     1.031057068981899e+03,     1.031618382614508e+03,     1.032177653017352e+03, 
            1.032734896884030e+03,     1.033290130696303e+03,     1.033843370727750e+03,     1.034394633047347e+03,     1.034943933522967e+03, 
            1.035491287824796e+03,     1.036036711428688e+03,     1.036580219619445e+03,     1.037121827494017e+03,     1.037661549964647e+03, 
            1.038199401761941e+03,     1.038735397437878e+03,     1.039269551368751e+03,     1.039801877758058e+03,     1.040332390639317e+03, 
            1.040861103878838e+03,     1.041388031178427e+03,     1.041913186078039e+03,     1.042436581958380e+03,     1.042958232043448e+03, 
            1.043478149403031e+03,     1.043996346955148e+03,     1.044512837468445e+03,     1.045027633564545e+03,     1.045540747720342e+03, 
            1.046052192270261e+03,     1.046561979408467e+03,     1.047070121191030e+03,     1.047576629538054e+03,     1.048081516235754e+03, 
            1.048584792938505e+03,     1.049086471170839e+03,     1.049586562329416e+03,     1.050085077684948e+03,     1.050582028384089e+03, 
            1.051077425451289e+03,     1.051571279790618e+03,     1.052063602187546e+03,     1.052554403310695e+03,     1.053043693713562e+03, 
            1.053531483836202e+03,     1.054017784006884e+03,     1.054502604443719e+03,     1.054985955256251e+03,     1.055467846447026e+03, 
            1.055948287913129e+03,     1.056427289447691e+03,     1.056904860741376e+03,     1.057381011383830e+03,     1.057855750865115e+03, 
            1.058329088577110e+03,     1.058801033814894e+03,     1.059271595778091e+03,     1.059740783572212e+03,     1.060208606209951e+03, 
            1.060675072612475e+03,     1.061140191610685e+03,     1.061603971946452e+03,     1.062066422273837e+03,     1.062527551160288e+03, 
            1.062987367087816e+03,     1.063445878454149e+03,     1.063903093573872e+03,     1.064359020679539e+03,     1.064813667922772e+03, 
            1.065267043375346e+03,     1.065719155030241e+03,     1.066170010802691e+03,     1.066619618531209e+03,     1.067067985978593e+03, 
            1.067515120832922e+03,     1.067961030708526e+03,     1.068405723146951e+03,     1.068849205617899e+03,     1.069291485520157e+03, 
            1.069732570182509e+03,     1.070172466864636e+03,     1.070611182758000e+03,     1.071048724986707e+03,     1.071485100608371e+03, 
            1.071920316614951e+03,     1.072354379933578e+03,     1.072787297427371e+03,     1.073219075896240e+03,     1.073649722077674e+03, 
            1.074079242647518e+03,     1.074507644220737e+03,     1.074934933352172e+03,     1.075361116537272e+03,     1.075786200212833e+03, 
            1.076210190757712e+03,     1.076633094493533e+03,     1.077054917685384e+03,     1.077475666542500e+03,     1.077895347218943e+03, 
            1.078313965814262e+03,     1.078731528374145e+03,     1.079148040891072e+03,     1.079563509304941e+03,     1.079977939503698e+03, 
            1.080391337323950e+03,     1.080803708551573e+03,     1.081215058922311e+03,     1.081625394122362e+03,     1.082034719788955e+03, 
            1.082443041510928e+03,     1.082850364829290e+03,     1.083256695237767e+03,     1.083662038183359e+03,     1.084066399066872e+03, 
            1.084469783243452e+03,     1.084872196023105e+03,     1.085273642671214e+03,     1.085674128409049e+03,     1.086073658414262e+03, 
            1.086472237821386e+03,     1.086869871722319e+03,     1.087266565166803e+03,     1.087662323162898e+03,     1.088057150677445e+03, 
            1.088451052636532e+03,     1.088844033925938e+03,     1.089236099391588e+03,     1.089627253839986e+03,     1.090017502038653e+03, 
            1.090406848716558e+03,     1.090795298564532e+03,     1.091182856235695e+03,     1.091569526345855e+03,     1.091955313473923e+03, 
            1.092340222162304e+03,     1.092724256917300e+03,     1.093107422209490e+03,     1.093489722474119e+03,     1.093871162111474e+03, 
            1.094251745487255e+03,     1.094631476932948e+03,     1.095010360746184e+03,     1.095388401191098e+03,     1.095765602498682e+03, 
            1.096141968867136e+03,     1.096517504462211e+03,     1.096892213417544e+03,     1.097266099835002e+03,     1.097639167785004e+03, 
            1.098011421306851e+03,     1.098382864409050e+03,     1.098753501069628e+03,     1.099123335236447e+03,     1.099492370827513e+03, 
            1.099860611731286e+03,     1.100228061806973e+03,     1.100594724884833e+03,     1.100960604766468e+03,     1.101325705225116e+03, 
            1.101690030005931e+03,     1.102053582826272e+03,     1.102416367375980e+03,     1.102778387317654e+03,     1.103139646286920e+03, 
            1.103500147892707e+03,     1.103859895717505e+03,     1.104218893317630e+03,     1.104577144223482e+03,     1.104934651939803e+03, 
            1.105291419945926e+03,     1.105647451696027e+03,     1.106002750619368e+03,     1.106357320120543e+03,     1.106711163579716e+03, 
            1.107064284352860e+03,     1.107416685771990e+03,     1.107768371145394e+03,     1.108119343757864e+03,     1.108469606870916e+03, 
            1.108819163723022e+03,     1.109168017529822e+03,     1.109516171484347e+03,     1.109863628757231e+03,     1.110210392496922e+03, 
            1.110556465829900e+03,     1.110901851860875e+03,     1.111246553672997e+03,     1.111590574328058e+03,     1.111933916866690e+03, 
            1.112276584308565e+03,     1.112618579652590e+03,     1.112959905877101e+03,     1.113300565940050e+03,     1.113640562779198e+03, 
            1.113979899312301e+03,     1.114318578437289e+03,     1.114656603032457e+03,     1.114993975956637e+03,     1.115330700049379e+03, 
            1.115666778131130e+03,     1.116002213003401e+03,     1.116337007448946e+03,     1.116671164231924e+03,     1.117004686098077e+03, 
            1.117337575774886e+03,     1.117669835971743e+03,     1.118001469380107e+03,     1.118332478673669e+03,     1.118662866508510e+03, 
            1.118992635523254e+03,     1.119321788339228e+03,     1.119650327560613e+03,     1.119978255774596e+03,     1.120305575551519e+03, 
            1.120632289445030e+03,     1.120958399992225e+03,     1.121283909713798e+03,     1.121608821114183e+03,     1.121933136681690e+03, 
            1.122256858888657e+03,     1.122579990191578e+03,     1.122902533031245e+03,     1.123224489832881e+03,     1.123545863006281e+03, 
            1.123866654945934e+03,     1.124186868031165e+03,     1.124506504626258e+03,     1.124825567080587e+03,     1.125144057728742e+03, 
            1.125461978890656e+03,     1.125779332871729e+03,     1.126096121962953e+03,     1.126412348441026e+03,     1.126728014568485e+03, 
            1.127043122593814e+03,     1.127357674751567e+03,     1.127671673262486e+03,     1.127985120333612e+03,     1.128298018158402e+03, 
            1.128610368916843e+03,     1.128922174775561e+03,     1.129233437887935e+03,     1.129544160394201e+03,     1.129854344421567e+03, 
            1.130163992084318e+03,     1.130473105483918e+03,     1.130781686709122e+03,     1.131089737836074e+03,     1.131397260928412e+03, 
            1.131704258037371e+03,     1.132010731201884e+03,     1.132316682448678e+03,     1.132622113792376e+03,     1.132927027235596e+03, 
            1.133231424769041e+03,     1.133535308371606e+03,     1.133838680010460e+03,     1.134141541641149e+03,     1.134443895207686e+03, 
            1.134745742642642e+03,     1.135047085867237e+03,     1.135347926791432e+03,     1.135648267314017e+03,     1.135948109322700e+03
    },
    {
            1.788248873768514e+00,     5.423652483806121e+00,     9.136152937103905e+00,     1.293003264607721e+01,     1.680996911245729e+01, 
            2.078108641967910e+01,     2.484901558889840e+01,     2.901996572560408e+01,     3.330080840448202e+01,     3.769917841917057e+01, 
            4.222359493420046e+01,     4.688360830538259e+01,     5.168997951593641e+01,     5.665490150632973e+01,     6.179227495548781e+01, 
            6.711805576179732e+01,     7.265069830243158e+01,     7.841172869353663e+01,     8.442649767525467e+01,     9.072518671343596e+01, 
            9.734417926195721e+01,     1.043279724734420e+02,     1.117319131452201e+02,     1.196262355885401e+02,     1.281022430752020e+02, 
            1.372822008833290e+02,     1.473360653914098e+02,     1.585118347254439e+02,     1.711960061233350e+02,     1.860509280959192e+02, 
            2.043970210187621e+02,     2.297619389046357e+02,     7.309351898895175e+02,     7.412759350994365e+02,     7.500538776526539e+02, 
            7.577466320315534e+02,     7.646319195789450e+02,     7.708879734997472e+02,     7.766370904899316e+02,     7.819673753476320e+02, 
            7.869447087624627e+02,     7.916198264627083e+02,     7.960327470000277e+02,     8.002156677329690e+02,     8.041949297198174e+02, 
            8.079923924802868e+02,     8.116264213516047e+02,     8.151126127799445e+02,     8.184643376779379e+02,     8.216931555815514e+02, 
            8.248091352014862e+02,     8.278211059408102e+02,     8.307368576834866e+02,     8.335633012609704e+02,     8.363065986378311e+02, 
            8.389722695018052e+02,     8.415652792685075e+02,     8.440901123017939e+02,     8.465508332660838e+02,     8.489511388714701e+02, 
            8.512944017811524e+02,     8.535837080786220e+02,     8.558218894072869e+02,     8.580115506753478e+02,     8.601550940475242e+02, 
            8.622547398107292e+02,     8.643125445944577e+02,     8.663304173418326e+02,     8.683101333593288e+02,     8.702533467182459e+02, 
            8.721616012364890e+02,     8.740363402327969e+02,     8.758789152156861e+02,     8.776905936447197e+02,     8.794725658813132e+02, 
            8.812259514292050e+02,     8.829518045505466e+02,     8.846511193315550e+02,     8.863248342616496e+02,     8.879738363813813e+02, 
            8.895989650472974e+02,     8.912010153556492e+02,     8.927807412615789e+02,     8.943388584259144e+02,     8.958760468177603e+02, 
            8.973929530977468e+02,     8.988901928038503e+02,     9.003683523592096e+02,     9.018279909191273e+02,     9.032696420725528e+02, 
            9.046938154116586e+02,     9.061009979816565e+02,     9.074916556216998e+02,     9.088662342066092e+02,     9.102251607981207e+02, 
            9.115688447135038e+02,     9.128976785186013e+02,     9.142120389516383e+02,     9.155122877835543e+02,     9.167987726200398e+02, 
            9.180718276499729e+02,     9.193317743445386e+02,     9.205789221108755e+02,     9.218135689037967e+02,     9.230360017987642e+02, 
            9.242464975290620e+02,     9.254453229898215e+02,     9.266327357113385e+02,     9.278089843039195e+02,     9.289743088762900e+02, 
            9.301289414294482e+02,     9.312731062276762e+02,     9.324070201482965e+02,     9.335308930116184e+02,     9.346449278924299e+02, 
            9.357493214142434e+02,     9.368442640274611e+02,     9.379299402724959e+02,     9.390065290288205e+02,     9.400742037508519e+02, 
            9.411331326916576e+02,     9.421834791168753e+02,     9.432254015055174e+02,     9.442590537396546e+02,     9.452845852857284e+02, 
            9.463021413668928e+02,     9.473118631268929e+02,     9.483138877859944e+02,     9.493083483039628e+02,     9.502953751239046e+02, 
            9.512750945086810e+02,     9.522476292420965e+02,     9.532130990109631e+02,     9.541716203707102e+02,     9.551233068569916e+02, 
            9.560682690922730e+02,     9.570066148876890e+02,     9.579384493404095e+02,     9.588638749267448e+02,     9.597829915912364e+02, 
            9.606958968319265e+02,     9.616026857819969e+02,     9.625034512879821e+02,     9.633982839847076e+02,     9.642872723671413e+02, 
            9.651705028592889e+02,     9.660480598802909e+02,     9.669200259078639e+02,     9.677864815391923e+02,     9.686475055494268e+02, 
            9.695031749478647e+02,     9.703535650460816e+02,     9.711987494520299e+02,     9.720388002087949e+02,     9.728737877818946e+02, 
            9.737037811210892e+02,     9.745288477048649e+02,     9.753490535832702e+02,     9.761644634191830e+02,     9.769751405280574e+02, 
            9.777811469162408e+02,     9.785825433179053e+02,     9.793793892306689e+02,     9.801717429499481e+02,     9.809596616021067e+02, 
            9.817432011764486e+02,     9.825224165561727e+02,     9.832973615241137e+02,     9.840680888888154e+02,     9.848346503642042e+02, 
            9.855970966969662e+02,     9.863554776669582e+02,     9.871098421123401e+02,     9.878602379538820e+02,     9.886067122184785e+02, 
            9.893493110618983e+02,     9.900880797907994e+02,     9.908230628840428e+02,     9.915543040133269e+02,     9.922818460631725e+02, 
            9.930057311502757e+02,     9.937260006422675e+02,     9.944426951758824e+02,     9.951558546745790e+02,     9.958655183656143e+02, 
            9.965717247966040e+02,     9.972745118515854e+02,     9.979739167665949e+02,     9.986699761447869e+02,     9.993627259711031e+02, 
            1.000052201626511e+03,     1.000738437901831e+03,     1.001421469011152e+03,     1.002101328604877e+03,     1.002778049782382e+03, 
            1.003451665104311e+03,     1.004122206604545e+03,     1.004789705801808e+03,     1.005454193710968e+03,     1.006115700854011e+03, 
            1.006774257270726e+03,     1.007429892529079e+03,     1.008082635735322e+03,     1.008732515543814e+03,     1.009379560166586e+03, 
            1.010023797382643e+03,     1.010665254547025e+03,     1.011303958599621e+03,     1.011939936073753e+03,     1.012573213104539e+03, 
            1.013203815437036e+03,     1.013831768434167e+03,     1.014457097084447e+03,     1.015079826009519e+03,     1.015699979471484e+03, 
            1.016317581380055e+03,     1.016932655299529e+03,     1.017545224480844e+03,     1.018155311766017e+03,     1.018762939749649e+03, 
            1.019368130680656e+03,     1.019970906494874e+03,     1.020571288821056e+03,     1.021169298986730e+03,     1.021764958023901e+03, 
            1.022358286674634e+03,     1.022949305396490e+03,     1.023538034367843e+03,     1.024124493493056e+03,     1.024708701897424e+03, 
            1.025290679955239e+03,     1.025870446285692e+03,     1.026448019746609e+03,     1.027023418945970e+03,     1.027596662246429e+03, 
            1.028167767769707e+03,     1.028736753400895e+03,     1.029303636792654e+03,     1.029868435369329e+03,     1.030431166330965e+03, 
            1.030991846657231e+03,     1.031550493111266e+03,     1.032107122243430e+03,     1.032661750394979e+03,     1.033214393701661e+03, 
            1.033765068097223e+03,     1.034313789316857e+03,     1.034860572900562e+03,     1.035405434196435e+03,     1.035948388363895e+03, 
            1.036489450376835e+03,     1.037028635026709e+03,     1.037565956925553e+03,     1.038101430508948e+03,     1.038635070038908e+03, 
            1.039166889606724e+03,     1.039696903135739e+03,     1.040225124384069e+03,     1.040751566947264e+03,     1.041276244260923e+03, 
            1.041799169603252e+03,     1.042320356097563e+03,     1.042839816714737e+03,     1.043357564275622e+03,     1.043873611453396e+03, 
            1.044387970775878e+03,     1.044900654627788e+03,     1.045411675252974e+03,     1.045921044756581e+03,     1.046428775107193e+03, 
            1.046934878138923e+03,     1.047439365553458e+03,     1.047942248922084e+03,     1.048443539687649e+03,     1.048943249166505e+03, 
            1.049441388550405e+03,     1.049937968908364e+03,     1.050433001188491e+03,     1.050926496219778e+03,     1.051418464713860e+03, 
            1.051908917266747e+03,     1.052397864360510e+03,     1.052885316364952e+03,     1.053371283539234e+03,     1.053855776033483e+03, 
            1.054338803890362e+03,     1.054820377046611e+03,     1.055300505334572e+03,     1.055779198483668e+03,     1.056256466121873e+03, 
            1.056732317777142e+03,     1.057206762878824e+03,     1.057679810759046e+03,     1.058151470654072e+03,     1.058621751705643e+03, 
            1.059090662962282e+03,     1.059558213380593e+03,     1.060024411826521e+03,     1.060489267076600e+03,     1.060952787819174e+03, 
            1.061414982655602e+03,     1.061875860101440e+03,     1.062335428587595e+03,     1.062793696461475e+03,     1.063250671988104e+03, 
            1.063706363351232e+03,     1.064160778654410e+03,     1.064613925922066e+03,     1.065065813100541e+03,     1.065516448059131e+03, 
            1.065965838591092e+03,     1.066413992414640e+03,     1.066860917173929e+03,     1.067306620440018e+03,     1.067751109711814e+03, 
            1.068194392417005e+03,     1.068636475912982e+03,     1.069077367487735e+03,     1.069517074360746e+03,     1.069955603683854e+03, 
            1.070392962542125e+03,     1.070829157954686e+03,     1.071264196875567e+03,     1.071698086194508e+03,     1.072130832737779e+03, 
            1.072562443268958e+03,     1.072992924489723e+03,     1.073422283040609e+03,     1.073850525501775e+03,     1.074277658393740e+03, 
            1.074703688178120e+03,     1.075128621258344e+03,     1.075552463980372e+03,     1.075975222633383e+03,     1.076396903450477e+03, 
            1.076817512609339e+03,     1.077237056232917e+03,     1.077655540390072e+03,     1.078072971096228e+03,     1.078489354314012e+03, 
            1.078904695953879e+03,     1.079319001874729e+03,     1.079732277884519e+03,     1.080144529740862e+03,     1.080555763151620e+03, 
            1.080965983775482e+03,     1.081375197222541e+03,     1.081783409054860e+03,     1.082190624787027e+03,     1.082596849886704e+03, 
            1.083002089775168e+03,     1.083406349827846e+03,     1.083809635374838e+03,     1.084211951701433e+03,     1.084613304048625e+03, 
            1.085013697613608e+03,     1.085413137550279e+03,     1.085811628969722e+03,     1.086209176940691e+03,     1.086605786490083e+03, 
            1.087001462603411e+03,     1.087396210225257e+03,     1.087790034259738e+03,     1.088182939570942e+03,     1.088574930983380e+03, 
            1.088966013282418e+03,     1.089356191214709e+03,     1.089745469488613e+03,     1.090133852774619e+03,     1.090521345705758e+03, 
            1.090907952878003e+03,     1.091293678850681e+03,     1.091678528146859e+03,     1.092062505253739e+03,     1.092445614623044e+03, 
            1.092827860671391e+03,     1.093209247780676e+03,     1.093589780298434e+03,     1.093969462538209e+03,     1.094348298779914e+03, 
            1.094726293270179e+03,     1.095103450222713e+03,     1.095479773818638e+03,     1.095855268206838e+03,     1.096229937504292e+03, 
            1.096603785796404e+03,     1.096976817137336e+03,     1.097349035550328e+03,     1.097720445028016e+03,     1.098091049532750e+03, 
            1.098460852996903e+03,     1.098829859323178e+03,     1.099198072384914e+03,     1.099565496026377e+03,     1.099932134063066e+03, 
            1.100297990281997e+03,     1.100663068441989e+03,     1.101027372273958e+03,     1.101390905481186e+03,     1.101753671739604e+03, 
            1.102115674698063e+03,     1.102476917978609e+03,     1.102837405176740e+03,     1.103197139861677e+03,     1.103556125576623e+03, 
            1.103914365839016e+03,     1.104271864140783e+03,     1.104628623948595e+03,     1.104984648704109e+03,     1.105339941824214e+03, 
            1.105694506701271e+03,     1.106048346703355e+03,     1.106401465174486e+03,     1.106753865434863e+03,     1.107105550781091e+03, 
            1.107456524486414e+03,     1.107806789800932e+03,     1.108156349951828e+03,     1.108505208143581e+03,     1.108853367558186e+03, 
            1.109200831355369e+03,     1.109547602672791e+03,     1.109893684626262e+03,     1.110239080309946e+03,     1.110583792796564e+03, 
            1.110927825137592e+03,     1.111271180363466e+03,     1.111613861483770e+03,     1.111955871487441e+03,     1.112297213342946e+03, 
            1.112637889998486e+03,     1.112977904382174e+03,     1.113317259402223e+03,     1.113655957947128e+03,     1.113994002885850e+03, 
            1.114331397067990e+03,     1.114668143323968e+03,     1.115004244465196e+03,     1.115339703284256e+03,     1.115674522555062e+03, 
            1.116008705033036e+03,     1.116342253455270e+03,     1.116675170540695e+03,     1.117007458990239e+03,     1.117339121486993e+03, 
            1.117670160696367e+03,     1.118000579266248e+03,     1.118330379827158e+03,     1.118659564992405e+03,     1.118988137358238e+03, 
            1.119316099503994e+03,     1.119643453992251e+03,     1.119970203368972e+03,     1.120296350163654e+03,     1.120621896889468e+03, 
            1.120946846043403e+03,     1.121271200106409e+03,     1.121594961543532e+03,     1.121918132804058e+03,     1.122240716321643e+03, 
            1.122562714514449e+03,     1.122884129785283e+03,     1.123204964521719e+03,     1.123525221096239e+03,     1.123844901866354e+03, 
            1.124164009174735e+03,     1.124482545349341e+03,     1.124800512703539e+03,     1.125117913536232e+03,     1.125434750131979e+03, 
            1.125751024761119e+03,     1.126066739679883e+03,     1.126381897130524e+03,     1.126696499341424e+03,     1.127010548527214e+03, 
            1.127324046888891e+03,     1.127636996613926e+03,     1.127949399876380e+03,     1.128261258837017e+03,     1.128572575643406e+03, 
            1.128883352430041e+03,     1.129193591318439e+03,     1.129503294417252e+03,     1.129812463822370e+03,     1.130121101617027e+03, 
            1.130429209871904e+03,     1.130736790645228e+03,     1.131043845982879e+03,     1.131350377918487e+03,     1.131656388473527e+03, 
            1.131961879657429e+03,     1.132266853467659e+03,     1.132571311889829e+03,     1.132875256897785e+03,     1.133178690453703e+03, 
            1.133481614508183e+03,     1.133784031000338e+03,     1.134085941857891e+03,     1.134387348997260e+03,     1.134688254323651e+03
    },
    {
            1.784571172368313e+00,     5.412117269103247e+00,     9.116042933321797e+00,     1.290055345423194e+01,     1.677023833764654e+01, 
            2.073012084558327e+01,     2.478571596531519e+01,     2.894309861816949e+01,     3.320898440134525e+01,     3.759082578362909e+01, 
            4.209692751472871e+01,     4.673658613563863e+01,     5.152026001351877e+01,     5.645977844455727e+01,     6.156860133660558e+01, 
            6.686214520545809e+01,     7.235819732892340e+01,     7.807744891636457e+01,     8.404419173284869e+01,     9.028724357244424e+01, 
            9.684120118239980e+01,     1.037481734787490e+02,     1.110602396071908e+02,     1.188430378490557e+02,     1.271811890276779e+02, 
            1.361868393563706e+02,     1.460138201702749e+02,     1.568826782271019e+02,     1.691288084901107e+02,     1.833063710347172e+02, 
            2.004546843644833e+02,     2.230131963177490e+02,     7.174223629615745e+02,     7.297820501360655e+02,     7.398675222073091e+02, 
            7.484969217017541e+02,     7.560960159877887e+02,     7.629195448236707e+02,     7.691339220935653e+02,     7.748547248641144e+02, 
            7.801659520923884e+02,     7.851308362514096e+02,     7.897983319386143e+02,     7.942072193066900e+02,     7.983888112606753e+02, 
            8.023688031442560e+02,     8.061685743782883e+02,     8.098061278422718e+02,     8.132967827902596e+02,     8.166536958232268e+02, 
            8.198882592391225e+02,     8.230104102153189e+02,     8.260288740158567e+02,     8.289513576176164e+02,     8.317847055488269e+02, 
            8.345350265590370e+02,     8.372077975111134e+02,     8.398079492961591e+02,     8.423399384216855e+02,     8.448078070794400e+02, 
            8.472152338726655e+02,     8.495655769119093e+02,     8.518619106312927e+02,     8.541070574033619e+02,     8.563036148188578e+02, 
            8.584539793325521e+02,     8.605603668463535e+02,     8.626248306980031e+02,     8.646492774415166e+02,     8.666354807396121e+02, 
            8.685850936350363e+02,     8.704996594243702e+02,     8.723806213225039e+02,     8.742293310768058e+02,     8.760470566660172e+02, 
            8.778349891989246e+02,     8.795942491112314e+02,     8.813258917451384e+02,     8.830309123844255e+02,     8.847102508079474e+02, 
            8.863647954161047e+02,     8.879953869777224e+02,     8.896028220387068e+02,     8.911878560286614e+02,     8.927512060971839e+02, 
            8.942935537077296e+02,     8.958155470136122e+02,     8.973178030378400e+02,     8.988009096760120e+02,     9.002654275392911e+02, 
            9.017118916526380e+02,     9.031408130217704e+02,     9.045526800809130e+02,     9.059479600321032e+02,     9.073271000856968e+02, 
            9.086905286107375e+02,     9.100386562029676e+02,     9.113718766774962e+02,     9.126905679924340e+02,     9.139950931092117e+02, 
            9.152858007947333e+02,     9.165630263700616e+02,     9.178270924098518e+02,     9.190783093964125e+02,     9.203169763318811e+02, 
            9.215433813117222e+02,     9.227578020624446e+02,     9.239605064462057e+02,     9.251517529347374e+02,     9.263317910548022e+02, 
            9.275008618072309e+02,     9.286591980614069e+02,     9.298070249269108e+02,     9.309445601039046e+02,     9.320720142137092e+02, 
            9.331895911109023e+02,     9.342974881781915e+02,     9.353958966051670e+02,     9.364850016520112e+02,     9.375649828991318e+02, 
            9.386360144836093e+02,     9.396982653244511e+02,     9.407518993364010e+02,     9.417970756298697e+02,     9.428339487021137e+02, 
            9.438626686190638e+02,     9.448833811881477e+02,     9.458962281226320e+02,     9.469013467781934e+02,     9.478988716493978e+02, 
            9.488889330982753e+02,     9.498716577821757e+02,     9.508471691382870e+02,     9.518155873432721e+02,     9.527770294305429e+02, 
            9.537316094022223e+02,     9.546794383360791e+02,     9.556206244877205e+02,     9.565552733882793e+02,     9.574834879378317e+02, 
            9.584053684947959e+02,     9.593210129614829e+02,     9.602305168660265e+02,     9.611339734408621e+02,     9.620314736979375e+02, 
            9.629231065008081e+02,     9.638089586337837e+02,     9.646891148682661e+02,     9.655636580264128e+02,     9.664326690422591e+02, 
            9.672962270204239e+02,     9.681544092925022e+02,     9.690072914848811e+02,     9.698549475151424e+02,     9.706974497277612e+02, 
            9.715348688838103e+02,     9.723672742223677e+02,     9.731947335051766e+02,     9.740173130596465e+02,     9.748350778202725e+02, 
            9.756480913685435e+02,     9.764564159714017e+02,     9.772601126183240e+02,     9.780592410570794e+02,     9.788538598282150e+02, 
            9.796440262983402e+02,     9.804297966677244e+02,     9.812112261011080e+02,     9.819883686052092e+02,     9.827612771611833e+02, 
            9.835300037261729e+02,     9.842945992603077e+02,     9.850551137528088e+02,     9.858115962472210e+02,     9.865640948658219e+02, 
            9.873126568332278e+02,     9.880573284992395e+02,     9.887981553609427e+02,     9.895351820841156e+02,     9.902684525239439e+02, 
            9.909980097450843e+02,     9.917238960411072e+02,     9.924461529533226e+02,     9.931648212890324e+02,     9.938799411392188e+02, 
            9.945915518956913e+02,     9.952996922677168e+02,     9.960044002981459e+02,     9.967057133790614e+02,     9.974036682669552e+02, 
            9.980983010974602e+02,     9.987896473996497e+02,     9.994777421099205e+02,     1.000162619585469e+03,     1.000844313617386e+03, 
            1.001522857443368e+03,     1.002198283760082e+03,     1.002870624735154e+03,     1.003539912018852e+03,     1.004206176755420e+03, 
            1.004869449594103e+03,     1.005529760699877e+03,     1.006187139763867e+03,     1.006841616013498e+03,     1.007493218222362e+03, 
            1.008141974719813e+03,     1.008787913400326e+03,     1.009431061732578e+03,     1.010071446768315e+03,     1.010709095150962e+03, 
            1.011344033124030e+03,     1.011976286539285e+03,     1.012605880864716e+03,     1.013232841192297e+03,     1.013857192245540e+03, 
            1.014478958411160e+03,     1.015098163648012e+03,     1.015714831643151e+03,     1.016328985718112e+03,     1.016940648861007e+03, 
            1.017549843733015e+03,     1.018156592674710e+03,     1.018760917712240e+03,     1.019362840563346e+03,     1.019962382643247e+03, 
            1.020559565070370e+03,     1.021154408671949e+03,     1.021746933989496e+03,     1.022337161284126e+03,     1.022925110031426e+03, 
            1.023510800950394e+03,     1.024094252998566e+03,     1.024675485366371e+03,     1.025254516988695e+03,     1.025831366549515e+03, 
            1.026406052486419e+03,     1.026978592995028e+03,     1.027549006033318e+03,     1.028117309325836e+03,     1.028683520367831e+03, 
            1.029247656429289e+03,     1.029809734558877e+03,     1.030369771587797e+03,     1.030927784133563e+03,     1.031483788603688e+03, 
            1.032037801199290e+03,     1.032589837918627e+03,     1.033139914560549e+03,     1.033688046727872e+03,     1.034234249830691e+03, 
            1.034778539089617e+03,     1.035320929538936e+03,     1.035861436029717e+03,     1.036400073232844e+03,     1.036936855641985e+03, 
            1.037471797576509e+03,     1.038004913184323e+03,     1.038536216444672e+03,     1.039065721170866e+03,     1.039593441012958e+03, 
            1.040119389460367e+03,     1.040643579844442e+03,     1.041166025340984e+03,     1.041686738972707e+03,     1.042205733611655e+03, 
            1.042723021981576e+03,     1.043238616660233e+03,     1.043752530081686e+03,     1.044264774538520e+03,     1.044775362184031e+03, 
            1.045284305034368e+03,     1.045791614970639e+03,     1.046297303740967e+03,     1.046801382962514e+03,     1.047303864123464e+03, 
            1.047804758584965e+03,     1.048304077583037e+03,     1.048801832230444e+03,     1.049298033518528e+03,     1.049792692319015e+03, 
            1.050285819385771e+03,     1.050777425356549e+03,     1.051267520754686e+03,     1.051756115990767e+03,     1.052243221364275e+03, 
            1.052728847065194e+03,     1.053213003175593e+03,     1.053695699671168e+03,     1.054176946422780e+03,     1.054656753197934e+03, 
            1.055135129662259e+03,     1.055612085380945e+03,     1.056087629820159e+03,     1.056561772348435e+03,     1.057034522238047e+03, 
            1.057505888666342e+03,     1.057975880717061e+03,     1.058444507381638e+03,     1.058911777560469e+03,     1.059377700064161e+03, 
            1.059842283614765e+03,     1.060305536846980e+03,     1.060767468309341e+03,     1.061228086465382e+03,     1.061687399694788e+03, 
            1.062145416294515e+03,     1.062602144479906e+03,     1.063057592385769e+03,     1.063511768067456e+03,     1.063964679501912e+03, 
            1.064416334588710e+03,     1.064866741151069e+03,     1.065315906936854e+03,     1.065763839619560e+03,     1.066210546799282e+03, 
            1.066656036003664e+03,     1.067100314688834e+03,     1.067543390240330e+03,     1.067985269974004e+03,     1.068425961136910e+03, 
            1.068865470908183e+03,     1.069303806399906e+03,     1.069740974657952e+03,     1.070176982662823e+03,     1.070611837330472e+03, 
            1.071045545513109e+03,     1.071478114000004e+03,     1.071909549518261e+03,     1.072339858733596e+03,     1.072769048251097e+03, 
            1.073197124615965e+03,     1.073624094314256e+03,     1.074049963773601e+03,     1.074474739363920e+03,     1.074898427398125e+03, 
            1.075321034132814e+03,     1.075742565768944e+03,     1.076163028452507e+03,     1.076582428275191e+03,     1.077000771275025e+03, 
            1.077418063437022e+03,     1.077834310693813e+03,     1.078249518926260e+03,     1.078663693964077e+03,     1.079076841586425e+03, 
            1.079488967522510e+03,     1.079900077452166e+03,     1.080310177006432e+03,     1.080719271768120e+03,     1.081127367272375e+03, 
            1.081534469007222e+03,     1.081940582414117e+03,     1.082345712888473e+03,     1.082749865780194e+03,     1.083153046394195e+03, 
            1.083555259990908e+03,     1.083956511786794e+03,     1.084356806954838e+03,     1.084756150625037e+03,     1.085154547884890e+03, 
            1.085552003779867e+03,     1.085948523313885e+03,     1.086344111449770e+03,     1.086738773109712e+03,     1.087132513175716e+03, 
            1.087525336490047e+03,     1.087917247855668e+03,     1.088308252036671e+03,     1.088698353758704e+03,     1.089087557709389e+03, 
            1.089475868538738e+03,     1.089863290859560e+03,     1.090249829247868e+03,     1.090635488243267e+03,     1.091020272349358e+03, 
            1.091404186034114e+03,     1.091787233730269e+03,     1.092169419835689e+03,     1.092550748713747e+03,     1.092931224693687e+03, 
            1.093310852070985e+03,     1.093689635107707e+03,     1.094067578032858e+03,     1.094444685042734e+03,     1.094820960301259e+03, 
            1.095196407940325e+03,     1.095571032060125e+03,     1.095944836729487e+03,     1.096317825986188e+03,     1.096690003837286e+03, 
            1.097061374259427e+03,     1.097431941199165e+03,     1.097801708573264e+03,     1.098170680269008e+03,     1.098538860144492e+03, 
            1.098906252028929e+03,     1.099272859722939e+03,     1.099638686998833e+03,     1.100003737600904e+03,     1.100368015245708e+03, 
            1.100731523622338e+03,     1.101094266392702e+03,     1.101456247191794e+03,     1.101817469627960e+03,     1.102177937283162e+03, 
            1.102537653713240e+03,     1.102896622448172e+03,     1.103254846992323e+03,     1.103612330824701e+03,     1.103969077399203e+03, 
            1.104325090144862e+03,     1.104680372466084e+03,     1.105034927742895e+03,     1.105388759331172e+03,     1.105741870562876e+03, 
            1.106094264746285e+03,     1.106445945166221e+03,     1.106796915084275e+03,     1.107147177739027e+03,     1.107496736346269e+03, 
            1.107845594099218e+03,     1.108193754168735e+03,     1.108541219703533e+03,     1.108887993830388e+03,     1.109234079654342e+03, 
            1.109579480258914e+03,     1.109924198706297e+03,     1.110268238037557e+03,     1.110611601272833e+03,     1.110954291411529e+03, 
            1.111296311432510e+03,     1.111637664294288e+03,     1.111978352935212e+03,     1.112318380273656e+03,     1.112657749208195e+03, 
            1.112996462617798e+03,     1.113334523361999e+03,     1.113671934281076e+03,     1.114008698196228e+03,     1.114344817909745e+03, 
            1.114680296205185e+03,     1.115015135847538e+03,     1.115349339583395e+03,     1.115682910141114e+03,     1.116015850230985e+03, 
            1.116348162545388e+03,     1.116679849758956e+03,     1.117010914528734e+03,     1.117341359494331e+03,     1.117671187278080e+03, 
            1.118000400485185e+03,     1.118329001703879e+03,     1.118656993505568e+03,     1.118984378444981e+03,     1.119311159060316e+03, 
            1.119637337873386e+03,     1.119962917389757e+03,     1.120287900098898e+03,     1.120612288474311e+03,     1.120936084973678e+03, 
            1.121259292038992e+03,     1.121581912096695e+03,     1.121903947557811e+03,     1.122225400818079e+03,     1.122546274258083e+03, 
            1.122866570243384e+03,     1.123186291124644e+03,     1.123505439237756e+03,     1.123824016903969e+03,     1.124142026430012e+03, 
            1.124459470108216e+03,     1.124776350216635e+03,     1.125092669019168e+03,     1.125408428765677e+03,     1.125723631692103e+03, 
            1.126038280020587e+03,     1.126352375959580e+03,     1.126665921703957e+03,     1.126978919435137e+03,     1.127291371321184e+03, 
            1.127603279516927e+03,     1.127914646164063e+03,     1.128225473391265e+03,     1.128535763314295e+03,     1.128845518036105e+03, 
            1.129154739646940e+03,     1.129463430224449e+03,     1.129771591833779e+03,     1.130079226527683e+03,     1.130386336346618e+03, 
            1.130692923318844e+03,     1.130998989460524e+03,     1.131304536775821e+03,     1.131609567256993e+03,     1.131914082884492e+03, 
            1.132218085627053e+03,     1.132521577441795e+03,     1.132824560274308e+03,     1.133127036058745e+03,     1.133429006717918e+03
    },
    {
            1.780908835005585e+00,     5.400633607277567e+00,     9.096029001108009e+00,     1.287122471904619e+01,     1.673072412761082e+01, 
            2.067945192145987e+01,     2.472280980475580e+01,     2.886674189058076e+01,     3.311781196730452e+01,     3.748329536101566e+01, 
            4.197128889597960e+01,     4.659084349011909e+01,     5.135212532657398e+01,     5.626661347151781e+01,     6.134734449623294e+01, 
            6.660921846394733e+01,     7.206938611221216e+01,     7.774774507768711e+01,     8.366758499956474e+01,     8.985643968328390e+01, 
            9.634723330446694e+01,     1.031798541664756e+02,     1.104033672376785e+02,     1.180792115266362e+02,     1.262859727200094e+02, 
            1.351267890162958e+02,     1.447413989172987e+02,     1.553269336087183e+02,     1.671766422282030e+02,     1.807598156247458e+02, 
            1.969129625845261e+02,     2.174189457896028e+02,     2.478449507132025e+02,     7.167608760910143e+02,     7.286619010239349e+02, 
            7.385037907981966e+02,     7.469863589570289e+02,     7.544905254429922e+02,     7.612501182425417e+02,     7.674204404068765e+02, 
            7.731106080412485e+02,     7.784006064438173e+02,     7.833510461080438e+02,     7.880090999343221e+02,     7.924122985489926e+02, 
            7.965910557200921e+02,     8.005704058922979e+02,     8.043712339968309e+02,     8.080111673486371e+02,     8.115052363078244e+02, 
            8.148663728225262e+02,     8.181057928595121e+02,     8.212332940832906e+02,     8.242574906183779e+02,     8.271860003880330e+02, 
            8.300255962125752e+02,     8.327823288652510e+02,     8.354616281807108e+02,     8.380683868063991e+02,     8.406070300950951e+02, 
            8.430815748337735e+02,     8.454956789062290e+02,     8.478526835370336e+02,     8.501556494222832e+02,     8.524073877898267e+02, 
            8.546104872281658e+02,     8.567673369640769e+02,     8.588801471438221e+02,     8.609509665733178e+02,     8.629816982933365e+02, 
            8.649741133018427e+02,     8.669298626839807e+02,     8.688504883681056e+02,     8.707374326918724e+02,     8.725920469340518e+02, 
            8.744155989443427e+02,     8.762092799840032e+02,     8.779742108738745e+02,     8.797114475328028e+02,     8.814219859780007e+02, 
            8.831067668492414e+02,     8.847666795105630e+02,     8.864025657762311e+02,     8.880152233017171e+02,     8.896054086753763e+02, 
            8.911738402421357e+02,     8.927212006867192e+02,     8.942481394006850e+02,     8.957552746547275e+02,     8.972431955952467e+02, 
            8.987124640820422e+02,     9.001636163821303e+02,     9.015971647330557e+02,     9.030135987876276e+02,     9.044133869507625e+02, 
            9.057969776179877e+02,     9.071648003242171e+02,     9.085172668105010e+02,     9.098547720157271e+02,     9.111776949995265e+02, 
            9.124863998020835e+02,     9.137812362459493e+02,     9.150625406845406e+02,     9.163306367015132e+02,     9.175858357648707e+02, 
            9.188284378392741e+02,     9.200587319597478e+02,     9.212769967696688e+02,     9.224835010256962e+02,     9.236785040720515e+02, 
            9.248622562863745e+02,     9.260349994991810e+02,     9.271969673887878e+02,     9.283483858534097e+02,     9.294894733620145e+02, 
            9.306204412853682e+02,     9.317414942086154e+02,     9.328528302266221e+02,     9.339546412232082e+02,     9.350471131353336e+02, 
            9.361304262031902e+02,     9.372047552075067e+02,     9.382702696961807e+02,     9.393271341960742e+02,     9.403755084142806e+02, 
            9.414155474299636e+02,     9.424474018766048e+02,     9.434712181152308e+02,     9.444871383991629e+02,     9.454953005016623e+02, 
            9.464958396247059e+02,     9.474888865375673e+02,     9.484745683932135e+02,     9.494530091066665e+02,     9.504243293210803e+02, 
            9.513886465253403e+02,     9.523460751663445e+02,     9.532967267562515e+02,     9.542407099749644e+02,     9.551781307681151e+02, 
            9.561090924407597e+02,     9.570336957470473e+02,     9.579520389760384e+02,     9.588642180338895e+02,     9.597703265225759e+02, 
            9.606704558153440e+02,     9.615646951290405e+02,     9.624531315934800e+02,     9.633358503180015e+02,     9.642129344553409e+02, 
            9.650844652629604e+02,     9.659505221619464e+02,     9.668111828080205e+02,     9.676665230868829e+02,     9.685166172572295e+02, 
            9.693615379390076e+02,     9.702013561777180e+02,     9.710361414909663e+02,     9.718659619132818e+02,     9.726908840392690e+02, 
            9.735109730651772e+02,     9.743262928289477e+02,     9.751369058488158e+02,     9.759428733605241e+02,     9.767442553532063e+02, 
            9.775411106040098e+02,     9.783334966879759e+02,     9.791214701060026e+02,     9.799050861697539e+02,     9.806843991310338e+02, 
            9.814594621854939e+02,     9.822303275006780e+02,     9.829970462431291e+02,     9.837596686045857e+02,     9.845182438273138e+02, 
            9.852728202286070e+02,     9.860234452244830e+02,     9.867701653526121e+02,     9.875130262945128e+02,     9.882520728970286e+02, 
            9.889873491931311e+02,     9.897188984220604e+02,     9.904467630488376e+02,     9.911709847831720e+02,     9.918916045977776e+02, 
            9.926086627461326e+02,     9.933221987796945e+02,     9.940322515645931e+02,     9.947388592978256e+02,     9.954420595229561e+02, 
            9.961418891453640e+02,     9.968383844470271e+02,     9.975315811008793e+02,     9.982215141847470e+02,     9.989082181948843e+02, 
            9.995917270591125e+02,     1.000272074149591e+03,     1.000949292295216e+03,     1.001623413793679e+03,     1.002294470423176e+03, 
            1.002962493453800e+03,     1.003627513658607e+03,     1.004289561324381e+03,     1.004948666262109e+03,     1.005604857817163e+03, 
            1.006258164879203e+03,     1.006908615891829e+03,     1.007556238861952e+03,     1.008201061368935e+03,     1.008843110573481e+03, 
            1.009482413226288e+03,     1.010118995676483e+03,     1.010752883904272e+03,     1.011384103430040e+03,     1.012012679472228e+03, 
            1.012638636853675e+03,     1.013262000034634e+03,     1.013882793119988e+03,     1.014501039866276e+03,     1.015116763688549e+03, 
            1.015729987667051e+03,     1.016340734553739e+03,     1.016949026778633e+03,     1.017554886456025e+03,     1.018158335390520e+03, 
            1.018759395082943e+03,     1.019358086736100e+03,     1.019954431260394e+03,     1.020548448786234e+03,     1.021140160624429e+03, 
            1.021729586364438e+03,     1.022316745800656e+03,     1.022901658461241e+03,     1.023484343612998e+03,     1.024064820266127e+03, 
            1.024643107178877e+03,     1.025219222862086e+03,     1.025793185583622e+03,     1.026365013372717e+03,     1.026934724024212e+03, 
            1.027502335102695e+03,     1.028067863946554e+03,     1.028631327671941e+03,     1.029192743176644e+03,     1.029752127143872e+03, 
            1.030309496045964e+03,     1.030864866148008e+03,     1.031418253511389e+03,     1.031969673997257e+03,     1.032519143269920e+03, 
            1.033066676800160e+03,     1.033612289868492e+03,     1.034155997568333e+03,     1.034697814809127e+03,     1.035237756319381e+03, 
            1.035775836649657e+03,     1.036312070175491e+03,     1.036846471100254e+03,     1.037379053457950e+03,     1.037909831115965e+03, 
            1.038438817777751e+03,     1.038966026985462e+03,     1.039491472122529e+03,     1.040015166416187e+03,     1.040537122939959e+03, 
            1.041057354616072e+03,     1.041575874217839e+03,     1.042092694371993e+03,     1.042607827560964e+03,     1.043121286125129e+03, 
            1.043633082264994e+03,     1.044143228043361e+03,     1.044651735387424e+03,     1.045158616090850e+03,     1.045663881815805e+03, 
            1.046167544094943e+03,     1.046669614333358e+03,     1.047170103810506e+03,     1.047669023682073e+03,     1.048166384981826e+03, 
            1.048662198623423e+03,     1.049156475402180e+03,     1.049649225996821e+03,     1.050140460971180e+03,     1.050630190775882e+03, 
            1.051118425749990e+03,     1.051605176122619e+03,     1.052090452014524e+03,     1.052574263439657e+03,     1.053056620306695e+03, 
            1.053537532420546e+03,     1.054017009483817e+03,     1.054495061098266e+03,     1.054971696766226e+03,     1.055446925891995e+03, 
            1.055920757783215e+03,     1.056393201652214e+03,     1.056864266617336e+03,     1.057333961704233e+03,     1.057802295847152e+03, 
            1.058269277890184e+03,     1.058734916588502e+03,     1.059199220609569e+03,     1.059662198534333e+03,     1.060123858858399e+03, 
            1.060584209993176e+03,     1.061043260267010e+03,     1.061501017926298e+03,     1.061957491136581e+03,     1.062412687983614e+03, 
            1.062866616474430e+03,     1.063319284538376e+03,     1.063770700028131e+03,     1.064220870720719e+03,     1.064669804318489e+03, 
            1.065117508450094e+03,     1.065563990671438e+03,     1.066009258466627e+03,     1.066453319248886e+03,     1.066896180361470e+03, 
            1.067337849078563e+03,     1.067778332606152e+03,     1.068217638082901e+03,     1.068655772580997e+03,     1.069092743106992e+03, 
            1.069528556602627e+03,     1.069963219945648e+03,     1.070396739950599e+03,     1.070829123369616e+03,     1.071260376893194e+03, 
            1.071690507150956e+03,     1.072119520712401e+03,     1.072547424087640e+03,     1.072974223728128e+03,     1.073399926027377e+03, 
            1.073824537321661e+03,     1.074248063890710e+03,     1.074670511958396e+03,     1.075091887693405e+03,     1.075512197209896e+03, 
            1.075931446568160e+03,     1.076349641775257e+03,     1.076766788785655e+03,     1.077182893501847e+03,     1.077597961774974e+03, 
            1.078011999405419e+03,     1.078425012143414e+03,     1.078837005689622e+03,     1.079247985695714e+03,     1.079657957764943e+03, 
            1.080066927452704e+03,     1.080474900267087e+03,     1.080881881669424e+03,     1.081287877074824e+03,     1.081692891852705e+03, 
            1.082096931327315e+03,     1.082500000778248e+03,     1.082902105440946e+03,     1.083303250507206e+03,     1.083703441125667e+03, 
            1.084102682402299e+03,     1.084500979400879e+03,     1.084898337143466e+03,     1.085294760610864e+03,     1.085690254743082e+03, 
            1.086084824439783e+03,     1.086478474560738e+03,     1.086871209926254e+03,     1.087263035317619e+03,     1.087653955477524e+03, 
            1.088043975110482e+03,     1.088433098883251e+03,     1.088821331425238e+03,     1.089208677328907e+03,     1.089595141150177e+03, 
            1.089980727408815e+03,     1.090365440588824e+03,     1.090749285138829e+03,     1.091132265472449e+03,     1.091514385968676e+03, 
            1.091895650972239e+03,     1.092276064793965e+03,     1.092655631711142e+03,     1.093034355967871e+03,     1.093412241775408e+03, 
            1.093789293312518e+03,     1.094165514725805e+03,     1.094540910130053e+03,     1.094915483608554e+03,     1.095289239213434e+03, 
            1.095662180965974e+03,     1.096034312856931e+03,     1.096405638846849e+03,     1.096776162866366e+03,     1.097145888816525e+03, 
            1.097514820569072e+03,     1.097882961966753e+03,     1.098250316823610e+03,     1.098616888925271e+03,     1.098982682029234e+03, 
            1.099347699865152e+03,     1.099711946135111e+03,     1.100075424513905e+03,     1.100438138649309e+03,     1.100800092162350e+03, 
            1.101161288647569e+03,     1.101521731673282e+03,     1.101881424781844e+03,     1.102240371489898e+03,     1.102598575288634e+03, 
            1.102956039644031e+03,     1.103312767997111e+03,     1.103668763764174e+03,     1.104024030337047e+03,     1.104378571083312e+03, 
            1.104732389346546e+03,     1.105085488446553e+03,     1.105437871679587e+03,     1.105789542318586e+03,     1.106140503613387e+03, 
            1.106490758790951e+03,     1.106840311055582e+03,     1.107189163589135e+03,     1.107537319551239e+03,     1.107884782079498e+03, 
            1.108231554289704e+03,     1.108577639276039e+03,     1.108923040111278e+03,     1.109267759846992e+03,     1.109611801513742e+03, 
            1.109955168121278e+03,     1.110297862658729e+03,     1.110639888094797e+03,     1.110981247377944e+03,     1.111321943436577e+03, 
            1.111661979179238e+03,     1.112001357494780e+03,     1.112340081252549e+03,     1.112678153302566e+03,     1.113015576475695e+03, 
            1.113352353583826e+03,     1.113688487420041e+03,     1.114023980758785e+03,     1.114358836356036e+03,     1.114693056949469e+03, 
            1.115026645258624e+03,     1.115359603985062e+03,     1.115691935812531e+03,     1.116023643407124e+03,     1.116354729417433e+03, 
            1.116685196474709e+03,     1.117015047193011e+03,     1.117344284169360e+03,     1.117672909983889e+03,     1.118000927199992e+03, 
            1.118328338364468e+03,     1.118655146007671e+03,     1.118981352643647e+03,     1.119306960770284e+03,     1.119631972869445e+03, 
            1.119956391407111e+03,     1.120280218833518e+03,     1.120603457583293e+03,     1.120926110075584e+03,     1.121248178714201e+03, 
            1.121569665887742e+03,     1.121890573969722e+03,     1.122210905318705e+03,     1.122530662278433e+03,     1.122849847177945e+03, 
            1.123168462331709e+03,     1.123486510039738e+03,     1.123803992587720e+03,     1.124120912247133e+03,     1.124437271275366e+03, 
            1.124753071915834e+03,     1.125068316398104e+03,     1.125383006937998e+03,     1.125697145737717e+03,     1.126010734985951e+03, 
            1.126323776857992e+03,     1.126636273515840e+03,     1.126948227108320e+03,     1.127259639771186e+03,     1.127570513627230e+03, 
            1.127880850786387e+03,     1.128190653345841e+03,     1.128499923390130e+03,     1.128808662991247e+03,     1.129116874208743e+03, 
            1.129424559089829e+03,     1.129731719669478e+03,     1.130038357970513e+03,     1.130344476003721e+03,     1.130650075767936e+03, 
            1.130955159250144e+03,     1.131259728425572e+03,     1.131563785257787e+03,     1.131867331698784e+03,     1.132170369689084e+03
    },
    {
            1.777261763126223e+00,     5.389201129228339e+00,     9.076110379948041e+00,     1.284204513284805e+01,     1.669142442660250e+01, 
            2.062907658382959e+01,     2.466029269962602e+01,     2.879088935397561e+01,     3.302728256190569e+01,     3.737657551172944e+01, 
            4.184666335390914e+01,     4.644635925329653e+01,     5.118554720130559e+01,     5.607536884068694e+01,     6.112845399055778e+01, 
            6.635920798593013e+01,     7.178417384671532e+01,     7.742249442625621e+01,     8.329651028423460e+01,     8.943254510942096e+01, 
            9.586195553062795e+01,     1.026225621518114e+02,     1.097606446491331e+02,     1.173337966987551e+02,     1.254151378544649e+02, 
            1.340997572590458e+02,     1.435150142908396e+02,     1.538379251543398e+02,     1.653266141962543e+02,     1.783826690666054e+02, 
            1.936916754745441e+02,     2.126084099771291e+02,     2.386606257732388e+02,     7.014600574091933e+02,     7.160904881284506e+02, 
            7.275742467334666e+02,     7.371828854170033e+02,     7.455204685383336e+02,     7.529287856001291e+02,     7.596225851670878e+02, 
            7.657467308536685e+02,     7.714041412999999e+02,     7.766708921396238e+02,     7.816050090238562e+02,     7.862518912023860e+02, 
            7.906478151499955e+02,     7.948222856632175e+02,     7.987996647204183e+02,     8.026003310852180e+02,     8.062415254507216e+02, 
            8.097379791419228e+02,     8.131023903105385e+02,     8.163457904247804e+02,     8.194778303772163e+02,     8.225070067165198e+02, 
            8.254408426100428e+02,     8.282860341170805e+02,     8.310485695527957e+02,     8.337338277433572e+02,     8.363466595520769e+02, 
            8.388914560221767e+02,     8.413722057194117e+02,     8.437925432888995e+02,     8.461557908114471e+02,     8.484649932176386e+02, 
            8.507229487663993e+02,     8.529322353994427e+02,     8.550952336301610e+02,     8.572141465049854e+02,     8.592910170793926e+02, 
            8.613277437741092e+02,     8.633260939153429e+02,     8.652877157128376e+02,     8.672141488888198e+02,     8.691068341374911e+02, 
            8.709671215672313e+02,     8.727962782549081e+02,     8.745954950227657e+02,     8.763658925325456e+02,     8.781085267782468e+02, 
            8.798243940477646e+02,     8.815144354141834e+02,     8.831795408095296e+02,     8.848205527269434e+02,     8.864382695914013e+02, 
            8.880334488341553e+02,     8.896068097017227e+02,     8.911590358266047e+02,     8.926907775836677e+02,     8.942026542533846e+02, 
            8.956952560106974e+02,     8.971691457561687e+02,     8.986248608042590e+02,     9.000629144419498e+02,     9.014837973695343e+02, 
            9.028879790341294e+02,     9.042759088654135e+02,     9.056480174220839e+02,     9.070047174567023e+02,     9.083464049058254e+02, 
            9.096734598116483e+02,     9.109862471807916e+02,     9.122851177853307e+02,     9.135704089106725e+02,     9.148424450544933e+02, 
            9.161015385805244e+02,     9.173479903306766e+02,     9.185820901986461e+02,     9.198041176678956e+02,     9.210143423166460e+02, 
            9.222130242922753e+02,     9.234004147573513e+02,     9.245767563092998e+02,     9.257422833755801e+02,     9.268972225860623e+02, 
            9.280417931241789e+02,     9.291762070582893e+02,     9.303006696545991e+02,     9.314153796728375e+02,     9.325205296458511e+02, 
            9.336163061441405e+02,     9.347028900277696e+02,     9.357804566783827e+02,     9.368491762383295e+02,     9.379092138086087e+02, 
            9.389607296581248e+02,     9.400038794144941e+02,     9.410388142466388e+02,     9.420656810383567e+02,     9.430846220930392e+02, 
            9.440957767839659e+02,     9.450992801004863e+02,     9.460952631837591e+02,     9.470838538081026e+02,     9.480651763419958e+02, 
            9.490393518716101e+02,     9.500064983186859e+02,     9.509667305531029e+02,     9.519201605003938e+02,     9.528668972444905e+02, 
            9.538070471259639e+02,     9.547407138359757e+02,     9.556679985061833e+02,     9.565889997947944e+02,     9.575038139689804e+02, 
            9.584125349838212e+02,     9.593152545579732e+02,     9.602120622462070e+02,     9.611030455089764e+02,     9.619882897791720e+02, 
            9.628678785261869e+02,     9.637418933174250e+02,     9.646104138773861e+02,     9.654735181582308e+02,     9.663312823378062e+02, 
            9.671837809589701e+02,     9.680310869206397e+02,     9.688732715415691e+02,     9.697104046070579e+02,     9.705425544139042e+02, 
            9.713697878137023e+02,     9.721921702545487e+02,     9.730097658212180e+02,     9.738226372738939e+02,     9.746308460855082e+02, 
            9.754344524535074e+02,     9.762335154332699e+02,     9.770280928208662e+02,     9.778182412878242e+02,     9.786040163862473e+02, 
            9.793854725789666e+02,     9.801626632686754e+02,     9.809356408260661e+02,     9.817044566170320e+02,     9.824691610289570e+02, 
            9.832298034961353e+02,     9.839864325243592e+02,     9.847390957146970e+02,     9.854878397865091e+02,     9.862327105997156e+02, 
            9.869737531763548e+02,     9.877110117214614e+02,     9.884445296432757e+02,     9.891743495728324e+02,     9.899005133829303e+02, 
            9.906230622065202e+02,     9.913420364545289e+02,     9.920574758331342e+02,     9.927694193605244e+02,     9.934779053831476e+02, 
            9.941829715914729e+02,     9.948846550352943e+02,     9.955829921385676e+02,     9.962780187138244e+02,     9.969697699761590e+02, 
            9.976582805568131e+02,     9.983435845163659e+02,     9.990257153575506e+02,     9.997047060377063e+02,     1.000380588980874e+03, 
            1.001053396089556e+03,     1.001723158756147e+03,     1.002389907874043e+03,     1.003053673848457e+03,     1.003714486606917e+03, 
            1.004372375609496e+03,     1.005027369858758e+03,     1.005679497909436e+03,     1.006328787877847e+03,     1.006975267450931e+03, 
            1.007618963919326e+03,     1.008259904089698e+03,     1.008898114438757e+03,     1.009533621023530e+03,     1.010166449514144e+03, 
            1.010796625201651e+03,     1.011424173005649e+03,     1.012049117481710e+03,     1.012671482828619e+03,     1.013291292895429e+03, 
            1.013908571188345e+03,     1.014523340877430e+03,     1.015135624803148e+03,     1.015745445482746e+03,     1.016352825116478e+03, 
            1.016957785593676e+03,     1.017560348498682e+03,     1.018160535116622e+03,     1.018758365946233e+03,     1.019353862659257e+03, 
            1.019947045200726e+03,     1.020537933714027e+03,     1.021126548070245e+03,     1.021712907873166e+03,     1.022297032464174e+03, 
            1.022878940927022e+03,     1.023458652092505e+03,     1.024036184543016e+03,     1.024611556617003e+03,     1.025184786413326e+03, 
            1.025755891795508e+03,     1.026324890395905e+03,     1.026891799619761e+03,     1.027456636649197e+03,     1.028019418447091e+03, 
            1.028580161760885e+03,     1.029138883126306e+03,     1.029695598870999e+03,     1.030250325118090e+03,     1.030803077789665e+03, 
            1.031353872610181e+03,     1.031902725109795e+03,     1.032449650627630e+03,     1.032994664314966e+03,     1.033537781138368e+03, 
            1.034079015882743e+03,     1.034618383154338e+03,     1.035155897383672e+03,     1.035691572828408e+03,     1.036225423576168e+03, 
            1.036757463547285e+03,     1.037287706497502e+03,     1.037816166020615e+03,     1.038342855551065e+03,     1.038867788366474e+03, 
            1.039390977590129e+03,     1.039912436193419e+03,     1.040432176998225e+03,     1.040950212679257e+03,     1.041466555766350e+03, 
            1.041981218646708e+03,     1.042494213567117e+03,     1.043005552636096e+03,     1.043515247826024e+03,     1.044023310975212e+03, 
            1.044529753789947e+03,     1.045034587846485e+03,     1.045537824593014e+03,     1.046039475351579e+03,     1.046539551319964e+03, 
            1.047038063573546e+03,     1.047535023067112e+03,     1.048030440636637e+03,     1.048524327001034e+03,     1.049016692763873e+03, 
            1.049507548415060e+03,     1.049996904332496e+03,     1.050484770783695e+03,     1.050971157927377e+03,     1.051456075815036e+03, 
            1.051939534392472e+03,     1.052421543501299e+03,     1.052902112880427e+03,     1.053381252167513e+03,     1.053858970900392e+03, 
            1.054335278518479e+03,     1.054810184364144e+03,     1.055283697684066e+03,     1.055755827630565e+03,     1.056226583262903e+03, 
            1.056695973548571e+03,     1.057164007364549e+03,     1.057630693498545e+03,     1.058096040650208e+03,     1.058560057432329e+03, 
            1.059022752372019e+03,     1.059484133911857e+03,     1.059944210411033e+03,     1.060402990146461e+03,     1.060860481313877e+03, 
            1.061316692028921e+03,     1.061771630328194e+03,     1.062225304170305e+03,     1.062677721436895e+03,     1.063128889933647e+03, 
            1.063578817391277e+03,     1.064027511466508e+03,     1.064474979743037e+03,     1.064921229732472e+03,     1.065366268875260e+03, 
            1.065810104541608e+03,     1.066252744032373e+03,     1.066694194579952e+03,     1.067134463349149e+03,     1.067573557438033e+03, 
            1.068011483878778e+03,     1.068448249638493e+03,     1.068883861620038e+03,     1.069318326662826e+03,     1.069751651543614e+03, 
            1.070183842977278e+03,     1.070614907617582e+03,     1.071044852057929e+03,     1.071473682832105e+03,     1.071901406415004e+03, 
            1.072328029223356e+03,     1.072753557616424e+03,     1.073177997896710e+03,     1.073601356310637e+03,     1.074023639049224e+03, 
            1.074444852248754e+03,     1.074865001991429e+03,     1.075284094306015e+03,     1.075702135168474e+03,     1.076119130502600e+03, 
            1.076535086180623e+03,     1.076950008023829e+03,     1.077363901803149e+03,     1.077776773239755e+03,     1.078188628005637e+03, 
            1.078599471724177e+03,     1.079009309970713e+03,     1.079418148273096e+03,     1.079825992112235e+03,     1.080232846922637e+03, 
            1.080638718092942e+03,     1.081043610966444e+03,     1.081447530841606e+03,     1.081850482972577e+03,     1.082252472569681e+03, 
            1.082653504799925e+03,     1.083053584787477e+03,     1.083452717614153e+03,     1.083850908319886e+03,     1.084248161903196e+03, 
            1.084644483321650e+03,     1.085039877492314e+03,     1.085434349292206e+03,     1.085827903558733e+03,     1.086220545090126e+03, 
            1.086612278645872e+03,     1.087003108947137e+03,     1.087393040677182e+03,     1.087782078481775e+03,     1.088170226969600e+03, 
            1.088557490712654e+03,     1.088943874246643e+03,     1.089329382071373e+03,     1.089714018651135e+03,     1.090097788415081e+03, 
            1.090480695757602e+03,     1.090862745038693e+03,     1.091243940584324e+03,     1.091624286686789e+03,     1.092003787605073e+03, 
            1.092382447565191e+03,     1.092760270760539e+03,     1.093137261352232e+03,     1.093513423469443e+03,     1.093888761209733e+03, 
            1.094263278639377e+03,     1.094636979793690e+03,     1.095009868677344e+03,     1.095381949264681e+03,     1.095753225500031e+03, 
            1.096123701298010e+03,     1.096493380543825e+03,     1.096862267093577e+03,     1.097230364774552e+03,     1.097597677385513e+03, 
            1.097964208696988e+03,     1.098329962451552e+03,     1.098694942364112e+03,     1.099059152122179e+03,     1.099422595386141e+03, 
            1.099785275789538e+03,     1.100147196939320e+03,     1.100508362416119e+03,     1.100868775774506e+03,     1.101228440543240e+03, 
            1.101587360225533e+03,     1.101945538299294e+03,     1.102302978217373e+03,     1.102659683407815e+03,     1.103015657274090e+03, 
            1.103370903195338e+03,     1.103725424526604e+03,     1.104079224599066e+03,     1.104432306720269e+03,     1.104784674174349e+03, 
            1.105136330222258e+03,     1.105487278101986e+03,     1.105837521028779e+03,     1.106187062195352e+03,     1.106535904772110e+03, 
            1.106884051907349e+03,     1.107231506727476e+03,     1.107578272337200e+03,     1.107924351819750e+03,     1.108269748237069e+03, 
            1.108614464630010e+03,     1.108958504018540e+03,     1.109301869401927e+03,     1.109644563758935e+03,     1.109986590048013e+03, 
            1.110327951207484e+03,     1.110668650155727e+03,     1.111008689791359e+03,     1.111348072993422e+03,     1.111686802621556e+03, 
            1.112024881516179e+03,     1.112362312498658e+03,     1.112699098371486e+03,     1.113035241918449e+03,     1.113370745904798e+03, 
            1.113705613077415e+03,     1.114039846164975e+03,     1.114373447878111e+03,     1.114706420909578e+03,     1.115038767934408e+03, 
            1.115370491610070e+03,     1.115701594576627e+03,     1.116032079456885e+03,     1.116361948856551e+03,     1.116691205364383e+03, 
            1.117019851552336e+03,     1.117347889975709e+03,     1.117675323173296e+03,     1.118002153667526e+03,     1.118328383964605e+03, 
            1.118654016554660e+03,     1.118979053911876e+03,     1.119303498494634e+03,     1.119627352745648e+03,     1.119950619092103e+03, 
            1.120273299945783e+03,     1.120595397703205e+03,     1.120916914745751e+03,     1.121237853439797e+03,     1.121558216136837e+03, 
            1.121878005173617e+03,     1.122197222872252e+03,     1.122515871540354e+03,     1.122833953471154e+03,     1.123151470943624e+03, 
            1.123468426222593e+03,     1.123784821558870e+03,     1.124100659189358e+03,     1.124415941337173e+03,     1.124730670211756e+03, 
            1.125044848008989e+03,     1.125358476911306e+03,     1.125671559087804e+03,     1.125984096694354e+03,     1.126296091873710e+03, 
            1.126607546755618e+03,     1.126918463456918e+03,     1.127228844081656e+03,     1.127538690721182e+03,     1.127848005454261e+03, 
            1.128156790347169e+03,     1.128465047453795e+03,     1.128772778815745e+03,     1.129079986462440e+03,     1.129386672411211e+03, 
            1.129692838667400e+03,     1.129998487224454e+03,     1.130303620064022e+03,     1.130608239156048e+03,     1.130912346458866e+03
    },
    {
            1.773629859046523e+00,     5.377819469654504e+00,     9.056286318198252e+00,     1.281301340495643e+01,     1.665233720798221e+01, 
            2.057899181719306e+01,     2.459816031747971e+01,     2.871553493397806e+01,     3.293738781573103e+01,     3.727065484817589e+01, 
            4.172303553225643e+01,     4.630311284311583e+01,     5.102049815519175e+01,     5.588600791974962e+01,     6.091188098782265e+01, 
            6.611204856107693e+01,     7.150247314657129e+01,     7.710157924745515e+01,     8.293080789336607e+01,     8.901534122666101e+01, 
            9.538506511753417e+01,     1.020758722224499e+02,     1.091314640800164e+02,     1.166059056723513e+02,     1.245673524652266e+02, 
            1.331036761640017e+02,     1.423313114913649e+02,     1.524098833740949e+02,     1.635679687699430e+02,     1.761523603703353e+02, 
            1.907334839054304e+02,     2.083714894236668e+02,     2.315009758551883e+02,     6.822333104989781e+02,     7.015642867519288e+02, 
            7.154179960036090e+02,     7.265180864785227e+02,     7.359028556683198e+02,     7.440974817585542e+02,     7.514093731160300e+02, 
            7.580358387590244e+02,     7.641119428835559e+02,     7.697346745691960e+02,     7.749763145761232e+02,     7.798923509991354e+02, 
            7.845264256336495e+02,     7.889135624183790e+02,     7.930823520559334e+02,     7.970564760452235e+02,     8.008557979967100e+02, 
            8.044971629773286e+02,     8.079949947125247e+02,     8.113617496337930e+02,     8.146082674935537e+02,     8.177440458982780e+02, 
            8.207774579719730e+02,     8.237159268896304e+02,     8.265660672676128e+02,     8.293338007783072e+02,     8.320244514978797e+02, 
            8.346428251575635e+02,     8.371932754919554e+02,     8.396797601554991e+02,     8.421058881381750e+02,     8.444749602029698e+02, 
            8.467900035558476e+02,     8.490538017184647e+02,     8.512689203869357e+02,     8.534377299133245e+02,     8.555624249307394e+02, 
            8.576450415507163e+02,     8.596874724877102e+02,     8.616914804059818e+02,     8.636587097358055e+02,     8.655906971665624e+02, 
            8.674888809918598e+02,     8.693546094552407e+02,     8.711891482228550e+02,     8.729936870911722e+02,     8.747693460223398e+02, 
            8.765171805869543e+02,     8.782381868831014e+02,     8.799333059912919e+02,     8.816034280171536e+02,     8.832493957670240e+02, 
            8.848720080959188e+02,     8.864720229624675e+02,     8.880501602211853e+02,     8.896071041788352e+02,     8.911435059385101e+02, 
            8.926599855522996e+02,     8.941571340010915e+02,     8.956355150179513e+02,     8.970956667697297e+02,     8.985381034099872e+02, 
            8.999633165148956e+02,     9.013717764125928e+02,     9.027639334153641e+02,     9.041402189630854e+02,     9.055010466855138e+02, 
            9.068468133902574e+02,     9.081778999826120e+02,     9.094946723228360e+02,     9.107974820259196e+02,     9.120866672084396e+02, 
            9.133625531866596e+02,     9.146254531296416e+02,     9.158756686708567e+02,     9.171134904813838e+02,     9.183391988076047e+02, 
            9.195530639759945e+02,     9.207553468674062e+02,     9.219462993630469e+02,     9.231261647641586e+02,     9.242951781872481e+02, 
            9.254535669365638e+02,     9.266015508553866e+02,     9.277393426575541e+02,     9.288671482405705e+02,     9.299851669814976e+02, 
            9.310935920167727e+02,     9.321926105070038e+02,     9.332824039044416e+02,     9.343631482202984e+02,     9.354350138683598e+02, 
            9.364981667979517e+02,     9.375527676967494e+02,     9.385989727072030e+02,     9.396369335014126e+02,     9.406667970564429e+02, 
            9.416887072339659e+02,     9.427028028917784e+02,     9.437092197728394e+02,     9.447080894745242e+02,     9.456995402099089e+02, 
            9.466836967764492e+02,     9.476606806797482e+02,     9.486306102516947e+02,     9.495936007632532e+02,     9.505497645322245e+02, 
            9.514992110262136e+02,     9.524420469610939e+02,     9.533783763951785e+02,     9.543083008193292e+02,     9.552319192432292e+02, 
            9.561493282779888e+02,     9.570606222152917e+02,     9.579658931032482e+02,     9.588652308191261e+02,     9.597587231390913e+02, 
            9.606464558051483e+02,     9.615285125893657e+02,     9.624049753555604e+02,     9.632759241330899e+02,     9.641414371141784e+02, 
            9.650015908002104e+02,     9.658564599917084e+02,     9.667061178549953e+02,     9.675506359708693e+02,     9.683900843814411e+02, 
            9.692245316352270e+02,     9.700540448305677e+02,     9.708786896574628e+02,     9.716985304378642e+02,     9.725136301645297e+02, 
            9.733240505153078e+02,     9.741298519835661e+02,     9.749310937689504e+02,     9.757278339088939e+02,     9.765201292861088e+02, 
            9.773080356599124e+02,     9.780916076964764e+02,     9.788708989980508e+02,     9.796459621311968e+02,     9.804168486540717e+02, 
            9.811836091428052e+02,     9.819462932170051e+02,     9.827049495644191e+02,     9.834596259647968e+02,     9.842103693129807e+02, 
            9.849572256412446e+02,     9.857002401409294e+02,     9.864394571833860e+02,     9.871749203402550e+02,     9.879066724031227e+02, 
            9.886347554025526e+02,     9.893592106265374e+02,     9.900800786383846e+02,     9.907973992940489e+02,     9.915112117589497e+02, 
            9.922215545242780e+02,     9.929284654228121e+02,     9.936319816442708e+02,     9.943321397502076e+02,     9.950289756884707e+02, 
            9.957225248072416e+02,     9.964128218686656e+02,     9.970999010620903e+02,     9.977837960169278e+02,     9.984645398151455e+02, 
            9.991421650034122e+02,     9.998167036048952e+02,     1.000488187130732e+03,     1.001156646591184e+03,     1.001822112506480e+03, 
            1.002484614917367e+03,     1.003144183395363e+03,     1.003800847076404e+03,     1.004454634574822e+03,     1.005105574138109e+03, 
            1.005753693558059e+03,     1.006399020204554e+03,     1.007041581034274e+03,     1.007681402599202e+03,     1.008318511054886e+03, 
            1.008952932168505e+03,     1.009584691326717e+03,     1.010213813543305e+03,     1.010840323466637e+03,     1.011464245386928e+03, 
            1.012085603243327e+03,     1.012704420630820e+03,     1.013320720806964e+03,     1.013934526698454e+03,     1.014545860907528e+03, 
            1.015154745718215e+03,     1.015761203102430e+03,     1.016365254725923e+03,     1.016966921461689e+03,     1.017566225347698e+03, 
            1.018163186690215e+03,     1.018757825986993e+03,     1.019350163457285e+03,     1.019940219046997e+03,     1.020528012433705e+03, 
            1.021113563031568e+03,     1.021696889996126e+03,     1.022278012228982e+03,     1.022856948382378e+03,     1.023433716863671e+03, 
            1.024008335839704e+03,     1.024580823241077e+03,     1.025151196766324e+03,     1.025719473885994e+03,     1.026285671846651e+03, 
            1.026849807674765e+03,     1.027411898180541e+03,     1.027971959961645e+03,     1.028530009406859e+03,     1.029086062699656e+03, 
            1.029640135821689e+03,     1.030192244556216e+03,     1.030742404491445e+03,     1.031290631023810e+03,     1.031836939361171e+03, 
            1.032381344525963e+03,     1.032923861358257e+03,     1.033464504518770e+03,     1.034003288491813e+03,     1.034540227588171e+03, 
            1.035075335947925e+03,     1.035608627543225e+03,     1.036140116180988e+03,     1.036669815505561e+03,     1.037197739001313e+03, 
            1.037723899995191e+03,     1.038248311659205e+03,     1.038770987012883e+03,     1.039291938925659e+03,     1.039811180119232e+03, 
            1.040328723169860e+03,     1.040844580510621e+03,     1.041358764433627e+03,     1.041871287092190e+03,     1.042382160502950e+03, 
            1.042891396547968e+03,     1.043399006976760e+03,     1.043905003408313e+03,     1.044409397333050e+03,     1.044912200114757e+03, 
            1.045413422992485e+03,     1.045913077082398e+03,     1.046411173379605e+03,     1.046907722759944e+03,     1.047402735981738e+03, 
            1.047896223687516e+03,     1.048388196405711e+03,     1.048878664552310e+03,     1.049367638432489e+03,     1.049855128242210e+03, 
            1.050341144069793e+03,     1.050825695897455e+03,     1.051308793602825e+03,     1.051790446960430e+03,     1.052270665643153e+03, 
            1.052749459223669e+03,     1.053226837175853e+03,     1.053702808876161e+03,     1.054177383604986e+03,     1.054650570547999e+03, 
            1.055122378797455e+03,     1.055592817353483e+03,     1.056061895125350e+03,     1.056529620932707e+03,     1.056996003506808e+03, 
            1.057461051491715e+03,     1.057924773445474e+03,     1.058387177841282e+03,     1.058848273068616e+03,     1.059308067434366e+03, 
            1.059766569163933e+03,     1.060223786402307e+03,     1.060679727215142e+03,     1.061134399589793e+03,     1.061587811436357e+03, 
            1.062039970588677e+03,     1.062490884805341e+03,     1.062940561770662e+03,     1.063389009095646e+03,     1.063836234318928e+03, 
            1.064282244907717e+03,     1.064727048258706e+03,     1.065170651698974e+03,     1.065613062486878e+03,     1.066054287812922e+03, 
            1.066494334800618e+03,     1.066933210507334e+03,     1.067370921925120e+03,     1.067807475981532e+03,     1.068242879540438e+03, 
            1.068677139402806e+03,     1.069110262307491e+03,     1.069542254932000e+03,     1.069973123893248e+03,     1.070402875748304e+03, 
            1.070831516995124e+03,     1.071259054073272e+03,     1.071685493364632e+03,     1.072110841194106e+03,     1.072535103830304e+03, 
            1.072958287486222e+03,     1.073380398319911e+03,     1.073801442435132e+03,     1.074221425882010e+03,     1.074640354657665e+03, 
            1.075058234706845e+03,     1.075475071922548e+03,     1.075890872146624e+03,     1.076305641170381e+03,     1.076719384735179e+03, 
            1.077132108533010e+03,     1.077543818207072e+03,     1.077954519352336e+03,     1.078364217516108e+03,     1.078772918198571e+03, 
            1.079180626853333e+03,     1.079587348887960e+03,     1.079993089664499e+03,     1.080397854500001e+03,     1.080801648667027e+03, 
            1.081204477394156e+03,     1.081606345866480e+03,     1.082007259226094e+03,     1.082407222572578e+03,     1.082806240963472e+03, 
            1.083204319414748e+03,     1.083601462901268e+03,     1.083997676357243e+03,     1.084392964676684e+03,     1.084787332713837e+03, 
            1.085180785283634e+03,     1.085573327162110e+03,     1.085964963086836e+03,     1.086355697757336e+03,     1.086745535835502e+03, 
            1.087134481946000e+03,     1.087522540676672e+03,     1.087909716578931e+03,     1.088296014168161e+03,     1.088681437924089e+03, 
            1.089065992291179e+03,     1.089449681678999e+03,     1.089832510462598e+03,     1.090214482982863e+03,     1.090595603546889e+03, 
            1.090975876428330e+03,     1.091355305867751e+03,     1.091733896072973e+03,     1.092111651219420e+03,     1.092488575450451e+03, 
            1.092864672877694e+03,     1.093239947581379e+03,     1.093614403610655e+03,     1.093988044983918e+03,     1.094360875689121e+03, 
            1.094732899684089e+03,     1.095104120896827e+03,     1.095474543225820e+03,     1.095844170540338e+03,     1.096213006680730e+03, 
            1.096581055458716e+03,     1.096948320657676e+03,     1.097314806032933e+03,     1.097680515312039e+03,     1.098045452195048e+03, 
            1.098409620354794e+03,     1.098773023437159e+03,     1.099135665061341e+03,     1.099497548820120e+03,     1.099858678280115e+03, 
            1.100219056982045e+03,     1.100578688440985e+03,     1.100937576146610e+03,     1.101295723563449e+03,     1.101653134131129e+03, 
            1.102009811264616e+03,     1.102365758354455e+03,     1.102720978767004e+03,     1.103075475844672e+03,     1.103429252906143e+03, 
            1.103782313246609e+03,     1.104134660137991e+03,     1.104486296829165e+03,     1.104837226546177e+03,     1.105187452492463e+03, 
            1.105536977849065e+03,     1.105885805774834e+03,     1.106233939406652e+03,     1.106581381859628e+03,     1.106928136227307e+03, 
            1.107274205581871e+03,     1.107619592974338e+03,     1.107964301434759e+03,     1.108308333972413e+03,     1.108651693576003e+03, 
            1.108994383213837e+03,     1.109336405834028e+03,     1.109677764364668e+03,     1.110018461714021e+03,     1.110358500770699e+03, 
            1.110697884403845e+03,     1.111036615463307e+03,     1.111374696779818e+03,     1.111712131165161e+03,     1.112048921412351e+03, 
            1.112385070295797e+03,     1.112720580571470e+03,     1.113055454977075e+03,     1.113389696232202e+03,     1.113723307038504e+03, 
            1.114056290079845e+03,     1.114388648022459e+03,     1.114720383515116e+03,     1.115051499189266e+03,     1.115381997659194e+03, 
            1.115711881522178e+03,     1.116041153358632e+03,     1.116369815732255e+03,     1.116697871190180e+03,     1.117025322263114e+03, 
            1.117352171465486e+03,     1.117678421295588e+03,     1.118004074235709e+03,     1.118329132752282e+03,     1.118653599296014e+03, 
            1.118977476302025e+03,     1.119300766189983e+03,     1.119623471364233e+03,     1.119945594213927e+03,     1.120267137113163e+03, 
            1.120588102421101e+03,     1.120908492482097e+03,     1.121228309625829e+03,     1.121547556167417e+03,     1.121866234407550e+03, 
            1.122184346632605e+03,     1.122501895114766e+03,     1.122818882112149e+03,     1.123135309868913e+03,     1.123451180615380e+03, 
            1.123766496568149e+03,     1.124081259930212e+03,     1.124395472891065e+03,     1.124709137626818e+03,     1.125022256300311e+03, 
            1.125334831061217e+03,     1.125646864046157e+03,     1.125958357378799e+03,     1.126269313169972e+03,     1.126579733517764e+03, 
            1.126889620507633e+03,     1.127198976212504e+03,     1.127507802692872e+03,     1.127816101996904e+03,     1.128123876160538e+03, 
            1.128431127207582e+03,     1.128737857149810e+03,     1.129044067987062e+03,     1.129349761707334e+03,     1.129654940286882e+03
    },
    {
            1.770013025943158e+00,     5.366488267001762e+00,     9.036556072944268e+00,     1.278412826137781e+01,     1.661346047495118e+01, 
            2.052919465299765e+01,     2.453640839925811e+01,     2.864067266779054e+01,     3.284811952570124e+01,     3.716552222729319e+01, 
            4.160039043077776e+01,     4.616108419258951e+01,     5.085695144828342e+01,     5.569849514584334e+01,     6.069757819834463e+01, 
            6.586767721006174e+01,     7.122419987134026e+01,     7.678488658413146e+01,     8.257032517781735e+01,     8.860461997430960e+01, 
            9.491627541279263e+01,     1.015393841524153e+02,     1.085152574913746e+02,     1.158947157971831e+02,     1.237413948290310e+02, 
            1.321366733891267e+02,     1.411873033063080e+02,     1.510377843305506e+02,     1.618916292390349e+02,     1.740507212846095e+02, 
            1.879957692118028e+02,     2.045757646299889e+02,     2.255652528227687e+02,     2.561868780544712e+02,     6.839333484128063e+02, 
            7.015662055601990e+02,     7.147475449833295e+02,     7.254921085126192e+02,     7.346617203277483e+02,     7.427156203445679e+02, 
            7.499308435004302e+02,     7.564887405229305e+02,     7.625151885139106e+02,     7.681015182440158e+02,     7.733163398278874e+02, 
            7.782126602491302e+02,     7.828323875605383e+02,     7.872093006320323e+02,     7.913710754305893e+02,     7.953407083834163e+02, 
            7.991375415818319e+02,     8.027780174793484e+02,     8.062762452005784e+02,     8.096444327524356e+02,     8.128932219117567e+02, 
            8.160319512410581e+02,     8.190688651916063e+02,     8.220112821892812e+02,     8.248657311104379e+02,     8.276380631100582e+02, 
            8.303335440235713e+02,     8.329569313057547e+02,     8.355125385492672e+02,     8.380042899425150e+02,     8.404357665146825e+02, 
            8.428102456278054e+02,     8.451307348788488e+02,     8.474000013453964e+02,     8.496205969298912e+02,     8.517948804170006e+02, 
            8.539250367476050e+02,     8.560130939243865e+02,     8.580609378929202e+02,     8.600703256848420e+02,     8.620428970630094e+02, 
            8.639801848705229e+02,     8.658836242542101e+02,     8.677545609073107e+02,     8.695942584547508e+02,     8.714039050864767e+02, 
            8.731846195294391e+02,     8.749374564362282e+02,     8.766634112577963e+02,     8.783634246587162e+02,     8.800383865258077e+02, 
            8.816891396144570e+02,     8.833164828714079e+02,     8.849211744679964e+02,     8.865039345737277e+02,     8.880654478965014e+02, 
            8.896063660127563e+02,     8.911273095081101e+02,     8.926288699467578e+02,     8.941116116858690e+02,     8.955760735494250e+02, 
            8.970227703744362e+02,     8.984521944410458e+02,     8.998648167968850e+02,     9.012610884849362e+02,     9.026414416832673e+02, 
            9.040062907641168e+02,     9.053560332791312e+02,     9.066910508768423e+02,     9.080117101579406e+02,     9.093183634733346e+02, 
            9.106113496695605e+02,     9.118909947856516e+02,     9.131576127052410e+02,     9.144115057673044e+02,     9.156529653386692e+02, 
            9.168822723511342e+02,     9.180996978057992e+02,     9.193055032469921e+02,     9.204999412079763e+02,     9.216832556304255e+02, 
            9.228556822595244e+02,     9.240174490163648e+02,     9.251687763492012e+02,     9.263098775649958e+02,     9.274409591425626e+02, 
            9.285622210285431e+02,     9.296738569173209e+02,     9.307760545209054e+02,     9.318689958587576e+02,     9.329528574722702e+02, 
            9.340278106262268e+02,     9.350940203497840e+02,     9.361516494505260e+02,     9.372008539674398e+02,     9.382417860434017e+02, 
            9.392745930083785e+02,     9.402994192060448e+02,     9.413164043210600e+02,     9.423256840531941e+02,     9.433273905831434e+02, 
            9.443216525372015e+02,     9.453085951172131e+02,     9.462883402245440e+02,     9.472610065784177e+02,     9.482267098289111e+02, 
            9.491855626649009e+02,     9.501376749172348e+02,     9.510831536573708e+02,     9.520221032917453e+02,     9.529546256520614e+02, 
            9.538808200817331e+02,     9.548007835186710e+02,     9.557146105746014e+02,     9.566223936110774e+02,     9.575242228123774e+02, 
            9.584201862554094e+02,     9.593103699767923e+02,     9.601948580372501e+02,     9.610737325834260e+02,     9.619470739211297e+02, 
            9.628149605156710e+02,     9.636774691338737e+02,     9.645346748372032e+02,     9.653866510477905e+02,     9.662334695972262e+02, 
            9.670752007735197e+02,     9.679119133663155e+02,     9.687436747104260e+02,     9.695705507277763e+02,     9.703926059439974e+02, 
            9.712099036243652e+02,     9.720225056631631e+02,     9.728304727206021e+02,     9.736338642320798e+02,     9.744327384418949e+02, 
            9.752271524357894e+02,     9.760171621723608e+02,     9.768028225134068e+02,     9.775841872532318e+02,     9.783613091469597e+02, 
            9.791342399379035e+02,     9.799030303840206e+02,     9.806677302834923e+02,     9.814283884994614e+02,     9.821850529839694e+02, 
            9.829377708011111e+02,     9.836865881494518e+02,     9.844315503837197e+02,     9.851727020358175e+02,     9.859100868351705e+02, 
            9.866437477284373e+02,     9.873737268986040e+02,     9.881000657834953e+02,     9.888228050937117e+02,     9.895419848300281e+02, 
            9.902576443002546e+02,     9.909698221355981e+02,     9.916785563065349e+02,     9.923838841382071e+02,     9.930858423253688e+02, 
            9.937844669468916e+02,     9.944797934798491e+02,     9.951718568131953e+02,     9.958606912610416e+02,     9.965463305755653e+02, 
            9.972288079595446e+02,     9.979081560785356e+02,     9.985844070727186e+02,     9.992575925684050e+02,     9.999277437130689e+02, 
            1.000594891089727e+03,     1.001259064874032e+03,     1.001920294745680e+03,     1.002578609923467e+03,     1.003234039175030e+03, 
            1.003886610826337e+03,     1.004536352770912e+03,     1.005183292478836e+03,     1.005827457005482e+03,     1.006468873000051e+03, 
            1.007107566713869e+03,     1.007743564008470e+03,     1.008376890363475e+03,     1.009007570884272e+03,     1.009635630309492e+03, 
            1.010261093018303e+03,     1.010883983037516e+03,     1.011504324048518e+03,     1.012122139394027e+03,     1.012737452084681e+03, 
            1.013350284805467e+03,     1.013960659921993e+03,     1.014568599486601e+03,     1.015174124752545e+03,     1.015777258129385e+03, 
            1.016378020290344e+03,     1.016976432092976e+03,     1.017572514110014e+03,     1.018166286634665e+03,     1.018757769685771e+03, 
            1.019346983012853e+03,     1.019933946101037e+03,     1.020518678175869e+03,     1.021101198208019e+03,     1.021681524917866e+03, 
            1.022259676779997e+03,     1.022835672027588e+03,     1.023409528656695e+03,     1.023981264430443e+03,     1.024550896883127e+03, 
            1.025118443324215e+03,     1.025683920842269e+03,     1.026247346308774e+03,     1.026808736381887e+03,     1.027368107510100e+03, 
            1.027925475935830e+03,     1.028480857698918e+03,     1.029034268640075e+03,     1.029585724404226e+03,     1.030135240443810e+03, 
            1.030682832021989e+03,     1.031228514215801e+03,     1.031772301919239e+03,     1.032314209846275e+03,     1.032854252533812e+03, 
            1.033392444344576e+03,     1.033928799469954e+03,     1.034463331932768e+03,     1.034996055589993e+03,     1.035526984135420e+03, 
            1.036056131102271e+03,     1.036583509865743e+03,     1.037109133645528e+03,     1.037633015508255e+03,     1.038155168369904e+03, 
            1.038675604998160e+03,     1.039194338014723e+03,     1.039711379897579e+03,     1.040226742983215e+03,     1.040740439468799e+03, 
            1.041252481414319e+03,     1.041762880744669e+03,     1.042271649251709e+03,     1.042778798596277e+03,     1.043284340310163e+03, 
            1.043788285798050e+03,     1.044290646339412e+03,     1.044791433090380e+03,     1.045290657085571e+03,     1.045788329239887e+03, 
            1.046284460350270e+03,     1.046779061097440e+03,     1.047272142047585e+03,     1.047763713654031e+03,     1.048253786258873e+03, 
            1.048742370094586e+03,     1.049229475285596e+03,     1.049715111849829e+03,     1.050199289700230e+03,     1.050682018646258e+03, 
            1.051163308395343e+03,     1.051643168554335e+03,     1.052121608630909e+03,     1.052598638034956e+03,     1.053074266079950e+03, 
            1.053548501984280e+03,     1.054021354872574e+03,     1.054492833776986e+03,     1.054962947638468e+03,     1.055431705308020e+03, 
            1.055899115547916e+03,     1.056365187032909e+03,     1.056829928351415e+03,     1.057293348006678e+03,     1.057755454417919e+03, 
            1.058216255921454e+03,     1.058675760771807e+03,     1.059133977142793e+03,     1.059590913128588e+03,     1.060046576744786e+03, 
            1.060500975929422e+03,     1.060954118544000e+03,     1.061406012374485e+03,     1.061856665132292e+03,     1.062306084455249e+03, 
            1.062754277908549e+03,     1.063201252985687e+03,     1.063647017109382e+03,     1.064091577632479e+03,     1.064534941838842e+03, 
            1.064977116944231e+03,     1.065418110097164e+03,     1.065857928379764e+03,     1.066296578808599e+03,     1.066734068335499e+03, 
            1.067170403848367e+03,     1.067605592171976e+03,     1.068039640068749e+03,     1.068472554239538e+03,     1.068904341324373e+03, 
            1.069335007903219e+03,     1.069764560496705e+03,     1.070193005566852e+03,     1.070620349517786e+03,     1.071046598696440e+03, 
            1.071471759393244e+03,     1.071895837842809e+03,     1.072318840224596e+03,     1.072740772663577e+03,     1.073161641230882e+03, 
            1.073581451944448e+03,     1.074000210769640e+03,     1.074417923619882e+03,     1.074834596357261e+03,     1.075250234793135e+03, 
            1.075664844688729e+03,     1.076078431755715e+03,     1.076491001656791e+03,     1.076902560006253e+03,     1.077313112370551e+03, 
            1.077722664268841e+03,     1.078131221173530e+03,     1.078538788510812e+03,     1.078945371661196e+03,     1.079350975960026e+03, 
            1.079755606697995e+03,     1.080159269121650e+03,     1.080561968433890e+03,     1.080963709794459e+03,     1.081364498320429e+03, 
            1.081764339086678e+03,     1.082163237126360e+03,     1.082561197431372e+03,     1.082958224952806e+03,     1.083354324601408e+03, 
            1.083749501248016e+03,     1.084143759724000e+03,     1.084537104821701e+03,     1.084929541294848e+03,     1.085321073858985e+03, 
            1.085711707191887e+03,     1.086101445933961e+03,     1.086490294688662e+03,     1.086878258022880e+03,     1.087265340467342e+03, 
            1.087651546516988e+03,     1.088036880631368e+03,     1.088421347235006e+03,     1.088804950717779e+03,     1.089187695435282e+03, 
            1.089569585709192e+03,     1.089950625827619e+03,     1.090330820045469e+03,     1.090710172584782e+03,     1.091088687635082e+03, 
            1.091466369353711e+03,     1.091843221866165e+03,     1.092219249266427e+03,     1.092594455617287e+03,     1.092968844950668e+03, 
            1.093342421267939e+03,     1.093715188540235e+03,     1.094087150708757e+03,     1.094458311685084e+03,     1.094828675351469e+03, 
            1.095198245561142e+03,     1.095567026138599e+03,     1.095935020879892e+03,     1.096302233552917e+03,     1.096668667897696e+03, 
            1.097034327626656e+03,     1.097399216424898e+03,     1.097763337950483e+03,     1.098126695834685e+03,     1.098489293682266e+03, 
            1.098851135071734e+03,     1.099212223555601e+03,     1.099572562660643e+03,     1.099932155888145e+03,     1.100291006714153e+03, 
            1.100649118589725e+03,     1.101006494941165e+03,     1.101363139170270e+03,     1.101719054654564e+03,     1.102074244747531e+03, 
            1.102428712778849e+03,     1.102782462054618e+03,     1.103135495857584e+03,     1.103487817447362e+03,     1.103839430060661e+03, 
            1.104190336911492e+03,     1.104540541191394e+03,     1.104890046069640e+03,     1.105238854693447e+03,     1.105586970188186e+03, 
            1.105934395657586e+03,     1.106281134183935e+03,     1.106627188828282e+03,     1.106972562630637e+03,     1.107317258610159e+03, 
            1.107661279765358e+03,     1.108004629074279e+03,     1.108347309494695e+03,     1.108689323964293e+03,     1.109030675400856e+03, 
            1.109371366702447e+03,     1.109711400747590e+03,     1.110050780395447e+03,     1.110389508485991e+03,     1.110727587840185e+03, 
            1.111065021260153e+03,     1.111401811529347e+03,     1.111737961412718e+03,     1.112073473656880e+03,     1.112408350990278e+03, 
            1.112742596123344e+03,     1.113076211748665e+03,     1.113409200541139e+03,     1.113741565158127e+03,     1.114073308239617e+03, 
            1.114404432408371e+03,     1.114734940270080e+03,     1.115064834413513e+03,     1.115394117410665e+03,     1.115722791816906e+03, 
            1.116050860171124e+03,     1.116378324995869e+03,     1.116705188797496e+03,     1.117031454066305e+03,     1.117357123276679e+03, 
            1.117682198887223e+03,     1.118006683340899e+03,     1.118330579065162e+03,     1.118653888472089e+03,     1.118976613958516e+03, 
            1.119298757906162e+03,     1.119620322681767e+03,     1.119941310637207e+03,     1.120261724109631e+03,     1.120581565421578e+03, 
            1.120900836881108e+03,     1.121219540781914e+03,     1.121537679403453e+03,     1.121855255011057e+03,     1.122172269856058e+03, 
            1.122488726175900e+03,     1.122804626194255e+03,     1.123119972121145e+03,     1.123434766153041e+03,     1.123749010472991e+03, 
            1.124062707250717e+03,     1.124375858642735e+03,     1.124688466792460e+03,     1.125000533830309e+03,     1.125312061873818e+03, 
            1.125623053027735e+03,     1.125933509384133e+03,     1.126243433022511e+03,     1.126552826009894e+03,     1.126861690400935e+03, 
            1.127170028238017e+03,     1.127477841551350e+03,     1.127785132359069e+03,     1.128091902667331e+03,     1.128398154470413e+03
    },
    {
            1.766411167843306e+00,     5.355207163410632e+00,     9.016918909862358e+00,     1.275538844451011e+01,     1.657479225799181e+01, 
            2.047968216863315e+01,     2.447503275758265e+01,     2.856629670138139e+01,     3.275946965054364e+01,     3.706116674336273e+01, 
            4.147871339396103e+01,     4.602025373220017e+01,     5.069488105585580e+01,     5.551279598307227e+01,     6.048549980836351e+01, 
            6.562603308105865e+01,     7.094927296285171e+01,     7.647230797680925e+01,     8.221491611374179e+01,     8.820018316820851e+01, 
            9.445531470631609e+01,     1.010127207346335e+02,     1.079114930968276e+02,     1.151994630361880e+02,     1.229361413461933e+02, 
            1.311970477016683e+02,     1.400803170922419e+02,     1.497172236134823e+02,     1.602898578592927e+02,     1.720628855806333e+02, 
            1.854458802977350e+02,     2.011316122305631e+02,     2.204648476600482e+02,     2.467979977910915e+02,     6.602643185914289e+02, 
            6.851786506233416e+02,     7.014934271978317e+02,     7.140815938881548e+02,     7.244948383690877e+02,     7.334575198896256e+02, 
            7.413731285769235e+02,     7.484917546673914e+02,     7.549801383170731e+02,     7.609555562318642e+02,     7.665039539407931e+02, 
            7.716904029766380e+02,     7.765654936604287e+02,     7.811694307667337e+02,     7.855347609286716e+02,     7.896882489099040e+02, 
            7.936522047036246e+02,     7.974454450186275e+02,     8.010840046550001e+02,     8.045816726588026e+02,     8.079504031070693e+02, 
            8.112006344904619e+02,     8.143415413252935e+02,     8.173812347467027e+02,     8.203269241609385e+02,     8.231850488000131e+02, 
            8.259613857454208e+02,     8.286611393604303e+02,     8.312890158908275e+02,     8.338492861276029e+02,     8.363458383810242e+02, 
            8.387822235313309e+02,     8.411616935534948e+02,     8.434872346313695e+02,     8.457615957581891e+02,     8.479873135498751e+02, 
            8.501667338635256e+02,     8.523020307070694e+02,     8.543952228412110e+02,     8.564481884065273e+02,     8.584626778534283e+02, 
            8.604403254077856e+02,     8.623826592683143e+02,     8.642911107016147e+02,     8.661670221757769e+02,     8.680116546527909e+02, 
            8.698261941426315e+02,     8.716117576074786e+02,     8.733693982922771e+02,     8.751001105476087e+02,     8.768048342020688e+02, 
            8.784844585339598e+02,     8.801398258857467e+02,     8.817717349593200e+02,     8.833809438254175e+02,     8.849681726765845e+02, 
            8.865341063495204e+02,     8.880793966397189e+02,     8.896046644286365e+02,     8.911105016413951e+02,     8.925974730510017e+02, 
            8.940661179433434e+02,     8.955169516557061e+02,     8.969504670001828e+02,     8.983671355822039e+02,     8.997674090233365e+02, 
            9.011517200966065e+02,     9.025204837817652e+02,     9.038740982471935e+02,     9.052129457645044e+02,     9.065373935613146e+02, 
            9.078477946171454e+02,     9.091444884069673e+02,     9.104278015964709e+02,     9.116980486927849e+02,     9.129555326540432e+02, 
            9.142005454608916e+02,     9.154333686527544e+02,     9.166542738314494e+02,     9.178635231345155e+02,     9.190613696804226e+02, 
            9.202480579876440e+02,     9.214238243694292e+02,     9.225888973059413e+02,     9.237434977953177e+02,     9.248878396850697e+02, 
            9.260221299851310e+02,     9.271465691637704e+02,     9.282613514281236e+02,     9.293666650173401e+02,     9.304626924631245e+02, 
            9.315496107886563e+02,     9.326275907503525e+02,     9.336968002649269e+02,     9.347574004768428e+02,     9.358095485130128e+02, 
            9.368533965132722e+02,     9.378890932703392e+02,     9.389167829426104e+02,     9.399366054649148e+02,     9.409486971124118e+02, 
            9.419531904614045e+02,     9.429502145257696e+02,     9.439398948870595e+02,     9.449223538186438e+02,     9.458977104041940e+02, 
            9.468660806508392e+02,     9.478275775972708e+02,     9.487823114170662e+02,     9.497303895174925e+02,     9.506719166340148e+02, 
            9.516069949207441e+02,     9.525357240370267e+02,     9.534582012303814e+02,     9.543745214159532e+02,     9.552847772526811e+02, 
            9.561890592163196e+02,     9.570874556694901e+02,     9.579800529288968e+02,     9.588669353298396e+02,     9.597481853026923e+02, 
            9.606238833729558e+02,     9.614941083098199e+02,     9.623589371186379e+02,     9.632184451098204e+02,     9.640727059496677e+02, 
            9.649217917092795e+02,     9.657657729116218e+02,     9.666047185768452e+02,     9.674386962659320e+02,     9.682677721000476e+02, 
            9.690920108934268e+02,     9.699114760512713e+02,     9.707262297033219e+02,     9.715363327157036e+02,     9.723418447259551e+02, 
            9.731428241768299e+02,     9.739393283489172e+02,     9.747314133921479e+02,     9.755191343562082e+02,     9.763025452199295e+02, 
            9.770816989196767e+02,     9.778566473767922e+02,     9.786274415241222e+02,     9.793941313316642e+02,     9.801567658313797e+02, 
            9.809153931411922e+02,     9.816700604882077e+02,     9.824208142311969e+02,     9.831676998823490e+02,     9.839107621283422e+02, 
            9.846500448507513e+02,     9.853855911458135e+02,     9.861174433435809e+02,     9.868456430264839e+02,     9.875702310473233e+02, 
            9.882912475467144e+02,     9.890087319700061e+02,     9.897227230836880e+02,     9.904332589913058e+02,     9.911403771489104e+02, 
            9.918441143800476e+02,     9.925445068903074e+02,     9.932415902814499e+02,     9.939353995651272e+02,     9.946259691762021e+02, 
            9.953133329856967e+02,     9.959975243133608e+02,     9.966785759627929e+02,     9.973565201406299e+02,     9.980313886088236e+02, 
            9.987032126008709e+02,     9.993720228567835e+02,     1.000037849633702e+03,     1.000700722716230e+03,     1.001360671426474e+03, 
            1.002017724633827e+03,     1.002671910764481e+03,     1.003323257810688e+03,     1.003971793339782e+03,     1.004617544502954e+03, 
            1.005260538043807e+03,     1.005900800306678e+03,     1.006538357244757e+03,     1.007173234427983e+03,     1.007805457050753e+03, 
            1.008435049939423e+03,     1.009062037559622e+03,     1.009686444023389e+03,     1.010308293096122e+03,     1.010927608203356e+03, 
            1.011544412437381e+03,     1.012158728563683e+03,     1.012770579027241e+03,     1.013379985467633e+03,     1.013986970671452e+03, 
            1.014591555684662e+03,     1.015193761730115e+03,     1.015793609739397e+03,     1.016391120358263e+03,     1.016986313951946e+03, 
            1.017579210610338e+03,     1.018169830153051e+03,     1.018758192134363e+03,     1.019344315848042e+03,     1.019928220332074e+03, 
            1.020509924373257e+03,     1.021089446511722e+03,     1.021666805045322e+03,     1.022242018033944e+03,     1.022815103303709e+03, 
            1.023386078451087e+03,     1.023954960846916e+03,     1.024521767640336e+03,     1.025086515762629e+03,     1.025649221930982e+03, 
            1.026209902652167e+03,     1.026768574226135e+03,     1.027325252749538e+03,     1.027879954119174e+03,     1.028432694035356e+03, 
            1.028983488005216e+03,     1.029532351345923e+03,     1.030079299187854e+03,     1.030624346477682e+03,     1.031167507981405e+03, 
            1.031708798287313e+03,     1.032248231808894e+03,     1.032785822787673e+03,     1.033321585296004e+03,     1.033855533239790e+03, 
            1.034387680361164e+03,     1.034918040241105e+03,     1.035446626301999e+03,     1.035973451810160e+03,     1.036498529878287e+03, 
            1.037021873467882e+03,     1.037543495391616e+03,     1.038063408315646e+03,     1.038581624761891e+03,     1.039098157110262e+03, 
            1.039613017600843e+03,     1.040126218336037e+03,     1.040637771282669e+03,     1.041147688274044e+03,     1.041655981011968e+03, 
            1.042162661068732e+03,     1.042667739889058e+03,     1.043171228792004e+03,     1.043673138972834e+03,     1.044173481504863e+03, 
            1.044672267341248e+03,     1.045169507316764e+03,     1.045665212149537e+03,     1.046159392442746e+03,     1.046652058686298e+03, 
            1.047143221258463e+03,     1.047632890427497e+03,     1.048121076353207e+03,     1.048607789088518e+03,     1.049093038580989e+03, 
            1.049576834674318e+03,     1.050059187109802e+03,     1.050540105527794e+03,     1.051019599469109e+03,     1.051497678376425e+03, 
            1.051974351595646e+03,     1.052449628377255e+03,     1.052923517877623e+03,     1.053396029160315e+03,     1.053867171197365e+03, 
            1.054336952870523e+03,     1.054805382972492e+03,     1.055272470208135e+03,     1.055738223195666e+03,     1.056202650467815e+03, 
            1.056665760472985e+03,     1.057127561576371e+03,     1.057588062061079e+03,     1.058047270129213e+03,     1.058505193902951e+03, 
            1.058961841425595e+03,     1.059417220662616e+03,     1.059871339502670e+03,     1.060324205758602e+03,     1.060775827168432e+03, 
            1.061226211396332e+03,     1.061675366033568e+03,     1.062123298599455e+03,     1.062570016542270e+03,     1.063015527240161e+03, 
            1.063459838002049e+03,     1.063902956068502e+03,     1.064344888612600e+03,     1.064785642740789e+03,     1.065225225493722e+03, 
            1.065663643847079e+03,     1.066100904712381e+03,     1.066537014937788e+03,     1.066971981308888e+03,     1.067405810549471e+03, 
            1.067838509322288e+03,     1.068270084229802e+03,     1.068700541814932e+03,     1.069129888561771e+03,     1.069558130896310e+03, 
            1.069985275187138e+03,     1.070411327746139e+03,     1.070836294829175e+03,     1.071260182636758e+03,     1.071682997314711e+03, 
            1.072104744954827e+03,     1.072525431595508e+03,     1.072945063222396e+03,     1.073363645769002e+03,     1.073781185117320e+03, 
            1.074197687098427e+03,     1.074613157493085e+03,     1.075027602032328e+03,     1.075441026398039e+03,     1.075853436223520e+03, 
            1.076264837094057e+03,     1.076675234547474e+03,     1.077084634074672e+03,     1.077493041120178e+03,     1.077900461082665e+03, 
            1.078306899315480e+03,     1.078712361127159e+03,     1.079116851781931e+03,     1.079520376500223e+03,     1.079922940459148e+03, 
            1.080324548792995e+03,     1.080725206593708e+03,     1.081124918911358e+03,     1.081523690754607e+03,     1.081921527091169e+03, 
            1.082318432848263e+03,     1.082714412913062e+03,     1.083109472133127e+03,     1.083503615316847e+03,     1.083896847233865e+03, 
            1.084289172615500e+03,     1.084680596155163e+03,     1.085071122508774e+03,     1.085460756295155e+03,     1.085849502096441e+03, 
            1.086237364458470e+03,     1.086624347891171e+03,     1.087010456868947e+03,     1.087395695831058e+03,     1.087780069181990e+03, 
            1.088163581291824e+03,     1.088546236496602e+03,     1.088928039098680e+03,     1.089308993367090e+03,     1.089689103537884e+03, 
            1.090068373814475e+03,     1.090446808367988e+03,     1.090824411337583e+03,     1.091201186830794e+03,     1.091577138923855e+03, 
            1.091952271662022e+03,     1.092326589059884e+03,     1.092700095101693e+03,     1.093072793741659e+03,     1.093444688904264e+03, 
            1.093815784484561e+03,     1.094186084348477e+03,     1.094555592333101e+03,     1.094924312246978e+03,     1.095292247870400e+03, 
            1.095659402955680e+03,     1.096025781227441e+03,     1.096391386382888e+03,     1.096756222092082e+03,     1.097120291998208e+03, 
            1.097483599717841e+03,     1.097846148841214e+03,     1.098207942932468e+03,     1.098568985529915e+03,     1.098929280146292e+03, 
            1.099288830269007e+03,     1.099647639360385e+03,     1.100005710857916e+03,     1.100363048174495e+03,     1.100719654698657e+03, 
            1.101075533794813e+03,     1.101430688803486e+03,     1.101785123041534e+03,     1.102138839802383e+03,     1.102491842356243e+03, 
            1.102844133950337e+03,     1.103195717809117e+03,     1.103546597134474e+03,     1.103896775105962e+03,     1.104246254880999e+03, 
            1.104595039595079e+03,     1.104943132361980e+03,     1.105290536273965e+03,     1.105637254401980e+03,     1.105983289795859e+03, 
            1.106328645484514e+03,     1.106673324476134e+03,     1.107017329758372e+03,     1.107360664298538e+03,     1.107703331043785e+03, 
            1.108045332921294e+03,     1.108386672838455e+03,     1.108727353683051e+03,     1.109067378323435e+03,     1.109406749608708e+03, 
            1.109745470368892e+03,     1.110083543415100e+03,     1.110420971539715e+03,     1.110757757516549e+03,     1.111093904101019e+03, 
            1.111429414030301e+03,     1.111764290023506e+03,     1.112098534781829e+03,     1.112432150988718e+03,     1.112765141310023e+03, 
            1.113097508394161e+03,     1.113429254872263e+03,     1.113760383358328e+03,     1.114090896449377e+03,     1.114420796725597e+03, 
            1.114750086750492e+03,     1.115078769071029e+03,     1.115406846217777e+03,     1.115734320705058e+03,     1.116061195031080e+03, 
            1.116387471678082e+03,     1.116713153112467e+03,     1.117038241784943e+03,     1.117362740130657e+03,     1.117686650569327e+03, 
            1.118009975505371e+03,     1.118332717328047e+03,     1.118654878411574e+03,     1.118976461115262e+03,     1.119297467783638e+03, 
            1.119617900746573e+03,     1.119937762319406e+03,     1.120257054803062e+03,     1.120575780484178e+03,     1.120893941635222e+03, 
            1.121211540514609e+03,     1.121528579366822e+03,     1.121845060422523e+03,     1.122160985898675e+03,     1.122476357998651e+03, 
            1.122791178912343e+03,     1.123105450816284e+03,     1.123419175873747e+03,     1.123732356234862e+03,     1.124044994036719e+03, 
            1.124357091403476e+03,     1.124668650446469e+03,     1.124979673264307e+03,     1.125290161942985e+03,     1.125600118555984e+03, 
            1.125909545164368e+03,     1.126218443816889e+03,     1.126526816550084e+03,     1.126834665388377e+03,     1.127141992344172e+03
    },
    {
            1.762824189614910e+00,     5.343975804665471e+00,     8.997374103083683e+00,     1.272679271285335e+01,     1.653633061566677e+01, 
            2.043045148645554e+01,     2.441402927509919e+01,     2.849240128676394e+01,     3.267143030641897e+01,     3.695757772109014e+01, 
            4.135799010019682e+01,     4.588060237306750e+01,     5.053426164233617e+01,     5.532887688215452e+01,     6.027560141746661e+01, 
            6.538705735227778e+01,     7.067761429234693e+01,     7.616373922167583e+01,     8.186444091471239e+01,     8.780184186955320e+01, 
            9.400192518387287e+01,     1.004955260062220e+02,     1.073196722688483e+02,     1.145194364492158e+02,     1.221505560665489e+02, 
            1.302832482754508e+02,     1.390079511239169e+02,     1.484443162605390e+02,     1.587559990949942e+02,     1.701765172563589e+02, 
            1.830581836423714e+02,     1.979751784862418e+02,     2.159770858478290e+02,     2.393907368658603e+02,     2.761189606080960e+02, 
            6.644605203527851e+02,     6.861230549736958e+02,     7.013638873728283e+02,     7.134215449554503e+02,     7.235247491623844e+02, 
            7.322883576712144e+02,     7.400682992081634e+02,     7.470906865071654e+02,     7.535088817340370e+02,     7.594321231464144e+02, 
            7.649412440857229e+02,     7.700979156625119e+02,     7.749503827284424e+02,     7.795371831501258e+02,     7.838896489640340e+02, 
            7.880336410738875e+02,     7.919907846706408e+02,     7.957793695671377e+02,     7.994150197194884e+02,     8.029112000793149e+02, 
            8.062796064497234e+02,     8.095304696518706e+02,     8.126727958977457e+02,     8.157145589629960e+02,     8.186628554497253e+02, 
            8.215240314365794e+02,     8.243037866982335e+02,     8.270072611588589e+02,     8.296391071401127e+02,     8.322035501508528e+02, 
            8.347044403593221e+02,     8.371452964315076e+02,     8.395293430712462e+02,     8.418595433301174e+02,     8.441386265475585e+02, 
            8.463691126192831e+02,     8.485533331641383e+02,     8.506934500578205e+02,     8.527914717206801e+02,     8.548492674813184e+02, 
            8.568685802847871e+02,     8.588510379709554e+02,     8.607981633133028e+02,     8.627113829792507e+02,     8.645920355490550e+02, 
            8.664413787102634e+02,     8.682605957279894e+02,     8.700508012772253e+02,     8.718130467116172e+02,     8.735483248331192e+02, 
            8.752575742184576e+02,     8.769416831511428e+02,     8.786014932015789e+02,     8.802378024925462e+02,     8.818513686827769e+02, 
            8.834429116974342e+02,     8.850131162309121e+02,     8.865626340444322e+02,     8.880920860783556e+02,     8.896020643969169e+02, 
            8.910931339811126e+02,     8.925658343837990e+02,     8.940206812595446e+02,     8.954581677804667e+02,     8.968787659481249e+02, 
            8.982829278105171e+02,     8.996710865923150e+02,     9.010436577456803e+02,     9.024010399282773e+02,     9.037436159144611e+02, 
            9.050717534450672e+02,     9.063858060207137e+02,     9.076861136430643e+02,     9.089730035081164e+02,     9.102467906551900e+02, 
            9.115077785749945e+02,     9.127562597798312e+02,     9.139925163387279e+02,     9.152168203800857e+02,     9.164294345641615e+02, 
            9.176306125275693e+02,     9.188205993017327e+02,     9.199996317071449e+02,     9.211679387250700e+02,     9.223257418482418e+02, 
            9.234732554119607e+02,     9.246106869069055e+02,     9.257382372797011e+02,     9.268561012009341e+02,     9.279644674135418e+02, 
            9.290635188962985e+02,     9.301534323553402e+02,     9.312343807745997e+02,     9.323065308614442e+02,     9.333700450240237e+02, 
            9.344250799899327e+02,     9.354717894891595e+02,     9.365103217744404e+02,     9.375408216700802e+02,     9.385634295038919e+02, 
            9.395782819270237e+02,     9.405855118846479e+02,     9.415852487524979e+02,     9.425776184670814e+02,     9.435627436499270e+02, 
            9.445407437261891e+02,     9.455117350379207e+02,     9.464758309522962e+02,     9.474331419650539e+02,     9.483837757994191e+02, 
            9.493278375007391e+02,     9.502654295270427e+02,     9.511966518357575e+02,     9.521216019667609e+02,     9.530403751219560e+02, 
            9.539530642415507e+02,     9.548597600772032e+02,     9.557605512621810e+02,     9.566555243786897e+02,     9.575447640225027e+02, 
            9.584283528787604e+02,     9.593063717253348e+02,     9.601788995765750e+02,     9.610460136792517e+02,     9.619077895806868e+02, 
            9.627643011796858e+02,     9.636156207755455e+02,     9.644618191152151e+02,     9.653029654154494e+02,     9.661391275012882e+02, 
            9.669703717033796e+02,     9.677967629970032e+02,     9.686183650161008e+02,     9.694352400910049e+02,     9.702474492848301e+02, 
            9.710550524285829e+02,     9.718581081550392e+02,     9.726566739314433e+02,     9.734508060910852e+02,     9.742405598637861e+02, 
            9.750259894053632e+02,     9.758071478260822e+02,     9.765840872181700e+02,     9.773568586824057e+02,     9.781255123538361e+02, 
            9.788900974266464e+02,     9.796506621782179e+02,     9.804072539924130e+02,     9.811599193821103e+02,     9.819087040110177e+02, 
            9.826536527147988e+02,     9.833948095215288e+02,     9.841322176715219e+02,     9.848659196365243e+02,     9.855959571383372e+02, 
            9.863223711668495e+02,     9.870452019975368e+02,     9.877644892084180e+02,     9.884802716965160e+02,     9.891925876938138e+02, 
            9.899014747827450e+02,     9.906069699112281e+02,     9.913091094072522e+02,     9.920079289930534e+02,     9.927034638219634e+02, 
            9.933957483982491e+02,     9.940848167321227e+02,     9.947707022564617e+02,     9.954534378633513e+02,     9.961330559159946e+02, 
            9.968095882602896e+02,     9.974830662360924e+02,     9.981535206881613e+02,     9.988209819768048e+02,     9.994854799882427e+02, 
            1.000147044144681e+03,     1.000805703414120e+03,     1.001461486319901e+03,     1.002114420949991e+03,     1.002764534966028e+03, 
            1.003411855612134e+03,     1.004056409723486e+03,     1.004698223734669e+03,     1.005337323687813e+03,     1.005973735240525e+03, 
            1.006607483673609e+03,     1.007238593898598e+03,     1.007867090465091e+03,     1.008492997567907e+03,     1.009116339054057e+03, 
            1.009737138429550e+03,     1.010355418866021e+03,     1.010971203207201e+03,     1.011584513485124e+03,     1.012195372868929e+03, 
            1.012803802783173e+03,     1.013409824821567e+03,     1.014013460279979e+03,     1.014614730162021e+03,     1.015213655184504e+03, 
            1.015810255782752e+03,     1.016404552115817e+03,     1.016996564071544e+03,     1.017586311271539e+03,     1.018173813076004e+03, 
            1.018759088588481e+03,     1.019342156660469e+03,     1.019923035895944e+03,     1.020501744655781e+03,     1.021078301062063e+03, 
            1.021652723002307e+03,     1.022225028133585e+03,     1.022795233886562e+03,     1.023363357469438e+03,     1.023929415871801e+03, 
            1.024493425868409e+03,     1.025055404022871e+03,     1.025615366691263e+03,     1.026173330025658e+03,     1.026729309977581e+03, 
            1.027283322301392e+03,     1.027835382557595e+03,     1.028385506116077e+03,     1.028933708159279e+03,     1.029480003685303e+03, 
            1.030024407510945e+03,     1.030566934274675e+03,     1.031107598439552e+03,     1.031646414296072e+03,     1.032183395964969e+03, 
            1.032718557399950e+03,     1.033251912390375e+03,     1.033783474563889e+03,     1.034313257388991e+03,     1.034841274177559e+03, 
            1.035367538087321e+03,     1.035892062124281e+03,     1.036414859145086e+03,     1.036935941859361e+03,     1.037455322831984e+03, 
            1.037973014485326e+03,     1.038489029101446e+03,     1.039003378824236e+03,     1.039516075661533e+03,     1.040027131487187e+03, 
            1.040536558043089e+03,     1.041044366941156e+03,     1.041550569665289e+03,     1.042055177573286e+03,     1.042558201898715e+03, 
            1.043059653752761e+03,     1.043559544126036e+03,     1.044057883890349e+03,     1.044554683800451e+03,     1.045049954495740e+03, 
            1.045543706501944e+03,     1.046035950232764e+03,     1.046526695991490e+03,     1.047015953972593e+03,     1.047503734263277e+03, 
            1.047990046845013e+03,     1.048474901595042e+03,     1.048958308287846e+03,     1.049440276596603e+03,     1.049920816094606e+03, 
            1.050399936256662e+03,     1.050877646460466e+03,     1.051353955987951e+03,     1.051828874026609e+03,     1.052302409670800e+03, 
            1.052774571923025e+03,     1.053245369695186e+03,     1.053714811809823e+03,     1.054182907001326e+03,     1.054649663917129e+03, 
            1.055115091118884e+03,     1.055579197083614e+03,     1.056041990204840e+03,     1.056503478793709e+03,     1.056963671080076e+03, 
            1.057422575213586e+03,     1.057880199264738e+03,     1.058336551225916e+03,     1.058791639012422e+03,     1.059245470463478e+03, 
            1.059698053343221e+03,     1.060149395341671e+03,     1.060599504075695e+03,     1.061048387089945e+03,     1.061496051857789e+03, 
            1.061942505782222e+03,     1.062387756196761e+03,     1.062831810366331e+03,     1.063274675488133e+03,     1.063716358692498e+03, 
            1.064156867043729e+03,     1.064596207540930e+03,     1.065034387118818e+03,     1.065471412648527e+03,     1.065907290938397e+03, 
            1.066342028734752e+03,     1.066775632722661e+03,     1.067208109526696e+03,     1.067639465711670e+03,     1.068069707783366e+03, 
            1.068498842189260e+03,     1.068926875319222e+03,     1.069353813506219e+03,     1.069779663026997e+03,     1.070204430102757e+03, 
            1.070628120899821e+03,     1.071050741530288e+03,     1.071472298052678e+03,     1.071892796472566e+03,     1.072312242743215e+03, 
            1.072730642766184e+03,     1.073148002391940e+03,     1.073564327420457e+03,     1.073979623601808e+03,     1.074393896636735e+03, 
            1.074807152177239e+03,     1.075219395827129e+03,     1.075630633142583e+03,     1.076040869632699e+03,     1.076450110760032e+03, 
            1.076858361941124e+03,     1.077265628547033e+03,     1.077671915903844e+03,     1.078077229293185e+03,     1.078481573952724e+03, 
            1.078884955076667e+03,     1.079287377816243e+03,     1.079688847280188e+03,     1.080089368535218e+03,     1.080488946606494e+03, 
            1.080887586478088e+03,     1.081285293093436e+03,     1.081682071355781e+03,     1.082077926128622e+03,     1.082472862236147e+03, 
            1.082866884463659e+03,     1.083259997558009e+03,     1.083652206228004e+03,     1.084043515144826e+03,     1.084433928942435e+03, 
            1.084823452217973e+03,     1.085212089532157e+03,     1.085599845409670e+03,     1.085986724339549e+03,     1.086372730775559e+03, 
            1.086757869136572e+03,     1.087142143806937e+03,     1.087525559136843e+03,     1.087908119442678e+03,     1.088289829007385e+03, 
            1.088670692080816e+03,     1.089050712880071e+03,     1.089429895589845e+03,     1.089808244362762e+03,     1.090185763319706e+03, 
            1.090562456550154e+03,     1.090938328112495e+03,     1.091313382034350e+03,     1.091687622312889e+03,     1.092061052915141e+03, 
            1.092433677778304e+03,     1.092805500810045e+03,     1.093176525888797e+03,     1.093546756864065e+03,     1.093916197556705e+03, 
            1.094284851759222e+03,     1.094652723236047e+03,     1.095019815723824e+03,     1.095386132931684e+03,     1.095751678541521e+03, 
            1.096116456208256e+03,     1.096480469560114e+03,     1.096843722198881e+03,     1.097206217700165e+03,     1.097567959613655e+03, 
            1.097928951463373e+03,     1.098289196747927e+03,     1.098648698940757e+03,     1.099007461490381e+03,     1.099365487820634e+03, 
            1.099722781330912e+03,     1.100079345396400e+03,     1.100435183368314e+03,     1.100790298574125e+03,     1.101144694317786e+03, 
            1.101498373879961e+03,     1.101851340518243e+03,     1.102203597467375e+03,     1.102555147939468e+03,     1.102905995124210e+03, 
            1.103256142189082e+03,     1.103605592279569e+03,     1.103954348519358e+03,     1.104302414010549e+03,     1.104649791833856e+03, 
            1.104996485048804e+03,     1.105342496693927e+03,     1.105687829786964e+03,     1.106032487325047e+03,     1.106376472284896e+03, 
            1.106719787623005e+03,     1.107062436275824e+03,     1.107404421159952e+03,     1.107745745172307e+03,     1.108086411190315e+03, 
            1.108426422072079e+03,     1.108765780656561e+03,     1.109104489763753e+03,     1.109442552194846e+03,     1.109779970732401e+03, 
            1.110116748140519e+03,     1.110452887165001e+03,     1.110788390533516e+03,     1.111123260955762e+03,     1.111457501123624e+03, 
            1.111791113711335e+03,     1.112124101375629e+03,     1.112456466755901e+03,     1.112788212474352e+03,     1.113119341136149e+03, 
            1.113449855329566e+03,     1.113779757626142e+03,     1.114109050580814e+03,     1.114437736732076e+03,     1.114765818602110e+03, 
            1.115093298696937e+03,     1.115420179506549e+03,     1.115746463505054e+03,     1.116072153150808e+03,     1.116397250886553e+03, 
            1.116721759139550e+03,     1.117045680321712e+03,     1.117369016829736e+03,     1.117691771045231e+03,     1.118013945334845e+03, 
            1.118335542050397e+03,     1.118656563528998e+03,     1.118977012093176e+03,     1.119296890051000e+03,     1.119616199696201e+03, 
            1.119934943308293e+03,     1.120253123152690e+03,     1.120570741480826e+03,     1.120887800530270e+03,     1.121204302524844e+03, 
            1.121520249674734e+03,     1.121835644176600e+03,     1.122150488213699e+03,     1.122464783955984e+03,     1.122778533560217e+03, 
            1.123091739170080e+03,     1.123404402916280e+03,     1.123716526916653e+03,     1.124028113276274e+03,     1.124339164087557e+03, 
            1.124649681430358e+03,     1.124959667372078e+03,     1.125269123967764e+03,     1.125578053260207e+03,     1.125886457280043e+03
    },
    {
            1.759251996957096e+00,     5.332793840144381e+00,     8.977920935061405e+00,     1.269833984072722e+01,     1.649807363374061e+01, 
            2.038149977283782e+01,     2.435339390287226e+01,     2.841898077936403e+01,     3.258399376270130e+01,     3.685474470894619e+01, 
            4.123820655138525e+01,     4.574211149084208e+01,     5.037506853644022e+01,     5.514670524207823e+01,     6.006783997936507e+01, 
            6.515069314012607e+01,     7.040914851714896e+01,     7.585908014490009e+01,     8.151876567227039e+01,     8.740941580410532e+01, 
            9.355586197202524e+01,     9.998746364406844e+01,     1.067393267729094e+02,     1.138539732572199e+02,     1.213836815965520e+02, 
            1.293938570720224e+02,     1.379680383695557e+02,     1.472156163938486e+02,     1.572842824832828e+02,     1.683812550537257e+02, 
            1.808121449418255e+02,     1.950591652329535e+02,     2.119608263789260e+02,     2.332179266798207e+02,     2.634581387919676e+02, 
            6.337387529684381e+02,     6.674383203385997e+02,     6.868522619971899e+02,     7.011897751995167e+02,     7.127681588289398e+02, 
            7.225803405086980e+02,     7.311524301112139e+02,     7.387994933122756e+02,     7.457262565153999e+02,     7.520738348299475e+02, 
            7.579439653421192e+02,     7.634126402807533e+02,     7.685382728034610e+02,     7.733668389291129e+02,     7.779352510011747e+02, 
            7.822736483086111e+02,     7.864069986486736e+02,     7.903562467675827e+02,     7.941391562391732e+02,     7.977709387144122e+02, 
            8.012647324166734e+02,     8.046319716399963e+02,     8.078826760462338e+02,     8.110256800080989e+02,     8.140688164861587e+02, 
            8.170190659735345e+02,     8.198826782794054e+02,     8.226652729613287e+02,     8.253719228038711e+02,     8.280072237098633e+02, 
            8.305753536084439e+02,     8.330801224140813e+02,     8.355250146400400e+02,     8.379132259409588e+02,     8.402476946057325e+02, 
            8.425311288250098e+02,     8.447660304031712e+02,     8.469547154627681e+02,     8.490993325923455e+02,     8.512018788109300e+02, 
            8.532642136597690e+02,     8.552880716811142e+02,     8.572750735023911e+02,     8.592267357100847e+02,     8.611444796696478e+02, 
            8.630296394244888e+02,     8.648834687877837e+02,     8.667071477246677e+02,     8.685017881088058e+02,     8.702684389258764e+02, 
            8.720080909868404e+02,     8.737216812056241e+02,     8.754100964888459e+02,     8.770741772792056e+02,     8.787147207890449e+02, 
            8.803324839561130e+02,     8.819281861497985e+02,     8.835025116527488e+02,     8.850561119399567e+02,     8.865896077748648e+02, 
            8.881035911399036e+02,     8.895986270169235e+02,     8.910752550313700e+02,     8.925339909725299e+02,     8.939753282009298e+02, 
            8.953997389528112e+02,     8.968076755505924e+02,     8.981995715273542e+02,     8.995758426725976e+02,     9.009368880057901e+02, 
            9.022830906836357e+02,     9.036148188463987e+02,     9.049324264081628e+02,     9.062362537954133e+02,     9.075266286379582e+02, 
            9.088038664158523e+02,     9.100682710656339e+02,     9.113201355489246e+02,     9.125597423861642e+02,     9.137873641580212e+02, 
            9.150032639768115e+02,     9.162076959300477e+02,     9.174009054980875e+02,     9.185831299476780e+02,     9.197545987030460e+02, 
            9.209155336960725e+02,     9.220661496969335e+02,     9.232066546265239e+02,     9.243372498552137e+02,     9.254581305198039e+02, 
            9.265694857725480e+02,     9.276714990037298e+02,     9.287643469054844e+02,     9.298482034832168e+02,     9.309232355856639e+02, 
            9.319896057559779e+02,     9.330474718503468e+02,     9.340969870588887e+02,     9.351383007477417e+02,     9.361715575948892e+02, 
            9.371968984548731e+02,     9.382144603269438e+02,     9.392243764983266e+02,     9.402267766808097e+02,     9.412217871410196e+02, 
            9.422095308247358e+02,     9.431901274755639e+02,     9.441636937482872e+02,     9.451303433171681e+02,     9.460901869794768e+02, 
            9.470433327544996e+02,     9.479898859782564e+02,     9.489299493941592e+02,     9.498636232398156e+02,     9.507910053301672e+02, 
            9.517121911371662e+02,     9.526272738661398e+02,     9.535363445290303e+02,     9.544394920146467e+02,     9.553368031560835e+02, 
            9.562283628097629e+02,     9.571142538589403e+02,     9.579945573635567e+02,     9.588693525559595e+02,     9.597387169118923e+02, 
            9.606027262035285e+02,     9.614614545504897e+02,     9.623149744689288e+02,     9.631633568967071e+02,     9.640066713288134e+02, 
            9.648449857237167e+02,     9.656783666390176e+02,     9.665068792482800e+02,     9.673305873802467e+02,     9.681495535566362e+02, 
            9.689638390286118e+02,     9.697735038119570e+02,     9.705786067210214e+02,     9.713792054014921e+02,     9.721753563620289e+02, 
            9.729671150048235e+02,     9.737545356551178e+02,     9.745376715897258e+02,     9.753165750646016e+02,     9.760912973414909e+02, 
            9.768618887137038e+02,     9.776283985310424e+02,     9.783908752239111e+02,     9.791493663266605e+02,     9.799039185001687e+02, 
            9.806545775537106e+02,     9.814013884661301e+02,     9.821443954063512e+02,     9.828836417532422e+02,     9.836191701148701e+02, 
            9.843510223471557e+02,     9.850792395719601e+02,     9.858038621946207e+02,     9.865249299209565e+02,     9.872424817737652e+02, 
            9.879565561088214e+02,     9.886671906303005e+02,     9.893744224285725e+02,     9.900782879039281e+02,     9.907788229182836e+02, 
            9.914760627163197e+02,     9.921700419623211e+02,     9.928607947531862e+02,     9.935483546310749e+02,     9.942327545956967e+02, 
            9.949140271162488e+02,     9.955922041430366e+02,     9.962673171187539e+02,     9.969393969894634e+02,     9.976084742152763e+02, 
            9.982745787807366e+02,     9.989377402049292e+02,     9.995979875513116e+02,     1.000255349437285e+03,     1.000909854043511e+03, 
            1.001561529122984e+03,     1.002210402009859e+03,     1.002856499628054e+03,     1.003499848499628e+03,     1.004140474752937e+03, 
            1.004778404130593e+03,     1.005413661997202e+03,     1.006046273346923e+03,     1.006676262810820e+03,     1.007303654664040e+03, 
            1.007928472832811e+03,     1.008550740901257e+03,     1.009170482118052e+03,     1.009787718913889e+03,     1.010402474846038e+03, 
            1.011014771723564e+03,     1.011624631516664e+03,     1.012232075890980e+03,     1.012837126213349e+03,     1.013439803557395e+03, 
            1.014040128709009e+03,     1.014638122171680e+03,     1.015233804171715e+03,     1.015827194663329e+03,     1.016418313333626e+03, 
            1.017007179607451e+03,     1.017593812652141e+03,     1.018178231382162e+03,     1.018760454463645e+03,     1.019340500318816e+03, 
            1.019918387130320e+03,     1.020494132845463e+03,     1.021067755180345e+03,     1.021639271623903e+03,     1.022208699441878e+03, 
            1.022776055680673e+03,     1.023341357171143e+03,     1.023904620532297e+03,     1.024465862174918e+03,     1.025025098305106e+03, 
            1.025582344927746e+03,     1.026137617849898e+03,     1.026690932684122e+03,     1.027242304851720e+03,     1.027791749585924e+03, 
            1.028339281935007e+03,     1.028884916765332e+03,     1.029428668764335e+03,     1.029970552443453e+03,     1.030510582140982e+03, 
            1.031048772024885e+03,     1.031585136095534e+03,     1.032119688188405e+03,     1.032652441976710e+03,     1.033183410973982e+03, 
            1.033712608536603e+03,     1.034240047866288e+03,     1.034765742012510e+03,     1.035289703874887e+03,     1.035811946205512e+03, 
            1.036332481611247e+03,     1.036851322555963e+03,     1.037368481362741e+03,     1.037883970216030e+03,     1.038397801163764e+03, 
            1.038909986119432e+03,     1.039420536864116e+03,     1.039929465048491e+03,     1.040436782194772e+03,     1.040942499698646e+03, 
            1.041446628831148e+03,     1.041949180740515e+03,     1.042450166454001e+03,     1.042949596879649e+03,     1.043447482808048e+03, 
            1.043943834914043e+03,     1.044438663758421e+03,     1.044931979789558e+03,     1.045423793345044e+03,     1.045914114653280e+03, 
            1.046402953835033e+03,     1.046890320904976e+03,     1.047376225773197e+03,     1.047860678246676e+03,     1.048343688030738e+03, 
            1.048825264730487e+03,     1.049305417852201e+03,     1.049784156804718e+03,     1.050261490900782e+03,     1.050737429358378e+03, 
            1.051211981302034e+03,     1.051685155764111e+03,     1.052156961686059e+03,     1.052627407919661e+03,     1.053096503228245e+03, 
            1.053564256287890e+03,     1.054030675688596e+03,     1.054495769935443e+03,     1.054959547449731e+03,     1.055422016570093e+03, 
            1.055883185553600e+03,     1.056343062576834e+03,     1.056801655736960e+03,     1.057258973052763e+03,     1.057715022465677e+03, 
            1.058169811840802e+03,     1.058623348967889e+03,     1.059075641562323e+03,     1.059526697266080e+03,     1.059976523648680e+03, 
            1.060425128208110e+03,     1.060872518371742e+03,     1.061318701497237e+03,     1.061763684873422e+03,     1.062207475721173e+03, 
            1.062650081194265e+03,     1.063091508380218e+03,     1.063531764301129e+03,     1.063970855914489e+03,     1.064408790113988e+03, 
            1.064845573730303e+03,     1.065281213531887e+03,     1.065715716225726e+03,     1.066149088458101e+03,     1.066581336815328e+03, 
            1.067012467824496e+03,     1.067442487954178e+03,     1.067871403615154e+03,     1.068299221161099e+03,     1.068725946889273e+03, 
            1.069151587041207e+03,     1.069576147803360e+03,     1.069999635307783e+03,     1.070422055632765e+03,     1.070843414803471e+03, 
            1.071263718792569e+03,     1.071682973520850e+03,     1.072101184857838e+03,     1.072518358622389e+03,     1.072934500583287e+03, 
            1.073349616459821e+03,     1.073763711922364e+03,     1.074176792592936e+03,     1.074588864045767e+03,     1.074999931807840e+03, 
            1.075410001359436e+03,     1.075819078134669e+03,     1.076227167522009e+03,     1.076634274864806e+03,     1.077040405461793e+03, 
            1.077445564567597e+03,     1.077849757393233e+03,     1.078252989106594e+03,     1.078655264832933e+03,     1.079056589655336e+03, 
            1.079456968615201e+03,     1.079856406712689e+03,     1.080254908907186e+03,     1.080652480117753e+03,     1.081049125223568e+03, 
            1.081444849064361e+03,     1.081839656440853e+03,     1.082233552115171e+03,     1.082626540811275e+03,     1.083018627215369e+03, 
            1.083409815976311e+03,     1.083800111706012e+03,     1.084189518979834e+03,     1.084578042336985e+03,     1.084965686280902e+03, 
            1.085352455279633e+03,     1.085738353766213e+03,     1.086123386139036e+03,     1.086507556762217e+03,     1.086890869965961e+03, 
            1.087273330046909e+03,     1.087654941268500e+03,     1.088035707861312e+03,     1.088415634023403e+03,     1.088794723920655e+03, 
            1.089172981687101e+03,     1.089550411425258e+03,     1.089927017206452e+03,     1.090302803071135e+03,     1.090677773029207e+03, 
            1.091051931060323e+03,     1.091425281114204e+03,     1.091797827110941e+03,     1.092169572941295e+03,     1.092540522466995e+03, 
            1.092910679521030e+03,     1.093280047907936e+03,     1.093648631404084e+03,     1.094016433757964e+03,     1.094383458690456e+03, 
            1.094749709895114e+03,     1.095115191038427e+03,     1.095479905760099e+03,     1.095843857673301e+03,     1.096207050364942e+03, 
            1.096569487395923e+03,     1.096931172301392e+03,     1.097292108590995e+03,     1.097652299749126e+03,     1.098011749235173e+03, 
            1.098370460483759e+03,     1.098728436904983e+03,     1.099085681884653e+03,     1.099442198784527e+03,     1.099797990942535e+03, 
            1.100153061673016e+03,     1.100507414266936e+03,     1.100861051992113e+03,     1.101213978093442e+03,     1.101566195793104e+03, 
            1.101917708290785e+03,     1.102268518763892e+03,     1.102618630367753e+03,     1.102968046235834e+03,     1.103316769479938e+03, 
            1.103664803190410e+03,     1.104012150436333e+03,     1.104358814265732e+03,     1.104704797705765e+03,     1.105050103762914e+03, 
            1.105394735423180e+03,     1.105738695652272e+03,     1.106081987395790e+03,     1.106424613579407e+03,     1.106766577109061e+03, 
            1.107107880871122e+03,     1.107448527732582e+03,     1.107788520541221e+03,     1.108127862125788e+03,     1.108466555296167e+03, 
            1.108804602843554e+03,     1.109142007540616e+03,     1.109478772141664e+03,     1.109814899382817e+03,     1.110150391982159e+03, 
            1.110485252639906e+03,     1.110819484038559e+03,     1.111153088843065e+03,     1.111486069700971e+03,     1.111818429242575e+03, 
            1.112150170081084e+03,     1.112481294812756e+03,     1.112811806017055e+03,     1.113141706256794e+03,     1.113470998078282e+03, 
            1.113799684011467e+03,     1.114127766570077e+03,     1.114455248251762e+03,     1.114782131538232e+03,     1.115108418895397e+03, 
            1.115434112773496e+03,     1.115759215607239e+03,     1.116083729815938e+03,     1.116407657803634e+03,     1.116731001959233e+03, 
            1.117053764656634e+03,     1.117375948254849e+03,     1.117697555098141e+03,     1.118018587516138e+03,     1.118339047823962e+03, 
            1.118658938322351e+03,     1.118978261297777e+03,     1.119297019022567e+03,     1.119615213755020e+03,     1.119932847739526e+03, 
            1.120249923206681e+03,     1.120566442373399e+03,     1.120882407443031e+03,     1.121197820605470e+03,     1.121512684037267e+03, 
            1.121826999901738e+03,     1.122140770349076e+03,     1.122453997516454e+03,     1.122766683528137e+03,     1.123078830495580e+03, 
            1.123390440517541e+03,     1.123701515680175e+03,     1.124012058057144e+03,     1.124322069709714e+03,     1.124631552686854e+03
    },
    {
            1.755694496390713e+00,     5.321660922770048e+00,     8.958558696440528e+00,     1.267002861799498e+01,     1.646001942465736e+01, 
            2.033282423724719e+01,     2.429312265882728e+01,     2.834602963547234e+01,     3.249715243790386e+01,     3.675265747275518e+01, 
            4.111934906295718e+01,     4.560476291028785e+01,     5.021727770744875e+01,     5.496624937364597e+01,     5.986217374580549e+01, 
            6.491688541260383e+01,     7.014380294614971e+01,     7.555823439196688e+01,     8.117776202241160e+01,     8.702273282700570e+01, 
            9.311689226495157e+01,     9.948821551126380e+01,     1.061700162882460e+02,     1.132024544875504e+02,     1.206346311596438e+02, 
            1.285275737644143e+02,     1.369586162096391e+02,     1.460280520370462e+02,     1.558696690613746e+02,     1.666683036146346e+02, 
            1.786910333444586e+02,     1.923474496685050e+02,     2.083202614389722e+02,     2.279002160122779e+02,     2.541232632541805e+02, 
            2.991089444825559e+02,     6.426031164817635e+02,     6.697040364585931e+02,     6.874189968363781e+02,     7.009797470474050e+02, 
            7.121218268528042e+02,     7.216601918646613e+02,     7.300480472963890e+02,     7.375651544552838e+02,     7.443971316583670e+02, 
            7.506738862729455e+02,     7.564901664477397e+02,     7.619173904322166e+02,     7.670108584572829e+02,     7.718143584974137e+02, 
            7.763632228717488e+02,     7.806864235624271e+02,     7.848080490016844e+02,     7.887483702851904e+02,     7.925246273765952e+02, 
            7.961516197535329e+02,     7.996421575657292e+02,     8.030074114078230e+02,     8.062571871426888e+02,     8.094001444630156e+02, 
            8.124439726276348e+02,     8.153955331837585e+02,     8.182609769411573e+02,     8.210458406496583e+02,     8.237551275191679e+02, 
            8.263933747600435e+02,     8.289647106086730e+02,     8.314729027684369e+02,     8.339213997909866e+02,     8.363133666125898e+02, 
            8.386517152207663e+02,     8.409391312397676e+02,     8.431780970769089e+02,     8.453709121557453e+02,     8.475197106696472e+02, 
            8.496264772151576e+02,     8.516930606045836e+02,     8.537211861086813e+02,     8.557124663404404e+02,     8.576684109584219e+02, 
            8.595904353410516e+02,     8.614798683609920e+02,     8.633379593699947e+02,     8.651658844890920e+02,     8.669647522858361e+02, 
            8.687356089092393e+02,     8.704794427436975e+02,     8.721971886351848e+02,     8.738897317362324e+02,     8.755579110103672e+02, 
            8.772025224316932e+02,     8.788243219109954e+02,     8.804240279760098e+02,     8.820023242303251e+02,     8.835598616125275e+02, 
            8.850972604748061e+02,     8.866151124981056e+02,     8.881139824590169e+02,     8.895944098620305e+02,     8.910569104492637e+02, 
            8.925019775985924e+02,     8.939300836199172e+02,     8.953416809584037e+02,     8.967372033125589e+02,     8.981170666743292e+02, 
            8.994816702976369e+02,     9.008313976012103e+02,     9.021666170109869e+02,     9.034876827468851e+02,     9.047949355583035e+02, 
            9.060887034123213e+02,     9.073693021381944e+02,     9.086370360314528e+02,     9.098921984206079e+02,     9.111350721992043e+02, 
            9.123659303257564e+02,     9.135850362938469e+02,     9.147926445745251e+02,     9.159890010329354e+02,     9.171743433209617e+02, 
            9.183489012475334e+02,     9.195128971280961e+02,     9.206665461146625e+02,     9.218100565080144e+02,     9.229436300774230e+02, 
            9.240674623559702e+02,     9.251817428644769e+02,     9.262866544299704e+02,     9.273823763432326e+02,     9.284690810441516e+02, 
            9.295469363093729e+02,     9.306161050313227e+02,     9.316767452395889e+02,     9.327290109873593e+02,     9.337730514417798e+02, 
            9.348090117929266e+02,     9.358370332204506e+02,     9.368572530437398e+02,     9.378698048651830e+02,     9.388748187067539e+02, 
            9.398724211403018e+02,     9.408627354118794e+02,     9.418458815604557e+02,     9.428219765312925e+02,     9.437911342842931e+02, 
            9.447534658975791e+02,     9.457090796665437e+02,     9.466580811986362e+02,     9.476005735040637e+02,     9.485366570826703e+02, 
            9.494664300071313e+02,     9.503899880026967e+02,     9.513074245236268e+02,     9.522188308264952e+02,     9.531242960405141e+02, 
            9.540239072350208e+02,     9.549177494977408e+02,     9.558059059418464e+02,     9.566884578505270e+02,     9.575654846764418e+02, 
            9.584370641118367e+02,     9.593032721416550e+02,     9.601641830720248e+02,     9.610198696714554e+02,     9.618704030774610e+02, 
            9.627158529377685e+02,     9.635562874297934e+02,     9.643917733029117e+02,     9.652223759191988e+02,     9.660481592927023e+02, 
            9.668691861273109e+02,     9.676855178532760e+02,     9.684972146624502e+02,     9.693043355422992e+02,     9.701069383087232e+02, 
            9.709050796377538e+02,     9.716988150961693e+02,     9.724881991710686e+02,     9.732732852984449e+02,     9.740541258908117e+02, 
            9.748307723639023e+02,     9.756032751624962e+02,     9.763716837853933e+02,     9.771360468095801e+02,     9.778964119136130e+02, 
            9.786528259002541e+02,     9.794053347183805e+02,     9.801539834842068e+02,     9.808988165018378e+02,     9.816398772831751e+02, 
            9.823772085672156e+02,     9.831108523387463e+02,     9.838408498464722e+02,     9.845672416205921e+02,     9.852900675122513e+02, 
            9.860093666193263e+02,     9.867251774403140e+02,     9.874375377968008e+02,     9.881464848721545e+02,     9.888520552261890e+02, 
            9.895542848093991e+02,     9.902532089767873e+02,     9.909488625012942e+02,     9.916412795868461e+02,     9.923304938810252e+02, 
            9.930165384873918e+02,     9.936994459774601e+02,     9.943792484023294e+02,     9.950559773040103e+02,     9.957296637264258e+02, 
            9.964003382261162e+02,     9.970680308826513e+02,     9.977327713087670e+02,     9.983945886602196e+02,     9.990535116453825e+02, 
            9.997095685345898e+02,     1.000362787169224e+03,     1.001013194970579e+03,     1.001660818948477e+03,     1.002305685709667e+03, 
            1.002947821466016e+03,     1.003587252042470e+03,     1.004224002884830e+03,     1.004858099067317e+03,     1.005489565299958e+03, 
            1.006118425935774e+03,     1.006744704977798e+03,     1.007368426085911e+03,     1.007989612095733e+03,     1.008608286958333e+03, 
            1.009224472873259e+03,     1.009838192192879e+03,     1.010449466958171e+03,     1.011058318904621e+03,     1.011664769467971e+03, 
            1.012268839789851e+03,     1.012870550723249e+03,     1.013469922837877e+03,     1.014066976425396e+03,     1.014661731504528e+03, 
            1.015254207826037e+03,     1.015844424877611e+03,     1.016432401888618e+03,     1.017018157834761e+03,     1.017601711442621e+03, 
            1.018183081194105e+03,     1.018762285330782e+03,     1.019339341858136e+03,     1.019914268549709e+03,     1.020487082951165e+03, 
            1.021057802384255e+03,     1.021626443950698e+03,     1.022193024535977e+03,     1.022757560813055e+03,     1.023320069245997e+03, 
            1.023880566093537e+03,     1.024439067412548e+03,     1.024995589061443e+03,     1.025550146703508e+03,     1.026102755810163e+03, 
            1.026653431664149e+03,     1.027202189362652e+03,     1.027749043820361e+03,     1.028294009772467e+03,     1.028837101777586e+03, 
            1.029378334220639e+03,     1.029917721315659e+03,     1.030455277108550e+03,     1.030991015479781e+03,     1.031524950147033e+03, 
            1.032057094667790e+03,     1.032587462441874e+03,     1.033116066713937e+03,     1.033642920575895e+03,     1.034168036969318e+03, 
            1.034691428687774e+03,     1.035213108379123e+03,     1.035733088547770e+03,     1.036251381556870e+03,     1.036767999630491e+03, 
            1.037282954855740e+03,     1.037796259184841e+03,     1.038307924437179e+03,     1.038817962301297e+03,     1.039326384336866e+03, 
            1.039833201976609e+03,     1.040338426528189e+03,     1.040842069176069e+03,     1.041344140983326e+03,     1.041844652893442e+03, 
            1.042343615732055e+03,     1.042841040208678e+03,     1.043336936918387e+03,     1.043831316343483e+03,     1.044324188855114e+03, 
            1.044815564714877e+03,     1.045305454076380e+03,     1.045793866986790e+03,     1.046280813388339e+03,     1.046766303119814e+03, 
            1.047250345918012e+03,     1.047732951419174e+03,     1.048214129160392e+03,     1.048693888580990e+03,     1.049172239023886e+03, 
            1.049649189736922e+03,     1.050124749874177e+03,     1.050598928497253e+03,     1.051071734576543e+03,     1.051543176992473e+03, 
            1.052013264536724e+03,     1.052482005913437e+03,     1.052949409740387e+03,     1.053415484550151e+03,     1.053880238791243e+03, 
            1.054343680829240e+03,     1.054805818947882e+03,     1.055266661350157e+03,     1.055726216159369e+03,     1.056184491420182e+03, 
            1.056641495099654e+03,     1.057097235088252e+03,     1.057551719200844e+03,     1.058004955177687e+03,     1.058456950685385e+03, 
            1.058907713317841e+03,     1.059357250597189e+03,     1.059805569974716e+03,     1.060252678831759e+03,     1.060698584480600e+03, 
            1.061143294165338e+03,     1.061586815062750e+03,     1.062029154283136e+03,     1.062470318871156e+03,     1.062910315806649e+03, 
            1.063349152005439e+03,     1.063786834320130e+03,     1.064223369540891e+03,     1.064658764396222e+03,     1.065093025553713e+03, 
            1.065526159620792e+03,     1.065958173145462e+03,     1.066389072617015e+03,     1.066818864466753e+03,     1.067247555068687e+03, 
            1.067675150740229e+03,     1.068101657742867e+03,     1.068527082282840e+03,     1.068951430511794e+03,     1.069374708527437e+03, 
            1.069796922374172e+03,     1.070218078043733e+03,     1.070638181475804e+03,     1.071057238558629e+03,     1.071475255129619e+03, 
            1.071892236975940e+03,     1.072308189835104e+03,     1.072723119395540e+03,     1.073137031297166e+03,     1.073549931131947e+03, 
            1.073961824444446e+03,     1.074372716732368e+03,     1.074782613447097e+03,     1.075191519994221e+03,     1.075599441734057e+03, 
            1.076006383982157e+03,     1.076412352009821e+03,     1.076817351044589e+03,     1.077221386270737e+03,     1.077624462829759e+03, 
            1.078026585820844e+03,     1.078427760301348e+03,     1.078827991287258e+03,     1.079227283753649e+03,     1.079625642635136e+03, 
            1.080023072826317e+03,     1.080419579182215e+03,     1.080815166518708e+03,     1.081209839612958e+03,     1.081603603203829e+03, 
            1.081996461992305e+03,     1.082388420641897e+03,     1.082779483779050e+03,     1.083169655993537e+03,     1.083558941838855e+03, 
            1.083947345832614e+03,     1.084334872456915e+03,     1.084721526158732e+03,     1.085107311350278e+03,     1.085492232409382e+03, 
            1.085876293679840e+03,     1.086259499471780e+03,     1.086641854062016e+03,     1.087023361694389e+03,     1.087404026580114e+03, 
            1.087783852898125e+03,     1.088162844795400e+03,     1.088541006387294e+03,     1.088918341757871e+03,     1.089294854960219e+03, 
            1.089670550016767e+03,     1.090045430919606e+03,     1.090419501630788e+03,     1.090792766082642e+03,     1.091165228178066e+03, 
            1.091536891790829e+03,     1.091907760765870e+03,     1.092277838919575e+03,     1.092647130040077e+03,     1.093015637887531e+03, 
            1.093383366194393e+03,     1.093750318665702e+03,     1.094116498979345e+03,     1.094481910786330e+03,     1.094846557711050e+03, 
            1.095210443351546e+03,     1.095573571279766e+03,     1.095935945041819e+03,     1.096297568158228e+03,     1.096658444124184e+03, 
            1.097018576409784e+03,     1.097377968460281e+03,     1.097736623696323e+03,     1.098094545514188e+03,     1.098451737286023e+03, 
            1.098808202360069e+03,     1.099163944060896e+03,     1.099518965689629e+03,     1.099873270524166e+03,     1.100226861819405e+03, 
            1.100579742807456e+03,     1.100931916697863e+03,     1.101283386677812e+03,     1.101634155912343e+03,     1.101984227544561e+03, 
            1.102333604695832e+03,     1.102682290465998e+03,     1.103030287933571e+03,     1.103377600155929e+03,     1.103724230169519e+03, 
            1.104070180990046e+03,     1.104415455612662e+03,     1.104760057012164e+03,     1.105103988143170e+03,     1.105447251940312e+03, 
            1.105789851318415e+03,     1.106131789172680e+03,     1.106473068378858e+03,     1.106813691793431e+03,     1.107153662253784e+03, 
            1.107492982578379e+03,     1.107831655566924e+03,     1.108169684000542e+03,     1.108507070641940e+03,     1.108843818235568e+03, 
            1.109179929507788e+03,     1.109515407167032e+03,     1.109850253903961e+03,     1.110184472391624e+03,     1.110518065285612e+03, 
            1.110851035224215e+03,     1.111183384828570e+03,     1.111515116702815e+03,     1.111846233434236e+03,     1.112176737593415e+03, 
            1.112506631734377e+03,     1.112835918394729e+03,     1.113164600095811e+03,     1.113492679342829e+03,     1.113820158624997e+03, 
            1.114147040415677e+03,     1.114473327172513e+03,     1.114799021337565e+03,     1.115124125337448e+03,     1.115448641583454e+03, 
            1.115772572471693e+03,     1.116095920383216e+03,     1.116418687684144e+03,     1.116740876725796e+03,     1.117062489844811e+03, 
            1.117383529363277e+03,     1.117703997588846e+03,     1.118023896814860e+03,     1.118343229320473e+03,     1.118661997370762e+03, 
            1.118980203216854e+03,     1.119297849096031e+03,     1.119614937231855e+03,     1.119931469834278e+03,     1.120247449099750e+03, 
            1.120562877211338e+03,     1.120877756338831e+03,     1.121192088638851e+03,     1.121505876254959e+03,     1.121819121317765e+03, 
            1.122131825945030e+03,     1.122443992241775e+03,     1.122755622300379e+03,     1.123066718200687e+03,     1.123377282010106e+03
    },
    {
            1.752151595249030e+00,     5.310576708961479e+00,     8.939286685930458e+00,     1.264185784979388e+01,     1.642216612703141e+01, 
            2.028442213134758e+01,     2.423321162623926e+01,     2.827354240977861e+01,     3.241089889574578e+01,     3.665130598952069e+01, 
            4.100140425429152e+01,     4.546853889051982e+01,     5.006086574256448e+01,     5.478747846479953e+01,     5.965856221342283e+01, 
            6.468558090758624e+01,     6.988150741347283e+01,     7.526110923084227e+01,     8.084130683578897e+01,     8.664162842892938e+01, 
            9.268479452480842e+01,     9.899748033754179e+01,     1.056113261799848e+02,     1.125643011074883e+02,     1.199025817109082e+02, 
            1.276832027710100e+02,     1.359779009539106e+02,     1.448788717605991e+02,     1.545077301717740e+02,     1.650301266692799e+02, 
            1.766810181651675e+02,     1.898117533938873e+02,     2.049870293838429e+02,     2.232149833664427e+02,     2.466287684122663e+02, 
            2.815620133424054e+02,     5.995738803772653e+02,     6.482348374912827e+02,     6.714953845708193e+02,     6.878582028441725e+02, 
            7.007402267612213e+02,     7.114827466935383e+02,     7.207629954784776e+02,     7.289736450064456e+02,     7.363638177521437e+02, 
            7.431020367651270e+02,     7.493079570581957e+02,     7.550698244871481e+02,     7.604547446661231e+02,     7.655150508280641e+02, 
            7.702924266043564e+02,     7.748206730229595e+02,     7.791276231767439e+02,     7.832365024340608e+02,     7.871669171717558e+02, 
            7.909355881344115e+02,     7.945569042037745e+02,     7.980433472952167e+02,     8.014058230855535e+02,     8.046539217980584e+02, 
            8.077961262633418e+02,     8.108399796964198e+02,     8.137922223132219e+02,     8.166589035696607e+02,     8.194454751303415e+02, 
            8.221568684572774e+02,     8.247975600141514e+02,     8.273716264159607e+02,     8.298827913529724e+02,     8.323344657373447e+02, 
            8.347297822286014e+02,     8.370716250680327e+02,     8.393626559755089e+02,     8.416053367232145e+02,     8.438019488906009e+02, 
            8.459546112169231e+02,     8.480652948969433e+02,     8.501358371082313e+02,     8.521679530119326e+02,     8.541632464307946e+02, 
            8.561232193769337e+02,     8.580492805759203e+02,     8.599427531122512e+02,     8.618048813033446e+02,     8.636368368941324e+02, 
            8.654397246516863e+02,     8.672145874285984e+02,     8.689624107547980e+02,     8.706841270097390e+02,     8.723806192203244e+02, 
            8.740527245242755e+02,     8.757012373338115e+02,     8.773269122303121e+02,     8.789304666170260e+02,     8.805125831537521e+02, 
            8.820739119946974e+02,     8.836150728483375e+02,     8.851366568760329e+02,     8.866392284443465e+02,     8.881233267443969e+02, 
            8.895894672901966e+02,     8.910381433066851e+02,     8.924698270170685e+02,     8.938849708381160e+02,     8.952840084912157e+02, 
            8.966673560362185e+02,     8.980354128344266e+02,     8.993885624464893e+02,     9.007271734704171e+02,     9.020516003244487e+02, 
            9.033621839790742e+02,     9.046592526421393e+02,     9.059431224005864e+02,     9.072140978220993e+02,     9.084724725196181e+02, 
            9.097185296814555e+02,     9.109525425694865e+02,     9.121747749877117e+02,     9.133854817232833e+02,     9.145849089619063e+02, 
            9.157732946794030e+02,     9.169508690110516e+02,     9.181178546002043e+02,     9.192744669275755e+02,     9.204209146327736e+02, 
            9.215573998456358e+02,     9.226841184286722e+02,     9.238012595054696e+02,     9.249090079122641e+02,     9.260075418316553e+02, 
            9.270970344466658e+02,     9.281776538504943e+02,     9.292495632490966e+02,     9.303129209931139e+02,     9.313678814202761e+02, 
            9.324145940122236e+02,     9.334532042597446e+02,     9.344838536380889e+02,     9.355066797587625e+02,     9.365218165123634e+02, 
            9.375293942051247e+02,     9.385295396891609e+02,     9.395223764867756e+02,     9.405080249091548e+02,     9.414866021697404e+02, 
            9.424582224925858e+02,     9.434229972159346e+02,     9.443810348912988e+02,     9.453324413782592e+02,     9.462773199352029e+02, 
            9.472157713062252e+02,     9.481478938043692e+02,     9.490737833914017e+02,     9.499935337542930e+02,     9.509072363785687e+02, 
            9.518149806186731e+02,     9.527168537794822e+02,     9.536129411239372e+02,     9.545033260232526e+02,     9.553880899566021e+02, 
            9.562673125840644e+02,     9.571410718019014e+02,     9.580094437743473e+02,     9.588725030718135e+02,     9.597303225869957e+02, 
            9.605829736727463e+02,     9.614305261645918e+02,     9.622730484246674e+02,     9.631106073840409e+02,     9.639432685835087e+02, 
            9.647710962129196e+02,     9.655941531490948e+02,     9.664125009924024e+02,     9.672262001020511e+02,     9.680353096301424e+02, 
            9.688398875545524e+02,     9.696399907106735e+02,     9.704356748220799e+02,     9.712269945301434e+02,     9.720140034226647e+02, 
            9.727967540615350e+02,     9.735752980094890e+02,     9.743496858559685e+02,     9.751199672421488e+02,     9.758861908851427e+02, 
            9.766484046014285e+02,     9.774066553295224e+02,     9.781609891519379e+02,     9.789114513164403e+02,     9.796580862566409e+02, 
            9.804009376119441e+02,     9.811400482695421e+02,     9.818754602913669e+02,     9.826072150716941e+02,     9.833353532605724e+02, 
            9.840599148047619e+02,     9.847809389643065e+02,     9.854984643286029e+02,     9.862125288319992e+02,     9.869231697689330e+02, 
            9.876304238086273e+02,     9.883343270093585e+02,     9.890349148323127e+02,     9.897322221550444e+02,     9.904262832845516e+02, 
            9.911171319699787e+02,     9.918048014149656e+02,     9.924893242896430e+02,     9.931707327423045e+02,     9.938490584107434e+02, 
            9.945243324332923e+02,     9.951965854595436e+02,     9.958658476607920e+02,     9.965321487401919e+02,     9.971955179426353e+02, 
            9.978559840643745e+02,     9.985135754623838e+02,     9.991683200634728e+02,     9.998202453731683e+02,     1.000469378484354e+03, 
            1.001115746085691e+03,     1.001759374469823e+03,     1.002400289541367e+03,     1.003038516824697e+03,     1.003674081471541e+03, 
            1.004307008268375e+03,     1.004937321643632e+03,     1.005565045674742e+03,     1.006190203608581e+03,     1.006812819795768e+03, 
            1.007432916832367e+03,     1.008050517458675e+03,     1.008665644096623e+03,     1.009278318855832e+03,     1.009888563539524e+03, 
            1.010496399650298e+03,     1.011101848395760e+03,     1.011704930694022e+03,     1.012305667179071e+03,     1.012904078206018e+03, 
            1.013500183856215e+03,     1.014094003942254e+03,     1.014685558012863e+03,     1.015274865357673e+03,     1.015861945011882e+03, 
            1.016446815760822e+03,     1.017029496144403e+03,     1.017610004461476e+03,     1.018188358774089e+03,     1.018764576911642e+03, 
            1.019338676474966e+03,     1.019910674840296e+03,     1.020480589163164e+03,     1.021048436382207e+03,     1.021614233222886e+03, 
            1.022177996201132e+03,     1.022739741626911e+03,     1.023299485607707e+03,     1.023857244051933e+03,     1.024413032672279e+03, 
            1.024966866988970e+03,     1.025518762332975e+03,     1.026068733849131e+03,     1.026616796499217e+03,     1.027162965064952e+03, 
            1.027707254150939e+03,     1.028249678187539e+03,     1.028790251433698e+03,     1.029328987979709e+03,     1.029865901749915e+03, 
            1.030401006505362e+03,     1.030934315846398e+03,     1.031465843215220e+03,     1.031995601898364e+03,     1.032523605029154e+03, 
            1.033049865590100e+03,     1.033574396415238e+03,     1.034097210192447e+03,     1.034618319465692e+03,     1.035137736637250e+03, 
            1.035655473969869e+03,     1.036171543588907e+03,     1.036685957484412e+03,     1.037198727513171e+03,     1.037709865400720e+03, 
            1.038219382743316e+03,     1.038727291009860e+03,     1.039233601543806e+03,     1.039738325565008e+03,     1.040241474171557e+03, 
            1.040743058341566e+03,     1.041243088934928e+03,     1.041741576695045e+03,     1.042238532250518e+03,     1.042733966116812e+03, 
            1.043227888697888e+03,     1.043720310287804e+03,     1.044211241072286e+03,     1.044700691130282e+03,     1.045188670435466e+03, 
            1.045675188857739e+03,     1.046160256164685e+03,     1.046643882023011e+03,     1.047126075999959e+03,     1.047606847564690e+03, 
            1.048086206089648e+03,     1.048564160851900e+03,     1.049040721034447e+03,     1.049515895727516e+03,     1.049989693929835e+03, 
            1.050462124549875e+03,     1.050933196407077e+03,     1.051402918233060e+03,     1.051871298672803e+03,     1.052338346285808e+03, 
            1.052804069547248e+03,     1.053268476849091e+03,     1.053731576501203e+03,     1.054193376732441e+03,     1.054653885691718e+03, 
            1.055113111449056e+03,     1.055571061996622e+03,     1.056027745249742e+03,     1.056483169047903e+03,     1.056937341155736e+03, 
            1.057390269263984e+03,     1.057841960990456e+03,     1.058292423880957e+03,     1.058741665410218e+03,     1.059189692982793e+03, 
            1.059636513933961e+03,     1.060082135530594e+03,     1.060526564972025e+03,     1.060969809390899e+03,     1.061411875854003e+03, 
            1.061852771363098e+03,     1.062292502855719e+03,     1.062731077205981e+03,     1.063168501225360e+03,     1.063604781663460e+03, 
            1.064039925208784e+03,     1.064473938489475e+03,     1.064906828074056e+03,     1.065338600472154e+03,     1.065769262135216e+03, 
            1.066198819457212e+03,     1.066627278775330e+03,     1.067054646370651e+03,     1.067480928468831e+03,     1.067906131240757e+03, 
            1.068330260803197e+03,     1.068753323219449e+03,     1.069175324499965e+03,     1.069596270602982e+03,     1.070016167435129e+03, 
            1.070435020852037e+03,     1.070852836658928e+03,     1.071269620611212e+03,     1.071685378415055e+03,     1.072100115727955e+03, 
            1.072513838159299e+03,     1.072926551270923e+03,     1.073338260577650e+03,     1.073748971547832e+03,     1.074158689603878e+03, 
            1.074567420122776e+03,     1.074975168436607e+03,     1.075381939833054e+03,     1.075787739555902e+03,     1.076192572805526e+03, 
            1.076596444739384e+03,     1.076999360472492e+03,     1.077401325077896e+03,     1.077802343587139e+03,     1.078202420990719e+03, 
            1.078601562238544e+03,     1.078999772240373e+03,     1.079397055866265e+03,     1.079793417947005e+03,     1.080188863274535e+03, 
            1.080583396602378e+03,     1.080977022646052e+03,     1.081369746083481e+03,     1.081761571555403e+03,     1.082152503665767e+03, 
            1.082542546982124e+03,     1.082931706036026e+03,     1.083319985323398e+03,     1.083707389304926e+03,     1.084093922406422e+03, 
            1.084479589019200e+03,     1.084864393500437e+03,     1.085248340173527e+03,     1.085631433328444e+03,     1.086013677222081e+03, 
            1.086395076078605e+03,     1.086775634089789e+03,     1.087155355415351e+03,     1.087534244183286e+03,     1.087912304490192e+03, 
            1.088289540401592e+03,     1.088665955952255e+03,     1.089041555146507e+03,     1.089416341958545e+03,     1.089790320332738e+03, 
            1.090163494183938e+03,     1.090535867397771e+03,     1.090907443830934e+03,     1.091278227311487e+03,     1.091648221639140e+03, 
            1.092017430585536e+03,     1.092385857894534e+03,     1.092753507282480e+03,     1.093120382438485e+03,     1.093486487024692e+03, 
            1.093851824676545e+03,     1.094216399003051e+03,     1.094580213587037e+03,     1.094943271985411e+03,     1.095305577729411e+03, 
            1.095667134324859e+03,     1.096027945252405e+03,     1.096388013967776e+03,     1.096747343902012e+03,     1.097105938461705e+03, 
            1.097463801029237e+03,     1.097820934963011e+03,     1.098177343597680e+03,     1.098533030244374e+03,     1.098887998190927e+03, 
            1.099242250702093e+03,     1.099595791019771e+03,     1.099948622363216e+03,     1.100300747929256e+03,     1.100652170892499e+03, 
            1.101002894405549e+03,     1.101352921599204e+03,     1.101702255582665e+03,     1.102050899443734e+03,     1.102398856249015e+03, 
            1.102746129044110e+03,     1.103092720853814e+03,     1.103438634682305e+03,     1.103783873513335e+03,     1.104128440310418e+03, 
            1.104472338017016e+03,     1.104815569556719e+03,     1.105158137833431e+03,     1.105500045731544e+03,     1.105841296116120e+03, 
            1.106181891833061e+03,     1.106521835709287e+03,     1.106861130552903e+03,     1.107199779153370e+03,     1.107537784281672e+03, 
            1.107875148690481e+03,     1.108211875114321e+03,     1.108547966269728e+03,     1.108883424855414e+03,     1.109218253552417e+03, 
            1.109552455024266e+03,     1.109886031917132e+03,     1.110218986859976e+03,     1.110551322464710e+03,     1.110883041326336e+03, 
            1.111214146023103e+03,     1.111544639116646e+03,     1.111874523152132e+03,     1.112203800658409e+03,     1.112532474148139e+03, 
            1.112860546117940e+03,     1.113188019048531e+03,     1.113514895404858e+03,     1.113841177636238e+03,     1.114166868176490e+03, 
            1.114491969444064e+03,     1.114816483842180e+03,     1.115140413758947e+03,     1.115463761567501e+03,     1.115786529626127e+03, 
            1.116108720278385e+03,     1.116430335853233e+03,     1.116751378665152e+03,     1.117071851014269e+03,     1.117391755186470e+03, 
            1.117711093453528e+03,     1.118029868073216e+03,     1.118348081289422e+03,     1.118665735332268e+03,     1.118982832418221e+03, 
            1.119299374750210e+03,     1.119615364517732e+03,     1.119930803896967e+03,     1.120245695050883e+03,     1.120560040129352e+03, 
            1.120873841269248e+03,     1.121187100594560e+03,     1.121499820216491e+03,     1.121812002233568e+03,     1.122123648731740e+03
    },
    {
            1.748623201668550e+00,     5.299540858586566e+00,     8.920104210180194e+00,     1.261382635627175e+01,     1.638451190515116e+01, 
            2.023629074812685e+01,     2.417365695226619e+01,     2.820151375298441e+01,     3.232522584135312e+01,     3.655068044147777e+01, 
            4.088435903950874e+01,     4.533342211086271e+01,     4.990580982528963e+01,     5.461036254762016e+01,     5.945696607334941e+01, 
            6.445672805565911e+01,     6.962219415971914e+01,     7.496761536788651e+01,     8.050928192961918e+01,     8.626594527978051e+01, 
            9.225935774825815e+01,     9.851497251903247e+01,     1.050628654923806e+02,     1.119389705811435e+02,     1.191867677605310e+02, 
            1.268596420512199e+02,     1.350242662630219e+02,     1.437656006437251e+02,     1.531945507020332e+02,     1.634602128462898e+02, 
            1.747705221847703e+02,     1.874294818914880e+02,     2.019104591650824e+02,     2.190190806869659e+02,     2.403267609236407e+02, 
            2.697388662988934e+02,     3.255543835528801e+02,     6.180298842708537e+02,     6.523268922251602e+02,     6.729449201055786e+02, 
            6.881944622813097e+02,     7.004761906069331e+02,     7.108510320213039e+02,     7.198875735496561e+02,     7.279277896871253e+02, 
            7.351941144837484e+02,     7.418397598153917e+02,     7.479750059937371e+02,     7.536820571221539e+02,     7.590239600850376e+02, 
            7.640502264411285e+02,     7.688005209401956e+02,     7.733071644516061e+02,     7.775968819790629e+02,     7.816920542661722e+02, 
            7.856116337404585e+02,     7.893718278668896e+02,     7.929866178012201e+02,     7.964681581384758e+02,     7.998270893120999e+02, 
            8.030727848074692e+02,     8.062135490292168e+02,     8.092567773222330e+02,     8.122090866171405e+02,     8.150764230231000e+02, 
            8.178641511457831e+02,     8.205771287818673e+02,     8.232197698100468e+02,     8.257960974778398e+02,     8.283097898150738e+02, 
            8.307642185478737e+02,     8.331624826123331e+02,     8.355074371538242e+02,     8.378017187310497e+02,     8.400477673123788e+02, 
            8.422478455474351e+02,     8.444040557132898e+02,     8.465183546672883e+02,     8.485925670839433e+02,     8.506283972089103e+02, 
            8.526274393266223e+02,     8.545911871081339e+02,     8.565210419809107e+02,     8.584183206416312e+02,     8.602842618157977e+02, 
            8.621200323534858e+02,     8.639267327383519e+02,     8.657054020766906e+02,     8.674570226246060e+02,     8.691825239038411e+02, 
            8.708827864505054e+02,     8.725586452353937e+02,     8.742108927899540e+02,     8.758402820678363e+02,     8.774475290685069e+02, 
            8.790333152463064e+02,     8.805982897257277e+02,     8.821430713413345e+02,     8.836682505187628e+02,     8.851743910114441e+02, 
            8.866620315061438e+02,     8.881316871090532e+02,     8.895838507229436e+02,     8.910189943248430e+02,     8.924375701527407e+02, 
            8.938400118089875e+02,     8.952267352873278e+02,     8.965981399298111e+02,     8.979546093192675e+02,     8.992965121124819e+02, 
            9.006242028187387e+02,     9.019380225279873e+02,     9.032382995924891e+02,     9.045253502654754e+02,     9.057994793000244e+02, 
            9.070609805111097e+02,     9.083101373034972e+02,     9.095472231679636e+02,     9.107725021480782e+02,     9.119862292796450e+02, 
            9.131886510046837e+02,     9.143800055617235e+02,     9.155605233539990e+02,     9.167304272970575e+02,     9.178899331498077e+02, 
            9.190392498610933e+02,     9.201785798519622e+02,     9.213081192636686e+02,     9.224280570875808e+02,     9.235385790581001e+02, 
            9.246398633931385e+02,     9.257320835560935e+02,     9.268154079193696e+02,     9.278899997986114e+02,     9.289560183350796e+02, 
            9.300136176141405e+02,     9.310629475695456e+02,     9.321041539595892e+02,     9.331373785282244e+02,     9.341627591503080e+02, 
            9.351804299776510e+02,     9.361905215747694e+02,     9.371931610490433e+02,     9.381884721749540e+02,     9.391765755127210e+02, 
            9.401575885216290e+02,     9.411316256683454e+02,     9.420987985304732e+02,     9.430592158956158e+02,     9.440129838561605e+02, 
            9.449602059000197e+02,     9.459009829975306e+02,     9.468354136847025e+02,     9.477635941430104e+02,     9.486856182758892e+02, 
            9.496015777821032e+02,     9.505115622261438e+02,     9.514156591188517e+02,     9.523139539287935e+02,     9.532065302268080e+02, 
            9.540934696896151e+02,     9.549748521499888e+02,     9.558507557409541e+02,     9.567212568130778e+02,     9.575864300780707e+02, 
            9.584463486344478e+02,     9.593010840149451e+02,     9.601507062321677e+02,     9.609952838225653e+02,     9.618348838888057e+02, 
            9.626695721406023e+02,     9.634994129340857e+02,     9.643244693097629e+02,     9.651448030291396e+02,     9.659604746100468e+02, 
            9.667715433607418e+02,     9.675780674128275e+02,     9.683801037530370e+02,     9.691777082539351e+02,     9.699709357035839e+02, 
            9.707598398342019e+02,     9.715444733498749e+02,     9.723248879533394e+02,     9.731011343718940e+02,     9.738732623824535e+02, 
            9.746413208357978e+02,     9.754053576800306e+02,     9.761654199832947e+02,     9.769215539557622e+02,     9.776738049926945e+02, 
            9.784222176068836e+02,     9.791668355826361e+02,     9.799077019046156e+02,     9.806448587995479e+02,     9.813783477544179e+02, 
            9.821082095341120e+02,     9.828344841985280e+02,     9.835572111191739e+02,     9.842764289952677e+02,     9.849921758693654e+02, 
            9.857044891425304e+02,     9.864134055890552e+02,     9.871189613707560e+02,     9.878211920508587e+02,     9.885201326074840e+02, 
            9.892158174467460e+02,     9.899082804154862e+02,     9.905975548136415e+02,     9.912836734062689e+02,     9.919666684352381e+02, 
            9.926465716305988e+02,     9.933234142216318e+02,     9.939972269476035e+02,     9.946680400682278e+02,     9.953358833738407e+02, 
            9.960007861953064e+02,     9.966627774136548e+02,     9.973218854694684e+02,     9.979781383720169e+02,     9.986315637081519e+02, 
            9.992821886509736e+02,     9.999300399682669e+02,     1.000575144030725e+03,     1.001217526819959e+03,     1.001857213936303e+03, 
            1.002494230606421e+03,     1.003128601690723e+03,     1.003760351690596e+03,     1.004389504270583e+03,     1.005016084186663e+03, 
            1.005640114437523e+03,     1.006261618157209e+03,     1.006880618154282e+03,     1.007497136918047e+03,     1.008111196624625e+03, 
            1.008722819142876e+03,     1.009332026040188e+03,     1.009938838588124e+03,     1.010543277767933e+03,     1.011145364275933e+03, 
            1.011745118528772e+03,     1.012342560668558e+03,     1.012937710567873e+03,     1.013530587834678e+03,     1.014121211817092e+03, 
            1.014709601608075e+03,     1.015295776049994e+03,     1.015879753739090e+03,     1.016461553029850e+03,     1.017041192039263e+03, 
            1.017618688651005e+03,     1.018194060519512e+03,     1.018767325073972e+03,     1.019338499522224e+03,     1.019907600854578e+03, 
            1.020474645847547e+03,     1.021039651067496e+03,     1.021602632874219e+03,     1.022163607424435e+03,     1.022722590675205e+03, 
            1.023279598387287e+03,     1.023834646128406e+03,     1.024387749276471e+03,     1.024938923022706e+03,     1.025488182374735e+03, 
            1.026035542159586e+03,     1.026581017026640e+03,     1.027124621450523e+03,     1.027666369733932e+03,     1.028206276010401e+03, 
            1.028744354247023e+03,     1.029280618247106e+03,     1.029815081652772e+03,     1.030347757947520e+03,     1.030878660458719e+03, 
            1.031407802360067e+03,     1.031935196673989e+03,     1.032460856273993e+03,     1.032984793886981e+03,     1.033507022095512e+03, 
            1.034027553340026e+03,     1.034546399921011e+03,     1.035063574001146e+03,     1.035579087607392e+03,     1.036092952633044e+03, 
            1.036605180839744e+03,     1.037115783859459e+03,     1.037624773196420e+03,     1.038132160229018e+03,     1.038637956211676e+03, 
            1.039142172276673e+03,     1.039644819435948e+03,     1.040145908582859e+03,     1.040645450493909e+03,     1.041143455830457e+03, 
            1.041639935140372e+03,     1.042134898859679e+03,     1.042628357314158e+03,     1.043120320720933e+03,     1.043610799190011e+03, 
            1.044099802725807e+03,     1.044587341228638e+03,     1.045073424496194e+03,     1.045558062224972e+03,     1.046041264011698e+03, 
            1.046523039354714e+03,     1.047003397655347e+03,     1.047482348219247e+03,     1.047959900257711e+03,     1.048436062888975e+03, 
            1.048910845139490e+03,     1.049384255945168e+03,     1.049856304152618e+03,     1.050326998520354e+03,     1.050796347719977e+03, 
            1.051264360337351e+03,     1.051731044873743e+03,     1.052196409746959e+03,     1.052660463292447e+03,     1.053123213764392e+03, 
            1.053584669336788e+03,     1.054044838104490e+03,     1.054503728084257e+03,     1.054961347215764e+03,     1.055417703362613e+03, 
            1.055872804313316e+03,     1.056326657782264e+03,     1.056779271410686e+03,     1.057230652767586e+03,     1.057680809350664e+03, 
            1.058129748587233e+03,     1.058577477835105e+03,     1.059024004383475e+03,     1.059469335453787e+03,     1.059913478200588e+03, 
            1.060356439712360e+03,     1.060798227012355e+03,     1.061238847059400e+03,     1.061678306748696e+03,     1.062116612912615e+03, 
            1.062553772321462e+03,     1.062989791684247e+03,     1.063424677649430e+03,     1.063858436805665e+03,     1.064291075682524e+03, 
            1.064722600751218e+03,     1.065153018425298e+03,     1.065582335061353e+03,     1.066010556959694e+03,     1.066437690365027e+03, 
            1.066863741467118e+03,     1.067288716401446e+03,     1.067712621249848e+03,     1.068135462041153e+03,     1.068557244751804e+03, 
            1.068977975306482e+03,     1.069397659578700e+03,     1.069816303391411e+03,     1.070233912517595e+03,     1.070650492680832e+03, 
            1.071066049555882e+03,     1.071480588769245e+03,     1.071894115899714e+03,     1.072306636478926e+03,     1.072718155991898e+03, 
            1.073128679877558e+03,     1.073538213529272e+03,     1.073946762295357e+03,     1.074354331479592e+03,     1.074760926341716e+03, 
            1.075166552097926e+03,     1.075571213921364e+03,     1.075974916942595e+03,     1.076377666250083e+03,     1.076779466890658e+03, 
            1.077180323869976e+03,     1.077580242152972e+03,     1.077979226664310e+03,     1.078377282288823e+03,     1.078774413871949e+03, 
            1.079170626220163e+03,     1.079565924101394e+03,     1.079960312245449e+03,     1.080353795344424e+03,     1.080746378053108e+03, 
            1.081138064989386e+03,     1.081528860734632e+03,     1.081918769834104e+03,     1.082307796797324e+03,     1.082695946098461e+03, 
            1.083083222176702e+03,     1.083469629436626e+03,     1.083855172248565e+03,     1.084239854948966e+03,     1.084623681840745e+03, 
            1.085006657193638e+03,     1.085388785244549e+03,     1.085770070197885e+03,     1.086150516225898e+03,     1.086530127469017e+03, 
            1.086908908036175e+03,     1.087286862005130e+03,     1.087663993422791e+03,     1.088040306305526e+03,     1.088415804639482e+03, 
            1.088790492380883e+03,     1.089164373456339e+03,     1.089537451763146e+03,     1.089909731169579e+03,     1.090281215515184e+03, 
            1.090651908611070e+03,     1.091021814240190e+03,     1.091390936157621e+03,     1.091759278090847e+03,     1.092126843740026e+03, 
            1.092493636778268e+03,     1.092859660851894e+03,     1.093224919580709e+03,     1.093589416558252e+03,     1.093953155352065e+03, 
            1.094316139503937e+03,     1.094678372530161e+03,     1.095039857921782e+03,     1.095400599144837e+03,     1.095760599640602e+03, 
            1.096119862825830e+03,     1.096478392092985e+03,     1.096836190810477e+03,     1.097193262322891e+03,     1.097549609951217e+03, 
            1.097905236993072e+03,     1.098260146722925e+03,     1.098614342392314e+03,     1.098967827230063e+03,     1.099320604442501e+03, 
            1.099672677213665e+03,     1.100024048705517e+03,     1.100374722058149e+03,     1.100724700389983e+03,     1.101073986797979e+03, 
            1.101422584357832e+03,     1.101770496124165e+03,     1.102117725130733e+03,     1.102464274390608e+03,     1.102810146896371e+03, 
            1.103155345620304e+03,     1.103499873514570e+03,     1.103843733511402e+03,     1.104186928523281e+03,     1.104529461443119e+03, 
            1.104871335144436e+03,     1.105212552481528e+03,     1.105553116289657e+03,     1.105893029385204e+03,     1.106232294565852e+03, 
            1.106570914610747e+03,     1.106908892280668e+03,     1.107246230318186e+03,     1.107582931447831e+03,     1.107918998376248e+03, 
            1.108254433792360e+03,     1.108589240367521e+03,     1.108923420755673e+03,     1.109256977593498e+03,     1.109589913500570e+03, 
            1.109922231079507e+03,     1.110253932916114e+03,     1.110585021579536e+03,     1.110915499622398e+03,     1.111245369580951e+03, 
            1.111574633975213e+03,     1.111903295309109e+03,     1.112231356070610e+03,     1.112558818731871e+03,     1.112885685749366e+03, 
            1.113211959564022e+03,     1.113537642601353e+03,     1.113862737271589e+03,     1.114187245969809e+03,     1.114511171076068e+03, 
            1.114834514955525e+03,     1.115157279958567e+03,     1.115479468420937e+03,     1.115801082663852e+03,     1.116122124994132e+03, 
            1.116442597704312e+03,     1.116762503072770e+03,     1.117081843363839e+03,     1.117400620827927e+03,     1.117718837701630e+03, 
            1.118036496207850e+03,     1.118353598555904e+03,     1.118670146941639e+03,     1.118986143547543e+03,     1.119301590542853e+03, 
            1.119616490083665e+03,     1.119930844313040e+03,     1.120244655361111e+03,     1.120557925345191e+03,     1.120870656369870e+03
    },
    {
            1.745109224579966e+00,     5.288553034915556e+00,     8.901010583656076e+00,     1.258593297232952e+01,     1.634705494849518e+01, 
            2.018842742104769e+01,     2.411445484652569e+01,     2.812993840949162e+01,     3.224012611758943e+01,     3.645077121036210e+01, 
            4.076820061862401e+01,     4.519939565730064e+01,     4.975208771477023e+01,     5.443487246690918e+01,     5.925734716341152e+01, 
            6.423027690720932e+01,     6.936579772025412e+01,     7.467766677553361e+01,     8.018157379948624e+01,     8.589553280653109e+01, 
            9.184038079265345e+01,     9.804042102451187e+01,     1.045242651371121e+02,     1.113259537947721e+02,     1.184864760582718e+02, 
            1.260558733805358e+02,     1.340962247712221e+02,     1.426860036474260e+02,     1.519266510186160e+02,     1.619528942097140e+02, 
            1.729497479495420e+02,     1.851822689253741e+02,     1.990518447927907e+02,     2.152144254460431e+02,     2.348689374796233e+02, 
            2.606485013462718e+02,     3.009809251492988e+02,     5.536202311924269e+02,     6.276381475713421e+02,     6.554922892336072e+02, 
            6.741351702165898e+02,     6.884459375054051e+02,     7.001916496133907e+02,     7.102267773917607e+02,     7.190328835709494e+02, 
            7.269091777689058e+02,     7.340547729988160e+02,     7.406091545391577e+02,     7.466740332013651e+02,     7.523260054290430e+02, 
            7.576243044467806e+02,     7.626157635300281e+02,     7.673381147258688e+02,     7.718222515052387e+02,     7.760938234052212e+02, 
            7.801743867172587e+02,     7.840822522342581e+02,     7.878331214171272e+02,     7.914405717033881e+02,     7.949164322435422e+02, 
            7.982710787123730e+02,     8.015136674409401e+02,     8.046523234179458e+02,     8.076942927754961e+02,     8.106460676129608e+02, 
            8.135134890447977e+02,     8.163018329361028e+02,     8.190158817485272e+02,     8.216599851479938e+02,     8.242381114477012e+02, 
            8.267538915225425e+02,     8.292106564966259e+02,     8.316114702476340e+02,     8.339591575710296e+02,     8.362563286896827e+02, 
            8.385054006700369e+02,     8.407086162068654e+02,     8.428680601592979e+02,     8.449856741567299e+02,     8.470632695412415e+02, 
            8.491025388707840e+02,     8.511050661725226e+02,     8.530723361070385e+02,     8.550057421803026e+02,     8.569065941204674e+02, 
            8.587761245199854e+02,     8.606154948295945e+02,     8.624258007790069e+02,     8.642080772891295e+02,     8.659633029322515e+02, 
            8.676924039893737e+02,     8.693962581477389e+02,     8.710756978762705e+02,     8.727315135121246e+02,     8.743644560875720e+02, 
            8.759752399230641e+02,     8.775645450093519e+02,     8.791330191989491e+02,     8.806812802249830e+02,     8.822099175635393e+02, 
            8.837194941538287e+02,     8.852105479890256e+02,     8.866835935892923e+02,     8.881391233673024e+02,     8.895776088955566e+02, 
            8.909995020838450e+02,     8.924052362744022e+02,     8.937952272615724e+02,     8.951698742421300e+02,     8.965295607018687e+02, 
            8.978746552434903e+02,     8.992055123604318e+02,     9.005224731607806e+02,     9.018258660451289e+02,     9.031160073418141e+02, 
            9.043932019027319e+02,     9.056577436626353e+02,     9.069099161645544e+02,     9.081499930537906e+02,     9.093782385427031e+02, 
            9.105949078483505e+02,     9.118002476048547e+02,     9.129944962522363e+02,     9.141778844033084e+02,     9.153506351903312e+02, 
            9.165129646155393e+02,     9.176650818792795e+02,     9.188071896323590e+02,     9.199394833465843e+02,     9.210621544088920e+02, 
            9.221753869448395e+02,     9.232793599622510e+02,     9.243742471658948e+02,     9.254602169946028e+02,     9.265374335436298e+02, 
            9.276060556453264e+02,     9.286662378143249e+02,     9.297181302244180e+02,     9.307618788737713e+02,     9.317976257405734e+02, 
            9.328255089391085e+02,     9.338456628541378e+02,     9.348582182824451e+02,     9.358633025616424e+02,     9.368610396942856e+02, 
            9.378515504664113e+02,     9.388349525607738e+02,     9.398113606650905e+02,     9.407808865755346e+02,     9.417436392957418e+02, 
            9.426997251315551e+02,     9.436492477817311e+02,     9.445923084248107e+02,     9.455290058023509e+02,     9.464594362986998e+02, 
            9.473836940174878e+02,     9.483018708549924e+02,     9.492140565840044e+02,     9.501203388662274e+02,     9.510208034019778e+02, 
            9.519155339122376e+02,     9.528046123041045e+02,     9.536881185896808e+02,     9.545661310357258e+02,     9.554387261927943e+02, 
            9.563059789464435e+02,     9.571679625665123e+02,     9.580247487545544e+02,     9.588764076895220e+02,     9.597230080717711e+02, 
            9.605646171654537e+02,     9.614013008393919e+02,     9.622331236064690e+02,     9.630601486616258e+02,     9.638824379185099e+02, 
            9.647000520448394e+02,     9.655130504965362e+02,     9.663214915506726e+02,     9.671254323372934e+02,     9.679249288701511e+02, 
            9.687200360763952e+02,     9.695108078252774e+02,     9.702972969558792e+02,     9.710795553039450e+02,     9.718576337278070e+02, 
            9.726315821334846e+02,     9.734014495210099e+02,     9.741672839185759e+02,     9.749291325410641e+02,     9.756870417203174e+02, 
            9.764410569497234e+02,     9.771912229048626e+02,     9.779375834635257e+02,     9.786801817251086e+02,     9.794190600294022e+02, 
            9.801542599748240e+02,     9.808858224360800e+02,     9.816137875813095e+02,     9.823381948887029e+02,     9.830590831626349e+02, 
            9.837764905493167e+02,     9.844904545519871e+02,     9.852010120456619e+02,     9.859081992914541e+02,     9.866120519504842e+02, 
            9.873126050973868e+02,     9.880098932334353e+02,     9.887039502992968e+02,     9.893948096874233e+02,     9.900825042541011e+02, 
            9.907670663311604e+02,     9.914485277373682e+02,     9.921269197894987e+02,     9.928022733131095e+02,     9.934746186530208e+02, 
            9.941439856835150e+02,     9.948104038182572e+02,     9.954739020199570e+02,     9.961345088097688e+02,     9.967922522764478e+02, 
            9.974471600852652e+02,     9.980992594866857e+02,     9.987485773248301e+02,     9.993951400457096e+02,     1.000038973705253e+03, 
            1.000680103977131e+03,     1.001318556160376e+03,     1.001954355186819e+03,     1.002587525145138e+03,     1.003218091202577e+03, 
            1.003846076766605e+03,     1.004471505370897e+03,     1.005094400216393e+03,     1.005714784177689e+03,     1.006332679809276e+03, 
            1.006948109351625e+03,     1.007561094737131e+03,     1.008171657595907e+03,     1.008779819261447e+03,     1.009385600776149e+03, 
            1.009989022896714e+03,     1.010590106099414e+03,     1.011188870585234e+03,     1.011785336284905e+03,     1.012379522863813e+03, 
            1.012971449726791e+03,     1.013561136022814e+03,     1.014148600649579e+03,     1.014733862257977e+03,     1.015316939256476e+03, 
            1.015897849815395e+03,     1.016476611871091e+03,     1.017053243130043e+03,     1.017627761072855e+03,     1.018200182958169e+03, 
            1.018770525826488e+03,     1.019338806503917e+03,     1.019905041605828e+03,     1.020469247540441e+03,     1.021031440512325e+03, 
            1.021591636525832e+03,     1.022149851388455e+03,     1.022706100714111e+03,     1.023260399926355e+03,     1.023812764261536e+03, 
            1.024363208771873e+03,     1.024911748328479e+03,     1.025458397624312e+03,     1.026003171177073e+03,     1.026546083332046e+03, 
            1.027087148264866e+03,     1.027626379984244e+03,     1.028163792334640e+03,     1.028699398998863e+03,     1.029233213500640e+03, 
            1.029765249207119e+03,     1.030295519331329e+03,     1.030824036934591e+03,     1.031350814928877e+03,     1.031875866079126e+03, 
            1.032399203005516e+03,     1.032920838185688e+03,     1.033440783956928e+03,     1.033959052518308e+03,     1.034475655932787e+03, 
            1.034990606129265e+03,     1.035503914904602e+03,     1.036015593925612e+03,     1.036525654730985e+03,     1.037034108733210e+03, 
            1.037540967220438e+03,     1.038046241358323e+03,     1.038549942191818e+03,     1.039052080646946e+03,     1.039552667532535e+03, 
            1.040051713541919e+03,     1.040549229254616e+03,     1.041045225137962e+03,     1.041539711548726e+03,     1.042032698734694e+03, 
            1.042524196836217e+03,     1.043014215887744e+03,     1.043502765819314e+03,     1.043989856458033e+03,     1.044475497529511e+03, 
            1.044959698659293e+03,     1.045442469374244e+03,     1.045923819103922e+03,     1.046403757181927e+03,     1.046882292847221e+03, 
            1.047359435245424e+03,     1.047835193430098e+03,     1.048309576363997e+03,     1.048782592920301e+03,     1.049254251883829e+03, 
            1.049724561952230e+03,     1.050193531737154e+03,     1.050661169765403e+03,     1.051127484480064e+03,     1.051592484241620e+03, 
            1.052056177329045e+03,     1.052518571940878e+03,     1.052979676196284e+03,     1.053439498136093e+03,     1.053898045723821e+03, 
            1.054355326846678e+03,     1.054811349316559e+03,     1.055266120871011e+03,     1.055719649174202e+03,     1.056171941817852e+03, 
            1.056623006322164e+03,     1.057072850136735e+03,     1.057521480641458e+03,     1.057968905147395e+03,     1.058415130897654e+03, 
            1.058860165068239e+03,     1.059304014768894e+03,     1.059746687043930e+03,     1.060188188873037e+03,     1.060628527172091e+03, 
            1.061067708793940e+03,     1.061505740529181e+03,     1.061942629106926e+03,     1.062378381195557e+03,     1.062813003403463e+03, 
            1.063246502279774e+03,     1.063678884315079e+03,     1.064110155942131e+03,     1.064540323536548e+03,     1.064969393417497e+03, 
            1.065397371848373e+03,     1.065824265037460e+03,     1.066250079138589e+03,     1.066674820251787e+03,     1.067098494423909e+03, 
            1.067521107649268e+03,     1.067942665870247e+03,     1.068363174977915e+03,     1.068782640812622e+03,     1.069201069164589e+03, 
            1.069618465774490e+03,     1.070034836334028e+03,     1.070450186486497e+03,     1.070864521827340e+03,     1.071277847904696e+03, 
            1.071690170219944e+03,     1.072101494228233e+03,     1.072511825339008e+03,     1.072921168916527e+03,     1.073329530280374e+03, 
            1.073736914705959e+03,     1.074143327425016e+03,     1.074548773626088e+03,     1.074953258455016e+03,     1.075356787015406e+03, 
            1.075759364369107e+03,     1.076160995536661e+03,     1.076561685497770e+03,     1.076961439191738e+03,     1.077360261517916e+03, 
            1.077758157336140e+03,     1.078155131467160e+03,     1.078551188693067e+03,     1.078946333757710e+03,     1.079340571367109e+03, 
            1.079733906189864e+03,     1.080126342857559e+03,     1.080517885965153e+03,     1.080908540071378e+03,     1.081298309699120e+03, 
            1.081687199335805e+03,     1.082075213433766e+03,     1.082462356410624e+03,     1.082848632649649e+03,     1.083234046500118e+03, 
            1.083618602277677e+03,     1.084002304264690e+03,     1.084385156710582e+03,     1.084767163832190e+03,     1.085148329814091e+03, 
            1.085528658808944e+03,     1.085908154937812e+03,     1.086286822290491e+03,     1.086664664925829e+03,     1.087041686872044e+03, 
            1.087417892127034e+03,     1.087793284658687e+03,     1.088167868405184e+03,     1.088541647275301e+03,     1.088914625148704e+03, 
            1.089286805876243e+03,     1.089658193280243e+03,     1.090028791154783e+03,     1.090398603265988e+03,     1.090767633352297e+03, 
            1.091135885124743e+03,     1.091503362267226e+03,     1.091870068436778e+03,     1.092236007263828e+03,     1.092601182352465e+03, 
            1.092965597280695e+03,     1.093329255600695e+03,     1.093692160839067e+03,     1.094054316497086e+03,     1.094415726050944e+03, 
            1.094776392951996e+03,     1.095136320626996e+03,     1.095495512478338e+03,     1.095853971884285e+03,     1.096211702199204e+03, 
            1.096568706753793e+03,     1.096924988855306e+03,     1.097280551787776e+03,     1.097635398812237e+03,     1.097989533166942e+03, 
            1.098342958067569e+03,     1.098695676707449e+03,     1.099047692257762e+03,     1.099399007867752e+03,     1.099749626664929e+03, 
            1.100099551755272e+03,     1.100448786223432e+03,     1.100797333132924e+03,     1.101145195526327e+03,     1.101492376425477e+03, 
            1.101838878831657e+03,     1.102184705725785e+03,     1.102529860068600e+03,     1.102874344800851e+03,     1.103218162843475e+03, 
            1.103561317097777e+03,     1.103903810445610e+03,     1.104245645749553e+03,     1.104586825853079e+03,     1.104927353580733e+03, 
            1.105267231738299e+03,     1.105606463112973e+03,     1.105945050473518e+03,     1.106282996570442e+03,     1.106620304136155e+03, 
            1.106956975885125e+03,     1.107293014514046e+03,     1.107628422701986e+03,     1.107963203110551e+03,     1.108297358384035e+03, 
            1.108630891149568e+03,     1.108963804017272e+03,     1.109296099580411e+03,     1.109627780415531e+03,     1.109958849082612e+03, 
            1.110289308125205e+03,     1.110619160070584e+03,     1.110948407429879e+03,     1.111277052698214e+03,     1.111605098354855e+03, 
            1.111932546863334e+03,     1.112259400671589e+03,     1.112585662212100e+03,     1.112911333902016e+03,     1.113236418143289e+03, 
            1.113560917322799e+03,     1.113884833812486e+03,     1.114208169969475e+03,     1.114530928136197e+03,     1.114853110640521e+03, 
            1.115174719795865e+03,     1.115495757901328e+03,     1.115816227241804e+03,     1.116136130088099e+03,     1.116455468697052e+03, 
            1.116774245311650e+03,     1.117092462161142e+03,     1.117410121461153e+03,     1.117727225413794e+03,     1.118043776207780e+03, 
            1.118359776018531e+03,     1.118675227008288e+03,     1.118990131326218e+03,     1.119304491108519e+03,     1.119618308478532e+03
    },
    {
            1.741609573699248e+00,     5.277612904575302e+00,     8.882005128521964e+00,     1.255817654736975e+01,     1.630979347126036e+01, 
            2.014082952322160e+01,     2.405560157971328e+01,     2.805881121516365e+01,     3.215559270151014e+01,     3.635156887188655e+01, 
            4.065291646904272e+01,     4.506644300948780e+01,     4.959967772605576e+01,     5.426097985025871e+01,     5.905966842275485e+01, 
            6.400617906348991e+01,     6.911225482004059e+01,     7.439118053084223e+01,     7.985807336940607e+01,     8.553024680216440e+01, 
            9.142767175610605e+01,     9.757356839691451e+01,     1.039951762541261e+02,     1.107247723037809e+02,     1.178010408266604e+02, 
            1.252709538744031e+02,     1.331924123512903e+02,     1.416380549365049e+02,     1.507009233809818e+02,     1.605032037577316e+02, 
            1.712103238483271e+02,     1.830549643687571e+02,     1.963808886134412e+02,     2.117305817742880e+02,     2.300440541360034e+02, 
            2.532034430339162e+02,     2.860946576687980e+02,     3.539982442050861e+02,     5.911239873630450e+02,     6.341534730982033e+02, 
            6.580309190904616e+02,     6.751216765037130e+02,     6.886265984820080e+02,     6.998899493194948e+02,     7.096100930997142e+02, 
            7.181980151934905e+02,     7.259166306713934e+02,     7.329446166271324e+02,     7.394091407632835e+02,     7.454040818993589e+02, 
            7.510008363721315e+02,     7.562550588635232e+02,     7.612110446938358e+02,     7.659046791861406e+02,     7.703654821044895e+02, 
            7.746180614485681e+02,     7.786831705844140e+02,     7.825784922513525e+02,     7.863192303122584e+02,     7.899185634799596e+02, 
            7.933879981852294e+02,     7.967376465552651e+02,     7.999764479697997e+02,     8.031123475391655e+02,     8.061524412891441e+02, 
            8.091030953245144e+02,     8.119700444432913e+02,     8.147584743667963e+02,     8.174730907899761e+02,     8.201181777419031e+02, 
            8.226976472091973e+02,     8.252150815671864e+02,     8.276737700507711e+02,     8.300767402550840e+02,     8.324267854672271e+02, 
            8.347264884820036e+02,     8.369782424370338e+02,     8.391842691088330e+02,     8.413466350361774e+02,     8.434672657762276e+02, 
            8.455479585494045e+02,     8.475903934886003e+02,     8.495961436750754e+02,     8.515666841159208e+02,     8.535033997952002e+02, 
            8.554075929118650e+02,     8.572804894016521e+02,     8.591232448267409e+02,     8.609369497056917e+02,     8.627226343465729e+02, 
            8.644812732380494e+02,     8.662137890462533e+02,     8.679210562592780e+02,     8.696039045160496e+02,     8.712631216518826e+02, 
            8.728994564892442e+02,     8.745136213989254e+02,     8.761062946539619e+02,     8.776781225961330e+02,     8.792297216326859e+02, 
            8.807616800790207e+02,     8.822745598613941e+02,     8.837688980922119e+02,     8.852452085292070e+02,     8.867039829286012e+02, 
            8.881456923013924e+02,     8.895707880809560e+02,     8.909797032093779e+02,     8.923728531492155e+02,     8.937506368267454e+02, 
            8.951134375121914e+02,     8.964616236419167e+02,     8.977955495871236e+02,     8.991155563731713e+02,     9.004219723532768e+02, 
            9.017151138400296e+02,     9.029952856978509e+02,     9.042627818992547e+02,     9.055178860475473e+02,     9.067608718683531e+02, 
            9.079920036721851e+02,     9.092115367900757e+02,     9.104197179841317e+02,     9.116167858347367e+02,     9.128029711059619e+02, 
            9.139784971004109e+02,     9.151435800223805e+02,     9.162984292512084e+02,     9.174432469110707e+02,     9.185782303029795e+02, 
            9.197035696206955e+02,     9.208194495955053e+02,     9.219260494349907e+02,     9.230235430462809e+02,     9.241120990851732e+02, 
            9.251918818265223e+02,     9.262630503239071e+02,     9.273257592998842e+02,     9.283801591365815e+02,     9.294263960405951e+02, 
            9.304646122000397e+02,     9.314949459314815e+02,     9.325175318326610e+02,     9.335325009045492e+02,     9.345399806899308e+02, 
            9.355400953953093e+02,     9.365329660092975e+02,     9.375187104157293e+02,     9.384974435017857e+02,     9.394692772613973e+02, 
            9.404343208941555e+02,     9.413926808999872e+02,     9.423444611697932e+02,     9.432897630722647e+02,     9.442286855370650e+02, 
            9.451613251345673e+02,     9.460877761523112e+02,     9.470081306822018e+02,     9.479224786341081e+02,     9.488309078907168e+02, 
            9.497335042917324e+02,     9.506303517969050e+02,     9.515215324153327e+02,     9.524071263518339e+02,     9.532872120396080e+02, 
            9.541618661934652e+02,     9.550311638610373e+02,     9.558951784720662e+02,     9.567539818858534e+02,     9.576076444369575e+02, 
            9.584562349792136e+02,     9.592998209281509e+02,     9.601384683018744e+02,     9.609722417604854e+02,     9.618012046440954e+02, 
            9.626254190094987e+02,     9.634449456655561e+02,     9.642598442073527e+02,     9.650701730491719e+02,     9.658759894563369e+02, 
            9.666773495759701e+02,     9.674743084667145e+02,     9.682669201274523e+02,     9.690552375250722e+02,     9.698393126425090e+02, 
            9.706191964188139e+02,     9.713949389048307e+02,     9.721665891992643e+02,     9.729341954945733e+02,     9.736978050997336e+02, 
            9.744574644622818e+02,     9.752132191896675e+02,     9.759651140699340e+02,     9.767131930917519e+02,     9.774574994638394e+02, 
            9.781980756337825e+02,     9.789349633062820e+02,     9.796682034608472e+02,     9.803978363689532e+02,     9.811239016106969e+02, 
            9.818464380909398e+02,     9.825654840549887e+02,     9.832810771038072e+02,     9.839932542087881e+02,     9.847020517260963e+02, 
            9.854075054105969e+02,     9.861096504293853e+02,     9.868085213749331e+02,     9.875041522778613e+02,     9.881965766193533e+02, 
            9.888858273432221e+02,     9.895719368676433e+02,     9.902549370965619e+02,     9.909348594307847e+02,     9.916117347787758e+02, 
            9.922855935671514e+02,     9.929564657508984e+02,     9.936243808233131e+02,     9.942893678256792e+02,     9.949514553566878e+02, 
            9.956106715816055e+02,     9.962670442412103e+02,     9.969206006604845e+02,     9.975713677570894e+02,     9.982193720496201e+02, 
            9.988646396656467e+02,     9.995071963495521e+02,     1.000147067470168e+03,     1.000784277546847e+03,     1.001418852164069e+03, 
            1.002050815144313e+03,     1.002680190426834e+03,     1.003307001610752e+03,     1.003931271961621e+03,     1.004553024417837e+03, 
            1.005172281596886e+03,     1.005789065801445e+03,     1.006403399025334e+03,     1.007015302959323e+03,     1.007624798996810e+03, 
            1.008231908239355e+03,     1.008836651502088e+03,     1.009439049318989e+03,     1.010039121948044e+03,     1.010636889376287e+03, 
            1.011232371324716e+03,     1.011825587253104e+03,     1.012416556364699e+03,     1.013005297610808e+03,     1.013591829695295e+03, 
            1.014176171078959e+03,     1.014758339983825e+03,     1.015338354397335e+03,     1.015916232076451e+03,     1.016491990551658e+03, 
            1.017065647130887e+03,     1.017637218903351e+03,     1.018206722743293e+03,     1.018774175313658e+03,     1.019339593069682e+03, 
            1.019902992262406e+03,     1.020464388942113e+03,     1.021023798961694e+03,     1.021581237979942e+03,     1.022136721464773e+03, 
            1.022690264696386e+03,     1.023241882770352e+03,     1.023791590600639e+03,     1.024339402922576e+03,     1.024885334295754e+03, 
            1.025429399106874e+03,     1.025971611572523e+03,     1.026511985741907e+03,     1.027050535499523e+03,     1.027587274567775e+03, 
            1.028122216509543e+03,     1.028655374730695e+03,     1.029186762482555e+03,     1.029716392864312e+03,     1.030244278825394e+03, 
            1.030770433167786e+03,     1.031294868548308e+03,     1.031817597480841e+03,     1.032338632338525e+03,     1.032857985355893e+03, 
            1.033375668630985e+03,     1.033891694127401e+03,     1.034406073676340e+03,     1.034918818978573e+03,     1.035429941606400e+03, 
            1.035939453005553e+03,     1.036447364497081e+03,     1.036953687279185e+03,     1.037458432429022e+03,     1.037961610904483e+03, 
            1.038463233545933e+03,     1.038963311077911e+03,     1.039461854110815e+03,     1.039958873142542e+03,     1.040454378560107e+03, 
            1.040948380641230e+03,     1.041440889555889e+03,     1.041931915367855e+03,     1.042421468036191e+03,     1.042909557416728e+03, 
            1.043396193263516e+03,     1.043881385230245e+03,     1.044365142871645e+03,     1.044847475644857e+03,     1.045328392910789e+03, 
            1.045807903935433e+03,     1.046286017891175e+03,     1.046762743858074e+03,     1.047238090825118e+03,     1.047712067691460e+03, 
            1.048184683267639e+03,     1.048655946276768e+03,     1.049125865355714e+03,     1.049594449056247e+03,     1.050061705846178e+03, 
            1.050527644110476e+03,     1.050992272152361e+03,     1.051455598194385e+03,     1.051917630379496e+03,     1.052378376772073e+03, 
            1.052837845358959e+03,     1.053296044050469e+03,     1.053752980681377e+03,     1.054208663011901e+03,     1.054663098728653e+03, 
            1.055116295445592e+03,     1.055568260704951e+03,     1.056019001978146e+03,     1.056468526666684e+03,     1.056916842103043e+03, 
            1.057363955551544e+03,     1.057809874209207e+03,     1.058254605206597e+03,     1.058698155608653e+03,     1.059140532415504e+03, 
            1.059581742563275e+03,     1.060021792924877e+03,     1.060460690310789e+03,     1.060898441469820e+03,     1.061335053089872e+03, 
            1.061770531798675e+03,     1.062204884164526e+03,     1.062638116697006e+03,     1.063070235847692e+03,     1.063501248010854e+03, 
            1.063931159524146e+03,     1.064359976669280e+03,     1.064787705672700e+03,     1.065214352706232e+03,     1.065639923887739e+03, 
            1.066064425281753e+03,     1.066487862900109e+03,     1.066910242702560e+03,     1.067331570597388e+03,     1.067751852442007e+03, 
            1.068171094043556e+03,     1.068589301159475e+03,     1.069006479498091e+03,     1.069422634719175e+03,     1.069837772434505e+03, 
            1.070251898208418e+03,     1.070665017558345e+03,     1.071077135955356e+03,     1.071488258824675e+03,     1.071898391546209e+03, 
            1.072307539455055e+03,     1.072715707842004e+03,     1.073122901954042e+03,     1.073529126994835e+03,     1.073934388125220e+03, 
            1.074338690463671e+03,     1.074742039086781e+03,     1.075144439029714e+03,     1.075545895286670e+03,     1.075946412811332e+03, 
            1.076345996517309e+03,     1.076744651278579e+03,     1.077142381929915e+03,     1.077539193267316e+03,     1.077935090048425e+03, 
            1.078330076992941e+03,     1.078724158783036e+03,     1.079117340063749e+03,     1.079509625443388e+03,     1.079901019493925e+03, 
            1.080291526751378e+03,     1.080681151716199e+03,     1.081069898853644e+03,     1.081457772594150e+03,     1.081844777333700e+03, 
            1.082230917434186e+03,     1.082616197223763e+03,     1.083000620997208e+03,     1.083384193016261e+03,     1.083766917509972e+03, 
            1.084148798675038e+03,     1.084529840676141e+03,     1.084910047646273e+03,     1.085289423687064e+03,     1.085667972869105e+03, 
            1.086045699232263e+03,     1.086422606785995e+03,     1.086798699509659e+03,     1.087173981352816e+03,     1.087548456235533e+03, 
            1.087922128048681e+03,     1.088295000654230e+03,     1.088667077885535e+03,     1.089038363547624e+03,     1.089408861417485e+03, 
            1.089778575244340e+03,     1.090147508749919e+03,     1.090515665628740e+03,     1.090883049548372e+03,     1.091249664149700e+03, 
            1.091615513047192e+03,     1.091980599829153e+03,     1.092344928057982e+03,     1.092708501270428e+03,     1.093071322977833e+03, 
            1.093433396666385e+03,     1.093794725797358e+03,     1.094155313807353e+03,     1.094515164108535e+03,     1.094874280088869e+03, 
            1.095232665112351e+03,     1.095590322519235e+03,     1.095947255626264e+03,     1.096303467726889e+03,     1.096658962091493e+03, 
            1.097013741967608e+03,     1.097367810580126e+03,     1.097721171131524e+03,     1.098073826802060e+03,     1.098425780749994e+03, 
            1.098777036111782e+03,     1.099127596002290e+03,     1.099477463514986e+03,     1.099826641722143e+03,     1.100175133675034e+03, 
            1.100522942404128e+03,     1.100870070919275e+03,     1.101216522209904e+03,     1.101562299245203e+03,     1.101907404974310e+03, 
            1.102251842326490e+03,     1.102595614211319e+03,     1.102938723518865e+03,     1.103281173119858e+03,     1.103622965865869e+03, 
            1.103964104589487e+03,     1.104304592104477e+03,     1.104644431205964e+03,     1.104983624670587e+03,     1.105322175256674e+03, 
            1.105660085704396e+03,     1.105997358735935e+03,     1.106333997055641e+03,     1.106670003350191e+03,     1.107005380288742e+03, 
            1.107340130523087e+03,     1.107674256687809e+03,     1.108007761400432e+03,     1.108340647261562e+03,     1.108672916855049e+03, 
            1.109004572748118e+03,     1.109335617491525e+03,     1.109666053619693e+03,     1.109995883650854e+03,     1.110325110087191e+03, 
            1.110653735414976e+03,     1.110981762104701e+03,     1.111309192611221e+03,     1.111636029373884e+03,     1.111962274816661e+03, 
            1.112287931348280e+03,     1.112613001362357e+03,     1.112937487237517e+03,     1.113261391337529e+03,     1.113584716011426e+03, 
            1.113907463593629e+03,     1.114229636404074e+03,     1.114551236748328e+03,     1.114872266917713e+03,     1.115192729189421e+03, 
            1.115512625826638e+03,     1.115831959078653e+03,     1.116150731180977e+03,     1.116468944355457e+03,     1.116786600810387e+03, 
            1.117103702740621e+03,     1.117420252327685e+03,     1.117736251739880e+03,     1.118051703132398e+03,     1.118366608647423e+03
    },
    {
            1.738124159518854e+00,     5.266720137504353e+00,     8.863087174522049e+00,     1.253055594505074e+01,     1.627272571190184e+01, 
            2.009349446660505e+01,     2.399709348226081e+01,     2.798812709515667e+01,     3.207161870093592e+01,     3.625306419041587e+01, 
            4.053849433738277e+01,     4.493454802829245e+01,     4.944855871122503e+01,     5.408865707952783e+01,     5.886389384875174e+01, 
            6.378438761140152e+01,     6.886150427455881e+01,     7.410807666409964e+01,     7.953867575866920e+01,     8.516994906299183e+01, 
            9.102104740631079e+01,     9.711416984024412e+01,     1.034752687255131e+02,     1.101349758615076e+02,     1.171298395450780e+02, 
            1.245040085592170e+02,     1.323115745743996e+02,     1.406199120168802e+02,     1.495145796985264e+02,     1.591067621668422e+02, 
            1.695450350511859e+02,     1.810349112912148e+02,     1.938733892084818e+02,     2.085151002623580e+02,     2.257133655411679e+02, 
            2.468711596626147e+02,     2.751551086286601e+02,     3.211368121656541e+02,     5.067219773919579e+02,     6.061160268323467e+02, 
            6.390188288121273e+02,     6.601149560572466e+02,     6.759440412256512e+02,     6.887475454610175e+02,     6.995739574337506e+02, 
            7.090011203722212e+02,     7.173821813438633e+02,     7.249490867006709e+02,     7.318625592959202e+02,     7.382387029364924e+02, 
            7.441642387420875e+02,     7.497057441496643e+02,     7.549155196321651e+02,     7.598354588938780e+02,     7.644996855269309e+02, 
            7.689363995981465e+02,     7.731692023412988e+02,     7.772180667298513e+02,     7.811000620365965e+02,     7.848299038679220e+02, 
            7.884203780448822e+02,     7.918826717420559e+02,     7.952266353932936e+02,     7.984609921865339e+02,     8.015935073712917e+02, 
            8.046311263867466e+02,     8.075800885353265e+02,     8.104460212828189e+02,     8.132340190669638e+02,     8.159487096112014e+02, 
            8.185943100792921e+02,     8.211746749078625e+02,     8.236933367738924e+02,     8.261535418620537e+02,     8.285582803700280e+02, 
            8.309103130127835e+02,     8.332121941469968e+02,     8.354662920259532e+02,     8.376748066065653e+02,     8.398397852588835e+02, 
            8.419631366706333e+02,     8.440466431924085e+02,     8.460919718305473e+02,     8.481006840631014e+02,     8.500742446280427e+02, 
            8.520140294110930e+02,     8.539213325423368e+02,     8.557973727955455e+02,     8.576432993712623e+02,     8.594601971338668e+02, 
            8.612490913635869e+02,     8.630109520766013e+02,     8.647466979596589e+02,     8.664571999598909e+02,     8.681432845655412e+02, 
            8.698057368090963e+02,     8.714453030205666e+02,     8.730626933555208e+02,     8.746585841196382e+02,     8.762336199091642e+02, 
            8.777884155844943e+02,     8.793235580922803e+02,     8.808396081497971e+02,     8.823371018038943e+02,     8.838165518755708e+02, 
            8.852784493000975e+02,     8.867232643716247e+02,     8.881514479003349e+02,     8.895634322893972e+02,     8.909596325383147e+02, 
            8.923404471786167e+02,     8.937062591472863e+02,     8.950574366028484e+02,     8.963943336885525e+02,     8.977172912467365e+02, 
            8.990266374880492e+02,     9.003226886189274e+02,     9.016057494304052e+02,     9.028761138510862e+02,     9.041340654668567e+02, 
            9.053798780097211e+02,     9.066138158179274e+02,     9.078361342693952e+02,     9.090470801902674e+02,     9.102468922402957e+02, 
            9.114358012792800e+02,     9.126140307465059e+02,     9.137817969742016e+02,     9.149393094651787e+02,     9.160867700595361e+02, 
            9.172243768230702e+02,     9.183523198494928e+02,     9.194707840241617e+02,     9.205799487137199e+02,     9.216799878196150e+02, 
            9.227710706839492e+02,     9.238533612191048e+02,     9.249270188340460e+02,     9.259921984262372e+02,     9.270490505544411e+02, 
            9.280977216032262e+02,     9.291383539396767e+02,     9.301710860594892e+02,     9.311960527413869e+02,     9.322133851661110e+02, 
            9.332232110565524e+02,     9.342256547990253e+02,     9.352208375614687e+02,     9.362088774063891e+02,     9.371898893988393e+02, 
            9.381639857096792e+02,     9.391312757143705e+02,     9.400918660875394e+02,     9.410458608935215e+02,     9.419933616730909e+02, 
            9.429344675265671e+02,     9.438692751934881e+02,     9.447978791290053e+02,     9.457203715900312e+02,     9.466368426315931e+02, 
            9.475473803422137e+02,     9.484520707204399e+02,     9.493509978417824e+02,     9.502442438954837e+02,     9.511318892420541e+02, 
            9.520140124685927e+02,     9.528906904420087e+02,     9.537619983602266e+02,     9.546280098014668e+02,     9.554887967717020e+02, 
            9.563444297503481e+02,     9.571949777342940e+02,     9.580405082803210e+02,     9.588810875459944e+02,     9.597167803290919e+02, 
            9.605476501056287e+02,     9.613737590665421e+02,     9.621951681530884e+02,     9.630119370910154e+02,     9.638241244235502e+02, 
            9.646317875432565e+02,     9.654349827443266e+02,     9.662337651651245e+02,     9.670281889494833e+02,     9.678183071848885e+02, 
            9.686041719520622e+02,     9.693858343509436e+02,     9.701633445258269e+02,     9.709367516896776e+02,     9.717061041476779e+02, 
            9.724714493200080e+02,     9.732328337639109e+02,     9.739903031950681e+02,     9.747439025082932e+02,     9.754936757975896e+02, 
            9.762396663755917e+02,     9.769819167924021e+02,     9.777204688538591e+02,     9.784553636392493e+02,     9.791866415184910e+02, 
            9.799143421687967e+02,     9.806385045908467e+02,     9.813591671244832e+02,     9.820763674639431e+02,     9.827901426726499e+02, 
            9.835005291975687e+02,     9.842075628831612e+02,     9.849112789849282e+02,     9.856117121825777e+02,     9.863088965928107e+02, 
            9.870028657817556e+02,     9.876936527770529e+02,     9.883812900796020e+02,     9.890658096749863e+02,     9.897472430445852e+02, 
            9.904256211763807e+02,     9.911009745754734e+02,     9.917733332743117e+02,     9.924427268426525e+02,     9.931091843972483e+02, 
            9.937727346112869e+02,     9.944334057235723e+02,     9.950912255474764e+02,     9.957462214796452e+02,     9.963984205084901e+02, 
            9.970478492224541e+02,     9.976945338180672e+02,     9.983385001078000e+02,     9.989797730482782e+02,     9.996183786472740e+02, 
            1.000254341148563e+03,     1.000887684902987e+03,     1.001518433913715e+03,     1.002146611842987e+03,     1.002772242018696e+03, 
            1.003395347440799e+03,     1.004015950787586e+03,     1.004634074421786e+03,     1.005249740396536e+03,     1.005862970461198e+03, 
            1.006473786067044e+03,     1.007082208372803e+03,     1.007688258250082e+03,     1.008291956288653e+03,     1.008893322801621e+03, 
            1.009492377830476e+03,     1.010089141150019e+03,     1.010683632273182e+03,     1.011275870455737e+03,     1.011865874700893e+03, 
            1.012453663763799e+03,     1.013039256155932e+03,     1.013622670149399e+03,     1.014203923781137e+03,     1.014783034857020e+03, 
            1.015360020955875e+03,     1.015934899433413e+03,     1.016507687426074e+03,     1.017078401854776e+03,     1.017647059428605e+03, 
            1.018213676648405e+03,     1.018778269810304e+03,     1.019340855009152e+03,     1.019901448141905e+03,     1.020460064910914e+03, 
            1.021016720827164e+03,     1.021571431213433e+03,     1.022124211207393e+03,     1.022675075764640e+03,     1.023224039661665e+03, 
            1.023771117498762e+03,     1.024316323702877e+03,     1.024859672530402e+03,     1.025401178069905e+03,     1.025940854244809e+03, 
            1.026478714816018e+03,     1.027014773384489e+03,     1.027549043393752e+03,     1.028081538132377e+03,     1.028612270736401e+03, 
            1.029141254191698e+03,     1.029668501336304e+03,     1.030194024862701e+03,     1.030717837320055e+03,     1.031239951116403e+03, 
            1.031760378520810e+03,     1.032279131665477e+03,     1.032796222547807e+03,     1.033311663032436e+03,     1.033825464853226e+03, 
            1.034337639615215e+03,     1.034848198796536e+03,     1.035357153750291e+03,     1.035864515706407e+03,     1.036370295773433e+03, 
            1.036874504940330e+03,     1.037377154078206e+03,     1.037878253942031e+03,     1.038377815172319e+03,     1.038875848296776e+03, 
            1.039372363731919e+03,     1.039867371784668e+03,     1.040360882653909e+03,     1.040852906432023e+03,     1.041343453106397e+03, 
            1.041832532560900e+03,     1.042320154577336e+03,     1.042806328836873e+03,     1.043291064921445e+03,     1.043774372315125e+03, 
            1.044256260405483e+03,     1.044736738484913e+03,     1.045215815751940e+03,     1.045693501312502e+03,     1.046169804181216e+03, 
            1.046644733282611e+03,     1.047118297452354e+03,     1.047590505438442e+03,     1.048061365902381e+03,     1.048530887420345e+03, 
            1.048999078484312e+03,     1.049465947503185e+03,     1.049931502803886e+03,     1.050395752632446e+03,     1.050858705155063e+03, 
            1.051320368459148e+03,     1.051780750554355e+03,     1.052239859373594e+03,     1.052697702774022e+03,     1.053154288538025e+03, 
            1.053609624374180e+03,     1.054063717918202e+03,     1.054516576733874e+03,     1.054968208313967e+03,     1.055418620081139e+03, 
            1.055867819388826e+03,     1.056315813522110e+03,     1.056762609698584e+03,     1.057208215069195e+03,     1.057652636719076e+03, 
            1.058095881668366e+03,     1.058537956873018e+03,     1.058978869225589e+03,     1.059418625556027e+03,     1.059857232632433e+03, 
            1.060294697161825e+03,     1.060731025790879e+03,     1.061166225106668e+03,     1.061600301637380e+03,     1.062033261853030e+03, 
            1.062465112166166e+03,     1.062895858932555e+03,     1.063325508451861e+03,     1.063754066968322e+03,     1.064181540671402e+03, 
            1.064607935696444e+03,     1.065033258125308e+03,     1.065457513987006e+03,     1.065880709258316e+03,     1.066302849864401e+03, 
            1.066723941679403e+03,     1.067143990527046e+03,     1.067563002181216e+03,     1.067980982366538e+03,     1.068397936758945e+03, 
            1.068813870986238e+03,     1.069228790628635e+03,     1.069642701219320e+03,     1.070055608244975e+03,     1.070467517146309e+03, 
            1.070878433318577e+03,     1.071288362112099e+03,     1.071697308832760e+03,     1.072105278742508e+03,     1.072512277059854e+03, 
            1.072918308960346e+03,     1.073323379577056e+03,     1.073727494001045e+03,     1.074130657281831e+03,     1.074532874427843e+03, 
            1.074934150406882e+03,     1.075334490146554e+03,     1.075733898534721e+03,     1.076132380419923e+03,     1.076529940611816e+03, 
            1.076926583881587e+03,     1.077322314962373e+03,     1.077717138549667e+03,     1.078111059301727e+03,     1.078504081839972e+03, 
            1.078896210749376e+03,     1.079287450578859e+03,     1.079677805841667e+03,     1.080067281015750e+03,     1.080455880544137e+03, 
            1.080843608835302e+03,     1.081230470263529e+03,     1.081616469169269e+03,     1.082001609859492e+03,     1.082385896608039e+03, 
            1.082769333655966e+03,     1.083151925211880e+03,     1.083533675452277e+03,     1.083914588521876e+03,     1.084294668533938e+03, 
            1.084673919570596e+03,     1.085052345683170e+03,     1.085429950892481e+03,     1.085806739189160e+03,     1.086182714533959e+03, 
            1.086557880858046e+03,     1.086932242063309e+03,     1.087305802022650e+03,     1.087678564580274e+03,     1.088050533551975e+03, 
            1.088421712725425e+03,     1.088792105860445e+03,     1.089161716689294e+03,     1.089530548916928e+03,     1.089898606221283e+03, 
            1.090265892253528e+03,     1.090632410638339e+03,     1.090998164974156e+03,     1.091363158833434e+03,     1.091727395762900e+03, 
            1.092090879283807e+03,     1.092453612892176e+03,     1.092815600059039e+03,     1.093176844230688e+03,     1.093537348828904e+03, 
            1.093897117251197e+03,     1.094256152871038e+03,     1.094614459038092e+03,     1.094972039078436e+03,     1.095328896294792e+03, 
            1.095685033966743e+03,     1.096040455350956e+03,     1.096395163681396e+03,     1.096749162169539e+03,     1.097102454004583e+03, 
            1.097455042353660e+03,     1.097806930362039e+03,     1.098158121153331e+03,     1.098508617829687e+03,     1.098858423472004e+03, 
            1.099207541140114e+03,     1.099555973872987e+03,     1.099903724688914e+03,     1.100250796585701e+03,     1.100597192540858e+03, 
            1.100942915511783e+03,     1.101287968435946e+03,     1.101632354231070e+03,     1.101976075795310e+03,     1.102319136007429e+03, 
            1.102661537726976e+03,     1.103003283794457e+03,     1.103344377031508e+03,     1.103684820241060e+03,     1.104024616207513e+03, 
            1.104363767696895e+03,     1.104702277457031e+03,     1.105040148217698e+03,     1.105377382690795e+03,     1.105713983570489e+03, 
            1.106049953533383e+03,     1.106385295238661e+03,     1.106720011328249e+03,     1.107054104426958e+03,     1.107387577142642e+03, 
            1.107720432066342e+03,     1.108052671772429e+03,     1.108384298818754e+03,     1.108715315746791e+03,     1.109045725081773e+03, 
            1.109375529332837e+03,     1.109704730993163e+03,     1.110033332540108e+03,     1.110361336435341e+03,     1.110688745124982e+03, 
            1.111015561039728e+03,     1.111341786594991e+03,     1.111667424191021e+03,     1.111992476213042e+03,     1.112316945031369e+03, 
            1.112640833001544e+03,     1.112964142464455e+03,     1.113286875746459e+03,     1.113609035159505e+03,     1.113930623001252e+03, 
            1.114251641555194e+03,     1.114572093090771e+03,     1.114891979863489e+03,     1.115211304115038e+03,     1.115530068073399e+03, 
            1.115848273952965e+03,     1.116165923954647e+03,     1.116483020265990e+03,     1.116799565061278e+03,     1.117115560501643e+03
    },
    {
            1.734652893299065e+00,     5.255874406908829e+00,     8.844256058865803e+00,     1.250307004304607e+01,     1.623584993268434e+01, 
            2.004641970121718e+01,     2.393892694303356e+01,     2.791788106181817e+01,     3.198819735113993e+01,     3.615524811383131e+01, 
            4.042492223160806e+01,     4.480369494384793e+01,     4.929871004133344e+01,     5.391787726364554e+01,     5.866998845605300e+01, 
            6.356485706175076e+01,     6.861348689639433e+01,     7.382827801673351e+01,     7.922328006412161e+01,     8.481450705189414e+01, 
            9.062033265356372e+01,     9.666199238319913e+01,     1.029642298254475e+02,     1.095561401955760e+02,     1.164722891981840e+02, 
            1.237542239097438e+02,     1.314525550042021e+02,     1.396298938007084e+02,     1.483651082642998e+02,     1.577596867996917e+02, 
            1.679476157999709e+02,     1.791114176512519e+02,     1.915096814054023e+02,     2.055277798417974e+02,     2.217803985458715e+02, 
            2.413472139481630e+02,     2.664285880984149e+02,     3.028598168723206e+02,     3.796397283207248e+02,     5.640331035570246e+02, 
            6.155752472281115e+02,     6.428432817228147e+02,     6.618538147027083e+02,     6.766317671348104e+02,     6.888178279344163e+02, 
            6.992461820220027e+02,     7.084000341529206e+02,     7.165847057582682e+02,     7.240055908847670e+02,     7.308075994815301e+02, 
            7.370968872435100e+02,     7.429536329878862e+02,     7.484399505914222e+02,     7.536049993137731e+02,     7.584884028665914e+02, 
            7.631226064659775e+02,     7.675345442821813e+02,     7.717468459874550e+02,     7.757787273885625e+02,     7.796466596465527e+02, 
            7.833648802071165e+02,     7.869457885336454e+02,     7.904002566412462e+02,     7.937378756870354e+02,     7.969671539213373e+02, 
            8.000956771829032e+02,     8.031302402209038e+02,     8.060769550554004e+02,     8.089413410888976e+02,     8.117284005830030e+02, 
            8.144426822995822e+02,     8.170883354951793e+02,     8.196691559951449e+02,     8.221886257203830e+02,     8.246499467670616e+02, 
            8.270560709274619e+02,     8.294097253738937e+02,     8.317134350962143e+02,     8.339695425789283e+02,     8.361802251201489e+02, 
            8.383475101271832e+02,     8.404732886687434e+02,     8.425593275191633e+02,     8.446072798933391e+02,     8.466186950409513e+02, 
            8.485950268434746e+02,     8.505376415366937e+02,     8.524478246640174e+02,     8.543267873512472e+02,     8.561756719811834e+02, 
            8.579955573359528e+02,     8.597874632661444e+02,     8.615523549382407e+02,     8.632911467053964e+02,     8.650047056410618e+02, 
            8.666938547701720e+02,     8.683593760285157e+02,     8.700020129773025e+02,     8.716224732968964e+02,     8.732214310809253e+02, 
            8.747995289496811e+02,     8.763573799996246e+02,     8.778955696040412e+02,     8.794146570782507e+02,     8.809151772214631e+02, 
            8.823976417460456e+02,     8.838625406039466e+02,     8.853103432190222e+02,     8.867414996331602e+02,     8.881564415733342e+02, 
            8.895555834460440e+02,     8.909393232649924e+02,     8.923080435172981e+02,     8.936621119730593e+02,     8.950018824426758e+02, 
            8.963276954858957e+02,     8.976398790762449e+02,     8.989387492241696e+02,     9.002246105619116e+02,     9.014977568929307e+02, 
            9.027584717083922e+02,     9.040070286730773e+02,     9.052436920828658e+02,     9.064687172957414e+02,     9.076823511381677e+02, 
            9.088848322887604e+02,     9.100763916639968e+02,     9.112572527772320e+02,     9.124276320223199e+02,     9.135877380713550e+02, 
            9.147377750049607e+02,     9.158779391461726e+02,     9.170084212376055e+02,     9.181294062762755e+02,     9.192410735722236e+02, 
            9.203435976894536e+02,     9.214371475472190e+02,     9.225218873819073e+02,     9.235979767408829e+02,     9.246655706635312e+02, 
            9.257248198535630e+02,     9.267758708430844e+02,     9.278188661488924e+02,     9.288539444214473e+02,     9.298812405820165e+02, 
            9.309008859765355e+02,     9.319130084790974e+02,     9.329177326316906e+02,     9.339151797583321e+02,     9.349054680778007e+02, 
            9.358887128114234e+02,     9.368650262861635e+02,     9.378345180332617e+02,     9.387972948826592e+02,     9.397534610534125e+02, 
            9.407031182403075e+02,     9.416463656968684e+02,     9.425833003149323e+02,     9.435140167141224e+02,     9.444386072411547e+02, 
            9.453571622045482e+02,     9.462697697606123e+02,     9.471765160776840e+02,     9.480774853766973e+02,     9.489727599909908e+02, 
            9.498624204238145e+02,     9.507465454036222e+02,     9.516252119372634e+02,     9.524984953611664e+02,     9.533664693906070e+02, 
            9.542292061671449e+02,     9.550867763043037e+02,     9.559392489315946e+02,     9.567866917369264e+02,     9.576291710074972e+02, 
            9.584667516692168e+02,     9.592994973247355e+02,     9.601274702901281e+02,     9.609507316302974e+02,     9.617693412138444e+02, 
            9.625833576621736e+02,     9.633928385089154e+02,     9.641978401444811e+02,     9.649984178676750e+02,     9.657946259144471e+02, 
            9.665865174856843e+02,     9.673741447740874e+02,     9.681575589901632e+02,     9.689368103873772e+02,     9.697119482864819e+02, 
            9.704830210990744e+02,     9.712500763503969e+02,     9.720131607014148e+02,     9.727723199702015e+02,     9.735275991526510e+02, 
            9.742790424425550e+02,     9.750266932510522e+02,     9.757705942254837e+02,     9.765107872676789e+02,     9.772473135516813e+02, 
            9.779802135409441e+02,     9.787095270050160e+02,     9.794352930357234e+02,     9.801575500628846e+02,     9.808763358695578e+02, 
            9.815916876068419e+02,     9.823036418082603e+02,     9.830122344037179e+02,     9.837175007330671e+02,     9.844194755592860e+02, 
            9.851181930812843e+02,     9.858136869463477e+02,     9.865059902622412e+02,     9.871951356089687e+02,     9.878811550502115e+02, 
            9.885640801444587e+02,     9.892439419558243e+02,     9.899207710645768e+02,     9.905945975773858e+02,     9.912654511372941e+02, 
            9.919333609334186e+02,     9.925983557104030e+02,     9.932604637776149e+02,     9.939197130181021e+02,     9.945761308973260e+02, 
            9.952297444716502e+02,     9.958805803966306e+02,     9.965286649350770e+02,     9.971740234875613e+02,     9.978166824912737e+02, 
            9.984566666176328e+02,     9.990940006351442e+02,     9.997287089569529e+02,     1.000360815647771e+03,     1.000990344430632e+03, 
            1.001617318693480e+03,     1.002241761495600e+03,     1.002863695573894e+03,     1.003483143348991e+03,     1.004100126931235e+03, 
            1.004714668126509e+03,     1.005326788441928e+03,     1.005936509091401e+03,     1.006543851001054e+03,     1.007148834814535e+03, 
            1.007751480898186e+03,     1.008351809346105e+03,     1.008949839985082e+03,     1.009545592379428e+03,     1.010139085835693e+03, 
            1.010730339407270e+03,     1.011319371898908e+03,     1.011906201871110e+03,     1.012490847644438e+03,     1.013073327303729e+03, 
            1.013653658702200e+03,     1.014231859465483e+03,     1.014807946995555e+03,     1.015381938474591e+03,     1.015953850868732e+03, 
            1.016523700931766e+03,     1.017091505208735e+03,     1.017657280039464e+03,     1.018221041562017e+03,     1.018782805716065e+03, 
            1.019342588246208e+03,     1.019900404705202e+03,     1.020456270457134e+03,     1.021010200680524e+03,     1.021562210371366e+03, 
            1.022112314346103e+03,     1.022660527244539e+03,     1.023206863532703e+03,     1.023751337505635e+03,     1.024293963290131e+03, 
            1.024834754847430e+03,     1.025373725975837e+03,     1.025910890313310e+03,     1.026446261339976e+03,     1.026979852380613e+03, 
            1.027511676607074e+03,     1.028041747040668e+03,     1.028570076554489e+03,     1.029096677875702e+03,     1.029621563587788e+03, 
            1.030144746132739e+03,     1.030666237813214e+03,     1.031186050794656e+03,     1.031704197107363e+03,     1.032220688648520e+03, 
            1.032735537184199e+03,     1.033248754351312e+03,     1.033760351659539e+03,     1.034270340493201e+03,     1.034778732113120e+03, 
            1.035285537658427e+03,     1.035790768148347e+03,     1.036294434483945e+03,     1.036796547449844e+03,     1.037297117715905e+03, 
            1.037796155838888e+03,     1.038293672264069e+03,     1.038789677326837e+03,     1.039284181254259e+03,     1.039777194166616e+03, 
            1.040268726078918e+03,     1.040758786902378e+03,     1.041247386445875e+03,     1.041734534417382e+03,     1.042220240425374e+03, 
            1.042704513980201e+03,     1.043187364495456e+03,     1.043668801289295e+03,     1.044148833585759e+03,     1.044627470516049e+03, 
            1.045104721119801e+03,     1.045580594346321e+03,     1.046055099055811e+03,     1.046528244020568e+03,     1.047000037926165e+03, 
            1.047470489372609e+03,     1.047939606875486e+03,     1.048407398867080e+03,     1.048873873697474e+03,     1.049339039635635e+03, 
            1.049802904870485e+03,     1.050265477511942e+03,     1.050726765591958e+03,     1.051186777065525e+03,     1.051645519811682e+03, 
            1.052103001634491e+03,     1.052559230264000e+03,     1.053014213357197e+03,     1.053467958498943e+03,     1.053920473202890e+03, 
            1.054371764912387e+03,     1.054821841001365e+03,     1.055270708775220e+03,     1.055718375471670e+03,     1.056164848261601e+03, 
            1.056610134249909e+03,     1.057054240476312e+03,     1.057497173916167e+03,     1.057938941481260e+03,     1.058379550020592e+03, 
            1.058819006321151e+03,     1.059257317108668e+03,     1.059694489048369e+03,     1.060130528745706e+03,     1.060565442747088e+03, 
            1.060999237540587e+03,     1.061431919556649e+03,     1.061863495168780e+03,     1.062293970694230e+03,     1.062723352394665e+03, 
            1.063151646476824e+03,     1.063578859093178e+03,     1.064004996342566e+03,     1.064430064270824e+03,     1.064854068871417e+03, 
            1.065277016086046e+03,     1.065698911805252e+03,     1.066119761869012e+03,     1.066539572067328e+03,     1.066958348140805e+03, 
            1.067376095781216e+03,     1.067792820632069e+03,     1.068208528289157e+03,     1.068623224301104e+03,     1.069036914169903e+03, 
            1.069449603351444e+03,     1.069861297256038e+03,     1.070272001248931e+03,     1.070681720650811e+03,     1.071090460738307e+03, 
            1.071498226744485e+03,     1.071905023859329e+03,     1.072310857230228e+03,     1.072715731962440e+03,     1.073119653119564e+03, 
            1.073522625723995e+03,     1.073924654757382e+03,     1.074325745161070e+03,     1.074725901836542e+03,     1.075125129645856e+03, 
            1.075523433412070e+03,     1.075920817919664e+03,     1.076317287914964e+03,     1.076712848106543e+03,     1.077107503165635e+03, 
            1.077501257726528e+03,     1.077894116386968e+03,     1.078286083708537e+03,     1.078677164217047e+03,     1.079067362402914e+03, 
            1.079456682721531e+03,     1.079845129593642e+03,     1.080232707405700e+03,     1.080619420510230e+03,     1.081005273226184e+03, 
            1.081390269839288e+03,     1.081774414602390e+03,     1.082157711735798e+03,     1.082540165427618e+03,     1.082921779834087e+03, 
            1.083302559079896e+03,     1.083682507258520e+03,     1.084061628432531e+03,     1.084439926633918e+03,     1.084817405864395e+03, 
            1.085194070095705e+03,     1.085569923269931e+03,     1.085944969299791e+03,     1.086319212068929e+03,     1.086692655432218e+03, 
            1.087065303216032e+03,     1.087437159218548e+03,     1.087808227210014e+03,     1.088178510933029e+03,     1.088548014102820e+03, 
            1.088916740407511e+03,     1.089284693508390e+03,     1.089651877040169e+03,     1.090018294611251e+03,     1.090383949803981e+03, 
            1.090748846174906e+03,     1.091112987255020e+03,     1.091476376550017e+03,     1.091839017540530e+03,     1.092200913682379e+03, 
            1.092562068406808e+03,     1.092922485120718e+03,     1.093282167206900e+03,     1.093641118024274e+03,     1.093999340908106e+03, 
            1.094356839170236e+03,     1.094713616099305e+03,     1.095069674960965e+03,     1.095425018998106e+03,     1.095779651431065e+03, 
            1.096133575457837e+03,     1.096486794254285e+03,     1.096839310974350e+03,     1.097191128750251e+03,     1.097542250692690e+03, 
            1.097892679891048e+03,     1.098242419413585e+03,     1.098591472307638e+03,     1.098939841599804e+03,     1.099287530296143e+03, 
            1.099634541382354e+03,     1.099980877823969e+03,     1.100326542566537e+03,     1.100671538535800e+03,     1.101015868637879e+03, 
            1.101359535759446e+03,     1.101702542767905e+03,     1.102044892511564e+03,     1.102386587819801e+03,     1.102727631503245e+03, 
            1.103068026353932e+03,     1.103407775145480e+03,     1.103746880633247e+03,     1.104085345554497e+03,     1.104423172628560e+03, 
            1.104760364556985e+03,     1.105096924023707e+03,     1.105432853695193e+03,     1.105768156220601e+03,     1.106102834231928e+03, 
            1.106436890344162e+03,     1.106770327155432e+03,     1.107103147247148e+03,     1.107435353184155e+03,     1.107766947514872e+03, 
            1.108097932771433e+03,     1.108428311469828e+03,     1.108758086110044e+03,     1.109087259176202e+03,     1.109415833136689e+03, 
            1.109743810444299e+03,     1.110071193536358e+03,     1.110397984834864e+03,     1.110724186746612e+03,     1.111049801663322e+03, 
            1.111374831961769e+03,     1.111699280003910e+03,     1.112023148137006e+03,     1.112346438693744e+03,     1.112669153992366e+03, 
            1.112991296336781e+03,     1.113312868016691e+03,     1.113633871307707e+03,     1.113954308471464e+03,     1.114274181755742e+03, 
            1.114593493394573e+03,     1.114912245608364e+03,     1.115230440604000e+03,     1.115548080574959e+03,     1.115865167701425e+03
    },
    {
            1.731195687059451e+00,     5.245075389219067e+00,     8.825511126115364e+00,     1.247571773280986e+01,     1.619916441924373e+01, 
            1.999960271437816e+01,     2.388109840806479e+01,     2.784806821265008e+01,     3.190532201164459e+01,     3.605811176857628e+01, 
            4.031218841345914e+01,     4.467386834408565e+01,     4.915011158913781e+01,     5.374861421266592e+01,     5.847791823765638e+01, 
            6.334754329076438e+01,     6.836814540710570e+01,     7.355171010784800e+01,     7.891178915666363e+01,     8.446379358527746e+01, 
            9.022536006390267e+01,     9.621681411184748e+01,     1.024617629913941e+02,     1.089878650024000e+02,     1.158278429281199e+02, 
            1.230208420290687e+02,     1.306142850322368e+02,     1.386664618983465e+02,     1.472502376599905e+02,     1.564585178783935e+02, 
            1.664125868552316e+02,     1.772753624356793e+02,     1.892735505177843e+02,     2.027370711960170e+02,     2.181751276200676e+02, 
            2.364397859626962e+02,     2.591362501397304e+02,     2.899273365086527e+02,     3.408435688664254e+02,     4.835783042995018e+02, 
            5.847413723327523e+02,     6.223900242106865e+02,     6.459476646128177e+02,     6.633220756136825e+02,     6.772075857638293e+02, 
            6.888449711462280e+02,     6.989088464807566e+02,     7.078070385000190e+02,     7.158050086009740e+02,     7.230852836196543e+02, 
            7.297788130538623e+02,     7.359827976857197e+02,     7.417714347535864e+02,     7.472027047845125e+02,     7.523228271817031e+02, 
            7.571692820327088e+02,     7.617729173701454e+02,     7.661594546176332e+02,     7.703505871702208e+02,     7.743647973108912e+02, 
            7.782179739975005e+02,     7.819238871995210e+02,     7.854945571299354e+02,     7.889405452750444e+02,     7.922711864172344e+02, 
            7.954947755582050e+02,     7.986187199620100e+02,     8.016496639251549e+02,     8.045935920050173e+02,     8.074559150727649e+02, 
            8.102415425518266e+02,     8.129549434542917e+02,     8.156001982643221e+02,     8.181810432894555e+02,     8.207009087722981e+02, 
            8.231629518009684e+02,     8.255700848584506e+02,     8.279250006951435e+02,     8.302301940854841e+02,     8.324879809310966e+02, 
            8.347005150939068e+02,     8.368698032788368e+02,     8.389977182338486e+02,     8.410860104927317e+02,     8.431363188512045e+02, 
            8.451501797381815e+02,     8.471290356201868e+02,     8.490742425570307e+02,     8.509870770102182e+02,     8.528687419915697e+02, 
            8.547203726277156e+02,     8.565430412061299e+02,     8.583377617598507e+02,     8.601054942407707e+02,     8.618471483251691e+02, 
            8.635635868898045e+02,     8.652556291922929e+02,     8.669240537855175e+02,     8.685696011923593e+02,     8.701929763640586e+02, 
            8.717948509428919e+02,     8.733758653475832e+02,     8.749366306978602e+02,     8.764777305928288e+02,     8.779997227562869e+02, 
            8.795031405607510e+02,     8.809884944407662e+02,     8.824562732050015e+02,     8.839069452557201e+02,     8.853409597233349e+02, 
            8.867587475230614e+02,     8.881607223399801e+02,     8.895472815482601e+02,     8.909188070697420e+02,     8.922756661766126e+02, 
            8.936182122424916e+02,     8.949467854458402e+02,     8.962617134292863e+02,     8.975633119181358e+02,     8.988518853010568e+02, 
            9.001277271756841e+02,     9.013911208616544e+02,     9.026423398833687e+02,     9.038816484246153e+02,     9.051093017569788e+02, 
            9.063255466438428e+02,     9.075306217323828e+02,     9.087247579492197e+02,     9.099081788045041e+02,     9.110810999828033e+02, 
            9.122437318417323e+02,     9.133962771016048e+02,     9.145389325462440e+02,     9.156718889781180e+02,     9.167953312828167e+02, 
            9.179094394045889e+02,     9.190143874212040e+02,     9.201103445408336e+02,     9.211974750984652e+02,     9.222759387455569e+02, 
            9.233458906304786e+02,     9.244074815702556e+02,     9.254608582141317e+02,     9.265061631993974e+02,     9.275435352999383e+02, 
            9.285731095678883e+02,     9.295950174616379e+02,     9.306093870017796e+02,     9.316163428561373e+02,     9.326160064815715e+02, 
            9.336084962307417e+02,     9.345939274596648e+02,     9.355724126305907e+02,     9.365440614104608e+02,     9.375089807651505e+02, 
            9.384672750497291e+02,     9.394190460949330e+02,     9.403643932900394e+02,     9.413034136554444e+02,     9.422362019466570e+02, 
            9.431628506853359e+02,     9.440834502577820e+02,     9.449980889751780e+02,     9.459068531382990e+02,     9.468098270996877e+02, 
            9.477070933234110e+02,     9.485987324425070e+02,     9.494848233142357e+02,     9.503654430732292e+02,     9.512406671826368e+02, 
            9.521105694833615e+02,     9.529752222414637e+02,     9.538346961938291e+02,     9.546890605921586e+02,     9.555383832453650e+02, 
            9.563827305604469e+02,     9.572221676029600e+02,     9.580567580496713e+02,     9.588865643550473e+02,     9.597116476988821e+02, 
            9.605320680427310e+02,     9.613478841628978e+02,     9.621591536823094e+02,     9.629659331012941e+02,     9.637682778273332e+02, 
            9.645662422038098e+02,     9.653598795378114e+02,     9.661492421270044e+02,     9.669343812856408e+02,     9.677153473697077e+02, 
            9.684921898012732e+02,     9.692649570920457e+02,     9.700336968661843e+02,     9.707984558823857e+02,     9.715592800552801e+02, 
            9.723162144761568e+02,     9.730693034330446e+02,     9.738185904301769e+02,     9.745641182068584e+02,     9.753059287557601e+02, 
            9.760440633406570e+02,     9.767785625136404e+02,     9.775094661318064e+02,     9.782368133734603e+02,     9.789606427538341e+02, 
            9.796809921403517e+02,     9.803978987674454e+02,     9.811113992509414e+02,     9.818215296020401e+02,     9.825283252408888e+02, 
            9.832318210097721e+02,     9.839320511859351e+02,     9.846290494940336e+02,     9.853228491182546e+02,     9.860134827140854e+02, 
            9.867009824197677e+02,     9.873853798674339e+02,     9.880667061939422e+02,     9.887449920514175e+02,     9.894202676175074e+02, 
            9.900925626053655e+02,     9.907619062733685e+02,     9.914283274345748e+02,     9.920918544659376e+02,     9.927525153172719e+02, 
            9.934103375199942e+02,     9.940653481956311e+02,     9.947175740641118e+02,     9.953670409766825e+02,     9.960137758061592e+02, 
            9.966578036580102e+02,     9.972991497245391e+02,     9.979378388348557e+02,     9.985738954619848e+02,     9.992073437298071e+02, 
            9.998382074198214e+02,     1.000466509977744e+03,     1.001092274519950e+03,     1.001715523839753e+03,     1.002336280413537e+03, 
            1.002954566406739e+03,     1.003570403679692e+03,     1.004183813793326e+03,     1.004794818014732e+03,     1.005403437322605e+03, 
            1.006009692412545e+03,     1.006613603702251e+03,     1.007215191336579e+03,     1.007814475192494e+03,     1.008411474883906e+03, 
            1.009006209766390e+03,     1.009598698941812e+03,     1.010188961262833e+03,     1.010777015337324e+03,     1.011362879532680e+03, 
            1.011946571980036e+03,     1.012528110578388e+03,     1.013107512998629e+03,     1.013684796687488e+03,     1.014259978871393e+03, 
            1.014833076560237e+03,     1.015404106551079e+03,     1.015973085431747e+03,     1.016540029584380e+03,     1.017104955188881e+03, 
            1.017667878226308e+03,     1.018228814482183e+03,     1.018787779549743e+03,     1.019344788833107e+03,     1.019899857550393e+03, 
            1.020453000736761e+03,     1.021004233247392e+03,     1.021553569760415e+03,     1.022101024779761e+03,     1.022646612637971e+03, 
            1.023190347498938e+03,     1.023732243360595e+03,     1.024272314057557e+03,     1.024810573263698e+03,     1.025347034494684e+03, 
            1.025881711110454e+03,     1.026414616317649e+03,     1.026945763171998e+03,     1.027475164580658e+03,     1.028002833304496e+03, 
            1.028528781960343e+03,     1.029053023023194e+03,     1.029575568828369e+03,     1.030096431573630e+03,     1.030615623321261e+03, 
            1.031133156000105e+03,     1.031649041407563e+03,     1.032163291211559e+03,     1.032675916952460e+03,     1.033186930044970e+03, 
            1.033696341779980e+03,     1.034204163326384e+03,     1.034710405732871e+03,     1.035215079929671e+03,     1.035718196730278e+03, 
            1.036219766833137e+03,     1.036719800823302e+03,     1.037218309174063e+03,     1.037715302248542e+03,     1.038210790301266e+03, 
            1.038704783479704e+03,     1.039197291825780e+03,     1.039688325277363e+03,     1.040177893669721e+03,     1.040666006736961e+03, 
            1.041152674113432e+03,     1.041637905335112e+03,     1.042121709840964e+03,     1.042604096974280e+03,     1.043085075983981e+03, 
            1.043564656025918e+03,     1.044042846164134e+03,     1.044519655372111e+03,     1.044995092533992e+03,     1.045469166445791e+03, 
            1.045941885816568e+03,     1.046413259269600e+03,     1.046883295343516e+03,     1.047352002493428e+03,     1.047819389092033e+03, 
            1.048285463430699e+03,     1.048750233720538e+03,     1.049213708093452e+03,     1.049675894603169e+03,     1.050136801226261e+03, 
            1.050596435863139e+03,     1.051054806339044e+03,     1.051511920405009e+03,     1.051967785738810e+03,     1.052422409945907e+03, 
            1.052875800560362e+03,     1.053327965045748e+03,     1.053778910796037e+03,     1.054228645136482e+03,     1.054677175324476e+03, 
            1.055124508550410e+03,     1.055570651938500e+03,     1.056015612547617e+03,     1.056459397372096e+03,     1.056902013342531e+03, 
            1.057343467326565e+03,     1.057783766129660e+03,     1.058222916495860e+03,     1.058660925108538e+03,     1.059097798591136e+03, 
            1.059533543507892e+03,     1.059968166364554e+03,     1.060401673609083e+03,     1.060834071632352e+03,     1.061265366768825e+03, 
            1.061695565297231e+03,     1.062124673441226e+03,     1.062552697370050e+03,     1.062979643199165e+03,     1.063405516990892e+03, 
            1.063830324755034e+03,     1.064254072449489e+03,     1.064676765980861e+03,     1.065098411205052e+03,     1.065519013927853e+03, 
            1.065938579905521e+03,     1.066357114845353e+03,     1.066774624406247e+03,     1.067191114199258e+03,     1.067606589788141e+03, 
            1.068021056689896e+03,     1.068434520375293e+03,     1.068846986269401e+03,     1.069258459752096e+03,     1.069668946158580e+03, 
            1.070078450779873e+03,     1.070486978863312e+03,     1.070894535613039e+03,     1.071301126190479e+03,     1.071706755714814e+03, 
            1.072111429263452e+03,     1.072515151872485e+03,     1.072917928537146e+03,     1.073319764212254e+03,     1.073720663812659e+03, 
            1.074120632213674e+03,     1.074519674251507e+03,     1.074917794723684e+03,     1.075314998389467e+03,     1.075711289970268e+03, 
            1.076106674150051e+03,     1.076501155575737e+03,     1.076894738857603e+03,     1.077287428569661e+03,     1.077679229250057e+03, 
            1.078070145401441e+03,     1.078460181491345e+03,     1.078849341952557e+03,     1.079237631183478e+03,     1.079625053548490e+03, 
            1.080011613378306e+03,     1.080397314970323e+03,     1.080782162588969e+03,     1.081166160466042e+03,     1.081549312801049e+03, 
            1.081931623761542e+03,     1.082313097483437e+03,     1.082693738071349e+03,     1.083073549598903e+03,     1.083452536109059e+03, 
            1.083830701614414e+03,     1.084208050097518e+03,     1.084584585511172e+03,     1.084960311778735e+03,     1.085335232794408e+03, 
            1.085709352423543e+03,     1.086082674502916e+03,     1.086455202841025e+03,     1.086826941218361e+03,     1.087197893387693e+03, 
            1.087568063074339e+03,     1.087937453976439e+03,     1.088306069765224e+03,     1.088673914085273e+03,     1.089040990554786e+03, 
            1.089407302765830e+03,     1.089772854284603e+03,     1.090137648651680e+03,     1.090501689382263e+03,     1.090864979966428e+03, 
            1.091227523869365e+03,     1.091589324531620e+03,     1.091950385369330e+03,     1.092310709774457e+03,     1.092670301115018e+03, 
            1.093029162735317e+03,     1.093387297956165e+03,     1.093744710075109e+03,     1.094101402366644e+03,     1.094457378082439e+03, 
            1.094812640451545e+03,     1.095167192680612e+03,     1.095521037954097e+03,     1.095874179434470e+03,     1.096226620262421e+03, 
            1.096578363557062e+03,     1.096929412416127e+03,     1.097279769916169e+03,     1.097629439112756e+03,     1.097978423040665e+03, 
            1.098326724714071e+03,     1.098674347126739e+03,     1.099021293252207e+03,     1.099367566043971e+03,     1.099713168435673e+03, 
            1.100058103341269e+03,     1.100402373655222e+03,     1.100745982252667e+03,     1.101088931989589e+03,     1.101431225702997e+03, 
            1.101772866211089e+03,     1.102113856313428e+03,     1.102454198791099e+03,     1.102793896406883e+03,     1.103132951905411e+03, 
            1.103471368013333e+03,     1.103809147439470e+03,     1.104146292874975e+03,     1.104482806993489e+03,     1.104818692451293e+03, 
            1.105153951887459e+03,     1.105488587924004e+03,     1.105822603166036e+03,     1.106156000201904e+03,     1.106488781603339e+03, 
            1.106820949925602e+03,     1.107152507707624e+03,     1.107483457472149e+03,     1.107813801725870e+03,     1.108143542959570e+03, 
            1.108472683648258e+03,     1.108801226251300e+03,     1.109129173212559e+03,     1.109456526960519e+03,     1.109783289908424e+03, 
            1.110109464454398e+03,     1.110435052981581e+03,     1.110760057858252e+03,     1.111084481437951e+03,     1.111408326059610e+03, 
            1.111731594047666e+03,     1.112054287712192e+03,     1.112376409349009e+03,     1.112697961239810e+03,     1.113018945652271e+03, 
            1.113339364840177e+03,     1.113659221043525e+03,     1.113978516488648e+03,     1.114297253388321e+03,     1.114615433941876e+03
    },
    {
            1.727752453570448e+00,     5.234322764047036e+00,     8.806851728075163e+00,     1.244849791934681e+01,     1.616266748016079e+01, 
            1.995304102996796e+01,     2.382360437932605e+01,     2.777868372833431e+01,     3.182298616312304e+01,     3.596164645487599e+01, 
            4.020028139116726e+01,     4.454505316372651e+01,     4.900274371255904e+01,     5.358084241300662e+01,     5.828765012787274e+01, 
            6.313240348465300e+01,     6.812542435401565e+01,     7.327830100875907e+01,     7.860410949085967e+01,     8.411768654175447e+01, 
            8.983596940873268e+01,     9.577842346456811e+01,     1.019675867036364e+02,     1.084297721344445e+02,     1.151959870390093e+02, 
            1.223031556278120e+02,     1.297957750153098e+02,     1.377282045789500e+02,     1.461679064395283e+02,     1.552001580463177e+02, 
            1.649351267139475e+02,     1.755188968545205e+02,     1.871514564495588e+02,     2.001177226784489e+02,     2.148449851770800e+02, 
            2.320195810587696e+02,     2.528558403182624e+02,     2.798406971923058e+02,     3.194806311986698e+02,     3.986709427442210e+02, 
            5.399688345949725e+02,     5.972527153201162e+02,     6.276359697548560e+02,     6.485241080096431e+02,     6.645732258371942e+02, 
            6.776894730508917e+02,     6.888353267868084e+02,     6.985639376744805e+02,     7.072223580236024e+02,     7.150425914111881e+02, 
            7.221873888298600e+02,     7.287753454898409e+02,     7.348955914648825e+02,     7.406168525944646e+02,     7.459932820955959e+02, 
            7.510683491559588e+02,     7.558775109840713e+02,     7.604500970549017e+02,     7.648106681848228e+02,     7.689800165584516e+02, 
            7.729759147564340e+02,     7.768136858070709e+02,     7.805066433283080e+02,     7.840664358464019e+02,     7.875033193917511e+02, 
            7.908263756872456e+02,     7.940436885529788e+02,     7.971624878556640e+02,     8.001892679820087e+02,     8.031298861183797e+02, 
            8.059896443778213e+02,     8.087733588969943e+02,     8.114854183385962e+02,     8.141298337156618e+02,     8.167102810581883e+02, 
            8.192301381377077e+02,     8.216925162289037e+02,     8.241002877022504e+02,     8.264561100957999e+02,     8.287624471983677e+02, 
            8.310215875838169e+02,     8.332356609616485e+02,     8.354066526488097e+02,     8.375364164185896e+02,     8.396266859422559e+02, 
            8.416790850060829e+02,     8.436951366590296e+02,     8.456762714236562e+02,     8.476238346838832e+02,     8.495390933472819e+02, 
            8.514232418662776e+02,     8.532774076912276e+02,     8.551026562188447e+02,     8.568999952912092e+02,     8.586703792936472e+02, 
            8.604147128937885e+02,     8.621338544589531e+02,     8.638286191845839e+02,     8.654997819626265e+02,     8.671480800153989e+02, 
            8.687742153176227e+02,     8.703788568267546e+02,     8.719626425395467e+02,     8.735261813908577e+02,     8.750700550089855e+02, 
            8.765948193403724e+02,     8.781010061551411e+02,     8.795891244438211e+02,     8.810596617145403e+02,     8.825130851990829e+02, 
            8.839498429753770e+02,     8.853703650132559e+02,     8.867750641497096e+02,     8.881643369992310e+02,     8.895385648043806e+02, 
            8.908981142312065e+02,     8.922433381137542e+02,     8.935745761515218e+02,     8.948921555633806e+02,     8.961963917011745e+02, 
            8.974875886259493e+02,     8.987660396495050e+02,     9.000320278437391e+02,     9.012858265200524e+02,     9.025276996809093e+02, 
            9.037579024454612e+02,     9.049766814543767e+02,     9.061842752852737e+02,     9.073809147950585e+02,     9.085668234313817e+02, 
            9.097422164052452e+02,     9.109073046941852e+02,     9.120622907502891e+02,     9.132073713607466e+02,     9.143427371576211e+02, 
            9.154685736273987e+02,     9.165850601615572e+02,     9.176923710877302e+02,     9.187906756693784e+02,     9.198801383044425e+02, 
            9.209609187142605e+02,     9.220331721233283e+02,     9.230970494304227e+02,     9.241526973715903e+02,     9.252002586754541e+02, 
            9.262398722112750e+02,     9.272716731301684e+02,     9.282957929998583e+02,     9.293123599231860e+02,     9.303214986992789e+02, 
            9.313233308863902e+02,     9.323179749486991e+02,     9.333055463553483e+02,     9.342861576830859e+02,     9.352599187144882e+02, 
            9.362269365320049e+02,     9.371873156080292e+02,     9.381411578705819e+02,     9.390885628837834e+02,     9.400296277424344e+02, 
            9.409644473219106e+02,     9.418931142697626e+02,     9.428157190909483e+02,     9.437323502151132e+02,     9.446430940612091e+02, 
            9.455480350995863e+02,     9.464472559116724e+02,     9.473408372473509e+02,     9.482288580801443e+02,     9.491113956603149e+02, 
            9.499885255659487e+02,     9.508603217521536e+02,     9.517268565984165e+02,     9.525882009542343e+02,     9.534444242033406e+02, 
            9.542955942238762e+02,     9.551417775542670e+02,     9.559830393480554e+02,     9.568194434333527e+02,     9.576510523494914e+02, 
            9.584779273824118e+02,     9.593001285988194e+02,     9.601177148791625e+02,     9.609307439494929e+02,     9.617392724122400e+02, 
            9.625433557759545e+02,     9.633430484840572e+02,     9.641384039426318e+02,     9.649294745473047e+02,     9.657163117092468e+02, 
            9.664989658803240e+02,     9.672774865774473e+02,     9.680519224061313e+02,     9.688223210833066e+02,     9.695887294594195e+02, 
            9.703511935398224e+02,     9.711097585055069e+02,     9.718644687331953e+02,     9.726153678148064e+02,     9.733624985763323e+02, 
            9.741059030961387e+02,     9.748456227227124e+02,     9.755816980918764e+02,     9.763141691434954e+02,     9.770430751376798e+02, 
            9.777684546705198e+02,     9.784903456893508e+02,     9.792087855075877e+02,     9.799238108191137e+02,     9.806354577122739e+02, 
            9.813437616834551e+02,     9.820487576502879e+02,     9.827504799644751e+02,     9.834489624242598e+02,     9.841442382865467e+02, 
            9.848363402786880e+02,     9.855253006099427e+02,     9.862111509826273e+02,     9.868939226029559e+02,     9.875736461915960e+02, 
            9.882503519939274e+02,     9.889240697900453e+02,     9.895948289044776e+02,     9.902626582156599e+02,     9.909275861651520e+02, 
            9.915896407666226e+02,     9.922488496145916e+02,     9.929052398929505e+02,     9.935588379104230e+02,     9.942096709817216e+02, 
            9.948577646528335e+02,     9.955031445460572e+02,     9.961458359125123e+02,     9.967858636394387e+02,     9.974232522573210e+02, 
            9.980580259468317e+02,     9.986902085456082e+02,     9.993198235548570e+02,     9.999468941458019e+02,     1.000571443165979e+03, 
            1.001193493145369e+03,     1.001813066302393e+03,     1.002430184549765e+03,     1.003044869500192e+03,     1.003657142471961e+03, 
            1.004267024494375e+03,     1.004874536313069e+03,     1.005479698395212e+03,     1.006082530934571e+03,     1.006683053856472e+03, 
            1.007281286822639e+03,     1.007877249235929e+03,     1.008470960244956e+03,     1.009062438748608e+03,     1.009651703400470e+03, 
            1.010238772613140e+03,     1.010823664562457e+03,     1.011406397191624e+03,     1.011986988215253e+03,     1.012565455123312e+03, 
            1.013141815184989e+03,     1.013716085452473e+03,     1.014288282764652e+03,     1.014858423750729e+03,     1.015426524833766e+03, 
            1.015992602234146e+03,     1.016556671972966e+03,     1.017118749875359e+03,     1.017678851573738e+03,     1.018236992510985e+03, 
            1.018793187943561e+03,     1.019347452944557e+03,     1.019899802406685e+03,     1.020450251045200e+03,     1.020998813400768e+03, 
            1.021545503842276e+03,     1.022090336569574e+03,     1.022633325616182e+03,     1.023174484851919e+03,     1.023713827985498e+03, 
            1.024251368567059e+03,     1.024787119990653e+03,     1.025321095496683e+03,     1.025853308174286e+03,     1.026383770963678e+03, 
            1.026912496658450e+03,     1.027439497907817e+03,     1.027964787218824e+03,     1.028488376958513e+03,     1.029010279356046e+03, 
            1.029530506504783e+03,     1.030049070364330e+03,     1.030565982762539e+03,     1.031081255397475e+03,     1.031594899839342e+03, 
            1.032106927532383e+03,     1.032617349796726e+03,     1.033126177830216e+03,     1.033633422710201e+03,     1.034139095395283e+03, 
            1.034643206727049e+03,     1.035145767431755e+03,     1.035646788121994e+03,     1.036146279298322e+03,     1.036644251350860e+03, 
            1.037140714560869e+03,     1.037635679102287e+03,     1.038129155043256e+03,     1.038621152347601e+03,     1.039111680876297e+03, 
            1.039600750388908e+03,     1.040088370544995e+03,     1.040574550905506e+03,     1.041059300934132e+03,     1.041542629998656e+03, 
            1.042024547372259e+03,     1.042505062234817e+03,     1.042984183674172e+03,     1.043461920687377e+03,     1.043938282181925e+03, 
            1.044413276976960e+03,     1.044886913804452e+03,     1.045359201310375e+03,     1.045830148055840e+03,     1.046299762518234e+03, 
            1.046768053092318e+03,     1.047235028091324e+03,     1.047700695748021e+03,     1.048165064215767e+03,     1.048628141569553e+03, 
            1.049089935807013e+03,     1.049550454849432e+03,     1.050009706542729e+03,     1.050467698658428e+03,     1.050924438894612e+03, 
            1.051379934876859e+03,     1.051834194159170e+03,     1.052287224224876e+03,     1.052739032487527e+03,     1.053189626291780e+03, 
            1.053639012914260e+03,     1.054087199564412e+03,     1.054534193385341e+03,     1.054980001454636e+03,     1.055424630785184e+03, 
            1.055868088325970e+03,     1.056310380962861e+03,     1.056751515519386e+03,     1.057191498757492e+03,     1.057630337378303e+03, 
            1.058068038022856e+03,     1.058504607272828e+03,     1.058940051651254e+03,     1.059374377623237e+03,     1.059807591596637e+03, 
            1.060239699922760e+03,     1.060670708897035e+03,     1.061100624759670e+03,     1.061529453696319e+03,     1.061957201838714e+03, 
            1.062383875265308e+03,     1.062809480001899e+03,     1.063234022022245e+03,     1.063657507248676e+03,     1.064079941552682e+03, 
            1.064501330755516e+03,     1.064921680628766e+03,     1.065340996894927e+03,     1.065759285227975e+03,     1.066176551253909e+03, 
            1.066592800551311e+03,     1.067008038651878e+03,     1.067422271040960e+03,     1.067835503158081e+03,     1.068247740397458e+03, 
            1.068658988108511e+03,     1.069069251596362e+03,     1.069478536122339e+03,     1.069886846904453e+03,     1.070294189117891e+03, 
            1.070700567895482e+03,     1.071105988328170e+03,     1.071510455465476e+03,     1.071913974315949e+03,     1.072316549847623e+03, 
            1.072718186988449e+03,     1.073118890626741e+03,     1.073518665611603e+03,     1.073917516753352e+03,     1.074315448823943e+03, 
            1.074712466557374e+03,     1.075108574650102e+03,     1.075503777761438e+03,     1.075898080513949e+03,     1.076291487493846e+03, 
            1.076684003251373e+03,     1.077075632301187e+03,     1.077466379122730e+03,     1.077856248160608e+03,     1.078245243824948e+03, 
            1.078633370491766e+03,     1.079020632503322e+03,     1.079407034168466e+03,     1.079792579762993e+03,     1.080177273529981e+03, 
            1.080561119680130e+03,     1.080944122392096e+03,     1.081326285812819e+03,     1.081707614057850e+03,     1.082088111211671e+03, 
            1.082467781328009e+03,     1.082846628430155e+03,     1.083224656511265e+03,     1.083601869534671e+03,     1.083978271434179e+03, 
            1.084353866114365e+03,     1.084728657450870e+03,     1.085102649290690e+03,     1.085475845452459e+03,     1.085848249726734e+03, 
            1.086219865876274e+03,     1.086590697636313e+03,     1.086960748714830e+03,     1.087330022792826e+03,     1.087698523524581e+03, 
            1.088066254537915e+03,     1.088433219434455e+03,     1.088799421789881e+03,     1.089164865154185e+03,     1.089529553051917e+03, 
            1.089893488982431e+03,     1.090256676420130e+03,     1.090619118814704e+03,     1.090980819591369e+03,     1.091341782151101e+03, 
            1.091702009870865e+03,     1.092061506103850e+03,     1.092420274179688e+03,     1.092778317404681e+03,     1.093135639062022e+03, 
            1.093492242412011e+03,     1.093848130692272e+03,     1.094203307117965e+03,     1.094557774881997e+03,     1.094911537155231e+03, 
            1.095264597086688e+03,     1.095616957803751e+03,     1.095968622412372e+03,     1.096319593997260e+03,     1.096669875622084e+03, 
            1.097019470329666e+03,     1.097368381142167e+03,     1.097716611061285e+03,     1.098064163068436e+03,     1.098411040124940e+03, 
            1.098757245172205e+03,     1.099102781131907e+03,     1.099447650906167e+03,     1.099791857377732e+03,     1.100135403410145e+03, 
            1.100478291847919e+03,     1.100820525516711e+03,     1.101162107223483e+03,     1.101503039756678e+03,     1.101843325886379e+03, 
            1.102182968364473e+03,     1.102521969924813e+03,     1.102860333283379e+03,     1.103198061138434e+03,     1.103535156170678e+03, 
            1.103871621043405e+03,     1.104207458402657e+03,     1.104542670877370e+03,     1.104877261079528e+03,     1.105211231604307e+03, 
            1.105544585030222e+03,     1.105877323919273e+03,     1.106209450817085e+03,     1.106540968253051e+03,     1.106871878740472e+03, 
            1.107202184776693e+03,     1.107531888843243e+03,     1.107860993405965e+03,     1.108189500915157e+03,     1.108517413805697e+03, 
            1.108844734497177e+03,     1.109171465394035e+03,     1.109497608885680e+03,     1.109823167346618e+03,     1.110148143136580e+03, 
            1.110472538600643e+03,     1.110796356069358e+03,     1.111119597858865e+03,     1.111442266271017e+03,     1.111764363593498e+03, 
            1.112085892099943e+03,     1.112406854050048e+03,     1.112727251689694e+03,     1.113047087251051e+03,     1.113366362952703e+03
    },
    {
            1.724323106345062e+00,     5.223616214144472e+00,     8.788277223683684e+00,     1.242140952098754e+01,     1.612635744654360e+01, 
            1.990673220770309e+01,     2.376644141353226e+01,     2.770972287081786e+01,     3.174118340440127e+01,     3.586584364212264e+01, 
            4.008918991243840e+01,     4.441723467370815e+01,     4.885658723884351e+01,     5.341453700380482e+01,     5.809915196707772e+01, 
            6.291939608703335e+01,     6.788527003159540e+01,     7.300798122495534e+01,     7.830015092664871e+01,     8.377606859075105e+01, 
            8.945200724767750e+01,     9.534661858324596e+01,     1.014814334617758e+02,     1.078815039582470e+02,     1.145762383098174e+02, 
            1.216005035073568e+02,     1.289961065037855e+02,     1.368138229517595e+02,     1.451162375064030e+02,     1.539818224829573e+02, 
            1.635109684478106e+02,     1.738352141189737e+02,     1.851319665046672e+02,     1.976491834708740e+02,     2.117494248611133e+02, 
            2.279950022083563e+02,     2.473309104174265e+02,     2.715394991560880e+02,     3.046351356762093e+02,     3.586613623651177e+02, 
            4.733248206691807e+02,     5.648810785696527e+02,     6.060561273330711e+02,     6.318404117462088e+02,     6.506977622569356e+02, 
            6.656471127576302e+02,     6.780919336629968e+02,     6.887943147378113e+02,     6.982132375232117e+02,     7.066462276486717e+02, 
            7.142970222734991e+02,     7.213112021923091e+02,     7.277964038503335e+02,     7.338344739616371e+02,     7.394891306241205e+02, 
            7.448109827455961e+02,     7.498409273358336e+02,     7.546125136276056e+02,     7.591536283016499e+02,     7.634877224123668e+02, 
            7.676347215385913e+02,     7.716117123567954e+02,     7.754334684411225e+02,     7.791128584919871e+02,     7.826611672644567e+02, 
            7.860883507647595e+02,     7.894032413182175e+02,     7.926137139552909e+02,     7.957268226216694e+02,     7.987489126088946e+02, 
            8.016857140691093e+02,     8.045424203502952e+02,     8.073237540502495e+02,     8.100340230577946e+02,     8.126771683719426e+02, 
            8.152568051239177e+02,     8.177762579444134e+02,     8.202385915984659e+02,     8.226466376377318e+02,     8.250030176834767e+02, 
            8.273101638450115e+02,     8.295703366913187e+02,     8.317856411234059e+02,     8.339580404381148e+02,     8.360893688276403e+02, 
            8.381813425209984e+02,     8.402355697423320e+02,     8.422535596349056e+02,     8.442367302780981e+02,     8.461864159065602e+02, 
            8.481038734255791e+02,     8.499902883038827e+02,     8.518467799143018e+02,     8.536744063835132e+02,     8.554741690042750e+02, 
            8.572470162568229e+02,     8.589938474804006e+02,     8.607155162309118e+02,     8.624128333564236e+02,     8.640865698185582e+02, 
            8.657374592845900e+02,     8.673662005122808e+02,     8.689734595470356e+02,     8.705598717488451e+02,     8.721260436645916e+02, 
            8.736725547596642e+02,     8.751999590213816e+02,     8.767087864454379e+02,     8.781995444154471e+02,     8.796727189846983e+02, 
            8.811287760682833e+02,     8.825681625530365e+02,     8.839913073319645e+02,     8.853986222692463e+02,     8.867905031013223e+02, 
            8.881673302790617e+02,     8.895294697555830e+02,     8.908772737238652e+02,     8.922110813079375e+02,     8.935312192111098e+02, 
            8.948380023244010e+02,     8.961317342980560e+02,     8.974127080788071e+02,     8.986812064153092e+02,     8.999375023339834e+02, 
            9.011818595873175e+02,     9.024145330770451e+02,     9.036357692792798e+02,     9.048458066319889e+02,     9.060448758529999e+02, 
            9.072331993380180e+02,     9.084109944331012e+02,     9.095784701421961e+02,     9.107358294206164e+02,     9.118832688217633e+02, 
            9.130209795399663e+02,     9.141491464391028e+02,     9.152679491172173e+02,     9.163775619101922e+02,     9.174781540997745e+02, 
            9.185698901113462e+02,     9.196529297020289e+02,     9.207274281396971e+02,     9.217935363734141e+02,     9.228514011957853e+02, 
            9.239011653976861e+02,     9.249429679157815e+02,     9.259769439732536e+02,     9.270032252140910e+02,     9.280219398313086e+02, 
            9.290332126754802e+02,     9.300371654247497e+02,     9.310339166209520e+02,     9.320235818248392e+02,     9.330062737068952e+02, 
            9.339821021453046e+02,     9.349511743197597e+02,     9.359135947820520e+02,     9.368694656207200e+02,     9.378188864359256e+02, 
            9.387619544489703e+02,     9.396987646364388e+02,     9.406294097488984e+02,     9.415539803947511e+02,     9.424725651073848e+02, 
            9.433852504096830e+02,     9.442921208760135e+02,     9.451932591918103e+02,     9.460887462108650e+02,     9.469786610104361e+02, 
            9.478630809442666e+02,     9.487420816935528e+02,     9.496157373358914e+02,     9.504841203128150e+02,     9.513473015964209e+02, 
            9.522053506515080e+02,     9.530583354986359e+02,     9.539063227549354e+02,     9.547493776734636e+02,     9.555875641811660e+02, 
            9.564209449155081e+02,     9.572495812598355e+02,     9.580735333775040e+02,     9.588928602448428e+02,     9.597076196829952e+02, 
            9.605178683886792e+02,     9.613236619639141e+02,     9.621250549447611e+02,     9.629221008291050e+02,     9.637148521035253e+02, 
            9.645033602692891e+02,     9.652876758675022e+02,     9.660678485034460e+02,     9.668439268701397e+02,     9.676159587711504e+02, 
            9.683839911426827e+02,     9.691480700749805e+02,     9.699082408330545e+02,     9.706645478767734e+02,     9.714170348803354e+02, 
            9.721657447511466e+02,     9.729107196481210e+02,     9.736520009994351e+02,     9.743896295197497e+02,     9.751236452269106e+02, 
            9.758540874581680e+02,     9.765809948859085e+02,     9.773044055329335e+02,     9.780243567872877e+02,     9.787408854166684e+02, 
            9.794540275824161e+02,     9.801638188531014e+02,     9.808702942177384e+02,     9.815734880986188e+02,     9.822734343637831e+02, 
            9.829701663391552e+02,     9.836637168203317e+02,     9.843541180840515e+02,     9.850414018993513e+02,     9.857255995384154e+02, 
            9.864067417871388e+02,     9.870848589553964e+02,     9.877599808870470e+02,     9.884321369696665e+02,     9.891013561440260e+02, 
            9.897676669133198e+02,     9.904310973521533e+02,     9.910916751152979e+02,     9.917494269758059e+02,     9.924043806966447e+02, 
            9.930565622708378e+02,     9.937059977569389e+02,     9.943527128341793e+02,     9.949967328099697e+02,     9.956380826272106e+02, 
            9.962767868714241e+02,     9.969128697777005e+02,     9.975463552374856e+02,     9.981772668051935e+02,     9.988056277046614e+02, 
            9.994314608354491e+02,     1.000054788778984e+03,     1.000675633804560e+03,     1.001294017875198e+03,     1.001909962653354e+03, 
            1.002523489506513e+03,     1.003134619512630e+03,     1.003743373465459e+03,     1.004349771879752e+03,     1.004953834996339e+03, 
            1.005555582787087e+03,     1.006155034959757e+03,     1.006752210962734e+03,     1.007347129989664e+03,     1.007939810983976e+03, 
            1.008530272643310e+03,     1.009118533423841e+03,     1.009704611544511e+03,     1.010288524991163e+03,     1.010870291520583e+03, 
            1.011449928664463e+03,     1.012027453733264e+03,     1.012602883820004e+03,     1.013176235803965e+03,     1.013747526354311e+03, 
            1.014316771933638e+03,     1.014883988801441e+03,     1.015449193017520e+03,     1.016012400445291e+03,     1.016573626755055e+03, 
            1.017132887427174e+03,     1.017690197755200e+03,     1.018245572848923e+03,     1.018799027637369e+03,     1.019350576871731e+03, 
            1.019900235128233e+03,     1.020448016810953e+03,     1.020993936154568e+03,     1.021538007227058e+03,     1.022080243932355e+03, 
            1.022620660012925e+03,     1.023159269052318e+03,     1.023696084477653e+03,     1.024231119562058e+03,     1.024764387427068e+03, 
            1.025295901044960e+03,     1.025825673241063e+03,     1.026353716696010e+03,     1.026880043947941e+03,     1.027404667394685e+03, 
            1.027927599295879e+03,     1.028448851775051e+03,     1.028968436821673e+03,     1.029486366293167e+03,     1.030002651916868e+03, 
            1.030517305291967e+03,     1.031030337891398e+03,     1.031541761063703e+03,     1.032051586034855e+03,     1.032559823910057e+03, 
            1.033066485675491e+03,     1.033571582200052e+03,     1.034075124237041e+03,     1.034577122425829e+03,     1.035077587293492e+03, 
            1.035576529256412e+03,     1.036073958621855e+03,     1.036569885589520e+03,     1.037064320253054e+03,     1.037557272601545e+03, 
            1.038048752520992e+03,     1.038538769795738e+03,     1.039027334109892e+03,     1.039514455048712e+03,     1.040000142099973e+03, 
            1.040484404655310e+03,     1.040967252011533e+03,     1.041448693371925e+03,     1.041928737847512e+03,     1.042407394458318e+03, 
            1.042884672134590e+03,     1.043360579718012e+03,     1.043835125962889e+03,     1.044308319537317e+03,     1.044780169024330e+03, 
            1.045250682923031e+03,     1.045719869649700e+03,     1.046187737538889e+03,     1.046654294844491e+03,     1.047119549740797e+03, 
            1.047583510323538e+03,     1.048046184610901e+03,     1.048507580544534e+03,     1.048967705990539e+03,     1.049426568740439e+03, 
            1.049884176512135e+03,     1.050340536950846e+03,     1.050795657630039e+03,     1.051249546052333e+03,     1.051702209650398e+03, 
            1.052153655787838e+03,     1.052603891760059e+03,     1.053052924795119e+03,     1.053500762054573e+03,     1.053947410634297e+03, 
            1.054392877565303e+03,     1.054837169814542e+03,     1.055280294285694e+03,     1.055722257819937e+03,     1.056163067196724e+03, 
            1.056602729134525e+03,     1.057041250291574e+03,     1.057478637266599e+03,     1.057914896599537e+03,     1.058350034772248e+03, 
            1.058784058209206e+03,     1.059216973278188e+03,     1.059648786290951e+03,     1.060079503503897e+03,     1.060509131118731e+03, 
            1.060937675283104e+03,     1.061365142091251e+03,     1.061791537584619e+03,     1.062216867752486e+03,     1.062641138532565e+03, 
            1.063064355811608e+03,     1.063486525425998e+03,     1.063907653162325e+03,     1.064327744757968e+03,     1.064746805901655e+03, 
            1.065164842234020e+03,     1.065581859348159e+03,     1.065997862790163e+03,     1.066412858059653e+03,     1.066826850610316e+03, 
            1.067239845850407e+03,     1.067651849143273e+03,     1.068062865807853e+03,     1.068472901119173e+03,     1.068881960308837e+03, 
            1.069290048565509e+03,     1.069697171035391e+03,     1.070103332822692e+03,     1.070508538990088e+03,     1.070912794559183e+03, 
            1.071316104510952e+03,     1.071718473786194e+03,     1.072119907285964e+03,     1.072520409872007e+03,     1.072919986367179e+03, 
            1.073318641555876e+03,     1.073716380184439e+03,     1.074113206961570e+03,     1.074509126558730e+03,     1.074904143610539e+03, 
            1.075298262715170e+03,     1.075691488434731e+03,     1.076083825295654e+03,     1.076475277789065e+03,     1.076865850371161e+03, 
            1.077255547463571e+03,     1.077644373453726e+03,     1.078032332695210e+03,     1.078419429508114e+03,     1.078805668179385e+03, 
            1.079191052963167e+03,     1.079575588081145e+03,     1.079959277722873e+03,     1.080342126046108e+03,     1.080724137177136e+03, 
            1.081105315211091e+03,     1.081485664212275e+03,     1.081865188214470e+03,     1.082243891221249e+03,     1.082621777206279e+03, 
            1.082998850113624e+03,     1.083375113858045e+03,     1.083750572325288e+03,     1.084125229372380e+03,     1.084499088827914e+03, 
            1.084872154492330e+03,     1.085244430138197e+03,     1.085615919510485e+03,     1.085986626326845e+03,     1.086356554277869e+03, 
            1.086725707027362e+03,     1.087094088212604e+03,     1.087461701444604e+03,     1.087828550308365e+03,     1.088194638363128e+03, 
            1.088559969142626e+03,     1.088924546155332e+03,     1.089288372884700e+03,     1.089651452789408e+03,     1.090013789303592e+03, 
            1.090375385837087e+03,     1.090736245775655e+03,     1.091096372481213e+03,     1.091455769292066e+03,     1.091814439523122e+03, 
            1.092172386466123e+03,     1.092529613389855e+03,     1.092886123540368e+03,     1.093241920141190e+03,     1.093597006393538e+03, 
            1.093951385476522e+03,     1.094305060547357e+03,     1.094658034741563e+03,     1.095010311173167e+03,     1.095361892934902e+03, 
            1.095712783098403e+03,     1.096062984714402e+03,     1.096412500812919e+03,     1.096761334403452e+03,     1.097109488475167e+03, 
            1.097456965997078e+03,     1.097803769918236e+03,     1.098149903167906e+03,     1.098495368655749e+03,     1.098840169271997e+03, 
            1.099184307887629e+03,     1.099527787354545e+03,     1.099870610505734e+03,     1.100212780155446e+03,     1.100554299099360e+03, 
            1.100895170114745e+03,     1.101235395960629e+03,     1.101574979377956e+03,     1.101913923089751e+03,     1.102252229801270e+03, 
            1.102589902200166e+03,     1.102926942956637e+03,     1.103263354723582e+03,     1.103599140136749e+03,     1.103934301814890e+03, 
            1.104268842359903e+03,     1.104602764356981e+03,     1.104936070374760e+03,     1.105268762965453e+03,     1.105600844665004e+03, 
            1.105932317993217e+03,     1.106263185453898e+03,     1.106593449534998e+03,     1.106923112708737e+03,     1.107252177431752e+03, 
            1.107580646145214e+03,     1.107908521274973e+03,     1.108235805231680e+03,     1.108562500410920e+03,     1.108888609193333e+03, 
            1.109214133944746e+03,     1.109539077016295e+03,     1.109863440744545e+03,     1.110187227451617e+03,     1.110510439445307e+03, 
            1.110833079019202e+03,     1.111155148452803e+03,     1.111476650011635e+03,     1.111797585947371e+03,     1.112117958497939e+03
    },
    {
            1.720907559630683e+00,     5.212955425361746e+00,     8.769786978907405e+00,     1.239445146916877e+01,     1.609023267162072e+01, 
            1.986067384243480e+01,     2.370960612098058e+01,     2.764118098145545e+01,     3.165990744955656e+01,     3.577069496441944e+01, 
            3.997890295769533e+01,     4.429039847102710e+01,     4.871162344938768e+01,     5.324967375432963e+01,     5.791239246814552e+01, 
            6.270848074903155e+01,     6.764763040713775e+01,     7.274068358495721e+01,     7.799982656223635e+01,     8.343882693941113e+01, 
            8.907332654173479e+01,     9.492120671537479e+01,     1.010030488482225e+02,     1.073427218641036e+02,     1.139681415779411e+02, 
            1.209122665544014e+02,     1.282144254855688e+02,     1.359221190060475e+02,     1.440935163317621e+02,     1.528009974176108e+02, 
            1.621363162319866e+02,     1.722183696000777e+02,     1.832053324955233e+02,     1.953144874214890e+02,     2.088564661982159e+02, 
            2.242986219265076e+02,     2.423932644459792e+02,     2.644697694078268e+02,     2.932160460635727e+02,     3.352614692909930e+02, 
            4.113992635875195e+02,     5.210009409666110e+02,     5.799518783276505e+02,     6.127359818522601e+02,     6.353038648946638e+02, 
            6.525551168941955e+02,     6.665743010348183e+02,     6.784268557858181e+02,     6.887265954260680e+02,     6.978583445157152e+02, 
            7.060788821841869e+02,     7.135679218277456e+02,     7.204560798345434e+02,     7.268412488370942e+02,     7.327986935547942e+02, 
            7.383875453624198e+02,     7.436551300780542e+02,     7.486399392351650e+02,     7.533737230623285e+02,     7.578829981473793e+02, 
            7.621901551194646e+02,     7.663142868987705e+02,     7.702718178654417e+02,     7.740769886780444e+02,     7.777422347493035e+02, 
            7.812784852383054e+02,     7.846954018429425e+02,     7.880015714391922e+02,     7.912046629359512e+02,     7.943115560936874e+02, 
            7.973284481633242e+02,     8.002609428189514e+02,     8.031141248357029e+02,     8.058926232002492e+02,     8.086006647648537e+02, 
            8.112421201167880e+02,     8.138205429972951e+02,     8.163392043427517e+02,     8.188011218162651e+02,     8.212090855371621e+02, 
            8.235656805883278e+02,     8.258733067796416e+02,     8.281341960640723e+02,     8.303504279369907e+02,     8.325239430955885e+02, 
            8.346565555915164e+02,     8.367499636737678e+02,     8.388057594891570e+02,     8.408254377830388e+02,     8.428104037223652e+02, 
            8.447619799459795e+02,     8.466814129325353e+02,     8.485698787642797e+02,     8.504284883545379e+02,     8.522582921979679e+02, 
            8.540602846951419e+02,     8.558354080966009e+02,     8.575845561059646e+02,     8.593085771769757e+02,     8.610082775352171e+02, 
            8.626844239516834e+02,     8.643377462922959e+02,     8.659689398647738e+02,     8.675786675818724e+02,     8.691675619579958e+02, 
            8.707362269543360e+02,     8.722852396861258e+02,     8.738151520041874e+02,     8.753264919617002e+02,     8.768197651760493e+02, 
            8.782954560946133e+02,     8.797540291725072e+02,     8.811959299695086e+02,     8.826215861727369e+02,     8.840314085510121e+02, 
            8.854257918463047e+02,     8.868051156071593e+02,     8.881697449685879e+02,     8.895200313824655e+02,     8.908563133021703e+02, 
            8.921789168248556e+02,     8.934881562944379e+02,     8.947843348681704e+02,     8.960677450493868e+02,     8.973386691888160e+02, 
            8.985973799566578e+02,     8.998441407874491e+02,     9.010792063132964e+02,     9.023028227913552e+02,     9.035152284394433e+02, 
            9.047166530251169e+02,     9.059073205247753e+02,     9.070874466678302e+02,     9.082572407652253e+02,     9.094169056667325e+02, 
            9.105666378548211e+02,     9.117066284167969e+02,     9.128370621790000e+02,     9.139581186967217e+02,     9.150699722757262e+02, 
            9.161727921792308e+02,     9.172667428247108e+02,     9.183519839711322e+02,     9.194286708971372e+02,     9.204969545707415e+02, 
            9.215569818109848e+02,     9.226088954420188e+02,     9.236528344400421e+02,     9.246889340734726e+02,     9.257173260367432e+02, 
            9.267381385780491e+02,     9.277514966213832e+02,     9.287575218644214e+02,     9.297563329615895e+02,     9.307480455280356e+02, 
            9.317327723072716e+02,     9.327106232336030e+02,     9.336817056052256e+02,     9.346461240520521e+02,     9.356039807172175e+02, 
            9.365553752660500e+02,     9.375004050452460e+02,     9.384391651036987e+02,     9.393717482792908e+02,     9.402982452686774e+02, 
            9.412187446942918e+02,     9.421333331687243e+02,     9.430420953565886e+02,     9.439451140339886e+02,     9.448424701656460e+02, 
            9.457342428790392e+02,     9.466205096403913e+02,     9.475013462223599e+02,     9.483768267742217e+02,     9.492470238691139e+02, 
            9.501120085495388e+02,     9.509718503712263e+02,     9.518266174453986e+02,     9.526763764795329e+02,     9.535211928166717e+02, 
            9.543611304733430e+02,     9.551962521761561e+02,     9.560266193971214e+02,     9.568522923877554e+02,     9.576733302120136e+02, 
            9.584897907781013e+02,     9.593017308692187e+02,     9.601092061732583e+02,     9.609122713115307e+02,     9.617109798665298e+02, 
            9.625053844087864e+02,     9.632955365228485e+02,     9.640814868324229e+02,     9.648632850246979e+02,     9.656409798738985e+02, 
            9.664146192640890e+02,     9.671842502112570e+02,     9.679499188847053e+02,     9.687116706277803e+02,     9.694695499779586e+02, 
            9.702236006863120e+02,     9.709738657363888e+02,     9.717203873625101e+02,     9.724632070675248e+02,     9.732023656400316e+02, 
            9.739379031710829e+02,     9.746698590703979e+02,     9.753982720821077e+02,     9.761231803000252e+02,     9.768446211824859e+02, 
            9.775626315667537e+02,     9.782772476830140e+02,     9.789885051679744e+02,     9.796964390780707e+02,     9.804010839023096e+02, 
            9.811024735747492e+02,     9.818006414866304e+02,     9.824956204981773e+02,     9.831874429500700e+02,     9.838761406746050e+02, 
            9.845617450065535e+02,     9.852442867937224e+02,     9.859237964072416e+02,     9.866003037515625e+02,     9.872738382742049e+02, 
            9.879444289752364e+02,     9.886121044165104e+02,     9.892768927306560e+02,     9.899388211619764e+02,     9.905979179281104e+02, 
            9.912542094757044e+02,     9.919077223058752e+02,     9.925584825321282e+02,     9.932065158880541e+02,     9.938518477348367e+02, 
            9.944945030685651e+02,     9.951345065273741e+02,     9.957718823983989e+02,     9.964066546245673e+02,     9.970388468112170e+02, 
            9.976684822325605e+02,     9.982955838379880e+02,     9.989201742582189e+02,     9.995422758113102e+02,     1.000161910508517e+03, 
            1.000779100060014e+03,     1.001393865880489e+03,     1.002006229094593e+03,     1.002616210542278e+03,     1.003223830783995e+03, 
            1.003829110105787e+03,     1.004432068524249e+03,     1.005032725791393e+03,     1.005631101399384e+03,     1.006227214585180e+03, 
            1.006821084335064e+03,     1.007412729389074e+03,     1.008002168245336e+03,     1.008589419164295e+03,     1.009174500172859e+03, 
            1.009757429068452e+03,     1.010338223422970e+03,     1.010916900586656e+03,     1.011493477691899e+03,     1.012067971656932e+03, 
            1.012640399189465e+03,     1.013210776790241e+03,     1.013779120756504e+03,     1.014345447185407e+03,     1.014909771977335e+03, 
            1.015472110839175e+03,     1.016032479287496e+03,     1.016590892651683e+03,     1.017147366076993e+03,     1.017701914527553e+03, 
            1.018254552789296e+03,     1.018805295472835e+03,     1.019354157016280e+03,     1.019901151687997e+03,     1.020446293589315e+03, 
            1.020989596657170e+03,     1.021531074666706e+03,     1.022070741233815e+03,     1.022608609817634e+03,     1.023144693722989e+03, 
            1.023679006102790e+03,     1.024211559960382e+03,     1.024742368151847e+03,     1.025271443388263e+03,     1.025798798237920e+03, 
            1.026324445128490e+03,     1.026848396349157e+03,     1.027370664052713e+03,     1.027891260257599e+03,     1.028410196849921e+03, 
            1.028927485585419e+03,     1.029443138091410e+03,     1.029957165868680e+03,     1.030469580293350e+03,     1.030980392618707e+03, 
            1.031489613977000e+03,     1.031997255381198e+03,     1.032503327726723e+03,     1.033007841793148e+03,     1.033510808245863e+03, 
            1.034012237637713e+03,     1.034512140410607e+03,     1.035010526897089e+03,     1.035507407321898e+03,     1.036002791803482e+03, 
            1.036496690355499e+03,     1.036989112888280e+03,     1.037480069210274e+03,     1.037969569029472e+03,     1.038457621954782e+03, 
            1.038944237497416e+03,     1.039429425072223e+03,     1.039913193999009e+03,     1.040395553503844e+03,     1.040876512720326e+03, 
            1.041356080690843e+03,     1.041834266367802e+03,     1.042311078614838e+03,     1.042786526208012e+03,     1.043260617836971e+03, 
            1.043733362106105e+03,     1.044204767535680e+03,     1.044674842562943e+03,     1.045143595543226e+03,     1.045611034751010e+03, 
            1.046077168380993e+03,     1.046542004549125e+03,     1.047005551293632e+03,     1.047467816576022e+03,     1.047928808282077e+03, 
            1.048388534222825e+03,     1.048847002135501e+03,     1.049304219684483e+03,     1.049760194462227e+03,     1.050214933990175e+03, 
            1.050668445719655e+03,     1.051120737032763e+03,     1.051571815243233e+03,     1.052021687597293e+03,     1.052470361274507e+03, 
            1.052917843388607e+03,     1.053364140988302e+03,     1.053809261058087e+03,     1.054253210519035e+03,     1.054695996229567e+03, 
            1.055137624986229e+03,     1.055578103524438e+03,     1.056017438519231e+03,     1.056455636585992e+03,     1.056892704281176e+03, 
            1.057328648103014e+03,     1.057763474492219e+03,     1.058197189832666e+03,     1.058629800452074e+03,     1.059061312622672e+03, 
            1.059491732561858e+03,     1.059921066432848e+03,     1.060349320345308e+03,     1.060776500355987e+03,     1.061202612469338e+03, 
            1.061627662638125e+03,     1.062051656764024e+03,     1.062474600698217e+03,     1.062896500241973e+03,     1.063317361147229e+03, 
            1.063737189117150e+03,     1.064155989806690e+03,     1.064573768823144e+03,     1.064990531726691e+03,     1.065406284030924e+03, 
            1.065821031203383e+03,     1.066234778666072e+03,     1.066647531795972e+03,     1.067059295925543e+03,     1.067470076343227e+03, 
            1.067879878293934e+03,     1.068288706979528e+03,     1.068696567559307e+03,     1.069103465150468e+03,     1.069509404828573e+03, 
            1.069914391628010e+03,     1.070318430542438e+03,     1.070721526525238e+03,     1.071123684489945e+03,     1.071524909310691e+03, 
            1.071925205822618e+03,     1.072324578822313e+03,     1.072723033068213e+03,     1.073120573281019e+03,     1.073517204144099e+03, 
            1.073912930303891e+03,     1.074307756370288e+03,     1.074701686917032e+03,     1.075094726482096e+03,     1.075486879568060e+03, 
            1.075878150642487e+03,     1.076268544138286e+03,     1.076658064454077e+03,     1.077046715954552e+03,     1.077434502970822e+03, 
            1.077821429800775e+03,     1.078207500709410e+03,     1.078592719929182e+03,     1.078977091660339e+03,     1.079360620071247e+03, 
            1.079743309298725e+03,     1.080125163448356e+03,     1.080506186594820e+03,     1.080886382782191e+03,     1.081265756024264e+03, 
            1.081644310304849e+03,     1.082022049578078e+03,     1.082398977768703e+03,     1.082775098772393e+03,     1.083150416456021e+03, 
            1.083524934657952e+03,     1.083898657188329e+03,     1.084271587829351e+03,     1.084643730335551e+03,     1.085015088434067e+03, 
            1.085385665824915e+03,     1.085755466181255e+03,     1.086124493149647e+03,     1.086492750350323e+03,     1.086860241377435e+03, 
            1.087226969799309e+03,     1.087592939158700e+03,     1.087958152973034e+03,     1.088322614734659e+03,     1.088686327911078e+03, 
            1.089049295945194e+03,     1.089411522255543e+03,     1.089773010236527e+03,     1.090133763258644e+03,     1.090493784668717e+03, 
            1.090853077790113e+03,     1.091211645922969e+03,     1.091569492344415e+03,     1.091926620308783e+03,     1.092283033047821e+03, 
            1.092638733770912e+03,     1.092993725665278e+03,     1.093348011896184e+03,     1.093701595607147e+03,     1.094054479920136e+03, 
            1.094406667935769e+03,     1.094758162733514e+03,     1.095108967371879e+03,     1.095459084888611e+03,     1.095808518300878e+03, 
            1.096157270605465e+03,     1.096505344778952e+03,     1.096852743777906e+03,     1.097199470539058e+03,     1.097545527979478e+03, 
            1.097890918996765e+03,     1.098235646469210e+03,     1.098579713255976e+03,     1.098923122197268e+03,     1.099265876114504e+03, 
            1.099607977810478e+03,     1.099949430069533e+03,     1.100290235657718e+03,     1.100630397322956e+03,     1.100969917795199e+03, 
            1.101308799786590e+03,     1.101647045991619e+03,     1.101984659087278e+03,     1.102321641733214e+03,     1.102657996571879e+03, 
            1.102993726228684e+03,     1.103328833312143e+03,     1.103663320414023e+03,     1.103997190109488e+03,     1.104330444957240e+03, 
            1.104663087499666e+03,     1.104995120262972e+03,     1.105326545757328e+03,     1.105657366477002e+03,     1.105987584900497e+03, 
            1.106317203490684e+03,     1.106646224694936e+03,     1.106974650945260e+03,     1.107302484658427e+03,     1.107629728236100e+03, 
            1.107956384064962e+03,     1.108282454516842e+03,     1.108607941948839e+03,     1.108932848703446e+03,     1.109257177108673e+03, 
            1.109580929478166e+03,     1.109904108111327e+03,     1.110226715293434e+03,     1.110548753295755e+03,     1.110870224375667e+03
    },
    {
            1.717505728401016e+00,     5.202340086607427e+00,     8.751380366636766e+00,     1.236762270821822e+01,     1.605429153034385e+01, 
            1.981486356346247e+01,     2.365309516441899e+01,     2.757305347920845e+01,     3.157915212510845e+01,     3.567619221627665e+01, 
            3.986940973356550e+01,     4.416453046897522e+01,     4.856783406519173e+01,     5.308622904239358e+01,     5.772734118446711e+01, 
            6.249961828190264e+01,     6.741245505043798e+01,     7.247634313559215e+01,     7.770305257732929e+01,     8.310585309632643e+01, 
            8.869978629410859e+01,     9.450200366231083e+01,     1.005321906698810e+02,     1.068131049107741e+02,     1.133712675611780e+02, 
            1.202378641674929e+02,     1.274499362867699e+02,     1.350519852151660e+02,     1.430981723370080e+02,     1.516554053869618e+02, 
            1.608077771857160e+02,     1.706631385954219e+02,     1.813631699226541e+02,     1.930994526632190e+02,     2.061404078988780e+02, 
            2.208792667731477e+02,     2.379262543510171e+02,     2.583039231818022e+02,     2.839168234624867e+02,     3.188702098519620e+02, 
            3.736777018190158e+02,     4.676585871328826e+02,     5.474668112248669e+02,     5.905064453659719e+02,     6.180415968026090e+02, 
            6.382148204986249e+02,     6.541586091751460e+02,     6.673787747672196e+02,     6.787041020095805e+02,     6.886361968281356e+02, 
            6.975006892153658e+02,     7.055205466135022e+02,     7.128549505153728e+02,     7.196214278007114e+02,     7.259091871747022e+02, 
            7.317875364828211e+02,     7.373114024718860e+02,     7.425250686456220e+02,     7.474647768147253e+02,     7.521605812599321e+02, 
            7.566376979983334e+02,     7.609175049087229e+02,     7.650182953913848e+02,     7.689558548129412e+02,     7.727439074028551e+02, 
            7.763944670153115e+02,     7.799181155683190e+02,     7.833242263855294e+02,     7.866211450739800e+02,     7.898163373208596e+02, 
            7.929165106604271e+02,     7.959277155677596e+02,     7.988554299902448e+02,     8.017046305017848e+02,     8.044798525694184e+02, 
            8.071852418949147e+02,     8.098245983906970e+02,     8.124014140383309e+02,     8.149189056358614e+02,     8.173800432506420e+02, 
            8.197875750446506e+02,     8.221440490202574e+02,     8.244518321392945e+02,     8.267131271915904e+02,     8.289299877271305e+02, 
            8.311043313154279e+02,     8.332379513543552e+02,     8.353325276165754e+02,     8.373896356936071e+02,     8.394107554740898e+02, 
            8.413972787733277e+02,     8.433505162147731e+02,     8.452717034503446e+02,     8.471620067948170e+02,     8.490225283396397e+02, 
            8.508543106031015e+02,     8.526583407666274e+02,     8.544355545407662e+02,     8.561868396991755e+02,     8.579130393143259e+02, 
            8.596149547247009e+02,     8.612933482598321e+02,     8.629489457465379e+02,     8.645824388171354e+02,     8.661944870381172e+02, 
            8.677857198757953e+02,     8.693567385136738e+02,     8.709081175347571e+02,     8.724404064806766e+02,     8.739541312982670e+02, 
            8.754497956832100e+02,     8.769278823294023e+02,     8.783888540918553e+02,     8.798331550702048e+02,     8.812612116192337e+02, 
            8.826734332922249e+02,     8.840702137224152e+02,     8.854519314473555e+02,     8.868189506805477e+02,     8.881716220343535e+02, 
            8.895102831977972e+02,     8.908352595726159e+02,     8.921468648705763e+02,     8.934454016748656e+02,     8.947311619681049e+02, 
            8.960044276293381e+02,     8.972654709021550e+02,     8.985145548411325e+02,     8.997519337652276e+02,     9.009778536271015e+02, 
            9.021925523626393e+02,     9.033962590349978e+02,     9.045891980836694e+02,     9.057715847655196e+02,     9.069436282174764e+02, 
            9.081055309582212e+02,     9.092574898886627e+02,     9.103996954125831e+02,     9.115323324546794e+02,     9.126555804877642e+02, 
            9.137696137493540e+02,     9.148746014475370e+02,     9.159707079567504e+02,     9.170580930040451e+02,     9.181369118464032e+02, 
            9.192073154396105e+02,     9.202694505991615e+02,     9.213234601536476e+02,     9.223694830910487e+02,     9.234076546983115e+02, 
            9.244381066945892e+02,     9.254609673584814e+02,     9.264763616495953e+02,     9.274844113247411e+02,     9.284852350243091e+02, 
            9.294789484534750e+02,     9.304656644281780e+02,     9.314454929364906e+02,     9.324185412947887e+02,     9.333849142285054e+02, 
            9.343447139049780e+02,     9.352980400966798e+02,     9.362449902044033e+02,     9.371856593470651e+02,     9.381201404341956e+02, 
            9.390485242355456e+02,     9.399708994479257e+02,     9.408873527786700e+02,     9.417979689293331e+02,     9.427028307737742e+02, 
            9.436020193348689e+02,     9.444956138598112e+02,     9.453836918729362e+02,     9.462663292265682e+02,     9.471436001499887e+02, 
            9.480155772965863e+02,     9.488823317892957e+02,     9.497439332643763e+02,     9.506004499136226e+02,     9.514519485250618e+02, 
            9.522984945222058e+02,     9.531401520019217e+02,     9.539769837709811e+02,     9.548090513813360e+02,     9.556364151641815e+02, 
            9.564591342628498e+02,     9.572772666645959e+02,     9.580908692312947e+02,     9.588999977291289e+02,     9.597047068572754e+02, 
            9.605050502756499e+02,     9.613010806317404e+02,     9.620928495865677e+02,     9.628804078398066e+02,     9.636638051540913e+02, 
            9.644430903785628e+02,     9.652183114716491e+02,     9.659895155231454e+02,     9.667567487755900e+02,     9.675200566449880e+02, 
            9.682794837408829e+02,     9.690350738858239e+02,     9.697868701342315e+02,     9.705349147906970e+02,     9.712792494277287e+02, 
            9.720199149029681e+02,     9.727569513758951e+02,     9.734903983240414e+02,     9.742202945587237e+02,     9.749466782403243e+02, 
            9.756695868931246e+02,     9.763890574197123e+02,     9.771051261149777e+02,     9.778178286797098e+02,     9.785272002338103e+02, 
            9.792332753291350e+02,     9.799360879619734e+02,     9.806356715851891e+02,     9.813320591200157e+02,     9.820252829675396e+02, 
            9.827153750198572e+02,     9.834023666709409e+02,     9.840862888272053e+02,     9.847671719177891e+02,     9.854450459045705e+02, 
            9.861199402919068e+02,     9.867918841361269e+02,     9.874609060547670e+02,     9.881270337703537e+02,     9.887902959616923e+02, 
            9.894507195356802e+02,     9.901083314423718e+02,     9.907631582357600e+02,     9.914152260816794e+02,     9.920645607655091e+02, 
            9.927111876996825e+02,     9.933551319310078e+02,     9.939964181478103e+02,     9.946350706868980e+02,     9.952711135403498e+02, 
            9.959045703621488e+02,     9.965354644746435e+02,     9.971638188748601e+02,     9.977896562406593e+02,     9.984129989367476e+02, 
            9.990338690205447e+02,     9.996522882479120e+02,     1.000268278078746e+03,     1.000881859682440e+03,     1.001493053943219e+03, 
            1.002101881465354e+03,     1.002708362578248e+03,     1.003312517341410e+03,     1.003914365549320e+03,     1.004513926736171e+03, 
            1.005111220180517e+03,     1.005706264909807e+03,     1.006299079704820e+03,     1.006889683104000e+03,     1.007478093407702e+03, 
            1.008064328682329e+03,     1.008648406764395e+03,     1.009230345264484e+03,     1.009810161571139e+03,     1.010387872854644e+03, 
            1.010963496070751e+03,     1.011537047964304e+03,     1.012108545072800e+03,     1.012678003729863e+03,     1.013245440068659e+03, 
            1.013810870025223e+03,     1.014374309341726e+03,     1.014935773569669e+03,     1.015495278073015e+03,     1.016052838031253e+03, 
            1.016608468442396e+03,     1.017162184125923e+03,     1.017713999725659e+03,     1.018263929712594e+03,     1.018811988387646e+03, 
            1.019358189884370e+03,     1.019902548171611e+03,     1.020445077056103e+03,     1.020985790185015e+03,     1.021524701048456e+03, 
            1.022061822981915e+03,     1.022597169168664e+03,     1.023130752642112e+03,     1.023662586288110e+03,     1.024192682847216e+03, 
            1.024721054916910e+03,     1.025247714953769e+03,     1.025772675275606e+03,     1.026295948063557e+03,     1.026817545364137e+03, 
            1.027337479091255e+03,     1.027855761028185e+03,     1.028372402829513e+03,     1.028887416023033e+03,     1.029400812011614e+03, 
            1.029912602075037e+03,     1.030422797371792e+03,     1.030931408940837e+03,     1.031438447703340e+03,     1.031943924464372e+03, 
            1.032447849914584e+03,     1.032950234631842e+03,     1.033451089082837e+03,     1.033950423624669e+03,     1.034448248506398e+03, 
            1.034944573870567e+03,     1.035439409754703e+03,     1.035932766092787e+03,     1.036424652716696e+03,     1.036915079357628e+03, 
            1.037404055647494e+03,     1.037891591120285e+03,     1.038377695213426e+03,     1.038862377269093e+03,     1.039345646535513e+03, 
            1.039827512168248e+03,     1.040307983231444e+03,     1.040787068699068e+03,     1.041264777456123e+03,     1.041741118299837e+03, 
            1.042216099940842e+03,     1.042689731004317e+03,     1.043162020031131e+03,     1.043632975478953e+03,     1.044102605723348e+03, 
            1.044570919058855e+03,     1.045037923700045e+03,     1.045503627782569e+03,     1.045968039364178e+03,     1.046431166425731e+03, 
            1.046893016872190e+03,     1.047353598533597e+03,     1.047812919166027e+03,     1.048270986452541e+03,     1.048727808004106e+03, 
            1.049183391360522e+03,     1.049637743991306e+03,     1.050090873296592e+03,     1.050542786607991e+03,     1.050993491189457e+03, 
            1.051442994238125e+03,     1.051891302885143e+03,     1.052338424196492e+03,     1.052784365173788e+03,     1.053229132755078e+03, 
            1.053672733815615e+03,     1.054115175168629e+03,     1.054556463566083e+03,     1.054996605699417e+03,     1.055435608200283e+03, 
            1.055873477641261e+03,     1.056310220536577e+03,     1.056745843342799e+03,     1.057180352459528e+03,     1.057613754230076e+03, 
            1.058046054942137e+03,     1.058477260828441e+03,     1.058907378067409e+03,     1.059336412783791e+03,     1.059764371049291e+03, 
            1.060191258883194e+03,     1.060617082252975e+03,     1.061041847074897e+03,     1.061465559214613e+03,     1.061888224487746e+03, 
            1.062309848660462e+03,     1.062730437450048e+03,     1.063149996525460e+03,     1.063568531507884e+03,     1.063986047971274e+03, 
            1.064402551442893e+03,     1.064818047403835e+03,     1.065232541289553e+03,     1.065646038490364e+03,     1.066058544351964e+03, 
            1.066470064175921e+03,     1.066880603220167e+03,     1.067290166699488e+03,     1.067698759785995e+03,     1.068106387609601e+03, 
            1.068513055258485e+03,     1.068918767779547e+03,     1.069323530178867e+03,     1.069727347422142e+03,     1.070130224435134e+03, 
            1.070532166104098e+03,     1.070933177276214e+03,     1.071333262760005e+03,     1.071732427325757e+03,     1.072130675705927e+03, 
            1.072528012595547e+03,     1.072924442652628e+03,     1.073319970498552e+03,     1.073714600718456e+03,     1.074108337861624e+03, 
            1.074501186441861e+03,     1.074893150937866e+03,     1.075284235793603e+03,     1.075674445418662e+03,     1.076063784188619e+03, 
            1.076452256445394e+03,     1.076839866497594e+03,     1.077226618620861e+03,     1.077612517058211e+03,     1.077997566020377e+03, 
            1.078381769686130e+03,     1.078765132202613e+03,     1.079147657685663e+03,     1.079529350220129e+03,     1.079910213860188e+03, 
            1.080290252629656e+03,     1.080669470522294e+03,     1.081047871502110e+03,     1.081425459503661e+03,     1.081802238432345e+03, 
            1.082178212164699e+03,     1.082553384548675e+03,     1.082927759403938e+03,     1.083301340522137e+03,     1.083674131667188e+03, 
            1.084046136575544e+03,     1.084417358956467e+03,     1.084787802492295e+03,     1.085157470838706e+03,     1.085526367624979e+03, 
            1.085894496454248e+03,     1.086261860903762e+03,     1.086628464525128e+03,     1.086994310844570e+03,     1.087359403363160e+03, 
            1.087723745557073e+03,     1.088087340877818e+03,     1.088450192752478e+03,     1.088812304583938e+03,     1.089173679751125e+03, 
            1.089534321609226e+03,     1.089894233489918e+03,     1.090253418701589e+03,     1.090611880529560e+03,     1.090969622236297e+03, 
            1.091326647061629e+03,     1.091682958222962e+03,     1.092038558915484e+03,     1.092393452312372e+03,     1.092747641565002e+03, 
            1.093101129803145e+03,     1.093453920135170e+03,     1.093806015648241e+03,     1.094157419408511e+03,     1.094508134461318e+03, 
            1.094858163831371e+03,     1.095207510522942e+03,     1.095556177520051e+03,     1.095904167786653e+03,     1.096251484266814e+03, 
            1.096598129884896e+03,     1.096944107545734e+03,     1.097289420134811e+03,     1.097634070518432e+03,     1.097978061543897e+03, 
            1.098321396039669e+03,     1.098664076815545e+03,     1.099006106662819e+03,     1.099347488354450e+03,     1.099688224645219e+03, 
            1.100028318271897e+03,     1.100367771953398e+03,     1.100706588390936e+03,     1.101044770268187e+03,     1.101382320251436e+03, 
            1.101719240989731e+03,     1.102055535115034e+03,     1.102391205242368e+03,     1.102726253969966e+03,     1.103060683879416e+03, 
            1.103394497535805e+03,     1.103727697487860e+03,     1.104060286268088e+03,     1.104392266392919e+03,     1.104723640362840e+03, 
            1.105054410662534e+03,     1.105384579761012e+03,     1.105714150111747e+03,     1.106043124152808e+03,     1.106371504306991e+03, 
            1.106699292981940e+03,     1.107026492570286e+03,     1.107353105449768e+03,     1.107679133983356e+03,     1.108004580519376e+03, 
            1.108329447391636e+03,     1.108653736919545e+03,     1.108977451408227e+03,     1.109300593148651e+03,     1.109623164417738e+03
    },
    {
            1.714117528348127e+00,     5.191769889808542e+00,     8.733056766584175e+00,     1.234092219514418e+01,     1.601853241899980e+01, 
            1.976929903386590e+01,     2.359690525795093e+01,     2.750533585889179e+01,     3.149891136729838e+01,     3.558232734845276e+01, 
            3.976069966660385e+01,     4.403961688775225e+01,     4.842520123290991e+01,     5.292417983370895e+01,     5.754396847946204e+01, 
            6.229277061201236e+01,     6.717969506722127e+01,     7.221489704323899e+01,     7.740974808594369e+01,     8.277704265075114e+01, 
            8.833125121635379e+01,     9.408883326942697e+01,     1.000686281702579e+02,     1.062923485906687e+02,     1.127852108901720e+02, 
            1.195767510603629e+02,     1.267018963215439e+02,     1.342023954635355e+02,     1.421287629004276e+02,     1.505429759522787e+02, 
            1.595223052481279e+02,     1.691649025770427e+02,     1.795982108204365e+02,     1.909920948618059e+02,     2.035802628149153e+02, 
            2.176971203778730e+02,     2.338454688919992e+02,     2.528314380732144e+02,     2.760621209838029e+02,     3.062839320353281e+02, 
            3.495825733876016e+02,     4.197396485174801e+02,     5.072146033150317e+02,     5.642295548221995e+02,     5.984827200470796e+02, 
            6.223883509981571e+02,     6.406996264825153e+02,     6.555548381673710e+02,     6.680796962474361e+02,     6.789319316030596e+02, 
            6.885266110890097e+02,     6.971415462951103e+02,     7.049714276310433e+02,     7.121577972922389e+02,     7.188066924805781e+02, 
            7.249995644987465e+02,     7.308003219070512e+02,     7.362600335157791e+02,     7.414201622217532e+02,     7.463148453954344e+02, 
            7.509725386129152e+02,     7.554172236156544e+02,     7.596693114447646e+02,     7.637463281995749e+02,     7.676634430853978e+02, 
            7.714338802432512e+02,     7.750692437166347e+02,     7.785797766488455e+02,     7.819745700844367e+02,     7.852617327263894e+02, 
            7.884485301321521e+02,     7.915414997590830e+02,     7.945465467541788e+02,     7.974690242621112e+02,     8.003138011879810e+02, 
            8.030853197191435e+02,     8.057876444291001e+02,     8.084245044166333e+02,     8.109993296470224e+02,     8.135152824385768e+02, 
            8.159752848620046e+02,     8.183820426809334e+02,     8.207380663509848e+02,     8.230456895058229e+02,     8.253070852867932e+02, 
            8.275242808144636e+02,     8.296991700528590e+02,     8.318335252781005e+02,     8.339290073310195e+02,     8.359871748066452e+02, 
            8.380094923112654e+02,     8.399973378992115e+02,     8.419520097859380e+02,     8.438747324208615e+02,     8.457666619922572e+02, 
            8.476288914271573e+02,     8.494624549410571e+02,     8.512683321854489e+02,     8.530474520352298e+02,     8.548006960529904e+02, 
            8.565289016627931e+02,     8.582328650622446e+02,     8.599133438983968e+02,     8.615710597301031e+02,     8.632067002969867e+02, 
            8.648209216129720e+02,     8.664143499004065e+02,     8.679875833791241e+02,     8.695411939233028e+02,     8.710757285976565e+02, 
            8.725917110833518e+02,     8.740896430030061e+02,     8.755700051531912e+02,     8.770332586520932e+02,     8.784798460092113e+02, 
            8.799101921233660e+02,     8.813247052146918e+02,     8.827237776957749e+02,     8.841077869866320e+02,     8.854770962778138e+02, 
            8.868320552455297e+02,     8.881730007223730e+02,     8.895002573268954e+02,     8.908141380550197e+02,     8.921149448360354e+02, 
            8.934029690556722e+02,     8.946784920485713e+02,     8.959417855635530e+02,     8.971931122317916e+02,     8.984327259796028e+02, 
            8.996608723849378e+02,     9.008777880445600e+02,     9.020837041078730e+02,     9.032788427025573e+02,     9.044634194386566e+02, 
            9.056376430483717e+02,     9.068017164139734e+02,     9.079558356775527e+02,     9.091001912861446e+02,     9.102349680254287e+02, 
            9.113603452463118e+02,     9.124764970802308e+02,     9.135835926438151e+02,     9.146817962335640e+02,     9.157712675110880e+02, 
            9.168521616794797e+02,     9.179246296513105e+02,     9.189888182087263e+02,     9.200448701560834e+02,     9.210929244655422e+02, 
            9.221331164160051e+02,     9.231655777257532e+02,     9.241904366791349e+02,     9.252078182476122e+02,     9.262178441855081e+02, 
            9.272206331946327e+02,     9.282163010108445e+02,     9.292049604384055e+02,     9.301867215226936e+02,     9.311616916326295e+02, 
            9.321299754964655e+02,     9.330916753690011e+02,     9.340468910573388e+02,     9.349957200137744e+02,     9.359382574307904e+02, 
            9.368745962334086e+02,     9.378048272702661e+02,     9.387290392979240e+02,     9.396473190658297e+02,     9.405597513778810e+02, 
            9.414664191516185e+02,     9.423674034751549e+02,     9.432627836619387e+02,     9.441526373034638e+02,     9.450370403200097e+02, 
            9.459160670094956e+02,     9.467897900945453e+02,     9.476582807678274e+02,     9.485216087357571e+02,     9.493798422606270e+02, 
            9.502330482012303e+02,     9.510812920520502e+02,     9.519246379810678e+02,     9.527631488662503e+02,     9.535968863307779e+02, 
            9.544259107770537e+02,     9.552502814195559e+02,     9.560700563165749e+02,     9.568852924008788e+02,     9.576960455093596e+02, 
            9.585023704116866e+02,     9.593043208380227e+02,     9.601019495058271e+02,     9.608953081457912e+02,     9.616844475269311e+02, 
            9.624694174808800e+02,     9.632502669254056e+02,     9.640270438871776e+02,     9.647997955238277e+02,     9.655685681453120e+02, 
            9.663334072346204e+02,     9.670943574678347e+02,     9.678514627335844e+02,     9.686047661519023e+02,     9.693543100925156e+02, 
            9.701001361925796e+02,     9.708422853738930e+02,     9.715807978595909e+02,     9.723157131903545e+02,     9.730470702401432e+02, 
            9.737749072314616e+02,     9.744992617501994e+02,     9.752201707600295e+02,     9.759376706164048e+02,     9.766517970801516e+02, 
            9.773625853306809e+02,     9.780700699788301e+02,     9.787742850793427e+02,     9.794752641430085e+02,     9.801730401484605e+02, 
            9.808676455536532e+02,     9.815591123070294e+02,     9.822474718583804e+02,     9.829327551694175e+02,     9.836149927240544e+02, 
            9.842942145384243e+02,     9.849704501706237e+02,     9.856437287302043e+02,     9.863140788874142e+02,     9.869815284013891e+02, 
            9.876461060333565e+02,     9.883078387262693e+02,     9.889667534808749e+02,     9.896228769013647e+02,     9.902762352032787e+02, 
            9.909268542212113e+02,     9.915747594163270e+02,     9.922199758836829e+02,     9.928625283593764e+02,     9.935024412275112e+02, 
            9.941397385269954e+02,     9.947744439581735e+02,     9.954065808892938e+02,     9.960361723628241e+02,     9.966632411016160e+02, 
            9.972878095149142e+02,     9.979098997042339e+02,     9.985295334690898e+02,     9.991467323125945e+02,     9.997615174469272e+02, 
            1.000373909798669e+03,     1.000983930014024e+03,     1.001591598463906e+03,     1.002196935248924e+03,     1.002799960204243e+03, 
            1.003400692904335e+03,     1.003999152667632e+03,     1.004595358561058e+03,     1.005189329404477e+03,     1.005781083775028e+03, 
            1.006370640011369e+03,     1.006958016217832e+03,     1.007543230268477e+03,     1.008126299811064e+03,     1.008707242270934e+03, 
            1.009286074854815e+03,     1.009862814554533e+03,     1.010437478150651e+03,     1.011010082216030e+03,     1.011580643119311e+03, 
            1.012149177028327e+03,     1.012715699913440e+03,     1.013280227550810e+03,     1.013842775525591e+03,     1.014403359235071e+03, 
            1.014961993891730e+03,     1.015518694526258e+03,     1.016073475990484e+03,     1.016626352960270e+03,     1.017177339938327e+03, 
            1.017726451256990e+03,     1.018273701080920e+03,     1.018819103409770e+03,     1.019362672080779e+03,     1.019904420771333e+03, 
            1.020444363001456e+03,     1.020982512136270e+03,     1.021518881388393e+03,     1.022053483820296e+03,     1.022586332346618e+03, 
            1.023117439736422e+03,     1.023646818615425e+03,     1.024174481468170e+03,     1.024700440640171e+03,     1.025224708339999e+03, 
            1.025747296641345e+03,     1.026268217485036e+03,     1.026787482681010e+03,     1.027305103910265e+03,     1.027821092726756e+03, 
            1.028335460559272e+03,     1.028848218713265e+03,     1.029359378372657e+03,     1.029868950601604e+03,     1.030376946346233e+03, 
            1.030883376436342e+03,     1.031388251587081e+03,     1.031891582400586e+03,     1.032393379367594e+03,     1.032893652869029e+03, 
            1.033392413177555e+03,     1.033889670459102e+03,     1.034385434774369e+03,     1.034879716080298e+03,     1.035372524231516e+03, 
            1.035863868981764e+03,     1.036353759985289e+03,     1.036842206798219e+03,     1.037329218879910e+03,     1.037814805594274e+03, 
            1.038298976211079e+03,     1.038781739907231e+03,     1.039263105768028e+03,     1.039743082788403e+03,     1.040221679874132e+03, 
            1.040698905843037e+03,     1.041174769426153e+03,     1.041649279268887e+03,     1.042122443932154e+03,     1.042594271893489e+03, 
            1.043064771548150e+03,     1.043533951210196e+03,     1.044001819113548e+03,     1.044468383413030e+03,     1.044933652185404e+03, 
            1.045397633430375e+03,     1.045860335071582e+03,     1.046321764957583e+03,     1.046781930862810e+03,     1.047240840488519e+03, 
            1.047698501463719e+03,     1.048154921346091e+03,     1.048610107622885e+03,     1.049064067711809e+03,     1.049516808961904e+03, 
            1.049968338654399e+03,     1.050418664003561e+03,     1.050867792157522e+03,     1.051315730199104e+03,     1.051762485146622e+03, 
            1.052208063954675e+03,     1.052652473514936e+03,     1.053095720656913e+03,     1.053537812148709e+03,     1.053978754697771e+03, 
            1.054418554951623e+03,     1.054857219498586e+03,     1.055294754868493e+03,     1.055731167533392e+03,     1.056166463908234e+03, 
            1.056600650351555e+03,     1.057033733166146e+03,     1.057465718599712e+03,     1.057896612845523e+03,     1.058326422043057e+03, 
            1.058755152278628e+03,     1.059182809586009e+03,     1.059609399947044e+03,     1.060034929292253e+03,     1.060459403501424e+03, 
            1.060882828404204e+03,     1.061305209780673e+03,     1.061726553361910e+03,     1.062146864830564e+03,     1.062566149821395e+03, 
            1.062984413921828e+03,     1.063401662672485e+03,     1.063817901567716e+03,     1.064233136056122e+03,     1.064647371541065e+03, 
            1.065060613381184e+03,     1.065472866890882e+03,     1.065884137340833e+03,     1.066294429958458e+03,     1.066703749928407e+03, 
            1.067112102393034e+03,     1.067519492452859e+03,     1.067925925167030e+03,     1.068331405553775e+03,     1.068735938590851e+03, 
            1.069139529215982e+03,     1.069542182327294e+03,     1.069943902783746e+03,     1.070344695405547e+03,     1.070744564974585e+03, 
            1.071143516234823e+03,     1.071541553892717e+03,     1.071938682617612e+03,     1.072334907042135e+03,     1.072730231762588e+03, 
            1.073124661339331e+03,     1.073518200297162e+03,     1.073910853125693e+03,     1.074302624279714e+03,     1.074693518179562e+03, 
            1.075083539211481e+03,     1.075472691727975e+03,     1.075860980048157e+03,     1.076248408458099e+03,     1.076634981211171e+03, 
            1.077020702528374e+03,     1.077405576598680e+03,     1.077789607579354e+03,     1.078172799596280e+03,     1.078555156744282e+03, 
            1.078936683087437e+03,     1.079317382659387e+03,     1.079697259463649e+03,     1.080076317473916e+03,     1.080454560634357e+03, 
            1.080831992859917e+03,     1.081208618036604e+03,     1.081584440021777e+03,     1.081959462644439e+03,     1.082333689705511e+03, 
            1.082707124978109e+03,     1.083079772207825e+03,     1.083451635112992e+03,     1.083822717384957e+03,     1.084193022688339e+03, 
            1.084562554661296e+03,     1.084931316915778e+03,     1.085299313037786e+03,     1.085666546587619e+03,     1.086033021100129e+03, 
            1.086398740084960e+03,     1.086763707026792e+03,     1.087127925385583e+03,     1.087491398596805e+03,     1.087854130071677e+03, 
            1.088216123197394e+03,     1.088577381337359e+03,     1.088937907831408e+03,     1.089297705996028e+03,     1.089656779124585e+03, 
            1.090015130487533e+03,     1.090372763332639e+03,     1.090729680885184e+03,     1.091085886348182e+03,     1.091441382902582e+03, 
            1.091796173707478e+03,     1.092150261900306e+03,     1.092503650597049e+03,     1.092856342892432e+03,     1.093208341860118e+03, 
            1.093559650552902e+03,     1.093910272002905e+03,     1.094260209221755e+03,     1.094609465200782e+03,     1.094958042911200e+03, 
            1.095305945304287e+03,     1.095653175311567e+03,     1.095999735844989e+03,     1.096345629797104e+03,     1.096690860041238e+03, 
            1.097035429431664e+03,     1.097379340803772e+03,     1.097722596974240e+03,     1.098065200741198e+03,     1.098407154884396e+03, 
            1.098748462165361e+03,     1.099089125327565e+03,     1.099429147096581e+03,     1.099768530180237e+03,     1.100107277268780e+03, 
            1.100445391035021e+03,     1.100782874134496e+03,     1.101119729205608e+03,     1.101455958869785e+03,     1.101791565731618e+03, 
            1.102126552379015e+03,     1.102460921383340e+03,     1.102794675299559e+03,     1.103127816666376e+03,     1.103460348006381e+03, 
            1.103792271826179e+03,     1.104123590616532e+03,     1.104454306852491e+03,     1.104784422993534e+03,     1.105113941483694e+03, 
            1.105442864751690e+03,     1.105771195211059e+03,     1.106098935260283e+03,     1.106426087282915e+03,     1.106752653647702e+03, 
            1.107078636708716e+03,     1.107404038805468e+03,     1.107728862263037e+03,     1.108053109392185e+03,     1.108376782489478e+03
    },
    {
            1.710742875874589e+00,     5.181244529871489e+00,     8.714815565183935e+00,     1.231434889942948e+01,     1.598295375483139e+01, 
            1.972397794985406e+01,     2.354103316596443e+01,     2.743802368948229e+01,     3.141917921945570e+01,     3.548909246393461e+01, 
            3.965276239723943e+01,     4.391564424543517e+01,     4.828370751146751e+01,     5.276350366213784e+01,     5.736224549749862e+01, 
            6.208790073803820e+01,     6.694930303607556e+01,     7.195628450063288e+01,     7.711983499808612e+01,     8.245229506608727e+01, 
            8.796759141769979e+01,     9.368152695437301e+01,     9.961214130510875e+01,     1.057801637027792e+02,     1.122095883271876e+02, 
            1.189284143949841e+02,     1.259696113613623e+02,     1.333723970979612e+02,     1.411839595527409e+02,     1.494618208701783e+02, 
            1.582771546071774e+02,     1.677195572914367e+02,     1.779041107248791e+02,     1.889821887066855e+02,     2.011586559215070e+02, 
            2.147205547343461e+02,     2.300877431700702e+02,     2.479086516796447e+02,     2.692569328785181e+02,     2.960737620148467e+02, 
            3.322268014404401e+02,     3.857793517169146e+02,     4.640593219351588e+02,     5.329074209876620e+02,     5.761141863233997e+02, 
            6.048006543647319e+02,     6.260309534310153e+02,     6.428471952071708e+02,     6.567795000025916e+02,     6.686925975202618e+02, 
            6.791173112749705e+02,     6.884008702706597e+02,     6.967820446611563e+02,     7.044317066841127e+02,     7.114761699129273e+02, 
            7.180113521169823e+02,     7.241117588764297e+02,     7.298363972977929e+02,     7.352327928448212e+02,     7.403397918271388e+02, 
            7.451895625246591e+02,     7.498090534069502e+02,     7.542210750164402e+02,     7.584451156511669e+02,     7.624979653314061e+02, 
            7.663941994430727e+02,     7.701465581593613e+02,     7.737662474136733e+02,     7.772631800952389e+02,     7.806461711767773e+02, 
            7.839230969650716e+02,     7.871010261368758e+02,     7.901863283827843e+02,     7.931847651277492e+02,     7.961015657896679e+02, 
            7.989414922807927e+02,     8.017088938828063e+02,     8.044077541873556e+02,     8.070417314551797e+02,     8.096141934835427e+02, 
            8.121282478654755e+02,     8.145867683615236e+02,     8.169924179754712e+02,     8.193476692221765e+02,     8.216548219925617e+02, 
            8.239160193535611e+02,     8.261332615661431e+02,     8.283084185597922e+02,     8.304432410650670e+02,     8.325393705754332e+02, 
            8.345983482844281e+02,     8.366216231231003e+02,     8.386105590051370e+02,     8.405664413722454e+02,     8.424904831198826e+02, 
            8.443838299728316e+02,     8.462475653711259e+02,     8.480827149191314e+02,     8.498902504440294e+02,     8.516710937042861e+02, 
            8.534261197838197e+02,     8.551561602034008e+02,     8.568620057771157e+02,     8.585444092386310e+02,     8.602040876591597e+02, 
            8.618417246766927e+02,     8.634579725538822e+02,     8.650534540801565e+02,     8.666287643319996e+02,     8.681844723038869e+02, 
            8.697211224211192e+02,     8.712392359446434e+02,     8.727393122769885e+02,     8.742218301775267e+02,     8.756872488945138e+02, 
            8.771360092206247e+02,     8.785685344781082e+02,     8.799852314391012e+02,     8.813864911861438e+02,     8.827726899174903e+02, 
            8.841441897014018e+02,     8.855013391832398e+02,     8.868444742488574e+02,     8.881739186474736e+02,     8.894899845769643e+02, 
            8.907929732342491e+02,     8.920831753332404e+02,     8.933608715927023e+02,     8.946263332152495e+02,     8.958798223432974e+02, 
            8.971215924295251e+02,     8.983518877962377e+02,     8.995709465631971e+02,     9.007789979064364e+02,     9.019762640987744e+02, 
            9.031629602667203e+02,     9.043392954448881e+02,     9.055054716776332e+02,     9.066616850901650e+02,     9.078081259295708e+02, 
            9.089449788018147e+02,     9.100724228968400e+02,     9.111906322024954e+02,     9.122997757079310e+02,     9.134000175970947e+02, 
            9.144915174328902e+02,     9.155744303325361e+02,     9.166489071346288e+02,     9.177150945583666e+02,     9.187731353553872e+02, 
            9.198231684546146e+02,     9.208653291004937e+02,     9.218997489849980e+02,     9.229265563737083e+02,     9.239458762077657e+02, 
            9.249578302947311e+02,     9.259625373028907e+02,     9.269601129102330e+02,     9.279506700211700e+02,     9.289343186797610e+02, 
            9.299111662349663e+02,     9.308813174813112e+02,     9.318448747064705e+02,     9.328019377100610e+02,     9.337526039994548e+02, 
            9.346969687852130e+02,     9.356351250733442e+02,     9.365671637344911e+02,     9.374931735703883e+02,     9.384132413777198e+02, 
            9.393274520095059e+02,     9.402358884341311e+02,     9.411386317921090e+02,     9.420357614507164e+02,     9.429273550565546e+02, 
            9.438134885861700e+02,     9.446942363947912e+02,     9.455696712632795e+02,     9.464398644433719e+02,     9.473048857012856e+02, 
            9.481648033597579e+02,     9.490196843385913e+02,     9.498695941937599e+02,     9.507145971551487e+02,     9.515547561629749e+02, 
            9.523901329029495e+02,     9.532207878402311e+02,     9.540467802522228e+02,     9.548681682602601e+02,     9.556850088602267e+02, 
            9.564973579521601e+02,     9.573052703688609e+02,     9.581087999035732e+02,     9.589079993367543e+02,     9.597029204619715e+02, 
            9.604936141109732e+02,     9.612801301779454e+02,     9.620625176430055e+02,     9.628408245949491e+02,     9.636150982532839e+02, 
            9.643853849895748e+02,     9.651517303481286e+02,     9.659141790660425e+02,     9.666727750926381e+02,     9.674275616083045e+02, 
            9.681785810427748e+02,     9.689258750928515e+02,     9.696694847396034e+02,     9.704094502650557e+02,     9.711458112683868e+02, 
            9.718786066816496e+02,     9.726078747850377e+02,     9.733336532217132e+02,     9.740559790121996e+02,     9.747748885683741e+02, 
            9.754904177070579e+02,     9.762026016632191e+02,     9.769114751028155e+02,     9.776170721352696e+02,     9.783194263256042e+02, 
            9.790185707062387e+02,     9.797145377884704e+02,     9.804073595736310e+02,     9.810970675639521e+02,     9.817836927731354e+02, 
            9.824672657366359e+02,     9.831478165216746e+02,     9.838253747369886e+02,     9.844999695423181e+02,     9.851716291796927e+02, 
            9.858403828754672e+02,     9.865062580372820e+02,     9.871692821189582e+02,     9.878294821692057e+02,     9.884868848397361e+02, 
            9.891415163931723e+02,     9.897934027107552e+02,     9.904425692998612e+02,     9.910890413013277e+02,     9.917328434966041e+02, 
            9.923740003147209e+02,     9.930125358390873e+02,     9.936484738141291e+02,     9.942818376517598e+02,     9.949126504376975e+02, 
            9.955409349376298e+02,     9.961667136032335e+02,     9.967900085780471e+02,     9.974108417032090e+02,     9.980292345230570e+02, 
            9.986452082905984e+02,     9.992587839728535e+02,     9.998699822560726e+02,     1.000478823550836e+03,     1.001085327997035e+03, 
            1.001689515468736e+03,     1.002291405578945e+03,     1.002891017684248e+03,     1.003488370889364e+03,     1.004083484051580e+03, 
            1.004676375785103e+03,     1.005267064465298e+03,     1.005855568232852e+03,     1.006441904997829e+03,     1.007026092443645e+03, 
            1.007608148030959e+03,     1.008188089001470e+03,     1.008765932381641e+03,     1.009341694986340e+03,     1.009915393422404e+03, 
            1.010487044092122e+03,     1.011056663196651e+03,     1.011624266739360e+03,     1.012189870529098e+03,     1.012753490183396e+03, 
            1.013315141131608e+03,     1.013874838617977e+03,     1.014432597704646e+03,     1.014988433274604e+03,     1.015542360034572e+03, 
            1.016094392517831e+03,     1.016644545086988e+03,     1.017192831936698e+03,     1.017739267096313e+03,     1.018283864432502e+03, 
            1.018826637651789e+03,     1.019367600303075e+03,     1.019906765780076e+03,     1.020444147323740e+03,     1.020979758024601e+03, 
            1.021513610825095e+03,     1.022045718521826e+03,     1.022576093767789e+03,     1.023104749074555e+03,     1.023631696814411e+03, 
            1.024156949222453e+03,     1.024680518398648e+03,     1.025202416309856e+03,     1.025722654791810e+03,     1.026241245551060e+03, 
            1.026758200166879e+03,     1.027273530093139e+03,     1.027787246660148e+03,     1.028299361076451e+03,     1.028809884430603e+03, 
            1.029318827692906e+03,     1.029826201717116e+03,     1.030332017242115e+03,     1.030836284893561e+03,     1.031339015185497e+03, 
            1.031840218521941e+03,     1.032339905198443e+03,     1.032838085403612e+03,     1.033334769220621e+03,     1.033829966628682e+03, 
            1.034323687504497e+03,     1.034815941623678e+03,     1.035306738662149e+03,     1.035796088197525e+03,     1.036283999710453e+03, 
            1.036770482585948e+03,     1.037255546114692e+03,     1.037739199494323e+03,     1.038221451830686e+03,     1.038702312139077e+03, 
            1.039181789345460e+03,     1.039659892287664e+03,     1.040136629716556e+03,     1.040612010297204e+03,     1.041086042610007e+03, 
            1.041558735151821e+03,     1.042030096337051e+03,     1.042500134498737e+03,     1.042968857889619e+03,     1.043436274683177e+03, 
            1.043902392974667e+03,     1.044367220782126e+03,     1.044830766047374e+03,     1.045293036636987e+03,     1.045754040343264e+03, 
            1.046213784885177e+03,     1.046672277909296e+03,     1.047129526990715e+03,     1.047585539633951e+03,     1.048040323273830e+03, 
            1.048493885276368e+03,     1.048946232939626e+03,     1.049397373494559e+03,     1.049847314105850e+03,     1.050296061872729e+03, 
            1.050743623829784e+03,     1.051190006947753e+03,     1.051635218134310e+03,     1.052079264234833e+03,     1.052522152033165e+03, 
            1.052963888252357e+03,     1.053404479555413e+03,     1.053843932546004e+03,     1.054282253769189e+03,     1.054719449712115e+03, 
            1.055155526804708e+03,     1.055590491420358e+03,     1.056024349876587e+03,     1.056457108435713e+03,     1.056888773305500e+03, 
            1.057319350639802e+03,     1.057748846539191e+03,     1.058177267051583e+03,     1.058604618172856e+03,     1.059030905847445e+03, 
            1.059456135968947e+03,     1.059880314380701e+03,     1.060303446876373e+03,     1.060725539200524e+03,     1.061146597049168e+03, 
            1.061566626070333e+03,     1.061985631864601e+03,     1.062403619985650e+03,     1.062820595940783e+03,     1.063236565191449e+03, 
            1.063651533153762e+03,     1.064065505199008e+03,     1.064478486654142e+03,     1.064890482802290e+03,     1.065301498883227e+03, 
            1.065711540093864e+03,     1.066120611588717e+03,     1.066528718480378e+03,     1.066935865839972e+03,     1.067342058697611e+03, 
            1.067747302042845e+03,     1.068151600825100e+03,     1.068554959954115e+03,     1.068957384300373e+03,     1.069358878695521e+03, 
            1.069759447932793e+03,     1.070159096767416e+03,     1.070557829917026e+03,     1.070955652062057e+03,     1.071352567846148e+03, 
            1.071748581876525e+03,     1.072143698724395e+03,     1.072537922925318e+03,     1.072931258979586e+03,     1.073323711352592e+03, 
            1.073715284475198e+03,     1.074105982744092e+03,     1.074495810522144e+03,     1.074884772138760e+03,     1.075272871890226e+03, 
            1.075660114040048e+03,     1.076046502819296e+03,     1.076432042426930e+03,     1.076816737030132e+03,     1.077200590764632e+03, 
            1.077583607735025e+03,     1.077965792015090e+03,     1.078347147648100e+03,     1.078727678647133e+03,     1.079107388995373e+03, 
            1.079486282646414e+03,     1.079864363524555e+03,     1.080241635525090e+03,     1.080618102514602e+03,     1.080993768331245e+03, 
            1.081368636785031e+03,     1.081742711658101e+03,     1.082115996705007e+03,     1.082488495652979e+03,     1.082860212202194e+03, 
            1.083231150026044e+03,     1.083601312771395e+03,     1.083970704058843e+03,     1.084339327482977e+03,     1.084707186612621e+03, 
            1.085074284991092e+03,     1.085440626136441e+03,     1.085806213541696e+03,     1.086171050675105e+03,     1.086535140980372e+03, 
            1.086898487876891e+03,     1.087261094759974e+03,     1.087622965001088e+03,     1.087984101948073e+03,     1.088344508925369e+03, 
            1.088704189234237e+03,     1.089063146152976e+03,     1.089421382937137e+03,     1.089778902819741e+03,     1.090135709011481e+03, 
            1.090491804700939e+03,     1.090847193054784e+03,     1.091201877217982e+03,     1.091555860313991e+03,     1.091909145444961e+03, 
            1.092261735691930e+03,     1.092613634115020e+03,     1.092964843753627e+03,     1.093315367626609e+03,     1.093665208732474e+03, 
            1.094014370049566e+03,     1.094362854536248e+03,     1.094710665131081e+03,     1.095057804753004e+03,     1.095404276301512e+03, 
            1.095750082656828e+03,     1.096095226680076e+03,     1.096439711213455e+03,     1.096783539080405e+03,     1.097126713085774e+03, 
            1.097469236015985e+03,     1.097811110639195e+03,     1.098152339705465e+03,     1.098492925946909e+03,     1.098832872077859e+03, 
            1.099172180795019e+03,     1.099510854777619e+03,     1.099848896687571e+03,     1.100186309169612e+03,     1.100523094851464e+03, 
            1.100859256343972e+03,     1.101194796241257e+03,     1.101529717120857e+03,     1.101864021543871e+03,     1.102197712055100e+03, 
            1.102530791183188e+03,     1.102863261440758e+03,     1.103195125324552e+03,     1.103526385315564e+03,     1.103857043879173e+03, 
            1.104187103465280e+03,     1.104516566508433e+03,     1.104845435427965e+03,     1.105173712628112e+03,     1.105501400498147e+03, 
            1.105828501412506e+03,     1.106155017730906e+03,     1.106480951798475e+03,     1.106806305945870e+03,     1.107131082489397e+03
    },
    {
            1.707381688085750e+00,     5.170763704643614e+00,     8.696656155494111e+00,     1.228790180282987e+01,     1.594755397566719e+01, 
            1.967889804013021e+01,     2.348547570209277e+01,     2.737111261246524e+01,     3.133994982943785e+01,     3.539647981405076e+01, 
            3.954558777393622e+01,     4.379259934928870e+01,     4.814333585921586e+01,     5.260417861078914e+01,     5.718214413614297e+01, 
            6.188497269025738e+01,     6.672123294866687e+01,     7.170044663885272e+01,     7.683323788966378e+01,     8.213151348653426e+01, 
            8.760868211562888e+01,     9.327992327004046e+01,     9.916252007551806e+01,     1.052762753221689e+02,     1.116440371502557e+02, 
            1.182923712040277e+02,     1.252524313401719e+02,     1.325611039242798e+02,     1.402625360088573e+02,     1.484102129219901e+02, 
            1.570698407803213e+02,     1.663234378251295e+02,     1.762752960432200e+02,     1.870609345829202e+02,     1.988610291943100e+02, 
            2.119240024859566e+02,     2.266045112052530e+02,     2.434329671711706e+02,     2.632499356274349e+02,     2.874852013352507e+02, 
            3.187637998878530e+02,     3.621019009502745e+02,     4.253682611828690e+02,     4.973080434915340e+02,     5.503657534144179e+02, 
            5.851433311366775e+02,     6.099688985963925e+02,     6.291369065283851e+02,     6.447224543388347e+02,     6.578605134708553e+02, 
            6.692302154400885e+02,     6.792661498779732e+02,     6.882616074023381e+02,     6.964231766014209e+02,     7.039015346011515e+02, 
            7.108097868005067e+02,     7.172349094437939e+02,     7.232451750387675e+02,     7.288951342303950e+02,     7.342290546952845e+02, 
            7.392833538434087e+02,     7.440883568561896e+02,     7.486695912663702e+02,     7.530487563285343e+02,     7.572444598550185e+02, 
            7.612727859635393e+02,     7.651477379949300e+02,     7.688815879981372e+02,     7.724851553970286e+02,     7.759680313546097e+02, 
            7.793387610499713e+02,     7.826049930089395e+02,     7.857736024031494e+02,     7.888507936013451e+02,     7.918421860485734e+02, 
            7.947528866450705e+02,     7.975875511138502e+02,     8.003504363255781e+02,     8.030454451494139e+02,     8.056761650885725e+02, 
            8.082459017175684e+02,     8.107577077478807e+02,     8.132144083982869e+02,     8.156186236262106e+02,     8.179727876802384e+02, 
            8.202791663564674e+02,     8.225398722784456e+02,     8.247568784692014e+02,     8.269320304418151e+02,     8.290670570003620e+02, 
            8.311635799144215e+02,     8.332231226064814e+02,     8.352471179716857e+02,     8.372369154326907e+02,     8.391937873183091e+02, 
            8.411189346427772e+02,     8.430134923523748e+02,     8.448785340975517e+02,     8.467150765813890e+02,     8.485240835289201e+02, 
            8.503064693164465e+02,     8.520631022953194e+02,     8.537948078406043e+02,     8.555023711515876e+02,     8.571865398279919e+02, 
            8.588480262431649e+02,     8.604875097331287e+02,     8.621056386184132e+02,     8.637030320737369e+02,     8.652802818590937e+02, 
            8.668379539243684e+02,     8.683765898984079e+02,     8.698967084723754e+02,     8.713988066862577e+02,     8.728833611265304e+02, 
            8.743508290422353e+02,     8.758016493860366e+02,     8.772362437862114e+02,     8.786550174549857e+02,     8.800583600381517e+02, 
            8.814466464104451e+02,     8.828202374207712e+02,     8.841794805910256e+02,     8.855247107719240e+02,     8.868562507589612e+02, 
            8.881744118713746e+02,     8.894794944967311e+02,     8.907717886035625e+02,     8.920515742333922e+02,     8.933191219910314e+02, 
            8.945746934412481e+02,     8.958185408311882e+02,     8.970509095098206e+02,     8.982720358856538e+02,     8.994821490875595e+02, 
            9.006814708205861e+02,     9.018702164458324e+02,     9.030485940769189e+02,     9.042168056758967e+02,     9.053750471024828e+02, 
            9.065235083618819e+02,     9.076623738400879e+02,     9.087918225274276e+02,     9.099120282310334e+02,     9.110231597769030e+02, 
            9.121253812021446e+02,     9.132188519379883e+02,     9.143037269840737e+02,     9.153801570745152e+02,     9.164482888362105e+02, 
            9.175082649398175e+02,     9.185602242438028e+02,     9.196043019319454e+02,     9.206406296259267e+02,     9.216693355871698e+02, 
            9.226905447197367e+02,     9.237043787646693e+02,     9.247109563892709e+02,     9.257103932920274e+02,     9.267028022714171e+02, 
            9.276882934593733e+02,     9.286669741714974e+02,     9.296389492135470e+02,     9.306043208646920e+02,     9.315631889782857e+02, 
            9.325156510597799e+02,     9.334618023414903e+02,     9.344017358543839e+02,     9.353355424970222e+02,     9.362633111017913e+02, 
            9.371851284985529e+02,     9.381010795758341e+02,     9.390112473396658e+02,     9.399157129701903e+02,     9.408145558761147e+02, 
            9.417078537471408e+02,     9.425956826044343e+02,     9.434781168492324e+02,     9.443552293096750e+02,     9.452270912859316e+02, 
            9.460937725936949e+02,     9.469553416061259e+02,     9.478118652942998e+02,     9.486634092662282e+02,     9.495100378045161e+02, 
            9.503518139027030e+02,     9.511887993003556e+02,     9.520210545169546e+02,     9.528486388846278e+02,     9.536716105797774e+02, 
            9.544900266536471e+02,     9.553039430618676e+02,     9.561134146930265e+02,     9.569184953962992e+02,     9.577192380081761e+02, 
            9.585156943783257e+02,     9.593079153946217e+02,     9.600959510073752e+02,     9.608798502527874e+02,     9.616596612756736e+02, 
            9.624354313514666e+02,     9.632072069075351e+02,     9.639750335438505e+02,     9.647389560530082e+02,     9.654990184396412e+02, 
            9.662552639392476e+02,     9.670077350364459e+02,     9.677564734826886e+02,     9.685015203134382e+02,     9.692429158648494e+02, 
            9.699806997899489e+02,     9.707149110743447e+02,     9.714455880514894e+02,     9.721727684174847e+02,     9.728964892454762e+02, 
            9.736167869996350e+02,     9.743336975487357e+02,     9.750472561793599e+02,     9.757574976087246e+02,     9.764644559971608e+02, 
            9.771681649602353e+02,     9.778686575805501e+02,     9.785659664192129e+02,     9.792601235269969e+02,     9.799511604551992e+02, 
            9.806391082662072e+02,     9.813239975437847e+02,     9.820058584030793e+02,     9.826847205003688e+02,     9.833606125675404e+02, 
            9.840335643025820e+02,     9.847036035844407e+02,     9.853707583263771e+02,     9.860350560278285e+02,     9.866965237827364e+02, 
            9.873551882876592e+02,     9.880110758496804e+02,     9.886642123941197e+02,     9.893146234720483e+02,     9.899623342676191e+02, 
            9.906073696052140e+02,     9.912497539564189e+02,     9.918895114468224e+02,     9.925266658626526e+02,     9.931612406572523e+02, 
            9.937932589573983e+02,     9.944227435694661e+02,     9.950497169854546e+02,     9.956742013888577e+02,     9.962962186604075e+02, 
            9.969157903836746e+02,     9.975329378505409e+02,     9.981476820665467e+02,     9.987600437561085e+02,     9.993700433676212e+02, 
            9.999777010784452e+02,     1.000583036799771e+03,     1.001186070181383e+03,     1.001786820616310e+03,     1.002385307245374e+03, 
            1.002981548961632e+03,     1.003575564414728e+03,     1.004167372015139e+03,     1.004756989938336e+03,     1.005344436128843e+03, 
            1.005929728304219e+03,     1.006512883958946e+03,     1.007093920368234e+03,     1.007672854591745e+03,     1.008249703477238e+03, 
            1.008824483664132e+03,     1.009397211586999e+03,     1.009967903478978e+03,     1.010536575375125e+03,     1.011103243115676e+03, 
            1.011667922349264e+03,     1.012230628536052e+03,     1.012791376950810e+03,     1.013350182685923e+03,     1.013907060654341e+03, 
            1.014462025592470e+03,     1.015015092063003e+03,     1.015566274457684e+03,     1.016115587000036e+03,     1.016663043748018e+03, 
            1.017208658596635e+03,     1.017752445280493e+03,     1.018294417376309e+03,     1.018834588305366e+03,     1.019372971335923e+03, 
            1.019909579585576e+03,     1.020444426023573e+03,     1.020977523473085e+03,     1.021508884613436e+03,     1.022038521982279e+03, 
            1.022566447977746e+03,     1.023092674860549e+03,     1.023617214756032e+03,     1.024140079656206e+03,     1.024661281421722e+03, 
            1.025180831783826e+03,     1.025698742346264e+03,     1.026215024587159e+03,     1.026729689860851e+03,     1.027242749399701e+03, 
            1.027754214315868e+03,     1.028264095603042e+03,     1.028772404138162e+03,     1.029279150683084e+03,     1.029784345886234e+03, 
            1.030288000284221e+03,     1.030790124303428e+03,     1.031290728261572e+03,     1.031789822369231e+03,     1.032287416731355e+03, 
            1.032783521348736e+03,     1.033278146119470e+03,     1.033771300840373e+03,     1.034262995208388e+03,     1.034753238821958e+03, 
            1.035242041182386e+03,     1.035729411695155e+03,     1.036215359671239e+03,     1.036699894328387e+03,     1.037183024792388e+03, 
            1.037664760098301e+03,     1.038145109191689e+03,     1.038624080929803e+03,     1.039101684082770e+03,     1.039577927334748e+03, 
            1.040052819285065e+03,     1.040526368449341e+03,     1.040998583260587e+03,     1.041469472070288e+03,     1.041939043149471e+03, 
            1.042407304689749e+03,     1.042874264804356e+03,     1.043339931529153e+03,     1.043804312823634e+03,     1.044267416571901e+03, 
            1.044729250583631e+03,     1.045189822595023e+03,     1.045649140269736e+03,     1.046107211199807e+03,     1.046564042906551e+03, 
            1.047019642841456e+03,     1.047474018387059e+03,     1.047927176857805e+03,     1.048379125500895e+03,     1.048829871497128e+03, 
            1.049279421961711e+03,     1.049727783945084e+03,     1.050174964433698e+03,     1.050620970350817e+03,     1.051065808557279e+03, 
            1.051509485852259e+03,     1.051952008974019e+03,     1.052393384600645e+03,     1.052833619350769e+03,     1.053272719784291e+03, 
            1.053710692403077e+03,     1.054147543651654e+03,     1.054583279917893e+03,     1.055017907533683e+03,     1.055451432775592e+03, 
            1.055883861865519e+03,     1.056315200971340e+03,     1.056745456207539e+03,     1.057174633635832e+03,     1.057602739265784e+03, 
            1.058029779055413e+03,     1.058455758911788e+03,     1.058880684691617e+03,     1.059304562201824e+03,     1.059727397200127e+03, 
            1.060149195395595e+03,     1.060569962449204e+03,     1.060989703974388e+03,     1.061408425537571e+03,     1.061826132658707e+03, 
            1.062242830811795e+03,     1.062658525425403e+03,     1.063073221883172e+03,     1.063486925524319e+03,     1.063899641644138e+03, 
            1.064311375494475e+03,     1.064722132284220e+03,     1.065131917179780e+03,     1.065540735305540e+03,     1.065948591744335e+03, 
            1.066355491537892e+03,     1.066761439687291e+03,     1.067166441153400e+03,     1.067570500857311e+03,     1.067973623680775e+03, 
            1.068375814466626e+03,     1.068777078019195e+03,     1.069177419104725e+03,     1.069576842451785e+03,     1.069975352751661e+03, 
            1.070372954658760e+03,     1.070769652791002e+03,     1.071165451730201e+03,     1.071560356022448e+03,     1.071954370178490e+03, 
            1.072347498674097e+03,     1.072739745950426e+03,     1.073131116414393e+03,     1.073521614439014e+03,     1.073911244363769e+03, 
            1.074300010494944e+03,     1.074687917105972e+03,     1.075074968437778e+03,     1.075461168699103e+03,     1.075846522066842e+03, 
            1.076231032686365e+03,     1.076614704671839e+03,     1.076997542106546e+03,     1.077379549043191e+03,     1.077760729504219e+03, 
            1.078141087482113e+03,     1.078520626939698e+03,     1.078899351810438e+03,     1.079277265998729e+03,     1.079654373380189e+03, 
            1.080030677801945e+03,     1.080406183082914e+03,     1.080780893014084e+03,     1.081154811358787e+03,     1.081527941852975e+03, 
            1.081900288205484e+03,     1.082271854098303e+03,     1.082642643186835e+03,     1.083012659100156e+03,     1.083381905441272e+03, 
            1.083750385787368e+03,     1.084118103690062e+03,     1.084485062675650e+03,     1.084851266245348e+03,     1.085216717875534e+03, 
            1.085581421017985e+03,     1.085945379100114e+03,     1.086308595525199e+03,     1.086671073672613e+03,     1.087032816898051e+03, 
            1.087393828533757e+03,     1.087754111888737e+03,     1.088113670248986e+03,     1.088472506877699e+03,     1.088830625015485e+03, 
            1.089188027880580e+03,     1.089544718669053e+03,     1.089900700555011e+03,     1.090255976690809e+03,     1.090610550207241e+03, 
            1.090964424213748e+03,     1.091317601798609e+03,     1.091670086029137e+03,     1.092021879951872e+03,     1.092372986592768e+03, 
            1.092723408957385e+03,     1.093073150031067e+03,     1.093422212779135e+03,     1.093770600147061e+03,     1.094118315060647e+03, 
            1.094465360426208e+03,     1.094811739130741e+03,     1.095157454042104e+03,     1.095502508009180e+03,     1.095846903862052e+03, 
            1.096190644412167e+03,     1.096533732452505e+03,     1.096876170757739e+03,     1.097217962084398e+03,     1.097559109171029e+03, 
            1.097899614738352e+03,     1.098239481489417e+03,     1.098578712109762e+03,     1.098917309267563e+03,     1.099255275613785e+03, 
            1.099592613782334e+03,     1.099929326390202e+03,     1.100265416037618e+03,     1.100600885308188e+03,     1.100935736769041e+03, 
            1.101269972970970e+03,     1.101603596448572e+03,     1.101936609720387e+03,     1.102269015289034e+03,     1.102600815641350e+03, 
            1.102932013248521e+03,     1.103262610566214e+03,     1.103592610034713e+03,     1.103922014079044e+03,     1.104250825109107e+03, 
            1.104579045519801e+03,     1.104906677691152e+03,     1.105233723988434e+03,     1.105560186762298e+03,     1.105886068348888e+03
    },
    {
            1.704033882782094e+00,     5.160327114875420e+00,     8.678577937100219e+00,     1.226157989917651e+01,     1.591233153955962e+01, 
            1.963405706527258e+01,     2.343022972820230e+01,     2.730459834023389e+01,     3.126121744716460e+01,     3.530448179471421e+01, 
            3.943916584755816e+01,     4.367046928739963e+01,     4.800406962159836e+01,     5.244618329391676e+01,     5.700363701966257e+01, 
            6.168395149179665e+01,     6.649544015302914e+01,     7.144732644414267e+01,     7.654988388003433e+01,     8.181460455589465e+01, 
            8.725440336596689e+01,     9.288386749917943e+01,     9.871956391297844e+01,     1.047804218561689e+02,     1.110882136844413e+02, 
            1.176681660680658e+02,     1.245497466111758e+02,     1.317676901013538e+02,     1.393633577480699e+02,     1.473865677684464e+02, 
            1.558981078752901e+02,     1.649732569849808e+02,     1.747068420186195e+02,     1.852207013493473e+02,     1.966750556606777e+02, 
            2.092864831149007e+02,     2.233575848755214e+02,     2.393284532041465e+02,     2.578711368480120e+02,     2.800731346666885e+02, 
            3.078053745693087e+02,     3.444002160482292e+02,     3.953257402140903e+02,     4.615759993763533e+02,     5.211397621091714e+02, 
            5.630862945571841e+02,     5.923179967707586e+02,     6.142977805358040e+02,     6.318221640380602e+02,     6.463742127315800e+02, 
            6.588200862534304e+02,     6.697030940418640e+02,     6.793834797772773e+02,     6.881111069101183e+02,     6.960658064973161e+02, 
            7.033810277723064e+02,     7.101583704510011e+02,     7.164768854568970e+02,     7.223992393646756e+02,     7.279759246483810e+02, 
            7.332482105586937e+02,     7.382502582704341e+02,     7.430106670929219e+02,     7.475536246135733e+02,     7.518997756318587e+02, 
            7.560668879046552e+02,     7.600703687537384e+02,     7.639236706432541e+02,     7.676386130223202e+02,     7.712256402647234e+02, 
            7.746940303042744e+02,     7.780520648414910e+02,     7.813071693137424e+02,     7.844660288633928e+02,     7.875346850942281e+02, 
            7.905186173299970e+02,     7.934228112786907e+02,     7.962518173908989e+02,     7.990098007292842e+02,     8.017005838023176e+02, 
            8.043276835322710e+02,     8.068943433056338e+02,     8.094035608789809e+02,     8.118581127743079e+02,     8.142605756866775e+02, 
            8.166133453376763e+02,     8.189186531359026e+02,     8.211785809469462e+02,     8.233950742273231e+02,     8.255699537373117e+02, 
            8.277049260151364e+02,     8.298015927678773e+02,     8.318614593120203e+02,     8.338859421777073e+02,     8.358763759749678e+02, 
            8.378340196068392e+02,     8.397600619030270e+02,     8.416556267381492e+02,     8.435217776904190e+02,     8.453595222896656e+02, 
            8.471698158975336e+02,     8.489535652575826e+02,     8.507116317485220e+02,     8.524448343699415e+02,     8.541539524865831e+02, 
            8.558397283542250e+02,     8.575028694477516e+02,     8.591440506097071e+02,     8.607639160357089e+02,     8.623630811113600e+02, 
            8.639421341137809e+02,     8.655016377895620e+02,     8.670421308197290e+02,     8.685641291812981e+02,     8.700681274140213e+02, 
            8.715545998001476e+02,     8.730240014642375e+02,     8.744767693994384e+02,     8.759133234260318e+02,     8.773340670875303e+02, 
            8.787393884891354e+02,     8.801296610829269e+02,     8.815052444038024e+02,     8.828664847597971e+02,     8.842137158801360e+02, 
            8.855472595240838e+02,     8.868674260533829e+02,     8.881745149708630e+02,     8.894688154309163e+02,     8.907506067523200e+02, 
            8.920201588535253e+02,     8.932777326526872e+02,     8.945235793663805e+02,     8.957579444451809e+02,     8.969810635311691e+02, 
            8.981931650955230e+02,     8.993944710030919e+02,     9.005851956067357e+02,     9.017655468668065e+02,     9.029357264094907e+02, 
            9.040959297858871e+02,     9.052463467179089e+02,     9.063871613318205e+02,     9.075185523801345e+02,     9.086406934525618e+02, 
            9.097537531766654e+02,     9.108578954087959e+02,     9.119532794158790e+02,     9.130400600485822e+02,     9.141183879063284e+02, 
            9.151884094946287e+02,     9.162502673751513e+02,     9.173041002900470e+02,     9.183500433757408e+02,     9.193882281754388e+02, 
            9.204187828443452e+02,     9.214418322483489e+02,     9.224574980970087e+02,     9.234658989757432e+02,     9.244671505805806e+02, 
            9.254613656847907e+02,     9.264486542818902e+02,     9.274291238368338e+02,     9.284028790746609e+02,     9.293700222674593e+02, 
            9.303306532661123e+02,     9.312848695778944e+02,     9.322327664409399e+02,     9.331744368957532e+02,     9.341099718538860e+02, 
            9.350394601639251e+02,     9.359629886749150e+02,     9.368806422973323e+02,     9.377925040617247e+02,     9.386986551751251e+02, 
            9.395991750753394e+02,     9.404941414832030e+02,     9.413836304528961e+02,     9.422677164204125e+02,     9.431464722502473e+02, 
            9.440199692804024e+02,     9.448882773657577e+02,     9.457514649199064e+02,     9.466095989554942e+02,     9.474627451231445e+02, 
            9.483109677490240e+02,     9.491543298710953e+02,     9.499928932741307e+02,     9.508267185235217e+02,     9.516558649979414e+02, 
            9.524803909209065e+02,     9.533003533912780e+02,     9.541158084127517e+02,     9.549268109223731e+02,     9.557334148181139e+02, 
            9.565356729855534e+02,     9.573336373236965e+02,     9.581273587699579e+02,     9.589168873243508e+02,     9.597022720729104e+02, 
            9.604835612103778e+02,     9.612608020621682e+02,     9.620340411056704e+02,     9.628033239908694e+02,     9.635686955603538e+02, 
            9.643301998686987e+02,     9.650878802012712e+02,     9.658417790924668e+02,     9.665919383433926e+02,     9.673383990390425e+02, 
            9.680812015649435e+02,     9.688203856233310e+02,     9.695559902488395e+02,     9.702880538237494e+02,     9.710166140927821e+02, 
            9.717417081774830e+02,     9.724633725901880e+02,     9.731816432475920e+02,     9.738965554839483e+02,     9.746081440638823e+02, 
            9.753164431948633e+02,     9.760214865393217e+02,     9.767233072264370e+02,     9.774219378636063e+02,     9.781174105475961e+02, 
            9.788097568753976e+02,     9.794990079547862e+02,     9.801851944146039e+02,     9.808683464147632e+02,     9.815484931840200e+02, 
            9.822256648985583e+02,     9.828998899152958e+02,     9.835711966133446e+02,     9.842396129491227e+02,     9.849051664649003e+02, 
            9.855678842971220e+02,     9.862277931845191e+02,     9.868849194760202e+02,     9.875392891384547e+02,     9.881909277640771e+02, 
            9.888398605778872e+02,     9.894861124447873e+02,     9.901297078765480e+02,     9.907706710386151e+02,     9.914090257567418e+02, 
            9.920447955234686e+02,     9.926780035044384e+02,     9.933086725445693e+02,     9.939368251740719e+02,     9.945624836143307e+02, 
            9.951856697836411e+02,     9.958064053028177e+02,     9.964247115006633e+02,     9.970406094193188e+02,     9.976541198194874e+02, 
            9.982652631855315e+02,     9.988740597304667e+02,     9.994805294008256e+02,     1.000084691881426e+03,     1.000686566600019e+03, 
            1.001286172731844e+03,     1.001883529204075e+03,     1.002478654700165e+03,     1.003071567664105e+03,     1.003662286304579e+03, 
            1.004250828599031e+03,     1.004837212297646e+03,     1.005421454927241e+03,     1.006003573795072e+03,     1.006583585992561e+03, 
            1.007161508398944e+03,     1.007737357684834e+03,     1.008311150315721e+03,     1.008882902555381e+03,     1.009452630469232e+03, 
            1.010020349927607e+03,     1.010586076608957e+03,     1.011149826003003e+03,     1.011711613413803e+03,     1.012271453962769e+03, 
            1.012829362591621e+03,     1.013385354065273e+03,     1.013939442974668e+03,     1.014491643739556e+03,     1.015041970611208e+03, 
            1.015590437675084e+03,     1.016137058853443e+03,     1.016681847907905e+03,     1.017224818441955e+03,     1.017765983903409e+03, 
            1.018305357586819e+03,     1.018842952635839e+03,     1.019378782045547e+03,     1.019912858664710e+03,     1.020445195198020e+03, 
            1.020975804208277e+03,     1.021504698118531e+03,     1.022031889214194e+03,     1.022557389645090e+03,     1.023081211427495e+03, 
            1.023603366446108e+03,     1.024123866456012e+03,     1.024642723084578e+03,     1.025159947833347e+03,     1.025675552079871e+03, 
            1.026189547079519e+03,     1.026701943967254e+03,     1.027212753759374e+03,     1.027721987355222e+03,     1.028229655538867e+03, 
            1.028735768980752e+03,     1.029240338239311e+03,     1.029743373762563e+03,     1.030244885889670e+03,     1.030744884852471e+03, 
            1.031243380776992e+03,     1.031740383684920e+03,     1.032235903495062e+03,     1.032729950024769e+03,     1.033222532991339e+03, 
            1.033713662013400e+03,     1.034203346612260e+03,     1.034691596213240e+03,     1.035178420146981e+03,     1.035663827650730e+03, 
            1.036147827869607e+03,     1.036630429857840e+03,     1.037111642579992e+03,     1.037591474912160e+03,     1.038069935643153e+03, 
            1.038547033475654e+03,     1.039022777027358e+03,     1.039497174832097e+03,     1.039970235340943e+03,     1.040441966923288e+03, 
            1.040912377867915e+03,     1.041381476384048e+03,     1.041849270602379e+03,     1.042315768576088e+03,     1.042780978281837e+03, 
            1.043244907620759e+03,     1.043707564419414e+03,     1.044168956430751e+03,     1.044629091335037e+03,     1.045087976740778e+03, 
            1.045545620185625e+03,     1.046002029137269e+03,     1.046457210994313e+03,     1.046911173087137e+03,     1.047363922678750e+03, 
            1.047815466965624e+03,     1.048265813078521e+03,     1.048714968083295e+03,     1.049162938981702e+03,     1.049609732712173e+03, 
            1.050055356150598e+03,     1.050499816111083e+03,     1.050943119346695e+03,     1.051385272550211e+03,     1.051826282354834e+03, 
            1.052266155334919e+03,     1.052704898006670e+03,     1.053142516828838e+03,     1.053579018203406e+03,     1.054014408476261e+03, 
            1.054448693937859e+03,     1.054881880823877e+03,     1.055313975315860e+03,     1.055744983541852e+03,     1.056174911577025e+03, 
            1.056603765444290e+03,     1.057031551114910e+03,     1.057458274509092e+03,     1.057883941496583e+03,     1.058308557897243e+03, 
            1.058732129481624e+03,     1.059154661971530e+03,     1.059576161040574e+03,     1.059996632314727e+03,     1.060416081372857e+03, 
            1.060834513747262e+03,     1.061251934924193e+03,     1.061668350344374e+03,     1.062083765403510e+03,     1.062498185452791e+03, 
            1.062911615799387e+03,     1.063324061706936e+03,     1.063735528396029e+03,     1.064146021044682e+03,     1.064555544788805e+03, 
            1.064964104722666e+03,     1.065371705899345e+03,     1.065778353331184e+03,     1.066184051990232e+03,     1.066588806808677e+03, 
            1.066992622679283e+03,     1.067395504455812e+03,     1.067797456953445e+03,     1.068198484949197e+03,     1.068598593182320e+03, 
            1.068997786354713e+03,     1.069396069131312e+03,     1.069793446140489e+03,     1.070189921974436e+03,     1.070585501189543e+03, 
            1.070980188306779e+03,     1.071373987812065e+03,     1.071766904156635e+03,     1.072158941757403e+03,     1.072550104997314e+03, 
            1.072940398225705e+03,     1.073329825758648e+03,     1.073718391879290e+03,     1.074106100838196e+03,     1.074492956853687e+03, 
            1.074878964112162e+03,     1.075264126768426e+03,     1.075648448946017e+03,     1.076031934737519e+03,     1.076414588204875e+03, 
            1.076796413379697e+03,     1.077177414263577e+03,     1.077557594828376e+03,     1.077936959016537e+03,     1.078315510741370e+03, 
            1.078693253887340e+03,     1.079070192310364e+03,     1.079446329838084e+03,     1.079821670270152e+03,     1.080196217378505e+03, 
            1.080569974907638e+03,     1.080942946574872e+03,     1.081315136070620e+03,     1.081686547058652e+03,     1.082057183176354e+03, 
            1.082427048034981e+03,     1.082796145219912e+03,     1.083164478290905e+03,     1.083532050782334e+03,     1.083898866203444e+03, 
            1.084264928038581e+03,     1.084630239747440e+03,     1.084994804765298e+03,     1.085358626503238e+03,     1.085721708348391e+03, 
            1.086084053664154e+03,     1.086445665790423e+03,     1.086806548043801e+03,     1.087166703717832e+03,     1.087526136083206e+03, 
            1.087884848387980e+03,     1.088242843857786e+03,     1.088600125696039e+03,     1.088956697084144e+03,     1.089312561181704e+03, 
            1.089667721126715e+03,     1.090022180035770e+03,     1.090375941004253e+03,     1.090729007106534e+03,     1.091081381396167e+03, 
            1.091433066906069e+03,     1.091784066648718e+03,     1.092134383616336e+03,     1.092484020781068e+03,     1.092832981095171e+03, 
            1.093181267491188e+03,     1.093528882882128e+03,     1.093875830161641e+03,     1.094222112204192e+03,     1.094567731865230e+03, 
            1.094912691981362e+03,     1.095256995370515e+03,     1.095600644832108e+03,     1.095943643147213e+03,     1.096285993078714e+03, 
            1.096627697371473e+03,     1.096968758752485e+03,     1.097309179931037e+03,     1.097648963598861e+03,     1.097988112430288e+03, 
            1.098326629082401e+03,     1.098664516195181e+03,     1.099001776391663e+03,     1.099338412278074e+03,     1.099674426443984e+03, 
            1.100009821462446e+03,     1.100344599890142e+03,     1.100678764267522e+03,     1.101012317118937e+03,     1.101345260952787e+03, 
            1.101677598261650e+03,     1.102009331522417e+03,     1.102340463196428e+03,     1.102670995729600e+03,     1.103000931552561e+03, 
            1.103330273080775e+03,     1.103659022714675e+03,     1.103987182839781e+03,     1.104314755826834e+03,     1.104641744031912e+03
    },
    {
            1.700699378451712e+00,     5.149934464183398e+00,     8.660580316020702e+00,     1.223538219418265e+01,     1.587728492443117e+01, 
            1.958945281713023e+01,     2.337529215340687e+01,     2.723847665453298e+01,     3.118297642221070e+01,     3.521309094277613e+01, 
            3.933348686593290e+01,     4.354924142062033e+01,     4.786589251930189e+01,     5.228949683957722e+01,     5.682669747371395e+01, 
            6.148480312172864e+01,     6.627188129973622e+01,     7.119686867924649e+01,     7.626970251665412e+01,     8.150147824761686e+01, 
            8.690463981090832e+01,     9.249321127792595e+01,     9.828308111162869e+01,     1.042923541785917e+02,     1.105417919643025e+02, 
            1.170553690176325e+02,     1.238609845976352e+02,     1.309913845908916e+02,     1.384853729064828e+02,     1.463894283214159e+02, 
            1.547599008810359e+02,     1.636660542319587e+02,     1.731943741659537e+02,     1.834548251543421e+02,     1.945901995264037e+02, 
            2.067905546745632e+02,     2.203163645760399e+02,     2.355372728993437e+02,     2.530000794542106e+02,     2.735535239792757e+02, 
            2.985824310561175e+02,     3.304152958053477e+02,     3.727736117975445e+02,     4.293367023044013e+02,     4.900214589037467e+02, 
            5.384481845239452e+02,     5.728790625787842e+02,     5.982013056490076e+02,     6.179901534702503e+02,     6.341702044449054e+02, 
            6.478400262934806e+02,     6.596761303551530e+02,     6.701200300253754e+02,     6.794735998622693e+02,     6.879513471661261e+02, 
            6.957106793857753e+02,     7.028702657763247e+02,     7.095216422778145e+02,     7.157368142835538e+02,     7.215733956255650e+02, 
            7.270781776251645e+02,     7.322896668637230e+02,     7.372399271686010e+02,     7.419559410303732e+02,     7.464606321753297e+02, 
            7.507736448135490e+02,     7.549119452823244e+02,     7.588902921389545e+02,     7.627216075107395e+02,     7.664172734227637e+02, 
            7.699873704860189e+02,     7.734408718413705e+02,     7.767858020348577e+02,     7.800293681600824e+02,     7.831780688838918e+02, 
            7.862377856943133e+02,     7.892138597516389e+02,     7.921111569983291e+02,     7.949341236295817e+02,     7.976868336001854e+02, 
            8.003730295125115e+02,     8.029961579722230e+02,     8.055594002948809e+02,     8.080656992856946e+02,     8.105177826862978e+02, 
            8.129181837795592e+02,     8.152692595604502e+02,     8.175732068137164e+02,     8.198320763842465e+02,     8.220477858810814e+02, 
            8.242221310190181e+02,     8.263567957711363e+02,     8.284533614801444e+02,     8.305133150552227e+02,     8.325380563632251e+02, 
            8.345289049081664e+02,     8.364871058802440e+02,     8.384138356449533e+02,     8.403102067337089e+02,     8.421772723896268e+02, 
            8.440160307154258e+02,     8.458274284647014e+02,     8.476123645128708e+02,     8.493716930398291e+02,     8.511062264526468e+02, 
            8.528167380734428e+02,     8.545039646147312e+02,     8.561686084621408e+02,     8.578113397822017e+02,     8.594327984710762e+02, 
            8.610335959584016e+02,     8.626143168789827e+02,     8.641755206237805e+02,     8.657177427804861e+02,     8.672414964729728e+02, 
            8.687472736080148e+02,     8.702355460368490e+02,     8.717067666384613e+02,     8.731613703308242e+02,     8.745997750157422e+02, 
            8.760223824624713e+02,     8.774295791347749e+02,     8.788217369657162e+02,     8.801992140840829e+02,     8.815623554960044e+02, 
            8.829114937250378e+02,     8.842469494137131e+02,     8.855690318892697e+02,     8.868780396968883e+02,     8.881742611283538e+02, 
            8.894579747009168e+02,     8.907294495688556e+02,     8.919889450177011e+02,     8.932367137918344e+02,     8.944729988952027e+02, 
            8.956980357560234e+02,     8.969120529232292e+02,     8.981152711618194e+02,     8.993079045946332e+02,     9.004901607707391e+02, 
            9.016622409362017e+02,     9.028243402909981e+02,     9.039766482329343e+02,     9.051193485893209e+02,     9.062526198371640e+02, 
            9.073766353125227e+02,     9.084915634096768e+02,     9.095975677706998e+02,     9.106948074659642e+02,     9.117834371661261e+02, 
            9.128636073060317e+02,     9.139354642411008e+02,     9.149991503785942e+02,     9.160548043919921e+02,     9.171025612468873e+02, 
            9.181425524239595e+02,     9.191749059493616e+02,     9.201997466268756e+02,     9.212171960743972e+02,     9.222273728519370e+02, 
            9.232303925776927e+02,     9.242263679782048e+02,     9.252154090591167e+02,     9.261976230758215e+02,     9.271731149017515e+02, 
            9.281419867233510e+02,     9.291043383721091e+02,     9.300602673407511e+02,     9.310098688573923e+02,     9.319532359567395e+02, 
            9.328904595484931e+02,     9.338216284830709e+02,     9.347468296147778e+02,     9.356661478625545e+02,     9.365796662683967e+02, 
            9.374874660535643e+02,     9.383896266726783e+02,     9.392862258657991e+02,     9.401773397085725e+02,     9.410630426605385e+02, 
            9.419434076116751e+02,     9.428185059272573e+02,     9.436884074911060e+02,     9.445531807472939e+02,     9.454128927403700e+02, 
            9.462676091541804e+02,     9.471173943493269e+02,     9.479623113993266e+02,     9.488024221255351e+02,     9.496377871308729e+02, 
            9.504684658324045e+02,     9.512945164928296e+02,     9.521159962509132e+02,     9.529329611509071e+02,     9.537454661710062e+02, 
            9.545535652508649e+02,     9.553573113182257e+02,     9.561567563146813e+02,     9.569519512206168e+02,     9.577429460793486e+02, 
            9.585297900205064e+02,     9.593125312826772e+02,     9.600912172353379e+02,     9.608658944001121e+02,     9.616366084713731e+02, 
            9.624034043362030e+02,     9.631663260937627e+02,     9.639254170740596e+02,     9.646807198561614e+02,     9.654322762858586e+02, 
            9.661801274928093e+02,     9.669243139071734e+02,     9.676648752757607e+02,     9.684018506777089e+02,     9.691352785397074e+02, 
            9.698651966507845e+02,     9.705916421766655e+02,     9.713146516737304e+02,     9.720342611025731e+02,     9.727505058411783e+02, 
            9.734634206977344e+02,     9.741730399230875e+02,     9.748793972228519e+02,     9.755825257691885e+02,     9.762824582122669e+02, 
            9.769792266914028e+02,     9.776728628459150e+02,     9.783633978256707e+02,     9.790508623013674e+02,     9.797352860056823e+02, 
            9.804166995996142e+02,     9.810951319247575e+02,     9.817706118325294e+02,     9.824431677426251e+02,     9.831128276517828e+02, 
            9.837796191423223e+02,     9.844435693904672e+02,     9.851047051744525e+02,     9.857630528824334e+02,     9.864186385201899e+02, 
            9.870714877186423e+02,     9.877216257411798e+02,     9.883690774908071e+02,     9.890138675171164e+02,     9.896560200230881e+02, 
            9.902955588717281e+02,     9.909325075925399e+02,     9.915668893878474e+02,     9.921987271389625e+02,     9.928280434122036e+02, 
            9.934548604647779e+02,     9.940792002505192e+02,     9.947010844254945e+02,     9.953205343534763e+02,     9.959375711112931e+02, 
            9.965522154940502e+02,     9.971644880202351e+02,     9.977744089367035e+02,     9.983819982235515e+02,     9.989872755988816e+02, 
            9.995902605234543e+02,     1.000190972205242e+03,     1.000789429603875e+03,     1.001385651434995e+03,     1.001979656174506e+03, 
            1.002571462062738e+03,     1.003161087108513e+03,     1.003748549093126e+03,     1.004333865574242e+03,     1.004917053889698e+03, 
            1.005498131161243e+03,     1.006077114298171e+03,     1.006654020000903e+03,     1.007228864764478e+03,     1.007801664881969e+03, 
            1.008372436447837e+03,     1.008941195361208e+03,     1.009507957329080e+03,     1.010072737869472e+03,     1.010635552314498e+03, 
            1.011196415813383e+03,     1.011755343335418e+03,     1.012312349672851e+03,     1.012867449443725e+03,     1.013420657094650e+03, 
            1.013971986903526e+03,     1.014521452982216e+03,     1.015069069279150e+03,     1.015614849581890e+03,     1.016158807519642e+03, 
            1.016700956565721e+03,     1.017241310039954e+03,     1.017779881111054e+03,     1.018316682798939e+03,     1.018851727977004e+03, 
            1.019385029374353e+03,     1.019916599577988e+03,     1.020446451034955e+03,     1.020974596054451e+03,     1.021501046809884e+03, 
            1.022025815340905e+03,     1.022548913555392e+03,     1.023070353231404e+03,     1.023590146019093e+03,     1.024108303442584e+03, 
            1.024624836901821e+03,     1.025139757674368e+03,     1.025653076917198e+03,     1.026164805668428e+03,     1.026674954849037e+03, 
            1.027183535264539e+03,     1.027690557606643e+03,     1.028196032454868e+03,     1.028699970278137e+03,     1.029202381436339e+03, 
            1.029703276181865e+03,     1.030202664661116e+03,     1.030700556915984e+03,     1.031196962885307e+03,     1.031691892406300e+03, 
            1.032185355215959e+03,     1.032677360952440e+03,     1.033167919156416e+03,     1.033657039272411e+03,     1.034144730650110e+03, 
            1.034631002545639e+03,     1.035115864122842e+03,     1.035599324454516e+03,     1.036081392523637e+03,     1.036562077224558e+03, 
            1.037041387364197e+03,     1.037519331663192e+03,     1.037995918757047e+03,     1.038471157197254e+03,     1.038945055452397e+03, 
            1.039417621909241e+03,     1.039888864873794e+03,     1.040358792572363e+03,     1.040827413152585e+03,     1.041294734684444e+03, 
            1.041760765161272e+03,     1.042225512500729e+03,     1.042688984545775e+03,     1.043151189065621e+03,     1.043612133756661e+03, 
            1.044071826243403e+03,     1.044530274079368e+03,     1.044987484747986e+03,     1.045443465663474e+03,     1.045898224171701e+03, 
            1.046351767551037e+03,     1.046804103013197e+03,     1.047255237704056e+03,     1.047705178704467e+03,     1.048153933031061e+03, 
            1.048601507637027e+03,     1.049047909412895e+03,     1.049493145187293e+03,     1.049937221727698e+03,     1.050380145741178e+03, 
            1.050821923875121e+03,     1.051262562717947e+03,     1.051702068799819e+03,     1.052140448593335e+03,     1.052577708514220e+03, 
            1.053013854921990e+03,     1.053448894120627e+03,     1.053882832359226e+03,     1.054315675832648e+03,     1.054747430682146e+03, 
            1.055178102996001e+03,     1.055607698810131e+03,     1.056036224108705e+03,     1.056463684824737e+03,     1.056890086840679e+03, 
            1.057315435989002e+03,     1.057739738052770e+03,     1.058162998766204e+03,     1.058585223815239e+03,     1.059006418838075e+03, 
            1.059426589425712e+03,     1.059845741122491e+03,     1.060263879426613e+03,     1.060681009790663e+03,     1.061097137622115e+03, 
            1.061512268283840e+03,     1.061926407094602e+03,     1.062339559329545e+03,     1.062751730220679e+03,     1.063162924957353e+03, 
            1.063573148686726e+03,     1.063982406514232e+03,     1.064390703504034e+03,     1.064798044679470e+03,     1.065204435023507e+03, 
            1.065609879479172e+03,     1.066014382949984e+03,     1.066417950300383e+03,     1.066820586356148e+03,     1.067222295904812e+03, 
            1.067623083696073e+03,     1.068022954442195e+03,     1.068421912818406e+03,     1.068819963463293e+03,     1.069217110979188e+03, 
            1.069613359932550e+03,     1.070008714854342e+03,     1.070403180240407e+03,     1.070796760551827e+03,     1.071189460215297e+03, 
            1.071581283623471e+03,     1.071972235135325e+03,     1.072362319076497e+03,     1.072751539739638e+03,     1.073139901384748e+03, 
            1.073527408239509e+03,     1.073914064499622e+03,     1.074299874329125e+03,     1.074684841860722e+03,     1.075068971196100e+03, 
            1.075452266406241e+03,     1.075834731531731e+03,     1.076216370583071e+03,     1.076597187540975e+03,     1.076977186356669e+03, 
            1.077356370952186e+03,     1.077734745220661e+03,     1.078112313026609e+03,     1.078489078206218e+03,     1.078865044567625e+03, 
            1.079240215891190e+03,     1.079614595929776e+03,     1.079988188409014e+03,     1.080360997027568e+03,     1.080733025457403e+03, 
            1.081104277344043e+03,     1.081474756306827e+03,     1.081844465939163e+03,     1.082213409808779e+03,     1.082581591457968e+03, 
            1.082949014403839e+03,     1.083315682138551e+03,     1.083681598129557e+03,     1.084046765819835e+03,     1.084411188628126e+03, 
            1.084774869949162e+03,     1.085137813153891e+03,     1.085500021589706e+03,     1.085861498580663e+03,     1.086222247427703e+03, 
            1.086582271408868e+03,     1.086941573779516e+03,     1.087300157772530e+03,     1.087658026598531e+03,     1.088015183446082e+03, 
            1.088371631481893e+03,     1.088727373851022e+03,     1.089082413677080e+03,     1.089436754062417e+03,     1.089790398088331e+03, 
            1.090143348815251e+03,     1.090495609282929e+03,     1.090847182510631e+03,     1.091198071497322e+03,     1.091548279221850e+03, 
            1.091897808643127e+03,     1.092246662700311e+03,     1.092594844312980e+03,     1.092942356381314e+03,     1.093289201786263e+03, 
            1.093635383389722e+03,     1.093980904034698e+03,     1.094325766545483e+03,     1.094669973727817e+03,     1.095013528369050e+03, 
            1.095356433238309e+03,     1.095698691086657e+03,     1.096040304647250e+03,     1.096381276635496e+03,     1.096721609749213e+03, 
            1.097061306668774e+03,     1.097400370057272e+03,     1.097738802560656e+03,     1.098076606807891e+03,     1.098413785411101e+03, 
            1.098750340965710e+03,     1.099086276050595e+03,     1.099421593228220e+03,     1.099756295044783e+03,     1.100090384030350e+03, 
            1.100423862698996e+03,     1.100756733548940e+03,     1.101088999062682e+03,     1.101420661707132e+03,     1.101751723933746e+03, 
            1.102082188178656e+03,     1.102412056862795e+03,     1.102741332392032e+03,     1.103070017157291e+03,     1.103398113534683e+03
    },
    {
            1.697378094262873e+00,     5.139585459013471e+00,     8.642662704614215e+00,     1.220930770525416e+01,     1.584241262772867e+01, 
            1.954508311823358e+01,     2.332065993310804e+01,     2.717274340494604e+01,     3.110522120147951e+01,     3.512229993251934e+01, 
            3.922854126858289e+01,     4.342890337480684e+01,     4.772878863687024e+01,     5.213409887300739e+01,     5.665129950115021e+01, 
            6.128749447990764e+01,     6.605051429077864e+01,     7.094901980895793e+01,     7.599262566632805e+01,     8.119204770523740e+01, 
            8.655928044354577e+01,     9.210781224577063e+01,     9.785288830333076e+01,     1.038118348342678e+02,     1.100044625135967e+02, 
            1.164535736342921e+02,     1.231856067885359e+02,     1.302314663760653e+02,     1.376276042866897e+02,     1.454174512218590e+02, 
            1.536533420823688e+02,     1.623991530562801e+02,     1.717339879270168e+02,     1.817574501623184e+02,     1.925973805132771e+02, 
            2.044215509589292e+02,     2.174559335801092e+02,     2.320143149287681e+02,     2.485482253318715e+02,     2.677342086323142e+02, 
            2.906285792270733e+02,     3.189239594001465e+02,     3.552405269636864e+02,     4.028215574446646e+02,     4.597670208325959e+02, 
            5.117483305900661e+02,     5.515143941492529e+02,     5.807227945609364e+02,     6.031397803160469e+02,     6.211855711705463e+02, 
            6.362430110165706e+02,     6.491493477847057e+02,     6.604432612855577e+02,     6.704884094240143e+02,     6.795401903280534e+02, 
            6.877840370300953e+02,     6.953584295009276e+02,     7.023692903057658e+02,     7.088993187729702e+02,     7.150142390881517e+02, 
            7.207671014739640e+02,     7.262013166344794e+02,     7.313528429933824e+02,     7.362517933139054e+02,     7.409236347288322e+02, 
            7.453900985612718e+02,     7.496698794585915e+02,     7.537791792295282e+02,     7.577321346329185e+02,     7.615411573605284e+02, 
            7.652172068215398e+02,     7.687700109567659e+02,     7.722082464664550e+02,     7.755396870531036e+02,     7.787713262427674e+02, 
            7.819094798396842e+02,     7.849598719407769e+02,     7.879277075849957e+02,     7.908177344640731e+02,     7.936342956234660e+02, 
            7.963813746971799e+02,     7.990626349200484e+02,     8.016814529255447e+02,     8.042409481511464e+02,     8.067440085254037e+02, 
            8.091933129925499e+02,     8.115913513353861e+02,     8.139404416801768e+02,     8.162427460047431e+02,     8.185002839197598e+02, 
            8.207149449512830e+02,     8.228884995178272e+02,     8.250226087665975e+02,     8.271188334095370e+02,     8.291786416798330e+02, 
            8.312034165127379e+02,     8.331944620403972e+02,     8.351530094783874e+02,     8.370802224715251e+02,     8.389772019577985e+02, 
            8.408449906019245e+02,     8.426845768436168e+02,     8.444968986002505e+02,     8.462828466588359e+02,     8.480432677881869e+02, 
            8.497789675985786e+02,     8.514907131731544e+02,     8.531792354926258e+02,     8.548452316724723e+02,     8.564893670297862e+02, 
            8.581122769950986e+02,     8.597145688829324e+02,     8.612968235334204e+02,     8.628595968360811e+02,     8.644034211457590e+02, 
            8.659288065997251e+02,     8.674362423441194e+02,     8.689261976770781e+02,     8.703991231152482e+02,     8.718554513897599e+02, 
            8.732955983771448e+02,     8.747199639702511e+02,     8.761289328937017e+02,     8.775228754680764e+02,     8.789021483266273e+02, 
            8.802670950880103e+02,     8.816180469882214e+02,     8.829553234746663e+02,     8.842792327650823e+02,     8.855900723905793e+02, 
            8.868881297159305e+02,     8.881736823697034e+02,     8.894469979080379e+02,     8.907083366257248e+02,     8.919579490743735e+02, 
            8.931960778334127e+02,     8.944229583192099e+02,     8.956388178846776e+02,     8.968438769820137e+02,     8.980383492420940e+02, 
            8.992224417573898e+02,     9.003963553503154e+02,     9.015602848279162e+02,     9.027144192237025e+02,     9.038589420274074e+02, 
            9.049940314033895e+02,     9.061198603983325e+02,     9.072365971388690e+02,     9.083444050197220e+02,     9.094434428828785e+02, 
            9.105338651883250e+02,     9.116158221592242e+02,     9.126894600089418e+02,     9.137549209969369e+02,     9.148123435728332e+02, 
            9.158618626024196e+02,     9.169036094219861e+02,     9.179377119805902e+02,     9.189642949579296e+02,     9.199834798771041e+02, 
            9.209953852243380e+02,     9.220001265037803e+02,     9.229978164110379e+02,     9.239885648768386e+02,     9.249724791709865e+02, 
            9.259496639051223e+02,     9.269202214433345e+02,     9.278842515059066e+02,     9.288418515547602e+02,     9.297931167922579e+02, 
            9.307381402320827e+02,     9.316770127673395e+02,     9.326098232359928e+02,     9.335366584837778e+02,     9.344576034246921e+02, 
            9.353727410991856e+02,     9.362821527301518e+02,     9.371859177768139e+02,     9.380841139866093e+02,     9.389768174451591e+02, 
            9.398641026243994e+02,     9.407460424289668e+02,     9.416227082409057e+02,     9.424941699627755e+02,     9.433604960592187e+02, 
            9.442217535970670e+02,     9.450780082840359e+02,     9.459293245060747e+02,     9.467757653634227e+02,     9.476173927054305e+02, 
            9.484542671641950e+02,     9.492864481870512e+02,     9.501139940679788e+02,     9.509369619779570e+02,     9.517554079943141e+02, 
            9.525693871291081e+02,     9.533789533565861e+02,     9.541841596397473e+02,     9.549850579560497e+02,     9.557816993222956e+02, 
            9.565741338187229e+02,     9.573624106123360e+02,     9.581465779795047e+02,     9.589266833278571e+02,     9.597027732174934e+02, 
            9.604748933815497e+02,     9.612430887461297e+02,     9.620074034496290e+02,     9.627678808614808e+02,     9.635245636003365e+02, 
            9.642774935516999e+02,     9.650267118850462e+02,     9.657722590704340e+02,     9.665141748946260e+02,     9.672524984767489e+02, 
            9.679872682834933e+02,     9.687185221438838e+02,     9.694462972636192e+02,     9.701706302390123e+02,     9.708915570705348e+02, 
            9.716091131759757e+02,     9.723233334032469e+02,     9.730342520428133e+02,     9.737419028398040e+02,     9.744463190057704e+02, 
            9.751475332301383e+02,     9.758455776913415e+02,     9.765404840676589e+02,     9.772322835477645e+02,     9.779210063753545e+02, 
            9.786066837029152e+02,     9.792893448634583e+02,     9.799690191872033e+02,     9.806457355634558e+02,     9.813195224496015e+02, 
            9.819904078798614e+02,     9.826584194738271e+02,     9.833235844447784e+02,     9.839859296077885e+02,     9.846454813876268e+02, 
            9.853022658264608e+02,     9.859563085913707e+02,     9.866076349816733e+02,     9.872562699360658e+02,     9.879022380395975e+02, 
            9.885455635304658e+02,     9.891862703066553e+02,     9.898243819324051e+02,     9.904599216445333e+02,     9.910929123585997e+02, 
            9.917233766749285e+02,     9.923513368844848e+02,     9.929768149746170e+02,     9.935998326346538e+02,     9.942204112613917e+02, 
            9.948385719644281e+02,     9.954543355713937e+02,     9.960677226330544e+02,     9.966787534282968e+02,     9.972874479690023e+02, 
            9.978938260048130e+02,     9.984979070277816e+02,     9.990997102769292e+02,     9.996992547426916e+02,     1.000296559171272e+03, 
            1.000891642068892e+03,     1.001484521705959e+03,     1.002075216121133e+03,     1.002663743125305e+03,     1.003250120305497e+03, 
            1.003834365028671e+03,     1.004416494445456e+03,     1.004996525493801e+03,     1.005574474902543e+03,     1.006150359194903e+03, 
            1.006724194691909e+03,     1.007295997515746e+03,     1.007865783593036e+03,     1.008433568658049e+03,     1.008999368255843e+03, 
            1.009563197745355e+03,     1.010125072302409e+03,     1.010685006922671e+03,     1.011243016424552e+03,     1.011799115452032e+03, 
            1.012353318477448e+03,     1.012905639804213e+03,     1.013456093569485e+03,     1.014004693746782e+03,     1.014551454148545e+03, 
            1.015096388428650e+03,     1.015639510084874e+03,     1.016180832461305e+03,     1.016720368750713e+03,     1.017258131996868e+03, 
            1.017794135096825e+03,     1.018328390803142e+03,     1.018860911726085e+03,     1.019391710335767e+03,     1.019920798964257e+03, 
            1.020448189807646e+03,     1.020973894928077e+03,     1.021497926255736e+03,     1.022020295590798e+03,     1.022541014605350e+03, 
            1.023060094845267e+03,     1.023577547732060e+03,     1.024093384564686e+03,     1.024607616521326e+03,     1.025120254661132e+03, 
            1.025631309925940e+03,     1.026140793141952e+03,     1.026648715021389e+03,     1.027155086164114e+03,     1.027659917059222e+03, 
            1.028163218086611e+03,     1.028664999518511e+03,     1.029165271521000e+03,     1.029664044155485e+03,     1.030161327380156e+03, 
            1.030657131051420e+03,     1.031151464925309e+03,     1.031644338658856e+03,     1.032135761811458e+03,     1.032625743846206e+03, 
            1.033114294131200e+03,     1.033601421940834e+03,     1.034087136457066e+03,     1.034571446770660e+03,     1.035054361882412e+03, 
            1.035535890704352e+03,     1.036016042060927e+03,     1.036494824690165e+03,     1.036972247244816e+03,     1.037448318293480e+03, 
            1.037923046321709e+03,     1.038396439733098e+03,     1.038868506850349e+03,     1.039339255916331e+03,     1.039808695095108e+03, 
            1.040276832472957e+03,     1.040743676059372e+03,     1.041209233788050e+03,     1.041673513517854e+03,     1.042136523033773e+03, 
            1.042598270047854e+03,     1.043058762200130e+03,     1.043518007059526e+03,     1.043976012124752e+03,     1.044432784825185e+03, 
            1.044888332521733e+03,     1.045342662507688e+03,     1.045795782009563e+03,     1.046247698187922e+03,     1.046698418138186e+03, 
            1.047147948891440e+03,     1.047596297415217e+03,     1.048043470614274e+03,     1.048489475331357e+03,     1.048934318347950e+03, 
            1.049378006385022e+03,     1.049820546103746e+03,     1.050261944106228e+03,     1.050702206936207e+03,     1.051141341079752e+03, 
            1.051579352965953e+03,     1.052016248967592e+03,     1.052452035401811e+03,     1.052886718530767e+03,     1.053320304562279e+03, 
            1.053752799650461e+03,     1.054184209896356e+03,     1.054614541348547e+03,     1.055043800003769e+03,     1.055471991807510e+03, 
            1.055899122654597e+03,     1.056325198389787e+03,     1.056750224808332e+03,     1.057174207656553e+03,     1.057597152632390e+03, 
            1.058019065385958e+03,     1.058439951520087e+03,     1.058859816590852e+03,     1.059278666108106e+03,     1.059696505535997e+03, 
            1.060113340293473e+03,     1.060529175754797e+03,     1.060944017250038e+03,     1.061357870065563e+03,     1.061770739444519e+03, 
            1.062182630587312e+03,     1.062593548652077e+03,     1.063003498755139e+03,     1.063412485971473e+03,     1.063820515335156e+03, 
            1.064227591839806e+03,     1.064633720439028e+03,     1.065038906046841e+03,     1.065443153538107e+03,     1.065846467748953e+03, 
            1.066248853477186e+03,     1.066650315482698e+03,     1.067050858487878e+03,     1.067450487178006e+03,     1.067849206201645e+03, 
            1.068247020171033e+03,     1.068643933662463e+03,     1.069039951216665e+03,     1.069435077339174e+03,     1.069829316500698e+03, 
            1.070222673137487e+03,     1.070615151651685e+03,     1.071006756411686e+03,     1.071397491752485e+03,     1.071787361976019e+03, 
            1.072176371351509e+03,     1.072564524115795e+03,     1.072951824473668e+03,     1.073338276598197e+03,     1.073723884631051e+03, 
            1.074108652682817e+03,     1.074492584833316e+03,     1.074875685131916e+03,     1.075257957597831e+03,     1.075639406220432e+03, 
            1.076020034959543e+03,     1.076399847745733e+03,     1.076778848480613e+03,     1.077157041037119e+03,     1.077534429259798e+03, 
            1.077911016965091e+03,     1.078286807941605e+03,     1.078661805950393e+03,     1.079036014725217e+03,     1.079409437972823e+03, 
            1.079782079373198e+03,     1.080153942579834e+03,     1.080525031219985e+03,     1.080895348894919e+03,     1.081264899180171e+03, 
            1.081633685625792e+03,     1.082001711756590e+03,     1.082368981072377e+03,     1.082735497048203e+03,     1.083101263134597e+03, 
            1.083466282757797e+03,     1.083830559319981e+03,     1.084194096199497e+03,     1.084556896751085e+03,     1.084918964306102e+03, 
            1.085280302172742e+03,     1.085640913636249e+03,     1.086000801959136e+03,     1.086359970381396e+03,     1.086718422120712e+03, 
            1.087076160372661e+03,     1.087433188310923e+03,     1.087789509087481e+03,     1.088145125832821e+03,     1.088500041656132e+03, 
            1.088854259645498e+03,     1.089207782868091e+03,     1.089560614370368e+03,     1.089912757178251e+03,     1.090264214297320e+03, 
            1.090614988712993e+03,     1.090965083390714e+03,     1.091314501276127e+03,     1.091663245295257e+03,     1.092011318354689e+03, 
            1.092358723341735e+03,     1.092705463124613e+03,     1.093051540552616e+03,     1.093396958456275e+03,     1.093741719647534e+03, 
            1.094085826919907e+03,     1.094429283048646e+03,     1.094772090790898e+03,     1.095114252885869e+03,     1.095455772054977e+03, 
            1.095796651002008e+03,     1.096136892413273e+03,     1.096476498957759e+03,     1.096815473287278e+03,     1.097153818036617e+03, 
            1.097491535823687e+03,     1.097828629249665e+03,     1.098165100899141e+03,     1.098500953340263e+03,     1.098836189124870e+03, 
            1.099170810788640e+03,     1.099504820851224e+03,     1.099838221816382e+03,     1.100171016172121e+03,     1.100503206390824e+03, 
            1.100834794929389e+03,     1.101165784229351e+03,     1.101496176717021e+03,     1.101825974803605e+03,     1.102155180885339e+03
    },
    {
            1.694069950056698e+00,     5.129279808605022e+00,     8.624824521488526e+00,     1.218335546130402e+01,     1.580771316608512e+01, 
            1.950094582121906e+01,     2.326633006806017e+01,     2.710739450742472e+01,     3.102794632694406e+01,     3.503210157223986e+01, 
            3.912431968167542e+01,     4.330944303334280e+01,     4.759274241175638e+01,     5.197996950068461e+01,     5.647741775888640e+01, 
            6.109199335344336e+01,     6.583129823097782e+01,     7.070372792961246e+01,     7.571858741260398e+01,     8.088622909245362e+01, 
            8.621821838760501e+01,     9.172753371974225e+01,     9.742880997171905e+01,     1.033386373070936e+02,     1.094759312299916e+02, 
            1.158623953282758e+02,     1.225231060369951e+02,     1.294872601304629e+02,     1.367891423228757e+02,     1.444693950897327e+02, 
            1.525767108777967e+02,     1.611701251614926e+02,     1.703221826215631e+02,     1.801234010698319e+02,     1.906887139589800e+02, 
            2.021670152097963e+02,     2.147557188303265e+02,     2.287236870341469e+02,     2.444485455019547e+02,     2.624791799348291e+02, 
            2.836412911521238e+02,     3.092050063770271e+02,     3.410783864856483e+02,     3.817402017361340e+02,     4.322510583315979e+02, 
            4.845001331823307e+02,     5.283857075028571e+02,     5.617711431744769e+02,     5.871909149452272e+02,     6.073609397644190e+02, 
            6.239838988582331e+02,     6.380877676779583e+02,     6.503256435327962e+02,     6.611335217395231e+02,     6.708144668937947e+02, 
            6.795864062322304e+02,     6.876106476831226e+02,     6.950095888282874e+02,     7.018781052213557e+02,     7.082911088454194e+02, 
            7.143087089331621e+02,     7.199798256402514e+02,     7.253447773219394e+02,     7.304371696457169e+02,     7.352852990816590e+02, 
            7.399132118324954e+02,     7.443415139326493e+02,     7.485879987922068e+02,     7.526681388987959e+02,     7.565954751342678e+02, 
            7.603819280175750e+02,     7.640380487718493e+02,     7.675732235501509e+02,     7.709958408632342e+02,     7.743134298503574e+02, 
            7.775327752610499e+02,     7.806600136934060e+02,     7.837007146390924e+02,     7.866599491292070e+02,     7.895423481961039e+02, 
            7.923521529194792e+02,     7.950932574775464e+02,     7.977692463520998e+02,     8.003834266219117e+02,     8.029388561088247e+02, 
            8.054383680052480e+02,     8.078845925028669e+02,     8.102799758544785e+02,     8.126267972296071e+02,     8.149271836663643e+02, 
            8.171831233743947e+02,     8.193964776045171e+02,     8.215689912681942e+02,     8.237023024630312e+02,     8.257979510379687e+02, 
            8.278573863130356e+02,     8.298819740526330e+02,     8.318730027779643e+02,     8.338316894928830e+02,     8.357591848877814e+02, 
            8.376565780779273e+02,     8.395249009256036e+02,     8.413651319893652e+02,     8.431782001385237e+02,     8.449649878664599e+02, 
            8.467263343324807e+02,     8.484630381585374e+02,     8.501758600041933e+02,     8.518655249406297e+02,     8.535327246422547e+02, 
            8.551781194124766e+02,     8.568023400584877e+02,     8.584059896283538e+02,     8.599896450223741e+02,     8.615538584894560e+02, 
            8.630991590182075e+02,     8.646260536314958e+02,     8.661350285923935e+02,     8.676265505286685e+02,     8.691010674823252e+02, 
            8.705590098900965e+02,     8.720007915002532e+02,     8.734268102306111e+02,     8.748374489722041e+02,     8.762330763426763e+02, 
            8.776140473931100e+02,     8.789807042717051e+02,     8.803333768473985e+02,     8.816723832963022e+02,     8.829980306619434e+02, 
            8.843106154091602e+02,     8.856104238831787e+02,     8.868977321188935e+02,     8.881728082168756e+02,     8.894359104679091e+02, 
            8.906872888000142e+02,     8.919271856833282e+02,     8.931558352372684e+02,     8.943734644128929e+02,     8.955802930842880e+02, 
            8.967765343440890e+02,     8.979623947837039e+02,     8.991380747591661e+02,     9.003037686435099e+02,     9.014596650664542e+02, 
            9.026059471421720e+02,     9.037427926858296e+02,     9.048703744195692e+02,     9.059888601685348e+02,     9.070984130475086e+02, 
            9.081991916210096e+02,     9.092913501622859e+02,     9.103750386339129e+02,     9.114504030243894e+02,     9.125175854033670e+02, 
            9.135767240804926e+02,     9.146279537395100e+02,     9.156714055663949e+02,     9.167072073718399e+02,     9.177354837083916e+02, 
            9.187563559942784e+02,     9.197699425723931e+02,     9.207763588872511e+02,     9.217757175324606e+02,     9.227681283580362e+02, 
            9.237536985607069e+02,     9.247325327705162e+02,     9.257047330320261e+02,     9.266703992798519e+02,     9.276296288378218e+02, 
            9.285825168669364e+02,     9.295291563447449e+02,     9.304696381331174e+02,     9.314040510433907e+02,     9.323324818989889e+02, 
            9.332550155956545e+02,     9.341717351593868e+02,     9.350827218021943e+02,     9.359880549757669e+02,     9.368878124231461e+02, 
            9.377820702285030e+02,     9.386709028650828e+02,     9.395543832414194e+02,     9.404325827458779e+02,     9.413055712896062e+02, 
            9.421734173479634e+02,     9.430361880004855e+02,     9.438939489694525e+02,     9.447467646571150e+02,     9.455946981816429e+02, 
            9.464378114118326e+02,     9.472761650006419e+02,     9.481098184175879e+02,     9.489388299800617e+02,     9.497632568835998e+02, 
            9.505831552311503e+02,     9.513985800613821e+02,     9.522095853760696e+02,     9.530162241665888e+02,     9.538185484395603e+02, 
            9.546166092416777e+02,     9.554104566837364e+02,     9.562001399639175e+02,     9.569857073903300e+02,     9.577672064028624e+02, 
            9.585446835943480e+02,     9.593181847310850e+02,     9.600877547727295e+02,     9.608534378915857e+02,     9.616152774913096e+02, 
            9.623733162250599e+02,     9.631275960131001e+02,     9.638781580598893e+02,     9.646250428706579e+02,     9.653682902675134e+02, 
            9.661079394050663e+02,     9.668440287856125e+02,     9.675765962738724e+02,     9.683056791113224e+02,     9.690313139301043e+02, 
            9.697535367665547e+02,     9.704723830743507e+02,     9.711878877372903e+02,     9.719000850817157e+02,     9.726090088886011e+02, 
            9.733146924053060e+02,     9.740171683570063e+02,     9.747164689578228e+02,     9.754126259216422e+02,     9.761056700103142e+02, 
            9.767956328745357e+02,     9.774825443455105e+02,     9.781664342387944e+02,     9.788473319196784e+02,     9.795252663124060e+02, 
            9.802002659091592e+02,     9.808723587788098e+02,     9.815415725754476e+02,     9.822079345466924e+02,     9.828714715417908e+02, 
            9.835322100195170e+02,     9.841901760558715e+02,     9.848453953515874e+02,     9.854978932394505e+02,     9.861476946914446e+02, 
            9.867948243257138e+02,     9.874393064133592e+02,     9.880811648850713e+02,     9.887204233376013e+02,     9.893571050400756e+02, 
            9.899912329401608e+02,     9.906228296700854e+02,     9.912519175525110e+02,     9.918785186062732e+02,     9.925026545519861e+02, 
            9.931243468175113e+02,     9.937436165433088e+02,     9.943604845876566e+02,     9.949749715317554e+02,     9.955870976847129e+02, 
            9.961968830884203e+02,     9.968043475223132e+02,     9.974095105080244e+02,     9.980123913139408e+02,     9.986130089596513e+02, 
            9.992113822202938e+02,     9.998075296308180e+02,     1.000401469490139e+03,     1.000993219865212e+03,     1.001582798595015e+03, 
            1.002170223294439e+03,     1.002755511358109e+03,     1.003338679964101e+03,     1.003919746077603e+03,     1.004498726454479e+03, 
            1.005075637644772e+03,     1.005650495996121e+03,     1.006223317657118e+03,     1.006794118580580e+03,     1.007362914526771e+03, 
            1.007929721066542e+03,     1.008494553584414e+03,     1.009057427281595e+03,     1.009618357178938e+03,     1.010177358119834e+03, 
            1.010734444773049e+03,     1.011289631635510e+03,     1.011842933035021e+03,     1.012394363132937e+03,     1.012943935926779e+03, 
            1.013491665252802e+03,     1.014037564788499e+03,     1.014581648055079e+03,     1.015123928419873e+03,     1.015664419098704e+03, 
            1.016203133158215e+03,     1.016740083518142e+03,     1.017275282953547e+03,     1.017808744097017e+03,     1.018340479440804e+03, 
            1.018870501338938e+03,     1.019398822009295e+03,     1.019925453535626e+03,     1.020450407869548e+03,     1.020973696832495e+03, 
            1.021495332117644e+03,     1.022015325291785e+03,     1.022533687797177e+03,     1.023050430953355e+03,     1.023565565958917e+03, 
            1.024079103893261e+03,     1.024591055718308e+03,     1.025101432280181e+03,     1.025610244310864e+03,     1.026117502429820e+03, 
            1.026623217145588e+03,     1.027127398857353e+03,     1.027630057856475e+03,     1.028131204328010e+03,     1.028630848352186e+03, 
            1.029128999905868e+03,     1.029625668863984e+03,     1.030120865000940e+03,     1.030614597991994e+03,     1.031106877414621e+03, 
            1.031597712749848e+03,     1.032087113383564e+03,     1.032575088607813e+03,     1.033061647622059e+03,     1.033546799534433e+03, 
            1.034030553362959e+03,     1.034512918036758e+03,     1.034993902397234e+03,     1.035473515199230e+03,     1.035951765112188e+03, 
            1.036428660721257e+03,     1.036904210528413e+03,     1.037378422953542e+03,     1.037851306335513e+03,     1.038322868933225e+03, 
            1.038793118926654e+03,     1.039262064417861e+03,     1.039729713431997e+03,     1.040196073918295e+03,     1.040661153751033e+03, 
            1.041124960730492e+03,     1.041587502583892e+03,     1.042048786966321e+03,     1.042508821461640e+03,     1.042967613583379e+03, 
            1.043425170775620e+03,     1.043881500413861e+03,     1.044336609805870e+03,     1.044790506192526e+03,     1.045243196748642e+03, 
            1.045694688583787e+03,     1.046144988743077e+03,     1.046594104207969e+03,     1.047042041897041e+03,     1.047488808666747e+03, 
            1.047934411312181e+03,     1.048378856567811e+03,     1.048822151108210e+03,     1.049264301548779e+03,     1.049705314446451e+03, 
            1.050145196300392e+03,     1.050583953552684e+03,     1.051021592589005e+03,     1.051458119739295e+03,     1.051893541278412e+03, 
            1.052327863426778e+03,     1.052761092351019e+03,     1.053193234164592e+03,     1.053624294928403e+03,     1.054054280651415e+03, 
            1.054483197291252e+03,     1.054911050754792e+03,     1.055337846898745e+03,     1.055763591530232e+03,     1.056188290407350e+03, 
            1.056611949239734e+03,     1.057034573689102e+03,     1.057456169369801e+03,     1.057876741849341e+03,     1.058296296648923e+03, 
            1.058714839243957e+03,     1.059132375064577e+03,     1.059548909496145e+03,     1.059964447879746e+03,     1.060378995512684e+03, 
            1.060792557648966e+03,     1.061205139499775e+03,     1.061616746233945e+03,     1.062027382978423e+03,     1.062437054818730e+03, 
            1.062845766799408e+03,     1.063253523924469e+03,     1.063660331157835e+03,     1.064066193423767e+03,     1.064471115607297e+03, 
            1.064875102554648e+03,     1.065278159073647e+03,     1.065680289934142e+03,     1.066081499868399e+03,     1.066481793571508e+03, 
            1.066881175701773e+03,     1.067279650881103e+03,     1.067677223695393e+03,     1.068073898694904e+03,     1.068469680394639e+03, 
            1.068864573274706e+03,     1.069258581780687e+03,     1.069651710323993e+03,     1.070043963282223e+03,     1.070435344999506e+03, 
            1.070825859786854e+03,     1.071215511922500e+03,     1.071604305652229e+03,     1.071992245189719e+03,     1.072379334716861e+03, 
            1.072765578384085e+03,     1.073150980310682e+03,     1.073535544585112e+03,     1.073919275265325e+03,     1.074302176379058e+03, 
            1.074684251924145e+03,     1.075065505868815e+03,     1.075445942151985e+03,     1.075825564683558e+03,     1.076204377344702e+03, 
            1.076582383988145e+03,     1.076959588438447e+03,     1.077335994492284e+03,     1.077711605918721e+03,     1.078086426459479e+03, 
            1.078460459829206e+03,     1.078833709715743e+03,     1.079206179780377e+03,     1.079577873658110e+03,     1.079948794957902e+03, 
            1.080318947262932e+03,     1.080688334130841e+03,     1.081056959093978e+03,     1.081424825659643e+03,     1.081791937310330e+03, 
            1.082158297503955e+03,     1.082523909674100e+03,     1.082888777230237e+03,     1.083252903557957e+03,     1.083616292019200e+03, 
            1.083978945952471e+03,     1.084340868673067e+03,     1.084702063473289e+03,     1.085062533622660e+03,     1.085422282368139e+03, 
            1.085781312934325e+03,     1.086139628523671e+03,     1.086497232316687e+03,     1.086854127472139e+03,     1.087210317127256e+03, 
            1.087565804397923e+03,     1.087920592378877e+03,     1.088274684143903e+03,     1.088628082746027e+03,     1.088980791217695e+03, 
            1.089332812570975e+03,     1.089684149797727e+03,     1.090034805869797e+03,     1.090384783739190e+03,     1.090734086338252e+03, 
            1.091082716579849e+03,     1.091430677357533e+03,     1.091777971545725e+03,     1.092124601999876e+03,     1.092470571556644e+03, 
            1.092815883034057e+03,     1.093160539231674e+03,     1.093504542930757e+03,     1.093847896894423e+03,     1.094190603867811e+03, 
            1.094532666578235e+03,     1.094874087735342e+03,     1.095214870031267e+03,     1.095555016140780e+03,     1.095894528721447e+03, 
            1.096233410413771e+03,     1.096571663841340e+03,     1.096909291610979e+03,     1.097246296312889e+03,     1.097582680520791e+03, 
            1.097918446792067e+03,     1.098253597667904e+03,     1.098588135673424e+03,     1.098922063317831e+03,     1.099255383094536e+03, 
            1.099588097481299e+03,     1.099920208940359e+03,     1.100251719918561e+03,     1.100582632847492e+03,     1.100912950143605e+03
    },
    {
            1.690774866339928e+00,     5.119017224955504e+00,     8.607065191411145e+00,     1.215752450257040e+01,     1.577318507498894e+01, 
            1.945703880826735e+01,     2.321229960345937e+01,     2.704242594285846e+01,     3.095114643345458e+01,     3.494248880094815e+01, 
            3.902081291310021e+01,     4.319084852990528e+01,     4.745773862380074e+01,     5.182708929503461e+01,     5.630502753576571e+01, 
            6.089826838471891e+01,     6.561419338178483e+01,     7.046094270226666e+01,     7.544752395889063e+01,     8.058394145212652e+01, 
            8.588135069120261e+01,     9.135224439079592e+01,     9.701067800175751e+01,     1.028725453455288e+02,     1.089559183640132e+02, 
            1.152814697731586e+02,     1.218730041252007e+02,     1.287581323656307e+02,     1.359691388663543e+02,     1.435441102721925e+02, 
            1.515284264235285e+02,     1.599767601836885e+02,     1.689558067268638e+02,     1.785480800438467e+02,     1.888573069331992e+02, 
            2.000162722838449e+02,     2.121985266577169e+02,     2.256363448295557e+02,     2.406490431525628e+02,     2.576886523576401e+02, 
            2.774138438146318e+02,     3.008029077688240e+02,     3.292854024320488e+02,     3.647378747237137e+02,     4.087418808125917e+02, 
            4.583933736019504e+02,     5.042301058297110e+02,     5.413966222083435e+02,     5.700857171205155e+02,     5.926440087218712e+02, 
            6.110216452119477e+02,     6.264588727401506e+02,     6.397411365787664e+02,     6.513878612936365e+02,     6.617569174827861e+02, 
            6.711034887410253e+02,     6.796149547749889e+02,     6.874324406706296e+02,     6.946645956475509e+02,     7.013966775589067e+02, 
            7.076967121890378e+02,     7.136197765018574e+02,     7.192110457872280e+02,     7.245080057562088e+02,     7.295420875338068e+02, 
            7.343398955641218e+02,     7.389241430455176e+02,     7.433143737727970e+02,     7.475275256851861e+02,     7.515783755418213e+02, 
            7.554798932534528e+02,     7.592435267977254e+02,     7.628794332592505e+02,     7.663966676657401e+02,     7.698033384758194e+02, 
            7.731067365017487e+02,     7.763134425089351e+02,     7.794294175765120e+02,     7.824600794259537e+02,     7.854103672543449e+02, 
            7.882847970925313e+02,     7.910875093077307e+02,     7.938223095571268e+02,     7.964927042527108e+02,     7.991019314027022e+02, 
            8.016529875396955e+02,     8.041486513213210e+02,     8.065915042890733e+02,     8.089839491899334e+02,     8.113282261993722e+02, 
            8.136264273304080e+02,     8.158805092690184e+02,     8.180923048396382e+02,     8.202635332740903e+02,     8.223958094320561e+02, 
            8.244906521000527e+02,     8.265494914781572e+02,     8.285736759487614e+02,     8.305644782090326e+02,     8.325231008379980e+02, 
            8.344506813600595e+02,     8.363482968589421e+02,     8.382169681893700e+02,     8.400576638280377e+02,     8.418713034004677e+02, 
            8.436587609160589e+02,     8.454208677399185e+02,     8.471584153268268e+02,     8.488721577398613e+02,     8.505628139737580e+02, 
            8.522310701009093e+02,     8.538775812560173e+02,     8.555029734737441e+02,     8.571078453922285e+02,     8.586927698340528e+02, 
            8.602582952750673e+02,     8.618049472104807e+02,     8.633332294267062e+02,     8.648436251866401e+02,     8.663365983353440e+02, 
            8.678125943324341e+02,     8.692720412169250e+02,     8.707153505097457e+02,     8.721429180586849e+02,     8.735551248301024e+02, 
            8.749523376513680e+02,     8.763349099076580e+02,     8.777031821964108e+02,     8.790574829424978e+02,     8.803981289802814e+02, 
            8.817254261322056e+02,     8.830396697063574e+02,     8.843411449566139e+02,     8.856301264664185e+02,     8.869068820400796e+02, 
            8.881716686289774e+02,     8.894247359463001e+02,     8.906663250593274e+02,     8.918966695900748e+02,     8.931159958196650e+02, 
            8.943245229969361e+02,     8.955224636309739e+02,     8.967100237685646e+02,     8.978874032574759e+02,     8.990547959964429e+02, 
            9.002123901726362e+02,     9.013603684873666e+02,     9.024989083707089e+02,     9.036281822036304e+02,     9.047483574216885e+02, 
            9.058595968839338e+02,     9.069620588624782e+02,     9.080558973057565e+02,     9.091412619793711e+02,     9.102182986190259e+02, 
            9.112871490764986e+02,     9.123479514590219e+02,     9.134008402624296e+02,     9.144459464984042e+02,     9.154833978161288e+02, 
            9.165133186303315e+02,     9.175358301846825e+02,     9.185510507321306e+02,     9.195590955864124e+02,     9.205600772327947e+02, 
            9.215541054217335e+02,     9.225412872586626e+02,     9.235217272900954e+02,     9.244955274764993e+02,     9.254627876982412e+02, 
            9.264236052089709e+02,     9.273780751128591e+02,     9.283262903363330e+02,     9.292683416955191e+02,     9.302043179610589e+02, 
            9.311343059204379e+02,     9.320583904379300e+02,     9.329766545122708e+02,     9.338891793321626e+02,     9.347960443297093e+02, 
            9.356973272318634e+02,     9.365931041099975e+02,     9.374834494276519e+02,     9.383684360865616e+02,     9.392481354710279e+02, 
            9.401226174907023e+02,     9.409919506218592e+02,     9.418562019472172e+02,     9.427154371943649e+02,     9.435697207728622e+02, 
            9.444191158100593e+02,     9.452636841856930e+02,     9.461034865653091e+02,     9.469385824325566e+02,     9.477690301204082e+02, 
            9.485948868413331e+02,     9.494162087164794e+02,     9.502330508039048e+02,     9.510454671258738e+02,     9.518535106952884e+02, 
            9.526572335412607e+02,     9.534566867338684e+02,     9.542519204081301e+02,     9.550429837872267e+02,     9.558299252049882e+02, 
            9.566127921276905e+02,     9.573916311751757e+02,     9.581664881413219e+02,     9.589374080138936e+02,     9.597044349937872e+02, 
            9.604676125136974e+02,     9.612269832562315e+02,     9.619825891714740e+02,     9.627344714940423e+02,     9.634826707596337e+02, 
            9.642272268211020e+02,     9.649681788640515e+02,     9.657055654219918e+02,     9.664394243910608e+02,     9.671697930443183e+02, 
            9.678967080456441e+02,     9.686202054632419e+02,     9.693403207827618e+02,     9.700570889200663e+02,     9.707705442336354e+02, 
            9.714807205366346e+02,     9.721876511086526e+02,     9.728913687071185e+02,     9.735919055784157e+02,     9.742892930097145e+02, 
            9.749835631566900e+02,     9.756747463555489e+02,     9.763628729137533e+02,     9.770479726789811e+02,     9.777300750485830e+02, 
            9.784092089787915e+02,     9.790854029937022e+02,     9.797586851940096e+02,     9.804290832655322e+02,     9.810966244875135e+02, 
            9.817613357407182e+02,     9.824232435153211e+02,     9.830823739186004e+02,     9.837387526824396e+02,     9.843924051706442e+02, 
            9.850433563860769e+02,     9.856916309776192e+02,     9.863372532469652e+02,     9.869802471552449e+02,     9.876206363294953e+02, 
            9.882584440689726e+02,     9.888936933513113e+02,     9.895264068385430e+02,     9.901566068829677e+02,     9.907843155328891e+02, 
            9.914095545382191e+02,     9.920323453559436e+02,     9.926527091554717e+02,     9.932706668238538e+02,     9.938862389708845e+02, 
            9.944994459340869e+02,     9.951103077835843e+02,     9.957188443268631e+02,     9.963250751134268e+02,     9.969290194393474e+02, 
            9.975306963517119e+02,     9.981301246529760e+02,     9.987273229052181e+02,     9.993223094342981e+02,     9.999151023339306e+02, 
            1.000505719469664e+03,     1.001094178482778e+03,     1.001680496794094e+03,     1.002264691607703e+03,     1.002846779914621e+03, 
            1.003426778496354e+03,     1.004004703928401e+03,     1.004580572583672e+03,     1.005154400635844e+03,     1.005726204062640e+03, 
            1.006295998649040e+03,     1.006863799990432e+03,     1.007429623495689e+03,     1.007993484390190e+03,     1.008555397718780e+03, 
            1.009115378348657e+03,     1.009673440972220e+03,     1.010229600109846e+03,     1.010783870112613e+03,     1.011336265164974e+03, 
            1.011886799287368e+03,     1.012435486338796e+03,     1.012982340019325e+03,     1.013527373872556e+03,     1.014070601288049e+03, 
            1.014612035503681e+03,     1.015151689607978e+03,     1.015689576542390e+03,     1.016225709103529e+03,     1.016760099945359e+03, 
            1.017292761581345e+03,     1.017823706386567e+03,     1.018352946599787e+03,     1.018880494325476e+03,     1.019406361535812e+03, 
            1.019930560072634e+03,     1.020453101649353e+03,     1.020973997852848e+03,     1.021493260145302e+03,     1.022010899866022e+03, 
            1.022526928233219e+03,     1.023041356345757e+03,     1.023554195184863e+03,     1.024065455615823e+03,     1.024575148389629e+03, 
            1.025083284144602e+03,     1.025589873407997e+03,     1.026094926597562e+03,     1.026598454023080e+03,     1.027100465887882e+03, 
            1.027600972290332e+03,     1.028099983225285e+03,     1.028597508585521e+03,     1.029093558163155e+03,     1.029588141651021e+03, 
            1.030081268644030e+03,     1.030572948640507e+03,     1.031063191043508e+03,     1.031552005162106e+03,     1.032039400212663e+03, 
            1.032525385320078e+03,     1.033009969519012e+03,     1.033493161755090e+03,     1.033974970886096e+03,     1.034455405683124e+03, 
            1.034934474831740e+03,     1.035412186933095e+03,     1.035888550505039e+03,     1.036363573983213e+03,     1.036837265722115e+03, 
            1.037309633996158e+03,     1.037780687000705e+03,     1.038250432853090e+03,     1.038718879593621e+03,     1.039186035186567e+03, 
            1.039651907521128e+03,     1.040116504412391e+03,     1.040579833602275e+03,     1.041041902760443e+03,     1.041502719485231e+03, 
            1.041962291304525e+03,     1.042420625676658e+03,     1.042877729991269e+03,     1.043333611570158e+03,     1.043788277668132e+03, 
            1.044241735473824e+03,     1.044693992110516e+03,     1.045145054636939e+03,     1.045594930048058e+03,     1.046043625275855e+03, 
            1.046491147190093e+03,     1.046937502599069e+03,     1.047382698250354e+03,     1.047826740831533e+03,     1.048269636970913e+03, 
            1.048711393238241e+03,     1.049152016145398e+03,     1.049591512147088e+03,     1.050029887641517e+03,     1.050467148971057e+03, 
            1.050903302422908e+03,     1.051338354229743e+03,     1.051772310570344e+03,     1.052205177570239e+03,     1.052636961302309e+03, 
            1.053067667787411e+03,     1.053497302994972e+03,     1.053925872843582e+03,     1.054353383201583e+03,     1.054779839887640e+03, 
            1.055205248671311e+03,     1.055629615273604e+03,     1.056052945367529e+03,     1.056475244578643e+03,     1.056896518485586e+03, 
            1.057316772620604e+03,     1.057736012470075e+03,     1.058154243475021e+03,     1.058571471031609e+03,     1.058987700491657e+03, 
            1.059402937163123e+03,     1.059817186310587e+03,     1.060230453155732e+03,     1.060642742877817e+03,     1.061054060614139e+03, 
            1.061464411460493e+03,     1.061873800471624e+03,     1.062282232661673e+03,     1.062689713004618e+03,     1.063096246434707e+03, 
            1.063501837846884e+03,     1.063906492097216e+03,     1.064310214003307e+03,     1.064713008344707e+03,     1.065114879863321e+03, 
            1.065515833263807e+03,     1.065915873213970e+03,     1.066315004345153e+03,     1.066713231252621e+03,     1.067110558495938e+03, 
            1.067506990599344e+03,     1.067902532052120e+03,     1.068297187308960e+03,     1.068690960790320e+03,     1.069083856882781e+03, 
            1.069475879939396e+03,     1.069867034280035e+03,     1.070257324191729e+03,     1.070646753929002e+03,     1.071035327714207e+03, 
            1.071423049737856e+03,     1.071809924158937e+03,     1.072195955105239e+03,     1.072581146673667e+03,     1.072965502930554e+03, 
            1.073349027911965e+03,     1.073731725624004e+03,     1.074113600043116e+03,     1.074494655116377e+03,     1.074874894761790e+03, 
            1.075254322868577e+03,     1.075632943297456e+03,     1.076010759880933e+03,     1.076387776423568e+03,     1.076763996702261e+03, 
            1.077139424466515e+03,     1.077514063438710e+03,     1.077887917314363e+03,     1.078260989762390e+03,     1.078633284425370e+03, 
            1.079004804919788e+03,     1.079375554836299e+03,     1.079745537739973e+03,     1.080114757170536e+03,     1.080483216642617e+03, 
            1.080850919645991e+03,     1.081217869645808e+03,     1.081584070082835e+03,     1.081949524373682e+03,     1.082314235911033e+03, 
            1.082678208063873e+03,     1.083041444177709e+03,     1.083403947574789e+03,     1.083765721554325e+03,     1.084126769392705e+03, 
            1.084487094343705e+03,     1.084846699638703e+03,     1.085205588486883e+03,     1.085563764075442e+03,     1.085921229569795e+03, 
            1.086277988113773e+03,     1.086634042829820e+03,     1.086989396819196e+03,     1.087344053162161e+03,     1.087698014918176e+03, 
            1.088051285126085e+03,     1.088403866804307e+03,     1.088755762951019e+03,     1.089106976544341e+03,     1.089457510542511e+03, 
            1.089807367884073e+03,     1.090156551488046e+03,     1.090505064254103e+03,     1.090852909062742e+03,     1.091200088775458e+03, 
            1.091546606234909e+03,     1.091892464265090e+03,     1.092237665671491e+03,     1.092582213241262e+03,     1.092926109743379e+03, 
            1.093269357928798e+03,     1.093611960530616e+03,     1.093953920264229e+03,     1.094295239827480e+03,     1.094635921900821e+03, 
            1.094975969147455e+03,     1.095315384213494e+03,     1.095654169728099e+03,     1.095992328303634e+03,     1.096329862535803e+03, 
            1.096666775003801e+03,     1.097003068270446e+03,     1.097338744882329e+03,     1.097673807369948e+03,     1.098008258247842e+03, 
            1.098342100014733e+03,     1.098675335153655e+03,     1.099007966132090e+03,     1.099339995402096e+03,     1.099671425400440e+03
    },
    {
            1.687492764277788e+00,     5.108797422785619e+00,     8.589384145221539e+00,     1.213181388043851e+01,     1.573882690846042e+01, 
            1.941335999055513e+01,     2.315856562805556e+01,     2.697783375568327e+01,     3.087481624661004e+01,     3.485345468517085e+01, 
            3.891801194773304e+01,     4.307310824154109e+01,     4.732376238506362e+01,     5.167543927975428e+01,     5.613410473137306e+01, 
            6.070628904086646e+01,     6.539916111732015e+01,     7.022061528933033e+01,     7.517937353691259e+01,     8.028510657357094e+01, 
            8.554857813355264e+01,     9.098181804058858e+01,     9.659833126169815e+01,     1.024133523401583e+02,     1.084441575827334e+02, 
            1.147104514805360e+02,     1.212348495646527e+02,     1.280434879819748e+02,     1.351668016648679e+02,     1.426405298647576e+02, 
            1.505070326381898e+02,     1.588170399429990e+02,     1.676320122163097e+02,     1.770273826412980e+02,     1.870970964018344e+02, 
            1.979601003541539e+02,     2.097698336478324e+02,     2.227284403699087e+02,     2.371085497143526e+02,     2.532872451006224e+02, 
            2.717990193238483e+02,     2.934139683100406e+02,     3.192291693284744e+02,     3.506844218377927e+02,     3.892265855652244e+02, 
            4.344637430131121e+02,     4.801982814344195e+02,     5.199574282595712e+02,     5.518414823677199e+02,     5.769989108943120e+02, 
            5.973219475656610e+02,     6.142342445081017e+02,     6.286663403566922e+02,     6.412320974875058e+02,     6.523514757317241e+02, 
            6.623218218960645e+02,     6.713599742185321e+02,     6.796281598650612e+02,     6.872504928123310e+02,     6.943238030091170e+02, 
            7.009249393146014e+02,     7.071158185319347e+02,     7.129469965823781e+02,     7.184602469622309e+02,     7.236904571274727e+02, 
            7.286670464107731e+02,     7.334150419186292e+02,     7.379559057675544e+02,     7.423081787648546e+02,     7.464879867286858e+02, 
            7.505094427403502e+02,     7.543849696639454e+02,     7.581255609488688e+02,     7.617409932073452e+02,     7.652400007786629e+02, 
            7.686304200842486e+02,     7.719193097913372e+02,     7.751130514644012e+02,     7.782174343710363e+02,     7.812377273367708e+02, 
            7.841787399494951e+02,     7.870448749542710e+02,     7.898401733204978e+02,     7.925683531817026e+02,     7.952328436255524e+02, 
            7.978368141347165e+02,     8.003832003376893e+02,     8.028747266148933e+02,     8.053139260134317e+02,     8.077031578491594e+02, 
            8.100446233137302e+02,     8.123403793542965e+02,     8.145923510522842e+02,     8.168023426935775e+02,     8.189720476940984e+02, 
            8.211030575211034e+02,     8.231968697306969e+02,     8.252548952253979e+02,     8.272784648215243e+02,     8.292688352042272e+02, 
            8.312271943378823e+02,     8.331546663908993e+02,     8.350523162266071e+02,     8.369211535055366e+02,     8.387621364389349e+02, 
            8.405761752286456e+02,     8.423641352243955e+02,     8.441268398259672e+02,     8.458650731546726e+02,     8.475795825158210e+02, 
            8.492710806715381e+02,     8.509402479412166e+02,     8.525877341450440e+02,     8.542141604044956e+02,     8.558201208122173e+02, 
            8.574061839825106e+02,     8.589728944925063e+02,     8.605207742231374e+02,     8.620503236081363e+02,     8.635620227985199e+02, 
            8.650563327493138e+02,     8.665336962346486e+02,     8.679945387968085e+02,     8.694392696343076e+02,     8.708682824336244e+02, 
            8.722819561488085e+02,     8.736806557328295e+02,     8.750647328241924e+02,     8.764345263920443e+02,     8.777903633437450e+02, 
            8.791325591232244e+02,     8.804614182510512e+02,     8.817772347993056e+02,     8.830802919520963e+02,     8.843708653655705e+02, 
            8.856492198394658e+02,     8.869156125222099e+02,     8.881702916130383e+02,     8.894134975795682e+02,     8.906454632761705e+02, 
            8.918664142661582e+02,     8.930765691270841e+02,     8.942761397402049e+02,     8.954653315650874e+02,     8.966443439002438e+02, 
            8.978133701306602e+02,     8.989725979804325e+02,     9.001222096654122e+02,     9.012623821961297e+02,     9.023932875799159e+02, 
            9.035150929201044e+02,     9.046279606759919e+02,     9.057320488181176e+02,     9.068275109949697e+02,     9.079144966919883e+02, 
            9.089931513832854e+02,     9.100636166764816e+02,     9.111260304510295e+02,     9.121805269903675e+02,     9.132272371082428e+02, 
            9.142662882810772e+02,     9.152978047160078e+02,     9.163219075345755e+02,     9.173387148284887e+02,     9.183483417738740e+02, 
            9.193509007283959e+02,     9.203465013243309e+02,     9.213352505577977e+02,     9.223172528743455e+02,     9.232926102510562e+02, 
            9.242614221444929e+02,     9.252237860759777e+02,     9.261797969594965e+02,     9.271295476555180e+02,     9.280731289200390e+02, 
            9.290106294690730e+02,     9.299421360406542e+02,     9.308677334544888e+02,     9.317875046693442e+02,     9.327015308382928e+02, 
            9.336098913618928e+02,     9.345126639394067e+02,     9.354099246181438e+02,     9.363017478410036e+02,     9.371882064923069e+02, 
            9.380693719419734e+02,     9.389453140881407e+02,     9.398161013982631e+02,     9.406818009487798e+02,     9.415424784633933e+02, 
            9.423981983500281e+02,     9.432490237365217e+02,     9.440950165050925e+02,     9.449362373256469e+02,     9.457727456879632e+02, 
            9.466045999328012e+02,     9.474318572819822e+02,     9.482545738674742e+02,     9.490728047595302e+02,     9.498866039939080e+02, 
            9.506960245982177e+02,     9.515011186174132e+02,     9.523019371384881e+02,     9.530985303143738e+02,     9.538909473871007e+02, 
            9.546792367102230e+02,     9.554634457705606e+02,     9.562436212092609e+02,     9.570198088422205e+02,     9.577920536798874e+02, 
            9.585603999464561e+02,     9.593248910984968e+02,     9.600855698430189e+02,     9.608424781550067e+02,     9.615956572944307e+02, 
            9.623451478227653e+02,     9.630909896190226e+02,     9.638332218953254e+02,     9.645718832120272e+02,     9.653070114924056e+02, 
            9.660386440369307e+02,     9.667668175371392e+02,     9.674915680891106e+02,     9.682129312065703e+02,     9.689309418336318e+02, 
            9.696456343571832e+02,     9.703570426189340e+02,     9.710651999271340e+02,     9.717701390679788e+02,     9.724718918611587e+02, 
            9.731704909741410e+02,     9.738659672549717e+02,     9.745583515096217e+02,     9.752476740745931e+02,     9.759339648266172e+02, 
            9.766172531921009e+02,     9.772975681563278e+02,     9.779749382724218e+02,     9.786493916700806e+02,     9.793209560640862e+02, 
            9.799896587626006e+02,     9.806555266752514e+02,     9.813185863210135e+02,     9.819788638358954e+02,     9.826363849804321e+02, 
            9.832911751470003e+02,     9.839432593669420e+02,     9.845926623175230e+02,     9.852394083287193e+02,     9.858835213898401e+02, 
            9.865250251559876e+02,     9.871639429543691e+02,     9.878002977904517e+02,     9.884341123539737e+02,     9.890654090248173e+02, 
            9.896942098787371e+02,     9.903205366929614e+02,     9.909444109516579e+02,     9.915658538512754e+02,     9.921848863057650e+02, 
            9.928015289516768e+02,     9.934158021531424e+02,     9.940277260067456e+02,     9.946373203462852e+02,     9.952446047474218e+02, 
            9.958495985322338e+02,     9.964523207736596e+02,     9.970527902998502e+02,     9.976510256984211e+02,     9.982470453206134e+02, 
            9.988408672853633e+02,     9.994325094832810e+02,     1.000021989580548e+03,     1.000609325022725e+03,     1.001194533038485e+03, 
            1.001777630643260e+03,     1.002358634642814e+03,     1.002937561636737e+03,     1.003514428021873e+03,     1.004089249995668e+03, 
            1.004662043559452e+03,     1.005232824521649e+03,     1.005801608500930e+03,     1.006368410929289e+03,     1.006933247055064e+03, 
            1.007496131945896e+03,     1.008057080491622e+03,     1.008616107407116e+03,     1.009173227235070e+03,     1.009728454348717e+03, 
            1.010281802954507e+03,     1.010833287094719e+03,     1.011382920650031e+03,     1.011930717342032e+03,     1.012476690735693e+03, 
            1.013020854241778e+03,     1.013563221119220e+03,     1.014103804477443e+03,     1.014642617278642e+03,     1.015179672340020e+03, 
            1.015714982335981e+03,     1.016248559800278e+03,     1.016780417128127e+03,     1.017310566578276e+03,     1.017839020275034e+03, 
            1.018365790210269e+03,     1.018890888245359e+03,     1.019414326113114e+03,     1.019936115419661e+03,     1.020456267646288e+03, 
            1.020974794151265e+03,     1.021491706171621e+03,     1.022007014824895e+03,     1.022520731110852e+03,     1.023032865913173e+03, 
            1.023543430001106e+03,     1.024052434031094e+03,     1.024559888548371e+03,     1.025065803988533e+03,     1.025570190679073e+03, 
            1.026073058840898e+03,     1.026574418589816e+03,     1.027074279937993e+03,     1.027572652795390e+03,     1.028069546971173e+03, 
            1.028564972175094e+03,     1.029058938018858e+03,     1.029551454017456e+03,     1.030042529590482e+03,     1.030532174063423e+03, 
            1.031020396668931e+03,     1.031507206548070e+03,     1.031992612751545e+03,     1.032476624240904e+03,     1.032959249889731e+03, 
            1.033440498484807e+03,     1.033920378727256e+03,     1.034398899233679e+03,     1.034876068537255e+03,     1.035351895088838e+03, 
            1.035826387258026e+03,     1.036299553334218e+03,     1.036771401527649e+03,     1.037241939970414e+03,     1.037711176717470e+03, 
            1.038179119747626e+03,     1.038645776964513e+03,     1.039111156197540e+03,     1.039575265202839e+03,     1.040038111664186e+03, 
            1.040499703193913e+03,     1.040960047333811e+03,     1.041419151556004e+03,     1.041877023263821e+03,     1.042333669792654e+03, 
            1.042789098410794e+03,     1.043243316320267e+03,     1.043696330657641e+03,     1.044148148494836e+03,     1.044598776839910e+03, 
            1.045048222637839e+03,     1.045496492771284e+03,     1.045943594061346e+03,     1.046389533268307e+03,     1.046834317092364e+03, 
            1.047277952174347e+03,     1.047720445096433e+03,     1.048161802382843e+03,     1.048602030500529e+03,     1.049041135859854e+03, 
            1.049479124815262e+03,     1.049916003665932e+03,     1.050351778656431e+03,     1.050786455977350e+03,     1.051220041765935e+03, 
            1.051652542106705e+03,     1.052083963032069e+03,     1.052514310522920e+03,     1.052943590509234e+03,     1.053371808870654e+03, 
            1.053798971437066e+03,     1.054225083989167e+03,     1.054650152259024e+03,     1.055074181930629e+03,     1.055497178640441e+03, 
            1.055919147977918e+03,     1.056340095486056e+03,     1.056760026661899e+03,     1.057178946957060e+03,     1.057596861778227e+03, 
            1.058013776487658e+03,     1.058429696403677e+03,     1.058844626801159e+03,     1.059258572912009e+03,     1.059671539925635e+03, 
            1.060083532989410e+03,     1.060494557209136e+03,     1.060904617649491e+03,     1.061313719334485e+03,     1.061721867247890e+03, 
            1.062129066333681e+03,     1.062535321496464e+03,     1.062940637601896e+03,     1.063345019477107e+03,     1.063748471911105e+03, 
            1.064150999655187e+03,     1.064552607423340e+03,     1.064953299892631e+03,     1.065353081703602e+03,     1.065751957460652e+03, 
            1.066149931732418e+03,     1.066547009052148e+03,     1.066943193918073e+03,     1.067338490793770e+03,     1.067732904108522e+03, 
            1.068126438257673e+03,     1.068519097602982e+03,     1.068910886472962e+03,     1.069301809163232e+03,     1.069691869936844e+03, 
            1.070081073024621e+03,     1.070469422625485e+03,     1.070856922906781e+03,     1.071243578004598e+03,     1.071629392024082e+03, 
            1.072014369039753e+03,     1.072398513095810e+03,     1.072781828206435e+03,     1.073164318356093e+03,     1.073545987499832e+03, 
            1.073926839563573e+03,     1.074306878444398e+03,     1.074686108010839e+03,     1.075064532103160e+03,     1.075442154533629e+03, 
            1.075818979086803e+03,     1.076195009519790e+03,     1.076570249562526e+03,     1.076944702918034e+03,     1.077318373262687e+03, 
            1.077691264246469e+03,     1.078063379493226e+03,     1.078434722600924e+03,     1.078805297141893e+03,     1.079175106663075e+03, 
            1.079544154686270e+03,     1.079912444708371e+03,     1.080279980201604e+03,     1.080646764613767e+03,     1.081012801368451e+03, 
            1.081378093865282e+03,     1.081742645480136e+03,     1.082106459565369e+03,     1.082469539450037e+03,     1.082831888440111e+03, 
            1.083193509818699e+03,     1.083554406846251e+03,     1.083914582760779e+03,     1.084274040778055e+03,     1.084632784091826e+03, 
            1.084990815874013e+03,     1.085348139274910e+03,     1.085704757423390e+03,     1.086060673427091e+03,     1.086415890372621e+03, 
            1.086770411325741e+03,     1.087124239331560e+03,     1.087477377414721e+03,     1.087829828579587e+03,     1.088181595810421e+03, 
            1.088532682071574e+03,     1.088883090307655e+03,     1.089232823443718e+03,     1.089581884385429e+03,     1.089930276019242e+03, 
            1.090278001212573e+03,     1.090625062813966e+03,     1.090971463653259e+03,     1.091317206541756e+03,     1.091662294272381e+03, 
            1.092006729619849e+03,     1.092350515340821e+03,     1.092693654174065e+03,     1.093036148840608e+03,     1.093378002043897e+03, 
            1.093719216469948e+03,     1.094059794787498e+03,     1.094399739648155e+03,     1.094739053686547e+03,     1.095077739520468e+03, 
            1.095415799751024e+03,     1.095753236962773e+03,     1.096090053723871e+03,     1.096426252586210e+03,     1.096761836085556e+03, 
            1.097096806741689e+03,     1.097431167058536e+03,     1.097764919524308e+03,     1.098098066611633e+03,     1.098430610777682e+03
    },
    {
            1.684223565686954e+00,     5.098620119505043e+00,     8.571780819744934e+00,     1.210622265726588e+01,     1.570463723873521e+01, 
            1.936990730771923e+01,     2.310512527328698e+01,     2.691361405252801e+01,     3.079895058069120e+01,     3.476499241585131e+01, 
            3.881590794285063e+01,     4.295621078192986e+01,     4.719079913012835e+01,     5.152500091572920e+01,     5.596462583574579e+01, 
            6.051602558461745e+01,     6.518616388252134e+01,     6.998269829443420e+01,     7.491407632014527e+01,     7.998964886754329e+01, 
            8.521980504364097e+01,     9.061613327699634e+01,     9.619161521464470e+01,     1.019608607485077e+02,     1.079403951098023e+02, 
            1.141490124997854e+02,     1.206082156046792e+02,     1.273427671729370e+02,     1.343813895230647e+02,     1.417576618188639e+02, 
            1.495111851902713e+02,     1.576891164312939e+02,     1.663482162032999e+02,     1.755576286386698e+02,     1.854027193885554e+02, 
            1.959904754604628e+02,     2.074572553883393e+02,     2.199801425487142e+02,     2.337938982604148e+02,     2.492166167218773e+02, 
            2.666884017044568e+02,     2.868267279464555e+02,     3.104909983288799e+02,     3.388036061904151e+02,     3.729743501733097e+02, 
            4.134698709927084e+02,     4.573137746619862e+02,     4.981461980500480e+02,     5.326430902323903e+02,     5.604343297032636e+02, 
            5.828632599892445e+02,     6.013915462192475e+02,     6.170817029445755e+02,     6.306495030784603e+02,     6.425838940891010e+02, 
            6.532292503824037e+02,     6.628352865568938e+02,     6.715877653027532e+02,     6.796280165829136e+02,     6.870657184596309e+02, 
            6.939874870750613e+02,     7.004627898425750e+02,     7.065481076223595e+02,     7.122899252101280e+02,     7.177269205800903e+02, 
            7.228915948530421e+02,     7.278115043974979e+02,     7.325102049354240e+02,     7.370079838850975e+02,     7.413224347770176e+02, 
            7.454689123808313e+02,     7.494608966828137e+02,     7.533102864807116e+02,     7.570276381066042e+02,     7.606223609895644e+02, 
            7.641028789897759e+02,     7.674767643782167e+02,     7.707508497972694e+02,     7.739313223760703e+02,     7.770238032898212e+02, 
            7.800334153731985e+02,     7.829648408727293e+02,     7.858223710138064e+02,     7.886099487371368e+02,     7.913312057062067e+02, 
            7.939894944863067e+02,     7.965879166351585e+02,     7.991293473163203e+02,     8.016164569425569e+02,     8.040517302720037e+02, 
            8.064374833111950e+02,     8.087758783227440e+02,     8.110689371891157e+02,     8.133185533456870e+02,     8.155265024645390e+02, 
            8.176944520439523e+02,     8.198239700364816e+02,     8.219165326298776e+02,     8.239735312794927e+02,     8.259962790775484e+02, 
            8.279860165334222e+02,     8.299439168295280e+02,     8.318710906091839e+02,     8.337685903458914e+02,     8.356374143373707e+02, 
            8.374785103625566e+02,     8.392927790352460e+02,     8.410810768841941e+02,     8.428442191860852e+02,     8.445829825748519e+02, 
            8.462981074482431e+02,     8.479903001902719e+02,     8.496602352262271e+02,     8.513085569251521e+02,     8.529358813631918e+02, 
            8.545427979598308e+02,     8.561298709978613e+02,     8.576976410368428e+02,     8.592466262288726e+02,     8.607773235446516e+02, 
            8.622902099170661e+02,     8.637857433088434e+02,     8.652643637102422e+02,     8.667264940721815e+02,     8.681725411797596e+02, 
            8.696028964706481e+02,     8.710179368024773e+02,     8.724180251729648e+02,     8.738035113962322e+02,     8.751747327385799e+02, 
            8.765320145353677e+02,     8.778756707728194e+02,     8.792060045826937e+02,     8.805233079581861e+02,     8.818278646597443e+02, 
            8.831199475271932e+02,     8.843998213392726e+02,     8.856677416139572e+02,     8.869239558416207e+02,     8.881687036184466e+02, 
            8.894022169826923e+02,     8.906247207332218e+02,     8.918364327314183e+02,     8.930375641875102e+02,     8.942283199492566e+02, 
            8.954088986907449e+02,     8.965794932628502e+02,     8.977402908545367e+02,     8.988914732160188e+02,     9.000332169365605e+02, 
            9.011656935419213e+02,     9.022890697554990e+02,     9.034035076621850e+02,     9.045091648816858e+02,     9.056061947337937e+02, 
            9.066947463960410e+02,     9.077749650541707e+02,     9.088469920458002e+02,     9.099109649976428e+02,     9.109670179565771e+02, 
            9.120152815267762e+02,     9.130558829419790e+02,     9.140889462531434e+02,     9.151145923883608e+02,     9.161329392707747e+02, 
            9.171441019192536e+02,     9.181481925448525e+02,     9.191453206432750e+02,     9.201355930835305e+02,     9.211191141929761e+02, 
            9.220959858389134e+02,     9.230663075069147e+02,     9.240301762212429e+02,     9.249876872206794e+02,     9.259389331447525e+02, 
            9.268840046751001e+02,     9.278229904593048e+02,     9.287559771725711e+02,     9.296830495770597e+02,     9.306042905789834e+02, 
            9.315197812835692e+02,     9.324296010479778e+02,     9.333338275322745e+02,     9.342325367485375e+02,     9.351258031081780e+02, 
            9.360136994675649e+02,     9.368962971720056e+02,     9.377736660981761e+02,     9.386458746950470e+02,     9.395129900233852e+02, 
            9.403750777938702e+02,     9.412322024039141e+02,     9.420844269732005e+02,     9.429318133780275e+02,     9.437744222844877e+02, 
            9.446123131805294e+02,     9.454455444069596e+02,     9.462741731874094e+02,     9.470982556573263e+02,     9.479178468920123e+02, 
            9.487330009337546e+02,     9.495437708180846e+02,     9.503502085991967e+02,     9.511523653745514e+02,     9.519502913087201e+02, 
            9.527440356564587e+02,     9.535336467850805e+02,     9.543191721961276e+02,     9.551006585463789e+02,     9.558781516682130e+02, 
            9.566516965893550e+02,     9.574213375520311e+02,     9.581871180315359e+02,     9.589490807542651e+02,     9.597072677151967e+02, 
            9.604617201948668e+02,     9.612124787758490e+02,     9.619595833587531e+02,     9.627030731777563e+02,     9.634429868156982e+02, 
            9.641793622187355e+02,     9.649122367105907e+02,     9.656416470063870e+02,     9.663676292261026e+02,     9.670902189076526e+02, 
            9.678094510195989e+02,     9.685253599735188e+02,     9.692379796360303e+02,     9.699473433404893e+02,     9.706534834463386e+02, 
            9.713564331396855e+02,     9.720562237872834e+02,     9.727528867002414e+02,     9.734464527103490e+02,     9.741369521800223e+02, 
            9.748244150119865e+02,     9.755088706587109e+02,     9.761903481315917e+02,     9.768688760099111e+02,     9.775444824495524e+02, 
            9.782171951915051e+02,     9.788870415701463e+02,     9.795540485213198e+02,     9.802182425902033e+02,     9.808796499389946e+02, 
            9.815382963543893e+02,     9.821942072548883e+02,     9.828474076979177e+02,     9.834979223867779e+02,     9.841457756774256e+02, 
            9.847909915850871e+02,     9.854335937907156e+02,     9.860736056472945e+02,     9.867110501859904e+02,     9.873459501221587e+02, 
            9.879783278612082e+02,     9.886082055043304e+02,     9.892356048540937e+02,     9.898605474199052e+02,     9.904830544233508e+02, 
            9.911031468034112e+02,     9.917208452215543e+02,     9.923361700667195e+02,     9.929491414601816e+02,     9.935597792603101e+02, 
            9.941681030672192e+02,     9.947741322273142e+02,     9.953778858377383e+02,     9.959793827507192e+02,     9.965786415778201e+02, 
            9.971756806941012e+02,     9.977705182421844e+02,     9.983631721362327e+02,     9.989536600658475e+02,     9.995419994998733e+02, 
            1.000128207690130e+03,     1.000712301675059e+03,     1.001294298283295e+03,     1.001874214137164e+03,     1.002452065656102e+03, 
            1.003027869060007e+03,     1.003601640372523e+03,     1.004173395424245e+03,     1.004743149855876e+03,     1.005310919121298e+03, 
            1.005876718490598e+03,     1.006440563053023e+03,     1.007002467719873e+03,     1.007562447227344e+03,     1.008120516139311e+03, 
            1.008676688850043e+03,     1.009230979586889e+03,     1.009783402412884e+03,     1.010333971229319e+03,     1.010882699778261e+03, 
            1.011429601645010e+03,     1.011974690260527e+03,     1.012517978903797e+03,     1.013059480704160e+03,     1.013599208643585e+03, 
            1.014137175558913e+03,     1.014673394144046e+03,     1.015207876952100e+03,     1.015740636397515e+03,     1.016271684758127e+03, 
            1.016801034177200e+03,     1.017328696665419e+03,     1.017854684102845e+03,     1.018379008240840e+03,     1.018901680703945e+03, 
            1.019422712991734e+03,     1.019942116480629e+03,     1.020459902425680e+03,     1.020976081962319e+03,     1.021490666108073e+03, 
            1.022003665764255e+03,     1.022515091717618e+03,     1.023024954641985e+03,     1.023533265099840e+03,     1.024040033543903e+03, 
            1.024545270318670e+03,     1.025048985661926e+03,     1.025551189706229e+03,     1.026051892480379e+03,     1.026551103910846e+03, 
            1.027048833823183e+03,     1.027545091943412e+03,     1.028039887899386e+03,     1.028533231222128e+03,     1.029025131347144e+03, 
            1.029515597615719e+03,     1.030004639276186e+03,     1.030492265485173e+03,     1.030978485308837e+03,     1.031463307724064e+03, 
            1.031946741619663e+03,     1.032428795797528e+03,     1.032909478973788e+03,     1.033388799779933e+03,     1.033866766763929e+03, 
            1.034343388391303e+03,     1.034818673046220e+03,     1.035292629032539e+03,     1.035765264574851e+03,     1.036236587819498e+03, 
            1.036706606835585e+03,     1.037175329615960e+03,     1.037642764078192e+03,     1.038108918065530e+03,     1.038573799347837e+03, 
            1.039037415622528e+03,     1.039499774515470e+03,     1.039960883581888e+03,     1.040420750307247e+03,     1.040879382108119e+03, 
            1.041336786333039e+03,     1.041792970263350e+03,     1.042247941114031e+03,     1.042701706034512e+03,     1.043154272109480e+03, 
            1.043605646359666e+03,     1.044055835742632e+03,     1.044504847153530e+03,     1.044952687425862e+03,     1.045399363332222e+03, 
            1.045844881585030e+03,     1.046289248837252e+03,     1.046732471683112e+03,     1.047174556658791e+03,     1.047615510243117e+03, 
            1.048055338858242e+03,     1.048494048870316e+03,     1.048931646590138e+03,     1.049368138273814e+03,     1.049803530123390e+03, 
            1.050237828287485e+03,     1.050671038861913e+03,     1.051103167890292e+03,     1.051534221364648e+03,     1.051964205226012e+03, 
            1.052393125364999e+03,     1.052820987622395e+03,     1.053247797789715e+03,     1.053673561609769e+03,     1.054098284777217e+03, 
            1.054521972939108e+03,     1.054944631695421e+03,     1.055366266599592e+03,     1.055786883159037e+03,     1.056206486835665e+03, 
            1.056625083046390e+03,     1.057042677163622e+03,     1.057459274515769e+03,     1.057874880387718e+03,     1.058289500021315e+03, 
            1.058703138615842e+03,     1.059115801328476e+03,     1.059527493274755e+03,     1.059938219529028e+03,     1.060347985124904e+03, 
            1.060756795055690e+03,     1.061164654274835e+03,     1.061571567696345e+03,     1.061977540195219e+03,     1.062382576607861e+03, 
            1.062786681732492e+03,     1.063189860329557e+03,     1.063592117122128e+03,     1.063993456796298e+03,     1.064393884001570e+03, 
            1.064793403351244e+03,     1.065192019422798e+03,     1.065589736758261e+03,     1.065986559864584e+03,     1.066382493214008e+03, 
            1.066777541244415e+03,     1.067171708359700e+03,     1.067564998930105e+03,     1.067957417292577e+03,     1.068348967751106e+03, 
            1.068739654577063e+03,     1.069129482009532e+03,     1.069518454255642e+03,     1.069906575490890e+03,     1.070293849859461e+03, 
            1.070680281474547e+03,     1.071065874418655e+03,     1.071450632743923e+03,     1.071834560472415e+03,     1.072217661596430e+03, 
            1.072599940078795e+03,     1.072981399853161e+03,     1.073362044824287e+03,     1.073741878868333e+03,     1.074120905833139e+03, 
            1.074499129538502e+03,     1.074876553776456e+03,     1.075253182311542e+03,     1.075629018881073e+03,     1.076004067195405e+03, 
            1.076378330938199e+03,     1.076751813766674e+03,     1.077124519311869e+03,     1.077496451178893e+03,     1.077867612947174e+03, 
            1.078238008170707e+03,     1.078607640378298e+03,     1.078976513073802e+03,     1.079344629736364e+03,     1.079711993820650e+03, 
            1.080078608757085e+03,     1.080444477952076e+03,     1.080809604788242e+03,     1.081173992624638e+03,     1.081537644796976e+03, 
            1.081900564617841e+03,     1.082262755376910e+03,     1.082624220341168e+03,     1.082984962755112e+03,     1.083344985840964e+03, 
            1.083704292798877e+03,     1.084062886807140e+03,     1.084420771022375e+03,     1.084777948579738e+03,     1.085134422593120e+03, 
            1.085490196155335e+03,     1.085845272338315e+03,     1.086199654193302e+03,     1.086553344751030e+03,     1.086906347021918e+03, 
            1.087258663996249e+03,     1.087610298644352e+03,     1.087961253916784e+03,     1.088311532744502e+03,     1.088661138039045e+03, 
            1.089010072692702e+03,     1.089358339578687e+03,     1.089705941551307e+03,     1.090052881446130e+03,     1.090399162080148e+03, 
            1.090744786251949e+03,     1.091089756741869e+03,     1.091434076312160e+03,     1.091777747707144e+03,     1.092120773653370e+03, 
            1.092463156859776e+03,     1.092804900017830e+03,     1.093146005801693e+03,     1.093486476868362e+03,     1.093826315857824e+03, 
            1.094165525393197e+03,     1.094504108080881e+03,     1.094842066510694e+03,     1.095179403256023e+03,     1.095516120873959e+03, 
            1.095852221905437e+03,     1.096187708875372e+03,     1.096522584292800e+03,     1.096856850651007e+03,     1.097190510427667e+03
    },
    {
            1.680967193028602e+00,     5.088485035178700e+00,     8.554254657707633e+00,     1.208074990621113e+01,     1.567061465595454e+01, 
            1.932667872733356e+01,     2.305197571243631e+01,     2.684976300089687e+01,     3.072354433665294e+01,     3.467709530534465e+01, 
            3.871449222369525e+01,     4.284014499491099e+01,     4.705883460666855e+01,     5.137575608745053e+01,     5.579656790995134e+01, 
            6.032744904645195e+01,     6.497516515327473e+01,     6.974714570533128e+01,     7.465157434190031e+01,     7.969749524838734e+01, 
            8.489493912997372e+01,     9.025507328688056e+01,     9.579038155720518e+01,     1.015148815628179e+02,     1.074443889343880e+02, 
            1.135968412298260e+02,     1.199926984257722e+02,     1.266554426394960e+02,     1.336122078531163e+02,     1.408945819805289e+02, 
            1.485396401594443e+02,     1.565912928992671e+02,     1.651020685221612e+02,     1.741355046882548e+02,     1.837694077892950e+02, 
            1.941003702411679e+02,     2.052501418967070e+02,     2.173747758218818e+02,     2.306779652496156e+02,     2.454306825921874e+02, 
            2.619999083471058e+02,     2.808886051275908e+02,     3.027820623481198e+02,     3.285685043703044e+02,     3.592408412676770e+02, 
            3.954735811986142e+02,     4.361881250264299e+02,     4.767633185696477e+02,     5.128969709672155e+02,     5.430549571522539e+02, 
            5.676529077261289e+02,     5.879186030367989e+02,     6.049730112714863e+02,     6.196268453699031e+02,     6.324423801418088e+02, 
            6.438154050565666e+02,     6.540318041732379e+02,     6.633032832321212e+02,     6.717901522694069e+02,     6.796162374878676e+02, 
            6.868788894586639e+02,     6.936558552517408e+02,     7.000100987111525e+02,     7.059932498137432e+02,     7.116481193663174e+02, 
            7.170105638669299e+02,     7.221108900445774e+02,     7.269749275848983e+02,     7.316248588087489e+02,     7.360798677097076e+02, 
            7.403566529511954e+02,     7.444698371837036e+02,     7.484322964868111e+02,     7.522554276665966e+02,     7.559493667650967e+02, 
            7.595231689474459e+02,     7.629849575766715e+02,     7.663420485283698e+02,     7.696010544728914e+02,     7.727679728455173e+02, 
            7.758482604529775e+02,     7.788468970680708e+02,     7.817684399000444e+02,     7.846170704646908e+02,     7.873966350915684e+02, 
            7.901106800783737e+02,     7.927624823212598e+02,     7.953550761044714e+02,     7.978912766155078e+02,     8.003737006570880e+02, 
            8.028047849498972e+02,     8.051868023569120e+02,     8.075218763081725e+02,     8.098119936620417e+02,     8.120590162034903e+02, 
            8.142646909504452e+02,     8.164306594145467e+02,     8.185584659420323e+02,     8.206495652430330e+02,     8.227053292029002e+02, 
            8.247270530567318e+02,     8.267159609976781e+02,     8.286732112805836e+02,     8.305999008748053e+02,     8.324970697133958e+02, 
            8.343657045801639e+02,     8.362067426711582e+02,     8.380210748629057e+02,     8.398095487159792e+02,     8.415729712392869e+02, 
            8.433121114376529e+02,     8.450277026627854e+02,     8.467204447856058e+02,     8.483910062059832e+02,     8.500400257142787e+02, 
            8.516681142176200e+02,     8.532758563425298e+02,     8.548638119243764e+02,     8.564325173930954e+02,     8.579824870637246e+02, 
            8.595142143394693e+02,     8.610281728343145e+02,     8.625248174215343e+02,     8.640045852138769e+02,     8.654678964806891e+02, 
            8.669151555067717e+02,     8.683467513973344e+02,     8.697630588330555e+02,     8.711644387788888e+02,     8.725512391499716e+02, 
            8.739237954487393e+02,     8.752824313839386e+02,     8.766274593922983e+02,     8.779591804902547e+02,     8.792778867941709e+02, 
            8.805838593806595e+02,     8.818773708566972e+02,     8.831586842484395e+02,     8.844280542486503e+02,     8.856857273662075e+02, 
            8.869319422769480e+02,     8.881669301559127e+02,     8.893909150087491e+02,     8.906041139027089e+02,     8.918067373526922e+02, 
            8.929989895201035e+02,     8.941810684857909e+02,     8.953531664759633e+02,     8.965154701600612e+02,     8.976681607664942e+02, 
            8.988114143617221e+02,     8.999454020306931e+02,     9.010702900659161e+02,     9.021862401476053e+02,     9.032934095154227e+02, 
            9.043919511322640e+02,     9.054820138405347e+02,     9.065637425113248e+02,     9.076372781868591e+02,     9.087027582291724e+02, 
            9.097603163985727e+02,     9.108100830574631e+02,     9.118521852348482e+02,     9.128867467541671e+02,     9.139138883422536e+02, 
            9.149337277336687e+02,     9.159463797706542e+02,     9.169519564989183e+02,     9.179505672594521e+02,     9.189423187765976e+02, 
            9.199273152425181e+02,     9.209056583982682e+02,     9.218774476116213e+02,     9.228427799518008e+02,     9.238017500795917e+02, 
            9.247544510256812e+02,     9.257009732178525e+02,     9.266414052216105e+02,     9.275758336360913e+02,     9.285043431530687e+02, 
            9.294270166137387e+02,     9.303439350633890e+02,     9.312551778040439e+02,     9.321608224451754e+02,     9.330609449525587e+02, 
            9.339556196953690e+02,     9.348449194915780e+02,     9.357289156517324e+02,     9.366076780211858e+02,     9.374812750208379e+02, 
            9.383497736864600e+02,     9.392132397066514e+02,     9.400717374594894e+02,     9.409253300479337e+02,     9.417740793340188e+02, 
            9.426180459719021e+02,     9.434572894398021e+02,     9.442918680708769e+02,     9.451218390830804e+02,     9.459472586080453e+02, 
            9.467681817190165e+02,     9.475846624578912e+02,     9.483967538613796e+02,     9.492045079863395e+02,     9.500079759343026e+02, 
            9.508072078752272e+02,     9.516022530705134e+02,     9.523931598952947e+02,     9.531799758600470e+02,     9.539627476315316e+02, 
            9.547415210530988e+02,     9.555163411643780e+02,     9.562872522203744e+02,     9.570542977099904e+02,     9.578175203740043e+02, 
            9.585769622225074e+02,     9.593326645518357e+02,     9.600846679610071e+02,     9.608330123676774e+02,     9.615777370236370e+02, 
            9.623188805298702e+02,     9.630564808511751e+02,     9.637905753303729e+02,     9.645212007021237e+02,     9.652483931063447e+02, 
            9.659721881012623e+02,     9.666926206761005e+02,     9.674097252634199e+02,     9.681235357511225e+02,     9.688340850456550e+02, 
            9.695414068586570e+02,     9.702455330824723e+02,     9.709464955400072e+02,     9.716443255648288e+02,     9.723390540113645e+02, 
            9.730307112648269e+02,     9.737193272508853e+02,     9.744049314450792e+02,     9.750875528819956e+02,     9.757672201642051e+02, 
            9.764439614709717e+02,     9.771178045667393e+02,     9.777887768094065e+02,     9.784569051583887e+02,     9.791222161824833e+02, 
            9.797847360675355e+02,     9.804444906239148e+02,     9.811015052938096e+02,     9.817558051583394e+02,     9.824074149444958e+02, 
            9.830563590319147e+02,     9.837026614594864e+02,     9.843463459318025e+02,     9.849874358254552e+02,     9.856259541951808e+02, 
            9.862619237798630e+02,     9.868953670083894e+02,     9.875263060053771e+02,     9.881547625967597e+02,     9.887807583152482e+02, 
            9.894043144056636e+02,     9.900254518301471e+02,     9.906441912732556e+02,     9.912605531469330e+02,     9.918745575953790e+02, 
            9.924862244997989e+02,     9.930955734830542e+02,     9.937026239142039e+02,     9.943073949129508e+02,     9.949099053539821e+02, 
            9.955101738712242e+02,     9.961082188619931e+02,     9.967040584910642e+02,     9.972977106946494e+02,     9.978891931842850e+02, 
            9.984785234506470e+02,     9.990657187672701e+02,     9.996507961941998e+02,     1.000233772581560e+03,     1.000814664573049e+03, 
            1.001393488609361e+03,     1.001970260931532e+03,     1.002544997584225e+03,     1.003117714418940e+03,     1.003688427097155e+03, 
            1.004257151093414e+03,     1.004823901698341e+03,     1.005388694021597e+03,     1.005951542994778e+03,     1.006512463374249e+03, 
            1.007071469743928e+03,     1.007628576518013e+03,     1.008183797943647e+03,     1.008737148103542e+03,     1.009288640918542e+03, 
            1.009838290150137e+03,     1.010386109402934e+03,     1.010932112127069e+03,     1.011476311620585e+03,     1.012018721031749e+03, 
            1.012559353361340e+03,     1.013098221464881e+03,     1.013635338054834e+03,     1.014170715702751e+03,     1.014704366841386e+03, 
            1.015236303766767e+03,     1.015766538640228e+03,     1.016295083490398e+03,     1.016821950215167e+03,     1.017347150583601e+03, 
            1.017870696237824e+03,     1.018392598694875e+03,     1.018912869348519e+03,     1.019431519471034e+03,     1.019948560214954e+03, 
            1.020464002614799e+03,     1.020977857588750e+03,     1.021490135940315e+03,     1.022000848359951e+03,     1.022510005426667e+03, 
            1.023017617609588e+03,     1.023523695269501e+03,     1.024028248660367e+03,     1.024531287930810e+03,     1.025032823125579e+03, 
            1.025532864186983e+03,     1.026031420956303e+03,     1.026528503175178e+03,     1.027024120486965e+03,     1.027518282438085e+03, 
            1.028010998479332e+03,     1.028502277967169e+03,     1.028992130165001e+03,     1.029480564244424e+03,     1.029967589286451e+03, 
            1.030453214282723e+03,     1.030937448136698e+03,     1.031420299664815e+03,     1.031901777597642e+03,     1.032381890581012e+03, 
            1.032860647177124e+03,     1.033338055865643e+03,     1.033814125044768e+03,     1.034288863032295e+03,     1.034762278066648e+03, 
            1.035234378307911e+03,     1.035705171838825e+03,     1.036174666665783e+03,     1.036642870719802e+03,     1.037109791857479e+03, 
            1.037575437861935e+03,     1.038039816443747e+03,     1.038502935241850e+03,     1.038964801824445e+03,     1.039425423689880e+03, 
            1.039884808267520e+03,     1.040342962918601e+03,     1.040799894937076e+03,     1.041255611550449e+03,     1.041710119920579e+03, 
            1.042163427144500e+03,     1.042615540255202e+03,     1.043066466222416e+03,     1.043516211953381e+03,     1.043964784293597e+03, 
            1.044412190027574e+03,     1.044858435879563e+03,     1.045303528514278e+03,     1.045747474537608e+03,     1.046190280497315e+03, 
            1.046631952883729e+03,     1.047072498130425e+03,     1.047511922614891e+03,     1.047950232659188e+03,     1.048387434530603e+03, 
            1.048823534442286e+03,     1.049258538553884e+03,     1.049692452972158e+03,     1.050125283751598e+03,     1.050557036895030e+03, 
            1.050987718354203e+03,     1.051417334030383e+03,     1.051845889774926e+03,     1.052273391389846e+03,     1.052699844628383e+03, 
            1.053125255195548e+03,     1.053549628748675e+03,     1.053972970897954e+03,     1.054395287206962e+03,     1.054816583193187e+03, 
            1.055236864328541e+03,     1.055656136039869e+03,     1.056074403709446e+03,     1.056491672675476e+03,     1.056907948232579e+03, 
            1.057323235632263e+03,     1.057737540083405e+03,     1.058150866752716e+03,     1.058563220765200e+03,     1.058974607204606e+03, 
            1.059385031113884e+03,     1.059794497495614e+03,     1.060203011312456e+03,     1.060610577487566e+03,     1.061017200905030e+03, 
            1.061422886410277e+03,     1.061827638810493e+03,     1.062231462875028e+03,     1.062634363335798e+03,     1.063036344887680e+03, 
            1.063437412188903e+03,     1.063837569861434e+03,     1.064236822491362e+03,     1.064635174629266e+03,     1.065032630790592e+03, 
            1.065429195456017e+03,     1.065824873071808e+03,     1.066219668050182e+03,     1.066613584769654e+03,     1.067006627575385e+03, 
            1.067398800779528e+03,     1.067790108661560e+03,     1.068180555468619e+03,     1.068570145415834e+03,     1.068958882686650e+03, 
            1.069346771433149e+03,     1.069733815776365e+03,     1.070120019806598e+03,     1.070505387583725e+03,     1.070889923137504e+03, 
            1.071273630467872e+03,     1.071656513545248e+03,     1.072038576310822e+03,     1.072419822676848e+03,     1.072800256526928e+03, 
            1.073179881716296e+03,     1.073558702072099e+03,     1.073936721393670e+03,     1.074313943452800e+03,     1.074690371994011e+03, 
            1.075066010734819e+03,     1.075440863365997e+03,     1.075814933551833e+03,     1.076188224930389e+03,     1.076560741113750e+03, 
            1.076932485688279e+03,     1.077303462214861e+03,     1.077673674229145e+03,     1.078043125241790e+03,     1.078411818738697e+03, 
            1.078779758181251e+03,     1.079146947006547e+03,     1.079513388627625e+03,     1.079879086433694e+03,     1.080244043790354e+03, 
            1.080608264039827e+03,     1.080971750501160e+03,     1.081334506470461e+03,     1.081696535221094e+03,     1.082057840003903e+03, 
            1.082418424047416e+03,     1.082778290558055e+03,     1.083137442720331e+03,     1.083495883697057e+03,     1.083853616629542e+03, 
            1.084210644637784e+03,     1.084566970820674e+03,     1.084922598256182e+03,     1.085277530001546e+03,     1.085631769093467e+03, 
            1.085985318548287e+03,     1.086338181362180e+03,     1.086690360511330e+03,     1.087041858952108e+03,     1.087392679621257e+03, 
            1.087742825436060e+03,     1.088092299294521e+03,     1.088441104075530e+03,     1.088789242639037e+03,     1.089136717826219e+03, 
            1.089483532459643e+03,     1.089829689343437e+03,     1.090175191263447e+03,     1.090520040987397e+03,     1.090864241265051e+03, 
            1.091207794828370e+03,     1.091550704391663e+03,     1.091892972651747e+03,     1.092234602288095e+03,     1.092575595962985e+03, 
            1.092915956321651e+03,     1.093255685992433e+03,     1.093594787586912e+03,     1.093933263700069e+03,     1.094271116910414e+03, 
            1.094608349780133e+03,     1.094944964855226e+03,     1.095280964665646e+03,     1.095616351725434e+03,     1.095951128532854e+03
    },
    {
            1.677723569401554e+00,     5.078391892493562e+00,     8.536805107653844e+00,     1.205539471106603e+01,     1.563675776786200e+01, 
            1.928367224439778e+01,     2.299911415980733e+01,     2.678627682788682e+01,     3.064859250017346e+01,     3.458975678450437e+01, 
            3.861375627918253e+01,     4.272489994822715e+01,     4.692785486641063e+01,     5.122768709007598e+01,     5.562990856738101e+01, 
            6.014053119797566e+01,     6.476612939841570e+01,     6.951391283964497e+01,     7.439181141775781e+01,     7.940857502284011e+01, 
            8.457389132058260e+01,     8.989852560474786e+01,     9.539448788296436e+01,     1.010752338169350e+02,     1.069559080824238e+02, 
            1.130536413313695e+02,     1.193879154973257e+02,     1.259810170780489e+02,     1.328586048331070e+02,     1.400504279302671e+02, 
            1.475912441178567e+02,     1.555220075298164e+02,     1.638914241691138e+02,     1.727580164399945e+02,     1.821929023971505e+02, 
            1.922835935510861e+02,     2.031392649826608e+02,     2.148981791414986e+02,     2.277382785316890e+02,     2.418924003640818e+02, 
            2.576699340665018e+02,     2.754861839542053e+02,     2.958961290265407e+02,     3.196124823429998e+02,     3.474493390425669e+02, 
            3.800790687198792e+02,     4.172944830576017e+02,     4.564398786172198e+02,     4.931558344600177e+02,     5.251048955929357e+02, 
            5.517566328646353e+02,     5.738232448886329e+02,     5.923342670137158e+02,     6.081555124746060e+02,     6.219182549931583e+02, 
            6.340721716531481e+02,     6.449421328692881e+02,     6.547680400378060e+02,     6.637308948896125e+02,     6.719699604045157e+02, 
            6.795942922442412e+02,     6.866906530924166e+02,     6.933290540442812e+02,     6.995667088784794e+02,     7.054509071209733e+02, 
            7.110211371339240e+02,     7.163106796940440e+02,     7.213478212883543e+02,     7.261567898784256e+02,     7.307584850903222e+02, 
            7.351710540501618e+02,     7.394103498872844e+02,     7.434903000462876e+02,     7.474232045649524e+02,     7.512199794652335e+02, 
            7.548903567621855e+02,     7.584430499145175e+02,     7.618858915444961e+02,     7.652259487537891e+02,     7.684696202221413e+02, 
            7.716227184031748e+02,     7.746905394581531e+02,     7.776779230450192e+02,     7.805893036702901e+02,     7.834287549886096e+02, 
            7.862000281790492e+02,     7.889065853234400e+02,     7.915516285486981e+02,     7.941381255636579e+02,     7.966688321144279e+02, 
            7.991463117957646e+02,     8.015729535852644e+02,     8.039509874090895e+02,     8.062824980002010e+02,     8.085694372704482e+02, 
            8.108136353850117e+02,     8.130168107002812e+02,     8.151805787032738e+02,     8.173064600714189e+02,     8.193958879552686e+02, 
            8.214502145729176e+02,     8.234707171932339e+02,     8.254586035750476e+02,     8.274150169209247e+02,     8.293410403968811e+02, 
            8.312377012631019e+02,     8.331059746553440e+02,     8.349467870520186e+02,     8.367610194579041e+02,     8.385495103319228e+02, 
            8.403130582833346e+02,     8.420524245580458e+02,     8.437683353343658e+02,     8.454614838454913e+02,     8.471325323441990e+02, 
            8.487821139236138e+02,     8.504108342065313e+02,     8.520192729145058e+02,     8.536079853268336e+02,     8.551775036385502e+02, 
            8.567283382257167e+02,     8.582609788254654e+02,     8.597758956375969e+02,     8.612735403538875e+02,     8.627543471207129e+02, 
            8.642187334400891e+02,     8.656671010137925e+02,     8.670998365347941e+02,     8.685173124299054e+02,     8.699198875571800e+02, 
            8.713079078669086e+02,     8.726817070512901e+02,     8.740416071010397e+02,     8.753879188347141e+02,     8.767209410779740e+02, 
            8.780409656836996e+02,     8.793482720682122e+02,     8.806431311780722e+02,     8.819258050905224e+02,     8.831965474002983e+02, 
            8.844556036017848e+02,     8.857032113695643e+02,     8.869396009871618e+02,     8.881649955897997e+02,     8.893796114767209e+02, 
            8.905836583910316e+02,     8.917773397687963e+02,     8.929608530590284e+02,     8.941343898596828e+02,     8.952981362164498e+02, 
            8.964522728214838e+02,     8.975969752197873e+02,     8.987324140057337e+02,     8.998587550102671e+02,     9.009761594793151e+02, 
            9.020847842439022e+02,     9.031847818824168e+02,     9.042763008754674e+02,     9.053594857537213e+02,     9.064344772515054e+02, 
            9.075014123909002e+02,     9.085604246889887e+02,     9.096116442275534e+02,     9.106551977848724e+02,     9.116912089486380e+02, 
            9.127197982240695e+02,     9.137410831374500e+02,     9.147551783353326e+02,     9.157621956796194e+02,     9.167622443387270e+02, 
            9.177554308750211e+02,     9.187418593287114e+02,     9.197216312983661e+02,     9.206948460182236e+02,     9.216616004324356e+02, 
            9.226219892664003e+02,     9.235761048835537e+02,     9.245240381789812e+02,     9.254658774290207e+02,     9.264017091436558e+02, 
            9.273316179315740e+02,     9.282556865566314e+02,     9.291739959922144e+02,     9.300866254735938e+02,     9.309936525483645e+02, 
            9.318951531250439e+02,     9.327912015199237e+02,     9.336818705022345e+02,     9.345672313377098e+02,     9.354473538306047e+02, 
            9.363223063642486e+02,     9.371921559401778e+02,     9.380569682159204e+02,     9.389168075414816e+02,     9.397717369945885e+02, 
            9.406218184147332e+02,     9.414671124360839e+02,     9.423076785192841e+02,     9.431435749822075e+02,     9.439748590296948e+02, 
            9.448015867823195e+02,     9.456238133042147e+02,     9.464415926300101e+02,     9.472549777908968e+02,     9.480640208398688e+02, 
            9.488687728761583e+02,     9.496692840689119e+02,     9.504656036801167e+02,     9.512577800868268e+02,     9.520458608026947e+02, 
            9.528298924988479e+02,     9.536099210241275e+02,     9.543859914247203e+02,     9.551581479631895e+02,     9.559264341369516e+02, 
            9.566908926961912e+02,     9.574515656612548e+02,     9.582084943395355e+02,     9.589617193418586e+02,     9.597112805984005e+02, 
            9.604572173741441e+02,     9.611995682838931e+02,     9.619383713068599e+02,     9.626736638008424e+02,     9.634054825159978e+02, 
            9.641338636082342e+02,     9.648588426522326e+02,     9.655804546541040e+02,     9.662987340637033e+02,     9.670137147866023e+02, 
            9.677254297323586e+02,     9.684339126603526e+02,     9.691391954671192e+02,     9.698413099945170e+02,     9.705402875953314e+02, 
            9.712361591434526e+02,     9.719289550437843e+02,     9.726187052418964e+02,     9.733054392334237e+02,     9.739891860732236e+02, 
            9.746699743842978e+02,     9.753478323664917e+02,     9.760227878049598e+02,     9.766948680784337e+02,     9.773641001672684e+02, 
            9.780305106612971e+02,     9.786941257674833e+02,     9.793549713173903e+02,     9.800130727744599e+02,     9.806684552411217e+02, 
            9.813211434657185e+02,     9.819711618492748e+02,     9.826185344520925e+02,     9.832632850001978e+02,     9.839054368916258e+02, 
            9.845450132025585e+02,     9.851820366933250e+02,     9.858165298142462e+02,     9.864485147113579e+02,     9.870780132319906e+02, 
            9.877050469302252e+02,     9.883296370722179e+02,     9.889518046414116e+02,     9.895715703436190e+02,     9.901889546119946e+02, 
            9.908039776118970e+02,     9.914166592456362e+02,     9.920270191571175e+02,     9.926350767363843e+02,     9.932408511240553e+02, 
            9.938443612156660e+02,     9.944456256659171e+02,     9.950446628928262e+02,     9.956414910817912e+02,     9.962361281895667e+02, 
            9.968285919481491e+02,     9.974188998685888e+02,     9.980070692447096e+02,     9.985931171567551e+02,     9.991770604749586e+02, 
            9.997589158630341e+02,     1.000338699781596e+03,     1.000916428491510e+03,     1.001492118057165e+03,     1.002065784349691e+03, 
            1.002637443050101e+03,     1.003207109652367e+03,     1.003774799466444e+03,     1.004340527621218e+03,     1.004904309067408e+03, 
            1.005466158580398e+03,     1.006026090763020e+03,     1.006584120048280e+03,     1.007140260702025e+03,     1.007694526825560e+03, 
            1.008246932358218e+03,     1.008797491079871e+03,     1.009346216613398e+03,     1.009893122427100e+03,     1.010438221837074e+03, 
            1.010981528009539e+03,     1.011523053963112e+03,     1.012062812571044e+03,     1.012600816563420e+03,     1.013137078529304e+03, 
            1.013671610918855e+03,     1.014204426045394e+03,     1.014735536087440e+03,     1.015264953090702e+03,     1.015792688970037e+03, 
            1.016318755511370e+03,     1.016843164373580e+03,     1.017365927090348e+03,     1.017887055071977e+03,     1.018406559607172e+03, 
            1.018924451864791e+03,     1.019440742895567e+03,     1.019955443633793e+03,     1.020468564898976e+03,     1.020980117397473e+03, 
            1.021490111724082e+03,     1.021998558363615e+03,     1.022505467692442e+03,     1.023010849980002e+03,     1.023514715390292e+03, 
            1.024017073983333e+03,     1.024517935716603e+03,     1.025017310446448e+03,     1.025515207929470e+03,     1.026011637823893e+03, 
            1.026506609690898e+03,     1.027000132995942e+03,     1.027492217110051e+03,     1.027982871311093e+03,     1.028472104785028e+03, 
            1.028959926627138e+03,     1.029446345843233e+03,     1.029931371350843e+03,     1.030415011980382e+03,     1.030897276476302e+03, 
            1.031378173498218e+03,     1.031857711622021e+03,     1.032335899340972e+03,     1.032812745066774e+03,     1.033288257130632e+03, 
            1.033762443784290e+03,     1.034235313201056e+03,     1.034706873476809e+03,     1.035177132630984e+03,     1.035646098607554e+03, 
            1.036113779275982e+03,     1.036580182432167e+03,     1.037045315799371e+03,     1.037509187029133e+03,     1.037971803702170e+03, 
            1.038433173329256e+03,     1.038893303352097e+03,     1.039352201144188e+03,     1.039809874011656e+03,     1.040266329194090e+03, 
            1.040721573865359e+03,     1.041175615134416e+03,     1.041628460046095e+03,     1.042080115581885e+03,     1.042530588660701e+03, 
            1.042979886139644e+03,     1.043428014814740e+03,     1.043874981421680e+03,     1.044320792636536e+03,     1.044765455076481e+03, 
            1.045208975300483e+03,     1.045651359809998e+03,     1.046092615049653e+03,     1.046532747407911e+03,     1.046971763217734e+03, 
            1.047409668757236e+03,     1.047846470250318e+03,     1.048282173867305e+03,     1.048716785725564e+03,     1.049150311890120e+03, 
            1.049582758374256e+03,     1.050014131140116e+03,     1.050444436099281e+03,     1.050873679113357e+03,     1.051301865994539e+03, 
            1.051729002506175e+03,     1.052155094363321e+03,     1.052580147233281e+03,     1.053004166736153e+03,     1.053427158445352e+03, 
            1.053849127888139e+03,     1.054270080546132e+03,     1.054690021855816e+03,     1.055108957209044e+03,     1.055526891953532e+03, 
            1.055943831393345e+03,     1.056359780789375e+03,     1.056774745359822e+03,     1.057188730280655e+03,     1.057601740686072e+03, 
            1.058013781668962e+03,     1.058424858281344e+03,     1.058834975534815e+03,     1.059244138400985e+03,     1.059652351811906e+03, 
            1.060059620660498e+03,     1.060465949800966e+03,     1.060871344049212e+03,     1.061275808183248e+03,     1.061679346943590e+03, 
            1.062081965033663e+03,     1.062483667120182e+03,     1.062884457833552e+03,     1.063284341768234e+03,     1.063683323483132e+03, 
            1.064081407501960e+03,     1.064478598313607e+03,     1.064874900372501e+03,     1.065270318098965e+03,     1.065664855879567e+03, 
            1.066058518067468e+03,     1.066451308982770e+03,     1.066843232912846e+03,     1.067234294112681e+03,     1.067624496805196e+03, 
            1.068013845181581e+03,     1.068402343401611e+03,     1.068789995593964e+03,     1.069176805856535e+03,     1.069562778256746e+03, 
            1.069947916831851e+03,     1.070332225589238e+03,     1.070715708506724e+03,     1.071098369532854e+03,     1.071480212587187e+03, 
            1.071861241560584e+03,     1.072241460315493e+03,     1.072620872686228e+03,     1.072999482479242e+03,     1.073377293473403e+03, 
            1.073754309420264e+03,     1.074130534044326e+03,     1.074505971043306e+03,     1.074880624088389e+03,     1.075254496824490e+03, 
            1.075627592870510e+03,     1.075999915819576e+03,     1.076371469239300e+03,     1.076742256672016e+03,     1.077112281635021e+03, 
            1.077481547620820e+03,     1.077850058097354e+03,     1.078217816508239e+03,     1.078584826272990e+03,     1.078951090787251e+03, 
            1.079316613423023e+03,     1.079681397528879e+03,     1.080045446430192e+03,     1.080408763429340e+03,     1.080771351805931e+03, 
            1.081133214817011e+03,     1.081494355697270e+03,     1.081854777659252e+03,     1.082214483893560e+03,     1.082573477569054e+03, 
            1.082931761833056e+03,     1.083289339811543e+03,     1.083646214609342e+03,     1.084002389310327e+03,     1.084357866977606e+03, 
            1.084712650653709e+03,     1.085066743360776e+03,     1.085420148100741e+03,     1.085772867855515e+03,     1.086124905587160e+03, 
            1.086476264238077e+03,     1.086826946731172e+03,     1.087176955970039e+03,     1.087526294839122e+03,     1.087874966203894e+03, 
            1.088222972911022e+03,     1.088570317788530e+03,     1.088917003645969e+03,     1.089263033274575e+03,     1.089608409447434e+03, 
            1.089953134919637e+03,     1.090297212428440e+03,     1.090640644693418e+03,     1.090983434416620e+03,     1.091325584282720e+03, 
            1.091667096959171e+03,     1.092007975096346e+03,     1.092348221327696e+03,     1.092687838269885e+03,     1.093026828522943e+03, 
            1.093365194670401e+03,     1.093702939279440e+03,     1.094040064901021e+03,     1.094376574070032e+03,     1.094712469305417e+03
    },
    {
            1.674492618535514e+00,     5.068340416725969e+00,     8.519431623863994e+00,     1.203015616609087e+01,     1.560306519950674e+01, 
            1.924088588083787e+01,     2.294653786992220e+01,     2.672315181893899e+01,     3.057409013975839e+01,     3.450297039985621e+01, 
            3.851369175774710e+01,     4.261046492748110e+01,     4.679784625641452e+01,     5.108077661687116e+01,     5.546462595599655e+01, 
            5.995524452647845e+01,     6.455902204349049e+01,     6.928295629329136e+01,     7.413473307206554e+01,     7.912281978504291e+01, 
            8.425657561254066e+01,     8.954638189607363e+01,     9.500379736872694e+01,     1.006417441288665e+02,     1.064747319442906e+02, 
            1.125191307295172e+02,     1.187935040819565e+02,     1.253190209097822e+02,     1.321199678961304e+02,     1.392243935151464e+02, 
            1.466649254215594e+02,     1.544798192815230e+02,     1.627143197485474e+02,     1.714224483023366e+02,     1.806693820525681e+02, 
            1.905346613389884e+02,     2.011165734638777e+02,     2.125382206155965e+02,     2.249560055349310e+02,     2.385715448170618e+02, 
            2.536482098072947e+02,     2.705330218773733e+02,     2.896815744496953e+02,     3.116730583472553e+02,     3.371776657465782e+02, 
            3.668061207824732e+02,     4.007035277411832e+02,     4.375598216580906e+02,     4.739614122033638e+02,     5.069514408530026e+02, 
            5.353281860258427e+02,     5.591509561435437e+02,     5.791740234951984e+02,     5.962335977960975e+02,     6.110068095946451e+02, 
            6.239941783460853e+02,     6.355609149119282e+02,     6.459769316389355e+02,     6.554454741874091e+02,     6.641224681946502e+02, 
            6.721296218068187e+02,     6.795634417020916e+02,     6.865015482163748e+02,     6.930071765705559e+02,     6.991324400642548e+02, 
            7.049207346312239e+02,     7.104085382178874e+02,     7.156267767325280e+02,     7.206018746888817e+02,     7.253565730500932e+02, 
            7.299105728014398e+02,     7.342810464025146e+02,     7.384830479124552e+02,     7.425298445864026e+02,     7.464331870294953e+02, 
            7.502035308573671e+02,     7.538502197764936e+02,     7.573816377439484e+02,     7.608053361748466e+02,     7.641281408838721e+02, 
            7.673562424672099e+02,     7.704952730755770e+02,     7.735503719421361e+02,     7.765262415700615e+02,     7.794271961231768e+02, 
            7.822572032769315e+02,     7.850199205590379e+02,     7.877187270266182e+02,     7.903567509797805e+02,     7.929368942927489e+02, 
            7.954618538471119e+02,     7.979341404729400e+02,     8.003560957389125e+02,     8.027299068793546e+02,     8.050576201021534e+02, 
            8.073411524849558e+02,     8.095823026366829e+02,     8.117827602759214e+02,     8.139441148564237e+02,     8.160678633519470e+02, 
            8.181554172974706e+02,     8.202081091709547e+02,     8.222271981887943e+02,     8.242138755788252e+02,     8.261692693866743e+02, 
            8.280944488643997e+02,     8.299904284844380e+02,     8.318581716167594e+02,     8.336985939027004e+02,     8.355125663551288e+02, 
            8.373009182112055e+02,     8.390644395611475e+02,     8.408038837737876e+02,     8.425199697375440e+02,     8.442133839334082e+02, 
            8.458847823548630e+02,     8.475347922880853e+02,     8.491640139644726e+02,     8.507730220963119e+02,     8.523623673053693e+02, 
            8.539325774532147e+02,     8.554841588812875e+02,     8.570175975679218e+02,     8.585333602089171e+02,     8.600318952276177e+02, 
            8.615136337199333e+02,     8.629789903392525e+02,     8.644283641257650e+02,     8.658621392843212e+02,     8.672806859145951e+02, 
            8.686843606994281e+02,     8.700735075804917e+02,     8.714484583549015e+02,     8.728095332220273e+02,     8.741570401285059e+02, 
            8.754912793053255e+02,     8.768125384931650e+02,     8.781210965319619e+02,     8.794172230837969e+02,     8.807011789719018e+02, 
            8.819732166607006e+02,     8.832335805501363e+02,     8.844825073346798e+02,     8.857202263273463e+02,     8.869469597668680e+02, 
            8.881629230924477e+02,     8.893683252881357e+02,     8.905633690412693e+02,     8.917482510629643e+02,     8.929231623070052e+02, 
            8.940882881953102e+02,     8.952438088324598e+02,     8.963898992099018e+02,     8.975267294004339e+02,     8.986544647434973e+02, 
            8.997732660218110e+02,     9.008832896298230e+02,     9.019846877344122e+02,     9.030776084282942e+02,     9.041621958886710e+02, 
            9.052385904671941e+02,     9.063069289006405e+02,     9.073673443860268e+02,     9.084199667164610e+02,     9.094649223981478e+02, 
            9.105023347623751e+02,     9.115323240727517e+02,     9.125550076279255e+02,     9.135704998600178e+02,     9.145789124289762e+02, 
            9.155803543130581e+02,     9.165749318956202e+02,     9.175627490484110e+02,     9.185439072115166e+02,     9.195185054701319e+02, 
            9.204866406282997e+02,     9.214484072797671e+02,     9.224038978760896e+02,     9.233532025468978e+02,     9.242964101222980e+02, 
            9.252336067851572e+02,     9.261648770485369e+02,     9.270903035867767e+02,     9.280099672895361e+02,     9.289239473138495e+02, 
            9.298323211342783e+02,     9.307351645912460e+02,     9.316325519376248e+02,     9.325245558836697e+02,     9.334112476403454e+02, 
            9.342926969611372e+02,     9.351689721823888e+02,     9.360401402622513e+02,     9.369062668182777e+02,     9.377674161637378e+02, 
            9.386236513426932e+02,     9.394750341638892e+02,     9.403216252335125e+02,     9.411634839868560e+02,     9.420006687189342e+02, 
            9.428332366140941e+02,     9.436612437746625e+02,     9.444847452486587e+02,     9.453037950566203e+02,     9.461184462175697e+02, 
            9.469287507741491e+02,     9.477347598169735e+02,     9.485365235082090e+02,     9.493340911044232e+02,     9.501275109787238e+02, 
            9.509168306422192e+02,     9.517020967648218e+02,     9.524833551954175e+02,     9.532606509814301e+02,     9.540340283877969e+02, 
            9.548035309153748e+02,     9.555692013188115e+02,     9.563310816238766e+02,     9.570892131442990e+02,     9.578436364981038e+02, 
            9.585943916234828e+02,     9.593415177942081e+02,     9.600850536346034e+02,     9.608250371340935e+02,     9.615615056613386e+02, 
            9.622944959779769e+02,     9.630240442519813e+02,     9.637501860706417e+02,     9.644729564532003e+02,     9.651923898631273e+02, 
            9.659085197604163e+02,     9.666213804328406e+02,     9.673310043057888e+02,     9.680374237359383e+02,     9.687406705808020e+02, 
            9.694407762091514e+02,     9.701377715111809e+02,     9.708316869083902e+02,     9.715225523632184e+02,     9.722103973884253e+02, 
            9.728952510562323e+02,     9.735771420072251e+02,     9.742560984590363e+02,     9.749321482148006e+02,     9.756053186714017e+02, 
            9.762756368275080e+02,     9.769431292914137e+02,     9.776078222886797e+02,     9.782697416695861e+02,     9.789289129164072e+02, 
            9.795853611505015e+02,     9.802391111392324e+02,     9.808901873027246e+02,     9.815386137204506e+02,     9.821844141376683e+02, 
            9.828276119716958e+02,     9.834682303180460e+02,     9.841062919564109e+02,     9.847418193565086e+02,     9.853748346837880e+02, 
            9.860053598050149e+02,     9.866334162937080e+02,     9.872590254354692e+02,     9.878822082331800e+02,     9.885029854120846e+02, 
            9.891213774247559e+02,     9.897374044559514e+02,     9.903510864273554e+02,     9.909624430022213e+02,     9.915714935899061e+02, 
            9.921782573503065e+02,     9.927827531981965e+02,     9.933849998074695e+02,     9.939850156152892e+02,     9.945828188261481e+02, 
            9.951784274158422e+02,     9.957718591353523e+02,     9.963631315146523e+02,     9.969522618664289e+02,     9.975392672897231e+02, 
            9.981241646734976e+02,     9.987069707001269e+02,     9.992877018488158e+02,     9.998663743989420e+02,     1.000443004433338e+03, 
            1.001017607841497e+03,     1.001590200322713e+03,     1.002160797389165e+03,     1.002729414368927e+03,     1.003296066408928e+03, 
            1.003860768477838e+03,     1.004423535368913e+03,     1.004984381702768e+03,     1.005543321930101e+03,     1.006100370334367e+03, 
            1.006655541034390e+03,     1.007208847986927e+03,     1.007760304989187e+03,     1.008309925681294e+03,     1.008857723548701e+03, 
            1.009403711924564e+03,     1.009947903992067e+03,     1.010490312786701e+03,     1.011030951198495e+03,     1.011569831974218e+03, 
            1.012106967719523e+03,     1.012642370901062e+03,     1.013176053848557e+03,     1.013708028756829e+03,     1.014238307687794e+03, 
            1.014766902572424e+03,     1.015293825212658e+03,     1.015819087283297e+03,     1.016342700333847e+03,     1.016864675790341e+03, 
            1.017385024957116e+03,     1.017903759018571e+03,     1.018420889040879e+03,     1.018936425973680e+03,     1.019450380651736e+03, 
            1.019962763796558e+03,     1.020473586018007e+03,     1.020982857815864e+03,     1.021490589581370e+03,     1.021996791598744e+03, 
            1.022501474046671e+03,     1.023004646999760e+03,     1.023506320429989e+03,     1.024006504208109e+03,     1.024505208105036e+03, 
            1.025002441793215e+03,     1.025498214847954e+03,     1.025992536748748e+03,     1.026485416880570e+03,     1.026976864535142e+03, 
            1.027466888912191e+03,     1.027955499120672e+03,     1.028442704179983e+03,     1.028928513021148e+03,     1.029412934487991e+03, 
            1.029895977338282e+03,     1.030377650244868e+03,     1.030857961796787e+03,     1.031336920500354e+03,     1.031814534780247e+03, 
            1.032290812980554e+03,     1.032765763365820e+03,     1.033239394122068e+03,     1.033711713357807e+03,     1.034182729105020e+03, 
            1.034652449320142e+03,     1.035120881885018e+03,     1.035588034607842e+03,     1.036053915224093e+03,     1.036518531397446e+03, 
            1.036981890720667e+03,     1.037444000716506e+03,     1.037904868838561e+03,     1.038364502472141e+03,     1.038822908935106e+03, 
            1.039280095478701e+03,     1.039736069288374e+03,     1.040190837484579e+03,     1.040644407123572e+03,     1.041096785198188e+03, 
            1.041547978638617e+03,     1.041997994313153e+03,     1.042446839028945e+03,     1.042894519532728e+03,     1.043341042511550e+03, 
            1.043786414593482e+03,     1.044230642348317e+03,     1.044673732288268e+03,     1.045115690868643e+03,     1.045556524488515e+03, 
            1.045996239491388e+03,     1.046434842165846e+03,     1.046872338746190e+03,     1.047308735413073e+03,     1.047744038294127e+03, 
            1.048178253464569e+03,     1.048611386947810e+03,     1.049043444716048e+03,     1.049474432690858e+03,     1.049904356743771e+03, 
            1.050333222696841e+03,     1.050761036323210e+03,     1.051187803347661e+03,     1.051613529447164e+03,     1.052038220251415e+03, 
            1.052461881343369e+03,     1.052884518259757e+03,     1.053306136491609e+03,     1.053726741484759e+03,     1.054146338640347e+03, 
            1.054564933315316e+03,     1.054982530822892e+03,     1.055399136433078e+03,     1.055814755373114e+03,     1.056229392827955e+03, 
            1.056643053940729e+03,     1.057055743813188e+03,     1.057467467506163e+03,     1.057878230040004e+03,     1.058288036395015e+03, 
            1.058696891511886e+03,     1.059104800292118e+03,     1.059511767598442e+03,     1.059917798255233e+03,     1.060322897048914e+03, 
            1.060727068728364e+03,     1.061130318005313e+03,     1.061532649554729e+03,     1.061934068015215e+03,     1.062334577989378e+03, 
            1.062734184044215e+03,     1.063132890711482e+03,     1.063530702488056e+03,     1.063927623836303e+03,     1.064323659184431e+03, 
            1.064718812926845e+03,     1.065113089424491e+03,     1.065506493005206e+03,     1.065899027964050e+03,     1.066290698563643e+03, 
            1.066681509034497e+03,     1.067071463575339e+03,     1.067460566353436e+03,     1.067848821504910e+03,     1.068236233135053e+03, 
            1.068622805318635e+03,     1.069008542100215e+03,     1.069393447494436e+03,     1.069777525486326e+03,     1.070160780031594e+03, 
            1.070543215056922e+03,     1.070924834460243e+03,     1.071305642111038e+03,     1.071685641850604e+03,     1.072064837492341e+03, 
            1.072443232822012e+03,     1.072820831598027e+03,     1.073197637551701e+03,     1.073573654387519e+03,     1.073948885783396e+03, 
            1.074323335390933e+03,     1.074697006835674e+03,     1.075069903717352e+03,     1.075442029610139e+03,     1.075813388062890e+03, 
            1.076183982599387e+03,     1.076553816718574e+03,     1.076922893894794e+03,     1.077291217578023e+03,     1.077658791194101e+03, 
            1.078025618144957e+03,     1.078391701808835e+03,     1.078757045540519e+03,     1.079121652671546e+03,     1.079485526510431e+03, 
            1.079848670342873e+03,     1.080211087431975e+03,     1.080572781018449e+03,     1.080933754320821e+03,     1.081294010535641e+03, 
            1.081653552837683e+03,     1.082012384380141e+03,     1.082370508294834e+03,     1.082727927692394e+03,     1.083084645662464e+03, 
            1.083440665273886e+03,     1.083795989574893e+03,     1.084150621593290e+03,     1.084504564336644e+03,     1.084857820792463e+03, 
            1.085210393928377e+03,     1.085562286692317e+03,     1.085913502012690e+03,     1.086264042798553e+03,     1.086613911939789e+03, 
            1.086963112307269e+03,     1.087311646753029e+03,     1.087659518110436e+03,     1.088006729194342e+03,     1.088353282801261e+03, 
            1.088699181709523e+03,     1.089044428679431e+03,     1.089389026453425e+03,     1.089732977756232e+03,     1.090076285295022e+03, 
            1.090418951759563e+03,     1.090760979822368e+03,     1.091102372138846e+03,     1.091443131347449e+03,     1.091783260069817e+03, 
            1.092122760910925e+03,     1.092461636459222e+03,     1.092799889286775e+03,     1.093137521949409e+03,     1.093474536986842e+03
    },
    {
            1.671274264784393e+00,     5.058330335709449e+00,     8.502133666274416e+00,     1.200503337585292e+01,     1.556953559295287e+01, 
            1.919831768501775e+01,     2.289424413673804e+01,     2.666038431662220e+01,     3.050003240489830e+01,     3.441672981085621e+01, 
            3.841429046331991e+01,     4.249682943029720e+01,     4.666879541066668e+01,     5.093500774719227e+01,     5.530069874110443e+01, 
            5.977156221048276e+01,     6.435380943617908e+01,     6.905423389141360e+01,     7.388028646824435e+01,     7.884016331733686e+01, 
            8.394290893030421e+01,     8.919853775416698e+01,     9.461817848167784e+01,     1.002142462759096e+02,     1.060006496537012e+02, 
            1.119930406977356e+02,     1.182091198708096e+02,     1.246690102239195e+02,     1.313957205895562e+02,     1.384157239809046e+02, 
            1.457596865376856e+02,     1.534633955624864e+02,     1.615689532410255e+02,     1.701263294156378e+02,     1.791954048163533e+02, 
            1.888486917120742e+02,     1.991749992258079e+02,     2.102844244614154e+02,     2.223152032659527e+02,     2.354431279514766e+02, 
            2.498943272714558e+02,     2.659618117308372e+02,     2.840240955369339e+02,     3.045573641620575e+02,     3.281165650084175e+02, 
            3.552386279215073e+02,     3.861972079417420e+02,     4.204285531997538e+02,     4.557143922470457e+02,     4.890050100711780e+02, 
            5.186118409510565e+02,     5.440041830625887e+02,     5.655263629030363e+02,     5.838701584685281e+02,     5.997088484945722e+02, 
            6.135794516735998e+02,     6.258851913247593e+02,     6.369266729009836e+02,     6.469305524595657e+02,     6.560704924906767e+02, 
            6.644817364757852e+02,     6.722712352589865e+02,     6.795247673203498e+02,     6.863120197608038e+02,     6.926902696816609e+02, 
            6.987070922101818e+02,     7.044023821646322e+02,     7.098098847432162e+02,     7.149583698621857e+02,     7.198725441265060e+02, 
            7.245737669621068e+02,     7.290806186779940e+02,     7.334093552398760e+02,     7.375742754226741e+02,     7.415880195226656e+02, 
            7.454618141294392e+02,     7.492056740360285e+02,     7.528285698330509e+02,     7.563385678371285e+02,     7.597429475702332e+02, 
            7.630483009122199e+02,     7.662606162060731e+02,     7.693853499414777e+02,     7.724274881311687e+02,     7.753915990923942e+02, 
            7.782818790274390e+02,     7.811021915437161e+02,     7.838561020509994e+02,     7.865469078101480e+02,     7.891776642756589e+02, 
            7.917512082671713e+02,     7.942701784175719e+02,     7.967370332736710e+02,     7.991540673664242e+02,     8.015234255189590e+02, 
            8.038471156202472e+02,     8.061270200586215e+02,     8.083649059812286e+02,     8.105624345219203e+02,     8.127211691202785e+02, 
            8.148425830376909e+02,     8.169280661622352e+02,     8.189789311820518e+02,     8.209964191966255e+02,     8.229817048265968e+02, 
            8.249359008751992e+02,     8.268600625879279e+02,     8.287551915514671e+02,     8.306222392680651e+02,     8.324621104373501e+02, 
            8.342756659739600e+02,     8.360637257861531e+02,     8.378270713378259e+02,     8.395664480139204e+02,     8.412825673070782e+02, 
            8.429761088415223e+02,     8.446477222485133e+02,     8.462980289062385e+02,     8.479276235557411e+02,     8.495370758033226e+02, 
            8.511269315188512e+02,     8.526977141385008e+02,     8.542499258796416e+02,     8.557840488748878e+02,     8.573005462316506e+02, 
            8.587998630229849e+02,     8.602824272149951e+02,     8.617486505355889e+02,     8.631989292889780e+02,     8.646336451199041e+02, 
            8.660531657320946e+02,     8.674578455878875e+02,     8.688480265466087e+02,     8.702240384314681e+02,     8.715861985231625e+02, 
            8.729348156780941e+02,     8.742701861718376e+02,     8.755925969023405e+02,     8.769023252884239e+02,     8.781996396250262e+02, 
            8.794847994977202e+02,     8.807580561590789e+02,     8.820196528849558e+02,     8.832698253119477e+02,     8.845088017405676e+02, 
            8.857368035065504e+02,     8.869540451641734e+02,     8.881607348306574e+02,     8.893570744273021e+02,     8.905432599259888e+02, 
            8.917194815835387e+02,     8.928859241646256e+02,     8.940427671539219e+02,     8.951901849580770e+02,     8.963283470981188e+02, 
            8.974574183928089e+02,     8.985775591334553e+02,     8.996889252506583e+02,     9.007916684734286e+02,     9.018859364930373e+02, 
            9.029718730590839e+02,     9.040496181935978e+02,     9.051193082717950e+02,     9.061810761620967e+02,     9.072350513473236e+02, 
            9.082813600406824e+02,     9.093201252967980e+02,     9.103514671180513e+02,     9.113755025564566e+02,     9.123923458112974e+02, 
            9.134021083227360e+02,     9.144048988615871e+02,     9.154008236154531e+02,     9.163899862713861e+02,     9.173724880952452e+02, 
            9.183484280079155e+02,     9.193179026585266e+02,     9.202810064948100e+02,     9.212378318307377e+02,     9.221884689115665e+02, 
            9.231330056941767e+02,     9.240715290125237e+02,     9.250041230117395e+02,     9.259308702646276e+02,     9.268518515654456e+02, 
            9.277671459816511e+02,     9.286768309037516e+02,     9.295809820933609e+02,     9.304796737295258e+02,     9.313729784533996e+02, 
            9.322609674113379e+02,     9.331437102964808e+02,     9.340212753888777e+02,     9.348937295942352e+02,     9.357611384813160e+02, 
            9.366235663180739e+02,     9.374810761065556e+02,     9.383337296166317e+02,     9.391815874185922e+02,     9.400247089146679e+02, 
            9.408631523695051e+02,     9.416969749396438e+02,     9.425262327020358e+02,     9.433509806816407e+02,     9.441712728781359e+02, 
            9.449871622917717e+02,     9.457987009484083e+02,     9.466059399237680e+02,     9.474089293669186e+02,     9.482077185230372e+02, 
            9.490023557554642e+02,     9.497928885670832e+02,     9.505793636210454e+02,     9.513618267608700e+02,     9.521403230299381e+02, 
            9.529148966904004e+02,     9.536855912415228e+02,     9.544524494374956e+02,     9.552155133047097e+02,     9.559748241585373e+02, 
            9.567304226196185e+02,     9.574823486296831e+02,     9.582306414669139e+02,     9.589753397608772e+02,     9.597164815070272e+02, 
            9.604541040807998e+02,     9.611882442513150e+02,     9.619189381946995e+02,     9.626462215070313e+02,     9.633701292169424e+02, 
            9.640906953419898e+02,     9.648079547051259e+02,     9.655219402673622e+02,     9.662326849067417e+02,     9.669402209918835e+02, 
            9.676445803926667e+02,     9.683457944906394e+02,     9.690438941891466e+02,     9.697389099232029e+02,     9.704308716690982e+02, 
            9.711198089537602e+02,     9.718057508638759e+02,     9.724887260547779e+02,     9.731687627591075e+02,     9.738458887952517e+02, 
            9.745201315755763e+02,     9.751915181144489e+02,     9.758600750360580e+02,     9.765258285820449e+02,     9.771888046189464e+02, 
            9.778490286454465e+02,     9.785065257994646e+02,     9.791613208650604e+02,     9.798134382791768e+02,     9.804629021382208e+02, 
            9.811097362044873e+02,     9.817539639124262e+02,     9.823956083747669e+02,     9.830346923884927e+02,     9.836712384406827e+02, 
            9.843052687142069e+02,     9.849368050933002e+02,     9.855658691690011e+02,     9.861924822444636e+02,     9.868166653401560e+02, 
            9.874384391989323e+02,     9.880578242909971e+02,     9.886748408187481e+02,     9.892895087215209e+02,     9.899018476802210e+02, 
            9.905118771218565e+02,     9.911196162239656e+02,     9.917250839189534e+02,     9.923282988983283e+02,     9.929292796168487e+02, 
            9.935280442965778e+02,     9.941246109308524e+02,     9.947189972881670e+02,     9.953112209159711e+02,     9.959012991443904e+02, 
            9.964892490898632e+02,     9.970750876587067e+02,     9.976588315506033e+02,     9.982404972620151e+02,     9.988201010895295e+02, 
            9.993976591331307e+02,     9.999731872994079e+02,     1.000546701304697e+03,     1.001118216678154e+03,     1.001687748764773e+03, 
            1.002255312728334e+03,     1.002820923554296e+03,     1.003384596052637e+03,     1.003946344860624e+03,     1.004506184445541e+03, 
            1.005064129107353e+03,     1.005620192981325e+03,     1.006174390040582e+03,     1.006726734098624e+03,     1.007277238811792e+03, 
            1.007825917681682e+03,     1.008372784057512e+03,     1.008917851138453e+03,     1.009461131975900e+03,     1.010002639475713e+03, 
            1.010542386400406e+03,     1.011080385371301e+03,     1.011616648870634e+03,     1.012151189243632e+03,     1.012684018700538e+03, 
            1.013215149318609e+03,     1.013744593044070e+03,     1.014272361694039e+03,     1.014798466958404e+03,     1.015322920401679e+03, 
            1.015845733464819e+03,     1.016366917467002e+03,     1.016886483607380e+03,     1.017404442966799e+03,     1.017920806509484e+03, 
            1.018435585084699e+03,     1.018948789428373e+03,     1.019460430164703e+03,     1.019970517807718e+03,     1.020479062762823e+03, 
            1.020986075328319e+03,     1.021491565696886e+03,     1.021995543957049e+03,     1.022498020094612e+03,     1.022999003994075e+03, 
            1.023498505440013e+03,     1.023996534118450e+03,     1.024493099618191e+03,     1.024988211432142e+03,     1.025481878958607e+03, 
            1.025974111502558e+03,     1.026464918276883e+03,     1.026954308403624e+03,     1.027442290915179e+03,     1.027928874755494e+03, 
            1.028414068781233e+03,     1.028897881762925e+03,     1.029380322386097e+03,     1.029861399252383e+03,     1.030341120880620e+03, 
            1.030819495707924e+03,     1.031296532090745e+03,     1.031772238305910e+03,     1.032246622551646e+03,     1.032719692948588e+03, 
            1.033191457540768e+03,     1.033661924296593e+03,     1.034131101109801e+03,     1.034598995800408e+03,     1.035065616115635e+03, 
            1.035530969730822e+03,     1.035995064250330e+03,     1.036457907208424e+03,     1.036919506070147e+03,     1.037379868232177e+03, 
            1.037839001023670e+03,     1.038296911707095e+03,     1.038753607479048e+03,     1.039209095471065e+03,     1.039663382750404e+03, 
            1.040116476320841e+03,     1.040568383123425e+03,     1.041019110037247e+03,     1.041468663880180e+03,     1.041917051409614e+03, 
            1.042364279323181e+03,     1.042810354259468e+03,     1.043255282798719e+03,     1.043699071463528e+03,     1.044141726719512e+03, 
            1.044583254975995e+03,     1.045023662586660e+03,     1.045462955850202e+03,     1.045901141010972e+03,     1.046338224259609e+03, 
            1.046774211733659e+03,     1.047209109518194e+03,     1.047642923646414e+03,     1.048075660100247e+03,     1.048507324810929e+03, 
            1.048937923659592e+03,     1.049367462477830e+03,     1.049795947048261e+03,     1.050223383105082e+03,     1.050649776334621e+03, 
            1.051075132375866e+03,     1.051499456821006e+03,     1.051922755215949e+03,     1.052345033060839e+03,     1.052766295810565e+03, 
            1.053186548875268e+03,     1.053605797620827e+03,     1.054024047369356e+03,     1.054441303399678e+03,     1.054857570947805e+03, 
            1.055272855207403e+03,     1.055687161330256e+03,     1.056100494426717e+03,     1.056512859566164e+03,     1.056924261777436e+03, 
            1.057334706049273e+03,     1.057744197330750e+03,     1.058152740531695e+03,     1.058560340523115e+03,     1.058967002137607e+03, 
            1.059372730169765e+03,     1.059777529376587e+03,     1.060181404477869e+03,     1.060584360156596e+03,     1.060986401059332e+03, 
            1.061387531796601e+03,     1.061787756943262e+03,     1.062187081038885e+03,     1.062585508588112e+03,     1.062983044061024e+03, 
            1.063379691893495e+03,     1.063775456487548e+03,     1.064170342211702e+03,     1.064564353401314e+03,     1.064957494358918e+03, 
            1.065349769354565e+03,     1.065741182626146e+03,     1.066131738379725e+03,     1.066521440789857e+03,     1.066910293999909e+03, 
            1.067298302122370e+03,     1.067685469239165e+03,     1.068071799401960e+03,     1.068457296632463e+03,     1.068841964922725e+03, 
            1.069225808235430e+03,     1.069608830504191e+03,     1.069991035633837e+03,     1.070372427500693e+03,     1.070753009952864e+03, 
            1.071132786810510e+03,     1.071511761866120e+03,     1.071889938884782e+03,     1.072267321604452e+03,     1.072643913736212e+03, 
            1.073019718964534e+03,     1.073394740947539e+03,     1.073768983317247e+03,     1.074142449679829e+03,     1.074515143615857e+03, 
            1.074887068680546e+03,     1.075258228403997e+03,     1.075628626291437e+03,     1.075998265823454e+03,     1.076367150456231e+03, 
            1.076735283621775e+03,     1.077102668728147e+03,     1.077469309159686e+03,     1.077835208277232e+03,     1.078200369418343e+03, 
            1.078564795897519e+03,     1.078928491006409e+03,     1.079291458014027e+03,     1.079653700166962e+03,     1.080015220689583e+03, 
            1.080376022784248e+03,     1.080736109631501e+03,     1.081095484390277e+03,     1.081454150198095e+03,     1.081812110171260e+03, 
            1.082169367405050e+03,     1.082525924973909e+03,     1.082881785931638e+03,     1.083236953311582e+03,     1.083591430126809e+03, 
            1.083945219370298e+03,     1.084298324015120e+03,     1.084650747014610e+03,     1.085002491302552e+03,     1.085353559793347e+03, 
            1.085703955382186e+03,     1.086053680945225e+03,     1.086402739339750e+03,     1.086751133404345e+03,     1.087098865959052e+03, 
            1.087445939805544e+03,     1.087792357727279e+03,     1.088138122489660e+03,     1.088483236840195e+03,     1.088827703508651e+03, 
            1.089171525207210e+03,     1.089514704630621e+03,     1.089857244456351e+03,     1.090199147344731e+03,     1.090540415939112e+03, 
            1.090881052866000e+03,     1.091221060735212e+03,     1.091560442140008e+03,     1.091899199657240e+03,     1.092237335847491e+03
    },
    {
            1.668068433119719e+00,     5.048361379803048e+00,     8.484910700398489e+00,     1.198002545506806e+01,     1.553616760699496e+01, 
            1.915596573126209e+01,     2.284223029288249e+01,     2.659797071944842e+01,     3.042641452427616e+01,     3.433102878722991e+01, 
            3.831554435143229e+01,     4.238398316067822e+01,     4.654068924197404e+01,     5.079036393491204e+01,     5.513810608892351e+01, 
            5.958945809656147e+01,     6.415045881331059e+01,     6.882770464168054e+01,     7.362842034266140e+01,     7.856054149645662e+01, 
            8.363281099225591e+01,     8.885489250955710e+01,     9.423750470578169e+01,     9.979258079956615e+01,     1.055334595131173e+02, 
            1.114751150152773e+02,     1.176344357361682e+02,     1.240305649108684e+02,     1.306853197464513e+02,     1.376237116128734e+02, 
            1.448745972617866e+02,     1.524715014555383e+02,     1.604536665423852e+02,     1.688674047143261e+02,     1.777678587837689e+02, 
            1.872213189200417e+02,     1.973083019056076e+02,     2.081276803545904e+02,     2.198022526749525e+02,     2.324862521221532e+02, 
            2.463753232284382e+02,     2.617191724994045e+02,     2.788356364658223e+02,     2.981203933676394e+02,     3.200359885059537e+02, 
            3.450482508089989e+02,     3.734671579198042e+02,     4.051068189317427e+02,     4.386692098336746e+02,     4.716333282589395e+02, 
            5.019055983915314e+02,     5.285490490946037e+02,     5.514634457571544e+02,     5.710923057380572e+02,     5.880336530699930e+02, 
            6.028305800434587e+02,     6.159149084886005e+02,     6.276160680796875e+02,     6.381844046308661e+02,     6.478120584767901e+02, 
            6.566485524778349e+02,     6.648119197439245e+02,     6.723966164408333e+02,     6.794791966373284e+02,     6.861224317440060e+02, 
            6.923783406466417e+02,     6.982904489378672e+02,     7.038954960927114e+02,     7.092247422527013e+02,     7.143049807726813e+02, 
            7.191593316815063e+02,     7.238078699265224e+02,     7.282681275220556e+02,     7.325554983825862e+02,     7.366835672823672e+02, 
            7.406643791062279e+02,     7.445086607125725e+02,     7.482260048949375e+02,     7.518250238131691e+02,     7.553134776697518e+02, 
            7.586983831912002e+02,     7.619861055399000e+02,     7.651824365573930e+02,     7.682926616743207e+02,     7.713216173774056e+02, 
            7.742737407717360e+02,     7.771531124964148e+02,     7.799634940273152e+02,     7.827083602202395e+02,     7.853909278019165e+02, 
            7.880141803977983e+02,     7.905808905889816e+02,     7.930936394114102e+02,     7.955548336454126e+02,     7.979667211898422e+02, 
            8.003314047705213e+02,     8.026508541956182e+02,     8.049269173395830e+02,     8.071613300113659e+02,     8.093557248407898e+02, 
            8.115116392985437e+02,     8.136305229497184e+02,     8.157137440275336e+02,     8.177625954026785e+02,     8.197783000140460e+02, 
            8.217620158184150e+02,     8.237148403095352e+02,     8.256378146509834e+02,     8.275319274618836e+02,     8.293981182900309e+02, 
            8.312372808029662e+02,     8.330502657241532e+02,     8.348378835383295e+02,     8.366009069875488e+02,     8.383400733770507e+02, 
            8.400560867081265e+02,     8.417496196533297e+02,     8.434213153878175e+02,     8.450717892892258e+02,     8.467016305172293e+02, 
            8.483114034828625e+02,     8.499016492166965e+02,     8.514728866441008e+02,     8.530256137750509e+02,     8.545603088152458e+02, 
            8.560774312046877e+02,     8.575774225893189e+02,     8.590607077308103e+02,     8.605276953591633e+02,     8.619787789723531e+02, 
            8.634143375870801e+02,     8.648347364624061e+02,     8.662403277791750e+02,     8.676314512308581e+02,     8.690084336656905e+02, 
            8.703715927806531e+02,     8.717212335709380e+02,     8.730576512560491e+02,     8.743811311832879e+02,     8.756919492663773e+02, 
            8.769903724000628e+02,     8.782766588522168e+02,     8.795510586349077e+02,     8.808138138557564e+02,     8.820651590356399e+02, 
            8.833053214863504e+02,     8.845345215146189e+02,     8.857529727712114e+02,     8.869608825039530e+02,     8.881584518139437e+02, 
            8.893458758990743e+02,     8.905233442856027e+02,     8.916910410484829e+02,     8.928491450210756e+02,     8.939978299948719e+02, 
            8.951372649097711e+02,     8.962676140354606e+02,     8.973890371443689e+02,     8.985016896766834e+02,     8.996057229095317e+02, 
            9.007012840593873e+02,     9.017885164996156e+02,     9.028675598470971e+02,     9.039385501065090e+02,     9.050016197958371e+02, 
            9.060568980664660e+02,     9.071045108181219e+02,     9.081445808089260e+02,     9.091772277608106e+02,     9.102025684605301e+02, 
            9.112207168564776e+02,     9.122317841515322e+02,     9.132358788921057e+02,     9.142331070535937e+02,     9.152235721223997e+02, 
            9.162073751746851e+02,     9.171846149520152e+02,     9.181553879340374e+02,     9.191197884083317e+02,     9.200779085375717e+02, 
            9.210298384241049e+02,     9.219756658736408e+02,     9.229154776243016e+02,     9.238493576856737e+02,     9.247773885171727e+02, 
            9.256996508061395e+02,     9.266162235192603e+02,     9.275271839521123e+02,     9.284326077769250e+02,     9.293325690886355e+02, 
            9.302271404492965e+02,     9.311163929309284e+02,     9.320003961568651e+02,     9.328792183416570e+02,     9.337529263296052e+02, 
            9.346215856319644e+02,     9.354852604628846e+02,     9.363440137741360e+02,     9.371979072886621e+02,     9.380470015330235e+02, 
            9.388913558687524e+02,     9.397310285226912e+02,     9.405660766163242e+02,     9.413965561941684e+02,     9.422225222512376e+02, 
            9.430440287596376e+02,     9.438611286943052e+02,     9.446738740579394e+02,     9.454823159051438e+02,     9.462865043658197e+02, 
            9.470864886678323e+02,     9.478823171589764e+02,     9.486740373282704e+02,     9.494616958266038e+02,     9.502453384867555e+02, 
            9.510250103428185e+02,     9.518007556490348e+02,     9.525726178980798e+02,     9.533406398388008e+02,     9.541048634934378e+02, 
            9.548653301743439e+02,     9.556220805002198e+02,     9.563751544118809e+02,     9.571245911875714e+02,     9.578704294578454e+02, 
            9.586127072200288e+02,     9.593514618522668e+02,     9.600867301271884e+02,     9.608185482251835e+02,     9.615469517473167e+02, 
            9.622719752758512e+02,     9.629936541757303e+02,     9.637120219503618e+02,     9.644271120057173e+02,     9.651389572279163e+02, 
            9.658475899941764e+02,     9.665530421834770e+02,     9.672553451869393e+02,     9.679545299179281e+02,     9.686506268219019e+02, 
            9.693436658859945e+02,     9.700336766483566e+02,     9.707206882072579e+02,     9.714047292299517e+02,     9.720858279613145e+02, 
            9.727640122322766e+02,     9.734393094680258e+02,     9.741117466960188e+02,     9.747813505537844e+02,     9.754481472965415e+02, 
            9.761121628046210e+02,     9.767734225907136e+02,     9.774319518069340e+02,     9.780877752517205e+02,     9.787409173765650e+02, 
            9.793914022925770e+02,     9.800392537769023e+02,     9.806844952789769e+02,     9.813271499266395e+02,     9.819672405321010e+02, 
            9.826047895977705e+02,     9.832398193219487e+02,     9.838723516043885e+02,     9.845024080517251e+02,     9.851300099827854e+02, 
            9.857551784337730e+02,     9.863779341633389e+02,     9.869982976575300e+02,     9.876162891346381e+02,     9.882319285499273e+02, 
            9.888452356002662e+02,     9.894562297286512e+02,     9.900649301286344e+02,     9.906713557486477e+02,     9.912755252962399e+02, 
            9.918774572422154e+02,     9.924771698246876e+02,     9.930746810530410e+02,     9.936700087118116e+02,     9.942631703644814e+02, 
            9.948541833571929e+02,     9.954430648223885e+02,     9.960298316823651e+02,     9.966145006527624e+02,     9.971970882459757e+02, 
            9.977776107744917e+02,     9.983560843541637e+02,     9.989325249074163e+02,     9.995069481663819e+02,     1.000079369675973e+03, 
            1.000649804796898e+03,     1.001218268708606e+03,     1.001784776412184e+03,     1.002349342733182e+03,     1.002911982324395e+03, 
            1.003472709668579e+03,     1.004031539081122e+03,     1.004588484712651e+03,     1.005143560551602e+03,     1.005696780426726e+03, 
            1.006248158009555e+03,     1.006797706816814e+03,     1.007345440212795e+03,     1.007891371411672e+03,     1.008435513479786e+03, 
            1.008977879337872e+03,     1.009518481763258e+03,     1.010057333392011e+03,     1.010594446721048e+03,     1.011129834110205e+03, 
            1.011663507784268e+03,     1.012195479834966e+03,     1.012725762222928e+03,     1.013254366779601e+03,     1.013781305209137e+03, 
            1.014306589090239e+03,     1.014830229877978e+03,     1.015352238905581e+03,     1.015872627386170e+03,     1.016391406414492e+03, 
            1.016908586968598e+03,     1.017424179911507e+03,     1.017938195992827e+03,     1.018450645850360e+03,     1.018961540011667e+03, 
            1.019470888895611e+03,     1.019978702813877e+03,     1.020484991972453e+03,     1.020989766473100e+03,     1.021493036314783e+03, 
            1.021994811395084e+03,     1.022495101511594e+03,     1.022993916363272e+03,     1.023491265551787e+03,     1.023987158582834e+03, 
            1.024481604867430e+03,     1.024974613723188e+03,     1.025466194375563e+03,     1.025956355959089e+03,     1.026445107518584e+03, 
            1.026932458010340e+03,     1.027418416303293e+03,     1.027902991180171e+03,     1.028386191338624e+03,     1.028868025392344e+03, 
            1.029348501872148e+03,     1.029827629227060e+03,     1.030305415825366e+03,     1.030781869955659e+03,     1.031256999827860e+03, 
            1.031730813574225e+03,     1.032203319250338e+03,     1.032674524836086e+03,     1.033144438236616e+03,     1.033613067283286e+03, 
            1.034080419734586e+03,     1.034546503277056e+03,     1.035011325526190e+03,     1.035474894027315e+03,     1.035937216256469e+03, 
            1.036398299621254e+03,     1.036858151461685e+03,     1.037316779051021e+03,     1.037774189596582e+03,     1.038230390240558e+03, 
            1.038685388060801e+03,     1.039139190071607e+03,     1.039591803224484e+03,     1.040043234408917e+03,     1.040493490453103e+03, 
            1.040942578124697e+03,     1.041390504131528e+03,     1.041837275122319e+03,     1.042282897687385e+03,     1.042727378359322e+03, 
            1.043170723613697e+03,     1.043612939869713e+03,     1.044054033490874e+03,     1.044494010785632e+03,     1.044932878008036e+03, 
            1.045370641358358e+03,     1.045807306983720e+03,     1.046242880978708e+03,     1.046677369385977e+03,     1.047110778196849e+03, 
            1.047543113351897e+03,     1.047974380741529e+03,     1.048404586206557e+03,     1.048833735538760e+03,     1.049261834481438e+03, 
            1.049688888729964e+03,     1.050114903932315e+03,     1.050539885689610e+03,     1.050963839556634e+03,     1.051386771042350e+03, 
            1.051808685610413e+03,     1.052229588679671e+03,     1.052649485624659e+03,     1.053068381776089e+03,     1.053486282421333e+03, 
            1.053903192804893e+03,     1.054319118128876e+03,     1.054734063553449e+03,     1.055148034197302e+03,     1.055561035138091e+03, 
            1.055973071412887e+03,     1.056384148018608e+03,     1.056794269912454e+03,     1.057203442012330e+03,     1.057611669197269e+03, 
            1.058018956307842e+03,     1.058425308146571e+03,     1.058830729478328e+03,     1.059235225030735e+03,     1.059638799494559e+03, 
            1.060041457524091e+03,     1.060443203737539e+03,     1.060844042717396e+03,     1.061243979010817e+03,     1.061643017129986e+03, 
            1.062041161552474e+03,     1.062438416721606e+03,     1.062834787046802e+03,     1.063230276903937e+03,     1.063624890635676e+03, 
            1.064018632551820e+03,     1.064411506929637e+03,     1.064803518014195e+03,     1.065194670018688e+03,     1.065584967124758e+03, 
            1.065974413482814e+03,     1.066363013212348e+03,     1.066750770402241e+03,     1.067137689111073e+03,     1.067523773367425e+03, 
            1.067909027170177e+03,     1.068293454488805e+03,     1.068677059263667e+03,     1.069059845406299e+03,     1.069441816799690e+03, 
            1.069822977298571e+03,     1.070203330729685e+03,     1.070582880892068e+03,     1.070961631557313e+03,     1.071339586469838e+03, 
            1.071716749347154e+03,     1.072093123880122e+03,     1.072468713733209e+03,     1.072843522544747e+03,     1.073217553927181e+03, 
            1.073590811467316e+03,     1.073963298726566e+03,     1.074335019241192e+03,     1.074705976522545e+03,     1.075076174057300e+03, 
            1.075445615307688e+03,     1.075814303711734e+03,     1.076182242683474e+03,     1.076549435613192e+03,     1.076915885867634e+03, 
            1.077281596790233e+03,     1.077646571701323e+03,     1.078010813898357e+03,     1.078374326656118e+03,     1.078737113226929e+03, 
            1.079099176840861e+03,     1.079460520705937e+03,     1.079821148008334e+03,     1.080181061912588e+03,     1.080540265561786e+03, 
            1.080898762077767e+03,     1.081256554561311e+03,     1.081613646092333e+03,     1.081970039730071e+03,     1.082325738513276e+03, 
            1.082680745460391e+03,     1.083035063569739e+03,     1.083388695819702e+03,     1.083741645168898e+03,     1.084093914556360e+03, 
            1.084445506901709e+03,     1.084796425105328e+03,     1.085146672048533e+03,     1.085496250593739e+03,     1.085845163584629e+03, 
            1.086193413846320e+03,     1.086541004185525e+03,     1.086887937390716e+03,     1.087234216232279e+03,     1.087579843462678e+03, 
            1.087924821816609e+03,     1.088269154011153e+03,     1.088612842745929e+03,     1.088955890703248e+03,     1.089298300548257e+03, 
            1.089640074929096e+03,     1.089981216477034e+03,     1.090321727806618e+03,     1.090661611515821e+03,     1.091000870186173e+03
    },
    {
            1.664875049124133e+00,     5.038433281860136e+00,     8.467762197249115e+00,     1.195513152844538e+01,     1.550295991687934e+01, 
            1.911382811938967e+01,     2.279049370890770e+01,     2.653590748071864e+01,     3.035323180402527e+01,     3.424586120639005e+01, 
            3.821744552544155e+01,     4.227191602354981e+01,     4.641351493414322e+01,     5.064682899727864e+01,     5.497682765078671e+01, 
            5.940890667689919e+01,     6.394893826923212e+01,     6.860332868984661e+01,     7.337908494184803e+01,     7.828389220476592e+01, 
            8.332620418487356e+01,     8.851534905096915e+01,     9.386165428589906e+01,     9.937659463773549e+01,     1.050729684615162e+02, 
            1.109651091910001e+02,     1.170691405893283e+02,     1.234032869643801e+02,     1.299882529322811e+02,     1.368476918999677e+02, 
            1.440087887031569e+02,     1.515029902644611e+02,     1.593669303273853e+02,     1.676436101852294e+02,     1.763839206929248e+02, 
            1.856486222873351e+02,     1.955109432844459e+02,     2.060600141889151e+02,     2.174054254432270e+02,     2.296832611642302e+02, 
            2.430639591600435e+02,     2.577620856788234e+02,     2.740470691885678e+02,     2.922508934576859e+02,     3.127617369746924e+02, 
            3.359815562262890e+02,     3.622182441690594e+02,     3.914713459650004e+02,     4.230285723047942e+02,     4.550992138371369e+02, 
            4.855063713425009e+02,     5.129995495723688e+02,     5.371019421444860e+02,     5.579534622988814e+02,     5.760037202873980e+02, 
            5.917568354975705e+02,     6.056538083046547e+02,     6.180464056767419e+02,     6.292071213741125e+02,     6.393466139751974e+02, 
            6.486291451913444e+02,     6.571843441742291e+02,     6.651158066623447e+02,     6.725073402436010e+02,     6.794275253566392e+02, 
            6.859330789203755e+02,     6.920713633699304e+02,     6.978822809280488e+02,     7.033997212347533e+02,     7.086526808343688e+02, 
            7.136661386999120e+02,     7.184617481798122e+02,     7.230583891663092e+02,     7.274726126336886e+02,     7.317190014288933e+02, 
            7.358104652672881e+02,     7.397584835810618e+02,     7.435733067039936e+02,     7.472641235237116e+02,     7.508392019634953e+02, 
            7.543060073113438e+02,     7.576713023827106e+02,     7.609412327050977e+02,     7.641213992900083e+02,     7.672169210684136e+02, 
            7.702324886789014e+02,     7.731724109895787e+02,     7.760406554883474e+02,     7.788408834778351e+02,     7.815764808509452e+02, 
            7.842505850928010e+02,     7.868661090486148e+02,     7.894257619100387e+02,     7.919320678009926e+02,     7.943873822848630e+02, 
            7.967939070660223e+02,     7.991537031179045e+02,     8.014687024358444e+02,     8.037407185844670e+02,     8.059714561854408e+02, 
            8.081625194712723e+02,     8.103154200137436e+02,     8.124315837211249e+02,     8.145123571859654e+02,     8.165590134547840e+02, 
            8.185727572819444e+02,     8.205547299222980e+02,     8.225060135105476e+02,     8.244276350694855e+02,     8.263205701843865e+02, 
            8.281857463764387e+02,     8.300240462044281e+02,     8.318363101205690e+02,     8.336233391035613e+02,     8.353858970894363e+02, 
            8.371247132185770e+02,     8.388404839153542e+02,     8.405338748151322e+02,     8.422055225518944e+02,     8.438560364184236e+02, 
            8.454859999097623e+02,     8.470959721596702e+02,     8.486864892788469e+02,     8.502580656028551e+02,     8.518111948569549e+02, 
            8.533463512443730e+02,     8.548639904639754e+02,     8.563645506627295e+02,     8.578484533279136e+02,     8.593161041235628e+02, 
            8.607678936752850e+02,     8.622041983194808e+02,     8.636253808363605e+02,     8.650317910085142e+02,     8.664237654603912e+02, 
            8.678016310391880e+02,     8.691657016459127e+02,     8.705162809913260e+02,     8.718536625595078e+02,     8.731781300649934e+02, 
            8.744899578847176e+02,     8.757894114664011e+02,     8.770767477149052e+02,     8.783522153427554e+02,     8.796160552786798e+02, 
            8.808685009004948e+02,     8.821097784115150e+02,     8.833401071191623e+02,     8.845596997152888e+02,     8.857687625424051e+02, 
            8.869674958466580e+02,     8.881560940183307e+02,     8.893347458206017e+02,     8.905036346072362e+02,     8.916629385298417e+02, 
            8.928128307352919e+02,     8.939534795538525e+02,     8.950850486785411e+02,     8.962076973362066e+02,     8.973215804621902e+02, 
            8.984268488093037e+02,     8.995236491688398e+02,     9.006121244632819e+02,     9.016924138949536e+02,     9.027646530759761e+02, 
            9.038289741525745e+02,     9.048855059240334e+02,     9.059343739565746e+02,     9.069757006924087e+02,     9.080096055542083e+02, 
            9.090362050452271e+02,     9.100556128452891e+02,     9.110679399028378e+02,     9.120732945232487e+02,     9.130717824535778e+02, 
            9.140635069639245e+02,     9.150485689255588e+02,     9.160270668859822e+02,     9.169990971410496e+02,     9.179647538042946e+02, 
            9.189241288735955e+02,     9.198773122952911e+02,     9.208243920258666e+02,     9.217654537505450e+02,     9.227005822767090e+02, 
            9.236298596233792e+02,     9.245533663596299e+02,     9.254711813403441e+02,     9.263833817554405e+02,     9.272900431773343e+02, 
            9.281912396067058e+02,     9.290870435166398e+02,     9.299775258952189e+02,     9.308627562866257e+02,     9.317428028308192e+02, 
            9.326177323018434e+02,     9.334876101448268e+02,     9.343525005117257e+02,     9.352124662958608e+02,     9.360675691652949e+02, 
            9.369178695950982e+02,     9.377634268985576e+02,     9.386042992573455e+02,     9.394405437507195e+02,     9.402722163837648e+02, 
            9.410993721147363e+02,     9.419220648815191e+02,     9.427403476272541e+02,     9.435542723251548e+02,     9.443638900025412e+02, 
            9.451692507641307e+02,     9.459704038146042e+02,     9.467673974804802e+02,     9.475602792313213e+02,     9.483490957002932e+02, 
            9.491338927041074e+02,     9.499147152623624e+02,     9.506916076163104e+02,     9.514646132470690e+02,     9.522337748932943e+02, 
            9.529991345683378e+02,     9.537607335769040e+02,     9.545186125312297e+02,     9.552728113667941e+02,     9.560233693575797e+02, 
            9.567703251309039e+02,     9.575137166818320e+02,     9.582535813871788e+02,     9.589899560191292e+02,     9.597228767584728e+02, 
            9.604523787593232e+02,     9.611784979354483e+02,     9.619012683394342e+02,     9.626207239117518e+02,     9.633368980624234e+02, 
            9.640498236822507e+02,     9.647595331537300e+02,     9.654660583616892e+02,     9.661694307036346e+02,     9.668696810998351e+02, 
            9.675668400031361e+02,     9.682609374085256e+02,     9.689520028624476e+02,     9.696400654718805e+02,     9.703251539131837e+02, 
            9.710072964407173e+02,     9.716865208952464e+02,     9.723628547121363e+02,     9.730363249293349e+02,     9.737069581951683e+02, 
            9.743747807759354e+02,     9.750398185633171e+02,     9.757020970816072e+02,     9.763616414947676e+02,     9.770184766133049e+02, 
            9.776726269009946e+02,     9.783241164814297e+02,     9.789729691444256e+02,     9.796192083522664e+02,     9.802628572458029e+02, 
            9.809039386504135e+02,     9.815424750818165e+02,     9.821784887517598e+02,     9.828120015735645e+02,     9.834430351675522e+02, 
            9.840716108663449e+02,     9.846977497200390e+02,     9.853214725012672e+02,     9.859427997101485e+02,     9.865617515791165e+02, 
            9.871783480776505e+02,     9.877926089168963e+02,     9.884045535541859e+02,     9.890142011974547e+02,     9.896215708095651e+02, 
            9.902266811125356e+02,     9.908295505916731e+02,     9.914301974996238e+02,     9.920286398603291e+02,     9.926248954729002e+02, 
            9.932189819154099e+02,     9.938109165486046e+02,     9.944007165195334e+02,     9.949883987651053e+02,     9.955739800155720e+02, 
            9.961574767979334e+02,     9.967389054392759e+02,     9.973182820700414e+02,     9.978956226272272e+02,     9.984709428575215e+02, 
            9.990442583203767e+02,     9.996155843910130e+02,     1.000184936263372e+03,     1.000752328953000e+03,     1.001317777299882e+03, 
            1.001881295971211e+03,     1.002442899464111e+03,     1.003002602108300e+03,     1.003560418068698e+03,     1.004116361347993e+03, 
            1.004670445789147e+03,     1.005222685077859e+03,     1.005773092744980e+03,     1.006321682168876e+03,     1.006868466577753e+03, 
            1.007413459051930e+03,     1.007956672526074e+03,     1.008498119791394e+03,     1.009037813497782e+03,     1.009575766155928e+03, 
            1.010111990139386e+03,     1.010646497686606e+03,     1.011179300902924e+03,     1.011710411762519e+03,     1.012239842110329e+03, 
            1.012767603663939e+03,     1.013293708015426e+03,     1.013818166633177e+03,     1.014340990863668e+03,     1.014862191933215e+03, 
            1.015381780949695e+03,     1.015899768904228e+03,     1.016416166672837e+03,     1.016930985018072e+03,     1.017444234590615e+03, 
            1.017955925930841e+03,     1.018466069470367e+03,     1.018974675533561e+03,     1.019481754339037e+03,     1.019987316001111e+03, 
            1.020491370531240e+03,     1.020993927839436e+03,     1.021494997735651e+03,     1.021994589931139e+03,     1.022492714039801e+03, 
            1.022989379579497e+03,     1.023484595973345e+03,     1.023978372550989e+03,     1.024470718549855e+03,     1.024961643116380e+03, 
            1.025451155307215e+03,     1.025939264090426e+03,     1.026425978346652e+03,     1.026911306870262e+03,     1.027395258370482e+03, 
            1.027877841472510e+03,     1.028359064718607e+03,     1.028838936569174e+03,     1.029317465403813e+03,     1.029794659522362e+03, 
            1.030270527145925e+03,     1.030745076417879e+03,     1.031218315404861e+03,     1.031690252097746e+03,     1.032160894412610e+03, 
            1.032630250191669e+03,     1.033098327204212e+03,     1.033565133147514e+03,     1.034030675647740e+03,     1.034494962260826e+03, 
            1.034958000473352e+03,     1.035419797703405e+03,     1.035880361301420e+03,     1.036339698551013e+03,     1.036797816669801e+03, 
            1.037254722810208e+03,     1.037710424060261e+03,     1.038164927444365e+03,     1.038618239924084e+03,     1.039070368398889e+03, 
            1.039521319706912e+03,     1.039971100625675e+03,     1.040419717872822e+03,     1.040867178106824e+03,     1.041313487927690e+03, 
            1.041758653877652e+03,     1.042202682441852e+03,     1.042645580049009e+03,     1.043087353072086e+03,     1.043528007828940e+03, 
            1.043967550582961e+03,     1.044405987543711e+03,     1.044843324867544e+03,     1.045279568658220e+03,     1.045714724967514e+03, 
            1.046148799795809e+03,     1.046581799092687e+03,     1.047013728757511e+03,     1.047444594639988e+03,     1.047874402540743e+03, 
            1.048303158211866e+03,     1.048730867357464e+03,     1.049157535634199e+03,     1.049583168651819e+03,     1.050007771973684e+03, 
            1.050431351117282e+03,     1.050853911554742e+03,     1.051275458713329e+03,     1.051695997975950e+03,     1.052115534681633e+03, 
            1.052534074126016e+03,     1.052951621561818e+03,     1.053368182199311e+03,     1.053783761206780e+03,     1.054198363710979e+03, 
            1.054611994797584e+03,     1.055024659511632e+03,     1.055436362857960e+03,     1.055847109801639e+03,     1.056256905268400e+03, 
            1.056665754145048e+03,     1.057073661279885e+03,     1.057480631483111e+03,     1.057886669527233e+03,     1.058291780147463e+03, 
            1.058695968042105e+03,     1.059099237872949e+03,     1.059501594265653e+03,     1.059903041810112e+03,     1.060303585060843e+03, 
            1.060703228537345e+03,     1.061101976724460e+03,     1.061499834072737e+03,     1.061896804998783e+03,     1.062292893885609e+03, 
            1.062688105082979e+03,     1.063082442907745e+03,     1.063475911644187e+03,     1.063868515544341e+03,     1.064260258828328e+03, 
            1.064651145684673e+03,     1.065041180270631e+03,     1.065430366712493e+03,     1.065818709105904e+03,     1.066206211516163e+03, 
            1.066592877978532e+03,     1.066978712498530e+03,     1.067363719052233e+03,     1.067747901586563e+03,     1.068131264019573e+03, 
            1.068513810240738e+03,     1.068895544111232e+03,     1.069276469464205e+03,     1.069656590105058e+03,     1.070035909811713e+03, 
            1.070414432334882e+03,     1.070792161398329e+03,     1.071169100699133e+03,     1.071545253907941e+03,     1.071920624669229e+03, 
            1.072295216601549e+03,     1.072669033297778e+03,     1.073042078325365e+03,     1.073414355226572e+03,     1.073785867518711e+03, 
            1.074156618694389e+03,     1.074526612221733e+03,     1.074895851544624e+03,     1.075264340082927e+03,     1.075632081232715e+03, 
            1.075999078366492e+03,     1.076365334833415e+03,     1.076730853959508e+03,     1.077095639047882e+03,     1.077459693378942e+03, 
            1.077823020210604e+03,     1.078185622778497e+03,     1.078547504296169e+03,     1.078908667955296e+03,     1.079269116925871e+03, 
            1.079628854356416e+03,     1.079987883374166e+03,     1.080346207085273e+03,     1.080703828574985e+03,     1.081060750907852e+03, 
            1.081416977127896e+03,     1.081772510258807e+03,     1.082127353304125e+03,     1.082481509247416e+03,     1.082834981052455e+03, 
            1.083187771663400e+03,     1.083539884004970e+03,     1.083891320982617e+03,     1.084242085482693e+03,     1.084592180372626e+03, 
            1.084941608501079e+03,     1.085290372698124e+03,     1.085638475775400e+03,     1.085985920526273e+03,     1.086332709726002e+03, 
            1.086678846131894e+03,     1.087024332483457e+03,     1.087369171502560e+03,     1.087713365893585e+03,     1.088056918343575e+03, 
            1.088399831522387e+03,     1.088742108082839e+03,     1.089083750660855e+03,     1.089424761875614e+03,     1.089765144329686e+03
    },
    {
            1.661694038984970e+00,     5.028545777197706e+00,     8.450687633262532e+00,     1.193035073053473e+01,     1.546991121403118e+01, 
            1.907190297425714e+01,     2.273903179256200e+01,     2.647419110739802e+01,     3.028047962603408e+01,     3.416122105092811e+01, 
            3.811998623287453e+01,     4.216061811948462e+01,     4.628725993443374e+01,     5.050438710418940e+01,     5.481684354796464e+01, 
            5.922988306791773e+01,     6.374921672584551e+01,     6.838106727721124e+01,     7.313223196285699e+01,     7.801015524620614e+01, 
            8.302301344399758e+01,     8.817981365703811e+01,     9.349050998823765e+01,     9.896614078192083e+01,     1.046189915807673e+02, 
            1.104627897473213e+02,     1.165129383331312e+02,     1.227867989344873e+02,     1.293040361350295e+02,     1.360870399601366e+02, 
            1.431614479352128e+02,     1.505567951899716e+02,     1.583073308734926e+02,     1.664530516077044e+02,     1.750410208821937e+02, 
            1.841270670651446e+02,     1.937779847914327e+02,     2.040744052565929e+02,     2.151145475785674e+02,     2.270191011597734e+02, 
            2.399374697298846e+02,     2.540553949265810e+02,     2.696032196873934e+02,     2.868619603724048e+02,     3.061596325598967e+02, 
            3.278425521507911e+02,     3.522004390017094e+02,     3.793226875793132e+02,     4.088400476508864e+02,     4.395790917900778e+02, 
            4.696680059088197e+02,     4.975855226085137e+02,     5.225966949309848e+02,     5.445384774936755e+02,     5.636602988439124e+02, 
            5.803774379285614e+02,     5.951109840156192e+02,     6.082221486253570e+02,     6.200009199358523e+02,     6.306751832397745e+02, 
            6.404238410365822e+02,     6.493883906717667e+02,     6.576819193391432e+02,     6.653958221628698e+02,     6.726047765642785e+02, 
            6.793704365131755e+02,     6.857441971728131e+02,     6.917692841205668e+02,     6.974823491595598e+02,     7.029147027646934e+02, 
            7.080932763176401e+02,     7.130413812465378e+02,     7.177793138191711e+02,     7.223248413452995e+02,     7.266935962976401e+02, 
            7.308993982265715e+02,     7.349545185355424e+02,     7.388698996612696e+02,     7.426553375922755e+02,     7.463196347030125e+02, 
            7.498707283989196e+02,     7.533157999339195e+02,     7.566613668861988e+02,     7.599133620960565e+02,     7.630772013342599e+02, 
            7.661578415462191e+02,     7.691598311806242e+02,     7.720873538418768e+02,     7.749442662889259e+02,     7.777341316279330e+02, 
            7.804602484038860e+02,     7.831256761801434e+02,     7.857332580997970e+02,     7.882856408444640e+02,     7.907852923415303e+02, 
            7.932345175173059e+02,     7.956354723490514e+02,     7.979901764316203e+02,     8.003005242434052e+02,     8.025682952700687e+02, 
            8.047951631225604e+02,     8.069827037672613e+02,     8.091324029703029e+02,     8.112456630447085e+02,     8.133238089774931e+02, 
            8.153680940041088e+02,     8.173797046891824e+02,     8.193597655652757e+02,     8.213093433751644e+02,     8.232294509577379e+02, 
            8.251210508129509e+02,     8.269850583772087e+02,     8.288223450370130e+02,     8.306337409056281e+02,     8.324200373848278e+02, 
            8.341819895313932e+02,     8.359203182459854e+02,     8.376357123001522e+02,     8.393288302156411e+02,     8.410003020087388e+02, 
            8.426507308111007e+02,     8.442806943774194e+02,     8.458907464892645e+02,     8.474814182635516e+02,     8.490532193732968e+02, 
            8.506066391876044e+02,     8.521421478372067e+02,     8.536601972113010e+02,     8.551612218909061e+02,     8.566456400235360e+02, 
            8.581138541582452e+02,     8.595662519631472e+02,     8.610032070703074e+02,     8.624250796666136e+02,     8.638322169290557e+02, 
            8.652249533730652e+02,     8.666036137263346e+02,     8.679685098294769e+02,     8.693199434972558e+02,     8.706582064291758e+02, 
            8.719835806593587e+02,     8.732963389817689e+02,     8.745967453371572e+02,     8.758850552557914e+02,     8.771615161223508e+02, 
            8.784263675825111e+02,     8.796798418498357e+02,     8.809221640127248e+02,     8.821535523256865e+02,     8.833742184859008e+02, 
            8.845843678959397e+02,     8.857841999134747e+02,     8.869739080887234e+02,     8.881536803903540e+02,     8.893236994205105e+02, 
            8.904841426195804e+02,     8.916351824612806e+02,     8.927769866386012e+02,     8.939097182411275e+02,     8.950335359353284e+02, 
            8.961485940803293e+02,     8.972550429524308e+02,     8.983530288441156e+02,     8.994426942171804e+02,     9.005241778372539e+02, 
            9.015976149024423e+02,     9.026631371664095e+02,     9.037208730561775e+02,     9.047709477849114e+02,     9.058134834599533e+02, 
            9.068485991863259e+02,     9.078764111659523e+02,     9.088970327927813e+02,     9.099105747440357e+02,     9.109171450677637e+02, 
            9.119168492668721e+02,     9.129097903798083e+02,     9.138960690580536e+02,     9.148757836405804e+02,     9.158490302254008e+02, 
            9.168159027383589e+02,     9.177764929992846e+02,     9.187308907856284e+02,     9.196791835369590e+02,     9.206214578121251e+02, 
            9.215577973188130e+02,     9.224882842001495e+02,     9.234129989219451e+02,     9.243320202164128e+02,     9.252454251572458e+02, 
            9.261532892067657e+02,     9.270556862613937e+02,     9.279526886955150e+02,     9.288443674038018e+02,     9.297307918420688e+02, 
            9.306120300667062e+02,     9.314881487727640e+02,     9.323592133307350e+02,     9.332252878220958e+02,     9.340864350736421e+02, 
            9.349427166906869e+02,     9.357941930891543e+02,     9.366409235266099e+02,     9.374829661322815e+02,     9.383203779361000e+02, 
            9.391532148968033e+02,     9.399815319291354e+02,     9.408053829301849e+02,     9.416248208048794e+02,     9.424398974906850e+02, 
            9.432506639815298e+02,     9.440571703509847e+02,     9.448594657747311e+02,     9.456575985523332e+02,     9.464516161283531e+02, 
            9.472415651128218e+02,     9.480274913010966e+02,     9.488094396931227e+02,     9.495874545121194e+02,     9.503615792227232e+02, 
            9.511318565485869e+02,     9.518983284894713e+02,     9.526610363378395e+02,     9.534200206949723e+02,     9.541753214866225e+02, 
            9.549269779782201e+02,     9.556750287896502e+02,     9.564195119096129e+02,     9.571604647095802e+02,     9.578979239573678e+02, 
            9.586319253860926e+02,     9.593625054651910e+02,     9.600896988032214e+02,     9.608135398817255e+02,     9.615340626410447e+02, 
            9.622513004918080e+02,     9.629652863261248e+02,     9.636760525284677e+02,     9.643836309862771e+02,     9.650880531002813e+02, 
            9.657893497945480e+02,     9.664875515262737e+02,     9.671826882953227e+02,     9.678747896535153e+02,     9.685638847136845e+02, 
            9.692500021584959e+02,     9.699331702490479e+02,     9.706134168332536e+02,     9.712907693540166e+02,     9.719652548571959e+02, 
            9.726368999993778e+02,     9.733057310554588e+02,     9.739717739260340e+02,     9.746350541446130e+02,     9.752955968846576e+02, 
            9.759534269664472e+02,     9.766085688637844e+02,     9.772610467105349e+02,     9.779108843070144e+02,     9.785581051262229e+02, 
            9.792027323199338e+02,     9.798447887246396e+02,     9.804842968673586e+02,     9.811212789713039e+02,     9.817557569614283e+02, 
            9.823877524698339e+02,     9.830172868410652e+02,     9.836443811372741e+02,     9.842690561432751e+02,     9.848913323714805e+02, 
            9.855112300667299e+02,     9.861287692110063e+02,     9.867439695280548e+02,     9.873568504878897e+02,     9.879674313112098e+02, 
            9.885757309737155e+02,     9.891817682103273e+02,     9.897855615193176e+02,     9.903871291663515e+02,     9.909864891884403e+02, 
            9.915836593978099e+02,     9.921786573856873e+02,     9.927715005260079e+02,     9.933622059790393e+02,     9.939507906949384e+02, 
            9.945372714172233e+02,     9.951216646861780e+02,     9.957039868421909e+02,     9.962842540290118e+02,     9.968624821969557e+02, 
            9.974386871060307e+02,     9.980128843290081e+02,     9.985850892544278e+02,     9.991553170895409e+02,     9.997235828631979e+02, 
            1.000289901428675e+03,     1.000854287466444e+03,     1.001416755486890e+03,     1.001977319832972e+03,     1.002535994682834e+03, 
            1.003092794052362e+03,     1.003647731797691e+03,     1.004200821617667e+03,     1.004752077056259e+03,     1.005301511504918e+03, 
            1.005849138204906e+03,     1.006394970249562e+03,     1.006939020586538e+03,     1.007481302019988e+03,     1.008021827212715e+03, 
            1.008560608688279e+03,     1.009097658833061e+03,     1.009632989898298e+03,     1.010166614002069e+03,     1.010698543131249e+03, 
            1.011228789143432e+03,     1.011757363768807e+03,     1.012284278612012e+03,     1.012809545153943e+03,     1.013333174753539e+03, 
            1.013855178649529e+03,     1.014375567962149e+03,     1.014894353694832e+03,     1.015411546735857e+03,     1.015927157859985e+03, 
            1.016441197730046e+03,     1.016953676898517e+03,     1.017464605809060e+03,     1.017973994798036e+03,     1.018481854095994e+03, 
            1.018988193829129e+03,     1.019493024020728e+03,     1.019996354592570e+03,     1.020498195366320e+03,     1.020998556064889e+03, 
            1.021497446313779e+03,     1.021994875642392e+03,     1.022490853485330e+03,     1.022985389183667e+03,     1.023478491986201e+03, 
            1.023970171050677e+03,     1.024460435445006e+03,     1.024949294148448e+03,     1.025436756052782e+03,     1.025922829963457e+03, 
            1.026407524600722e+03,     1.026890848600740e+03,     1.027372810516677e+03,     1.027853418819783e+03,     1.028332681900449e+03, 
            1.028810608069246e+03,     1.029287205557951e+03,     1.029762482520555e+03,     1.030236447034252e+03,     1.030709107100419e+03, 
            1.031180470645571e+03,     1.031650545522310e+03,     1.032119339510249e+03,     1.032586860316933e+03,     1.033053115578736e+03, 
            1.033518112861749e+03,     1.033981859662648e+03,     1.034444363409561e+03,     1.034905631462905e+03,     1.035365671116222e+03, 
            1.035824489596998e+03,     1.036282094067472e+03,     1.036738491625424e+03,     1.037193689304965e+03,     1.037647694077301e+03, 
            1.038100512851494e+03,     1.038552152475210e+03,     1.039002619735453e+03,     1.039451921359287e+03,     1.039900064014556e+03, 
            1.040347054310583e+03,     1.040792898798860e+03,     1.041237603973737e+03,     1.041681176273087e+03,     1.042123622078972e+03, 
            1.042564947718295e+03,     1.043005159463441e+03,     1.043444263532911e+03,     1.043882266091946e+03,     1.044319173253143e+03, 
            1.044754991077061e+03,     1.045189725572815e+03,     1.045623382698669e+03,     1.046055968362611e+03,     1.046487488422930e+03, 
            1.046917948688776e+03,     1.047347354920718e+03,     1.047775712831289e+03,     1.048203028085527e+03,     1.048629306301509e+03, 
            1.049054553050873e+03,     1.049478773859335e+03,     1.049901974207203e+03,     1.050324159529876e+03,     1.050745335218342e+03, 
            1.051165506619665e+03,     1.051584679037471e+03,     1.052002857732418e+03,     1.052420047922672e+03,     1.052836254784362e+03, 
            1.053251483452044e+03,     1.053665739019144e+03,     1.054079026538408e+03,     1.054491351022333e+03,     1.054902717443607e+03, 
            1.055313130735529e+03,     1.055722595792431e+03,     1.056131117470094e+03,     1.056538700586157e+03,     1.056945349920516e+03, 
            1.057351070215733e+03,     1.057755866177416e+03,     1.058159742474616e+03,     1.058562703740208e+03,     1.058964754571265e+03, 
            1.059365899529435e+03,     1.059766143141306e+03,     1.060165489898772e+03,     1.060563944259386e+03,     1.060961510646722e+03, 
            1.061358193450713e+03,     1.061753997028007e+03,     1.062148925702300e+03,     1.062542983764672e+03,     1.062936175473923e+03, 
            1.063328505056893e+03,     1.063719976708793e+03,     1.064110594593518e+03,     1.064500362843964e+03,     1.064889285562340e+03, 
            1.065277366820473e+03,     1.065664610660112e+03,     1.066051021093227e+03,     1.066436602102305e+03,     1.066821357640641e+03, 
            1.067205291632627e+03,     1.067588407974039e+03,     1.067970710532311e+03,     1.068352203146821e+03,     1.068732889629161e+03, 
            1.069112773763405e+03,     1.069491859306385e+03,     1.069870149987946e+03,     1.070247649511212e+03,     1.070624361552846e+03, 
            1.071000289763298e+03,     1.071375437767062e+03,     1.071749809162924e+03,     1.072123407524204e+03,     1.072496236399004e+03, 
            1.072868299310444e+03,     1.073239599756899e+03,     1.073610141212237e+03,     1.073979927126042e+03,     1.074348960923854e+03, 
            1.074717246007385e+03,     1.075084785754746e+03,     1.075451583520668e+03,     1.075817642636719e+03,     1.076182966411521e+03, 
            1.076547558130959e+03,     1.076911421058397e+03,     1.077274558434880e+03,     1.077636973479343e+03,     1.077998669388817e+03, 
            1.078359649338620e+03,     1.078719916482568e+03,     1.079079473953161e+03,     1.079438324861783e+03,     1.079796472298891e+03, 
            1.080153919334203e+03,     1.080510669016894e+03,     1.080866724375767e+03,     1.081222088419449e+03,     1.081576764136566e+03, 
            1.081930754495923e+03,     1.082284062446681e+03,     1.082636690918531e+03,     1.082988642821870e+03,     1.083339921047971e+03, 
            1.083690528469150e+03,     1.084040467938935e+03,     1.084389742292232e+03,     1.084738354345488e+03,     1.085086306896853e+03, 
            1.085433602726340e+03,     1.085780244595984e+03,     1.086126235249995e+03,     1.086471577414921e+03,     1.086816273799791e+03, 
            1.087160327096274e+03,     1.087503739978824e+03,     1.087846515104835e+03,     1.088188655114777e+03,     1.088530162632351e+03
    },
    {
            1.658525329487920e+00,     5.018698603566125e+00,     8.433686490223435e+00,     1.190568220557716e+01,     1.543702020578719e+01, 
            1.903018844531283e+01,     2.268784198807895e+01,     2.641281815901986e+01,     3.020815344629720e+01,     3.407710240617979e+01, 
            3.802315886188141e+01,     4.205007973959866e+01,     4.616191194627348e+01,     5.036302276785927e+01,     5.465813435708356e+01, 
            5.905236298975995e+01,     6.355126390368562e+01,     6.816088270046676e+01,     7.288781449661336e+01,     7.773927226665468e+01, 
            8.272316614271305e+01,     8.784819583798583e+01,     9.312395887588320e+01,     9.856107795740559e+01,     1.041713516372548e+02, 
            1.099679335587316e+02,     1.159655468997775e+02,     1.221807425152508e+02,     1.286322116711232e+02,     1.353411674565394e+02, 
            1.423318132238093e+02,     1.496319219759270e+02,     1.572735585456432e+02,     1.652939861997662e+02,     1.737368134558575e+02, 
            1.826534548695777e+02,     1.921050031752575e+02,     2.021646389702468e+02,     2.129207349138386e+02,     2.244808316126335e+02, 
            2.369766350132734e+02,     2.505700121828177e+02,     2.654594042906895e+02,     2.818846129850722e+02,     3.001246887066036e+02, 
            3.204782261194391e+02,     3.432105430467312e+02,     3.684528512738477e+02,     3.960316420139650e+02,     4.252105450294976e+02, 
            4.545684988977196e+02,     4.825214000311194e+02,     5.081227149711434e+02,     5.309613803028143e+02,     5.510672079758657e+02, 
            5.687253456415933e+02,     5.843031891465946e+02,     5.981520983395535e+02,     6.105706858605628e+02,     6.218006142522904e+02, 
            6.320343351483632e+02,     6.414250394755545e+02,     6.500954531433639e+02,     6.581447961620124e+02,     6.656540835326811e+02, 
            6.726901206741865e+02,     6.793085171045061e+02,     6.855559727486202e+02,     6.914720267621495e+02,     6.970904079597086e+02, 
            7.024400880725625e+02,     7.075461114860080e+02,     7.124302552417327e+02,     7.171115588386400e+02,     7.216067531370792e+02, 
            7.259306103010782e+02,     7.300962313666724e+02,     7.341152841120741e+02,     7.379982010139322e+02,     7.417543449142938e+02, 
            7.453921483926097e+02,     7.489192315937328e+02,     7.523425023053010e+02,     7.556682413336229e+02,     7.589021756441829e+02, 
            7.620495412723815e+02,     7.651151376442461e+02,     7.681033746541235e+02,     7.710183136108745e+02,     7.738637029737877e+02, 
            7.766430096446761e+02,     7.793594464564541e+02,     7.820159963949836e+02,     7.846154340059304e+02,     7.871603443679912e+02, 
            7.896531399556384e+02,     7.920960756660271e+02,     7.944912622442663e+02,     7.968406783073657e+02,     7.991461811387057e+02, 
            8.014095164009465e+02,     8.036323268949410e+02,     8.058161604751167e+02,     8.079624772171302e+02,     8.100726559211755e+02, 
            8.121480000236522e+02,     8.141897429808093e+02,     8.161990531800947e+02,     8.181770384282059e+02,     8.201247500590002e+02, 
            8.220431866993274e+02,     8.239332977265130e+02,     8.257959864473403e+02,     8.276321130250830e+02,     8.294424971782171e+02, 
            8.312279206718765e+02,     8.329891296208857e+02,     8.347268366212271e+02,     8.364417227250599e+02,     8.381344392728743e+02, 
            8.398056095949971e+02,     8.414558305934694e+02,     8.430856742142417e+02,     8.446956888186710e+02,     8.462864004624627e+02, 
            8.478583140894489e+02,     8.494119146468885e+02,     8.509476681284010e+02,     8.524660225645829e+02,     8.539674088782182e+02, 
            8.554522418318745e+02,     8.569209207749915e+02,     8.583738304451203e+02,     8.598113416588361e+02,     8.612338117575296e+02, 
            8.626415850808414e+02,     8.640349954851878e+02,     8.654143637841057e+02,     8.667800003191963e+02,     8.681322049611714e+02, 
            8.694712675782876e+02,     8.707974684637483e+02,     8.721110788163481e+02,     8.734123610408819e+02,     8.747015691881063e+02, 
            8.759789492929370e+02,     8.772447397108037e+02,     8.784991714365829e+02,     8.797424684071746e+02,     8.809748477887115e+02, 
            8.821965202493294e+02,     8.834076902183505e+02,     8.846085561326832e+02,     8.857993106711900e+02,     8.869801409777047e+02, 
            8.881512288733653e+02,     8.893127510588550e+02,     8.904648793071302e+02,     8.916077806470997e+02,     8.927416175499715e+02, 
            8.938665480514957e+02,     8.949827259805883e+02,     8.960903010645681e+02,     8.971894190869439e+02,     8.982802220266169e+02, 
            8.993628481909831e+02,     9.004374323432472e+02,     9.015041058242546e+02,     9.025629966691080e+02,     9.036142297188555e+02, 
            9.046579267274685e+02,     9.056942064643749e+02,     9.067231848127414e+02,     9.077449748637359e+02,     9.087596870069474e+02, 
            9.097674290171607e+02,     9.107683061376575e+02,     9.117624211602091e+02,     9.127498745019140e+02,     9.137307642790352e+02, 
            9.147051863779701e+02,     9.156732345234896e+02,     9.166350003443669e+02,     9.175905730880828e+02,     9.185400410471285e+02, 
            9.194834896099488e+02,     9.204210026294814e+02,     9.213526621890724e+02,     9.222785485240814e+02,     9.231987402639799e+02, 
            9.241133143558325e+02,     9.250223461417457e+02,     9.259259094040336e+02,     9.268240764087910e+02,     9.277169179479494e+02, 
            9.286045033798650e+02,     9.294869006685103e+02,     9.303641764213224e+02,     9.312363959257641e+02,     9.321036231846472e+02, 
            9.329659209502780e+02,     9.338233507574545e+02,     9.346759729553803e+02,     9.355238467385236e+02,     9.363670301764726e+02, 
            9.372055802428191e+02,     9.380395528431108e+02,     9.388690028419137e+02,     9.396939840890091e+02,     9.405145494447615e+02, 
            9.413307508046942e+02,     9.421426391232999e+02,     9.429502644371017e+02,     9.437536758870203e+02,     9.445529217400436e+02, 
            9.453480494102431e+02,     9.461391054791540e+02,     9.469261357155411e+02,     9.477091850945810e+02,     9.484882978164666e+02, 
            9.492635173244681e+02,     9.500348863224654e+02,     9.508024467919657e+02,     9.515662400086344e+02,     9.523263065583419e+02, 
            9.530826863527589e+02,     9.538354186445038e+02,     9.545845420418650e+02,     9.553300945231065e+02,     9.560721134503731e+02, 
            9.568106351429417e+02,     9.575456966327788e+02,     9.582773330912003e+02,     9.590055795474057e+02,     9.597304704784663e+02, 
            9.604520398210962e+02,     9.611703209831088e+02,     9.618853468545674e+02,     9.625971498186398e+02,     9.633057617621638e+02, 
            9.640112140859411e+02,     9.647135377147542e+02,     9.654127631071325e+02,     9.661089202648553e+02,     9.668020387422217e+02, 
            9.674921476550766e+02,     9.681792756896068e+02,     9.688634511109207e+02,     9.695447017714058e+02,     9.702230551188811e+02, 
            9.708985382045440e+02,     9.715711776907234e+02,     9.722409998584387e+02,     9.729080306147755e+02,     9.735722955000814e+02, 
            9.742338196949876e+02,     9.748926280272570e+02,     9.755487449784766e+02,     9.762021946905797e+02,     9.768530009722220e+02, 
            9.775011873049995e+02,     9.781467768495268e+02,     9.787897924513694e+02,     9.794302566468352e+02,     9.800681916686394e+02, 
            9.807036194514295e+02,     9.813365616371929e+02,     9.819670395805314e+02,     9.825950743538237e+02,     9.832206867522656e+02, 
            9.838438972988022e+02,     9.844647262489409e+02,     9.850831935954677e+02,     9.856993190730506e+02,     9.863131221627426e+02, 
            9.869246220963922e+02,     9.875338378609457e+02,     9.881407882026677e+02,     9.887454916312616e+02,     9.893479664239042e+02, 
            9.899482306291944e+02,     9.905463020710151e+02,     9.911421983523162e+02,     9.917359368588120e+02,     9.923275347626070e+02, 
            9.929170090257408e+02,     9.935043764036594e+02,     9.940896534486166e+02,     9.946728565130023e+02,     9.952540017526035e+02, 
            9.958331051297971e+02,     9.964101824166787e+02,     9.969852491981260e+02,     9.975583208748027e+02,     9.981294126660958e+02, 
            9.986985396130037e+02,     9.992657165809559e+02,     9.998309582625834e+02,     1.000394279180429e+03,     1.000955693689610e+03, 
            1.001515215980425e+03,     1.002072860080906e+03,     1.002628639859327e+03,     1.003182569026663e+03,     1.003734661138995e+03, 
            1.004284929599874e+03,     1.004833387662641e+03,     1.005380048432698e+03,     1.005924924869739e+03,     1.006468029789936e+03, 
            1.007009375868085e+03,     1.007548975639712e+03,     1.008086841503140e+03,     1.008622985721515e+03,     1.009157420424797e+03, 
            1.009690157611710e+03,     1.010221209151663e+03,     1.010750586786628e+03,     1.011278302132986e+03,     1.011804366683344e+03, 
            1.012328791808315e+03,     1.012851588758260e+03,     1.013372768665010e+03,     1.013892342543552e+03,     1.014410321293680e+03, 
            1.014926715701622e+03,     1.015441536441641e+03,     1.015954794077598e+03,     1.016466499064497e+03,     1.016976661749995e+03, 
            1.017485292375892e+03,     1.017992401079593e+03,     1.018497997895538e+03,     1.019002092756623e+03,     1.019504695495578e+03, 
            1.020005815846332e+03,     1.020505463445356e+03,     1.021003647832973e+03,     1.021500378454659e+03,     1.021995664662310e+03, 
            1.022489515715497e+03,     1.022981940782691e+03,     1.023472948942475e+03,     1.023962549184734e+03,     1.024450750411820e+03, 
            1.024937561439705e+03,     1.025422990999110e+03,     1.025907047736617e+03,     1.026389740215764e+03,     1.026871076918120e+03, 
            1.027351066244341e+03,     1.027829716515216e+03,     1.028307035972685e+03,     1.028783032780852e+03,     1.029257715026974e+03, 
            1.029731090722434e+03,     1.030203167803708e+03,     1.030673954133302e+03,     1.031143457500687e+03,     1.031611685623209e+03, 
            1.032078646146994e+03,     1.032544346647831e+03,     1.033008794632049e+03,     1.033471997537368e+03,     1.033933962733754e+03, 
            1.034394697524242e+03,     1.034854209145764e+03,     1.035312504769947e+03,     1.035769591503915e+03,     1.036225476391069e+03, 
            1.036680166411854e+03,     1.037133668484522e+03,     1.037585989465877e+03,     1.038037136152011e+03,     1.038487115279026e+03, 
            1.038935933523755e+03,     1.039383597504456e+03,     1.039830113781514e+03,     1.040275488858114e+03,     1.040719729180920e+03, 
            1.041162841140733e+03,     1.041604831073147e+03,     1.042045705259190e+03,     1.042485469925956e+03,     1.042924131247233e+03, 
            1.043361695344113e+03,     1.043798168285604e+03,     1.044233556089221e+03,     1.044667864721581e+03,     1.045101100098979e+03, 
            1.045533268087962e+03,     1.045964374505892e+03,     1.046394425121502e+03,     1.046823425655442e+03,     1.047251381780822e+03, 
            1.047678299123745e+03,     1.048104183263827e+03,     1.048529039734720e+03,     1.048952874024617e+03,     1.049375691576762e+03, 
            1.049797497789939e+03,     1.050218298018967e+03,     1.050638097575180e+03,     1.051056901726899e+03,     1.051474715699910e+03, 
            1.051891544677920e+03,     1.052307393803014e+03,     1.052722268176110e+03,     1.053136172857397e+03,     1.053549112866777e+03, 
            1.053961093184297e+03,     1.054372118750573e+03,     1.054782194467215e+03,     1.055191325197233e+03,     1.055599515765461e+03, 
            1.056006770958944e+03,     1.056413095527352e+03,     1.056818494183362e+03,     1.057222971603050e+03,     1.057626532426279e+03, 
            1.058029181257067e+03,     1.058430922663968e+03,     1.058831761180436e+03,     1.059231701305190e+03,     1.059630747502572e+03, 
            1.060028904202902e+03,     1.060426175802825e+03,     1.060822566665654e+03,     1.061218081121720e+03,     1.061612723468696e+03, 
            1.062006497971935e+03,     1.062399408864798e+03,     1.062791460348973e+03,     1.063182656594801e+03,     1.063573001741581e+03, 
            1.063962499897893e+03,     1.064351155141893e+03,     1.064738971521628e+03,     1.065125953055328e+03,     1.065512103731703e+03, 
            1.065897427510236e+03,     1.066281928321472e+03,     1.066665610067302e+03,     1.067048476621246e+03,     1.067430531828726e+03, 
            1.067811779507348e+03,     1.068192223447165e+03,     1.068571867410952e+03,     1.068950715134464e+03,     1.069328770326704e+03, 
            1.069706036670175e+03,     1.070082517821138e+03,     1.070458217409864e+03,     1.070833139040881e+03,     1.071207286293222e+03, 
            1.071580662720667e+03,     1.071953271851981e+03,     1.072325117191155e+03,     1.072696202217637e+03,     1.073066530386566e+03, 
            1.073436105128997e+03,     1.073804929852133e+03,     1.074173007939542e+03,     1.074540342751379e+03,     1.074906937624610e+03, 
            1.075272795873221e+03,     1.075637920788433e+03,     1.076002315638914e+03,     1.076365983670985e+03,     1.076728928108828e+03, 
            1.077091152154686e+03,     1.077452658989067e+03,     1.077813451770944e+03,     1.078173533637947e+03,     1.078532907706558e+03, 
            1.078891577072307e+03,     1.079249544809957e+03,     1.079606813973694e+03,     1.079963387597313e+03,     1.080319268694399e+03, 
            1.080674460258509e+03,     1.081028965263354e+03,     1.081382786662971e+03,     1.081735927391903e+03,     1.082088390365371e+03, 
            1.082440178479443e+03,     1.082791294611205e+03,     1.083141741618931e+03,     1.083491522342243e+03,     1.083840639602282e+03, 
            1.084189096201862e+03,     1.084536894925638e+03,     1.084884038540258e+03,     1.085230529794525e+03,     1.085576371419547e+03, 
            1.085921566128895e+03,     1.086266116618752e+03,     1.086610025568064e+03,     1.086953295638686e+03,     1.087295929475533e+03
    },
    {
            1.655368848010780e+00,     5.008891501119353e+00,     8.416758255191397e+00,     1.188112510735812e+01,     1.540428561513373e+01, 
            1.898868270616042e+01,     2.263692177548316e+01,     2.635178524661708e+01,     3.013624879331071e+01,     3.399349945785969e+01, 
            3.792695593780007e+01,     4.194029136061479e+01,     4.603745892222416e+01,     5.022272083286673e+01,     5.450068109610713e+01, 
            5.887632274661699e+01,     6.335505029440039e+01,     6.794273827297309e+01,     7.264578697380652e+01,     7.747118667848007e+01, 
            8.242659198540338e+01,     8.752040818654433e+01,     9.276189209826430e+01,     9.816127032454679e+01,     1.037298786557271e+02, 
            1.094803272398834e+02,     1.154266973656194e+02,     1.215847772532958e+02,     1.279723462831483e+02,     1.346095197506205e+02, 
            1.415191697594735e+02,     1.487274423920081e+02,     1.562643976949935e+02,     1.641648067029852e+02,     1.724691507502814e+02, 
            1.812248818903661e+02,     1.904880205945271e+02,     2.003251871171178e+02,     2.108161827814558e+02,     2.220572464461558e+02, 
            2.341650811105256e+02,     2.472816049301070e+02,     2.615789641954215e+02,     2.772633060310426e+02,     2.945735716521900e+02, 
            3.137677538592811e+02,     3.350851972104675e+02,     3.586738832622539e+02,     3.844723289433250e+02,     4.120293540191873e+02, 
            4.403346469601477e+02,     4.679862882051424e+02,     4.938539357791646e+02,     5.173553402945149e+02,     5.383102852790170e+02, 
            5.568500444160906e+02,     5.732574885098766e+02,     5.878510663579276e+02,     6.009248591842146e+02,     6.127280088181204e+02, 
            6.234638903538424e+02,     6.332964601738983e+02,     6.423578698752725e+02,     6.507552285300269e+02,     6.585760446827950e+02, 
            6.658924471571457e+02,     6.727644190400352e+02,     6.792422725113853e+02,     6.853685504302427e+02,     6.911794974812208e+02, 
            6.967062078297951e+02,     7.019755285353561e+02,     7.070107772624463e+02,     7.118323176014860e+02,     7.164580241986843e+02, 
            7.209036618058122e+02,     7.251831964604532e+02,     7.293090526818062e+02,     7.332923273725232e+02,     7.371429687363440e+02, 
            7.408699267298897e+02,     7.444812802053411e+02,     7.479843448554645e+02,     7.513857652625613e+02,     7.546915937197665e+02, 
            7.579073579941786e+02,     7.610381198052236e+02,     7.640885254750907e+02,     7.670628499535717e+02,     7.699650352138838e+02, 
            7.727987238488477e+02,     7.755672885603244e+02,     7.782738581229304e+02,     7.809213403109504e+02,     7.835124422012613e+02, 
            7.860496882019969e+02,     7.885354361041593e+02,     7.909718914095470e+02,     7.933611201516633e+02,     7.957050603954182e+02, 
            7.980055325754215e+02,     8.002642488107297e+02,     8.024828213152575e+02,     8.046627700072343e+02,     8.068055294076223e+02, 
            8.089124549058326e+02,     8.109848284612449e+02,     8.130238638004926e+02,     8.150307111632123e+02,     8.170064616425987e+02, 
            8.189521511616645e+02,     8.208687641213514e+02,     8.227572367525147e+02,     8.246184602002107e+02,     8.264532833655671e+02, 
            8.282625155277761e+02,     8.300469287663271e+02,     8.318072602014803e+02,     8.335442140691106e+02,     8.352584636444019e+02, 
            8.369506530274111e+02,     8.386213988022307e+02,     8.402712915803226e+02,     8.419008974375919e+02,     8.435107592538400e+02, 
            8.451013979624386e+02,     8.466733137316646e+02,     8.482269869970858e+02,     8.497628795713689e+02,     8.512814355390066e+02, 
            8.527830821672513e+02,     8.542682307482056e+02,     8.557372774152926e+02,     8.571906036464417e+02,     8.586285778767367e+02, 
            8.600515538048355e+02,     8.614598748875869e+02,     8.628538711107475e+02,     8.642338615410875e+02,     8.656001544088039e+02, 
            8.669530475799212e+02,     8.682928290790068e+02,     8.696197774290309e+02,     8.709341621282914e+02,     8.722362440232706e+02, 
            8.735262756775335e+02,     8.748045017212164e+02,     8.760711591823252e+02,     8.773264778009574e+02,     8.785706803274871e+02, 
            8.798039828056818e+02,     8.810265948416509e+02,     8.822387198594689e+02,     8.834405553442424e+02,     8.846322930733652e+02, 
            8.858141193366288e+02,     8.869862151458285e+02,     8.881487564344617e+02,     8.893019142598004e+02,     8.904458549362214e+02, 
            8.915807402825870e+02,     8.927067277365907e+02,     8.938239705256517e+02,     8.949326178176253e+02,     8.960328148648256e+02, 
            8.971247031416955e+02,     8.982084204764747e+02,     8.992841011771623e+02,     9.003518761520761e+02,     9.014118730252759e+02, 
            9.024642162471206e+02,     9.035090272001886e+02,     9.045464243008066e+02,     9.055765230963942e+02,     9.065994363588321e+02, 
            9.076152741740445e+02,     9.086241440279842e+02,     9.096261508891811e+02,     9.106213972880329e+02,     9.116099833929727e+02, 
            9.125920070836759e+02,     9.135675640214342e+02,     9.145367477168294e+02,     9.154996495948325e+02,     9.164563586893574e+02, 
            9.174069631465679e+02,     9.183515481607379e+02,     9.192901974177427e+02,     9.202229928085642e+02,     9.211500145199182e+02, 
            9.220713409326361e+02,     9.229870488925391e+02,     9.238972136115624e+02,     9.248019087482186e+02,     9.257012064508799e+02, 
            9.265951773995423e+02,     9.274838908461561e+02,     9.283674146535550e+02,     9.292458153330701e+02,     9.301191580808548e+02, 
            9.309875068129968e+02,     9.318509241994462e+02,     9.327094716968254e+02,     9.335632095801477e+02,     9.344121969735002e+02, 
            9.352564918797289e+02,     9.360961512091570e+02,     9.369312308073876e+02,     9.377617854822148e+02,     9.385878690296795e+02, 
            9.394095342593085e+02,     9.402268330185586e+02,     9.410398162165025e+02,     9.418485338467834e+02,     9.426530350098617e+02, 
            9.434533679345834e+02,     9.442495799990945e+02,     9.450417177511263e+02,     9.458298269276687e+02,     9.466139524740630e+02, 
            9.473941385625238e+02,     9.481704286101206e+02,     9.489428652962328e+02,     9.497114905794945e+02,     9.504763457142533e+02, 
            9.512374712665548e+02,     9.519949071296701e+02,     9.527486925391836e+02,     9.534988660876556e+02,     9.542454657388730e+02, 
            9.549885288417012e+02,     9.557280916886848e+02,     9.564641913295069e+02,     9.571968629113371e+02,     9.579261414543919e+02, 
            9.586520614277240e+02,     9.593746567609484e+02,     9.600939608556610e+02,     9.608100065965518e+02,     9.615228263622216e+02, 
            9.622324520357147e+02,     9.629389150147774e+02,     9.636422462218442e+02,     9.643424761137741e+02,     9.650396346913233e+02, 
            9.657337515083854e+02,     9.664248556809933e+02,     9.671129758960892e+02,     9.677981404200772e+02,     9.684803771071583e+02, 
            9.691597134074610e+02,     9.698361763749637e+02,     9.705097926752302e+02,     9.711805885929460e+02,     9.718485900392752e+02, 
            9.725138225590376e+02,     9.731763113377127e+02,     9.738360812082725e+02,     9.744931566578521e+02,     9.751475618342646e+02, 
            9.757993205523514e+02,     9.764484563001970e+02,     9.770949922451844e+02,     9.777389512399172e+02,     9.783803558279983e+02, 
            9.790192282496836e+02,     9.796555904473931e+02,     9.802894640711080e+02,     9.809208704836326e+02,     9.815498307657498e+02, 
            9.821763657212485e+02,     9.828004958818450e+02,     9.834222415119903e+02,     9.840416226135734e+02,     9.846586589305197e+02, 
            9.852733699532855e+02,     9.858857749232532e+02,     9.864958928370390e+02,     9.871037424506937e+02,     9.877093422838240e+02, 
            9.883127106236151e+02,     9.889138655287777e+02,     9.895128248334007e+02,     9.901096061507272e+02,     9.907042268768503e+02, 
            9.912967041943281e+02,     9.918870550757267e+02,     9.924752962870850e+02,     9.930614443913128e+02,     9.936455157515119e+02, 
            9.942275265342346e+02,     9.948074927126715e+02,     9.953854300697737e+02,     9.959613542013171e+02,     9.965352805188983e+02, 
            9.971072242528701e+02,     9.976772004552246e+02,     9.982452240024104e+02,     9.988113095980993e+02,     9.993754717758966e+02, 
            9.999377249019940e+02,     1.000498083177779e+03,     1.001056560642382e+03,     1.001613171175186e+03,     1.002167928498272e+03, 
            1.002720846178838e+03,     1.003271937631546e+03,     1.003821216120850e+03,     1.004368694763256e+03,     1.004914386529558e+03, 
            1.005458304247019e+03,     1.006000460601514e+03,     1.006540868139638e+03,     1.007079539270767e+03,     1.007616486269084e+03, 
            1.008151721275569e+03,     1.008685256299948e+03,     1.009217103222609e+03,     1.009747273796482e+03,     1.010275779648885e+03, 
            1.010802632283333e+03,     1.011327843081323e+03,     1.011851423304074e+03,     1.012373384094247e+03,     1.012893736477627e+03, 
            1.013412491364777e+03,     1.013929659552666e+03,     1.014445251726260e+03,     1.014959278460093e+03,     1.015471750219808e+03, 
            1.015982677363666e+03,     1.016492070144034e+03,     1.016999938708849e+03,     1.017506293103050e+03,     1.018011143269985e+03, 
            1.018514499052805e+03,     1.019016370195819e+03,     1.019516766345838e+03,     1.020015697053488e+03,     1.020513171774502e+03, 
            1.021009199870999e+03,     1.021503790612725e+03,     1.021996953178288e+03,     1.022488696656367e+03,     1.022979030046896e+03, 
            1.023467962262236e+03,     1.023955502128327e+03,     1.024441658385809e+03,     1.024926439691144e+03,     1.025409854617704e+03, 
            1.025891911656847e+03,     1.026372619218976e+03,     1.026851985634579e+03,     1.027330019155253e+03,     1.027806727954714e+03, 
            1.028282120129782e+03,     1.028756203701365e+03,     1.029228986615411e+03,     1.029700476743856e+03,     1.030170681885554e+03, 
            1.030639609767192e+03,     1.031107268044186e+03,     1.031573664301575e+03,     1.032038806054886e+03,     1.032502700750997e+03, 
            1.032965355768980e+03,     1.033426778420936e+03,     1.033886975952813e+03,     1.034345955545212e+03,     1.034803724314181e+03, 
            1.035260289312002e+03,     1.035715657527954e+03,     1.036169835889078e+03,     1.036622831260920e+03,     1.037074650448269e+03, 
            1.037525300195883e+03,     1.037974787189197e+03,     1.038423118055034e+03,     1.038870299362291e+03,     1.039316337622626e+03, 
            1.039761239291129e+03,     1.040205010766982e+03,     1.040647658394115e+03,     1.041089188461846e+03,     1.041529607205517e+03, 
            1.041968920807119e+03,     1.042407135395900e+03,     1.042844257048984e+03,     1.043280291791956e+03,     1.043715245599458e+03, 
            1.044149124395768e+03,     1.044581934055372e+03,     1.045013680403526e+03,     1.045444369216817e+03,     1.045874006223703e+03, 
            1.046302597105062e+03,     1.046730147494717e+03,     1.047156662979969e+03,     1.047582149102106e+03,     1.048006611356920e+03, 
            1.048430055195206e+03,     1.048852486023264e+03,     1.049273909203382e+03,     1.049694330054322e+03,     1.050113753851797e+03, 
            1.050532185828938e+03,     1.050949631176757e+03,     1.051366095044607e+03,     1.051781582540629e+03,     1.052196098732198e+03, 
            1.052609648646361e+03,     1.053022237270268e+03,     1.053433869551602e+03,     1.053844550398995e+03,     1.054254284682449e+03, 
            1.054663077233738e+03,     1.055070932846822e+03,     1.055477856278235e+03,     1.055883852247487e+03,     1.056288925437448e+03, 
            1.056693080494734e+03,     1.057096322030079e+03,     1.057498654618717e+03,     1.057900082800743e+03,     1.058300611081481e+03, 
            1.058700243931840e+03,     1.059098985788668e+03,     1.059496841055104e+03,     1.059893814100922e+03,     1.060289909262869e+03, 
            1.060685130845006e+03,     1.061079483119033e+03,     1.061472970324625e+03,     1.061865596669748e+03,     1.062257366330985e+03, 
            1.062648283453843e+03,     1.063038352153074e+03,     1.063427576512974e+03,     1.063815960587692e+03,     1.064203508401527e+03, 
            1.064590223949225e+03,     1.064976111196271e+03,     1.065361174079178e+03,     1.065745416505772e+03,     1.066128842355472e+03, 
            1.066511455479572e+03,     1.066893259701509e+03,     1.067274258817142e+03,     1.067654456595016e+03,     1.068033856776624e+03, 
            1.068412463076675e+03,     1.068790279183345e+03,     1.069167308758539e+03,     1.069543555438139e+03,     1.069919022832254e+03, 
            1.070293714525464e+03,     1.070667634077067e+03,     1.071040785021316e+03,     1.071413170867659e+03,     1.071784795100971e+03, 
            1.072155661181785e+03,     1.072525772546524e+03,     1.072895132607727e+03,     1.073263744754268e+03,     1.073631612351582e+03, 
            1.073998738741882e+03,     1.074365127244373e+03,     1.074730781155468e+03,     1.075095703748995e+03,     1.075459898276409e+03, 
            1.075823367966998e+03,     1.076186116028081e+03,     1.076548145645217e+03,     1.076909459982397e+03,     1.077270062182246e+03, 
            1.077629955366214e+03,     1.077989142634766e+03,     1.078347627067581e+03,     1.078705411723729e+03,     1.079062499641861e+03, 
            1.079418893840395e+03,     1.079774597317695e+03,     1.080129613052247e+03,     1.080483944002844e+03,     1.080837593108756e+03, 
            1.081190563289904e+03,     1.081542857447032e+03,     1.081894478461877e+03,     1.082245429197337e+03,     1.082595712497636e+03, 
            1.082945331188487e+03,     1.083294288077257e+03,     1.083642585953125e+03,     1.083990227587241e+03,     1.084337215732884e+03, 
            1.084683553125616e+03,     1.085029242483435e+03,     1.085374286506931e+03,     1.085718687879429e+03,     1.086062449267144e+03
    },
    {
            1.652224522517271e+00,     4.999124212385627e+00,     8.399902420428514e+00,     1.185667859906350e+01,     1.537170618045021e+01, 
            1.894738395413210e+01,     2.258626866991232e+01,     2.629108903168062e+01,     3.006476126651067e+01,     3.391040648976352e+01, 
            3.783137011982368e+01,     4.183124364008194e+01,     4.591388905718991e+01,     5.008346646656042e+01,     5.434446521085653e+01, 
            5.870173920785474e+01,     6.316054713438849e+01,     6.772659828802249e+01,     7.240610511387183e+01,     7.720584358862165e+01, 
            8.213322290755555e+01,     8.719636623748384e+01,     9.240420469351061e+01,     9.776658719951013e+01,     1.032944095226530e+02, 
            1.089997665788053e+02,     1.148961331355678e+02,     1.209985793648070e+02,     1.273240294084346e+02,     1.338915733424051e+02, 
            1.407228458304290e+02,     1.478424884402807e+02,     1.552787177667064e+02,     1.630640275246648e+02,     1.712360613729952e+02, 
            1.798387034447915e+02,     1.889234462529867e+02,     1.985511096702334e+02,     2.087939970412646e+02,     2.197385764665959e+02, 
            2.314887449506021e+02,     2.441696184325582e+02,     2.579314757204208e+02,     2.729527339352857e+02,     2.894392610648294e+02, 
            3.076146312793390e+02,     3.276929147348037e+02,     3.498253614627825e+02,     3.740152022474862e+02,     3.999918245559101e+02, 
            4.270614892364565e+02,     4.541043904320517e+02,     4.799468396459843e+02,     5.038588621058639e+02,     5.254917359440399e+02, 
            5.448176512602371e+02,     5.620132870715555e+02,     5.773417665689598e+02,     5.910766696488695e+02,     6.034654075841185e+02, 
            6.147176823625048e+02,     6.250061736851783e+02,     6.344716663394248e+02,     6.432289303561947e+02,     6.513719771453056e+02, 
            6.589783569218739e+02,     6.661125476290794e+02,     6.728285913103828e+02,     6.791721389828748e+02,     6.851820407265050e+02, 
            6.908915890198538e+02,     6.963294980204224e+02,     7.015206811623943e+02,     7.064868738321317e+02,     7.112471361571692e+02, 
            7.158182622439556e+02,     7.202151157755076e+02,     7.244509071380545e+02,     7.285374237331054e+02,     7.324852225136956e+02, 
            7.363037918173352e+02,     7.400016880781242e+02,     7.435866518604180e+02,     7.470657067761085e+02,     7.504452441613576e+02, 
            7.537310958493554e+02,     7.569285969482992e+02,     7.600426401928604e+02,     7.630777231634366e+02,     7.660379894462061e+02, 
            7.689272646271846e+02,     7.717490878666931e+02,     7.745067396803103e+02,     7.772032664532235e+02,     7.798415021330018e+02, 
            7.824240874777912e+02,     7.849534871803959e+02,     7.874320051413891e+02,     7.898617981248167e+02,     7.922448879967658e+02, 
            7.945831727190183e+02,     7.968784362462561e+02,     7.991323574552271e+02,     8.013465182171402e+02,     8.035224107100142e+02, 
            8.056614440552430e+02,     8.077649503519782e+02,     8.098341901737591e+02,     8.118703575839291e+02,     8.138745847195758e+02, 
            8.158479459878240e+02,     8.177914619132164e+02,     8.197061026704480e+02,     8.215927913328834e+02,     8.234524068638700e+02, 
            8.252857868749329e+02,     8.270937301723218e+02,     8.288769991111144e+02,     8.306363217740728e+02,     8.323723939906716e+02, 
            8.340858812101579e+02,     8.357774202411239e+02,     8.374476208688367e+02,     8.390970673604700e+02,     8.407263198816108e+02, 
            8.423359157461706e+02,     8.439263707255255e+02,     8.454981801287821e+02,     8.470518198846405e+02,     8.485877475395737e+02, 
            8.501064031928562e+02,     8.516082103742891e+02,     8.530935768913880e+02,     8.545628953784645e+02,     8.560165449152391e+02, 
            8.574548894794337e+02,     8.588782821394825e+02,     8.602870622560815e+02,     8.616815578216106e+02,     8.630620856008071e+02, 
            8.644289517002481e+02,     8.657824519520472e+02,     8.671228724317718e+02,     8.684504898697210e+02,     8.697655720558442e+02, 
            8.710683782230370e+02,     8.723591594101766e+02,     8.736381588061600e+02,     8.749056120761246e+02,     8.761617476709393e+02, 
            8.774067871209783e+02,     8.786409453151223e+02,     8.798644307658687e+02,     8.810774458613616e+02,     8.82