#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#
# Changes by rd :
#	- french description
#	- solution
#	- script id

if(description)
{
 script_id(10354);
 script_bugtraq_id(1610);
 script_cve_id("CVE-2000-0766");
 script_version ("$Revision: 8292 $");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "vqServer administrative port";
 
 script_name(name);
 
 desc = "
vqSoft's vqServer administrative port is open. Brute force guessing of the 
username/password is possible, and a bug in versions 1.9.9 and below 
allows configuration file retrieval remotely.

For more information, see:
http://www.securiteam.com/windowsntfocus/Some_Web_servers_are_still_vulnerable_to_the_dotdotdot_vulnerability.html

Solution: close this port for outside access.

Risk factor : Medium";



 script_description(desc);
 
 summary = "Detect vqServer's administrative port";
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2000 SecuriTeam");
 family = "General";
 script_family(family);
 
 script_require_ports("Services/vqServer-admin", 9090);
 script_dependencies("find_service.nes");
 exit(0);
}

#
# The script code starts here
#
include("http_func.inc");

port = get_kb_item("Services/vqServer-admin");
if(!port)port = 9090;
if (get_port_state(port))
{
 soctcp9090 = http_open_socket(port);

 if (soctcp9090)
 {
  sendata = http_get(item:"/", port:port);
  send(socket:soctcp9090, data:sendata);
  banner = http_recv(socket:soctcp9090);
  http_close_socket(soctcp9090);
  
  if (("Server: vqServer" >< banner) && ("WWW-Authenticate: Basic realm=/" >< banner))
  {
    resultrecv = strstr(banner, "Server: ");
    resultsub = strstr(resultrecv, string("\n"));
    resultrecv = resultrecv - resultsub;
    resultrecv = resultrecv - "Server: ";
    resultrecv = resultrecv - "\n";
   
    banner = string("vqServer version is : ");
    banner = banner + resultrecv;
    security_warning(port);
    security_warning(port:port, data:banner);
  }
 }
}

