##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_powerzip_detect.nasl 1151 2009-03-30 12:30:24Z mar $
#
# PowerZip Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900490);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("PowerZip Version Detection");
  desc = "
  Overview : This script finds the installed version of PowerZip and
  saves the version in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set Version of PowerZip in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Trident Software\PowerZip\";
if(!registry_key_exists(key:key)){
  exit(0);
}

# Method 1
zipName = registry_get_sz(key:key, item:"Name");
if("PowerZip" >< zipName)
{
  zipVer = registry_get_sz(key:key, item:"Version");
  if(zipVer != NULL)
  {
    set_kb_item(name:"PowerZip/Ver", value:zipVer);
    security_note(data:"PowerZip version " + zipVer +
                       " was detected on the host");
    exit(0);
  }
}

# Method 2
key2 = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key2))
{
  zipName = registry_get_sz(key:key2 + item, item:"DisplayName");
  if("PowerZip" >< zipName)
  {
    zipVer = registry_get_sz(key:key2 + item, item:"DisplayVersion");
    if(zipVer != NULL){
      set_kb_item(name:"PowerZip/Ver", value:zipVer);
      security_note(data:"PowerZip version " + zipVer +
                         " was detected on the host");
    }
    exit(0);
  }
}
