###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_nagios_csrf_n_bypass_vuln.nasl 462 2008-11-25 15:26:20Z nov $
#
# Nagios Cross-site Request Forgery (CSRF) and Authentication Bypass Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800068);
  script_version("$Revision: 7922 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-5027", "CVE-2008-5028");
  script_bugtraq_id(32156);
  script_name("Nagios Cross-site Request Forgery (CSRF) and Authentication Bypass Vulnerability");
  desc = "

  Overview: This host has Nagios installed and is prone to CSRF (Cross Site
  Request Forgery) and Authentication Bypass vulnerability.

  Vulnerability Insight:
  The flaw exists due to improper validation of user supplied inputs passed
  to custom form, browser addon and cmd.cgi script.

  Impact:
  Successful exploitation will allow attackers to execute certain commands
  with disable notification actions when a logged-in user visits a malicious
  web site.

  Impact Level: Application

  Affected Software/OS:
  Nagios 3.0.5 and prior on Linux.

  Fix: Upgrade to Nagios version 3.2.1 or later.
  For updates refer, http://www.nagios.org/

  *****
  NOTE : Nagios 3.0.5 is prone only to CSRF and not authentication bypass.
  *****

  References:
  http://secunia.com/advisories/32543
  http://secunia.com/advisories/32610

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Nagios");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Web application abuses");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

getPath = find_file(file_name:"nagios", file_path:"/", useregex:TRUE,
                    regexpar:"$", sock:sock);
foreach binaryFile (getPath)
{
  nsVer = get_bin_version(full_prog_name:chomp(binaryFile), version_argv:"-V",
                          ver_pattern:"Nagios ([0-9.]+)", sock:sock);
  if(nsVer[1] != NULL)
  {
    if(version_is_less_equal(version:nsVer[1], test_version:"3.0.5")){
      security_hole(0);
    }
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
