###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for xscreensaver FEDORA-2007-2721
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861077);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2007-2721");
  script_cve_id("CVE-2007-5585");
  script_name( "Fedora Update for xscreensaver FEDORA-2007-2721");
  desc = "

  Vulnerability Insight:
  A modular screen saver and locker for the X Window System.
  More than 200 display modes are included in this package.
  
  This is a metapackage for installing all default packages
  related to XScreenSaver.


  Affected Software/OS:
  xscreensaver on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00016.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of xscreensaver");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"xscreensaver", rpm:"xscreensaver~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver-gl-base", rpm:"xscreensaver-gl-base~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver-extras-gss", rpm:"xscreensaver-extras-gss~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver", rpm:"xscreensaver~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver-base", rpm:"xscreensaver-base~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver-gl-extras-gss", rpm:"xscreensaver-gl-extras-gss~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver-debuginfo", rpm:"xscreensaver-debuginfo~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver-gl-extras", rpm:"xscreensaver-gl-extras~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver-extras", rpm:"xscreensaver-extras~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver-gl-extras-gss", rpm:"xscreensaver-gl-extras-gss~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver-base", rpm:"xscreensaver-base~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver-extras-gss", rpm:"xscreensaver-extras-gss~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver-extras", rpm:"xscreensaver-extras~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver-gl-base", rpm:"xscreensaver-gl-base~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver-debuginfo", rpm:"xscreensaver-debuginfo~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver", rpm:"xscreensaver~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xscreensaver-gl-extras", rpm:"xscreensaver-gl-extras~5.03~14.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}