#
#VID 265c8b00-d2d0-11d8-b479-02e0185c0b53
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52434);
 script_cve_id("CVE-2004-0633", "CVE-2004-0634", "CVE-2004-0635");
 script_bugtraq_id(10672);
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: ethereal, ethereal-lite, tethereal, tethereal-lite";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   ethereal
   ethereal-lite
   tethereal
   tethereal-lite

CVE-2004-0633
The iSNS dissector for Ethereal 0.10.3 through 0.10.4 allows remote
attackers to cause a denial of service (process abort) via an integer
overflow.

CVE-2004-0634
The SMB SID snooping capability in Ethereal 0.9.15 to 0.10.4 allows
remote attackers to cause a denial of service (process crash) via a
handle without a policy name, which causes a null dereference.

CVE-2004-0635
The SNMP dissector in Ethereal 0.8.15 through 0.10.4 allows remote
attackers to cause a denial of service (process crash) via a (1)
malformed or (2) missing community string, which causes an
out-of-bounds read.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.ethereal.com/appnotes/enpa-sa-00015.html
http://secunia.com/advisories/12024
http://www.osvdb.org/7536
http://www.osvdb.org/7537
http://www.osvdb.org/7538
http://www.vuxml.org/freebsd/265c8b00-d2d0-11d8-b479-02e0185c0b53.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: ethereal, ethereal-lite, tethereal, tethereal-lite";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"ethereal");
if(!isnull(bver) && revcomp(a:bver, b:"0.10.5")<0) {
    security_note(0, data:"Package ethereal version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ethereal-lite");
if(!isnull(bver) && revcomp(a:bver, b:"0.10.5")<0) {
    security_note(0, data:"Package ethereal-lite version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"tethereal");
if(!isnull(bver) && revcomp(a:bver, b:"0.10.5")<0) {
    security_note(0, data:"Package tethereal version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"tethereal-lite");
if(!isnull(bver) && revcomp(a:bver, b:"0.10.5")<0) {
    security_note(0, data:"Package tethereal-lite version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
