##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/05/29
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import unittest
from parser import solaris


class SolarisParserTestCase(unittest.TestCase):

    ## Initial Setup
    solaris_parser_obj = solaris.Parser()

    def setUp(self):
        ptr = open('./test/unit_test/work/input/solaris_1-21-119725-06-1.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.solaris_parser_obj, 'Html_content', self.Html_content)


    def test_getCVE(self):
        print "\nTesting Solaris Parser Test Suite ..."
        req_out_put = 'CVE-2006-3738", "CVE-2006-4343", "CVE-2006-4339", "CVE-2006-2937", "CVE-2006-2940'

        out_put = self.solaris_parser_obj.getCVE()
        self.assertEquals(out_put, req_out_put)


    def test_getAdvID(self):
        req_out_put = '119725-06'

        out_put = self.solaris_parser_obj.getAdvID()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedPackage(self):
        req_out_put = 'Sun Java(TM) System LDAP Java Development Kit'

        out_put = self.solaris_parser_obj.getAffectedPackage()
        self.assertEquals(out_put, req_out_put)


    def test_getDescription(self):
        req_out_put = "The remote host is missing a patch containing a security fix,\n  which affects the following component(s): \n  Sun Java(TM) System LDAP Java Development Kit\n  For more information please visit the below reference link."

        pkg = 'Sun Java(TM) System LDAP Java Development Kit'
        out_put = self.solaris_parser_obj.getDescription(pkg)
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedProduct1(self):
        req_out_put = ['solaris_5.8_sparc', 'solaris_5.9_sparc', 'solaris_5.9_x86', 'solaris_5.10_sparc', 'solaris_5.10_x86']

        out_put = self.solaris_parser_obj.getAffectedProduct()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedProduct2(self):
        req_out_put = ['solaris_5.10_x86']
        ptr = open('./test/unit_test/work/input/solaris_1-21-118919-21-1.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.solaris_parser_obj, 'Html_content', self.Html_content)

        out_put = self.solaris_parser_obj.getAffectedProduct()
        self.assertEquals(out_put, req_out_put)


    def test_getPackages1(self):
        req_out_put = {'solaris_5.10_sparc': ['SUNWljdk', '119725-06'], 'solaris_5.8_sparc': ['SUNWljdk', '119725-06'], 'solaris_5.10_x86': ['SUNWljdk', '119725-06'], 'solaris_5.9_x86': ['SUNWljdk', '119725-06'], 'solaris_5.9_sparc': ['SUNWljdk', '119725-06']}

        setattr(self.solaris_parser_obj, 'html_cache', "./test/unit_test/work/input/Solaris/")
        prod_list = ['solaris_5.8_sparc', 'solaris_5.9_sparc', 'solaris_5.9_x86', 'solaris_5.10_sparc', 'solaris_5.10_x86']
        patch_id = '119725-06' 
        out_put = self.solaris_parser_obj.getPackages(prod_list, patch_id)
        self.assertEquals(out_put, req_out_put)


    def test_getPackages2(self):
        req_out_put = {}

        ptr = open('./test/unit_test/work/input/glsa-200703-23.html', 'r')
        lines = ptr.readlines()
        ptr.close
        self.Html_content = "".join(lines)

        setattr(self.solaris_parser_obj, 'html_cache', "./test/unit_test/work/input/Solaris/")
        prod_list = ['solaris_5.10_x86']
        patch_id = '118919-21' 
        setattr(self.solaris_parser_obj, 'Html_content', self.Html_content)

        out_put = self.solaris_parser_obj.getPackages(prod_list, patch_id)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference1(self):
        req_out_put = 'http://sunsolve.sun.com/search/document.do?assetkey=1-21-119725-06-1'

        main_url = 'http://sunsolve.sun.com/'
        file_name = 'solaris_1-21-119725-06-1.html'
        out_put = self.solaris_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference2(self):
        req_out_put = 'http://sunsolve.sun.com/search/document.do?assetkey=1-21-118919-21-1'

        main_url = 'http://sunsolve.sun.com'
        file_name = 'solaris_1-21-118919-21-1.html'
        out_put = self.solaris_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_parser(self):
        req_out_put = True

        setattr(self.solaris_parser_obj, 'html_cache', "./test/unit_test/work/input/Solaris/")
        out_put = self.solaris_parser_obj.parser(self.Html_content)
        self.assertEquals(out_put, req_out_put)


    def test_getAdvIds(self):
        req_out_put = ['118855-36', '118919-21', '119255-65', '119549-13', '119725-06', '119758-14', '119784-10', '119811-05', '119904-02', '120012-14', '120273-25', '120293-02', '120330-02', '120413-09', '120415-23', '120544-14', '120720-02', '120740-05', '120831-06', '121013-02', '121096-02', '121212-02', '121309-16', '121395-03', '121454-02', '122213-32', '122676-02', '122912-15', '123006-07', '123591-10', '124944-01', '124998-01', '125280-05', '125333-05', '125540-06', '125542-04', '125732-04', '126207-04', '126441-01', '126869-03', '127128-11', '128329-01', '128412-01', '136883-02', '136999-05', '137001-03', '137005-04', '137033-01', '137081-01', '137094-01', '137138-09', '137872-02', '138105-01', '138266-01', '138270-02', '138323-02', '138362-01', '138374-02', '138877-01', '139100-02', '139463-02', '139556-08', '140084-01', '140102-01', '140106-01', '140119-06', '140130-06', '140392-02', '140400-01', '140560-01', '140564-01', '141015-01']

        ptr = open('./test/unit_test/work/input/solaris_main_advisory_10_x86.html', 'r')
        lines = ptr.readlines()
        ptr.close

        data = "".join(lines)
        out_put = self.solaris_parser_obj._getAdvIds(data)
        self.assertEquals(out_put, req_out_put)


if __name__ == '__main__':
    unittest.main()

