//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir Common
 *
 *  Copyright 2005-2017 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTCOMMON_HXX
#define OPENTURNS_OTCOMMON_HXX

#include "openturns/AtomicFunctions.hxx"
//#include "BinaryStorageManager.hxx"
#include "openturns/Catalog.hxx"
#include "openturns/ComparisonOperator.hxx"
#include "openturns/ComparisonOperatorImplementation.hxx"
#include "openturns/Equal.hxx"
#include "openturns/Exception.hxx"
#include "openturns/Greater.hxx"
#include "openturns/GreaterOrEqual.hxx"
#include "openturns/IdFactory.hxx"
#include "openturns/InterfaceObject.hxx"
#include "openturns/Less.hxx"
#include "openturns/LessOrEqual.hxx"
#include "openturns/Lockable.hxx"
#include "openturns/Log.hxx"
#include "openturns/Memory.hxx"
#include "openturns/Os.hxx"
#include "openturns/OSS.hxx"
#include "openturns/Object.hxx"
#include "openturns/Path.hxx"
#include "openturns/PersistentObject.hxx"
#include "openturns/PersistentObjectFactory.hxx"
#include "openturns/PlatformInfo.hxx"
#include "openturns/Pointer.hxx"
#include "openturns/ResourceMap.hxx"
#include "openturns/SharedPointer.hxx"
#include "openturns/StorageManager.hxx"
#include "openturns/Study.hxx"
#include "openturns/TypedCollectionInterfaceObject.hxx"
#include "openturns/TypedInterfaceObject.hxx"
#include "openturns/OTconfig.hxx"
#ifdef OPENTURNS_HAVE_LIBXML2
#include "openturns/XMLStorageManager.hxx"
#include "openturns/XMLchar_traits.hxx"
#endif

#endif /* OPENTURNS_OTCOMMON_HXX */
