/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENRIJN_BRUSH_WRAP_P_H_
#define _OPENRIJN_BRUSH_WRAP_P_H_

#include <GTLCore/wrappers/StructWrap.h>
#include <OpenRijn/Export.h>
#include <GTLFragment/wrappers/ColorWrap_p.h>

struct CanvasWrap;

namespace OpenRijn {
  class AbstractBrush;
}

//---------------------- WARNING ----------------------//
// Whenever the following structure is edited,         //
// it's llvm declaration must be changed too in        //
// Wrapper::createBrushType !                          //
//---------------------- WARNING ----------------------//
struct BrushWrap {
  STRUCT_HEADER
  OpenRijn::AbstractBrush* brush;
  ColorWrap paintColor;
};

BrushWrap* wrapBrush(OpenRijn::AbstractBrush* brush);

extern "C" {
OPENRIJN_EXPORT void brush_wrap_draw_point(BrushWrap* brush, CanvasWrap* canvas, float x, float y, float t1, float angle);
OPENRIJN_EXPORT void brush_wrap_draw_line(BrushWrap* brush, CanvasWrap* canvas, float x1, float y1, float t1, float x2, float y2, float t2);
OPENRIJN_EXPORT void brush_wrap_draw_line_to(BrushWrap* brush, CanvasWrap* canvas, float x2, float y2, float t2);
}

#endif
