/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_TRANSFORM_H_
#define _GTLCORE_TRANSFORM_H_

#include <GTLCore/Export.h>

namespace GTLCore {
  class RegionF;
  /**
   * @ingroup GTLCore
   * This class describes a 2D transformation for pixels.
   */
  class GTLCORE_EXPORT Transform {
    public:
      /**
       * Construct an empty transformation
       */
      Transform();
      Transform(const Transform& _transform);
      Transform& operator=(const Transform& _transform);
      ~Transform();
    public:
      /**
       * Perform a rotation anti-clock wise.
       */
      void rotate(double _angle);
      /**
       * Perform a translation
       */
      void translate(double _dx, double _dy);
      /**
       * Scale the transformation
       */
      void scale(double sx, double sy);
      /**
       * Shear the transformation
       */
      void shear(double sh, double sv);
      /**
       * Invert this transformation
       */
      Transform invert() const;
    public:
      /**
       * Apply the transformation on the coordinate ( @p x, @p y ) and store the
       * result in ( @p x_o, @p y_o )
       */
      void map(double x, double y, double& x_o, double& y_o) const;
      /**
       * Apply the transformation on the coordinate ( @p x, @p y ) and store the
       * result in ( @p x_o, @p y_o )
       */
      void map(float x, float y, float& x_o, float& y_o) const;
      /**
       * Transform a region
       */
      RegionF map(const RegionF& region) const;
    public:
      const Transform& operator*=(const Transform &m);
      Transform operator*(const Transform &m) const;
    private:
      struct Private;
      Private* const d;
  };
}

#endif
