/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi.test;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.util.NSProperty;
import java.io.File;
import java.util.Hashtable;

public class PerfTestPut {
    public static void main(String[] args) {
        File file;
        if (args.length < 4) {
            System.err.println("Usage: PerfTestPut filenamebase url username password [-addprops numProp]");
            System.exit(-1);
        }
        String propContent = "12345678901234567890123456789012345678901234567890123456789012345678901234567890";
        String filenameBase = args[0];
        String mHostStr = args[1];
        String username = args[2];
        String passwd = args[3];
        int numprops = 0;
        Hashtable<NSProperty, String> props = null;
        if (args.length == 6) {
            numprops = Integer.parseInt(args[5]);
            props = new Hashtable<NSProperty, String>();
            for (int i = 0; i < numprops; ++i) {
                String propName = "prop" + i;
                NSProperty nsp = new NSProperty("cmcs", propName);
                props.put(nsp, propContent);
            }
        }
        if (!(file = new File(filenameBase)).exists()) {
            System.err.println(file.toString() + " not found");
            System.exit(-1);
        }
        long total = 0L;
        long minDur = 0L;
        long maxDur = 0L;
        try {
            DSI dsi = new DSI(mHostStr, username, passwd);
            for (int i = 0; i < 100; ++i) {
                String filename = filenameBase + i + ".txt";
                long start = System.currentTimeMillis();
                dsi.setURL(mHostStr + "/" + filename);
                dsi.putDataSet(file);
                if (numprops > 0) {
                    dsi.putMetaData(props);
                }
                long end = System.currentTimeMillis();
                long duration = end - start;
                System.out.println("file " + filename + " time: " + duration + "ms");
                total += duration;
                if (i == 0) {
                    minDur = duration;
                    maxDur = duration;
                    continue;
                }
                if (duration < minDur) {
                    minDur = duration;
                }
                if (duration <= maxDur) continue;
                maxDur = duration;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        System.out.println("PutDataset time with " + numprops + " properties");
        System.out.println("Total time: " + total + " ms");
        System.out.println("Average time: " + total / 100L + " ms");
        System.out.println("Minimum time: " + minDur + " ms");
        System.out.println("Maximum time: " + maxDur + " ms");
        System.exit(0);
    }
}

