/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2010 Sun Microsystems, Inc.
 */

package org.netbeans.modules.web.common.api;

import java.awt.Color;
import org.netbeans.modules.csl.api.test.CslTestBase;
import org.openide.filesystems.FileObject;

/**
 *
 * @author marekfukala
 */
public class WebUtilsTest extends CslTestBase {

    public WebUtilsTest(String testName) {
        super(testName);
    }

    public void toHexColorCode() {
        assertEquals("#ff0000", WebUtils.toHexCode(Color.RED));
        assertEquals("#2201aa", WebUtils.toHexCode(Color.decode("#2201aa")));
    }

    public void testResolve() {
        FileObject one = getTestFile("one.txt");
        assertNotNull(one);
        FileObject two = getTestFile("third.txt");
        assertNotNull(two);

        FileObject resolved = WebUtils.resolve(one, "third.txt");
        assertNotNull(resolved);
        assertEquals(two, resolved);

    }

    public void testResolveFolderReferences() {
        FileObject one = getTestFile("one.txt");
        assertNotNull(one);
        FileObject two = getTestFile("folder/second.txt");
        assertNotNull(two);

        //test resolve path reference
        FileObject resolved = WebUtils.resolve(one, "folder/second.txt");
        assertNotNull(resolved);
        assertEquals(two, resolved);

        //test resolve path reference backward
        resolved = WebUtils.resolve(two, "../one.txt");
        assertNotNull(resolved);
        assertEquals(one, resolved);

    }

    public void testResolveInvalidLinks() {
        FileObject one = getTestFile("one.txt");
        assertNotNull(one);
        FileObject two = getTestFile("folder/second.txt");
        assertNotNull(two);

        //test resolve invalid path reference
        FileReference resolved = WebUtils.resolveToReference(one, "xyz");
        assertNull(resolved);
        
        resolved = WebUtils.resolveToReference(one, "");
        assertNull(resolved);

    }

    public void testGetRelativePathFolderWithDot() {
        FileObject one = getTestFile("one.txt");
        assertNotNull(one);
        FileObject two = getTestFile("folder/inner.folder/fourth.txt");
        assertNotNull(two);
        assertEquals("folder/inner.folder/fourth.txt", WebUtils.getRelativePath(one, two));
    }

    public void test182423() {
        FileObject one = getTestFile("one.txt");
        assertNotNull(one);

        FileReference resolved = WebUtils.resolveToReference(one, "/css/common.css");
        assertNull(resolved);

    }

}