/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.web.webkit.debugging.api;

/**
 * Thrown when there's an error while submitting a breakpoint.
 * 
 * @author Martin Entlicher
 * @since 1.28
 */
public class BreakpointException extends Exception {
    
    /**
     * Creates a new {@code BreakpointException} with the specified error message.
     * 
     * @param message message with the error details.
     */
    public BreakpointException(String message) {
        super(message);
    }

}
