/* $Id: Name_std.cpp 508532 2016-07-28 17:21:31Z bollin $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'general.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/general/Name_std.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CName_std::~CName_std(void)
{
}


const CName_std::TSuffixes& CName_std::GetStandardSuffixes(void)
{
    static const char* sfxs[] = { "2nd", "3rd", "4th", "5th", "6th", "II", "III", "IV", "Jr.", "Sr.", "V", "VI"};
    DEFINE_STATIC_ARRAY_MAP_WITH_COPY(TSuffixes, suffixes, sfxs);

    return suffixes;
}


bool CName_std::ExtractSuffixFromLastName()
{
    if ((IsSetSuffix() && !NStr::IsBlank(GetSuffix()))
        || !IsSetLast()) {
        // bail if already have non-empty suffix or if no last name
        return false;
    }
    string& last = SetLast();
    size_t pos = NStr::Find(last, " ");
    if (pos == string::npos) {
        return false;
    }
    size_t npos = NStr::Find(last, " ", pos + 1);
    while (npos != string::npos) {
        pos = npos;
        npos = NStr::Find(last, " ", pos + 1);
    }

    string suffix = last.substr(pos + 1);
    if (NStr::Equal(suffix, "Jr.") ||
        NStr::Equal(suffix, "Jr") ||
        NStr::Equal(suffix, "Sr.") ||
        NStr::Equal(suffix, "Sr") ||
        NStr::Equal(suffix, "II") ||
        NStr::Equal(suffix, "III") ||
        NStr::Equal(suffix, "IV")) {
        SetSuffix(suffix);
        FixSuffix(SetSuffix());
        last = last.substr(0, pos);
        return true;
    }
    return false;
}


void CName_std::FixSuffix(string& suffix)
{
    // remove spaces
    NStr::ReplaceInPlace(suffix, " ", "");

    if (!suffix.empty()) {
        // remove any period, if any, on the end
        if (NStr::EndsWith(suffix, ".")) {
            suffix.resize(suffix.length() - 1);
        }

        if (NStr::EqualNocase(suffix, "1d")) {
            suffix = "1st";
        } else if (NStr::EqualNocase(suffix, "2d")) {
            suffix = "2nd";
        } else if (NStr::EqualNocase(suffix, "3d")) {
            suffix = "3rd";
        } else if (NStr::EqualNocase(suffix, "Sr")) {
            suffix = "Sr.";
        } else if (NStr::EqualNocase(suffix, "Jr")) {
            suffix = "Jr.";
        }
    }
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 65, chars: 1888, CRC32: daed53d2 */
