C
C  This file is part of MUMPS 5.7.3, released
C  on Mon Jul 15 11:44:21 UTC 2024
C
C
C  Copyright 1991-2024 CERFACS, CNRS, ENS Lyon, INP Toulouse, Inria,
C  Mumps Technologies, University of Bordeaux.
C
C  This version of MUMPS is provided to you free of charge. It is
C  released under the CeCILL-C license 
C  (see doc/CeCILL-C_V1-en.txt, doc/CeCILL-C_V1-fr.txt, and
C  https://cecill.info/licences/Licence_CeCILL-C_V1-en.html)
C
      MODULE DMUMPS_LR_DATA_M
      USE DMUMPS_LR_TYPE
      IMPLICIT NONE
      PRIVATE
      PUBLIC :: DMUMPS_BLR_END_FRONT, DMUMPS_BLR_INIT_MODULE,
     &  DMUMPS_BLR_END_MODULE, DMUMPS_BLR_INIT_FRONT, 
     &  DMUMPS_BLR_SAVE_INIT,
     &  DMUMPS_BLR_SAVE_PANEL_LORU, DMUMPS_BLR_RETRIEVE_BEGS_BLR_L,
     &  DMUMPS_BLR_SAVE_BEGS_BLR_C, DMUMPS_BLR_RETRIEVE_BEGS_BLR_C,
     &  DMUMPS_BLR_DEC_AND_RETRIEVE_L, DMUMPS_BLR_RETRIEVE_PANEL_LORU,
     &  DMUMPS_BLR_DEC_AND_TRYFREE_L, DMUMPS_BLR_TRY_FREE_PANEL, 
     &  DMUMPS_BLR_FREE_CB_LRB, DMUMPS_BLR_FREE_ALL_PANELS,
     &  DMUMPS_BLR_SAVE_CB_LRB,
     &  DMUMPS_BLR_RETRIEVE_CB_LRB, DMUMPS_BLR_RETRIEVE_BEGSBLR_STA,
     &  DMUMPS_BLR_SAVE_BEGS_BLR_DYN, DMUMPS_BLR_RETRIEVE_BEGSBLR_DYN,
     &  DMUMPS_BLR_RETRIEVE_NB_PANELS, DMUMPS_BLR_EMPTY_PANEL_LORU,
     &  DMUMPS_BLR_SAVE_NFS4FATHER, DMUMPS_BLR_RETRIEVE_NFS4FATHER,
     &  DMUMPS_BLR_SAVE_M_ARRAY, DMUMPS_BLR_RETRIEVE_M_ARRAY,
     &  DMUMPS_BLR_FREE_M_ARRAY
     &  , DMUMPS_BLR_STRUC_TO_MOD, DMUMPS_BLR_MOD_TO_STRUC, BLR_ARRAY
#if defined(MUMPS_NOF2003)
     &  , BLR_STRUC_T, blr_panel_type, diag_block_type
#endif
     &  , DMUMPS_BLR_SAVE_DIAG_BLOCK, DMUMPS_BLR_RETRIEVE_DIAG_BLOCK
#if ! defined(NO_SAVE_RESTORE)
     &  , DMUMPS_SAVE_RESTORE_BLR
#endif      
      TYPE blr_panel_type
         integer                 :: NB_ACCESSES_LEFT
         type(LRB_TYPE), pointer :: LRB_PANEL(:)
      END TYPE blr_panel_type
      TYPE diag_block_type
        DOUBLE PRECISION, POINTER :: DIAG_BLOCK(:)
      END TYPE diag_block_type
      TYPE BLR_STRUC_T
         LOGICAL   :: IsSYM, IsT2, IsSLAVE
         TYPE(blr_panel_type), DIMENSION (:), POINTER  :: PANELS_L 
         TYPE(blr_panel_type), DIMENSION (:), POINTER  :: PANELS_U
         TYPE(LRB_TYPE), pointer :: CB_LRB(:,:)
         TYPE(diag_block_type), DIMENSION (:), POINTER :: DIAG_BLOCKS
         INTEGER, DIMENSION(:), POINTER :: BEGS_BLR_STATIC
         INTEGER, DIMENSION(:), POINTER :: BEGS_BLR_DYNAMIC 
         INTEGER, DIMENSION(:), POINTER :: BEGS_BLR_L
         INTEGER, DIMENSION(:), POINTER :: BEGS_BLR_COL
         INTEGER :: NB_ACCESSES_INIT 
         INTEGER :: NB_PANELS 
         INTEGER   :: NFS4FATHER
         DOUBLE PRECISION,  DIMENSION(:), POINTER :: M_ARRAY
      END TYPE BLR_STRUC_T
      type(BLR_STRUC_T), POINTER, DIMENSION(:), SAVE :: BLR_ARRAY
      TYPE BLR_ARRAY_T
        type(BLR_STRUC_T), POINTER, DIMENSION(:) :: BLR_ARRAY
      END TYPE BLR_ARRAY_T
      INTEGER BLR_ARRAY_FREE, PANELS_NOTUSED, PANELS_FREED,
     &        NB_PANELS_NOTINIT, NFS4FATHER_NOTINIT
      PARAMETER (BLR_ARRAY_FREE=-9999, 
     &           PANELS_NOTUSED=-1111, PANELS_FREED=-2222, 
     &           NB_PANELS_NOTINIT=-3333, 
     &           NFS4FATHER_NOTINIT=-4444 )
#if ! defined(NO_SAVE_RESTORE)
      INCLUDE 'mumps_save_restore_modes.h'
#endif
      CONTAINS
      SUBROUTINE DMUMPS_BLR_INIT_MODULE(INITIAL_SIZE, INFO)
       INTEGER, INTENT(IN) :: INITIAL_SIZE
       INTEGER, INTENT(INOUT) :: INFO(2)
       INTEGER :: I, IERR
       ALLOCATE(BLR_ARRAY( INITIAL_SIZE ), stat=IERR)
       IF (IERR > 0 ) THEN
         INFO(1)=-13
         INFO(2)=INITIAL_SIZE
         RETURN
       ENDIF
       DO I=1, INITIAL_SIZE
         NULLIFY(BLR_ARRAY(I)%PANELS_L)
         NULLIFY(BLR_ARRAY(I)%PANELS_U)
         NULLIFY(BLR_ARRAY(I)%CB_LRB)
         NULLIFY(BLR_ARRAY(I)%DIAG_BLOCKS)
         NULLIFY(BLR_ARRAY(I)%BEGS_BLR_STATIC)
         NULLIFY(BLR_ARRAY(I)%BEGS_BLR_DYNAMIC)
         BLR_ARRAY(I)%NB_ACCESSES_INIT = BLR_ARRAY_FREE
         BLR_ARRAY(I)%NB_PANELS        = NB_PANELS_NOTINIT
         NULLIFY(BLR_ARRAY(I)%BEGS_BLR_L)
         NULLIFY(BLR_ARRAY(I)%BEGS_BLR_COL)
         BLR_ARRAY(I)%NFS4FATHER       = NFS4FATHER_NOTINIT
         NULLIFY(BLR_ARRAY(I)%M_ARRAY)
       ENDDO
       RETURN
       END SUBROUTINE DMUMPS_BLR_INIT_MODULE
       SUBROUTINE DMUMPS_BLR_END_MODULE(INFO1, KEEP8, K34
     &             , LRSOLVE_ACT_OPT
     &            )
       INTEGER, INTENT(IN) :: INFO1, K34
       LOGICAL, OPTIONAL, INTENT(IN) :: LRSOLVE_ACT_OPT
       INTEGER(8) :: KEEP8(150)
       INTEGER :: I, ILOOP
       IF (.NOT. associated(BLR_ARRAY)) THEN
         WRITE(*,*) "Internal error 1 in DMUMPS_BLR_END_MODULE"
         CALL MUMPS_ABORT()
       ENDIF
       DO I=1, size(BLR_ARRAY)
         ILOOP= I
         IF (associated(BLR_ARRAY(I)%PANELS_L).OR.
     &       associated(BLR_ARRAY(I)%PANELS_U).OR.
     &       associated(BLR_ARRAY(I)%CB_LRB).OR.
     &       associated(BLR_ARRAY(I)%DIAG_BLOCKS)
     &      ) THEN
           IF (present(LRSOLVE_ACT_OPT)) THEN
             CALL DMUMPS_BLR_END_FRONT(ILOOP, INFO1, KEEP8, K34
     &                              , LRSOLVE_ACT_OPT
     &                              )
           ELSE
             CALL DMUMPS_BLR_END_FRONT(ILOOP, INFO1, KEEP8, K34 )
           ENDIF
         ENDIF
       ENDDO
       DEALLOCATE(BLR_ARRAY)
       NULLIFY(BLR_ARRAY)
       RETURN
       END SUBROUTINE DMUMPS_BLR_END_MODULE
       SUBROUTINE DMUMPS_BLR_MOD_TO_STRUC(id_BLRARRAY_ENCODING)
#      if defined(MUMPS_NOF2003)
       CHARACTER, DIMENSION(:), POINTER :: id_BLRARRAY_ENCODING
#      else
       CHARACTER, DIMENSION(:), POINTER, intent(inout) ::
     &                                            id_BLRARRAY_ENCODING
#      endif
       CHARACTER :: CHAR_ARRAY(1)
       INTEGER :: CHAR_LENGTH, IERR
       TYPE(BLR_ARRAY_T) :: BLR_ARRAY_VAR
       IF (associated(id_BLRARRAY_ENCODING)) THEN
         WRITE(*,*) "Internal error 1 in MUMPS_BLR_MOD_TO_STRUC"
         CALL MUMPS_ABORT()
       ENDIF
       BLR_ARRAY_VAR%BLR_ARRAY => BLR_ARRAY
       CHAR_LENGTH=size(transfer(BLR_ARRAY_VAR,CHAR_ARRAY))
       ALLOCATE(id_BLRARRAY_ENCODING(CHAR_LENGTH), stat=IERR)
       IF (IERR > 0 ) THEN
          WRITE(*,*) "Allocation error in MUMPS_BLR_MOD_TO_STRUC"
          CALL MUMPS_ABORT()
       ENDIF
       id_BLRARRAY_ENCODING=transfer(BLR_ARRAY_VAR,CHAR_ARRAY)
       NULLIFY(BLR_ARRAY)
       RETURN
       END SUBROUTINE DMUMPS_BLR_MOD_TO_STRUC
       SUBROUTINE DMUMPS_BLR_STRUC_TO_MOD(id_BLRARRAY_ENCODING)
#      if defined(MUMPS_NOF2003)
       CHARACTER, DIMENSION(:), POINTER :: id_BLRARRAY_ENCODING
#      else
       CHARACTER, DIMENSION(:), POINTER, intent(inout) ::
     &                                            id_BLRARRAY_ENCODING
#      endif
       TYPE (BLR_ARRAY_T) :: BLR_ARRAY_VAR
       IF (.NOT.associated(id_BLRARRAY_ENCODING)) THEN
         WRITE(*,*) "Internal error 1 in DMUMPS_BLR_STRUC_TO_MOD"
       ENDIF
       BLR_ARRAY_VAR = transfer(id_BLRARRAY_ENCODING,BLR_ARRAY_VAR)
       BLR_ARRAY => BLR_ARRAY_VAR%BLR_ARRAY
       DEALLOCATE(id_BLRARRAY_ENCODING)
       NULLIFY(id_BLRARRAY_ENCODING)
       RETURN
       END SUBROUTINE DMUMPS_BLR_STRUC_TO_MOD
       SUBROUTINE DMUMPS_BLR_INIT_FRONT(IWHANDLER, 
     &                       INFO, MTK405)
       USE MUMPS_FRONT_DATA_MGT_M, ONLY : MUMPS_FDM_START_IDX
!$    USE OMP_LIB
       INTEGER, INTENT(INOUT) :: IWHANDLER, INFO(2)
       INTEGER, INTENT(IN), OPTIONAL    :: MTK405
       TYPE(BLR_STRUC_T), POINTER, DIMENSION(:) :: BLR_ARRAY_TMP
       INTEGER :: OLD_SIZE, NEW_SIZE
       INTEGER :: I
       INTEGER :: IERR
       LOGICAL :: NEEDS_THREAD_SAFETY
       NEEDS_THREAD_SAFETY = .FALSE.
       IF (present(MTK405)) THEN
         IF (MTK405 .EQ. 1 ) THEN
           NEEDS_THREAD_SAFETY = .TRUE.
         ENDIF
       ENDIF
       IF ( NEEDS_THREAD_SAFETY ) THEN
!$OMP CRITICAL(critical_blr_idx)
         CALL MUMPS_FDM_START_IDX('F', 'INITF', IWHANDLER, INFO)
!$OMP END CRITICAL(critical_blr_idx)
       ELSE
         CALL MUMPS_FDM_START_IDX('F', 'INITF', IWHANDLER, INFO)
       ENDIF
       IF (IWHANDLER > size(BLR_ARRAY)) THEN
         OLD_SIZE = size(BLR_ARRAY)
         NEW_SIZE = max( (OLD_SIZE * 3) / 2 + 1, IWHANDLER)
         ALLOCATE(BLR_ARRAY_TMP(NEW_SIZE),stat=IERR)
         IF (IERR.GT.0) THEN
           INFO(1)=-13
           INFO(2)=NEW_SIZE
           GOTO 500
         ENDIF
         DO I=1, OLD_SIZE
           BLR_ARRAY_TMP(I)=BLR_ARRAY(I)
         ENDDO
         DO I=OLD_SIZE+1, NEW_SIZE
           NULLIFY(BLR_ARRAY_TMP(I)%PANELS_L)
           NULLIFY(BLR_ARRAY_TMP(I)%PANELS_U)
           NULLIFY(BLR_ARRAY_TMP(I)%CB_LRB)
           NULLIFY(BLR_ARRAY_TMP(I)%DIAG_BLOCKS)
           NULLIFY(BLR_ARRAY_TMP(I)%BEGS_BLR_STATIC)
           NULLIFY(BLR_ARRAY_TMP(I)%BEGS_BLR_DYNAMIC)
           BLR_ARRAY_TMP(I)%NB_ACCESSES_INIT = BLR_ARRAY_FREE
           BLR_ARRAY_TMP(I)%NB_PANELS        = NB_PANELS_NOTINIT
           NULLIFY(BLR_ARRAY_TMP(I)%BEGS_BLR_L)
           NULLIFY(BLR_ARRAY_TMP(I)%BEGS_BLR_COL)
           BLR_ARRAY_TMP(I)%NFS4FATHER       = NFS4FATHER_NOTINIT
           NULLIFY(BLR_ARRAY_TMP(I)%M_ARRAY)
         ENDDO
         DEALLOCATE(BLR_ARRAY)
         BLR_ARRAY => BLR_ARRAY_TMP
         NULLIFY(BLR_ARRAY_TMP)
  500   CONTINUE
       ENDIF
       RETURN
       END SUBROUTINE DMUMPS_BLR_INIT_FRONT
       SUBROUTINE DMUMPS_BLR_SAVE_INIT(IWHANDLER, 
     &                       IsSYM, IsT2, IsSLAVE, 
     &                       NB_PANELS,
     &                       BEGS_BLR_L, BEGS_BLR_COL, 
     &                       NB_ACCESSES_INIT, INFO)
       LOGICAL, INTENT(IN) :: IsSYM, IsT2, IsSLAVE
       INTEGER, INTENT(IN) :: NB_PANELS, IWHANDLER
       INTEGER, INTENT(INOUT) :: INFO(2)
       INTEGER, INTENT(IN) :: NB_ACCESSES_INIT 
       INTEGER, INTENT(IN), DIMENSION(:) :: BEGS_BLR_L
       INTEGER,  DIMENSION(:), POINTER :: BEGS_BLR_COL
       INTEGER :: I
       INTEGER :: IERR
       IF (NB_PANELS.EQ.0) THEN
        WRITE(6,*) " Internal error 1 in DMUMPS_BLR_SAVE_INIT ", 
     &    NB_PANELS
       ENDIF
       IF (IWHANDLER .LE.0 ) THEN
        WRITE(6,*) " Internal error 2 in DMUMPS_BLR_SAVE_INIT ", 
     &     IWHANDLER
       ENDIF
       IF (associated(BEGS_BLR_COL)) THEN
         ALLOCATE(
     &         BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL(size(BEGS_BLR_COL)),
     &         stat=IERR)
         IF (IERR .GT. 0) THEN
           INFO(1)=-13
           INFO(2)=size(BEGS_BLR_COL)
           RETURN
         ENDIF
       ENDIF
       IF (NB_ACCESSES_INIT.EQ.0) THEN
        NULLIFY(BLR_ARRAY(IWHANDLER)%PANELS_L)
        NULLIFY(BLR_ARRAY(IWHANDLER)%PANELS_U)
        NULLIFY(BLR_ARRAY(IWHANDLER)%CB_LRB)
        NULLIFY(BLR_ARRAY(IWHANDLER)%DIAG_BLOCKS)
        ALLOCATE(
     &         BLR_ARRAY(IWHANDLER)%BEGS_BLR_L(size(BEGS_BLR_L)),
     &         BLR_ARRAY(IWHANDLER)%BEGS_BLR_STATIC(size(BEGS_BLR_L)),
     &         BLR_ARRAY(IWHANDLER)%BEGS_BLR_DYNAMIC(size(BEGS_BLR_L)),
     &         stat=IERR)
        IF (IERR .GT. 0) THEN
           INFO(1)=-13
           INFO(2)=3*size(BEGS_BLR_L)
           RETURN
        ENDIF
       ELSE
        IF (IsSYM) THEN
         ALLOCATE(BLR_ARRAY(IWHANDLER)%PANELS_L(NB_PANELS),
     &          BLR_ARRAY(IWHANDLER)%BEGS_BLR_L(size(BEGS_BLR_L)),
     &          BLR_ARRAY(IWHANDLER)%BEGS_BLR_STATIC(size(BEGS_BLR_L)),
     &          BLR_ARRAY(IWHANDLER)%BEGS_BLR_DYNAMIC(size(BEGS_BLR_L)),
     &          stat=IERR)
        ELSE 
         ALLOCATE(BLR_ARRAY(IWHANDLER)%PANELS_L(NB_PANELS),
     &          BLR_ARRAY(IWHANDLER)%PANELS_U(NB_PANELS),
     &          BLR_ARRAY(IWHANDLER)%BEGS_BLR_STATIC(size(BEGS_BLR_L)),
     &          BLR_ARRAY(IWHANDLER)%BEGS_BLR_DYNAMIC(size(BEGS_BLR_L)),
     &          BLR_ARRAY(IWHANDLER)%BEGS_BLR_L(size(BEGS_BLR_L)),
     &          stat=IERR)
        ENDIF
        IF (IERR .GT. 0) THEN
           INFO(1)=-13
           IF (IsSYM) THEN
              INFO(2)=NB_PANELS+3*size(BEGS_BLR_L)
           ELSE
              INFO(2)=NB_PANELS+NB_PANELS+3*size(BEGS_BLR_L)
           ENDIF
           RETURN
        ENDIF
        IF (.NOT.IsSLAVE) THEN
          ALLOCATE(BLR_ARRAY(IWHANDLER)%DIAG_BLOCKS(NB_PANELS),
     &          stat=IERR)
          IF (IERR .GT. 0) THEN
            INFO(1)=-13
            INFO(2)=NB_PANELS
            RETURN
          ENDIF
        ENDIF
        DO I=1,NB_PANELS
           NULLIFY(BLR_ARRAY(IWHANDLER)%PANELS_L(I)%LRB_PANEL)
           IF (.NOT.IsSYM) THEN
             NULLIFY(BLR_ARRAY(IWHANDLER)%PANELS_U(I)%LRB_PANEL)
           ENDIF
           IF (.NOT.IsSLAVE) THEN
             NULLIFY(BLR_ARRAY(IWHANDLER)%DIAG_BLOCKS(I)%DIAG_BLOCK)
           ENDIF
        ENDDO
       ENDIF
       BLR_ARRAY(IWHANDLER)%IsSYM        = IsSYM
       BLR_ARRAY(IWHANDLER)%IsT2         = IsT2
       BLR_ARRAY(IWHANDLER)%IsSLAVE      = IsSLAVE
       BLR_ARRAY(IWHANDLER)%NB_PANELS    = NB_PANELS
       BLR_ARRAY(IWHANDLER)%BEGS_BLR_L   = BEGS_BLR_L
       BLR_ARRAY(IWHANDLER)%BEGS_BLR_STATIC   = BEGS_BLR_L
       BLR_ARRAY(IWHANDLER)%BEGS_BLR_DYNAMIC   = -999991
       IF (NB_ACCESSES_INIT.EQ.0) THEN
         BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT = PANELS_NOTUSED
       ELSE
         BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT = NB_ACCESSES_INIT
       ENDIF
       IF (associated(BEGS_BLR_COL)) THEN
          DO I=1,size(BEGS_BLR_COL)
             BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL(I) = BEGS_BLR_COL(I)
          ENDDO
       ELSE
         NULLIFY( BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL )
       ENDIF
       RETURN
       END SUBROUTINE DMUMPS_BLR_SAVE_INIT
       SUBROUTINE DMUMPS_BLR_END_FRONT(IWHANDLER, INFO1, KEEP8, K34
     &             , LRSOLVE_ACT_OPT, MTK405 )
       USE MUMPS_FRONT_DATA_MGT_M, ONLY : MUMPS_FDM_END_IDX
       INTEGER, INTENT(INOUT) :: IWHANDLER
       INTEGER, INTENT(IN) :: INFO1
       INTEGER(8) :: KEEP8(150)
       INTEGER, INTENT(IN) :: K34
       LOGICAL, OPTIONAL, INTENT(IN) :: LRSOLVE_ACT_OPT
       INTEGER, OPTIONAL, INTENT(IN) :: MTK405
       INTEGER :: IPANEL, JPANEL
       INTEGER(8) :: MEM_FREED
       INTEGER :: IDUMMY, JDUMMY
       TYPE(blr_panel_type), POINTER  :: THEPANEL
       LOGICAL :: LRSOLVE_ACT, NEEDS_THREAD_SAFETY
       TYPE(diag_block_type), POINTER  :: THEBLOCK
       LRSOLVE_ACT = .FALSE.
       IF (present(LRSOLVE_ACT_OPT)) LRSOLVE_ACT = LRSOLVE_ACT_OPT
       IF (IWHANDLER.LE.0) THEN 
        RETURN
       ENDIF
       NEEDS_THREAD_SAFETY = .FALSE.
       IF (present(MTK405)) THEN
         IF (MTK405 .EQ. 1 ) THEN
           NEEDS_THREAD_SAFETY = .TRUE.
         ENDIF
       ENDIF
       IF (IWHANDLER .GT. size(BLR_ARRAY)) THEN
        RETURN
       END IF
       IF (BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT.EQ.BLR_ARRAY_FREE)
     &      RETURN  
       IF (BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT.NE.
     &      PANELS_NOTUSED) THEN
        DO IPANEL = 1, size(BLR_ARRAY(IWHANDLER)%PANELS_L)
           THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)
           IF (associated(THEPANEL%LRB_PANEL)) THEN
             IF (INFO1 .GE. 0 
     &            .AND..NOT.LRSOLVE_ACT
     &           ) THEN
               WRITE(*,*) " Internal Error 2a in MUMPS_BLR_END_FRONT ",
     &          IWHANDLER, "NB_ACCESSES_INIT=", 
     &          BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT, 
     &          "Pointer to panel number ",IPANEL," still associated",
     &          "NB_ACCESSES_LEFT= ",THEPANEL%NB_ACCESSES_LEFT
               CALL MUMPS_ABORT()
             ELSE
               CALL DEALLOC_BLR_PANEL(THEPANEL%LRB_PANEL,
     &          size(THEPANEL%LRB_PANEL), KEEP8, K34)
               THEPANEL%NB_ACCESSES_LEFT = PANELS_FREED
             ENDIF
             DEALLOCATE(THEPANEL%LRB_PANEL)
             NULLIFY(THEPANEL%LRB_PANEL)
           ENDIF
        ENDDO
        IF (associated(BLR_ARRAY(IWHANDLER)%PANELS_L)) THEN
         DEALLOCATE(BLR_ARRAY(IWHANDLER)%PANELS_L)
         NULLIFY(BLR_ARRAY(IWHANDLER)%PANELS_L)
        ENDIF
        IF (.NOT.BLR_ARRAY(IWHANDLER)%IsSYM) THEN
         DO IPANEL = 1, size(BLR_ARRAY(IWHANDLER)%PANELS_U)
           THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_U(IPANEL)
           IF (associated(THEPANEL%LRB_PANEL)) THEN
             IF (INFO1 .GE. 0 
     &            .AND..NOT.LRSOLVE_ACT
     &          ) THEN
             WRITE(*,*) " Internal Error 2b in MUMPS_BLR_END_FRONT ",
     &          IWHANDLER, "NB_ACCESSES_INIT=", 
     &          BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT, 
     &          "Pointer to panel number ",IPANEL," still associated"
             CALL MUMPS_ABORT()
             ELSE
               CALL DEALLOC_BLR_PANEL(THEPANEL%LRB_PANEL,
     &          size(THEPANEL%LRB_PANEL), KEEP8, K34)
               THEPANEL%NB_ACCESSES_LEFT = PANELS_FREED 
             ENDIF
             DEALLOCATE(THEPANEL%LRB_PANEL)
             NULLIFY(THEPANEL%LRB_PANEL)
           ENDIF
         ENDDO
         IF (associated(BLR_ARRAY(IWHANDLER)%PANELS_U)) THEN
          DEALLOCATE(BLR_ARRAY(IWHANDLER)%PANELS_U)
          NULLIFY(BLR_ARRAY(IWHANDLER)%PANELS_U)
         ENDIF
        ENDIF   
        IF (.NOT.BLR_ARRAY(IWHANDLER)%IsSLAVE) THEN
          MEM_FREED = 0_8
          DO IPANEL = 1, size(BLR_ARRAY(IWHANDLER)%DIAG_BLOCKS)
            THEBLOCK => BLR_ARRAY(IWHANDLER)%DIAG_BLOCKS(IPANEL)
            IF (associated(THEBLOCK%DIAG_BLOCK)) THEN
              IF (INFO1 .GE. 0 
     &             .AND..NOT.LRSOLVE_ACT
     &           ) THEN
              WRITE(*,*) " Internal Error 3 in MUMPS_BLR_END_FRONT ",
     &           IWHANDLER, "NB_ACCESSES_INIT=", 
     &           BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT, 
     &           "Pointer to panel number ",IPANEL," still associated"
              CALL MUMPS_ABORT()
              ELSE
                MEM_FREED = MEM_FREED + int(size(THEBLOCK%DIAG_BLOCK),8)
                DEALLOCATE    (THEBLOCK%DIAG_BLOCK)
                NULLIFY       (THEBLOCK%DIAG_BLOCK)
              ENDIF
            ENDIF
          ENDDO
          IF ( MEM_FREED .GT. 0_8 ) THEN
            CALL MUMPS_DM_FAC_UPD_DYN_MEMCNTS(-MEM_FREED,
     &        NEEDS_THREAD_SAFETY, KEEP8, 
     &        IDUMMY, JDUMMY,  
     &        .TRUE., .TRUE.)
          ENDIF
          IF (associated(BLR_ARRAY(IWHANDLER)%DIAG_BLOCKS)) THEN
            DEALLOCATE(BLR_ARRAY(IWHANDLER)%DIAG_BLOCKS)
            NULLIFY(BLR_ARRAY(IWHANDLER)%DIAG_BLOCKS)
          ENDIF
        ENDIF   
        IF (.NOT.BLR_ARRAY(IWHANDLER)%IsT2.OR.
     &           BLR_ARRAY(IWHANDLER)%IsSLAVE) THEN
          IF (associated(BLR_ARRAY(IWHANDLER)%CB_LRB)) THEN
             IF (INFO1 .GE. 0) THEN
             WRITE(*,*) " Internal Error 4 in MUMPS_BLR_END_FRONT ",
     &          IWHANDLER, "CB block still associated", 
     &          BLR_ARRAY(IWHANDLER)%IsT2,
     &          BLR_ARRAY(IWHANDLER)%IsSLAVE
             CALL MUMPS_ABORT()
            ELSE
              DO IPANEL = 1, size(BLR_ARRAY(IWHANDLER)%CB_LRB,1)
              DO JPANEL = 1, size(BLR_ARRAY(IWHANDLER)%CB_LRB,2)
                CALL DEALLOC_LRB(
     &                 BLR_ARRAY(IWHANDLER)%CB_LRB(IPANEL,JPANEL),
     &                 KEEP8, K34)
              ENDDO
              ENDDO
              DEALLOCATE(BLR_ARRAY(IWHANDLER)%CB_LRB)
              NULLIFY(BLR_ARRAY(IWHANDLER)%CB_LRB)
            ENDIF
          ENDIF
        ENDIF   
       ENDIF  
       IF (associated(BLR_ARRAY(IWHANDLER)%BEGS_BLR_STATIC)) THEN
         DEALLOCATE(BLR_ARRAY(IWHANDLER)%BEGS_BLR_STATIC)
         NULLIFY(BLR_ARRAY(IWHANDLER)%BEGS_BLR_STATIC)
       ENDIF
       IF (associated(BLR_ARRAY(IWHANDLER)%BEGS_BLR_DYNAMIC)) THEN
         DEALLOCATE(BLR_ARRAY(IWHANDLER)%BEGS_BLR_DYNAMIC)
         NULLIFY(BLR_ARRAY(IWHANDLER)%BEGS_BLR_DYNAMIC)
       ENDIF
       IF (associated(BLR_ARRAY(IWHANDLER)%BEGS_BLR_L)) THEN
         DEALLOCATE(BLR_ARRAY(IWHANDLER)%BEGS_BLR_L)
         NULLIFY(BLR_ARRAY(IWHANDLER)%BEGS_BLR_L)
       ENDIF
       IF (associated(BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL)) THEN
          DEALLOCATE(BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL)
          NULLIFY(BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL)
       ENDIF
       BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT = BLR_ARRAY_FREE
       BLR_ARRAY(IWHANDLER)%NB_PANELS        = NB_PANELS_NOTINIT
       BLR_ARRAY(IWHANDLER)%NFS4FATHER       = NFS4FATHER_NOTINIT
       IF (associated(BLR_ARRAY(IWHANDLER)%M_ARRAY)) THEN
          DEALLOCATE(BLR_ARRAY(IWHANDLER)%M_ARRAY)
          NULLIFY(BLR_ARRAY(IWHANDLER)%M_ARRAY)
       ENDIF
       IF (NEEDS_THREAD_SAFETY) THEN
!$OMP    CRITICAL(critical_blr_idx)
         CALL MUMPS_FDM_END_IDX('F', 'ENDF', IWHANDLER)
!$OMP    END CRITICAL(critical_blr_idx)
       ELSE
         CALL MUMPS_FDM_END_IDX('F', 'ENDF', IWHANDLER)
       ENDIF
       RETURN
       END SUBROUTINE DMUMPS_BLR_END_FRONT
       SUBROUTINE DMUMPS_BLR_SAVE_PANEL_LORU (
     &    IWHANDLER, LORU, IPANEL, LRB_PANEL )
       type(LRB_TYPE), DIMENSION(:), pointer  :: LRB_PANEL
       INTEGER, INTENT(IN) :: IWHANDLER, IPANEL
       INTEGER, INTENT(IN) :: LORU
       TYPE(blr_panel_type), POINTER  :: THEPANEL
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) "Internal error 1 in DMUMPS_BLR_SAVE_PANEL_LORU"
         CALL MUMPS_ABORT()
       ENDIF
       IF (LORU.EQ.0) THEN
         THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)
       ELSE 
         THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_U(IPANEL)
       ENDIF
       THEPANEL%NB_ACCESSES_LEFT = 
     &           BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT
       THEPANEL%LRB_PANEL => LRB_PANEL
       RETURN
       END SUBROUTINE DMUMPS_BLR_SAVE_PANEL_LORU
       SUBROUTINE DMUMPS_BLR_SAVE_CB_LRB (
     &    IWHANDLER, CB_LRB )
#if defined(MUMPS_NOF2003)
       TYPE(LRB_TYPE), POINTER :: CB_LRB(:,:)
#else       
       TYPE(LRB_TYPE), POINTER, INTENT(IN) :: CB_LRB(:,:)
#endif       
       INTEGER, INTENT(IN) :: IWHANDLER
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) "Internal error 1 in DMUMPS_BLR_SAVE_CB_LRB"
         CALL MUMPS_ABORT()
       ENDIF
       BLR_ARRAY(IWHANDLER)%CB_LRB => CB_LRB
       RETURN
       END SUBROUTINE DMUMPS_BLR_SAVE_CB_LRB
       SUBROUTINE DMUMPS_BLR_SAVE_DIAG_BLOCK (
     &    IWHANDLER, IPANEL, D )
       DOUBLE PRECISION,POINTER :: D(:)
       INTEGER, INTENT(IN) :: IWHANDLER, IPANEL
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) "Internal error 1 in DMUMPS_BLR_SAVE_DIAG_BLOCK"
         CALL MUMPS_ABORT()
       ENDIF
       IF ( BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT.LT.0) THEN
         WRITE(*,*) "Internal error 2 in DMUMPS_BLR_SAVE_DIAG_BLOCK"
         CALL MUMPS_ABORT()
       ENDIF
       BLR_ARRAY(IWHANDLER)%DIAG_BLOCKS(IPANEL)%DIAG_BLOCK => D
       RETURN
       END SUBROUTINE DMUMPS_BLR_SAVE_DIAG_BLOCK
       SUBROUTINE DMUMPS_BLR_SAVE_BEGS_BLR_C (
     &    IWHANDLER, BEGS_BLR_COL, INFO)
       INTEGER, DIMENSION(:), POINTER :: BEGS_BLR_COL
       INTEGER, INTENT(IN) :: IWHANDLER
       INTEGER, INTENT(INOUT) :: INFO(2)
       INTEGER :: I, IERR
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
          WRITE(*,*) "Internal error 1 in DMUMPS_BLR_SAVE_BEGS_BLR_C"
          CALL MUMPS_ABORT()
       ENDIF
       IF ( BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT.LT.0) THEN
          WRITE(*,*) "Internal error 2 in DMUMPS_BLR_SAVE_BEGS_BLR_C"
          CALL MUMPS_ABORT()
       ENDIF
       ALLOCATE(BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL(size(BEGS_BLR_COL)),
     &          stat=IERR)
       IF (IERR > 0 ) THEN
         INFO(1)=-13
         INFO(2)=size(BEGS_BLR_COL)
         RETURN
       ENDIF
       DO I=1,size(BEGS_BLR_COL)
          BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL(I) = BEGS_BLR_COL(I)
       ENDDO
       RETURN
       END SUBROUTINE DMUMPS_BLR_SAVE_BEGS_BLR_C
       SUBROUTINE DMUMPS_BLR_SAVE_BEGS_BLR_DYN (
     &    IWHANDLER, BEGS_BLR_DYNAMIC )
       INTEGER, DIMENSION(:), POINTER :: BEGS_BLR_DYNAMIC
       INTEGER, INTENT(IN) :: IWHANDLER
       INTEGER :: I
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
          WRITE(*,*) "Internal error 1 in DMUMPS_BLR_SAVE_BEGS_BLR_DYN"
          CALL MUMPS_ABORT()
       ENDIF
       IF ( BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT.LT.0) THEN
          WRITE(*,*) "Internal error 2 in DMUMPS_BLR_SAVE_BEGS_BLR_DYN"
          CALL MUMPS_ABORT()
       ENDIF
       DO I=1,size(BEGS_BLR_DYNAMIC)
          BLR_ARRAY(IWHANDLER)%BEGS_BLR_DYNAMIC(I) = BEGS_BLR_DYNAMIC(I)
       ENDDO
       RETURN
       END SUBROUTINE DMUMPS_BLR_SAVE_BEGS_BLR_DYN
       SUBROUTINE DMUMPS_BLR_RETRIEVE_BEGS_BLR_L 
     &            ( IWHANDLER, BEGS_BLR_L )
       INTEGER, INTENT(IN) :: IWHANDLER
#if defined(MUMPS_NOF2003)
       INTEGER, POINTER, DIMENSION(:) :: BEGS_BLR_L
#else
       INTEGER, POINTER, DIMENSION(:), INTENT(OUT) :: BEGS_BLR_L
#endif
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) 
     &       "Internal error 1 in DMUMPS_BLR_RETRIEVE_BEGS_BLR_L"
         CALL MUMPS_ABORT()
       ENDIF
       BEGS_BLR_L => BLR_ARRAY(IWHANDLER)%BEGS_BLR_L
       RETURN
       END SUBROUTINE DMUMPS_BLR_RETRIEVE_BEGS_BLR_L
       SUBROUTINE DMUMPS_BLR_RETRIEVE_BEGSBLR_STA
     &            ( IWHANDLER, BEGS_BLR_STATIC )
       INTEGER, INTENT(IN) :: IWHANDLER
#if defined(MUMPS_NOF2003)
       INTEGER, POINTER, DIMENSION(:) :: BEGS_BLR_STATIC
#else
       INTEGER, POINTER, DIMENSION(:), INTENT(OUT) :: BEGS_BLR_STATIC
#endif
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) 
     &       "Internal error 1 in DMUMPS_BLR_RETRIEVE_BEGSBLR_STA"
         CALL MUMPS_ABORT()
       ENDIF
       BEGS_BLR_STATIC => BLR_ARRAY(IWHANDLER)%BEGS_BLR_STATIC
       RETURN
       END SUBROUTINE DMUMPS_BLR_RETRIEVE_BEGSBLR_STA
       SUBROUTINE DMUMPS_BLR_RETRIEVE_BEGSBLR_DYN
     &            ( IWHANDLER, BEGS_BLR_DYNAMIC )
       INTEGER, INTENT(IN) :: IWHANDLER
#if defined(MUMPS_NOF2003)
       INTEGER, POINTER, DIMENSION(:) :: BEGS_BLR_DYNAMIC
#else
       INTEGER, POINTER, DIMENSION(:), INTENT(OUT) :: BEGS_BLR_DYNAMIC
#endif
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) 
     &       "Internal error 1 in DMUMPS_BLR_RETRIEVE_BEGSBLR_DYN"
         CALL MUMPS_ABORT()
       ENDIF
       BEGS_BLR_DYNAMIC => BLR_ARRAY(IWHANDLER)%BEGS_BLR_DYNAMIC
       RETURN
       END SUBROUTINE DMUMPS_BLR_RETRIEVE_BEGSBLR_DYN
       SUBROUTINE DMUMPS_BLR_RETRIEVE_BEGS_BLR_C
     &            ( IWHANDLER, BEGS_BLR_COL, NB_PANELS )
       INTEGER, INTENT(IN)  :: IWHANDLER
       INTEGER, INTENT(OUT) :: NB_PANELS
#if defined(MUMPS_NOF2003)
       INTEGER, POINTER, DIMENSION(:) :: BEGS_BLR_COL
#else
       INTEGER, POINTER, DIMENSION(:), INTENT(OUT) :: BEGS_BLR_COL
#endif
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) 
     &   "Internal error 1 in  DMUMPS_BLR_RETRIEVE_BEGS_BLR_C"
         CALL MUMPS_ABORT()
       ENDIF
       BEGS_BLR_COL => BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL
       NB_PANELS     = BLR_ARRAY(IWHANDLER)%NB_PANELS
       RETURN
       END SUBROUTINE DMUMPS_BLR_RETRIEVE_BEGS_BLR_C
       SUBROUTINE DMUMPS_BLR_RETRIEVE_NB_PANELS
     &            ( IWHANDLER, NB_PANELS )
       INTEGER, INTENT(IN)  :: IWHANDLER
       INTEGER, INTENT(OUT) :: NB_PANELS
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) 
     &       "Internal error 1 in DMUMPS_BLR_RETRIEVE_NB_PANELS"
         CALL MUMPS_ABORT()
       ENDIF
       NB_PANELS = BLR_ARRAY(IWHANDLER)%NB_PANELS
       RETURN
       END SUBROUTINE DMUMPS_BLR_RETRIEVE_NB_PANELS
       SUBROUTINE DMUMPS_BLR_DEC_AND_RETRIEVE_L(IWHANDLER, IPANEL,
     &                                      BEGS_BLR_L, THELRBPANEL)
       INTEGER, INTENT(IN) :: IWHANDLER
       INTEGER, INTENT(IN) :: IPANEL
#if defined(MUMPS_NOF2003)
       INTEGER, POINTER, DIMENSION(:) :: BEGS_BLR_L
       TYPE(LRB_TYPE), POINTER, DIMENSION(:) :: THELRBPANEL
#else
       INTEGER, POINTER, DIMENSION(:), INTENT(OUT) :: BEGS_BLR_L
       TYPE(LRB_TYPE), INTENT(OUT), DIMENSION(:), POINTER :: THELRBPANEL
#endif
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) "Internal error 1 in DMUMPS_BLR_DEC_AND_RETRIEVE_L",
     &    "IPANEL=", IPANEL
         CALL MUMPS_ABORT()
       ENDIF
       IF ( .NOT. associated(BLR_ARRAY(IWHANDLER)%PANELS_L)) THEN
         WRITE(*,*) "Internal error 2 in DMUMPS_BLR_DEC_AND_RETRIEVE_L",
     &    "IPANEL=", IPANEL
         CALL MUMPS_ABORT()
       ENDIF
       IF ( .NOT.
     & associated(BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%LRB_PANEL) )
     &      THEN
         WRITE(*,*) "Internal error 3 in DMUMPS_BLR_DEC_AND_RETRIEVE_L",
     &    "IPANEL=", IPANEL
         CALL MUMPS_ABORT()
       ENDIF
       CALL DMUMPS_BLR_RETRIEVE_BEGS_BLR_L( IWHANDLER, BEGS_BLR_L )
       THELRBPANEL =>
     &        BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%LRB_PANEL
       BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%NB_ACCESSES_LEFT = 
     & BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%NB_ACCESSES_LEFT - 1
       RETURN
       END SUBROUTINE DMUMPS_BLR_DEC_AND_RETRIEVE_L
       LOGICAL FUNCTION DMUMPS_BLR_EMPTY_PANEL_LORU
     & (IWHANDLER, LorU, IPANEL)
       INTEGER, INTENT(IN) :: LorU, IPANEL, IWHANDLER
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) 
     &    "Internal error 1 in DMUMPS_BLR_EMPTY_PANEL_LORU, ",
     &    "IWHANDLER=", IWHANDLER
         CALL MUMPS_ABORT()
       ENDIF
       IF (LorU.EQ.0) THEN
         IF ( .NOT. associated(BLR_ARRAY(IWHANDLER)%PANELS_L)) THEN
           WRITE(*,*) 
     &     "Internal error 2 in DMUMPS_BLR_EMPTY_PANEL_LORU, ",
     &     "IWHANDLER=", IWHANDLER
           CALL MUMPS_ABORT()
         ENDIF
         DMUMPS_BLR_EMPTY_PANEL_LORU = .NOT.
     &   associated(BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%LRB_PANEL)
       ELSE
         IF ( .NOT. associated(BLR_ARRAY(IWHANDLER)%PANELS_U)) THEN
           WRITE(*,*) 
     &     "Internal error 3 in DMUMPS_BLR_EMPTY_PANEL_LORU, ",
     &     "IWHANDLER=", IWHANDLER
           CALL MUMPS_ABORT()
         ENDIF
         DMUMPS_BLR_EMPTY_PANEL_LORU = .NOT.
     &   associated(BLR_ARRAY(IWHANDLER)%PANELS_U(IPANEL)%LRB_PANEL)
       ENDIF
       RETURN
       END FUNCTION DMUMPS_BLR_EMPTY_PANEL_LORU
       SUBROUTINE DMUMPS_BLR_RETRIEVE_PANEL_LORU
     &                          (IWHANDLER, LORU, IPANEL,
     &                           THELRBPANEL)
       INTEGER, INTENT(IN) :: IWHANDLER
       INTEGER, INTENT(IN) :: LORU 
       INTEGER, INTENT(IN) :: IPANEL
#if defined(MUMPS_NOF2003)
       TYPE(LRB_TYPE), POINTER, DIMENSION(:) :: THELRBPANEL
#else
       TYPE(LRB_TYPE), INTENT(OUT), DIMENSION(:), POINTER :: THELRBPANEL
#endif
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) 
     &    "Internal error 1 in DMUMPS_BLR_RETRIEVE_PANEL_LORU",
     &    "IWHANDLER=", IWHANDLER
         CALL MUMPS_ABORT()
       ENDIF
       IF (LORU.EQ.0) THEN
          IF ( .NOT. associated(BLR_ARRAY(IWHANDLER)%PANELS_L)) THEN
         WRITE(*,*) 
     &    "Internal error 2 in DMUMPS_BLR_RETRIEVE_PANEL_LORU",
     &    " IWHANDLER=", IWHANDLER
         CALL MUMPS_ABORT()
        ENDIF
        IF ( .NOT.
     &  associated(BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%LRB_PANEL) )
     &       THEN
         WRITE(*,*) 
     &    "Internal error 3 in DMUMPS_BLR_RETRIEVE_PANEL_LORU",
     &    " IPANEL=", IPANEL
         CALL MUMPS_ABORT()
        ENDIF
        THELRBPANEL =>
     &        BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%LRB_PANEL
       ELSE
          IF ( .NOT. associated(BLR_ARRAY(IWHANDLER)%PANELS_U)) THEN
         WRITE(*,*) 
     &    "Internal error 4 in DMUMPS_BLR_RETRIEVE_PANEL_LORU",
     &    " IWHANDLER=", IWHANDLER
         CALL MUMPS_ABORT()
        ENDIF
        IF ( .NOT.
     &  associated(BLR_ARRAY(IWHANDLER)%PANELS_U(IPANEL)%LRB_PANEL) )
     &       THEN
         WRITE(*,*) 
     &    "Internal error 5 in DMUMPS_BLR_RETRIEVE_PANEL_LORU",
     &    " IPANEL=", IPANEL
         CALL MUMPS_ABORT()
        ENDIF
        THELRBPANEL =>
     &        BLR_ARRAY(IWHANDLER)%PANELS_U(IPANEL)%LRB_PANEL
       ENDIF
       RETURN
       END SUBROUTINE DMUMPS_BLR_RETRIEVE_PANEL_LORU
       SUBROUTINE DMUMPS_BLR_RETRIEVE_DIAG_BLOCK
     &                          (IWHANDLER, IPANEL,
     &                           THEBLOCK)
       INTEGER, INTENT(IN) :: IWHANDLER
       INTEGER, INTENT(IN) :: IPANEL
#if defined(MUMPS_NOF2003)
       DOUBLE PRECISION, POINTER :: THEBLOCK(:)
#else
       DOUBLE PRECISION, POINTER, INTENT(OUT) :: THEBLOCK(:)
#endif
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) 
     &    "Internal error 1 in DMUMPS_BLR_RETRIEVE_DIAG_BLOCK",
     &    "IPANEL=", IPANEL
         CALL MUMPS_ABORT()
       ENDIF
       IF ( .NOT. associated(BLR_ARRAY(IWHANDLER)%DIAG_BLOCKS)) THEN
         WRITE(*,*) 
     &    "Internal error 2 in DMUMPS_BLR_RETRIEVE_DIAG_BLOCK",
     &    "IPANEL=", IPANEL
         CALL MUMPS_ABORT()
       ENDIF
       IF ( .NOT.
     & associated(BLR_ARRAY(IWHANDLER)%DIAG_BLOCKS(IPANEL)%DIAG_BLOCK))
     &      THEN
         WRITE(*,*) 
     &    "Internal error 3 in DMUMPS_BLR_RETRIEVE_DIAG_BLOCK",
     &    "IPANEL=", IPANEL
         CALL MUMPS_ABORT()
       ENDIF
       THEBLOCK =>
     &        BLR_ARRAY(IWHANDLER)%DIAG_BLOCKS(IPANEL)%DIAG_BLOCK
       RETURN
       END SUBROUTINE DMUMPS_BLR_RETRIEVE_DIAG_BLOCK
       SUBROUTINE DMUMPS_BLR_RETRIEVE_CB_LRB
     &                          (IWHANDLER, THECB)
       INTEGER, INTENT(IN) :: IWHANDLER
#if defined(MUMPS_NOF2003)
       TYPE(LRB_TYPE), POINTER :: THECB(:,:)
#else
       TYPE(LRB_TYPE), POINTER, INTENT(OUT) :: THECB(:,:)
#endif
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) "Internal error 1 in DMUMPS_BLR_RETRIEVE_CB_LRB"
         CALL MUMPS_ABORT()
       ENDIF
       IF ( .NOT. associated(BLR_ARRAY(IWHANDLER)%CB_LRB)) THEN
         WRITE(*,*) "Internal error 2 in DMUMPS_BLR_RETRIEVE_CB_LRB"
         CALL MUMPS_ABORT()
       ENDIF
       THECB => BLR_ARRAY(IWHANDLER)%CB_LRB
       RETURN
       END SUBROUTINE DMUMPS_BLR_RETRIEVE_CB_LRB
       SUBROUTINE DMUMPS_BLR_SAVE_NFS4FATHER
     &            ( IWHANDLER, NFS4FATHER  )
       INTEGER, INTENT(IN) :: IWHANDLER
       INTEGER, INTENT(IN) :: NFS4FATHER 
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) 
     &       "Internal error 1 in DMUMPS_BLR_RETRIEVE_NFS4FATHER"
         CALL MUMPS_ABORT()
       ENDIF
       BLR_ARRAY(IWHANDLER)%NFS4FATHER = NFS4FATHER
       RETURN
       END SUBROUTINE DMUMPS_BLR_SAVE_NFS4FATHER
       SUBROUTINE DMUMPS_BLR_RETRIEVE_NFS4FATHER
     &            ( IWHANDLER, NFS4FATHER  )
       INTEGER, INTENT(IN)  :: IWHANDLER
       INTEGER, INTENT(OUT) :: NFS4FATHER 
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) 
     &       "Internal error 1 in DMUMPS_BLR_RETRIEVE_NFS4FATHER"
         CALL MUMPS_ABORT()
       ENDIF
       NFS4FATHER = BLR_ARRAY(IWHANDLER)%NFS4FATHER
       RETURN
       END SUBROUTINE DMUMPS_BLR_RETRIEVE_NFS4FATHER
       SUBROUTINE DMUMPS_BLR_SAVE_M_ARRAY (
     &    IWHANDLER, M_ARRAY, INFO)
       DOUBLE PRECISION, DIMENSION(:), INTENT(IN) :: M_ARRAY
       INTEGER, INTENT(IN) ::  IWHANDLER
       INTEGER, INTENT(INOUT) :: INFO(2)
       INTEGER :: I, IERR
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
          WRITE(*,*) "Internal error 1 in DMUMPS_BLR_SAVE_M_ARRAY"
          CALL MUMPS_ABORT()
       ENDIF
       ALLOCATE(BLR_ARRAY(IWHANDLER)%M_ARRAY(size(M_ARRAY)),
     &          stat=IERR)
       IF (IERR > 0 ) THEN
         INFO(1)=-13
         INFO(2)=size(M_ARRAY)
         RETURN
       ENDIF
       DO I=1,size(M_ARRAY)
          BLR_ARRAY(IWHANDLER)%M_ARRAY(I) = M_ARRAY(I)
       ENDDO
       BLR_ARRAY(IWHANDLER)%NFS4FATHER = size(M_ARRAY)
       RETURN
       END SUBROUTINE DMUMPS_BLR_SAVE_M_ARRAY
       SUBROUTINE DMUMPS_BLR_RETRIEVE_M_ARRAY ( IWHANDLER, M_ARRAY)
       IMPLICIT NONE
       INTEGER, INTENT(IN) ::  IWHANDLER
#if defined(MUMPS_NOF2003)
       DOUBLE PRECISION, DIMENSION(:), POINTER :: M_ARRAY
#else
       DOUBLE PRECISION, DIMENSION(:), POINTER, INTENT(OUT) :: M_ARRAY
#endif
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
          WRITE(*,*) "Internal error 1 in DMUMPS_BLR_RETRIEVE_M_ARRAY"
          CALL MUMPS_ABORT()
       ENDIF
       M_ARRAY =>  BLR_ARRAY(IWHANDLER)%M_ARRAY
       RETURN
       END SUBROUTINE DMUMPS_BLR_RETRIEVE_M_ARRAY
       SUBROUTINE DMUMPS_BLR_FREE_M_ARRAY ( IWHANDLER )
       IMPLICIT NONE
       INTEGER, INTENT(IN) ::  IWHANDLER
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
          WRITE(*,*) "Internal error 1 in DMUMPS_BLR_FREE_M_ARRAY"
          CALL MUMPS_ABORT()
       ENDIF
       IF (associated(BLR_ARRAY(IWHANDLER)%M_ARRAY)) THEN
          DEALLOCATE(BLR_ARRAY(IWHANDLER)%M_ARRAY)
          NULLIFY(BLR_ARRAY(IWHANDLER)%M_ARRAY)
       ENDIF
       BLR_ARRAY(IWHANDLER)%NFS4FATHER       = NFS4FATHER_NOTINIT
       RETURN
       END SUBROUTINE DMUMPS_BLR_FREE_M_ARRAY
       SUBROUTINE DMUMPS_BLR_DEC_AND_TRYFREE_L( IWHANDLER, IPANEL,
     &                            KEEP8, K34)      
       IMPLICIT NONE
       INTEGER, INTENT(IN) :: IWHANDLER, IPANEL, K34
       INTEGER(8) :: KEEP8(150)
       IF (IWHANDLER.LE.0) RETURN
       IF ( BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT.LT.0)
     &    RETURN
       BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%NB_ACCESSES_LEFT = 
     & BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%NB_ACCESSES_LEFT - 1
       CALL DMUMPS_BLR_TRY_FREE_PANEL (IWHANDLER, IPANEL,
     &                   KEEP8, K34)
       RETURN
       END SUBROUTINE DMUMPS_BLR_DEC_AND_TRYFREE_L
       SUBROUTINE DMUMPS_BLR_TRY_FREE_PANEL( IWHANDLER, IPANEL, 
     &           KEEP8, K34 )
       IMPLICIT NONE
       INTEGER, INTENT(IN) :: IWHANDLER, IPANEL
       INTEGER(8) :: KEEP8(150)
       INTEGER, INTENT(IN)    :: K34
       TYPE(blr_panel_type), POINTER  :: THEPANEL
       IF (IWHANDLER.LE.0) RETURN
       IF ( BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT.LT.0)
     &    RETURN
       THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)
       IF ( THEPANEL%NB_ACCESSES_LEFT .EQ. 0 ) THEN
         IF (associated(THEPANEL%LRB_PANEL)) THEN
          IF (size(THEPANEL%LRB_PANEL) .GT.0) THEN
           CALL DEALLOC_BLR_PANEL(THEPANEL%LRB_PANEL,
     &        size(THEPANEL%LRB_PANEL), KEEP8, K34)
          ENDIF
          DEALLOCATE(THEPANEL%LRB_PANEL)
          NULLIFY(THEPANEL%LRB_PANEL)
         ENDIF
         THEPANEL%NB_ACCESSES_LEFT = PANELS_FREED 
       ENDIF
       RETURN
       END SUBROUTINE DMUMPS_BLR_TRY_FREE_PANEL
       SUBROUTINE DMUMPS_BLR_FREE_CB_LRB ( IWHANDLER, FREE_ONLY_STRUCT,
     &                                     KEEP8, K34 )
       IMPLICIT NONE
       INTEGER, INTENT(IN) :: IWHANDLER, K34
       LOGICAL, INTENT(IN) :: FREE_ONLY_STRUCT
       INTEGER(8) :: KEEP8(150)
       TYPE(LRB_TYPE), POINTER  :: CB_LRB(:,:)
       INTEGER :: IPANEL, JPANEL
       TYPE(LRB_TYPE), POINTER  :: THELRB 
       IF (BLR_ARRAY(IWHANDLER)%IsT2.AND.
     &      .NOT.BLR_ARRAY(IWHANDLER)%IsSLAVE) THEN
         write(*,*) 'Internal error 1 in DMUMPS_BLR_FREE_CB_LRB'
         CALL MUMPS_ABORT()
       ENDIF
       CB_LRB => BLR_ARRAY(IWHANDLER)%CB_LRB
       IF (.NOT.associated(CB_LRB)) THEN
         write(*,*) 'Internal error 2 in DMUMPS_BLR_FREE_CB_LRB'
         CALL MUMPS_ABORT()
       ENDIF
       IF (.NOT.FREE_ONLY_STRUCT) THEN
         DO IPANEL = 1,size(CB_LRB,1)
         DO JPANEL = 1,size(CB_LRB,2)
           THELRB => CB_LRB(IPANEL,JPANEL)
           IF (associated(THELRB)) THEN
             CALL DEALLOC_LRB(THELRB, KEEP8, K34)
           ENDIF
         ENDDO
         ENDDO
       ENDIF
       DEALLOCATE(BLR_ARRAY(IWHANDLER)%CB_LRB)
       NULLIFY(BLR_ARRAY(IWHANDLER)%CB_LRB)
       RETURN
       END SUBROUTINE DMUMPS_BLR_FREE_CB_LRB
       SUBROUTINE DMUMPS_BLR_FREE_ALL_PANELS ( IWHANDLER, 
     &         LorU, KEEP8, K34)
       IMPLICIT NONE
       INTEGER, INTENT(IN) :: IWHANDLER, LorU, K34
       INTEGER(8) :: KEEP8(150)
       INTEGER             :: IPANEL
       INTEGER             :: IDUMMY, JDUMMY
       TYPE(blr_panel_type), POINTER  :: THEPANEL
       TYPE(diag_block_type), POINTER  :: THEBLOCK
       INTEGER(8) :: MEM_FREED
       IF (IWHANDLER.LE.0) RETURN
       IF (BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT.EQ.
     &      PANELS_NOTUSED) RETURN
       IF (LorU.EQ.0.OR.LorU.EQ.2) THEN
         IF (associated(BLR_ARRAY(IWHANDLER)%PANELS_L)) THEN
         DO IPANEL = 1, size(BLR_ARRAY(IWHANDLER)%PANELS_L)
         THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)
           IF (associated(THEPANEL%LRB_PANEL)) THEN
            IF (size(THEPANEL%LRB_PANEL) .GT.0) THEN
             CALL DEALLOC_BLR_PANEL(THEPANEL%LRB_PANEL,
     &          size(THEPANEL%LRB_PANEL), KEEP8, K34)
            ENDIF
            DEALLOCATE(THEPANEL%LRB_PANEL)
            NULLIFY(THEPANEL%LRB_PANEL)
           ENDIF
           THEPANEL%NB_ACCESSES_LEFT = PANELS_FREED 
         ENDDO
         ENDIF
       ENDIF
       IF (LorU.GE.1.AND..NOT.BLR_ARRAY(IWHANDLER)%IsSYM) THEN
         IF (associated(BLR_ARRAY(IWHANDLER)%PANELS_U)) THEN
         DO IPANEL = 1, size(BLR_ARRAY(IWHANDLER)%PANELS_U)
           THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_U(IPANEL)
          IF (associated(THEPANEL%LRB_PANEL)) THEN
           IF (size(THEPANEL%LRB_PANEL) .GT.0) THEN
            CALL DEALLOC_BLR_PANEL(THEPANEL%LRB_PANEL,
     &        size(THEPANEL%LRB_PANEL), KEEP8, K34)
           ENDIF
           DEALLOCATE(THEPANEL%LRB_PANEL)
           NULLIFY(THEPANEL%LRB_PANEL)
          ENDIF
          THEPANEL%NB_ACCESSES_LEFT = PANELS_FREED 
         ENDDO
         ENDIF
       ENDIF
       IF (.NOT.BLR_ARRAY(IWHANDLER)%IsSLAVE) THEN
         IF (associated(BLR_ARRAY(IWHANDLER)%DIAG_BLOCKS)) THEN
           MEM_FREED = 0_8
           DO IPANEL = 1, size(BLR_ARRAY(IWHANDLER)%DIAG_BLOCKS)
             THEBLOCK => BLR_ARRAY(IWHANDLER)%DIAG_BLOCKS(IPANEL)
             IF (associated(THEBLOCK%DIAG_BLOCK)) THEN
               MEM_FREED = MEM_FREED + int(size(THEBLOCK%DIAG_BLOCK),8)
               DEALLOCATE(THEBLOCK%DIAG_BLOCK)
               NULLIFY   (THEBLOCK%DIAG_BLOCK)
             ENDIF
           ENDDO
           IF (MEM_FREED .GT. 0 ) THEN
             CALL MUMPS_DM_FAC_UPD_DYN_MEMCNTS(-MEM_FREED,
     &        .TRUE., KEEP8, 
     &        IDUMMY, JDUMMY, 
     &        .TRUE., .TRUE.)
           ENDIF
         ENDIF
       ENDIF
       RETURN
       END SUBROUTINE DMUMPS_BLR_FREE_ALL_PANELS
#if ! defined(NO_SAVE_RESTORE)
      SUBROUTINE DMUMPS_SAVE_RESTORE_BLR(id_BLRARRAY_ENCODING
     &                 ,unit,MYID,mode
     &                 ,SIZE_GEST,SIZE_VARIABLES
     &                 ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &                 ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                 ,size_read,size_allocated,size_written
     &                 ,INFO)
      INCLUDE 'mpif.h'
      CHARACTER, DIMENSION(:), POINTER :: id_BLRARRAY_ENCODING
      INTEGER,intent(IN)::unit,MYID
      INTEGER,intent(IN) :: mode
      INTEGER,INTENT(OUT) :: SIZE_GEST
      INTEGER(8),intent(OUT) :: SIZE_VARIABLES
      INTEGER(8),intent(IN) :: TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
      INTEGER,intent(INOUT):: INFO(2)
      INTEGER,intent(IN):: SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
      INTEGER(8),intent(INOUT):: size_read,size_allocated,size_written
      INTEGER:: j1,NbRecords,NbSubRecords,size_array1,dummy,allocok,err
      INTEGER:: SIZE_GEST_BLR_ARRAY,SIZE_GEST_BLR_ARRAY_j1
      INTEGER(8):: SIZE_VARIABLES_BLR_ARRAY,SIZE_VARIABLES_BLR_ARRAY_j1
      INTEGER(4) :: I4
      NbRecords=0
      SIZE_GEST_BLR_ARRAY=0
      SIZE_GEST_BLR_ARRAY_j1=0
      SIZE_VARIABLES_BLR_ARRAY=0_8
      SIZE_VARIABLES_BLR_ARRAY_j1=0_8
      SIZE_GEST=0
      SIZE_VARIABLES=0_8
      if(mode.EQ.memory_save_mode.OR.mode.EQ.save_mode) then
         call DMUMPS_BLR_STRUC_TO_MOD(id_BLRARRAY_ENCODING)
      endif
      if(mode.EQ.memory_save_mode) then
         IF(associated(BLR_ARRAY)) THEN
            NbRecords=1
            SIZE_GEST=SIZE_INT
            SIZE_VARIABLES=0
            DO j1=1,size(BLR_ARRAY,1)
               CALL DMUMPS_SAVE_RESTORE_BLR_STRUC(
     &              BLR_ARRAY(j1)
     &              ,unit,MYID,memory_save_mode
     &              ,SIZE_GEST_BLR_ARRAY_j1
     &              ,SIZE_VARIABLES_BLR_ARRAY_j1
     &              ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &              ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &              ,size_read,size_allocated,size_written
     &              ,INFO)
               SIZE_GEST_BLR_ARRAY=SIZE_GEST_BLR_ARRAY+
     &              SIZE_GEST_BLR_ARRAY_j1
               SIZE_VARIABLES_BLR_ARRAY=SIZE_VARIABLES_BLR_ARRAY+
     &              SIZE_VARIABLES_BLR_ARRAY_j1
            ENDDO
         ELSE
            NbRecords=2
            SIZE_GEST=SIZE_INT*2
            SIZE_VARIABLES=0
         ENDIF
      elseif(mode.EQ.save_mode) then
         IF(associated(BLR_ARRAY)) THEN
            NbRecords=1
            SIZE_GEST=SIZE_INT
            SIZE_VARIABLES=0
            write(unit,iostat=err) size(BLR_ARRAY,1)
            if(err.ne.0) then
               INFO(1) = -72
               CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &              INFO(2))
            endif
            IF ( INFO(1) .LT. 0 ) GOTO 100
            DO j1=1,size(BLR_ARRAY,1)
               CALL DMUMPS_SAVE_RESTORE_BLR_STRUC(
     &              BLR_ARRAY(j1)
     &              ,unit,MYID,save_mode
     &              ,SIZE_GEST_BLR_ARRAY_j1
     &              ,SIZE_VARIABLES_BLR_ARRAY_j1
     &              ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &              ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &              ,size_read,size_allocated,size_written
     &              ,INFO)
               IF ( INFO(1) .LT. 0 ) GOTO 100
            ENDDO
         ELSE
            NbRecords=2
            SIZE_GEST=SIZE_INT*2
            SIZE_VARIABLES=0
            write(unit,iostat=err) -999
            if(err.ne.0) then
               INFO(1) = -72
               CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &              INFO(2))
            endif
            IF ( INFO(1) .LT. 0 ) GOTO 100
            write(unit,iostat=err) -999
            if(err.ne.0) then
               INFO(1) = -72
               CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &              INFO(2))
            endif
            IF ( INFO(1) .LT. 0 ) GOTO 100
         ENDIF 
      elseif(mode.EQ.restore_mode) then
         nullify(BLR_ARRAY)
         read(unit,iostat=err) size_array1
         if(err.ne.0) THEN
            INFO(1) = -75
            CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &           ,INFO(2))
         endif
         IF ( INFO(1) .LT. 0 ) GOTO 100
         if(size_array1.EQ.-999) then
            NbRecords=2
            SIZE_GEST=SIZE_INT*2
            SIZE_VARIABLES=0
            read(unit,iostat=err) dummy
            if(err.ne.0) THEN
               INFO(1) = -75
               CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &              ,INFO(2))
            endif
            IF ( INFO(1) .LT. 0 ) GOTO 100
         else
            NbRecords=1
            SIZE_GEST=SIZE_INT
            SIZE_VARIABLES=0
            allocate(BLR_ARRAY(size_array1), stat=allocok)
            if (allocok .GT. 0) THEN
               INFO(1) = -78
               CALL MUMPS_SETI8TOI4(
     &              TOTAL_STRUC_SIZE-size_allocated
     &              ,INFO(2))
            endif
            DO j1=1,size_array1
               CALL DMUMPS_SAVE_RESTORE_BLR_STRUC(
     &              BLR_ARRAY(j1)
     &              ,unit,MYID,restore_mode
     &              ,SIZE_GEST_BLR_ARRAY_j1
     &              ,SIZE_VARIABLES_BLR_ARRAY_j1
     &              ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &              ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &              ,size_read,size_allocated,size_written
     &              ,INFO)
               SIZE_GEST_BLR_ARRAY=SIZE_GEST_BLR_ARRAY+
     &              SIZE_GEST_BLR_ARRAY_j1
               SIZE_VARIABLES_BLR_ARRAY=SIZE_VARIABLES_BLR_ARRAY+
     &              SIZE_VARIABLES_BLR_ARRAY_j1
            ENDDO
         endif
      endif
      if(mode.EQ.memory_save_mode) then
         NbSubRecords=int(SIZE_VARIABLES/huge(I4))
         IF(NbSubRecords.GT.0) then
            NbRecords=NbRecords+NbSubRecords
         ENDIF
      elseif(mode.EQ.save_mode) then
         size_written=size_written+SIZE_VARIABLES
     &        +int(SIZE_GEST,kind=8)
#if defined(MUMPS_NOF2003)
         size_written=size_written
     &        +int(2*SIZE_INT*NbRecords,kind=8)
#endif
      elseif(mode.EQ.restore_mode) then
         size_allocated=size_allocated+SIZE_VARIABLES
         size_read=size_read+SIZE_VARIABLES
     &        +int(SIZE_GEST,kind=8)
#if defined(MUMPS_NOF2003)
         size_read=size_read
     &        +int(2*SIZE_INT*NbRecords,kind=8)
#endif
      endif
      if(mode.EQ.memory_save_mode) then
         SIZE_VARIABLES=SIZE_VARIABLES+SIZE_VARIABLES_BLR_ARRAY
         SIZE_GEST=SIZE_GEST+SIZE_GEST_BLR_ARRAY
#if defined(MUMPS_NOF2003)
         SIZE_GEST=SIZE_GEST+2*SIZE_INT*NbRecords
#endif
      endif
      call DMUMPS_BLR_MOD_TO_STRUC(id_BLRARRAY_ENCODING)
 100  continue
      RETURN
      END SUBROUTINE DMUMPS_SAVE_RESTORE_BLR
      SUBROUTINE DMUMPS_SAVE_RESTORE_BLR_STRUC(BLR_STRUC
     &     ,unit,MYID,mode
     &     ,Local_SIZE_GEST,Local_SIZE_VARIABLES
     &     ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &     ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &     ,size_read,size_allocated,size_written
     &     ,INFO)     
      INCLUDE 'mpif.h'
      TYPE(BLR_STRUC_T) :: BLR_STRUC
      INTEGER,intent(IN)::unit,MYID
      INTEGER,intent(IN) :: mode
      INTEGER,INTENT(OUT) :: Local_SIZE_GEST
      INTEGER(8),intent(OUT) :: Local_SIZE_VARIABLES
      INTEGER,intent(INOUT):: INFO(2)
      INTEGER,intent(IN):: SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
      INTEGER(8),intent(IN) :: TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
      INTEGER(8),intent(INOUT):: size_read,size_allocated,size_written
      INTEGER, PARAMETER :: NBVARIABLES_BLR_STRUC_T = 15
      INTEGER, PARAMETER :: B_IsSYM=1
      INTEGER, PARAMETER :: B_IsT2=2
      INTEGER, PARAMETER :: B_IsSLAVE=3
      INTEGER, PARAMETER :: B_PANELS_L=4
      INTEGER, PARAMETER :: B_PANELS_U=5
      INTEGER, PARAMETER :: B_CB_LRB=6
      INTEGER, PARAMETER :: B_DIAG_BLOCKS=7
      INTEGER, PARAMETER :: B_BEGS_BLR_STATIC=8
      INTEGER, PARAMETER :: B_BEGS_BLR_DYNAMIC=9
      INTEGER, PARAMETER :: B_BEGS_BLR_L=10
      INTEGER, PARAMETER :: B_BEGS_BLR_COL=11
      INTEGER, PARAMETER :: B_NB_ACCESSES_INIT=12
      INTEGER, PARAMETER :: B_NB_PANELS=13
      INTEGER, PARAMETER :: B_NFS4FATHER=14
      INTEGER, PARAMETER :: B_M_ARRAY=15
      INTEGER(8),dimension(NBVARIABLES_BLR_STRUC_T)::
     &     SIZE_VARIABLES_BLR_STRUC_T
      INTEGER,dimension(NBVARIABLES_BLR_STRUC_T)::SIZE_GEST_BLR_STRUC_T
      INTEGER,dimension(NBVARIABLES_BLR_STRUC_T)::NbRecords_BLR_STRUC_T
      INTEGER:: size_array1,size_array2,dummy,allocok
      INTEGER:: err,i1,j1,j2,NbSubRecords
#if defined(MUMPS_NOF2003)
      INTEGER:: Local_NbRecords
#endif
      INTEGER::SIZE_GEST_PANELS_L,SIZE_GEST_PANELS_L_j1
      INTEGER(8)::SIZE_VARIABLES_PANELS_L,SIZE_VARIABLES_PANELS_L_j1
      INTEGER::SIZE_GEST_PANELS_U,SIZE_GEST_PANELS_U_j1
      INTEGER(8)::SIZE_VARIABLES_PANELS_U,SIZE_VARIABLES_PANELS_U_j1
      INTEGER::SIZE_GEST_CB_LRB,SIZE_GEST_CB_LRB_j1j2
      INTEGER(8)::SIZE_VARIABLES_CB_LRB,SIZE_VARIABLES_CB_LRB_j1j2
      INTEGER::SIZE_GEST_DIAG_BLOCKS,SIZE_GEST_DIAG_BLOCKS_j1
      INTEGER(8)::SIZE_VARIABLES_DIAG_BLOCKS
      INTEGER(8)::SIZE_VARIABLES_DIAG_BLOCKS_j1
      INTEGER(4)::I4
      SIZE_VARIABLES_BLR_STRUC_T(:)=0_8
      SIZE_GEST_BLR_STRUC_T(:)=0
      NbRecords_BLR_STRUC_T(:)=0
      SIZE_GEST_PANELS_L=0
      SIZE_GEST_PANELS_L_j1=0
      SIZE_VARIABLES_PANELS_L=0_8
      SIZE_VARIABLES_PANELS_L_j1=0_8
      SIZE_GEST_PANELS_U=0
      SIZE_GEST_PANELS_U_j1=0
      SIZE_VARIABLES_PANELS_U=0_8
      SIZE_VARIABLES_PANELS_U_j1=0_8
      SIZE_GEST_CB_LRB=0
      SIZE_GEST_CB_LRB_j1j2=0
      SIZE_VARIABLES_CB_LRB=0_8
      SIZE_VARIABLES_CB_LRB_j1j2=0_8
      SIZE_GEST_DIAG_BLOCKS=0
      SIZE_GEST_DIAG_BLOCKS_j1=0
      SIZE_VARIABLES_DIAG_BLOCKS=0_8
      SIZE_VARIABLES_DIAG_BLOCKS_j1=0_8
      DO i1=1,NBVARIABLES_BLR_STRUC_T 
         SELECT CASE(i1)
         CASE(B_IsSYM)
            NbRecords_BLR_STRUC_T(i1)=1
            if(mode.EQ.memory_save_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_LOGICAL
            elseif(mode.EQ.save_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_LOGICAL
               write(unit,iostat=err) BLR_STRUC%IsSYM
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
            elseif(mode.EQ.restore_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_LOGICAL
               read(unit,iostat=err) BLR_STRUC%IsSYM
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif 
               IF (INFO(1) .LT. 0 ) GOTO 100
            endif
         CASE(B_IsT2)
            NbRecords_BLR_STRUC_T(i1)=1
            if(mode.EQ.memory_save_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_LOGICAL
            elseif(mode.EQ.save_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_LOGICAL
               write(unit,iostat=err) BLR_STRUC%IsT2
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
            elseif(mode.EQ.restore_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_LOGICAL
               read(unit,iostat=err) BLR_STRUC%IsT2
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif 
               IF (INFO(1) .LT. 0 ) GOTO 100
            endif
         CASE(B_IsSLAVE)
            NbRecords_BLR_STRUC_T(i1)=1
            if(mode.EQ.memory_save_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_LOGICAL
            elseif(mode.EQ.save_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_LOGICAL
               write(unit,iostat=err) BLR_STRUC%IsSLAVE
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
            elseif(mode.EQ.restore_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_LOGICAL
               read(unit,iostat=err) BLR_STRUC%IsSLAVE
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif 
               IF (INFO(1) .LT. 0 ) GOTO 100
            endif
         CASE(B_BEGS_BLR_STATIC)
            NbRecords_BLR_STRUC_T(i1)=2
            if(mode.EQ.memory_save_mode) then
               IF(associated(BLR_STRUC%BEGS_BLR_STATIC)) THEN
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=
     &                 size(BLR_STRUC%BEGS_BLR_STATIC,1)*SIZE_INT
               ELSE
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
               ENDIF
            elseif(mode.EQ.save_mode) then
               IF(associated(BLR_STRUC%BEGS_BLR_STATIC)) THEN
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=
     &                 size(BLR_STRUC%BEGS_BLR_STATIC,1)*SIZE_INT
                  write(unit,iostat=err)
     &                 size(BLR_STRUC%BEGS_BLR_STATIC,1)
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
                  write(unit,iostat=err) BLR_STRUC%BEGS_BLR_STATIC
               ELSE
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  write(unit,iostat=err) -999
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
                  write(unit,iostat=err) -999
               ENDIF 
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
            elseif(mode.EQ.restore_mode) then
               nullify(BLR_STRUC%BEGS_BLR_STATIC)
               read(unit,iostat=err) size_array1
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
               if(size_array1.EQ.-999) then
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  read(unit,iostat=err) dummy
               else
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=size_array1*SIZE_INT
                  allocate(BLR_STRUC%BEGS_BLR_STATIC(size_array1)
     &                 , stat=allocok)
                  if (allocok .GT. 0) THEN
                     INFO(1) = -78
                     CALL MUMPS_SETI8TOI4(
     &                    TOTAL_STRUC_SIZE-size_allocated
     &                    ,INFO(2))
                  endif
                  read(unit,iostat=err) BLR_STRUC%BEGS_BLR_STATIC
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
            endif
         CASE(B_BEGS_BLR_DYNAMIC)
            NbRecords_BLR_STRUC_T(i1)=2
            if(mode.EQ.memory_save_mode) then
               IF(associated(BLR_STRUC%BEGS_BLR_DYNAMIC)) THEN
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=
     &                 size(BLR_STRUC%BEGS_BLR_DYNAMIC,1)*SIZE_INT
               ELSE
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
               ENDIF
            elseif(mode.EQ.save_mode) then
               IF(associated(BLR_STRUC%BEGS_BLR_DYNAMIC)) THEN
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=
     &                 size(BLR_STRUC%BEGS_BLR_DYNAMIC,1)*SIZE_INT
                  write(unit,iostat=err)
     &                 size(BLR_STRUC%BEGS_BLR_DYNAMIC,1)
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
                  write(unit,iostat=err) BLR_STRUC%BEGS_BLR_DYNAMIC
               ELSE
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  write(unit,iostat=err) -999
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
                  write(unit,iostat=err) -999
               ENDIF 
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
            elseif(mode.EQ.restore_mode) then
               nullify(BLR_STRUC%BEGS_BLR_DYNAMIC)
               read(unit,iostat=err) size_array1
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
               if(size_array1.EQ.-999) then
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  read(unit,iostat=err) dummy
               else
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=size_array1*SIZE_INT
                  allocate(BLR_STRUC%BEGS_BLR_DYNAMIC(size_array1)
     &                 , stat=allocok)
                  if (allocok .GT. 0) THEN
                     INFO(1) = -78
                     CALL MUMPS_SETI8TOI4(
     &                    TOTAL_STRUC_SIZE-size_allocated
     &                    ,INFO(2))
                  endif
                  read(unit,iostat=err) BLR_STRUC%BEGS_BLR_DYNAMIC
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
            endif
         CASE(B_BEGS_BLR_L)
            NbRecords_BLR_STRUC_T(i1)=2
            if(mode.EQ.memory_save_mode) then
               IF(associated(BLR_STRUC%BEGS_BLR_L)) THEN
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=
     &                 size(BLR_STRUC%BEGS_BLR_L,1)*SIZE_INT
               ELSE
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
               ENDIF
            elseif(mode.EQ.save_mode) then
               IF(associated(BLR_STRUC%BEGS_BLR_L)) THEN
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=
     &                 size(BLR_STRUC%BEGS_BLR_L,1)*SIZE_INT
                  write(unit,iostat=err)
     &                 size(BLR_STRUC%BEGS_BLR_L,1)
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
                  write(unit,iostat=err) BLR_STRUC%BEGS_BLR_L
               ELSE
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  write(unit,iostat=err) -999
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
                  write(unit,iostat=err) -999
               ENDIF 
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
            elseif(mode.EQ.restore_mode) then
               nullify(BLR_STRUC%BEGS_BLR_L)
               read(unit,iostat=err) size_array1
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
               if(size_array1.EQ.-999) then
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  read(unit,iostat=err) dummy
               else
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=size_array1*SIZE_INT
                  allocate(BLR_STRUC%BEGS_BLR_L(size_array1)
     &                 , stat=allocok)
                  if (allocok .GT. 0) THEN
                     INFO(1) = -78
                     CALL MUMPS_SETI8TOI4(
     &                    TOTAL_STRUC_SIZE-size_allocated
     &                    ,INFO(2))
                  endif
                  read(unit,iostat=err) BLR_STRUC%BEGS_BLR_L
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
            endif
         CASE(B_BEGS_BLR_COL)
            NbRecords_BLR_STRUC_T(i1)=2
            if(mode.EQ.memory_save_mode) then
               IF(associated(BLR_STRUC%BEGS_BLR_COL)) THEN
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=
     &                 size(BLR_STRUC%BEGS_BLR_COL,1)*SIZE_INT
               ELSE
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
               ENDIF
            elseif(mode.EQ.save_mode) then
               IF(associated(BLR_STRUC%BEGS_BLR_COL)) THEN
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=
     &                 size(BLR_STRUC%BEGS_BLR_COL,1)*SIZE_INT
                  write(unit,iostat=err)
     &                 size(BLR_STRUC%BEGS_BLR_COL,1)
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
                  write(unit,iostat=err) BLR_STRUC%BEGS_BLR_COL
               ELSE
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  write(unit,iostat=err) -999
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
                  write(unit,iostat=err) -999
               ENDIF 
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
            elseif(mode.EQ.restore_mode) then
               nullify(BLR_STRUC%BEGS_BLR_COL)
               read(unit,iostat=err) size_array1
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
               if(size_array1.EQ.-999) then
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  read(unit,iostat=err) dummy
               else
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=size_array1*SIZE_INT
                  allocate(BLR_STRUC%BEGS_BLR_COL(size_array1)
     &                 , stat=allocok)
                  if (allocok .GT. 0) THEN
                     INFO(1) = -78
                     CALL MUMPS_SETI8TOI4(
     &                    TOTAL_STRUC_SIZE-size_allocated
     &                    ,INFO(2))
                  endif
                  read(unit,iostat=err) BLR_STRUC%BEGS_BLR_COL
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
            endif
         CASE(B_NB_ACCESSES_INIT)
            NbRecords_BLR_STRUC_T(i1)=1
            if(mode.EQ.memory_save_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_INT
            elseif(mode.EQ.save_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_INT
               write(unit,iostat=err) BLR_STRUC%NB_ACCESSES_INIT
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
            elseif(mode.EQ.restore_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_INT
               read(unit,iostat=err) BLR_STRUC%NB_ACCESSES_INIT
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif 
               IF (INFO(1) .LT. 0 ) GOTO 100
            endif
         CASE(B_NB_PANELS)
            NbRecords_BLR_STRUC_T(i1)=1
            if(mode.EQ.memory_save_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_INT
            elseif(mode.EQ.save_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_INT
               write(unit,iostat=err) BLR_STRUC%NB_PANELS
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
            elseif(mode.EQ.restore_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_INT
               read(unit,iostat=err) BLR_STRUC%NB_PANELS
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif 
               IF (INFO(1) .LT. 0 ) GOTO 100
            endif
         CASE(B_PANELS_L)
            if(mode.EQ.memory_save_mode) then
               IF(associated(BLR_STRUC%PANELS_L)) THEN
                  NbRecords_BLR_STRUC_T(i1)=1
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  DO j1=1,size(BLR_STRUC%PANELS_L,1)
                     CALL DMUMPS_SAVE_RESTORE_BLR_PANEL(
     &                    BLR_STRUC%PANELS_L(j1)
     &                    ,unit,MYID,memory_save_mode
     &                    ,SIZE_GEST_PANELS_L_j1
     &                    ,SIZE_VARIABLES_PANELS_L_j1
     &                    ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &                    ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                    ,size_read,size_allocated,size_written
     &                    ,INFO)
                     SIZE_GEST_PANELS_L=SIZE_GEST_PANELS_L+
     &                    SIZE_GEST_PANELS_L_j1
                     SIZE_VARIABLES_PANELS_L=SIZE_VARIABLES_PANELS_L+
     &                    SIZE_VARIABLES_PANELS_L_j1
                  ENDDO
               ELSE
                  NbRecords_BLR_STRUC_T(i1)=2
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
               ENDIF
            elseif(mode.EQ.save_mode) then
               IF(associated(BLR_STRUC%PANELS_L)) THEN
                  NbRecords_BLR_STRUC_T(i1)=1
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  write(unit,iostat=err)
     &                 size(BLR_STRUC%PANELS_L,1)
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  DO j1=1,size(BLR_STRUC%PANELS_L,1)
                     CALL DMUMPS_SAVE_RESTORE_BLR_PANEL(
     &                    BLR_STRUC%PANELS_L(j1)
     &                    ,unit,MYID,save_mode
     &                    ,SIZE_GEST_PANELS_L_j1
     &                    ,SIZE_VARIABLES_PANELS_L_j1
     &                    ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &                    ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                    ,size_read,size_allocated,size_written
     &                    ,INFO)                     
                     IF ( INFO(1) .LT. 0 ) GOTO 100
                  ENDDO
               ELSE
                  NbRecords_BLR_STRUC_T(i1)=2
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  write(unit,iostat=err) -999
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
                  write(unit,iostat=err) -999
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
               ENDIF 
            elseif(mode.EQ.restore_mode) then
               nullify(BLR_STRUC%PANELS_L)
               read(unit,iostat=err) size_array1
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
               if(size_array1.EQ.-999) then
                  NbRecords_BLR_STRUC_T(i1)=2
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  read(unit,iostat=err) dummy
                  if(err.ne.0) THEN
                     INFO(1) = -75
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                    ,INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
               else
                  NbRecords_BLR_STRUC_T(i1)=1
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  allocate(BLR_STRUC%PANELS_L(size_array1)
     &                 , stat=allocok)
                  if (allocok .GT. 0) THEN
                     INFO(1) = -78
                     CALL MUMPS_SETI8TOI4(
     &                    TOTAL_STRUC_SIZE-size_allocated
     &                    ,INFO(2))
                  endif
                  DO j1=1,size_array1
                     CALL DMUMPS_SAVE_RESTORE_BLR_PANEL(
     &                    BLR_STRUC%PANELS_L(j1)
     &                    ,unit,MYID,restore_mode
     &                    ,SIZE_GEST_PANELS_L_j1
     &                    ,SIZE_VARIABLES_PANELS_L_j1
     &                    ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &                    ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                    ,size_read,size_allocated,size_written
     &                    ,INFO)
                     SIZE_GEST_PANELS_L=SIZE_GEST_PANELS_L+
     &                    SIZE_GEST_PANELS_L_j1
                     SIZE_VARIABLES_PANELS_L=SIZE_VARIABLES_PANELS_L+
     &                    SIZE_VARIABLES_PANELS_L_j1
                  ENDDO
               endif
            endif
            CASE(B_PANELS_U)
            if(mode.EQ.memory_save_mode) then
               IF(associated(BLR_STRUC%PANELS_U)) THEN
                  NbRecords_BLR_STRUC_T(i1)=1
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  DO j1=1,size(BLR_STRUC%PANELS_U,1)
                     CALL DMUMPS_SAVE_RESTORE_BLR_PANEL(
     &                    BLR_STRUC%PANELS_U(j1)
     &                    ,unit,MYID,memory_save_mode
     &                    ,SIZE_GEST_PANELS_U_j1
     &                    ,SIZE_VARIABLES_PANELS_U_j1
     &                    ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &                    ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                    ,size_read,size_allocated,size_written
     &                    ,INFO)
                     SIZE_GEST_PANELS_U=SIZE_GEST_PANELS_U+
     &                    SIZE_GEST_PANELS_U_j1
                     SIZE_VARIABLES_PANELS_U=SIZE_VARIABLES_PANELS_U+
     &                    SIZE_VARIABLES_PANELS_U_j1
                  ENDDO
               ELSE
                  NbRecords_BLR_STRUC_T(i1)=2
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
               ENDIF
            elseif(mode.EQ.save_mode) then
               IF(associated(BLR_STRUC%PANELS_U)) THEN
                  NbRecords_BLR_STRUC_T(i1)=1
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  write(unit,iostat=err)
     &                 size(BLR_STRUC%PANELS_U,1)
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  DO j1=1,size(BLR_STRUC%PANELS_U,1)
                     CALL DMUMPS_SAVE_RESTORE_BLR_PANEL(
     &                    BLR_STRUC%PANELS_U(j1)
     &                    ,unit,MYID,save_mode
     &                    ,SIZE_GEST_PANELS_U_j1
     &                    ,SIZE_VARIABLES_PANELS_U_j1
     &                    ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &                    ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                    ,size_read,size_allocated,size_written
     &                    ,INFO)
                     IF ( INFO(1) .LT. 0 ) GOTO 100
                  ENDDO
               ELSE
                  NbRecords_BLR_STRUC_T(i1)=2
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  write(unit,iostat=err) -999
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
                  write(unit,iostat=err) -999
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
               ENDIF 
            elseif(mode.EQ.restore_mode) then
               nullify(BLR_STRUC%PANELS_U)
               read(unit,iostat=err) size_array1
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
               if(size_array1.EQ.-999) then
                  NbRecords_BLR_STRUC_T(i1)=2
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  read(unit,iostat=err) dummy
                  if(err.ne.0) THEN
                     INFO(1) = -75
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                    ,INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
               else
                  NbRecords_BLR_STRUC_T(i1)=1
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  allocate(BLR_STRUC%PANELS_U(size_array1)
     &                 , stat=allocok)
                  if (allocok .GT. 0) THEN
                     INFO(1) = -78
                     CALL MUMPS_SETI8TOI4(
     &                    TOTAL_STRUC_SIZE-size_allocated
     &                    ,INFO(2))
                  endif
                  DO j1=1,size_array1
                     CALL DMUMPS_SAVE_RESTORE_BLR_PANEL(
     &                    BLR_STRUC%PANELS_U(j1)
     &                    ,unit,MYID,restore_mode
     &                    ,SIZE_GEST_PANELS_U_j1
     &                    ,SIZE_VARIABLES_PANELS_U_j1
     &                    ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &                    ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                    ,size_read,size_allocated,size_written
     &                    ,INFO)
                     SIZE_GEST_PANELS_U=SIZE_GEST_PANELS_U+
     &                    SIZE_GEST_PANELS_U_j1
                     SIZE_VARIABLES_PANELS_U=SIZE_VARIABLES_PANELS_U+
     &                    SIZE_VARIABLES_PANELS_U_j1
                  ENDDO
               endif
            endif
         CASE(B_CB_LRB)
            if(mode.EQ.memory_save_mode) then
               IF(associated(BLR_STRUC%CB_LRB)) THEN
                  NbRecords_BLR_STRUC_T(i1)=1
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  DO j1=1,size(BLR_STRUC%CB_LRB,1)
                     DO j2=1,size(BLR_STRUC%CB_LRB,2)
                        CALL DMUMPS_SAVE_RESTORE_LRB(
     &                       BLR_STRUC%CB_LRB(j1,j2)
     &                       ,unit,MYID,memory_save_mode
     &                       ,SIZE_GEST_CB_LRB_j1j2
     &                       ,SIZE_VARIABLES_CB_LRB_j1j2
     &                       ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &                       ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                       ,size_read,size_allocated,size_written
     &                       ,INFO)
                        SIZE_GEST_CB_LRB=SIZE_GEST_CB_LRB+
     &                       SIZE_GEST_CB_LRB_j1j2
                        SIZE_VARIABLES_CB_LRB=SIZE_VARIABLES_CB_LRB+
     &                       SIZE_VARIABLES_CB_LRB_j1j2
                     ENDDO
                  ENDDO
               ELSE
                  NbRecords_BLR_STRUC_T(i1)=2
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*3
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
               ENDIF
            elseif(mode.EQ.save_mode) then
               IF(associated(BLR_STRUC%CB_LRB)) THEN
                  NbRecords_BLR_STRUC_T(i1)=1
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  write(unit,iostat=err)
     &                 size(BLR_STRUC%CB_LRB,1),size(BLR_STRUC%CB_LRB,2)
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  DO j1=1,size(BLR_STRUC%CB_LRB,1)
                     DO j2=1,size(BLR_STRUC%CB_LRB,2)
                        CALL DMUMPS_SAVE_RESTORE_LRB(
     &                       BLR_STRUC%CB_LRB(j1,j2)
     &                       ,unit,MYID,save_mode
     &                       ,SIZE_GEST_CB_LRB_j1j2
     &                       ,SIZE_VARIABLES_CB_LRB_j1j2
     &                       ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &                       ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                       ,size_read,size_allocated,size_written
     &                       ,INFO)
                        IF ( INFO(1) .LT. 0 ) GOTO 100
                     ENDDO
                  ENDDO
               ELSE
                  NbRecords_BLR_STRUC_T(i1)=2
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*3
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  write(unit,iostat=err) -999,-998
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
                  write(unit,iostat=err) -999
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
               ENDIF 
            elseif(mode.EQ.restore_mode) then
               nullify(BLR_STRUC%CB_LRB)
               read(unit,iostat=err) size_array1,size_array2
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
               if(size_array1.EQ.-999) then
                  NbRecords_BLR_STRUC_T(i1)=2
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*3
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  read(unit,iostat=err) dummy
                  if(err.ne.0) THEN
                     INFO(1) = -75
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                    ,INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
               else
                  NbRecords_BLR_STRUC_T(i1)=1
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  allocate(BLR_STRUC%CB_LRB(size_array1,size_array2)
     &                 , stat=allocok)
                  if (allocok .GT. 0) THEN
                     INFO(1) = -78
                     CALL MUMPS_SETI8TOI4(
     &                    TOTAL_STRUC_SIZE-size_allocated
     &                    ,INFO(2))
                  endif
                  DO j1=1,size_array1
                     DO j2=1,size_array2
                        CALL DMUMPS_SAVE_RESTORE_LRB(
     &                       BLR_STRUC%CB_LRB(j1,j2)
     &                       ,unit,MYID,restore_mode
     &                       ,SIZE_GEST_CB_LRB_j1j2
     &                       ,SIZE_VARIABLES_CB_LRB_j1j2
     &                       ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &                       ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                       ,size_read,size_allocated,size_written
     &                       ,INFO)
                        SIZE_GEST_CB_LRB=SIZE_GEST_CB_LRB+
     &                       SIZE_GEST_CB_LRB_j1j2
                        SIZE_VARIABLES_CB_LRB=SIZE_VARIABLES_CB_LRB+
     &                       SIZE_VARIABLES_CB_LRB_j1j2
                     ENDDO
                  ENDDO
               endif
            endif
         CASE(B_DIAG_BLOCKS)
            if(mode.EQ.memory_save_mode) then
               IF(associated(BLR_STRUC%DIAG_BLOCKS)) THEN
                  NbRecords_BLR_STRUC_T(i1)=1
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  DO j1=1,size(BLR_STRUC%DIAG_BLOCKS,1)
                     CALL DMUMPS_SAVE_RESTORE_DIAG_BLOCK(
     &                    BLR_STRUC%DIAG_BLOCKS(j1)
     &                    ,unit,MYID,memory_save_mode
     &                    ,SIZE_GEST_DIAG_BLOCKS_j1
     &                    ,SIZE_VARIABLES_DIAG_BLOCKS_j1
     &                    ,SIZE_INT, SIZE_ARITH_DEP
     &                    ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                    ,size_read,size_allocated,size_written
     &                    ,INFO)
                     SIZE_GEST_DIAG_BLOCKS=SIZE_GEST_DIAG_BLOCKS+
     &                    SIZE_GEST_DIAG_BLOCKS_j1
                     SIZE_VARIABLES_DIAG_BLOCKS=
     &                    SIZE_VARIABLES_DIAG_BLOCKS+
     &                    SIZE_VARIABLES_DIAG_BLOCKS_j1
                  ENDDO
               ELSE
                  NbRecords_BLR_STRUC_T(i1)=2
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
               ENDIF
            elseif(mode.EQ.save_mode) then
               IF(associated(BLR_STRUC%DIAG_BLOCKS)) THEN
                  NbRecords_BLR_STRUC_T(i1)=1
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  write(unit,iostat=err)
     &                 size(BLR_STRUC%DIAG_BLOCKS,1)
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  DO j1=1,size(BLR_STRUC%DIAG_BLOCKS,1)
                     CALL DMUMPS_SAVE_RESTORE_DIAG_BLOCK(
     &                    BLR_STRUC%DIAG_BLOCKS(j1)
     &                    ,unit,MYID,save_mode
     &                    ,SIZE_GEST_DIAG_BLOCKS_j1
     &                    ,SIZE_VARIABLES_DIAG_BLOCKS_j1
     &                    ,SIZE_INT, SIZE_ARITH_DEP
     &                    ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                    ,size_read,size_allocated,size_written
     &                    ,INFO)
                     IF ( INFO(1) .LT. 0 ) GOTO 100
                  ENDDO
               ELSE
                  NbRecords_BLR_STRUC_T(i1)=2
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  write(unit,iostat=err) -999
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
                  write(unit,iostat=err) -999
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
               ENDIF 
            elseif(mode.EQ.restore_mode) then
               nullify(BLR_STRUC%DIAG_BLOCKS)
               read(unit,iostat=err) size_array1
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
               if(size_array1.EQ.-999) then
                  NbRecords_BLR_STRUC_T(i1)=2
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  read(unit,iostat=err) dummy
                  if(err.ne.0) THEN
                     INFO(1) = -75
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                    ,INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 100
               else
                  NbRecords_BLR_STRUC_T(i1)=1
                  SIZE_GEST_BLR_STRUC_T(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_STRUC_T(i1)=0
                  allocate(BLR_STRUC%DIAG_BLOCKS(size_array1)
     &                 , stat=allocok)
                  if (allocok .GT. 0) THEN
                     INFO(1) = -78
                     CALL MUMPS_SETI8TOI4(
     &                    TOTAL_STRUC_SIZE-size_allocated
     &                    ,INFO(2))
                  endif
                  DO j1=1,size_array1
                     CALL DMUMPS_SAVE_RESTORE_DIAG_BLOCK(
     &                    BLR_STRUC%DIAG_BLOCKS(j1)
     &                    ,unit,MYID,restore_mode
     &                    ,SIZE_GEST_DIAG_BLOCKS_j1
     &                    ,SIZE_VARIABLES_DIAG_BLOCKS_j1
     &                    ,SIZE_INT, SIZE_ARITH_DEP
     &                    ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                    ,size_read,size_allocated,size_written
     &                    ,INFO)
                     SIZE_GEST_DIAG_BLOCKS=SIZE_GEST_DIAG_BLOCKS+
     &                    SIZE_GEST_DIAG_BLOCKS_j1
                     SIZE_VARIABLES_DIAG_BLOCKS=
     &                    SIZE_VARIABLES_DIAG_BLOCKS+
     &                    SIZE_VARIABLES_DIAG_BLOCKS_j1
                  ENDDO
               endif
            endif
         CASE(B_NFS4FATHER)
            NbRecords_BLR_STRUC_T(i1)=1
            if(mode.EQ.memory_save_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_INT
            elseif(mode.EQ.save_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_INT
               write(unit,iostat=err) BLR_STRUC%NFS4FATHER
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 100
            elseif(mode.EQ.restore_mode) then
               SIZE_VARIABLES_BLR_STRUC_T(i1)=SIZE_INT
               read(unit,iostat=err) BLR_STRUC%NFS4FATHER
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif 
               IF (INFO(1) .LT. 0 ) GOTO 100
            endif
            CASE(B_M_ARRAY)
               if(mode.EQ.restore_mode) then
                  nullify(BLR_STRUC%M_ARRAY)
               endif
         CASE DEFAULT
         END SELECT
         if(mode.EQ.memory_save_mode) then
            NbSubRecords=int(SIZE_VARIABLES_BLR_STRUC_T(i1)/huge(I4))
            IF(NbSubRecords.GT.0) then
               NbRecords_BLR_STRUC_T(i1)=NbRecords_BLR_STRUC_T(i1)
     &              +NbSubRecords
            ENDIF
         elseif(mode.EQ.save_mode) then
            size_written=size_written+SIZE_VARIABLES_BLR_STRUC_T(i1)
     &           +int(SIZE_GEST_BLR_STRUC_T(i1),kind=8)
#if defined(MUMPS_NOF2003)
            size_written=size_written
     &           +int(2*SIZE_INT*NbRecords_BLR_STRUC_T(i1),kind=8)
#endif
         elseif(mode.EQ.restore_mode) then
            size_allocated=size_allocated+
     &           SIZE_VARIABLES_BLR_STRUC_T(i1)
            size_read=size_read+SIZE_VARIABLES_BLR_STRUC_T(i1)
     &           +int(SIZE_GEST_BLR_STRUC_T(i1),kind=8)
#if defined(MUMPS_NOF2003)
            size_read=size_read
     &           +int(2*SIZE_INT*NbRecords_BLR_STRUC_T(i1),kind=8)
#endif
         endif
      ENDDO
      if(mode.EQ.memory_save_mode) then
         Local_SIZE_VARIABLES=sum(SIZE_VARIABLES_BLR_STRUC_T)
     &        +SIZE_VARIABLES_PANELS_L
     &        +SIZE_VARIABLES_PANELS_U
     &        +SIZE_VARIABLES_CB_LRB
     &        +SIZE_VARIABLES_DIAG_BLOCKS
         Local_SIZE_GEST=sum(SIZE_GEST_BLR_STRUC_T)
     &        +SIZE_GEST_PANELS_L
     &        +SIZE_GEST_PANELS_U
     &        +SIZE_GEST_CB_LRB
     &        +SIZE_GEST_DIAG_BLOCKS
#if defined(MUMPS_NOF2003)
         Local_NbRecords=sum(NbRecords_BLR_STRUC_T)
         Local_SIZE_GEST=Local_SIZE_GEST+2*SIZE_INT*Local_NbRecords
#endif
      endif
 100  continue
      RETURN
      END SUBROUTINE DMUMPS_SAVE_RESTORE_BLR_STRUC
      SUBROUTINE DMUMPS_SAVE_RESTORE_LRB(LRB_T
     &     ,unit,MYID,mode
     &     ,Local_SIZE_GEST,Local_SIZE_VARIABLES
     &     ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &     ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &     ,size_read,size_allocated,size_written
     &     ,INFO)
      INCLUDE 'mpif.h'
      TYPE(LRB_TYPE) :: LRB_T
      INTEGER,intent(IN)::unit,MYID
      INTEGER,intent(IN) :: mode
      INTEGER,INTENT(OUT) :: Local_SIZE_GEST
      INTEGER(8),intent(OUT) :: Local_SIZE_VARIABLES
      INTEGER,intent(INOUT):: INFO(2)
      INTEGER,intent(IN):: SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
      INTEGER(8),intent(IN) :: TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
      INTEGER(8),intent(INOUT):: size_read,size_allocated,size_written
      INTEGER, PARAMETER :: LRB_Q=1
      INTEGER, PARAMETER :: LRB_R=2
      INTEGER, PARAMETER :: LRB_K=3
      INTEGER, PARAMETER :: LRB_M=4
      INTEGER, PARAMETER :: LRB_N=5
      INTEGER, PARAMETER :: LRB_ISLR=6
      INTEGER, PARAMETER :: NBVARIABLES_LRB_TYPE=6
      INTEGER(8),dimension(NBVARIABLES_LRB_TYPE)::
     &     SIZE_VARIABLES_LRB_TYPE
      INTEGER,dimension(NBVARIABLES_LRB_TYPE)::
     &     SIZE_GEST_LRB_TYPE
      INTEGER,dimension(NBVARIABLES_LRB_TYPE)::
     &     NbRecords_LRB_TYPE
      INTEGER:: size_array1,size_array2,dummy,allocok
      INTEGER:: err,i1,NbSubRecords
#if defined(MUMPS_NOF2003)
      INTEGER:: Local_NbRecords
#endif
      INTEGER(4) ::I4
      SIZE_VARIABLES_LRB_TYPE(:)=0_8
      SIZE_GEST_LRB_TYPE(:)=0
      NbRecords_LRB_TYPE(:)=0
      DO i1=1,NBVARIABLES_LRB_TYPE
         SELECT CASE(i1)
         CASE(LRB_Q)
            NbRecords_LRB_TYPE(i1)=2
            if(mode.EQ.memory_save_mode) then
               IF(associated(LRB_T%Q)) THEN
                  SIZE_GEST_LRB_TYPE(i1)=SIZE_INT*2
                  SIZE_VARIABLES_LRB_TYPE(i1)=
     &                 size(LRB_T%Q,1)*size(LRB_T%Q,2)
     &                 *     SIZE_ARITH_DEP
               ELSE
                  SIZE_GEST_LRB_TYPE(i1)=SIZE_INT*3
                  SIZE_VARIABLES_LRB_TYPE(i1)=0
               ENDIF
            elseif(mode.EQ.save_mode) then
               IF(associated(LRB_T%Q)) THEN
                  SIZE_GEST_LRB_TYPE(i1)=SIZE_INT*2
                  SIZE_VARIABLES_LRB_TYPE(i1)=
     &                 size(LRB_T%Q,1)*size(LRB_T%Q,2)
     &                 *     SIZE_ARITH_DEP
                  write(unit,iostat=err) size(LRB_T%Q,1),size(LRB_T%Q,2)
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 300
                  write(unit,iostat=err) LRB_T%Q
               ELSE
                  SIZE_GEST_LRB_TYPE(i1)=SIZE_INT*3
                  SIZE_VARIABLES_LRB_TYPE(i1)=0
                  write(unit,iostat=err) -999,-998
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 300
                  write(unit,iostat=err) -999
               ENDIF 
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 300
            elseif(mode.EQ.restore_mode) then
               nullify(LRB_T%Q)
               read(unit,iostat=err) size_array1,size_array2
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 300
               if(size_array1.EQ.-999) then
                  SIZE_GEST_LRB_TYPE(i1)=SIZE_INT*3
                  SIZE_VARIABLES_LRB_TYPE(i1)=0
                  read(unit,iostat=err) dummy
               else
                  SIZE_GEST_LRB_TYPE(i1)=SIZE_INT*2
                  SIZE_VARIABLES_LRB_TYPE(i1)=
     &                 size_array1*size_array2*SIZE_ARITH_DEP
                  allocate(LRB_T%Q(size_array1,size_array2),
     &                 stat=allocok)
                  if (allocok .GT. 0) THEN
                     INFO(1) = -78
                     CALL MUMPS_SETI8TOI4(
     &                    TOTAL_STRUC_SIZE-size_allocated
     &                    ,INFO(2))
                  endif
                  read(unit,iostat=err) LRB_T%Q
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 300
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 300
            endif
         CASE(LRB_R)
            NbRecords_LRB_TYPE(i1)=2
            if(mode.EQ.memory_save_mode) then
               IF(associated(LRB_T%R)) THEN
                  SIZE_GEST_LRB_TYPE(i1)=SIZE_INT*2
                  SIZE_VARIABLES_LRB_TYPE(i1)=
     &                 size(LRB_T%R,1)*size(LRB_T%R,2)
     &                 *     SIZE_ARITH_DEP
               ELSE
                  SIZE_GEST_LRB_TYPE(i1)=SIZE_INT*3
                  SIZE_VARIABLES_LRB_TYPE(i1)=0
               ENDIF
            elseif(mode.EQ.save_mode) then
               IF(associated(LRB_T%R)) THEN
                  SIZE_GEST_LRB_TYPE(i1)=SIZE_INT*2
                  SIZE_VARIABLES_LRB_TYPE(i1)=
     &                 size(LRB_T%R,1)*size(LRB_T%R,2)
     &                 *     SIZE_ARITH_DEP
                  write(unit,iostat=err) size(LRB_T%R,1),size(LRB_T%R,2)
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 300
                  write(unit,iostat=err) LRB_T%R
               ELSE
                  SIZE_GEST_LRB_TYPE(i1)=SIZE_INT*3
                  SIZE_VARIABLES_LRB_TYPE(i1)=0
                  write(unit,iostat=err) -999,-998
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 300
                  write(unit,iostat=err) -999
               ENDIF 
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 300
            elseif(mode.EQ.restore_mode) then
               nullify(LRB_T%R)
               read(unit,iostat=err) size_array1,size_array2
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 300
               if(size_array1.EQ.-999) then
                  SIZE_GEST_LRB_TYPE(i1)=SIZE_INT*3
                  SIZE_VARIABLES_LRB_TYPE(i1)=0
                  read(unit,iostat=err) dummy
               else
                  SIZE_GEST_LRB_TYPE(i1)=SIZE_INT*2
                  SIZE_VARIABLES_LRB_TYPE(i1)=
     &                 size_array1*size_array2*SIZE_ARITH_DEP
                  allocate(LRB_T%R(size_array1,size_array2),
     &                 stat=allocok)
                  if (allocok .GT. 0) THEN
                     INFO(1) = -78
                     CALL MUMPS_SETI8TOI4(
     &                    TOTAL_STRUC_SIZE-size_allocated
     &                    ,INFO(2))
                  endif
                  read(unit,iostat=err) LRB_T%R
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 300
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 300
            endif
         CASE(LRB_K)
            NbRecords_LRB_TYPE(i1)=1
            if(mode.EQ.memory_save_mode) then
               SIZE_VARIABLES_LRB_TYPE(i1)=SIZE_INT
            elseif(mode.EQ.save_mode) then
               SIZE_VARIABLES_LRB_TYPE(i1)=SIZE_INT
               write(unit,iostat=err) LRB_T%K
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 300
            elseif(mode.EQ.restore_mode) then
               SIZE_VARIABLES_LRB_TYPE(i1)=SIZE_INT
               read(unit,iostat=err) LRB_T%K
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif 
               IF ( INFO(1) .LT. 0 ) GOTO 300
            endif
         CASE(LRB_M)
            NbRecords_LRB_TYPE(i1)=1
            if(mode.EQ.memory_save_mode) then
               SIZE_VARIABLES_LRB_TYPE(i1)=SIZE_INT
            elseif(mode.EQ.save_mode) then
               SIZE_VARIABLES_LRB_TYPE(i1)=SIZE_INT
               write(unit,iostat=err) LRB_T%M
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 300
            elseif(mode.EQ.restore_mode) then
               SIZE_VARIABLES_LRB_TYPE(i1)=SIZE_INT
               read(unit,iostat=err) LRB_T%M
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif 
               IF ( INFO(1) .LT. 0 ) GOTO 300
            endif
         CASE(LRB_N)
            NbRecords_LRB_TYPE(i1)=1
            if(mode.EQ.memory_save_mode) then
               SIZE_VARIABLES_LRB_TYPE(i1)=SIZE_INT
            elseif(mode.EQ.save_mode) then
               SIZE_VARIABLES_LRB_TYPE(i1)=SIZE_INT
               write(unit,iostat=err) LRB_T%N
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 300
            elseif(mode.EQ.restore_mode) then
               SIZE_VARIABLES_LRB_TYPE(i1)=SIZE_INT
               read(unit,iostat=err) LRB_T%N
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif 
               IF ( INFO(1) .LT. 0 ) GOTO 300
            endif
         CASE(LRB_ISLR)
            NbRecords_LRB_TYPE(i1)=1
            if(mode.EQ.memory_save_mode) then
               SIZE_VARIABLES_LRB_TYPE(i1)=SIZE_LOGICAL
            elseif(mode.EQ.save_mode) then
               SIZE_VARIABLES_LRB_TYPE(i1)=SIZE_LOGICAL
               write(unit,iostat=err) LRB_T%ISLR
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 300
            elseif(mode.EQ.restore_mode) then
               SIZE_VARIABLES_LRB_TYPE(i1)=SIZE_LOGICAL
               read(unit,iostat=err) LRB_T%ISLR
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif 
               IF ( INFO(1) .LT. 0 ) GOTO 300
            endif   
         CASE DEFAULT
         END SELECT
         if(mode.EQ.memory_save_mode) then
            NbSubRecords=int(SIZE_VARIABLES_LRB_TYPE(i1)/huge(I4))
            IF(NbSubRecords.GT.0) then
               NbRecords_LRB_TYPE(i1)=
     &              NbRecords_LRB_TYPE(i1)
     &              +NbSubRecords
            ENDIF
         elseif(mode.EQ.save_mode) then
            size_written=size_written+SIZE_VARIABLES_LRB_TYPE(i1)
     &           +int(SIZE_GEST_LRB_TYPE(i1),kind=8)
#if defined(MUMPS_NOF2003)
            size_written=size_written
     &           +int(2*SIZE_INT*NbRecords_LRB_TYPE(i1),kind=8)
#endif
         elseif(mode.EQ.restore_mode) then
            size_allocated=size_allocated+
     &           SIZE_VARIABLES_LRB_TYPE(i1)
            size_read=size_read+SIZE_VARIABLES_LRB_TYPE(i1)
     &           +int(SIZE_GEST_LRB_TYPE(i1),kind=8)
#if defined(MUMPS_NOF2003)
            size_read=size_read
     &           +int(2*SIZE_INT*NbRecords_LRB_TYPE(i1),kind=8)
#endif
         endif
      ENDDO
      if(mode.EQ.memory_save_mode) then
         Local_SIZE_VARIABLES=sum(SIZE_VARIABLES_LRB_TYPE)
         Local_SIZE_GEST=sum(SIZE_GEST_LRB_TYPE)
#if defined(MUMPS_NOF2003)
         Local_NbRecords=sum(NbRecords_LRB_TYPE)
         Local_SIZE_GEST=Local_SIZE_GEST+2*SIZE_INT*Local_NbRecords
#endif
      endif
 300  continue
      RETURN
      END SUBROUTINE DMUMPS_SAVE_RESTORE_LRB
      SUBROUTINE DMUMPS_SAVE_RESTORE_BLR_PANEL(BLR_PANEL_T
     &     ,unit,MYID,mode
     &     ,Local_SIZE_GEST,Local_SIZE_VARIABLES
     &     ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &     ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &     ,size_read,size_allocated,size_written
     &     ,INFO)
      INCLUDE 'mpif.h'
      TYPE(blr_panel_type) :: BLR_PANEL_T
      INTEGER,intent(IN)::unit,MYID
      INTEGER,intent(IN) :: mode
      INTEGER,INTENT(OUT) :: Local_SIZE_GEST
      INTEGER(8),intent(OUT) :: Local_SIZE_VARIABLES
      INTEGER,intent(INOUT):: INFO(2)
      INTEGER,intent(IN):: SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
      INTEGER(8),intent(IN) :: TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
      INTEGER(8),intent(INOUT):: size_read,size_allocated,size_written
      INTEGER, PARAMETER :: P_NB_ACCESSES_LEFT=1
      INTEGER, PARAMETER :: P_LRB_PANEL=2
      INTEGER, PARAMETER :: NBVARIABLES_BLR_PANEL_TYPE = 2
      INTEGER(8),dimension(NBVARIABLES_BLR_PANEL_TYPE)::
     &     SIZE_VARIABLES_BLR_PANEL_TYPE
      INTEGER,dimension(NBVARIABLES_BLR_PANEL_TYPE)::
     &     SIZE_GEST_BLR_PANEL_TYPE
      INTEGER,dimension(NBVARIABLES_BLR_PANEL_TYPE)::
     &     NbRecords_BLR_PANEL_TYPE
      INTEGER:: size_array1,dummy,allocok
      INTEGER:: err,i1,j1,NbSubRecords
#if defined(MUMPS_NOF2003)
      INTEGER:: Local_NbRecords
#endif
      INTEGER:: SIZE_GEST_LRB_PANEL_j1,SIZE_GEST_LRB_PANEL
      INTEGER(8)::SIZE_VARIABLES_LRB_PANEL_j1,SIZE_VARIABLES_LRB_PANEL
      INTEGER(4)::I4
      SIZE_VARIABLES_BLR_PANEL_TYPE(:)=0_8
      SIZE_GEST_BLR_PANEL_TYPE(:)=0
      NbRecords_BLR_PANEL_TYPE(:)=0
      SIZE_GEST_LRB_PANEL_j1=0
      SIZE_GEST_LRB_PANEL=0
      SIZE_VARIABLES_LRB_PANEL_j1=0_8
      SIZE_VARIABLES_LRB_PANEL=0_8
      DO i1=1,NBVARIABLES_BLR_PANEL_TYPE
         SELECT CASE(i1)
         CASE(P_NB_ACCESSES_LEFT)
            NbRecords_BLR_PANEL_TYPE(i1)=1
            if(mode.EQ.memory_save_mode) then
               SIZE_VARIABLES_BLR_PANEL_TYPE(i1)=SIZE_INT
            elseif(mode.EQ.save_mode) then
               SIZE_VARIABLES_BLR_PANEL_TYPE(i1)=SIZE_INT
               write(unit,iostat=err) BLR_PANEL_T%NB_ACCESSES_LEFT
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 400
            elseif(mode.EQ.restore_mode) then
               SIZE_VARIABLES_BLR_PANEL_TYPE(i1)=SIZE_INT
               read(unit,iostat=err) BLR_PANEL_T%NB_ACCESSES_LEFT
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif 
               IF ( INFO(1) .LT. 0 ) GOTO 400
            endif
         CASE(P_LRB_PANEL)
            if(mode.EQ.memory_save_mode) then
               IF(associated(BLR_PANEL_T%LRB_PANEL)) THEN
                  NbRecords_BLR_PANEL_TYPE(i1)=1
                  SIZE_GEST_BLR_PANEL_TYPE(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_PANEL_TYPE(i1)=0
                  DO j1=1,size(BLR_PANEL_T%LRB_PANEL,1)
                     CALL DMUMPS_SAVE_RESTORE_LRB(
     &                    BLR_PANEL_T%LRB_PANEL(j1)
     &                    ,unit,MYID,memory_save_mode
     &                    ,SIZE_GEST_LRB_PANEL_j1
     &                    ,SIZE_VARIABLES_LRB_PANEL_j1
     &                    ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &                    ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                    ,size_read,size_allocated,size_written
     &                    ,INFO)
                     SIZE_GEST_LRB_PANEL=SIZE_GEST_LRB_PANEL+
     &                    SIZE_GEST_LRB_PANEL_j1
                     SIZE_VARIABLES_LRB_PANEL=SIZE_VARIABLES_LRB_PANEL+
     &                    SIZE_VARIABLES_LRB_PANEL_j1
                  ENDDO
               ELSE
                  NbRecords_BLR_PANEL_TYPE(i1)=2
                  SIZE_GEST_BLR_PANEL_TYPE(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_PANEL_TYPE(i1)=0
               ENDIF
            elseif(mode.EQ.save_mode) then
               IF(associated(BLR_PANEL_T%LRB_PANEL)) THEN
                  NbRecords_BLR_PANEL_TYPE(i1)=1
                  SIZE_GEST_BLR_PANEL_TYPE(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_PANEL_TYPE(i1)=0
                  write(unit,iostat=err) size(BLR_PANEL_T%LRB_PANEL,1)
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 400
                  DO j1=1,size(BLR_PANEL_T%LRB_PANEL,1)
                     CALL DMUMPS_SAVE_RESTORE_LRB(
     &                    BLR_PANEL_T%LRB_PANEL(j1)
     &                    ,unit,MYID,save_mode
     &                    ,SIZE_GEST_LRB_PANEL_j1
     &                    ,SIZE_VARIABLES_LRB_PANEL_j1
     &                    ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &                    ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                    ,size_read,size_allocated,size_written
     &                    ,INFO)
                     IF ( INFO(1) .LT. 0 ) GOTO 400
                  ENDDO
               ELSE
                  NbRecords_BLR_PANEL_TYPE(i1)=2
                  SIZE_GEST_BLR_PANEL_TYPE(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_PANEL_TYPE(i1)=0
                  write(unit,iostat=err) -999
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 400
                  write(unit,iostat=err) -999
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 400
               ENDIF 
            elseif(mode.EQ.restore_mode) then
               nullify(BLR_PANEL_T%LRB_PANEL)
               read(unit,iostat=err) size_array1
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 400
               if(size_array1.EQ.-999) then
                  NbRecords_BLR_PANEL_TYPE(i1)=2
                  SIZE_GEST_BLR_PANEL_TYPE(i1)=SIZE_INT*2
                  SIZE_VARIABLES_BLR_PANEL_TYPE(i1)=0
                  read(unit,iostat=err) dummy
                  if(err.ne.0) THEN
                     INFO(1) = -75
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                    ,INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 400
               else
                  NbRecords_BLR_PANEL_TYPE(i1)=1
                  SIZE_GEST_BLR_PANEL_TYPE(i1)=SIZE_INT
                  SIZE_VARIABLES_BLR_PANEL_TYPE(i1)=0
                  allocate(BLR_PANEL_T%LRB_PANEL(size_array1)
     &                 , stat=allocok)
                  if (allocok .GT. 0) THEN
                     INFO(1) = -78
                     CALL MUMPS_SETI8TOI4(
     &                    TOTAL_STRUC_SIZE-size_allocated
     &                    ,INFO(2))
                  endif
                  DO j1=1,size_array1
                     CALL DMUMPS_SAVE_RESTORE_LRB(
     &                    BLR_PANEL_T%LRB_PANEL(j1)
     &                    ,unit,MYID,restore_mode
     &                    ,SIZE_GEST_LRB_PANEL_j1
     &                    ,SIZE_VARIABLES_LRB_PANEL_j1
     &                    ,SIZE_INT, SIZE_ARITH_DEP, SIZE_LOGICAL
     &                    ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &                    ,size_read,size_allocated,size_written
     &                    ,INFO)
                     SIZE_GEST_LRB_PANEL=SIZE_GEST_LRB_PANEL+
     &                    SIZE_GEST_LRB_PANEL_j1
                     SIZE_VARIABLES_LRB_PANEL=SIZE_VARIABLES_LRB_PANEL+
     &                    SIZE_VARIABLES_LRB_PANEL_j1
                  ENDDO
               endif
            endif
         CASE DEFAULT
         END SELECT
         if(mode.EQ.memory_save_mode) then
            NbSubRecords=int(SIZE_VARIABLES_BLR_PANEL_TYPE(i1)/huge(I4))
            IF(NbSubRecords.GT.0) then
               NbRecords_BLR_PANEL_TYPE(i1)=
     &              NbRecords_BLR_PANEL_TYPE(i1)
     &              +NbSubRecords
            ENDIF
         elseif(mode.EQ.save_mode) then
            size_written=size_written+SIZE_VARIABLES_BLR_PANEL_TYPE(i1)
     &           +int(SIZE_GEST_BLR_PANEL_TYPE(i1),kind=8)
#if defined(MUMPS_NOF2003)
            size_written=size_written
     &           +int(2*SIZE_INT*NbRecords_BLR_PANEL_TYPE(i1),kind=8)
#endif
         elseif(mode.EQ.restore_mode) then
            size_allocated=size_allocated+
     &           SIZE_VARIABLES_BLR_PANEL_TYPE(i1)
            size_read=size_read+SIZE_VARIABLES_BLR_PANEL_TYPE(i1)
     &           +int(SIZE_GEST_BLR_PANEL_TYPE(i1),kind=8)
#if defined(MUMPS_NOF2003)
            size_read=size_read
     &           +int(2*SIZE_INT*NbRecords_BLR_PANEL_TYPE(i1),kind=8)
#endif
         endif
      ENDDO
      if(mode.EQ.memory_save_mode) then
         Local_SIZE_VARIABLES=sum(SIZE_VARIABLES_BLR_PANEL_TYPE)+
     &        SIZE_VARIABLES_LRB_PANEL
         Local_SIZE_GEST=sum(SIZE_GEST_BLR_PANEL_TYPE)+
     &        SIZE_GEST_LRB_PANEL
#if defined(MUMPS_NOF2003)
         Local_NbRecords=sum(NbRecords_BLR_PANEL_TYPE)
         Local_SIZE_GEST=Local_SIZE_GEST+2*SIZE_INT*Local_NbRecords
#endif
      endif
 400  continue
      RETURN
      END SUBROUTINE DMUMPS_SAVE_RESTORE_BLR_PANEL
      SUBROUTINE DMUMPS_SAVE_RESTORE_DIAG_BLOCK(DIAG_BLOCK_T
     &     ,unit,MYID,mode
     &     ,Local_SIZE_GEST,Local_SIZE_VARIABLES
     &     ,SIZE_INT, SIZE_ARITH_DEP
     &     ,TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
     &     ,size_read,size_allocated,size_written
     &     ,INFO)
      INCLUDE 'mpif.h'
      TYPE(diag_block_type) :: DIAG_BLOCK_T
      INTEGER,intent(IN)::unit,MYID
      INTEGER,intent(IN) :: mode
      INTEGER,INTENT(OUT) :: Local_SIZE_GEST
      INTEGER(8),intent(OUT) :: Local_SIZE_VARIABLES
      INTEGER,intent(INOUT):: INFO(2)
      INTEGER,intent(IN):: SIZE_INT, SIZE_ARITH_DEP
      INTEGER(8),intent(IN) :: TOTAL_FILE_SIZE,TOTAL_STRUC_SIZE
      INTEGER(8),intent(INOUT):: size_read,size_allocated,size_written
      INTEGER, PARAMETER :: D_DIAG_BLOCK=1
      INTEGER, PARAMETER :: NBVARIABLES_DIAG_BLOCK_TYPE = 1
      INTEGER(8),dimension(NBVARIABLES_DIAG_BLOCK_TYPE)::
     &     SIZE_VARIABLES_DIAG_BLOCK_TYPE
      INTEGER,dimension(NBVARIABLES_DIAG_BLOCK_TYPE)::
     &     SIZE_GEST_DIAG_BLOCK_TYPE
      INTEGER,dimension(NBVARIABLES_DIAG_BLOCK_TYPE)::
     &     NbRecords_DIAG_BLOCK_TYPE
      INTEGER:: size_array1,dummy,allocok
      INTEGER:: err,i1,NbSubRecords
#if defined(MUMPS_NOF2003)
      INTEGER:: Local_NbRecords
#endif
      INTEGER(4) :: I4
      SIZE_VARIABLES_DIAG_BLOCK_TYPE(:)=0_8
      SIZE_GEST_DIAG_BLOCK_TYPE(:)=0
      NbRecords_DIAG_BLOCK_TYPE(:)=0
      DO i1=1,NBVARIABLES_DIAG_BLOCK_TYPE
         SELECT CASE(i1)
         CASE(D_DIAG_BLOCK)
            NbRecords_DIAG_BLOCK_TYPE(i1)=2
            if(mode.EQ.memory_save_mode) then
               IF(associated(DIAG_BLOCK_T%DIAG_BLOCK)) THEN
                  SIZE_GEST_DIAG_BLOCK_TYPE(i1)=SIZE_INT
                  SIZE_VARIABLES_DIAG_BLOCK_TYPE(i1)=
     &                 size(DIAG_BLOCK_T%DIAG_BLOCK,1)
     &                 *     SIZE_ARITH_DEP
               ELSE
                  SIZE_GEST_DIAG_BLOCK_TYPE(i1)=SIZE_INT*2
                  SIZE_VARIABLES_DIAG_BLOCK_TYPE(i1)=0
               ENDIF
            elseif(mode.EQ.save_mode) then
               IF(associated(DIAG_BLOCK_T%DIAG_BLOCK)) THEN
                  SIZE_GEST_DIAG_BLOCK_TYPE(i1)=SIZE_INT
                  SIZE_VARIABLES_DIAG_BLOCK_TYPE(i1)=
     &                 size(DIAG_BLOCK_T%DIAG_BLOCK,1)
     &                 *     SIZE_ARITH_DEP
                  write(unit,iostat=err) size(DIAG_BLOCK_T%DIAG_BLOCK,1)
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 200
                  write(unit,iostat=err) DIAG_BLOCK_T%DIAG_BLOCK
               ELSE
                  SIZE_GEST_DIAG_BLOCK_TYPE(i1)=SIZE_INT*2
                  SIZE_VARIABLES_DIAG_BLOCK_TYPE(i1)=0
                  write(unit,iostat=err) -999
                  if(err.ne.0) then
                     INFO(1) = -72
                     CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                    INFO(2))
                  endif
                  IF ( INFO(1) .LT. 0 ) GOTO 200
                  write(unit,iostat=err) -999
               ENDIF 
               if(err.ne.0) then
                  INFO(1) = -72
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_written,
     &                 INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 200
            elseif(mode.EQ.restore_mode) then
               nullify(DIAG_BLOCK_T%DIAG_BLOCK)
               read(unit,iostat=err) size_array1
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
               endif
               IF ( INFO(1) .LT. 0 ) GOTO 200
               if(size_array1.EQ.-999) then
                  SIZE_GEST_DIAG_BLOCK_TYPE(i1)=SIZE_INT*2
                  SIZE_VARIABLES_DIAG_BLOCK_TYPE(i1)=0
                  read(unit,iostat=err) dummy
               else
                  SIZE_GEST_DIAG_BLOCK_TYPE(i1)=SIZE_INT
                  SIZE_VARIABLES_DIAG_BLOCK_TYPE(i1)=
     &                 size_array1*SIZE_ARITH_DEP
                  allocate(DIAG_BLOCK_T%DIAG_BLOCK(size_array1),
     &                 stat=allocok)
                  if (allocok .GT. 0) THEN
                     INFO(1) = -78
                     CALL MUMPS_SETI8TOI4(
     &                    TOTAL_STRUC_SIZE-size_allocated
     &                    ,INFO(2))
                     GOTO 200
                  endif
                  read(unit,iostat=err) DIAG_BLOCK_T%DIAG_BLOCK
               endif
               if(err.ne.0) THEN
                  INFO(1) = -75
                  CALL MUMPS_SETI8TOI4(TOTAL_FILE_SIZE-size_read
     &                 ,INFO(2))
                  GOTO 200
               endif
            endif
         CASE DEFAULT
         END SELECT
         if(mode.EQ.memory_save_mode) then
            NbSubRecords=int(SIZE_VARIABLES_DIAG_BLOCK_TYPE(i1)/
     &      huge(I4))
            IF(NbSubRecords.GT.0) then
               NbRecords_DIAG_BLOCK_TYPE(i1)=
     &              NbRecords_DIAG_BLOCK_TYPE(i1)
     &              +NbSubRecords
            ENDIF
         elseif(mode.EQ.save_mode) then
            size_written=size_written+SIZE_VARIABLES_DIAG_BLOCK_TYPE(i1)
     &           +int(SIZE_GEST_DIAG_BLOCK_TYPE(i1),kind=8)
#if defined(MUMPS_NOF2003)
            size_written=size_written
     &           +int(2*SIZE_INT*NbRecords_DIAG_BLOCK_TYPE(i1),kind=8)
#endif
         elseif(mode.EQ.restore_mode) then
            size_allocated=size_allocated+
     &           SIZE_VARIABLES_DIAG_BLOCK_TYPE(i1)
            size_read=size_read+SIZE_VARIABLES_DIAG_BLOCK_TYPE(i1)
     &           +int(SIZE_GEST_DIAG_BLOCK_TYPE(i1),kind=8)
#if defined(MUMPS_NOF2003)
            size_read=size_read
     &           +int(2*SIZE_INT*NbRecords_DIAG_BLOCK_TYPE(i1),kind=8)
#endif
         endif
      ENDDO
      if(mode.EQ.memory_save_mode) then
         Local_SIZE_VARIABLES=sum(SIZE_VARIABLES_DIAG_BLOCK_TYPE)
         Local_SIZE_GEST=sum(SIZE_GEST_DIAG_BLOCK_TYPE)
#if defined(MUMPS_NOF2003)
         Local_NbRecords=sum(NbRecords_DIAG_BLOCK_TYPE)
         Local_SIZE_GEST=Local_SIZE_GEST+2*SIZE_INT*Local_NbRecords
#endif
      endif
 200  continue
      RETURN
      END SUBROUTINE DMUMPS_SAVE_RESTORE_DIAG_BLOCK
#endif
      END MODULE DMUMPS_LR_DATA_M
