
/*
 * $Header: /cvsroot/mpdist/mpdist/mimep/text2latex/cutlines.c,v 1.1.1.1 2002/04/12 16:47:26 richbastard Exp $
 * 
 * Copyright (c) Mikael Cam. All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * This command wraps the lines of a text. The maximum length of a line is
 * determined with the environment variable MIMEPMAXCH, initialized by Mimep.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../../common/option.h"

static int _TRACE = 0;

#define MIMEPMAXCH  "MIMEPMAXCH"
#define DEFMAXCAR   80
#define MIMEMAXLINE 4096
#define EOS         '\0'
#define SPACE       ' '
#define TAB         '\t'
#define T(toto)     (void) fprintf(stderr, "%s\n", toto)
#define True        1
#define False       0

static char *usage = "Usage: cutlines [input_file] (else stdin)\n";


static int 
cutlines(char *filename)
{
    char *ERR[] = {
        "Erreur lors de l'ouverture du fichier source\n"
    };

    FILE *fp;
    char carcour, *maxchstr, lignecour[MIMEMAXLINE], *souschaine;
    int  j, lastspace, lastCR, maxcar;

    if (!(maxchstr = getenv(MIMEPMAXCH))) {
        maxcar = DEFMAXCAR;
    } else {
        maxcar = (int) strtol(maxchstr, NULL, 10);
    }

    if (_TRACE) {
        FPRINTF(stderr, "Maxcar: %d\n", maxcar);
    }

    if (!strcmp(filename, "stdin")) {
        fp = stdin;
    } else if (!(fp = fopen(filename, "r"))) {
        FPRINTF(stderr, "%s", ERR[0]);
        return(1);
    }
    if (_TRACE) {
        T("Fichier ouvert!");
    }

    while (!feof(fp)) {
        if (!fgets(lignecour, MIMEMAXLINE, fp)) {
            lignecour[0] = EOS;
        }

        if (strlen(lignecour) <= maxcar) {
            FPRINTF(stdout, "%s", lignecour);
        } else {
            j = 0;
            lastCR = 0;
            lastspace = 0;

            while (lignecour[lastCR + j] != EOS) {
                carcour = lignecour[lastCR + j];

                if ((carcour == SPACE) || (carcour == TAB)) {
                    lastspace = j;
                }

                if (j > maxcar - 1) {
                    if (lastspace) {
                        souschaine = (char *) malloc(sizeof(char) * 
                                                     (lastspace + 1));
                        STRNCPY(souschaine, lignecour + lastCR, lastspace);
                        souschaine[lastspace] = EOS;
                        FPRINTF(stdout, "%s\n", souschaine);
                        lastCR = lastCR + lastspace + 1;
                        j = 0;
                        lastspace = 0;
                    } else {
                        souschaine = (char *) malloc(sizeof(char) * (j + 1));
                        STRNCPY(souschaine, lignecour + lastCR, j);
                        souschaine[j] = EOS;
                        FPRINTF(stdout, "%s\n", souschaine);
                        lastCR = lastCR + j;
                        j = 0;
                        lastspace = 0;
                    }

                    free(souschaine);
                } else {
                    if (lignecour[lastCR + j + 1] == EOS) {
                        souschaine = (char *) malloc(sizeof(char) * (j + 1));
                        STRNCPY(souschaine, lignecour + lastCR, j + 1);
                        souschaine[j] = EOS;
                        FPRINTF(stdout, "%s\n", souschaine);
                        free(souschaine);
                    }
                    j++;
                }
            }
        }
    }

    return(0);
}


int 
main(int argc, char *argv[])
{
    char fichier[50];

    switch (argc) {
        case 1:
            STRCPY(fichier, "stdin");
            break;
        case 2:
            STRCPY(fichier, argv[1]);
            break;
        default:
            FPRINTF(stderr, "%s", usage);
            exit(1);
    }

    return(cutlines(fichier));
}
