[comment {-*- tcl -*- doctools}]
[manpage_begin random n 2.2]
[moddesc   {Memory channels}]
[titledesc {Create and manipulate randomizer channels}]
[copyright {2004 Pat Thoyts <patthoyts@users.sourceforge.net>}]
[require Tcl]
[require memchan]
[description]

[list_begin definitions]

[call [cmd random]]

creates a random channel which absorbs everything written into it and
uses it as a seed for a random number generator. This generator is
used to create a random sequence of bytes when reading from the
channel. It is not possible to seek the channel.

[list_end]

[section OPTIONS]

Memory channels created by [cmd random] provide one additional option to
set or query.

[list_begin definitions]

    [lst_item [arg "-delay [opt milliseconds]"]]

    A [cmd random] channel is always writable and readable. This means
    that all [cmd fileevent]-handlers will fire continuously.  To
    avoid starvation of other event sources the events raised by this
    channel type have a configurable delay. This option is set in
    milliseconds and defaults to 5.

[list_end]

[see_also memchan fifo fifo2 null zero]
[keywords random {in-memory channel} channel i/o]
[manpage_end]
