# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class TimePointUtility(Object):
    r"""
    TimePointUtility - performs common time operations
    
    Superclass: Object
    
    TimePointUtility is provides methods to perform common time
    operations.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTimePointUtility, obj, update, **traits)
    
    def get_date(self, *args):
        """
        get_date(time:int, year:int, month:int, day:int) -> None
        C++: static void get_date(TypeUInt64 time, int &year,
            int &month, int &day)
        Retrieve the year, month, and day of a time point. Everything but
        the first argument are output parameters.
        """
        ret = self._wrap_call(self._vtk_obj.GetDate, *args)
        return ret

    def get_date_time(self, *args):
        """
        get_date_time(time:int, year:int, month:int, day:int, hour:int,
            minute:int, second:int, millis:int) -> None
        C++: static void get_date_time(TypeUInt64 time, int &year,
            int &month, int &day, int &hour, int &minute, int &second,
            int &millis)
        Retrieve the date and time of a time point. Everything but the
        first argument are output parameters.
        """
        ret = self._wrap_call(self._vtk_obj.GetDateTime, *args)
        return ret

    def get_day(self, *args):
        """
        get_day(time:int) -> int
        C++: static int get_day(TypeUInt64 time)
        Retrieve the day of the month from a time point.
        """
        ret = self._wrap_call(self._vtk_obj.GetDay, *args)
        return ret

    def get_hour(self, *args):
        """
        get_hour(time:int) -> int
        C++: static int get_hour(TypeUInt64 time)
        Retrieve the hour of the day from the time point.
        """
        ret = self._wrap_call(self._vtk_obj.GetHour, *args)
        return ret

    def get_millisecond(self, *args):
        """
        get_millisecond(time:int) -> int
        C++: static int get_millisecond(TypeUInt64 time)
        Retrieve the milliseconds from the start of the last second.
        """
        ret = self._wrap_call(self._vtk_obj.GetMillisecond, *args)
        return ret

    def get_minute(self, *args):
        """
        get_minute(time:int) -> int
        C++: static int get_minute(TypeUInt64 time)
        Retrieve the number of minutes from the start of the last hour.
        """
        ret = self._wrap_call(self._vtk_obj.GetMinute, *args)
        return ret

    def get_month(self, *args):
        """
        get_month(time:int) -> int
        C++: static int get_month(TypeUInt64 time)
        Retrieve the month from a time point.
        """
        ret = self._wrap_call(self._vtk_obj.GetMonth, *args)
        return ret

    def get_second(self, *args):
        """
        get_second(time:int) -> int
        C++: static int get_second(TypeUInt64 time)
        Retrieve the number of seconds from the start of the last minute.
        """
        ret = self._wrap_call(self._vtk_obj.GetSecond, *args)
        return ret

    def get_time(self, *args):
        """
        get_time(time:int, hour:int, minute:int, second:int, millis:int)
            -> None
        C++: static void get_time(TypeUInt64 time, int &hour,
            int &minute, int &second, int &millis)
        Retrieve the hour, minute, second, and milliseconds of a time
        point. Everything but the first argument are output parameters.
        """
        ret = self._wrap_call(self._vtk_obj.GetTime, *args)
        return ret

    def get_year(self, *args):
        """
        get_year(time:int) -> int
        C++: static int get_year(TypeUInt64 time)
        Retrieve the year from a time point.
        """
        ret = self._wrap_call(self._vtk_obj.GetYear, *args)
        return ret

    def date_time_to_time_point(self, *args):
        """
        date_time_to_time_point(year:int, month:int, day:int, hour:int,
            minute:int, sec:int, millis:int=0) -> int
        C++: static TypeUInt64 date_time_to_time_point(int year, int month,
             int day, int hour, int minute, int sec, int millis=0)
        Return the time point for a date and time.
        """
        ret = self._wrap_call(self._vtk_obj.DateTimeToTimePoint, *args)
        return ret

    def date_to_time_point(self, *args):
        """
        date_to_time_point(year:int, month:int, day:int) -> int
        C++: static TypeUInt64 date_to_time_point(int year, int month,
            int day)
        Return the time point for 12:00am on a specified day.
        """
        ret = self._wrap_call(self._vtk_obj.DateToTimePoint, *args)
        return ret

    def iso8601_to_time_point(self, *args):
        """
        iso8601_to_time_point(str:str, ok:[bool, ...]=...) -> int
        C++: static TypeUInt64 iso8601_to_time_point(const char *str,
            bool *ok=nullptr)
        Converts a ISO8601 string into a VTK timepoint. The string must
        follow one of the ISO8601 formats described in to_iso8601.  To
        check for a valid format, pass a bool* as the second argument. 
        The value will be set to true if the string was parsed
        successfully, false otherwise.
        """
        ret = self._wrap_call(self._vtk_obj.ISO8601ToTimePoint, *args)
        return ret

    def time_point_to_iso8601(self, *args):
        """
        time_point_to_iso8601(__a:int, format:int=...) -> str
        C++: static const char *time_point_to_iso8601(TypeUInt64,
            int format=ISO8601_DATETIME_MILLIS)
        Converts a VTK timepoint into one of the following ISO8601
        formats.  The default format is ISO8601_DATETIME_MILLIS.
        
        *
        
        * Type                      Format / Example
        * 0 ISO8601_DATETIME_MILLIS [YYYY]-[MM]-[DD]T[hh]:[mm]:[ss].[SSS]
        * 2006-01-02T03:04:05.678
        * 1 ISO8601_DATETIME        [YYYY]-[MM]-[DD]T[hh]:[mm]:[ss]
        * 2006-01-02T03:04:05
        * 2 ISO8601_DATE            [YYYY]-[MM]-[DD]
        * 2006-01-02
        * 3 ISO8601_TIME_MILLIS     [hh]:[mm]:[ss].[SSS]
        * 03:04:05.678
        * 4 ISO8601_TIME            [hh]:[mm]:[ss]
        * 03:04:05
        * 
        """
        ret = self._wrap_call(self._vtk_obj.TimePointToISO8601, *args)
        return ret

    def time_to_time_point(self, *args):
        """
        time_to_time_point(hour:int, minute:int, second:int, millis:int=0)
            -> int
        C++: static TypeUInt64 time_to_time_point(int hour, int minute,
            int second, int millis=0)
        Return the time point for a time of day (the number of
        milliseconds from 12:00am. The hour should be from 0-23.
        """
        ret = self._wrap_call(self._vtk_obj.TimeToTimePoint, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(TimePointUtility, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit TimePointUtility properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit TimePointUtility properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit TimePointUtility properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

