function defaultStatus = emptyStatus(testsuite, testNumber)
% constructs an empty status struct
    defaultStatus = struct(...
      'function',               '', ...
      'description',            '',...
      'testsuite',              testsuite ,...
      'index',                  testNumber, ...
      'issues',                 [],...
      'unreliable',             false, ...
      'skip',                   false, ... % skipped this test?
      'closeall',               false, ... % call close all after?
      'extraOptions',           {cell(0)}, ...
      'extraCleanfigureOptions',{cell(0)}, ...
      'plotStage',              emptyStage(), ...
      'saveStage',              emptyStage(), ...
      'tikzStage',              emptyStage(), ...
      'hashStage',              emptyStage() ...
      );

    % for reliable tests explicitly define width and height, see #659
    % TODO: Remove explicitly setting this option.
    %       After #641 is merged, this might be not needed anyhow.
    defaultStatus.extraCleanfigureOptions = {'targetResolution', [1000,500]};
end
