/***************************************************************************
   cstringhash.h  -  DCLib CString Hash function for STL unordered_map/set
                             -------------------
    begin                : Fri Jun 27 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSTRINGHASH_H
#define CSTRINGHASH_H

// <dclib/dclib-stl-use.h> plus the correct <tr1/unordered_map>
// or <unordered_map> headers must be included before this file

#include <dclib/core/cstring.h>

// ok so adding a hash function for CString to the standard namespace
// is probably not the best solution... but it makes CString easier
// to use until it's replaced with std::string

namespace std
{

#if ( DCLIB_USES_TR1_UNORDERED_MAP == 1 ) || ( DCLIB_USES_TR1_UNORDERED_SET == 1 )
namespace tr1
{
#endif

// this is the same as the hash function for a std::string
// but it probably only works with recent GCC since
// _Fnv_hash is probably not part of any API
template<>
struct hash<const CString &>
{
	size_t operator() (const CString & s) const
	{
#if DCLIB_FNV_HASH_IS_PREFIXED == 1
#if DCLIB_FNV_HASH_IS_TEMPLATE == 1
		return _Fnv_hash<>::hash( s.Data(), s.Length() );
#else
		return _Fnv_hash::hash( s.Data(), s.Length() );
#endif	
#else /* DCLIB_FNV_HASH_IS_PREFIXED */
#if DCLIB_FNV_HASH_IS_TEMPLATE == 1
		return Fnv_hash<>::hash( s.Data(), s.Length() );
#else
		return Fnv_hash::hash( s.Data(), s.Length() );
#endif
#endif /* DCLIB_FNV_HASH_IS_PREFIXED */
	}
};

template<>
struct hash<CString>
{
	size_t operator() (CString s) const
	{
#if DCLIB_FNV_HASH_IS_PREFIXED == 1
#if DCLIB_FNV_HASH_IS_TEMPLATE == 1
		return _Fnv_hash<>::hash( s.Data(), s.Length() );
#else
		return _Fnv_hash::hash( s.Data(), s.Length() );
#endif
#else /* DCLIB_FNV_HASH_IS_PREFIXED */
#if DCLIB_FNV_HASH_IS_TEMPLATE == 1
		return Fnv_hash<>::hash( s.Data(), s.Length() );
#else
		return Fnv_hash::hash( s.Data(), s.Length() );
#endif
#endif /* DCLIB_FNV_HASH_IS_PREFIXED */
	}
};

#if ( DCLIB_USES_TR1_UNORDERED_MAP == 1 ) || ( DCLIB_USES_TR1_UNORDERED_SET == 1 )
}
#endif

}

#endif // CSTRINGHASH_H
