#if !defined(__HANDLER_HPP)
#define  __HANDLER_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__REQUEST_HPP)
#include <Request.hpp>
#endif

namespace   corelinux
{

   DECLARE_CLASS( Handler );

   /**
   Defines an interface for handling requests, accessing successors,
	and optionally implements the successor link. The builtin behavior
   is to allow forward and backward chaining of Handlers.
   */

   class Handler : public Synchronized
   {
   public:

      //
      // Constructors and destructors
      //

                        /// Default constructor   

                        Handler( void );

                        /// Copy constructor

                        Handler( HandlerCref );

                        /// Virtual destructor

      virtual           ~Handler( void );

      //
      // Operator overloads
      //
               /// Operator assignment

               HandlerRef  operator=( HandlerCref );

               /// Equality operator 

               bool        operator==( HandlerCref ) const;

      //
      // Accessors
      //       
               /// Returns successor or NULLPTR if end-of-chain

               HandlerPtr  operator++( void ) ;

               /// Returns predecessor or NULLPTR if end-of-chain

               HandlerPtr  operator--( void ) ;

      //
      // Mutators
      //

               /**
               Have this tie itself as the successor to the
               argument handler pointer
               @param Handler pointer to succeed
               @exception Assertion if HandlerPtr is NULLPTR
               */

               void  succeedHandler( HandlerPtr ) throw ( Assertion );

               /**
               Have this tie itself as the predecessor to the
               argument handler pointer
               @param Handler pointer to preceed.
               @exception Assertion if HandlerPtr is NULLPTR
               */

               void  precedeHandler( HandlerPtr ) throw ( Assertion );

               /// Removes links from self

               void  extractSelf( void );

               /**
               Routine which either invokes the work
               method or passes along to successor.
               First calls handleType which determines
               if work is handled here or passed on.
               @param Request pointer to request type
               */

      virtual  void  handleRequest( RequestPtr ) ;

   protected:

               /**
               Implementation required. Respond to
               type handler requests.
               @param Request pointer to request object
               to determine if this handler handles the
               request.
               @return bool true if this handler handles type
               */

      virtual  bool  handlesType( RequestPtr ) = 0;

               /**
               Implementation required. Once determined if
               type is handled, then handle it!
               @param Request pointer to request object
               */

      virtual  void  handle( RequestPtr ) = 0;

               /// Sets the objects theSuccessor member

               void  setSuccessor( HandlerPtr ) ;

               /// Sets the objects thePredecessor member

               void  setPredecessor( HandlerPtr ) ;

               /// Sets the object siblings as atomic operation

               void  setSiblings( HandlerPtr, HandlerPtr );
   protected:

               /// Supports chaining of responsibility

               HandlerPtr  theSuccessor;

               /// Supports chaining of responsibility where

               HandlerPtr  thePredecessor;

   private:

   };
}
#endif   // if !defined(__HANDLER_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/27 14:32:21 $
   $Locker:  $
*/



